// services/viz/public/mojom/compositing/frame_timing_details.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/frame_timing_details.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var begin_frame_args$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/begin_frame_args.mojom', 'begin_frame_args.mojom.js');
  }
  var presentation_feedback$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/presentation_feedback.mojom', '../../../../../ui/gfx/mojom/presentation_feedback.mojom.js');
  }
  var swap_timings$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/swap_timings.mojom', '../../../../../ui/gfx/mojom/swap_timings.mojom.js');
  }



  function FrameTimingDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameTimingDetails.prototype.initDefaults_ = function() {
    this.receivedCompositorFrameTimestamp = null;
    this.embeddedFrameTimestamp = null;
    this.drawStartTimestamp = null;
    this.swapTimings = null;
    this.presentationFeedback = null;
    this.frameId = null;
    this.startUpdateDisplayTree = null;
    this.startPrepareToDraw = null;
    this.startDrawLayers = null;
    this.submitCompositorFrame = null;
  };
  FrameTimingDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameTimingDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.receivedCompositorFrameTimestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.embeddedFrameTimestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.drawStartTimestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.swapTimings
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, swap_timings$.SwapTimings, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.presentationFeedback
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, presentation_feedback$.PresentationFeedback, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.frameId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, begin_frame_args$.BeginFrameId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.startUpdateDisplayTree
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.startPrepareToDraw
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.startDrawLayers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameTimingDetails.submitCompositorFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameTimingDetails.encodedSize = codec.kStructHeaderSize + 80;

  FrameTimingDetails.decode = function(decoder) {
    var packed;
    var val = new FrameTimingDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receivedCompositorFrameTimestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.embeddedFrameTimestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.drawStartTimestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.swapTimings =
        decoder.decodeStructPointer(swap_timings$.SwapTimings);
    val.presentationFeedback =
        decoder.decodeStructPointer(presentation_feedback$.PresentationFeedback);
    val.frameId =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameId);
    val.startUpdateDisplayTree =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.startPrepareToDraw =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.startDrawLayers =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.submitCompositorFrame =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  FrameTimingDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameTimingDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.receivedCompositorFrameTimestamp);
    encoder.encodeStructPointer(time$.TimeTicks, val.embeddedFrameTimestamp);
    encoder.encodeStructPointer(time$.TimeTicks, val.drawStartTimestamp);
    encoder.encodeStructPointer(swap_timings$.SwapTimings, val.swapTimings);
    encoder.encodeStructPointer(presentation_feedback$.PresentationFeedback, val.presentationFeedback);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameId, val.frameId);
    encoder.encodeStructPointer(time$.TimeTicks, val.startUpdateDisplayTree);
    encoder.encodeStructPointer(time$.TimeTicks, val.startPrepareToDraw);
    encoder.encodeStructPointer(time$.TimeTicks, val.startDrawLayers);
    encoder.encodeStructPointer(time$.TimeTicks, val.submitCompositorFrame);
  };
  exports.FrameTimingDetails = FrameTimingDetails;
})();