// services/viz/public/mojom/compositing/trees_in_viz_timing.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/trees_in_viz_timing.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }



  function TreesInVizTiming(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TreesInVizTiming.prototype.initDefaults_ = function() {
    this.startUpdateDisplayTree = null;
    this.startPrepareToDraw = null;
    this.startDrawLayers = null;
    this.submitCompositorFrame = null;
  };
  TreesInVizTiming.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TreesInVizTiming.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TreesInVizTiming.startUpdateDisplayTree
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TreesInVizTiming.startPrepareToDraw
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TreesInVizTiming.startDrawLayers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TreesInVizTiming.submitCompositorFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TreesInVizTiming.encodedSize = codec.kStructHeaderSize + 32;

  TreesInVizTiming.decode = function(decoder) {
    var packed;
    var val = new TreesInVizTiming();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startUpdateDisplayTree =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.startPrepareToDraw =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.startDrawLayers =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.submitCompositorFrame =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  TreesInVizTiming.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TreesInVizTiming.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.startUpdateDisplayTree);
    encoder.encodeStructPointer(time$.TimeTicks, val.startPrepareToDraw);
    encoder.encodeStructPointer(time$.TimeTicks, val.startDrawLayers);
    encoder.encodeStructPointer(time$.TimeTicks, val.submitCompositorFrame);
  };
  exports.TreesInVizTiming = TreesInVizTiming;
})();