// third_party/blink/public/mojom/ai/ai_summarizer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_summarizer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }
  var model_streaming_responder$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_streaming_responder.mojom', 'model_streaming_responder.mojom.js');
  }


  var AISummarizerType = {};
  AISummarizerType.kTLDR = 0;
  AISummarizerType.kKeyPoints = 1;
  AISummarizerType.kTeaser = 2;
  AISummarizerType.kHeadline = 3;
  AISummarizerType.MIN_VALUE = 0;
  AISummarizerType.MAX_VALUE = 3;

  AISummarizerType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AISummarizerType.toKnownEnumValue = function(value) {
    return value;
  };

  AISummarizerType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AISummarizerFormat = {};
  AISummarizerFormat.kPlainText = 0;
  AISummarizerFormat.kMarkDown = 1;
  AISummarizerFormat.MIN_VALUE = 0;
  AISummarizerFormat.MAX_VALUE = 1;

  AISummarizerFormat.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AISummarizerFormat.toKnownEnumValue = function(value) {
    return value;
  };

  AISummarizerFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AISummarizerLength = {};
  AISummarizerLength.kShort = 0;
  AISummarizerLength.kMedium = 1;
  AISummarizerLength.kLong = 2;
  AISummarizerLength.MIN_VALUE = 0;
  AISummarizerLength.MAX_VALUE = 2;

  AISummarizerLength.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AISummarizerLength.toKnownEnumValue = function(value) {
    return value;
  };

  AISummarizerLength.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AISummarizerCreateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AISummarizerCreateOptions.prototype.initDefaults_ = function() {
    this.sharedContext = null;
    this.type = 0;
    this.format = 0;
    this.length = 0;
    this.expectedInputLanguages = null;
    this.expectedContextLanguages = null;
    this.outputLanguage = null;
  };
  AISummarizerCreateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AISummarizerCreateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.sharedContext
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AISummarizerType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.format
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AISummarizerFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.length
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, AISummarizerLength);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.expectedInputLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.expectedContextLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizerCreateOptions.outputLanguage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, ai_common$.AILanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AISummarizerCreateOptions.encodedSize = codec.kStructHeaderSize + 48;

  AISummarizerCreateOptions.decode = function(decoder) {
    var packed;
    var val = new AISummarizerCreateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sharedContext =
        decoder.decodeStruct(codec.String);
    val.type =
        decoder.decodeStruct(new codec.Enum(AISummarizerType));
    val.format =
        decoder.decodeStruct(new codec.Enum(AISummarizerFormat));
    val.length =
        decoder.decodeStruct(new codec.Enum(AISummarizerLength));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.expectedInputLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    val.expectedContextLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    val.outputLanguage =
        decoder.decodeStructPointer(ai_common$.AILanguageCode);
    return val;
  };

  AISummarizerCreateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AISummarizerCreateOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sharedContext);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.format);
    encoder.encodeStruct(codec.Int32, val.length);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedInputLanguages);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedContextLanguages);
    encoder.encodeStructPointer(ai_common$.AILanguageCode, val.outputLanguage);
  };
  function AISummarizer_Summarize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AISummarizer_Summarize_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.context = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AISummarizer_Summarize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AISummarizer_Summarize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizer_Summarize_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizer_Summarize_Params.context
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizer_Summarize_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AISummarizer_Summarize_Params.encodedSize = codec.kStructHeaderSize + 24;

  AISummarizer_Summarize_Params.decode = function(decoder) {
    var packed;
    var val = new AISummarizer_Summarize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.context =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AISummarizer_Summarize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AISummarizer_Summarize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.context);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  function AISummarizer_MeasureUsage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AISummarizer_MeasureUsage_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.context = null;
  };
  AISummarizer_MeasureUsage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AISummarizer_MeasureUsage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizer_MeasureUsage_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AISummarizer_MeasureUsage_Params.context
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AISummarizer_MeasureUsage_Params.encodedSize = codec.kStructHeaderSize + 16;

  AISummarizer_MeasureUsage_Params.decode = function(decoder) {
    var packed;
    var val = new AISummarizer_MeasureUsage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.context =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AISummarizer_MeasureUsage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AISummarizer_MeasureUsage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.context);
  };
  function AISummarizer_MeasureUsage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AISummarizer_MeasureUsage_ResponseParams.prototype.initDefaults_ = function() {
    this.number_of_tokens_$flag = false;
    this.number_of_tokens_$value = 0;
  };
  AISummarizer_MeasureUsage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AISummarizer_MeasureUsage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AISummarizer_MeasureUsage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AISummarizer_MeasureUsage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AISummarizer_MeasureUsage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.number_of_tokens_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.number_of_tokens_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AISummarizer_MeasureUsage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AISummarizer_MeasureUsage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.number_of_tokens_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.number_of_tokens_$value);
  };
  var kAISummarizer_Summarize_Name = 0;
  var kAISummarizer_MeasureUsage_Name = 1;

  function AISummarizerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AISummarizer,
                                                   handleOrPtrInfo);
  }

  function AISummarizerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AISummarizer, associatedInterfacePtrInfo);
  }

  AISummarizerAssociatedPtr.prototype =
      Object.create(AISummarizerPtr.prototype);
  AISummarizerAssociatedPtr.prototype.constructor =
      AISummarizerAssociatedPtr;

  function AISummarizerProxy(receiver) {
    this.receiver_ = receiver;
  }
  AISummarizerPtr.prototype.summarize = function() {
    return AISummarizerProxy.prototype.summarize
        .apply(this.ptr.getProxy(), arguments);
  };

  AISummarizerProxy.prototype.summarize = function(input, context, pendingResponder) {
    var params_ = new AISummarizer_Summarize_Params();
    params_.input = input;
    params_.context = context;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kAISummarizer_Summarize_Name,
        codec.align(AISummarizer_Summarize_Params.encodedSize));
    builder.encodeStruct(AISummarizer_Summarize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AISummarizerPtr.prototype.measureUsage = function() {
    return AISummarizerProxy.prototype.measureUsage
        .apply(this.ptr.getProxy(), arguments);
  };

  AISummarizerProxy.prototype.measureUsage = function(input, context) {
    var params_ = new AISummarizer_MeasureUsage_Params();
    params_.input = input;
    params_.context = context;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAISummarizer_MeasureUsage_Name,
          codec.align(AISummarizer_MeasureUsage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AISummarizer_MeasureUsage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AISummarizer_MeasureUsage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AISummarizerStub(delegate) {
    this.delegate_ = delegate;
  }
  AISummarizerStub.prototype.summarize = function(input, context, pendingResponder) {
    return this.delegate_ && this.delegate_.summarize && this.delegate_.summarize(input, context, pendingResponder);
  }
  AISummarizerStub.prototype.measureUsage = function(input, context) {
    return this.delegate_ && this.delegate_.measureUsage && this.delegate_.measureUsage(input, context);
  }

  AISummarizerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAISummarizer_Summarize_Name:
      var params = reader.decodeStruct(AISummarizer_Summarize_Params);
      this.summarize(params.input, params.context, params.pendingResponder);
      return true;
    default:
      return false;
    }
  };

  AISummarizerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAISummarizer_MeasureUsage_Name:
      var params = reader.decodeStruct(AISummarizer_MeasureUsage_Params);
      this.measureUsage(params.input, params.context).then(function(response) {
        var responseParams =
            new AISummarizer_MeasureUsage_ResponseParams();
        responseParams.numberOfTokens = response.numberOfTokens;
        var builder = new codec.MessageV1Builder(
            kAISummarizer_MeasureUsage_Name,
            codec.align(AISummarizer_MeasureUsage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AISummarizer_MeasureUsage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAISummarizerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAISummarizer_Summarize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AISummarizer_Summarize_Params;
      break;
      case kAISummarizer_MeasureUsage_Name:
        if (message.expectsResponse())
          paramsClass = AISummarizer_MeasureUsage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAISummarizerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAISummarizer_MeasureUsage_Name:
        if (message.isResponse())
          paramsClass = AISummarizer_MeasureUsage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AISummarizer = {
    name: 'blink.mojom.AISummarizer',
    kVersion: 0,
    ptrClass: AISummarizerPtr,
    proxyClass: AISummarizerProxy,
    stubClass: AISummarizerStub,
    validateRequest: validateAISummarizerRequest,
    validateResponse: validateAISummarizerResponse,
  };
  AISummarizerStub.prototype.validator = validateAISummarizerRequest;
  AISummarizerProxy.prototype.validator = validateAISummarizerResponse;
  exports.AISummarizerType = AISummarizerType;
  exports.AISummarizerFormat = AISummarizerFormat;
  exports.AISummarizerLength = AISummarizerLength;
  exports.AISummarizerCreateOptions = AISummarizerCreateOptions;
  exports.AISummarizer = AISummarizer;
  exports.AISummarizerPtr = AISummarizerPtr;
  exports.AISummarizerAssociatedPtr = AISummarizerAssociatedPtr;
})();