// third_party/blink/public/mojom/ai/model_streaming_responder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  QuotaErrorInfo as blink_mojom_QuotaErrorInfo,
  QuotaErrorInfoSpec as blink_mojom_QuotaErrorInfoSpec
} from './ai_common.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ModelStreamingResponseStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ModelStreamingResponseStatus = {
  
  kOngoing: 0,
  kComplete: 1,
  kErrorUnknown: 2,
  kErrorInvalidRequest: 3,
  kErrorRequestThrottled: 4,
  kErrorPermissionDenied: 5,
  kErrorGenericFailure: 6,
  kErrorRetryableError: 7,
  kErrorNonRetryableError: 8,
  kErrorUnsupportedLanguage: 9,
  kErrorFiltered: 10,
  kErrorDisabled: 11,
  kErrorCancelled: 12,
  kErrorSessionDestroyed: 13,
  kErrorInputTooLarge: 14,
  kErrorResponseLowQuality: 15,
  MIN_VALUE: 0,
  MAX_VALUE: 15,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ModelStreamingResponderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ModelStreamingResponder', scope);
  }
}

/** @interface */
export class ModelStreamingResponderInterface {
  
  /**
   * @param { ?ModelExecutionContextInfo } contextInfo
   */

  onCompletion(contextInfo) {}
  
  /**
   * @param { !ModelStreamingResponseStatus } status
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(status, quotaErrorInfo) {}
  
  /**
   * @param { !string } text
   */

  onStreaming(text) {}
  
  /**
   */

  onQuotaOverflow() {}
}

/**
 * @implements { ModelStreamingResponderInterface }
 */
export class ModelStreamingResponderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ModelStreamingResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ModelStreamingResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ModelStreamingResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?ModelExecutionContextInfo } contextInfo
   */

  onCompletion(
      contextInfo) {
    this.proxy.sendMessage(
        0,
        ModelStreamingResponder_OnCompletion_ParamsSpec.$,
        null,
        [
          contextInfo
        ],
        false);
  }

  
  /**
   * @param { !ModelStreamingResponseStatus } status
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      status,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        ModelStreamingResponder_OnError_ParamsSpec.$,
        null,
        [
          status,
          quotaErrorInfo
        ],
        false);
  }

  
  /**
   * @param { !string } text
   */

  onStreaming(
      text) {
    this.proxy.sendMessage(
        2,
        ModelStreamingResponder_OnStreaming_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   */

  onQuotaOverflow() {
    this.proxy.sendMessage(
        3,
        ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ModelStreamingResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ModelStreamingResponderReceiver {
  /**
   * @param {!ModelStreamingResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ModelStreamingResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ModelStreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ModelStreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ModelStreamingResponder_OnCompletion_ParamsSpec.$,
        null,
        impl.onCompletion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ModelStreamingResponder_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ModelStreamingResponder_OnStreaming_ParamsSpec.$,
        null,
        impl.onStreaming.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
        null,
        impl.onQuotaOverflow.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ModelStreamingResponder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ModelStreamingResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ModelStreamingResponderRemote}
   */
  static getRemote() {
    let remote = new ModelStreamingResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ModelStreamingResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ModelStreamingResponderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ModelStreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ModelStreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompletion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ModelStreamingResponder_OnCompletion_ParamsSpec.$,
        null,
        this.onCompletion.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ModelStreamingResponder_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ModelStreamingResponder_OnStreaming_ParamsSpec.$,
        null,
        this.onStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onQuotaOverflow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
        null,
        this.onQuotaOverflow.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelExecutionContextInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelStreamingResponder_OnCompletion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelStreamingResponder_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelStreamingResponder_OnStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelStreamingResponder_OnQuotaOverflow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ModelExecutionContextInfoSpec.$,
    'ModelExecutionContextInfo',
    [
      mojo.internal.StructField(
        'currentTokens', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ModelExecutionContextInfo {
  constructor() {
    /** @type { !bigint } */
    this.currentTokens;
  }
}



mojo.internal.Struct(
    ModelStreamingResponder_OnCompletion_ParamsSpec.$,
    'ModelStreamingResponder_OnCompletion_Params',
    [
      mojo.internal.StructField(
        'contextInfo', 0,
        0,
        ModelExecutionContextInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ModelStreamingResponder_OnCompletion_Params {
  constructor() {
    /** @type { (ModelExecutionContextInfo|undefined) } */
    this.contextInfo;
  }
}



mojo.internal.Struct(
    ModelStreamingResponder_OnError_ParamsSpec.$,
    'ModelStreamingResponder_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ModelStreamingResponseStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink_mojom_QuotaErrorInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ModelStreamingResponder_OnError_Params {
  constructor() {
    /** @type { !ModelStreamingResponseStatus } */
    this.status;
    /** @type { (blink_mojom_QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
}



mojo.internal.Struct(
    ModelStreamingResponder_OnStreaming_ParamsSpec.$,
    'ModelStreamingResponder_OnStreaming_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ModelStreamingResponder_OnStreaming_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
    'ModelStreamingResponder_OnQuotaOverflow_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ModelStreamingResponder_OnQuotaOverflow_Params {
  constructor() {
  }
}

