// third_party/blink/public/mojom/annotation/annotation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  LinkGenerationError as blink_mojom_LinkGenerationError,
  LinkGenerationErrorSpec as blink_mojom_LinkGenerationErrorSpec,
  LinkGenerationReadyStatus as blink_mojom_LinkGenerationReadyStatus,
  LinkGenerationReadyStatusSpec as blink_mojom_LinkGenerationReadyStatusSpec
} from '../link_to_text/link_to_text.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AnnotationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AnnotationType = {
  
  kSharedHighlight: 0,
  kUserNote: 1,
  kTextFinder: 2,
  kGlic: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AttachmentResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AttachmentResult = {
  
  kSuccess: 0,
  kSelectorNotMatched: 1,
  kRangeInvalid: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AnnotationAgentPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AnnotationAgent', scope);
  }
}

/** @interface */
export class AnnotationAgentInterface {
  
  /**
   * @param { !boolean } appliesFocus
   */

  scrollIntoView(appliesFocus) {}
}

/**
 * @implements { AnnotationAgentInterface }
 */
export class AnnotationAgentRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AnnotationAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AnnotationAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AnnotationAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } appliesFocus
   */

  scrollIntoView(
      appliesFocus) {
    this.proxy.sendMessage(
        0,
        AnnotationAgent_ScrollIntoView_ParamsSpec.$,
        null,
        [
          appliesFocus
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AnnotationAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AnnotationAgentReceiver {
  /**
   * @param {!AnnotationAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AnnotationAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AnnotationAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnnotationAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AnnotationAgent_ScrollIntoView_ParamsSpec.$,
        null,
        impl.scrollIntoView.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AnnotationAgent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnnotationAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AnnotationAgentRemote}
   */
  static getRemote() {
    let remote = new AnnotationAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AnnotationAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AnnotationAgentCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AnnotationAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnnotationAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollIntoView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AnnotationAgent_ScrollIntoView_ParamsSpec.$,
        null,
        this.scrollIntoView.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AnnotationAgentHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AnnotationAgentHost', scope);
  }
}

/** @interface */
export class AnnotationAgentHostInterface {
  
  /**
   * @param { !gfx_mojom_Rect } documentRelativeRect
   * @param { !AttachmentResult } attachmentResult
   */

  didFinishAttachment(documentRelativeRect, attachmentResult) {}
}

/**
 * @implements { AnnotationAgentHostInterface }
 */
export class AnnotationAgentHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AnnotationAgentHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AnnotationAgentHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AnnotationAgentHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx_mojom_Rect } documentRelativeRect
   * @param { !AttachmentResult } attachmentResult
   */

  didFinishAttachment(
      documentRelativeRect,
      attachmentResult) {
    this.proxy.sendMessage(
        0,
        AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
        null,
        [
          documentRelativeRect,
          attachmentResult
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AnnotationAgentHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AnnotationAgentHostReceiver {
  /**
   * @param {!AnnotationAgentHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AnnotationAgentHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AnnotationAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnnotationAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
        null,
        impl.didFinishAttachment.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AnnotationAgentHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnnotationAgentHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AnnotationAgentHostRemote}
   */
  static getRemote() {
    let remote = new AnnotationAgentHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AnnotationAgentHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AnnotationAgentHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AnnotationAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnnotationAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFinishAttachment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
        null,
        this.didFinishAttachment.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AnnotationAgentContainerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AnnotationAgentContainer', scope);
  }
}

/** @interface */
export class AnnotationAgentContainerInterface {
  
  /**
   * @param { !AnnotationAgentHostRemote } hostRemote
   * @param { !AnnotationAgentPendingReceiver } agentReceiver
   * @param { !AnnotationType } type
   * @param { !Selector } selector
   * @param { ?number } searchRangeStartNodeId
   */

  createAgent(hostRemote, agentReceiver, type, selector, searchRangeStartNodeId) {}
  
  /**
   * @param { !AnnotationType } type
   * @return {!Promise<{
        result: ?SelectorCreationResult,
        error: !blink_mojom_LinkGenerationError,
        readyStatus: !blink_mojom_LinkGenerationReadyStatus,
   *  }>}
   */

  createAgentFromSelection(type) {}
  
  /**
   * @param { !AnnotationType } type
   */

  removeAgentsOfType(type) {}
}

/**
 * @implements { AnnotationAgentContainerInterface }
 */
export class AnnotationAgentContainerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AnnotationAgentContainerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AnnotationAgentContainerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AnnotationAgentContainerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AnnotationAgentHostRemote } hostRemote
   * @param { !AnnotationAgentPendingReceiver } agentReceiver
   * @param { !AnnotationType } type
   * @param { !Selector } selector
   * @param { ?number } searchRangeStartNodeId
   */

  createAgent(
      hostRemote,
      agentReceiver,
      type,
      selector,
      searchRangeStartNodeId) {
    this.proxy.sendMessage(
        0,
        AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
        null,
        [
          hostRemote,
          agentReceiver,
          type,
          selector,
          searchRangeStartNodeId
        ],
        false);
  }

  
  /**
   * @param { !AnnotationType } type
   * @return {!Promise<{
        result: ?SelectorCreationResult,
        error: !blink_mojom_LinkGenerationError,
        readyStatus: !blink_mojom_LinkGenerationReadyStatus,
   *  }>}
   */

  createAgentFromSelection(
      type) {
    return this.proxy.sendMessage(
        1,
        AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
        AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !AnnotationType } type
   */

  removeAgentsOfType(
      type) {
    this.proxy.sendMessage(
        2,
        AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AnnotationAgentContainer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AnnotationAgentContainerReceiver {
  /**
   * @param {!AnnotationAgentContainerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AnnotationAgentContainerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AnnotationAgentContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnnotationAgentContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
        null,
        impl.createAgent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
        AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
        impl.createAgentFromSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
        null,
        impl.removeAgentsOfType.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AnnotationAgentContainer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnnotationAgentContainer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AnnotationAgentContainerRemote}
   */
  static getRemote() {
    let remote = new AnnotationAgentContainerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AnnotationAgentContainer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AnnotationAgentContainerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AnnotationAgentContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnnotationAgentContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAgent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
        null,
        this.createAgent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAgentFromSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
        AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
        this.createAgentFromSelection.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeAgentsOfType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
        null,
        this.removeAgentsOfType.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SelectorCreationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnnotationAgent_ScrollIntoView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnnotationAgentHost_DidFinishAttachment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnnotationAgentContainer_CreateAgent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SelectorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SelectorCreationResultSpec.$,
    'SelectorCreationResult',
    [
      mojo.internal.StructField(
        'hostReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(AnnotationAgentHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'agentRemote', 4,
        0,
        mojo.internal.InterfaceProxy(AnnotationAgentRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializedSelector', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectedText', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class SelectorCreationResult {
  constructor() {
    /** @type { !AnnotationAgentHostPendingReceiver } */
    this.hostReceiver;
    /** @type { !AnnotationAgentRemote } */
    this.agentRemote;
    /** @type { !string } */
    this.serializedSelector;
    /** @type { !mojoBase_mojom_String16 } */
    this.selectedText;
  }
}



mojo.internal.Struct(
    AnnotationAgent_ScrollIntoView_ParamsSpec.$,
    'AnnotationAgent_ScrollIntoView_Params',
    [
      mojo.internal.StructField(
        'appliesFocus', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnnotationAgent_ScrollIntoView_Params {
  constructor() {
    /** @type { !boolean } */
    this.appliesFocus;
  }
}



mojo.internal.Struct(
    AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
    'AnnotationAgentHost_DidFinishAttachment_Params',
    [
      mojo.internal.StructField(
        'documentRelativeRect', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attachmentResult', 8,
        0,
        AttachmentResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnnotationAgentHost_DidFinishAttachment_Params {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.documentRelativeRect;
    /** @type { !AttachmentResult } */
    this.attachmentResult;
  }
}



mojo.internal.Struct(
    AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
    'AnnotationAgentContainer_CreateAgent_Params',
    [
      mojo.internal.StructField(
        'hostRemote', 0,
        0,
        mojo.internal.InterfaceProxy(AnnotationAgentHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'agentReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(AnnotationAgentPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 12,
        0,
        AnnotationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selector', 16,
        0,
        SelectorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'search_range_start_node_id_$flag', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "search_range_start_node_id_$value",
          originalFieldName: "searchRangeStartNodeId",
        }
      ),
      mojo.internal.StructField(
        'search_range_start_node_id_$value', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "searchRangeStartNodeId",
        }
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class AnnotationAgentContainer_CreateAgent_Params {
  constructor() {
    /** @type { !AnnotationAgentHostRemote } */
    this.hostRemote;
    /** @type { !AnnotationAgentPendingReceiver } */
    this.agentReceiver;
    /** @type { !AnnotationType } */
    this.type;
    /** @type { !Selector } */
    this.selector;
    /** @type { (number|undefined) } */
    this.searchRangeStartNodeId;
  }
}



mojo.internal.Struct(
    AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
    'AnnotationAgentContainer_CreateAgentFromSelection_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        AnnotationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnnotationAgentContainer_CreateAgentFromSelection_Params {
  constructor() {
    /** @type { !AnnotationType } */
    this.type;
  }
}



mojo.internal.Struct(
    AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
    'AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SelectorCreationResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink_mojom_LinkGenerationErrorSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readyStatus', 12,
        0,
        blink_mojom_LinkGenerationReadyStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams {
  constructor() {
    /** @type { (SelectorCreationResult|undefined) } */
    this.result;
    /** @type { !blink_mojom_LinkGenerationError } */
    this.error;
    /** @type { !blink_mojom_LinkGenerationReadyStatus } */
    this.readyStatus;
  }
}



mojo.internal.Struct(
    AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
    'AnnotationAgentContainer_RemoveAgentsOfType_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        AnnotationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnnotationAgentContainer_RemoveAgentsOfType_Params {
  constructor() {
    /** @type { !AnnotationType } */
    this.type;
  }
}

mojo.internal.Union(
    SelectorSpec.$, 'Selector',
    {
      'serializedSelector': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'nodeId': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
    });

/**
 * @typedef { {
 *   serializedSelector: (!string|undefined),
 *   nodeId: (!number|undefined),
 * } }
 */
export const Selector = {};
