// third_party/blink/public/mojom/background_fetch/background_fetch.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  CacheQueryOptions as blink_mojom_CacheQueryOptions,
  CacheQueryOptionsSpec as blink_mojom_CacheQueryOptionsSpec
} from '../cache_storage/cache_storage.mojom.m.js';

import {
  FetchAPIRequest as blink_mojom_FetchAPIRequest,
  FetchAPIRequestSpec as blink_mojom_FetchAPIRequestSpec
} from '../fetch/fetch_api_request.mojom.m.js';

import {
  FetchAPIResponse as blink_mojom_FetchAPIResponse,
  FetchAPIResponseSpec as blink_mojom_FetchAPIResponseSpec
} from '../fetch/fetch_api_response.mojom.m.js';

import {
  ManifestImageResource as blink_mojom_ManifestImageResource,
  ManifestImageResourceSpec as blink_mojom_ManifestImageResourceSpec
} from '../manifest/manifest.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundFetchErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundFetchError = {
  
  NONE: 0,
  DUPLICATED_DEVELOPER_ID: 1,
  INVALID_ARGUMENT: 2,
  INVALID_ID: 3,
  STORAGE_ERROR: 4,
  SERVICE_WORKER_UNAVAILABLE: 5,
  QUOTA_EXCEEDED: 6,
  PERMISSION_DENIED: 7,
  REGISTRATION_LIMIT_EXCEEDED: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundFetchResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundFetchResult = {
  
  UNSET: 0,
  FAILURE: 1,
  SUCCESS: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundFetchFailureReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundFetchFailureReason = {
  
  NONE: 0,
  CANCELLED_FROM_UI: 1,
  CANCELLED_BY_DEVELOPER: 2,
  BAD_STATUS: 3,
  FETCH_ERROR: 4,
  SERVICE_WORKER_UNAVAILABLE: 5,
  QUOTA_EXCEEDED: 6,
  DOWNLOAD_TOTAL_EXCEEDED: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BackgroundFetchRegistrationObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BackgroundFetchRegistrationObserver', scope);
  }
}

/** @interface */
export class BackgroundFetchRegistrationObserverInterface {
  
  /**
   * @param { !bigint } uploadTotal
   * @param { !bigint } uploaded
   * @param { !bigint } downloadTotal
   * @param { !bigint } downloaded
   * @param { !BackgroundFetchResult } result
   * @param { !BackgroundFetchFailureReason } failureReason
   */

  onProgress(uploadTotal, uploaded, downloadTotal, downloaded, result, failureReason) {}
  
  /**
   */

  onRecordsUnavailable() {}
  
  /**
   * @param { !blink_mojom_FetchAPIRequest } request
   * @param { ?blink_mojom_FetchAPIResponse } response
   */

  onRequestCompleted(request, response) {}
}

/**
 * @implements { BackgroundFetchRegistrationObserverInterface }
 */
export class BackgroundFetchRegistrationObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BackgroundFetchRegistrationObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BackgroundFetchRegistrationObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BackgroundFetchRegistrationObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } uploadTotal
   * @param { !bigint } uploaded
   * @param { !bigint } downloadTotal
   * @param { !bigint } downloaded
   * @param { !BackgroundFetchResult } result
   * @param { !BackgroundFetchFailureReason } failureReason
   */

  onProgress(
      uploadTotal,
      uploaded,
      downloadTotal,
      downloaded,
      result,
      failureReason) {
    this.proxy.sendMessage(
        0,
        BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
        null,
        [
          uploadTotal,
          uploaded,
          downloadTotal,
          downloaded,
          result,
          failureReason
        ],
        false);
  }

  
  /**
   */

  onRecordsUnavailable() {
    this.proxy.sendMessage(
        1,
        BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FetchAPIRequest } request
   * @param { ?blink_mojom_FetchAPIResponse } response
   */

  onRequestCompleted(
      request,
      response) {
    this.proxy.sendMessage(
        2,
        BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
        null,
        [
          request,
          response
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BackgroundFetchRegistrationObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BackgroundFetchRegistrationObserverReceiver {
  /**
   * @param {!BackgroundFetchRegistrationObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BackgroundFetchRegistrationObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BackgroundFetchRegistrationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackgroundFetchRegistrationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
        null,
        impl.onProgress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
        null,
        impl.onRecordsUnavailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
        null,
        impl.onRequestCompleted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BackgroundFetchRegistrationObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackgroundFetchRegistrationObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BackgroundFetchRegistrationObserverRemote}
   */
  static getRemote() {
    let remote = new BackgroundFetchRegistrationObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BackgroundFetchRegistrationObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BackgroundFetchRegistrationObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BackgroundFetchRegistrationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackgroundFetchRegistrationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
        null,
        this.onProgress.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRecordsUnavailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
        null,
        this.onRecordsUnavailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
        null,
        this.onRequestCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BackgroundFetchServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BackgroundFetchService', scope);
  }
}

/** @interface */
export class BackgroundFetchServiceInterface {
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } developerId
   * @param { !Array<!blink_mojom_FetchAPIRequest> } requests
   * @param { !BackgroundFetchOptions } options
   * @param { ?skia_mojom_BitmapN32 } icon
   * @param { !BackgroundFetchUkmData } ukmData
   * @return {!Promise<{
        error: !BackgroundFetchError,
        registration: ?BackgroundFetchRegistration,
   *  }>}
   */

  fetch(serviceWorkerRegistrationId, developerId, requests, options, icon, ukmData) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } developerId
   * @return {!Promise<{
        error: !BackgroundFetchError,
        registration: ?BackgroundFetchRegistration,
   *  }>}
   */

  getRegistration(serviceWorkerRegistrationId, developerId) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !BackgroundFetchError,
        developerIds: !Array<!string>,
   *  }>}
   */

  getDeveloperIds(serviceWorkerRegistrationId) {}
  
  /**
   * @return {!Promise<{
        iconSizePixels: !gfx_mojom_Size,
   *  }>}
   */

  getIconDisplaySize() {}
}

/**
 * @implements { BackgroundFetchServiceInterface }
 */
export class BackgroundFetchServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BackgroundFetchServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BackgroundFetchServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BackgroundFetchServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } developerId
   * @param { !Array<!blink_mojom_FetchAPIRequest> } requests
   * @param { !BackgroundFetchOptions } options
   * @param { ?skia_mojom_BitmapN32 } icon
   * @param { !BackgroundFetchUkmData } ukmData
   * @return {!Promise<{
        error: !BackgroundFetchError,
        registration: ?BackgroundFetchRegistration,
   *  }>}
   */

  fetch(
      serviceWorkerRegistrationId,
      developerId,
      requests,
      options,
      icon,
      ukmData) {
    return this.proxy.sendMessage(
        0,
        BackgroundFetchService_Fetch_ParamsSpec.$,
        BackgroundFetchService_Fetch_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          developerId,
          requests,
          options,
          icon,
          ukmData
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } developerId
   * @return {!Promise<{
        error: !BackgroundFetchError,
        registration: ?BackgroundFetchRegistration,
   *  }>}
   */

  getRegistration(
      serviceWorkerRegistrationId,
      developerId) {
    return this.proxy.sendMessage(
        1,
        BackgroundFetchService_GetRegistration_ParamsSpec.$,
        BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          developerId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !BackgroundFetchError,
        developerIds: !Array<!string>,
   *  }>}
   */

  getDeveloperIds(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
        BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        iconSizePixels: !gfx_mojom_Size,
   *  }>}
   */

  getIconDisplaySize() {
    return this.proxy.sendMessage(
        3,
        BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
        BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BackgroundFetchService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BackgroundFetchServiceReceiver {
  /**
   * @param {!BackgroundFetchServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BackgroundFetchServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BackgroundFetchServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackgroundFetchServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BackgroundFetchService_Fetch_ParamsSpec.$,
        BackgroundFetchService_Fetch_ResponseParamsSpec.$,
        impl.fetch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BackgroundFetchService_GetRegistration_ParamsSpec.$,
        BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
        impl.getRegistration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
        BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
        impl.getDeveloperIds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
        BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
        impl.getIconDisplaySize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BackgroundFetchService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackgroundFetchService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BackgroundFetchServiceRemote}
   */
  static getRemote() {
    let remote = new BackgroundFetchServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BackgroundFetchService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BackgroundFetchServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BackgroundFetchServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackgroundFetchServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BackgroundFetchService_Fetch_ParamsSpec.$,
        BackgroundFetchService_Fetch_ResponseParamsSpec.$,
        this.fetch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BackgroundFetchService_GetRegistration_ParamsSpec.$,
        BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
        this.getRegistration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeveloperIds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
        BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
        this.getDeveloperIds.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIconDisplaySize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
        BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
        this.getIconDisplaySize.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BackgroundFetchRegistrationServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BackgroundFetchRegistrationService', scope);
  }
}

/** @interface */
export class BackgroundFetchRegistrationServiceInterface {
  
  /**
   * @param { ?string } title
   * @param { ?skia_mojom_BitmapN32 } icon
   * @return {!Promise<{
        error: !BackgroundFetchError,
   *  }>}
   */

  updateUI(title, icon) {}
  
  /**
   * @return {!Promise<{
        error: !BackgroundFetchError,
   *  }>}
   */

  abort() {}
  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } requestToMatch
   * @param { ?blink_mojom_CacheQueryOptions } cacheQueryOptions
   * @param { !boolean } matchAll
   * @return {!Promise<{
        fetches: !Array<!BackgroundFetchSettledFetch>,
   *  }>}
   */

  matchRequests(requestToMatch, cacheQueryOptions, matchAll) {}
  
  /**
   * @param { !BackgroundFetchRegistrationObserverRemote } observer
   */

  addRegistrationObserver(observer) {}
}

/**
 * @implements { BackgroundFetchRegistrationServiceInterface }
 */
export class BackgroundFetchRegistrationServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BackgroundFetchRegistrationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BackgroundFetchRegistrationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BackgroundFetchRegistrationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?string } title
   * @param { ?skia_mojom_BitmapN32 } icon
   * @return {!Promise<{
        error: !BackgroundFetchError,
   *  }>}
   */

  updateUI(
      title,
      icon) {
    return this.proxy.sendMessage(
        0,
        BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
        BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
        [
          title,
          icon
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !BackgroundFetchError,
   *  }>}
   */

  abort() {
    return this.proxy.sendMessage(
        1,
        BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
        BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } requestToMatch
   * @param { ?blink_mojom_CacheQueryOptions } cacheQueryOptions
   * @param { !boolean } matchAll
   * @return {!Promise<{
        fetches: !Array<!BackgroundFetchSettledFetch>,
   *  }>}
   */

  matchRequests(
      requestToMatch,
      cacheQueryOptions,
      matchAll) {
    return this.proxy.sendMessage(
        2,
        BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
        BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
        [
          requestToMatch,
          cacheQueryOptions,
          matchAll
        ],
        false);
  }

  
  /**
   * @param { !BackgroundFetchRegistrationObserverRemote } observer
   */

  addRegistrationObserver(
      observer) {
    this.proxy.sendMessage(
        3,
        BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BackgroundFetchRegistrationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BackgroundFetchRegistrationServiceReceiver {
  /**
   * @param {!BackgroundFetchRegistrationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BackgroundFetchRegistrationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BackgroundFetchRegistrationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackgroundFetchRegistrationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
        BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
        impl.updateUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
        BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
        BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
        impl.matchRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
        null,
        impl.addRegistrationObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BackgroundFetchRegistrationService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackgroundFetchRegistrationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BackgroundFetchRegistrationServiceRemote}
   */
  static getRemote() {
    let remote = new BackgroundFetchRegistrationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BackgroundFetchRegistrationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BackgroundFetchRegistrationServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BackgroundFetchRegistrationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackgroundFetchRegistrationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
        BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
        this.updateUI.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
        BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
        this.abort.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.matchRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
        BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
        this.matchRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addRegistrationObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
        null,
        this.addRegistrationObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchSettledFetchSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchUkmDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_Fetch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_Fetch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_GetRegistration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_GetRegistration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_GetDeveloperIds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_GetIconDisplaySize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_UpdateUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_Abort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_MatchRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BackgroundFetchSettledFetchSpec.$,
    'BackgroundFetchSettledFetch',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchSettledFetch {
  constructor() {
    /** @type { !blink_mojom_FetchAPIRequest } */
    this.request;
    /** @type { (blink_mojom_FetchAPIResponse|undefined) } */
    this.response;
  }
}



mojo.internal.Struct(
    BackgroundFetchOptionsSpec.$,
    'BackgroundFetchOptions',
    [
      mojo.internal.StructField(
        'icons', 0,
        0,
        mojo.internal.Array(blink_mojom_ManifestImageResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloadTotal', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BackgroundFetchOptions {
  constructor() {
    /** @type { !Array<!blink_mojom_ManifestImageResource> } */
    this.icons;
    /** @type { !bigint } */
    this.downloadTotal;
    /** @type { !string } */
    this.title;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationDataSpec.$,
    'BackgroundFetchRegistrationData',
    [
      mojo.internal.StructField(
        'developerId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploadTotal', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploaded', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloadTotal', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloaded', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 40,
        0,
        BackgroundFetchResultSpec.$,
        BackgroundFetchResult.UNSET,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'failureReason', 44,
        0,
        BackgroundFetchFailureReasonSpec.$,
        BackgroundFetchFailureReason.NONE,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationData {
  constructor() {
    /** @type { !string } */
    this.developerId;
    /** @type { !bigint } */
    this.uploadTotal;
    /** @type { !bigint } */
    this.uploaded;
    /** @type { !bigint } */
    this.downloadTotal;
    /** @type { !bigint } */
    this.downloaded;
    /** @type { !BackgroundFetchResult } */
    this.result;
    /** @type { !BackgroundFetchFailureReason } */
    this.failureReason;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationSpec.$,
    'BackgroundFetchRegistration',
    [
      mojo.internal.StructField(
        'registrationData', 0,
        0,
        BackgroundFetchRegistrationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registrationInterface', 8,
        0,
        mojo.internal.InterfaceProxy(BackgroundFetchRegistrationServiceRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchRegistration {
  constructor() {
    /** @type { !BackgroundFetchRegistrationData } */
    this.registrationData;
    /** @type { !BackgroundFetchRegistrationServiceRemote } */
    this.registrationInterface;
  }
}



mojo.internal.Struct(
    BackgroundFetchUkmDataSpec.$,
    'BackgroundFetchUkmData',
    [
      mojo.internal.StructField(
        'idealToChosenIconSize', 0,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchUkmData {
  constructor() {
    /** @type { !bigint } */
    this.idealToChosenIconSize;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
    'BackgroundFetchRegistrationObserver_OnProgress_Params',
    [
      mojo.internal.StructField(
        'uploadTotal', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploaded', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloadTotal', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloaded', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 32,
        0,
        BackgroundFetchResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'failureReason', 36,
        0,
        BackgroundFetchFailureReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationObserver_OnProgress_Params {
  constructor() {
    /** @type { !bigint } */
    this.uploadTotal;
    /** @type { !bigint } */
    this.uploaded;
    /** @type { !bigint } */
    this.downloadTotal;
    /** @type { !bigint } */
    this.downloaded;
    /** @type { !BackgroundFetchResult } */
    this.result;
    /** @type { !BackgroundFetchFailureReason } */
    this.failureReason;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
    'BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
    'BackgroundFetchRegistrationObserver_OnRequestCompleted_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationObserver_OnRequestCompleted_Params {
  constructor() {
    /** @type { !blink_mojom_FetchAPIRequest } */
    this.request;
    /** @type { (blink_mojom_FetchAPIResponse|undefined) } */
    this.response;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_Fetch_ParamsSpec.$,
    'BackgroundFetchService_Fetch_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'developerId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requests', 16,
        0,
        mojo.internal.Array(blink_mojom_FetchAPIRequestSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        BackgroundFetchOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 32,
        0,
        skia_mojom_BitmapN32Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ukmData', 40,
        0,
        BackgroundFetchUkmDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class BackgroundFetchService_Fetch_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !string } */
    this.developerId;
    /** @type { !Array<!blink_mojom_FetchAPIRequest> } */
    this.requests;
    /** @type { !BackgroundFetchOptions } */
    this.options;
    /** @type { (skia_mojom_BitmapN32|undefined) } */
    this.icon;
    /** @type { !BackgroundFetchUkmData } */
    this.ukmData;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_Fetch_ResponseParamsSpec.$,
    'BackgroundFetchService_Fetch_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        BackgroundFetchErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registration', 8,
        0,
        BackgroundFetchRegistrationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchService_Fetch_ResponseParams {
  constructor() {
    /** @type { !BackgroundFetchError } */
    this.error;
    /** @type { (BackgroundFetchRegistration|undefined) } */
    this.registration;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_GetRegistration_ParamsSpec.$,
    'BackgroundFetchService_GetRegistration_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'developerId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchService_GetRegistration_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !string } */
    this.developerId;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
    'BackgroundFetchService_GetRegistration_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        BackgroundFetchErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registration', 8,
        0,
        BackgroundFetchRegistrationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchService_GetRegistration_ResponseParams {
  constructor() {
    /** @type { !BackgroundFetchError } */
    this.error;
    /** @type { (BackgroundFetchRegistration|undefined) } */
    this.registration;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
    'BackgroundFetchService_GetDeveloperIds_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchService_GetDeveloperIds_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
    'BackgroundFetchService_GetDeveloperIds_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        BackgroundFetchErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'developerIds', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchService_GetDeveloperIds_ResponseParams {
  constructor() {
    /** @type { !BackgroundFetchError } */
    this.error;
    /** @type { !Array<!string> } */
    this.developerIds;
  }
}



mojo.internal.Struct(
    BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
    'BackgroundFetchService_GetIconDisplaySize_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BackgroundFetchService_GetIconDisplaySize_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
    'BackgroundFetchService_GetIconDisplaySize_ResponseParams',
    [
      mojo.internal.StructField(
        'iconSizePixels', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchService_GetIconDisplaySize_ResponseParams {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.iconSizePixels;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
    'BackgroundFetchRegistrationService_UpdateUI_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 8,
        0,
        skia_mojom_BitmapN32Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_UpdateUI_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.title;
    /** @type { (skia_mojom_BitmapN32|undefined) } */
    this.icon;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
    'BackgroundFetchRegistrationService_UpdateUI_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        BackgroundFetchErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_UpdateUI_ResponseParams {
  constructor() {
    /** @type { !BackgroundFetchError } */
    this.error;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
    'BackgroundFetchRegistrationService_Abort_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_Abort_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
    'BackgroundFetchRegistrationService_Abort_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        BackgroundFetchErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_Abort_ResponseParams {
  constructor() {
    /** @type { !BackgroundFetchError } */
    this.error;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
    'BackgroundFetchRegistrationService_MatchRequests_Params',
    [
      mojo.internal.StructField(
        'requestToMatch', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheQueryOptions', 8,
        0,
        blink_mojom_CacheQueryOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchAll', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_MatchRequests_Params {
  constructor() {
    /** @type { (blink_mojom_FetchAPIRequest|undefined) } */
    this.requestToMatch;
    /** @type { (blink_mojom_CacheQueryOptions|undefined) } */
    this.cacheQueryOptions;
    /** @type { !boolean } */
    this.matchAll;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
    'BackgroundFetchRegistrationService_MatchRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'fetches', 0,
        0,
        mojo.internal.Array(BackgroundFetchSettledFetchSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_MatchRequests_ResponseParams {
  constructor() {
    /** @type { !Array<!BackgroundFetchSettledFetch> } */
    this.fetches;
  }
}



mojo.internal.Struct(
    BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
    'BackgroundFetchRegistrationService_AddRegistrationObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(BackgroundFetchRegistrationObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackgroundFetchRegistrationService_AddRegistrationObserver_Params {
  constructor() {
    /** @type { !BackgroundFetchRegistrationObserverRemote } */
    this.observer;
  }
}

