// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.BucketErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.BucketError = {
  
  kUnknown: 0,
  kQuotaExceeded: 1,
  kInvalidExpiration: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BucketHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BucketHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.BucketHostInterface }
 */
blink.mojom.BucketHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BucketHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BucketHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BucketHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        persisted: !boolean,
        success: !boolean,
   *  }>}
   */

  persist() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.BucketHost_Persist_ParamsSpec.$,
        blink.mojom.BucketHost_Persist_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        persisted: !boolean,
        success: !boolean,
   *  }>}
   */

  persisted() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.BucketHost_Persisted_ParamsSpec.$,
        blink.mojom.BucketHost_Persisted_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        currentUsage: !bigint,
        currentQuota: !bigint,
        success: !boolean,
   *  }>}
   */

  estimate() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.BucketHost_Estimate_ParamsSpec.$,
        blink.mojom.BucketHost_Estimate_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        durability: !blink.mojom.BucketDurability,
        success: !boolean,
   *  }>}
   */

  durability() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.BucketHost_Durability_ParamsSpec.$,
        blink.mojom.BucketHost_Durability_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } expires
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setExpires(
      expires) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.BucketHost_SetExpires_ParamsSpec.$,
        blink.mojom.BucketHost_SetExpires_ResponseParamsSpec.$,
        [
          expires
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        expires: ?mojoBase.mojom.Time,
        success: !boolean,
   *  }>}
   */

  expires() {
    return this.proxy.sendMessage(
        5,
        blink.mojom.BucketHost_Expires_ParamsSpec.$,
        blink.mojom.BucketHost_Expires_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IDBFactoryPendingReceiver } idbFactory
   */

  getIdbFactory(
      idbFactory) {
    this.proxy.sendMessage(
        6,
        blink.mojom.BucketHost_GetIdbFactory_ParamsSpec.$,
        null,
        [
          idbFactory
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.LockManagerPendingReceiver } lockManager
   */

  getLockManager(
      lockManager) {
    this.proxy.sendMessage(
        7,
        blink.mojom.BucketHost_GetLockManager_ParamsSpec.$,
        null,
        [
          lockManager
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CacheStoragePendingReceiver } cacheStorage
   */

  getCaches(
      cacheStorage) {
    this.proxy.sendMessage(
        8,
        blink.mojom.BucketHost_GetCaches_ParamsSpec.$,
        null,
        [
          cacheStorage
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {
    return this.proxy.sendMessage(
        9,
        blink.mojom.BucketHost_GetDirectory_ParamsSpec.$,
        blink.mojom.BucketHost_GetDirectory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectoryForDevtools(
      directoryPathComponents) {
    return this.proxy.sendMessage(
        10,
        blink.mojom.BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
        blink.mojom.BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
        [
          directoryPathComponents
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BucketHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BucketHostReceiver = class {
  /**
   * @param {!blink.mojom.BucketHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BucketHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BucketHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BucketHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BucketHost_Persist_ParamsSpec.$,
        blink.mojom.BucketHost_Persist_ResponseParamsSpec.$,
        impl.persist.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BucketHost_Persisted_ParamsSpec.$,
        blink.mojom.BucketHost_Persisted_ResponseParamsSpec.$,
        impl.persisted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BucketHost_Estimate_ParamsSpec.$,
        blink.mojom.BucketHost_Estimate_ResponseParamsSpec.$,
        impl.estimate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BucketHost_Durability_ParamsSpec.$,
        blink.mojom.BucketHost_Durability_ResponseParamsSpec.$,
        impl.durability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.BucketHost_SetExpires_ParamsSpec.$,
        blink.mojom.BucketHost_SetExpires_ResponseParamsSpec.$,
        impl.setExpires.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.BucketHost_Expires_ParamsSpec.$,
        blink.mojom.BucketHost_Expires_ResponseParamsSpec.$,
        impl.expires.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.BucketHost_GetIdbFactory_ParamsSpec.$,
        null,
        impl.getIdbFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.BucketHost_GetLockManager_ParamsSpec.$,
        null,
        impl.getLockManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.BucketHost_GetCaches_ParamsSpec.$,
        null,
        impl.getCaches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.BucketHost_GetDirectory_ParamsSpec.$,
        blink.mojom.BucketHost_GetDirectory_ResponseParamsSpec.$,
        impl.getDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
        blink.mojom.BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
        impl.getDirectoryForDevtools.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BucketHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BucketHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BucketHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BucketHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BucketHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BucketHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BucketHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BucketHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.persist =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BucketHost_Persist_ParamsSpec.$,
        blink.mojom.BucketHost_Persist_ResponseParamsSpec.$,
        this.persist.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.persisted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BucketHost_Persisted_ParamsSpec.$,
        blink.mojom.BucketHost_Persisted_ResponseParamsSpec.$,
        this.persisted.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.estimate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BucketHost_Estimate_ParamsSpec.$,
        blink.mojom.BucketHost_Estimate_ResponseParamsSpec.$,
        this.estimate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.durability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BucketHost_Durability_ParamsSpec.$,
        blink.mojom.BucketHost_Durability_ResponseParamsSpec.$,
        this.durability.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setExpires =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.BucketHost_SetExpires_ParamsSpec.$,
        blink.mojom.BucketHost_SetExpires_ResponseParamsSpec.$,
        this.setExpires.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.expires =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.BucketHost_Expires_ParamsSpec.$,
        blink.mojom.BucketHost_Expires_ResponseParamsSpec.$,
        this.expires.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIdbFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.BucketHost_GetIdbFactory_ParamsSpec.$,
        null,
        this.getIdbFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLockManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.BucketHost_GetLockManager_ParamsSpec.$,
        null,
        this.getLockManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCaches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.BucketHost_GetCaches_ParamsSpec.$,
        null,
        this.getCaches.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.BucketHost_GetDirectory_ParamsSpec.$,
        blink.mojom.BucketHost_GetDirectory_ResponseParamsSpec.$,
        this.getDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectoryForDevtools =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
        blink.mojom.BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
        this.getDirectoryForDevtools.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BucketManagerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BucketManagerHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.BucketManagerHostInterface }
 */
blink.mojom.BucketManagerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BucketManagerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BucketManagerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BucketManagerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !blink.mojom.BucketPolicies } policy
   * @return {!Promise<{
        remote: ?blink.mojom.BucketHostRemote,
        error: !blink.mojom.BucketError,
   *  }>}
   */

  openBucket(
      name,
      policy) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.BucketManagerHost_OpenBucket_ParamsSpec.$,
        blink.mojom.BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
        [
          name,
          policy
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink.mojom.BucketHostPendingReceiver } receiver
   */

  getBucketForDevtools(
      name,
      receiver) {
    this.proxy.sendMessage(
        1,
        blink.mojom.BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
        null,
        [
          name,
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        buckets: !Array<!string>,
        success: !boolean,
   *  }>}
   */

  keys() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.BucketManagerHost_Keys_ParamsSpec.$,
        blink.mojom.BucketManagerHost_Keys_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteBucket(
      name) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.BucketManagerHost_DeleteBucket_ParamsSpec.$,
        blink.mojom.BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BucketManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BucketManagerHostReceiver = class {
  /**
   * @param {!blink.mojom.BucketManagerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BucketManagerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BucketManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BucketManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BucketManagerHost_OpenBucket_ParamsSpec.$,
        blink.mojom.BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
        impl.openBucket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
        null,
        impl.getBucketForDevtools.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BucketManagerHost_Keys_ParamsSpec.$,
        blink.mojom.BucketManagerHost_Keys_ResponseParamsSpec.$,
        impl.keys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BucketManagerHost_DeleteBucket_ParamsSpec.$,
        blink.mojom.BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
        impl.deleteBucket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BucketManagerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BucketManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BucketManagerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BucketManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BucketManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BucketManagerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BucketManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BucketManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openBucket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BucketManagerHost_OpenBucket_ParamsSpec.$,
        blink.mojom.BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
        this.openBucket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBucketForDevtools =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
        null,
        this.getBucketForDevtools.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BucketManagerHost_Keys_ParamsSpec.$,
        blink.mojom.BucketManagerHost_Keys_ResponseParamsSpec.$,
        this.keys.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteBucket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BucketManagerHost_DeleteBucket_ParamsSpec.$,
        blink.mojom.BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
        this.deleteBucket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketPoliciesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Persist_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Persist_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Persisted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Persisted_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Estimate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Estimate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Durability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Durability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_SetExpires_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_SetExpires_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Expires_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_Expires_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetIdbFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetLockManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetCaches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetDirectoryForDevtools_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketHost_GetDirectoryForDevtools_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_OpenBucket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_OpenBucket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_GetBucketForDevtools_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_Keys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_Keys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_DeleteBucket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BucketManagerHost_DeleteBucket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.BucketPoliciesSpec.$,
    'BucketPolicies',
    [
      mojo.internal.StructField(
        'persisted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasPersisted', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'durability', 4,
        0,
        blink.mojom.BucketDurabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasDurability', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quota', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasQuota', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expires', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.BucketPolicies = class {
  constructor() {
    /** @export { !boolean } */
    this.persisted;
    /** @export { !boolean } */
    this.hasPersisted;
    /** @export { !blink.mojom.BucketDurability } */
    this.durability;
    /** @export { !boolean } */
    this.hasDurability;
    /** @export { !bigint } */
    this.quota;
    /** @export { !boolean } */
    this.hasQuota;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.expires;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Persist_ParamsSpec.$,
    'BucketHost_Persist_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketHost_Persist_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Persist_ResponseParamsSpec.$,
    'BucketHost_Persist_ResponseParams',
    [
      mojo.internal.StructField(
        'persisted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_Persist_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.persisted;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Persisted_ParamsSpec.$,
    'BucketHost_Persisted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketHost_Persisted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Persisted_ResponseParamsSpec.$,
    'BucketHost_Persisted_ResponseParams',
    [
      mojo.internal.StructField(
        'persisted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_Persisted_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.persisted;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Estimate_ParamsSpec.$,
    'BucketHost_Estimate_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketHost_Estimate_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Estimate_ResponseParamsSpec.$,
    'BucketHost_Estimate_ResponseParams',
    [
      mojo.internal.StructField(
        'currentUsage', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentQuota', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.BucketHost_Estimate_ResponseParams = class {
  constructor() {
    /** @export { !bigint } */
    this.currentUsage;
    /** @export { !bigint } */
    this.currentQuota;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Durability_ParamsSpec.$,
    'BucketHost_Durability_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketHost_Durability_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Durability_ResponseParamsSpec.$,
    'BucketHost_Durability_ResponseParams',
    [
      mojo.internal.StructField(
        'durability', 0,
        0,
        blink.mojom.BucketDurabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_Durability_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BucketDurability } */
    this.durability;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_SetExpires_ParamsSpec.$,
    'BucketHost_SetExpires_Params',
    [
      mojo.internal.StructField(
        'expires', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_SetExpires_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.expires;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_SetExpires_ResponseParamsSpec.$,
    'BucketHost_SetExpires_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_SetExpires_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Expires_ParamsSpec.$,
    'BucketHost_Expires_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketHost_Expires_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_Expires_ResponseParamsSpec.$,
    'BucketHost_Expires_ResponseParams',
    [
      mojo.internal.StructField(
        'expires', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketHost_Expires_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.expires;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetIdbFactory_ParamsSpec.$,
    'BucketHost_GetIdbFactory_Params',
    [
      mojo.internal.StructField(
        'idbFactory', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.IDBFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_GetIdbFactory_Params = class {
  constructor() {
    /** @export { !blink.mojom.IDBFactoryPendingReceiver } */
    this.idbFactory;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetLockManager_ParamsSpec.$,
    'BucketHost_GetLockManager_Params',
    [
      mojo.internal.StructField(
        'lockManager', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.LockManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_GetLockManager_Params = class {
  constructor() {
    /** @export { !blink.mojom.LockManagerPendingReceiver } */
    this.lockManager;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetCaches_ParamsSpec.$,
    'BucketHost_GetCaches_Params',
    [
      mojo.internal.StructField(
        'cacheStorage', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.CacheStoragePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_GetCaches_Params = class {
  constructor() {
    /** @export { !blink.mojom.CacheStoragePendingReceiver } */
    this.cacheStorage;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetDirectory_ParamsSpec.$,
    'BucketHost_GetDirectory_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketHost_GetDirectory_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetDirectory_ResponseParamsSpec.$,
    'BucketHost_GetDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketHost_GetDirectory_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
    'BucketHost_GetDirectoryForDevtools_Params',
    [
      mojo.internal.StructField(
        'directoryPathComponents', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketHost_GetDirectoryForDevtools_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.directoryPathComponents;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
    'BucketHost_GetDirectoryForDevtools_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketHost_GetDirectoryForDevtools_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_OpenBucket_ParamsSpec.$,
    'BucketManagerHost_OpenBucket_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policy', 8,
        0,
        blink.mojom.BucketPoliciesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketManagerHost_OpenBucket_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !blink.mojom.BucketPolicies } */
    this.policy;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
    'BucketManagerHost_OpenBucket_ResponseParams',
    [
      mojo.internal.StructField(
        'remote', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BucketHostRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.BucketErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketManagerHost_OpenBucket_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.BucketHostRemote|undefined) } */
    this.remote;
    /** @export { !blink.mojom.BucketError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
    'BucketManagerHost_GetBucketForDevtools_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.BucketHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketManagerHost_GetBucketForDevtools_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !blink.mojom.BucketHostPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_Keys_ParamsSpec.$,
    'BucketManagerHost_Keys_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BucketManagerHost_Keys_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_Keys_ResponseParamsSpec.$,
    'BucketManagerHost_Keys_ResponseParams',
    [
      mojo.internal.StructField(
        'buckets', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BucketManagerHost_Keys_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.buckets;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_DeleteBucket_ParamsSpec.$,
    'BucketManagerHost_DeleteBucket_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketManagerHost_DeleteBucket_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    blink.mojom.BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
    'BucketManagerHost_DeleteBucket_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BucketManagerHost_DeleteBucket_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};

