// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  CacheStorageRemote as blink_mojom_CacheStorageRemote,
  CacheStoragePendingReceiver as blink_mojom_CacheStoragePendingReceiver
} from '../cache_storage/cache_storage.mojom.m.js';

import {
  FileSystemAccessDirectoryHandleRemote as blink_mojom_FileSystemAccessDirectoryHandleRemote,
  FileSystemAccessDirectoryHandlePendingReceiver as blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver
} from '../file_system_access/file_system_access_directory_handle.mojom.m.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from '../file_system_access/file_system_access_error.mojom.m.js';

import {
  IDBFactoryRemote as blink_mojom_IDBFactoryRemote,
  IDBFactoryPendingReceiver as blink_mojom_IDBFactoryPendingReceiver
} from '../indexeddb/indexeddb.mojom.m.js';

import {
  LockManagerRemote as blink_mojom_LockManagerRemote,
  LockManagerPendingReceiver as blink_mojom_LockManagerPendingReceiver
} from '../locks/lock_manager.mojom.m.js';

import {
  BucketDurability as blink_mojom_BucketDurability,
  BucketDurabilitySpec as blink_mojom_BucketDurabilitySpec
} from '../quota/quota_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BucketErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BucketError = {
  
  kUnknown: 0,
  kQuotaExceeded: 1,
  kInvalidExpiration: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BucketHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BucketHost', scope);
  }
}

/** @interface */
export class BucketHostInterface {
  
  /**
   * @return {!Promise<{
        persisted: !boolean,
        success: !boolean,
   *  }>}
   */

  persist() {}
  
  /**
   * @return {!Promise<{
        persisted: !boolean,
        success: !boolean,
   *  }>}
   */

  persisted() {}
  
  /**
   * @return {!Promise<{
        currentUsage: !bigint,
        currentQuota: !bigint,
        success: !boolean,
   *  }>}
   */

  estimate() {}
  
  /**
   * @return {!Promise<{
        durability: !blink_mojom_BucketDurability,
        success: !boolean,
   *  }>}
   */

  durability() {}
  
  /**
   * @param { !mojoBase_mojom_Time } expires
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setExpires(expires) {}
  
  /**
   * @return {!Promise<{
        expires: ?mojoBase_mojom_Time,
        success: !boolean,
   *  }>}
   */

  expires() {}
  
  /**
   * @param { !blink_mojom_IDBFactoryPendingReceiver } idbFactory
   */

  getIdbFactory(idbFactory) {}
  
  /**
   * @param { !blink_mojom_LockManagerPendingReceiver } lockManager
   */

  getLockManager(lockManager) {}
  
  /**
   * @param { !blink_mojom_CacheStoragePendingReceiver } cacheStorage
   */

  getCaches(cacheStorage) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {}
  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectoryForDevtools(directoryPathComponents) {}
}

/**
 * @implements { BucketHostInterface }
 */
export class BucketHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BucketHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BucketHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BucketHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        persisted: !boolean,
        success: !boolean,
   *  }>}
   */

  persist() {
    return this.proxy.sendMessage(
        0,
        BucketHost_Persist_ParamsSpec.$,
        BucketHost_Persist_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        persisted: !boolean,
        success: !boolean,
   *  }>}
   */

  persisted() {
    return this.proxy.sendMessage(
        1,
        BucketHost_Persisted_ParamsSpec.$,
        BucketHost_Persisted_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        currentUsage: !bigint,
        currentQuota: !bigint,
        success: !boolean,
   *  }>}
   */

  estimate() {
    return this.proxy.sendMessage(
        2,
        BucketHost_Estimate_ParamsSpec.$,
        BucketHost_Estimate_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        durability: !blink_mojom_BucketDurability,
        success: !boolean,
   *  }>}
   */

  durability() {
    return this.proxy.sendMessage(
        3,
        BucketHost_Durability_ParamsSpec.$,
        BucketHost_Durability_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } expires
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setExpires(
      expires) {
    return this.proxy.sendMessage(
        4,
        BucketHost_SetExpires_ParamsSpec.$,
        BucketHost_SetExpires_ResponseParamsSpec.$,
        [
          expires
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        expires: ?mojoBase_mojom_Time,
        success: !boolean,
   *  }>}
   */

  expires() {
    return this.proxy.sendMessage(
        5,
        BucketHost_Expires_ParamsSpec.$,
        BucketHost_Expires_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_IDBFactoryPendingReceiver } idbFactory
   */

  getIdbFactory(
      idbFactory) {
    this.proxy.sendMessage(
        6,
        BucketHost_GetIdbFactory_ParamsSpec.$,
        null,
        [
          idbFactory
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_LockManagerPendingReceiver } lockManager
   */

  getLockManager(
      lockManager) {
    this.proxy.sendMessage(
        7,
        BucketHost_GetLockManager_ParamsSpec.$,
        null,
        [
          lockManager
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_CacheStoragePendingReceiver } cacheStorage
   */

  getCaches(
      cacheStorage) {
    this.proxy.sendMessage(
        8,
        BucketHost_GetCaches_ParamsSpec.$,
        null,
        [
          cacheStorage
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {
    return this.proxy.sendMessage(
        9,
        BucketHost_GetDirectory_ParamsSpec.$,
        BucketHost_GetDirectory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectoryForDevtools(
      directoryPathComponents) {
    return this.proxy.sendMessage(
        10,
        BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
        BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
        [
          directoryPathComponents
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BucketHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BucketHostReceiver {
  /**
   * @param {!BucketHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BucketHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BucketHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BucketHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BucketHost_Persist_ParamsSpec.$,
        BucketHost_Persist_ResponseParamsSpec.$,
        impl.persist.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BucketHost_Persisted_ParamsSpec.$,
        BucketHost_Persisted_ResponseParamsSpec.$,
        impl.persisted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BucketHost_Estimate_ParamsSpec.$,
        BucketHost_Estimate_ResponseParamsSpec.$,
        impl.estimate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BucketHost_Durability_ParamsSpec.$,
        BucketHost_Durability_ResponseParamsSpec.$,
        impl.durability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        BucketHost_SetExpires_ParamsSpec.$,
        BucketHost_SetExpires_ResponseParamsSpec.$,
        impl.setExpires.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        BucketHost_Expires_ParamsSpec.$,
        BucketHost_Expires_ResponseParamsSpec.$,
        impl.expires.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        BucketHost_GetIdbFactory_ParamsSpec.$,
        null,
        impl.getIdbFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        BucketHost_GetLockManager_ParamsSpec.$,
        null,
        impl.getLockManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        BucketHost_GetCaches_ParamsSpec.$,
        null,
        impl.getCaches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        BucketHost_GetDirectory_ParamsSpec.$,
        BucketHost_GetDirectory_ResponseParamsSpec.$,
        impl.getDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
        BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
        impl.getDirectoryForDevtools.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BucketHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BucketHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BucketHostRemote}
   */
  static getRemote() {
    let remote = new BucketHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BucketHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BucketHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BucketHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BucketHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.persist =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BucketHost_Persist_ParamsSpec.$,
        BucketHost_Persist_ResponseParamsSpec.$,
        this.persist.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.persisted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BucketHost_Persisted_ParamsSpec.$,
        BucketHost_Persisted_ResponseParamsSpec.$,
        this.persisted.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.estimate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BucketHost_Estimate_ParamsSpec.$,
        BucketHost_Estimate_ResponseParamsSpec.$,
        this.estimate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.durability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BucketHost_Durability_ParamsSpec.$,
        BucketHost_Durability_ResponseParamsSpec.$,
        this.durability.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setExpires =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        BucketHost_SetExpires_ParamsSpec.$,
        BucketHost_SetExpires_ResponseParamsSpec.$,
        this.setExpires.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.expires =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        BucketHost_Expires_ParamsSpec.$,
        BucketHost_Expires_ResponseParamsSpec.$,
        this.expires.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIdbFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        BucketHost_GetIdbFactory_ParamsSpec.$,
        null,
        this.getIdbFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLockManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        BucketHost_GetLockManager_ParamsSpec.$,
        null,
        this.getLockManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCaches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        BucketHost_GetCaches_ParamsSpec.$,
        null,
        this.getCaches.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        BucketHost_GetDirectory_ParamsSpec.$,
        BucketHost_GetDirectory_ResponseParamsSpec.$,
        this.getDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectoryForDevtools =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
        BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
        this.getDirectoryForDevtools.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BucketManagerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BucketManagerHost', scope);
  }
}

/** @interface */
export class BucketManagerHostInterface {
  
  /**
   * @param { !string } name
   * @param { !BucketPolicies } policy
   * @return {!Promise<{
        remote: ?BucketHostRemote,
        error: !BucketError,
   *  }>}
   */

  openBucket(name, policy) {}
  
  /**
   * @param { !string } name
   * @param { !BucketHostPendingReceiver } receiver
   */

  getBucketForDevtools(name, receiver) {}
  
  /**
   * @return {!Promise<{
        buckets: !Array<!string>,
        success: !boolean,
   *  }>}
   */

  keys() {}
  
  /**
   * @param { !string } name
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteBucket(name) {}
}

/**
 * @implements { BucketManagerHostInterface }
 */
export class BucketManagerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BucketManagerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BucketManagerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BucketManagerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !BucketPolicies } policy
   * @return {!Promise<{
        remote: ?BucketHostRemote,
        error: !BucketError,
   *  }>}
   */

  openBucket(
      name,
      policy) {
    return this.proxy.sendMessage(
        0,
        BucketManagerHost_OpenBucket_ParamsSpec.$,
        BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
        [
          name,
          policy
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !BucketHostPendingReceiver } receiver
   */

  getBucketForDevtools(
      name,
      receiver) {
    this.proxy.sendMessage(
        1,
        BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
        null,
        [
          name,
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        buckets: !Array<!string>,
        success: !boolean,
   *  }>}
   */

  keys() {
    return this.proxy.sendMessage(
        2,
        BucketManagerHost_Keys_ParamsSpec.$,
        BucketManagerHost_Keys_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteBucket(
      name) {
    return this.proxy.sendMessage(
        3,
        BucketManagerHost_DeleteBucket_ParamsSpec.$,
        BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BucketManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BucketManagerHostReceiver {
  /**
   * @param {!BucketManagerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BucketManagerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BucketManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BucketManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BucketManagerHost_OpenBucket_ParamsSpec.$,
        BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
        impl.openBucket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
        null,
        impl.getBucketForDevtools.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BucketManagerHost_Keys_ParamsSpec.$,
        BucketManagerHost_Keys_ResponseParamsSpec.$,
        impl.keys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BucketManagerHost_DeleteBucket_ParamsSpec.$,
        BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
        impl.deleteBucket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BucketManagerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BucketManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BucketManagerHostRemote}
   */
  static getRemote() {
    let remote = new BucketManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BucketManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BucketManagerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BucketManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BucketManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openBucket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BucketManagerHost_OpenBucket_ParamsSpec.$,
        BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
        this.openBucket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBucketForDevtools =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
        null,
        this.getBucketForDevtools.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BucketManagerHost_Keys_ParamsSpec.$,
        BucketManagerHost_Keys_ResponseParamsSpec.$,
        this.keys.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteBucket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BucketManagerHost_DeleteBucket_ParamsSpec.$,
        BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
        this.deleteBucket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketPoliciesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Persist_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Persist_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Persisted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Persisted_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Estimate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Estimate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Durability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Durability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_SetExpires_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_SetExpires_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Expires_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_Expires_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetIdbFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetLockManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetCaches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetDirectoryForDevtools_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketHost_GetDirectoryForDevtools_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_OpenBucket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_OpenBucket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_GetBucketForDevtools_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_Keys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_Keys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_DeleteBucket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketManagerHost_DeleteBucket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BucketPoliciesSpec.$,
    'BucketPolicies',
    [
      mojo.internal.StructField(
        'persisted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasPersisted', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'durability', 4,
        0,
        blink_mojom_BucketDurabilitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDurability', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quota', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasQuota', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expires', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BucketPolicies {
  constructor() {
    /** @type { !boolean } */
    this.persisted;
    /** @type { !boolean } */
    this.hasPersisted;
    /** @type { !blink_mojom_BucketDurability } */
    this.durability;
    /** @type { !boolean } */
    this.hasDurability;
    /** @type { !bigint } */
    this.quota;
    /** @type { !boolean } */
    this.hasQuota;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.expires;
  }
}



mojo.internal.Struct(
    BucketHost_Persist_ParamsSpec.$,
    'BucketHost_Persist_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketHost_Persist_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketHost_Persist_ResponseParamsSpec.$,
    'BucketHost_Persist_ResponseParams',
    [
      mojo.internal.StructField(
        'persisted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_Persist_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.persisted;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketHost_Persisted_ParamsSpec.$,
    'BucketHost_Persisted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketHost_Persisted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketHost_Persisted_ResponseParamsSpec.$,
    'BucketHost_Persisted_ResponseParams',
    [
      mojo.internal.StructField(
        'persisted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_Persisted_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.persisted;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketHost_Estimate_ParamsSpec.$,
    'BucketHost_Estimate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketHost_Estimate_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketHost_Estimate_ResponseParamsSpec.$,
    'BucketHost_Estimate_ResponseParams',
    [
      mojo.internal.StructField(
        'currentUsage', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentQuota', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BucketHost_Estimate_ResponseParams {
  constructor() {
    /** @type { !bigint } */
    this.currentUsage;
    /** @type { !bigint } */
    this.currentQuota;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketHost_Durability_ParamsSpec.$,
    'BucketHost_Durability_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketHost_Durability_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketHost_Durability_ResponseParamsSpec.$,
    'BucketHost_Durability_ResponseParams',
    [
      mojo.internal.StructField(
        'durability', 0,
        0,
        blink_mojom_BucketDurabilitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_Durability_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_BucketDurability } */
    this.durability;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketHost_SetExpires_ParamsSpec.$,
    'BucketHost_SetExpires_Params',
    [
      mojo.internal.StructField(
        'expires', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_SetExpires_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.expires;
  }
}



mojo.internal.Struct(
    BucketHost_SetExpires_ResponseParamsSpec.$,
    'BucketHost_SetExpires_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_SetExpires_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketHost_Expires_ParamsSpec.$,
    'BucketHost_Expires_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketHost_Expires_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketHost_Expires_ResponseParamsSpec.$,
    'BucketHost_Expires_ResponseParams',
    [
      mojo.internal.StructField(
        'expires', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketHost_Expires_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.expires;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketHost_GetIdbFactory_ParamsSpec.$,
    'BucketHost_GetIdbFactory_Params',
    [
      mojo.internal.StructField(
        'idbFactory', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_IDBFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_GetIdbFactory_Params {
  constructor() {
    /** @type { !blink_mojom_IDBFactoryPendingReceiver } */
    this.idbFactory;
  }
}



mojo.internal.Struct(
    BucketHost_GetLockManager_ParamsSpec.$,
    'BucketHost_GetLockManager_Params',
    [
      mojo.internal.StructField(
        'lockManager', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_LockManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_GetLockManager_Params {
  constructor() {
    /** @type { !blink_mojom_LockManagerPendingReceiver } */
    this.lockManager;
  }
}



mojo.internal.Struct(
    BucketHost_GetCaches_ParamsSpec.$,
    'BucketHost_GetCaches_Params',
    [
      mojo.internal.StructField(
        'cacheStorage', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_CacheStoragePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_GetCaches_Params {
  constructor() {
    /** @type { !blink_mojom_CacheStoragePendingReceiver } */
    this.cacheStorage;
  }
}



mojo.internal.Struct(
    BucketHost_GetDirectory_ParamsSpec.$,
    'BucketHost_GetDirectory_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketHost_GetDirectory_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketHost_GetDirectory_ResponseParamsSpec.$,
    'BucketHost_GetDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessDirectoryHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketHost_GetDirectory_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
}



mojo.internal.Struct(
    BucketHost_GetDirectoryForDevtools_ParamsSpec.$,
    'BucketHost_GetDirectoryForDevtools_Params',
    [
      mojo.internal.StructField(
        'directoryPathComponents', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketHost_GetDirectoryForDevtools_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.directoryPathComponents;
  }
}



mojo.internal.Struct(
    BucketHost_GetDirectoryForDevtools_ResponseParamsSpec.$,
    'BucketHost_GetDirectoryForDevtools_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessDirectoryHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketHost_GetDirectoryForDevtools_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
}



mojo.internal.Struct(
    BucketManagerHost_OpenBucket_ParamsSpec.$,
    'BucketManagerHost_OpenBucket_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policy', 8,
        0,
        BucketPoliciesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketManagerHost_OpenBucket_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !BucketPolicies } */
    this.policy;
  }
}



mojo.internal.Struct(
    BucketManagerHost_OpenBucket_ResponseParamsSpec.$,
    'BucketManagerHost_OpenBucket_ResponseParams',
    [
      mojo.internal.StructField(
        'remote', 0,
        0,
        mojo.internal.InterfaceProxy(BucketHostRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        BucketErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketManagerHost_OpenBucket_ResponseParams {
  constructor() {
    /** @type { (BucketHostRemote|undefined) } */
    this.remote;
    /** @type { !BucketError } */
    this.error;
  }
}



mojo.internal.Struct(
    BucketManagerHost_GetBucketForDevtools_ParamsSpec.$,
    'BucketManagerHost_GetBucketForDevtools_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(BucketHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketManagerHost_GetBucketForDevtools_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !BucketHostPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    BucketManagerHost_Keys_ParamsSpec.$,
    'BucketManagerHost_Keys_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BucketManagerHost_Keys_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BucketManagerHost_Keys_ResponseParamsSpec.$,
    'BucketManagerHost_Keys_ResponseParams',
    [
      mojo.internal.StructField(
        'buckets', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BucketManagerHost_Keys_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.buckets;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    BucketManagerHost_DeleteBucket_ParamsSpec.$,
    'BucketManagerHost_DeleteBucket_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketManagerHost_DeleteBucket_Params {
  constructor() {
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    BucketManagerHost_DeleteBucket_ResponseParamsSpec.$,
    'BucketManagerHost_DeleteBucket_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BucketManagerHost_DeleteBucket_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}

