// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorageErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CacheStorageError = {
  
  kSuccess: 0,
  kErrorExists: 1,
  kErrorStorage: 2,
  kErrorNotFound: 3,
  kErrorQuotaExceeded: 4,
  kErrorCacheNameNotFound: 5,
  kErrorQueryTooLarge: 6,
  kErrorNotImplemented: 7,
  kErrorDuplicateOperation: 8,
  kErrorCrossOriginResourcePolicy: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.OperationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.OperationType = {
  
  kUndefined: 0,
  kPut: 1,
  kDelete: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.CacheStorageCachePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.CacheStorageCache.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.CacheStorageCacheInterface }
 */
blink.mojom.CacheStorageCacheRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.CacheStorageCachePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.CacheStorageCachePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.CacheStorageCachePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FetchAPIRequest } request
   * @param { !blink.mojom.CacheQueryOptions } queryOptions
   * @param { !boolean } inRelatedFetchEvent
   * @param { !boolean } inRangeFetchEvent
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageCache_Match_ResponseParam_Result,
   *  }>}
   */

  match(
      request,
      queryOptions,
      inRelatedFetchEvent,
      inRangeFetchEvent,
      traceId) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.CacheStorageCache_Match_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Match_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          inRelatedFetchEvent,
          inRangeFetchEvent,
          traceId
        ],
        true);
  }

  
  /**
   * @param { ?blink.mojom.FetchAPIRequest } request
   * @param { !blink.mojom.CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageCache_MatchAll_ResponseParam_Result,
   *  }>}
   */

  matchAll(
      request,
      queryOptions,
      traceId) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.CacheStorageCache_MatchAll_ParamsSpec.$,
        blink.mojom.CacheStorageCache_MatchAll_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          traceId
        ],
        true);
  }

  
  /**
   * @param { ?blink.mojom.FetchAPIRequest } request
   * @param { !blink.mojom.CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result,
   *  }>}
   */

  getAllMatchedEntries(
      request,
      queryOptions,
      traceId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          traceId
        ],
        true);
  }

  
  /**
   * @param { ?blink.mojom.FetchAPIRequest } request
   * @param { !blink.mojom.CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageCache_Keys_ResponseParam_Result,
   *  }>}
   */

  keys(
      request,
      queryOptions,
      traceId) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.CacheStorageCache_Keys_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Keys_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          traceId
        ],
        true);
  }

  
  /**
   * @param { !Array<!blink.mojom.BatchOperation> } batchOperations
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageVerboseError,
   *  }>}
   */

  batch(
      batchOperations,
      traceId) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.CacheStorageCache_Batch_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Batch_ResponseParamsSpec.$,
        [
          batchOperations,
          traceId
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.Time } expectedResponseTime
   * @param { !mojoBase.mojom.BigBuffer } data
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageError,
   *  }>}
   */

  writeSideData(
      url,
      expectedResponseTime,
      data,
      traceId) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.CacheStorageCache_WriteSideData_ParamsSpec.$,
        blink.mojom.CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
        [
          url,
          expectedResponseTime,
          data,
          traceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CacheStorageCache
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.CacheStorageCacheReceiver = class {
  /**
   * @param {!blink.mojom.CacheStorageCacheInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.CacheStorageCacheRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.CacheStorageCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CacheStorageCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CacheStorageCache_Match_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Match_ResponseParamsSpec.$,
        impl.match.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CacheStorageCache_MatchAll_ParamsSpec.$,
        blink.mojom.CacheStorageCache_MatchAll_ResponseParamsSpec.$,
        impl.matchAll.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
        impl.getAllMatchedEntries.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.CacheStorageCache_Keys_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Keys_ResponseParamsSpec.$,
        impl.keys.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.CacheStorageCache_Batch_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Batch_ResponseParamsSpec.$,
        impl.batch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.CacheStorageCache_WriteSideData_ParamsSpec.$,
        blink.mojom.CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
        impl.writeSideData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.CacheStorageCache = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CacheStorageCache";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.CacheStorageCacheRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.CacheStorageCacheRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CacheStorageCache
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.CacheStorageCacheCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.CacheStorageCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CacheStorageCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.match =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CacheStorageCache_Match_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Match_ResponseParamsSpec.$,
        this.match.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.matchAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CacheStorageCache_MatchAll_ParamsSpec.$,
        blink.mojom.CacheStorageCache_MatchAll_ResponseParamsSpec.$,
        this.matchAll.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllMatchedEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
        this.getAllMatchedEntries.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.CacheStorageCache_Keys_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Keys_ResponseParamsSpec.$,
        this.keys.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.batch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.CacheStorageCache_Batch_ParamsSpec.$,
        blink.mojom.CacheStorageCache_Batch_ResponseParamsSpec.$,
        this.batch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSideData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.CacheStorageCache_WriteSideData_ParamsSpec.$,
        blink.mojom.CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
        this.writeSideData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.CacheStoragePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.CacheStorage.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.CacheStorageInterface }
 */
blink.mojom.CacheStorageRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.CacheStoragePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.CacheStoragePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.CacheStoragePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageError,
   *  }>}
   */

  has(
      cacheName,
      traceId) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.CacheStorage_Has_ParamsSpec.$,
        blink.mojom.CacheStorage_Has_ResponseParamsSpec.$,
        [
          cacheName,
          traceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorageError,
   *  }>}
   */

  delete(
      cacheName,
      traceId) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.CacheStorage_Delete_ParamsSpec.$,
        blink.mojom.CacheStorage_Delete_ResponseParamsSpec.$,
        [
          cacheName,
          traceId
        ],
        false);
  }

  
  /**
   * @param { !bigint } traceId
   * @return {!Promise<{
        keys: !Array<!mojoBase.mojom.String16>,
   *  }>}
   */

  keys(
      traceId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.CacheStorage_Keys_ParamsSpec.$,
        blink.mojom.CacheStorage_Keys_ResponseParamsSpec.$,
        [
          traceId
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FetchAPIRequest } request
   * @param { !blink.mojom.MultiCacheQueryOptions } matchOptions
   * @param { !boolean } inRelatedFetchEvent
   * @param { !boolean } inRangeFetchEvent
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorage_Match_ResponseParam_Result,
   *  }>}
   */

  match(
      request,
      matchOptions,
      inRelatedFetchEvent,
      inRangeFetchEvent,
      traceId) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.CacheStorage_Match_ParamsSpec.$,
        blink.mojom.CacheStorage_Match_ResponseParamsSpec.$,
        [
          request,
          matchOptions,
          inRelatedFetchEvent,
          inRangeFetchEvent,
          traceId
        ],
        true);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !blink.mojom.CacheStorage_Open_ResponseParam_Result,
   *  }>}
   */

  open(
      cacheName,
      traceId) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.CacheStorage_Open_ParamsSpec.$,
        blink.mojom.CacheStorage_Open_ResponseParamsSpec.$,
        [
          cacheName,
          traceId
        ],
        true);
  }
};

/**
 * An object which receives request messages for the CacheStorage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.CacheStorageReceiver = class {
  /**
   * @param {!blink.mojom.CacheStorageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.CacheStorageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.CacheStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CacheStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CacheStorage_Has_ParamsSpec.$,
        blink.mojom.CacheStorage_Has_ResponseParamsSpec.$,
        impl.has.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CacheStorage_Delete_ParamsSpec.$,
        blink.mojom.CacheStorage_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CacheStorage_Keys_ParamsSpec.$,
        blink.mojom.CacheStorage_Keys_ResponseParamsSpec.$,
        impl.keys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.CacheStorage_Match_ParamsSpec.$,
        blink.mojom.CacheStorage_Match_ResponseParamsSpec.$,
        impl.match.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.CacheStorage_Open_ParamsSpec.$,
        blink.mojom.CacheStorage_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.CacheStorage = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CacheStorage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.CacheStorageRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.CacheStorageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CacheStorage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.CacheStorageCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.CacheStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CacheStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.has =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CacheStorage_Has_ParamsSpec.$,
        blink.mojom.CacheStorage_Has_ResponseParamsSpec.$,
        this.has.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CacheStorage_Delete_ParamsSpec.$,
        blink.mojom.CacheStorage_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CacheStorage_Keys_ParamsSpec.$,
        blink.mojom.CacheStorage_Keys_ResponseParamsSpec.$,
        this.keys.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.match =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.CacheStorage_Match_ParamsSpec.$,
        blink.mojom.CacheStorage_Match_ResponseParamsSpec.$,
        this.match.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.CacheStorage_Open_ParamsSpec.$,
        blink.mojom.CacheStorage_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageVerboseErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheQueryOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MultiCacheQueryOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BatchOperationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EagerResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_Match_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_Match_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_MatchAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_MatchAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_GetAllMatchedEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_Keys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_Keys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_Batch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_Batch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_WriteSideData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorageCache_WriteSideData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Has_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Has_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Keys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Keys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Match_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Match_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CacheStorage_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MatchResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorageCache_Match_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorageCache_MatchAll_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorageCache_Keys_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorage_Match_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CacheStorage_Open_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.CacheStorageVerboseErrorSpec.$,
    'CacheStorageVerboseError',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        blink.mojom.CacheStorageErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorageVerboseError = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageError } */
    this.value;
    /** @export { (string|undefined) } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheQueryOptionsSpec.$,
    'CacheQueryOptions',
    [
      mojo.internal.StructField(
        'ignoreSearch', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ignoreMethod', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ignoreVary', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheQueryOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.ignoreSearch;
    /** @export { !boolean } */
    this.ignoreMethod;
    /** @export { !boolean } */
    this.ignoreVary;
  }
};



mojo.internal.Struct(
    blink.mojom.MultiCacheQueryOptionsSpec.$,
    'MultiCacheQueryOptions',
    [
      mojo.internal.StructField(
        'queryOptions', 0,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheName', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MultiCacheQueryOptions = class {
  constructor() {
    /** @export { !blink.mojom.CacheQueryOptions } */
    this.queryOptions;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.cacheName;
  }
};



mojo.internal.Struct(
    blink.mojom.BatchOperationSpec.$,
    'BatchOperation',
    [
      mojo.internal.StructField(
        'operationType', 0,
        0,
        blink.mojom.OperationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 16,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchOptions', 24,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.BatchOperation = class {
  constructor() {
    /** @export { !blink.mojom.OperationType } */
    this.operationType;
    /** @export { !blink.mojom.FetchAPIRequest } */
    this.request;
    /** @export { (blink.mojom.FetchAPIResponse|undefined) } */
    this.response;
    /** @export { (blink.mojom.CacheQueryOptions|undefined) } */
    this.matchOptions;
  }
};



mojo.internal.Struct(
    blink.mojom.EagerResponseSpec.$,
    'EagerResponse',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pipe', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientReceiver', 12,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.BlobReaderClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.EagerResponse = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIResponse } */
    this.response;
    /** @export { !MojoHandle } */
    this.pipe;
    /** @export { !blink.mojom.BlobReaderClientPendingReceiver } */
    this.clientReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheEntrySpec.$,
    'CacheEntry',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheEntry = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIRequest } */
    this.request;
    /** @export { !blink.mojom.FetchAPIResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_Match_ParamsSpec.$,
    'CacheStorageCache_Match_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inRelatedFetchEvent', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inRangeFetchEvent', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.CacheStorageCache_Match_Params = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIRequest } */
    this.request;
    /** @export { !blink.mojom.CacheQueryOptions } */
    this.queryOptions;
    /** @export { !boolean } */
    this.inRelatedFetchEvent;
    /** @export { !boolean } */
    this.inRangeFetchEvent;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_Match_ResponseParamsSpec.$,
    'CacheStorageCache_Match_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageCache_Match_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorageCache_Match_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageCache_Match_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_MatchAll_ParamsSpec.$,
    'CacheStorageCache_MatchAll_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CacheStorageCache_MatchAll_Params = class {
  constructor() {
    /** @export { (blink.mojom.FetchAPIRequest|undefined) } */
    this.request;
    /** @export { !blink.mojom.CacheQueryOptions } */
    this.queryOptions;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_MatchAll_ResponseParamsSpec.$,
    'CacheStorageCache_MatchAll_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageCache_MatchAll_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorageCache_MatchAll_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageCache_MatchAll_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
    'CacheStorageCache_GetAllMatchedEntries_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CacheStorageCache_GetAllMatchedEntries_Params = class {
  constructor() {
    /** @export { (blink.mojom.FetchAPIRequest|undefined) } */
    this.request;
    /** @export { !blink.mojom.CacheQueryOptions } */
    this.queryOptions;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
    'CacheStorageCache_GetAllMatchedEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_Keys_ParamsSpec.$,
    'CacheStorageCache_Keys_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CacheStorageCache_Keys_Params = class {
  constructor() {
    /** @export { (blink.mojom.FetchAPIRequest|undefined) } */
    this.request;
    /** @export { !blink.mojom.CacheQueryOptions } */
    this.queryOptions;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_Keys_ResponseParamsSpec.$,
    'CacheStorageCache_Keys_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageCache_Keys_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorageCache_Keys_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageCache_Keys_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_Batch_ParamsSpec.$,
    'CacheStorageCache_Batch_Params',
    [
      mojo.internal.StructField(
        'batchOperations', 0,
        0,
        mojo.internal.Array(blink.mojom.BatchOperationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorageCache_Batch_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.BatchOperation> } */
    this.batchOperations;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_Batch_ResponseParamsSpec.$,
    'CacheStorageCache_Batch_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageVerboseErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheStorageCache_Batch_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageVerboseError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_WriteSideData_ParamsSpec.$,
    'CacheStorageCache_WriteSideData_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedResponseTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.CacheStorageCache_WriteSideData_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.Time } */
    this.expectedResponseTime;
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
    'CacheStorageCache_WriteSideData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheStorageCache_WriteSideData_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Has_ParamsSpec.$,
    'CacheStorage_Has_Params',
    [
      mojo.internal.StructField(
        'cacheName', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorage_Has_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.cacheName;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Has_ResponseParamsSpec.$,
    'CacheStorage_Has_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheStorage_Has_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Delete_ParamsSpec.$,
    'CacheStorage_Delete_Params',
    [
      mojo.internal.StructField(
        'cacheName', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorage_Delete_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.cacheName;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Delete_ResponseParamsSpec.$,
    'CacheStorage_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorageErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheStorage_Delete_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorageError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Keys_ParamsSpec.$,
    'CacheStorage_Keys_Params',
    [
      mojo.internal.StructField(
        'traceId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheStorage_Keys_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Keys_ResponseParamsSpec.$,
    'CacheStorage_Keys_ResponseParams',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.String16Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CacheStorage_Keys_ResponseParams = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.String16> } */
    this.keys;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Match_ParamsSpec.$,
    'CacheStorage_Match_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchOptions', 8,
        0,
        blink.mojom.MultiCacheQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inRelatedFetchEvent', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inRangeFetchEvent', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.CacheStorage_Match_Params = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIRequest } */
    this.request;
    /** @export { !blink.mojom.MultiCacheQueryOptions } */
    this.matchOptions;
    /** @export { !boolean } */
    this.inRelatedFetchEvent;
    /** @export { !boolean } */
    this.inRangeFetchEvent;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Match_ResponseParamsSpec.$,
    'CacheStorage_Match_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorage_Match_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorage_Match_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorage_Match_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Open_ParamsSpec.$,
    'CacheStorage_Open_Params',
    [
      mojo.internal.StructField(
        'cacheName', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorage_Open_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.cacheName;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    blink.mojom.CacheStorage_Open_ResponseParamsSpec.$,
    'CacheStorage_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CacheStorage_Open_ResponseParam_ResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CacheStorage_Open_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CacheStorage_Open_ResponseParam_Result } */
    this.result;
  }
};



mojo.internal.Union(
    blink.mojom.MatchResponseSpec.$, 'MatchResponse',
    {
      'response': {
        'ordinal': 0,
        'type': blink.mojom.FetchAPIResponseSpec.$,
      },
      'eagerResponse': {
        'ordinal': 1,
        'type': blink.mojom.EagerResponseSpec.$,
      },
    });

/**
 * @typedef { {
 *   response: (!blink.mojom.FetchAPIResponse|undefined),
 *   eagerResponse: (!blink.mojom.EagerResponse|undefined),
 * } }
 */
blink.mojom.MatchResponse;


mojo.internal.Union(
    blink.mojom.CacheStorageCache_Match_ResponseParam_ResultSpec.$, 'CacheStorageCache_Match_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': blink.mojom.MatchResponseSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': blink.mojom.CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!blink.mojom.MatchResponse|undefined),
 *   failure: (!blink.mojom.CacheStorageError|undefined),
 * } }
 */
blink.mojom.CacheStorageCache_Match_ResponseParam_Result;


mojo.internal.Union(
    blink.mojom.CacheStorageCache_MatchAll_ResponseParam_ResultSpec.$, 'CacheStorageCache_MatchAll_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink.mojom.FetchAPIResponseSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': blink.mojom.CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!blink.mojom.FetchAPIResponse>|undefined),
 *   failure: (!blink.mojom.CacheStorageError|undefined),
 * } }
 */
blink.mojom.CacheStorageCache_MatchAll_ResponseParam_Result;


mojo.internal.Union(
    blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultSpec.$, 'CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink.mojom.CacheEntrySpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': blink.mojom.CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!blink.mojom.CacheEntry>|undefined),
 *   failure: (!blink.mojom.CacheStorageError|undefined),
 * } }
 */
blink.mojom.CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result;


mojo.internal.Union(
    blink.mojom.CacheStorageCache_Keys_ResponseParam_ResultSpec.$, 'CacheStorageCache_Keys_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink.mojom.FetchAPIRequestSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': blink.mojom.CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!blink.mojom.FetchAPIRequest>|undefined),
 *   failure: (!blink.mojom.CacheStorageError|undefined),
 * } }
 */
blink.mojom.CacheStorageCache_Keys_ResponseParam_Result;


mojo.internal.Union(
    blink.mojom.CacheStorage_Match_ResponseParam_ResultSpec.$, 'CacheStorage_Match_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': blink.mojom.MatchResponseSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': blink.mojom.CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!blink.mojom.MatchResponse|undefined),
 *   failure: (!blink.mojom.CacheStorageError|undefined),
 * } }
 */
blink.mojom.CacheStorage_Match_ResponseParam_Result;


mojo.internal.Union(
    blink.mojom.CacheStorage_Open_ResponseParam_ResultSpec.$, 'CacheStorage_Open_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.AssociatedInterfaceProxy(blink.mojom.CacheStorageCacheRemote),
      },
      'failure': {
        'ordinal': 1,
        'type': blink.mojom.CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Object|undefined),
 *   failure: (!blink.mojom.CacheStorageError|undefined),
 * } }
 */
blink.mojom.CacheStorage_Open_ResponseParam_Result;
