// third_party/blink/public/mojom/choosers/date_time_chooser.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DateTimeChooserPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DateTimeChooser.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DateTimeChooserInterface }
 */
blink.mojom.DateTimeChooserRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DateTimeChooserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DateTimeChooserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DateTimeChooserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DateTimeDialogValue } value
   * @return {!Promise<{
        success: !boolean,
        dialogValue: !number,
   *  }>}
   */

  openDateTimeDialog(
      value) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
        blink.mojom.DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   */

  closeDateTimeDialog() {
    this.proxy.sendMessage(
        1,
        blink.mojom.DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DateTimeChooser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DateTimeChooserReceiver = class {
  /**
   * @param {!blink.mojom.DateTimeChooserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DateTimeChooserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DateTimeChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DateTimeChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
        blink.mojom.DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
        impl.openDateTimeDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
        null,
        impl.closeDateTimeDialog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DateTimeChooser = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DateTimeChooser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DateTimeChooserRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DateTimeChooserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DateTimeChooser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DateTimeChooserCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DateTimeChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DateTimeChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDateTimeDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
        blink.mojom.DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
        this.openDateTimeDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeDateTimeDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
        null,
        this.closeDateTimeDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DateTimeSuggestionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DateTimeDialogValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DateTimeChooser_OpenDateTimeDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DateTimeChooser_CloseDateTimeDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DateTimeSuggestionSpec.$,
    'DateTimeSuggestion',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localizedValue', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DateTimeSuggestion = class {
  constructor() {
    /** @export { !number } */
    this.value;
    /** @export { !mojoBase.mojom.String16 } */
    this.localizedValue;
    /** @export { !mojoBase.mojom.String16 } */
    this.label;
  }
};



mojo.internal.Struct(
    blink.mojom.DateTimeDialogValueSpec.$,
    'DateTimeDialogValue',
    [
      mojo.internal.StructField(
        'dialogType', 0,
        0,
        ui.mojom.TextInputTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dialogValue', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minimum', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maximum', 24,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'step', 32,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestions', 40,
        0,
        mojo.internal.Array(blink.mojom.DateTimeSuggestionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.DateTimeDialogValue = class {
  constructor() {
    /** @export { !ui.mojom.TextInputType } */
    this.dialogType;
    /** @export { !number } */
    this.dialogValue;
    /** @export { !number } */
    this.minimum;
    /** @export { !number } */
    this.maximum;
    /** @export { !number } */
    this.step;
    /** @export { !Array<!blink.mojom.DateTimeSuggestion> } */
    this.suggestions;
  }
};



mojo.internal.Struct(
    blink.mojom.DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
    'DateTimeChooser_OpenDateTimeDialog_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        blink.mojom.DateTimeDialogValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DateTimeChooser_OpenDateTimeDialog_Params = class {
  constructor() {
    /** @export { !blink.mojom.DateTimeDialogValue } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
    'DateTimeChooser_OpenDateTimeDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dialogValue', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DateTimeChooser_OpenDateTimeDialog_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !number } */
    this.dialogValue;
  }
};



mojo.internal.Struct(
    blink.mojom.DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
    'DateTimeChooser_CloseDateTimeDialog_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DateTimeChooser_CloseDateTimeDialog_Params = class {
  constructor() {
  }
};

