// third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PressureManagerAddClientResult as device_mojom_PressureManagerAddClientResult,
  PressureManagerAddClientResultSpec as device_mojom_PressureManagerAddClientResultSpec
} from '../../../../../services/device/public/mojom/pressure_manager.mojom.m.js';

import {
  PressureSource as device_mojom_PressureSource,
  PressureSourceSpec as device_mojom_PressureSourceSpec
} from '../../../../../services/device/public/mojom/pressure_update.mojom.m.js';

import {
  WebPressureUpdate as blink_mojom_WebPressureUpdate,
  WebPressureUpdateSpec as blink_mojom_WebPressureUpdateSpec
} from './web_pressure_update.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebPressureManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebPressureManager', scope);
  }
}

/** @interface */
export class WebPressureManagerInterface {
  
  /**
   * @param { !device_mojom_PressureSource } source
   * @param { !Object } client
   * @return {!Promise<{
        result: !device_mojom_PressureManagerAddClientResult,
   *  }>}
   */

  addClient(source, client) {}
}

/**
 * @implements { WebPressureManagerInterface }
 */
export class WebPressureManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebPressureManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebPressureManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebPressureManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_PressureSource } source
   * @param { !Object } client
   * @return {!Promise<{
        result: !device_mojom_PressureManagerAddClientResult,
   *  }>}
   */

  addClient(
      source,
      client) {
    return this.proxy.sendMessage(
        0,
        WebPressureManager_AddClient_ParamsSpec.$,
        WebPressureManager_AddClient_ResponseParamsSpec.$,
        [
          source,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebPressureManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebPressureManagerReceiver {
  /**
   * @param {!WebPressureManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebPressureManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebPressureManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPressureManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebPressureManager_AddClient_ParamsSpec.$,
        WebPressureManager_AddClient_ResponseParamsSpec.$,
        impl.addClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebPressureManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPressureManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebPressureManagerRemote}
   */
  static getRemote() {
    let remote = new WebPressureManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebPressureManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebPressureManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebPressureManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPressureManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebPressureManager_AddClient_ParamsSpec.$,
        WebPressureManager_AddClient_ResponseParamsSpec.$,
        this.addClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebPressureClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebPressureClient', scope);
  }
}

/** @interface */
export class WebPressureClientInterface {
  
  /**
   * @param { !blink_mojom_WebPressureUpdate } update
   */

  onPressureUpdated(update) {}
}

/**
 * @implements { WebPressureClientInterface }
 */
export class WebPressureClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebPressureClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebPressureClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebPressureClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_WebPressureUpdate } update
   */

  onPressureUpdated(
      update) {
    this.proxy.sendMessage(
        0,
        WebPressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebPressureClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebPressureClientReceiver {
  /**
   * @param {!WebPressureClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebPressureClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebPressureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPressureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebPressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        impl.onPressureUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebPressureClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPressureClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebPressureClientRemote}
   */
  static getRemote() {
    let remote = new WebPressureClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebPressureClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebPressureClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebPressureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebPressureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPressureUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebPressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        this.onPressureUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPressureManager_AddClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPressureManager_AddClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebPressureClient_OnPressureUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebPressureManager_AddClient_ParamsSpec.$,
    'WebPressureManager_AddClient_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        device_mojom_PressureSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(WebPressureClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebPressureManager_AddClient_Params {
  constructor() {
    /** @type { !device_mojom_PressureSource } */
    this.source;
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    WebPressureManager_AddClient_ResponseParamsSpec.$,
    'WebPressureManager_AddClient_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device_mojom_PressureManagerAddClientResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebPressureManager_AddClient_ResponseParams {
  constructor() {
    /** @type { !device_mojom_PressureManagerAddClientResult } */
    this.result;
  }
}



mojo.internal.Struct(
    WebPressureClient_OnPressureUpdated_ParamsSpec.$,
    'WebPressureClient_OnPressureUpdated_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        blink_mojom_WebPressureUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebPressureClient_OnPressureUpdated_Params {
  constructor() {
    /** @type { !blink_mojom_WebPressureUpdate } */
    this.update;
  }
}

