// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DirectSocketsServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DirectSocketsService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DirectSocketsServiceInterface }
 */
blink.mojom.DirectSocketsServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DirectSocketsServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DirectSocketsServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DirectSocketsServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DirectTCPSocketOptions } options
   * @param { !network.mojom.TCPConnectedSocketPendingReceiver } receiver
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  openTCPSocket(
      options,
      receiver,
      observer) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
        [
          options,
          receiver,
          observer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DirectConnectedUDPSocketOptions } options
   * @param { !network.mojom.RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network.mojom.UDPSocketListenerRemote } listener
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
   *  }>}
   */

  openConnectedUDPSocket(
      options,
      receiver,
      listener) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
        [
          options,
          receiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DirectBoundUDPSocketOptions } options
   * @param { !network.mojom.RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network.mojom.UDPSocketListenerRemote } listener
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
   *  }>}
   */

  openBoundUDPSocket(
      options,
      receiver,
      listener) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
        [
          options,
          receiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DirectTCPServerSocketOptions } options
   * @param { !network.mojom.TCPServerSocketPendingReceiver } receiver
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
   *  }>}
   */

  openTCPServerSocket(
      options,
      receiver) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
        [
          options,
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DirectSocketsService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DirectSocketsServiceReceiver = class {
  /**
   * @param {!blink.mojom.DirectSocketsServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DirectSocketsServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DirectSocketsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DirectSocketsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
        impl.openTCPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
        impl.openConnectedUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
        impl.openBoundUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
        impl.openTCPServerSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DirectSocketsService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DirectSocketsService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DirectSocketsServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DirectSocketsServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DirectSocketsService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DirectSocketsServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DirectSocketsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DirectSocketsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openTCPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
        this.openTCPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openConnectedUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
        this.openConnectedUDPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openBoundUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
        this.openBoundUDPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openTCPServerSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
        blink.mojom.DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
        this.openTCPServerSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectTCPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectConnectedUDPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectBoundUDPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectTCPServerSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenTCPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenTCPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenTCPServerSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DirectTCPSocketOptionsSpec.$,
    'DirectTCPSocketOptions',
    [
      mojo.internal.StructField(
        'remoteAddr', 0,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'send_buffer_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "send_buffer_size_$value",
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'send_buffer_size_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "receive_buffer_size_$value",
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'noDelay', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keepAliveOptions', 24,
        0,
        network.mojom.TCPKeepAliveOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dns_query_type_$flag', 8,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "dns_query_type_$value",
          originalFieldName: "dnsQueryType",
        }
      ),
      mojo.internal.StructField(
        'dns_query_type_$value', 20,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "dnsQueryType",
        }
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.DirectTCPSocketOptions = class {
  constructor() {
    /** @export { !network.mojom.HostPortPair } */
    this.remoteAddr;
    /** @export { (number|undefined) } */
    this.sendBufferSize;
    /** @export { (number|undefined) } */
    this.receiveBufferSize;
    /** @export { !boolean } */
    this.noDelay;
    /** @export { (network.mojom.TCPKeepAliveOptions|undefined) } */
    this.keepAliveOptions;
    /** @export { (network.mojom.DnsQueryType|undefined) } */
    this.dnsQueryType;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectConnectedUDPSocketOptionsSpec.$,
    'DirectConnectedUDPSocketOptions',
    [
      mojo.internal.StructField(
        'remoteAddr', 0,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'send_buffer_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "send_buffer_size_$value",
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'send_buffer_size_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "receive_buffer_size_$value",
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'dns_query_type_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "dns_query_type_$value",
          originalFieldName: "dnsQueryType",
        }
      ),
      mojo.internal.StructField(
        'dns_query_type_$value', 20,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "dnsQueryType",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$flag', 8,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_time_to_live_$value",
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$value', 9,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$flag', 8,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_loopback_$value",
          originalFieldName: "multicastLoopback",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$value', 8,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "multicastLoopback",
        }
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DirectConnectedUDPSocketOptions = class {
  constructor() {
    /** @export { !network.mojom.HostPortPair } */
    this.remoteAddr;
    /** @export { (number|undefined) } */
    this.sendBufferSize;
    /** @export { (number|undefined) } */
    this.receiveBufferSize;
    /** @export { (network.mojom.DnsQueryType|undefined) } */
    this.dnsQueryType;
    /** @export { (number|undefined) } */
    this.multicastTimeToLive;
    /** @export { (boolean|undefined) } */
    this.multicastLoopback;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectBoundUDPSocketOptionsSpec.$,
    'DirectBoundUDPSocketOptions',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'send_buffer_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "send_buffer_size_$value",
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'send_buffer_size_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "receive_buffer_size_$value",
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 8,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'multicast_allow_address_sharing_$flag', 8,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_allow_address_sharing_$value",
          originalFieldName: "multicastAllowAddressSharing",
        }
      ),
      mojo.internal.StructField(
        'multicast_allow_address_sharing_$value', 8,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "multicastAllowAddressSharing",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$flag', 8,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_time_to_live_$value",
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$value', 9,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$flag', 8,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_loopback_$value",
          originalFieldName: "multicastLoopback",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$value', 10,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "multicastLoopback",
        }
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DirectBoundUDPSocketOptions = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddr;
    /** @export { (number|undefined) } */
    this.sendBufferSize;
    /** @export { (number|undefined) } */
    this.receiveBufferSize;
    /** @export { (boolean|undefined) } */
    this.ipv6Only;
    /** @export { (boolean|undefined) } */
    this.multicastAllowAddressSharing;
    /** @export { (number|undefined) } */
    this.multicastTimeToLive;
    /** @export { (boolean|undefined) } */
    this.multicastLoopback;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectTCPServerSocketOptionsSpec.$,
    'DirectTCPServerSocketOptions',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'backlog_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "backlog_$value",
          originalFieldName: "backlog",
        }
      ),
      mojo.internal.StructField(
        'backlog_$value', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "backlog",
        }
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DirectTCPServerSocketOptions = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddr;
    /** @export { (boolean|undefined) } */
    this.ipv6Only;
    /** @export { (number|undefined) } */
    this.backlog;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
    'DirectSocketsService_OpenTCPSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.DirectTCPSocketOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPConnectedSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DirectSocketsService_OpenTCPSocket_Params = class {
  constructor() {
    /** @export { !blink.mojom.DirectTCPSocketOptions } */
    this.options;
    /** @export { !network.mojom.TCPConnectedSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenTCPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.DirectSocketsService_OpenTCPSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.peerAddr;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
    'DirectSocketsService_OpenConnectedUDPSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.DirectConnectedUDPSocketOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.RestrictedUDPSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 12,
        0,
        mojo.internal.InterfaceProxy(network.mojom.UDPSocketListenerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_Params = class {
  constructor() {
    /** @export { !blink.mojom.DirectConnectedUDPSocketOptions } */
    this.options;
    /** @export { !network.mojom.RestrictedUDPSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.UDPSocketListenerRemote|undefined) } */
    this.listener;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenConnectedUDPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DirectSocketsService_OpenConnectedUDPSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.peerAddr;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
    'DirectSocketsService_OpenBoundUDPSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.DirectBoundUDPSocketOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.RestrictedUDPSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 12,
        0,
        mojo.internal.InterfaceProxy(network.mojom.UDPSocketListenerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DirectSocketsService_OpenBoundUDPSocket_Params = class {
  constructor() {
    /** @export { !blink.mojom.DirectBoundUDPSocketOptions } */
    this.options;
    /** @export { !network.mojom.RestrictedUDPSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.UDPSocketListenerRemote|undefined) } */
    this.listener;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenBoundUDPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DirectSocketsService_OpenBoundUDPSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
    'DirectSocketsService_OpenTCPServerSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.DirectTCPServerSocketOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPServerSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DirectSocketsService_OpenTCPServerSocket_Params = class {
  constructor() {
    /** @export { !blink.mojom.DirectTCPServerSocketOptions } */
    this.options;
    /** @export { !network.mojom.TCPServerSocketPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenTCPServerSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DirectSocketsService_OpenTCPServerSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
  }
};

