// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  DnsQueryType as network_mojom_DnsQueryType,
  DnsQueryTypeSpec as network_mojom_DnsQueryTypeSpec
} from '../../../../../services/network/public/mojom/host_resolver.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from '../../../../../services/network/public/mojom/ip_endpoint.mojom.m.js';

import {
  HostPortPair as network_mojom_HostPortPair,
  HostPortPairSpec as network_mojom_HostPortPairSpec
} from '../../../../../services/network/public/mojom/network_param.mojom.m.js';

import {
  RestrictedUDPSocketRemote as network_mojom_RestrictedUDPSocketRemote,
  RestrictedUDPSocketPendingReceiver as network_mojom_RestrictedUDPSocketPendingReceiver
} from '../../../../../services/network/public/mojom/restricted_udp_socket.mojom.m.js';

import {
  SocketObserverRemote as network_mojom_SocketObserverRemote,
  SocketObserverPendingReceiver as network_mojom_SocketObserverPendingReceiver,
  TCPConnectedSocketRemote as network_mojom_TCPConnectedSocketRemote,
  TCPConnectedSocketPendingReceiver as network_mojom_TCPConnectedSocketPendingReceiver,
  TCPServerSocketRemote as network_mojom_TCPServerSocketRemote,
  TCPServerSocketPendingReceiver as network_mojom_TCPServerSocketPendingReceiver,
  TCPKeepAliveOptions as network_mojom_TCPKeepAliveOptions,
  TCPKeepAliveOptionsSpec as network_mojom_TCPKeepAliveOptionsSpec
} from '../../../../../services/network/public/mojom/tcp_socket.mojom.m.js';

import {
  UDPSocketListenerRemote as network_mojom_UDPSocketListenerRemote,
  UDPSocketListenerPendingReceiver as network_mojom_UDPSocketListenerPendingReceiver
} from '../../../../../services/network/public/mojom/udp_socket.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DirectSocketsServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DirectSocketsService', scope);
  }
}

/** @interface */
export class DirectSocketsServiceInterface {
  
  /**
   * @param { !DirectTCPSocketOptions } options
   * @param { !network_mojom_TCPConnectedSocketPendingReceiver } receiver
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  openTCPSocket(options, receiver, observer) {}
  
  /**
   * @param { !DirectConnectedUDPSocketOptions } options
   * @param { !network_mojom_RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  openConnectedUDPSocket(options, receiver, listener) {}
  
  /**
   * @param { !DirectBoundUDPSocketOptions } options
   * @param { !network_mojom_RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  openBoundUDPSocket(options, receiver, listener) {}
  
  /**
   * @param { !DirectTCPServerSocketOptions } options
   * @param { !network_mojom_TCPServerSocketPendingReceiver } receiver
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  openTCPServerSocket(options, receiver) {}
}

/**
 * @implements { DirectSocketsServiceInterface }
 */
export class DirectSocketsServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DirectSocketsServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DirectSocketsServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DirectSocketsServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DirectTCPSocketOptions } options
   * @param { !network_mojom_TCPConnectedSocketPendingReceiver } receiver
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  openTCPSocket(
      options,
      receiver,
      observer) {
    return this.proxy.sendMessage(
        0,
        DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
        DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
        [
          options,
          receiver,
          observer
        ],
        false);
  }

  
  /**
   * @param { !DirectConnectedUDPSocketOptions } options
   * @param { !network_mojom_RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  openConnectedUDPSocket(
      options,
      receiver,
      listener) {
    return this.proxy.sendMessage(
        1,
        DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
        DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
        [
          options,
          receiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !DirectBoundUDPSocketOptions } options
   * @param { !network_mojom_RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  openBoundUDPSocket(
      options,
      receiver,
      listener) {
    return this.proxy.sendMessage(
        2,
        DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
        DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
        [
          options,
          receiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !DirectTCPServerSocketOptions } options
   * @param { !network_mojom_TCPServerSocketPendingReceiver } receiver
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  openTCPServerSocket(
      options,
      receiver) {
    return this.proxy.sendMessage(
        3,
        DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
        DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
        [
          options,
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DirectSocketsService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DirectSocketsServiceReceiver {
  /**
   * @param {!DirectSocketsServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DirectSocketsServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DirectSocketsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DirectSocketsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
        DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
        impl.openTCPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
        DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
        impl.openConnectedUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
        DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
        impl.openBoundUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
        DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
        impl.openTCPServerSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DirectSocketsService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DirectSocketsService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DirectSocketsServiceRemote}
   */
  static getRemote() {
    let remote = new DirectSocketsServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DirectSocketsService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DirectSocketsServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DirectSocketsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DirectSocketsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openTCPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
        DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
        this.openTCPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openConnectedUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
        DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
        this.openConnectedUDPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openBoundUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
        DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
        this.openBoundUDPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openTCPServerSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
        DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
        this.openTCPServerSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectTCPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectConnectedUDPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectBoundUDPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectTCPServerSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenTCPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenTCPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenBoundUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenTCPServerSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DirectTCPSocketOptionsSpec.$,
    'DirectTCPSocketOptions',
    [
      mojo.internal.StructField(
        'remoteAddr', 0,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'send_buffer_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "send_buffer_size_$value",
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'send_buffer_size_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "receive_buffer_size_$value",
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'noDelay', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keepAliveOptions', 24,
        0,
        network_mojom_TCPKeepAliveOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dns_query_type_$flag', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "dns_query_type_$value",
          originalFieldName: "dnsQueryType",
        }
      ),
      mojo.internal.StructField(
        'dns_query_type_$value', 20,
        0,
        network_mojom_DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "dnsQueryType",
        }
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DirectTCPSocketOptions {
  constructor() {
    /** @type { !network_mojom_HostPortPair } */
    this.remoteAddr;
    /** @type { (number|undefined) } */
    this.sendBufferSize;
    /** @type { (number|undefined) } */
    this.receiveBufferSize;
    /** @type { !boolean } */
    this.noDelay;
    /** @type { (network_mojom_TCPKeepAliveOptions|undefined) } */
    this.keepAliveOptions;
    /** @type { (network_mojom_DnsQueryType|undefined) } */
    this.dnsQueryType;
  }
}



mojo.internal.Struct(
    DirectConnectedUDPSocketOptionsSpec.$,
    'DirectConnectedUDPSocketOptions',
    [
      mojo.internal.StructField(
        'remoteAddr', 0,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'send_buffer_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "send_buffer_size_$value",
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'send_buffer_size_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "receive_buffer_size_$value",
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'dns_query_type_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "dns_query_type_$value",
          originalFieldName: "dnsQueryType",
        }
      ),
      mojo.internal.StructField(
        'dns_query_type_$value', 20,
        0,
        network_mojom_DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "dnsQueryType",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$flag', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_time_to_live_$value",
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$value', 9,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$flag', 8,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_loopback_$value",
          originalFieldName: "multicastLoopback",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$value', 8,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "multicastLoopback",
        }
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DirectConnectedUDPSocketOptions {
  constructor() {
    /** @type { !network_mojom_HostPortPair } */
    this.remoteAddr;
    /** @type { (number|undefined) } */
    this.sendBufferSize;
    /** @type { (number|undefined) } */
    this.receiveBufferSize;
    /** @type { (network_mojom_DnsQueryType|undefined) } */
    this.dnsQueryType;
    /** @type { (number|undefined) } */
    this.multicastTimeToLive;
    /** @type { (boolean|undefined) } */
    this.multicastLoopback;
  }
}



mojo.internal.Struct(
    DirectBoundUDPSocketOptionsSpec.$,
    'DirectBoundUDPSocketOptions',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'send_buffer_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "send_buffer_size_$value",
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'send_buffer_size_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sendBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "receive_buffer_size_$value",
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'receive_buffer_size_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "receiveBufferSize",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'multicast_allow_address_sharing_$flag', 8,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_allow_address_sharing_$value",
          originalFieldName: "multicastAllowAddressSharing",
        }
      ),
      mojo.internal.StructField(
        'multicast_allow_address_sharing_$value', 8,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "multicastAllowAddressSharing",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$flag', 8,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_time_to_live_$value",
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_time_to_live_$value', 9,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "multicastTimeToLive",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$flag', 8,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "multicast_loopback_$value",
          originalFieldName: "multicastLoopback",
        }
      ),
      mojo.internal.StructField(
        'multicast_loopback_$value', 10,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "multicastLoopback",
        }
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DirectBoundUDPSocketOptions {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddr;
    /** @type { (number|undefined) } */
    this.sendBufferSize;
    /** @type { (number|undefined) } */
    this.receiveBufferSize;
    /** @type { (boolean|undefined) } */
    this.ipv6Only;
    /** @type { (boolean|undefined) } */
    this.multicastAllowAddressSharing;
    /** @type { (number|undefined) } */
    this.multicastTimeToLive;
    /** @type { (boolean|undefined) } */
    this.multicastLoopback;
  }
}



mojo.internal.Struct(
    DirectTCPServerSocketOptionsSpec.$,
    'DirectTCPServerSocketOptions',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'backlog_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "backlog_$value",
          originalFieldName: "backlog",
        }
      ),
      mojo.internal.StructField(
        'backlog_$value', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "backlog",
        }
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DirectTCPServerSocketOptions {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddr;
    /** @type { (boolean|undefined) } */
    this.ipv6Only;
    /** @type { (number|undefined) } */
    this.backlog;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenTCPSocket_ParamsSpec.$,
    'DirectSocketsService_OpenTCPSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        DirectTCPSocketOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TCPConnectedSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DirectSocketsService_OpenTCPSocket_Params {
  constructor() {
    /** @type { !DirectTCPSocketOptions } */
    this.options;
    /** @type { !network_mojom_TCPConnectedSocketPendingReceiver } */
    this.receiver;
    /** @type { (network_mojom_SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenTCPSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenTCPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DirectSocketsService_OpenTCPSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.peerAddr;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenConnectedUDPSocket_ParamsSpec.$,
    'DirectSocketsService_OpenConnectedUDPSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        DirectConnectedUDPSocketOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_RestrictedUDPSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 12,
        0,
        mojo.internal.InterfaceProxy(network_mojom_UDPSocketListenerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DirectSocketsService_OpenConnectedUDPSocket_Params {
  constructor() {
    /** @type { !DirectConnectedUDPSocketOptions } */
    this.options;
    /** @type { !network_mojom_RestrictedUDPSocketPendingReceiver } */
    this.receiver;
    /** @type { (network_mojom_UDPSocketListenerRemote|undefined) } */
    this.listener;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenConnectedUDPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DirectSocketsService_OpenConnectedUDPSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.peerAddr;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenBoundUDPSocket_ParamsSpec.$,
    'DirectSocketsService_OpenBoundUDPSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        DirectBoundUDPSocketOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_RestrictedUDPSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 12,
        0,
        mojo.internal.InterfaceProxy(network_mojom_UDPSocketListenerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DirectSocketsService_OpenBoundUDPSocket_Params {
  constructor() {
    /** @type { !DirectBoundUDPSocketOptions } */
    this.options;
    /** @type { !network_mojom_RestrictedUDPSocketPendingReceiver } */
    this.receiver;
    /** @type { (network_mojom_UDPSocketListenerRemote|undefined) } */
    this.listener;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenBoundUDPSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenBoundUDPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DirectSocketsService_OpenBoundUDPSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenTCPServerSocket_ParamsSpec.$,
    'DirectSocketsService_OpenTCPServerSocket_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        DirectTCPServerSocketOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TCPServerSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DirectSocketsService_OpenTCPServerSocket_Params {
  constructor() {
    /** @type { !DirectTCPServerSocketOptions } */
    this.options;
    /** @type { !network_mojom_TCPServerSocketPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    DirectSocketsService_OpenTCPServerSocket_ResponseParamsSpec.$,
    'DirectSocketsService_OpenTCPServerSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DirectSocketsService_OpenTCPServerSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
  }
}

