// third_party/blink/public/mojom/dom_storage/storage_area.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class StorageAreaObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.StorageAreaObserver', scope);
  }
}

/** @interface */
export class StorageAreaObserverInterface {
  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } newValue
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyChanged(key, newValue, oldValue, source) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { !string } source
   */

  keyChangeFailed(key, source) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyDeleted(key, oldValue, source) {}
  
  /**
   * @param { !boolean } wasNonempty
   * @param { !string } source
   */

  allDeleted(wasNonempty, source) {}
  
  /**
   * @param { !boolean } value
   */

  shouldSendOldValueOnMutations(value) {}
}

/**
 * @implements { StorageAreaObserverInterface }
 */
export class StorageAreaObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!StorageAreaObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StorageAreaObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!StorageAreaObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } newValue
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyChanged(
      key,
      newValue,
      oldValue,
      source) {
    this.proxy.sendMessage(
        0,
        StorageAreaObserver_KeyChanged_ParamsSpec.$,
        null,
        [
          key,
          newValue,
          oldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { !string } source
   */

  keyChangeFailed(
      key,
      source) {
    this.proxy.sendMessage(
        1,
        StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
        null,
        [
          key,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyDeleted(
      key,
      oldValue,
      source) {
    this.proxy.sendMessage(
        2,
        StorageAreaObserver_KeyDeleted_ParamsSpec.$,
        null,
        [
          key,
          oldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !boolean } wasNonempty
   * @param { !string } source
   */

  allDeleted(
      wasNonempty,
      source) {
    this.proxy.sendMessage(
        3,
        StorageAreaObserver_AllDeleted_ParamsSpec.$,
        null,
        [
          wasNonempty,
          source
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  shouldSendOldValueOnMutations(
      value) {
    this.proxy.sendMessage(
        4,
        StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }
}

/**
 * An object which receives request messages for the StorageAreaObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StorageAreaObserverReceiver {
  /**
   * @param {!StorageAreaObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!StorageAreaObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StorageAreaObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StorageAreaObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StorageAreaObserver_KeyChanged_ParamsSpec.$,
        null,
        impl.keyChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
        null,
        impl.keyChangeFailed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        StorageAreaObserver_KeyDeleted_ParamsSpec.$,
        null,
        impl.keyDeleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        StorageAreaObserver_AllDeleted_ParamsSpec.$,
        null,
        impl.allDeleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
        null,
        impl.shouldSendOldValueOnMutations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StorageAreaObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.StorageAreaObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!StorageAreaObserverRemote}
   */
  static getRemote() {
    let remote = new StorageAreaObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the StorageAreaObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StorageAreaObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StorageAreaObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StorageAreaObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keyChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StorageAreaObserver_KeyChanged_ParamsSpec.$,
        null,
        this.keyChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keyChangeFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
        null,
        this.keyChangeFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keyDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        StorageAreaObserver_KeyDeleted_ParamsSpec.$,
        null,
        this.keyDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        StorageAreaObserver_AllDeleted_ParamsSpec.$,
        null,
        this.allDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.shouldSendOldValueOnMutations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
        null,
        this.shouldSendOldValueOnMutations.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class StorageAreaPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.StorageArea', scope);
  }
}

/** @interface */
export class StorageAreaInterface {
  
  /**
   * @param { !StorageAreaObserverRemote } observer
   */

  addObserver(observer) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } value
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  put(key, value, clientOldValue, source) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  delete(key, clientOldValue, source) {}
  
  /**
   * @param { !string } source
   * @param { ?StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteAll(source, newObserver) {}
  
  /**
   * @param { !Array<!number> } key
   * @return {!Promise<{
        success: !boolean,
        value: !Array<!number>,
   *  }>}
   */

  get(key) {}
  
  /**
   * @param { ?StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        data: !Array<!KeyValue>,
   *  }>}
   */

  getAll(newObserver) {}
}

/**
 * @implements { StorageAreaInterface }
 */
export class StorageAreaRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!StorageAreaPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StorageAreaPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!StorageAreaPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !StorageAreaObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        StorageArea_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } value
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  put(
      key,
      value,
      clientOldValue,
      source) {
    return this.proxy.sendMessage(
        1,
        StorageArea_Put_ParamsSpec.$,
        StorageArea_Put_ResponseParamsSpec.$,
        [
          key,
          value,
          clientOldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  delete(
      key,
      clientOldValue,
      source) {
    return this.proxy.sendMessage(
        2,
        StorageArea_Delete_ParamsSpec.$,
        StorageArea_Delete_ResponseParamsSpec.$,
        [
          key,
          clientOldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !string } source
   * @param { ?StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteAll(
      source,
      newObserver) {
    return this.proxy.sendMessage(
        3,
        StorageArea_DeleteAll_ParamsSpec.$,
        StorageArea_DeleteAll_ResponseParamsSpec.$,
        [
          source,
          newObserver
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @return {!Promise<{
        success: !boolean,
        value: !Array<!number>,
   *  }>}
   */

  get(
      key) {
    return this.proxy.sendMessage(
        4,
        StorageArea_Get_ParamsSpec.$,
        StorageArea_Get_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { ?StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        data: !Array<!KeyValue>,
   *  }>}
   */

  getAll(
      newObserver) {
    return this.proxy.sendMessage(
        5,
        StorageArea_GetAll_ParamsSpec.$,
        StorageArea_GetAll_ResponseParamsSpec.$,
        [
          newObserver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the StorageArea
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StorageAreaReceiver {
  /**
   * @param {!StorageAreaInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!StorageAreaRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StorageAreaRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StorageAreaRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StorageArea_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        StorageArea_Put_ParamsSpec.$,
        StorageArea_Put_ResponseParamsSpec.$,
        impl.put.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        StorageArea_Delete_ParamsSpec.$,
        StorageArea_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        StorageArea_DeleteAll_ParamsSpec.$,
        StorageArea_DeleteAll_ResponseParamsSpec.$,
        impl.deleteAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        StorageArea_Get_ParamsSpec.$,
        StorageArea_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        StorageArea_GetAll_ParamsSpec.$,
        StorageArea_GetAll_ResponseParamsSpec.$,
        impl.getAll.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StorageArea {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.StorageArea";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!StorageAreaRemote}
   */
  static getRemote() {
    let remote = new StorageAreaRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the StorageArea
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StorageAreaCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StorageAreaRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StorageAreaRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StorageArea_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.put =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        StorageArea_Put_ParamsSpec.$,
        StorageArea_Put_ResponseParamsSpec.$,
        this.put.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        StorageArea_Delete_ParamsSpec.$,
        StorageArea_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        StorageArea_DeleteAll_ParamsSpec.$,
        StorageArea_DeleteAll_ResponseParamsSpec.$,
        this.deleteAll.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        StorageArea_Get_ParamsSpec.$,
        StorageArea_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        StorageArea_GetAll_ParamsSpec.$,
        StorageArea_GetAll_ResponseParamsSpec.$,
        this.getAll.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAreaObserver_KeyChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAreaObserver_KeyChangeFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAreaObserver_KeyDeleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAreaObserver_AllDeleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_Put_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_Put_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_DeleteAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_DeleteAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_GetAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageArea_GetAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    KeyValueSpec.$,
    'KeyValue',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class KeyValue {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
    /** @type { !Array<!number> } */
    this.value;
  }
}



mojo.internal.Struct(
    StorageAreaObserver_KeyChanged_ParamsSpec.$,
    'StorageAreaObserver_KeyChanged_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newValue', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'oldValue', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class StorageAreaObserver_KeyChanged_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
    /** @type { !Array<!number> } */
    this.newValue;
    /** @type { (Array<!number>|undefined) } */
    this.oldValue;
    /** @type { !string } */
    this.source;
  }
}



mojo.internal.Struct(
    StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
    'StorageAreaObserver_KeyChangeFailed_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StorageAreaObserver_KeyChangeFailed_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
    /** @type { !string } */
    this.source;
  }
}



mojo.internal.Struct(
    StorageAreaObserver_KeyDeleted_ParamsSpec.$,
    'StorageAreaObserver_KeyDeleted_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'oldValue', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class StorageAreaObserver_KeyDeleted_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
    /** @type { (Array<!number>|undefined) } */
    this.oldValue;
    /** @type { !string } */
    this.source;
  }
}



mojo.internal.Struct(
    StorageAreaObserver_AllDeleted_ParamsSpec.$,
    'StorageAreaObserver_AllDeleted_Params',
    [
      mojo.internal.StructField(
        'wasNonempty', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StorageAreaObserver_AllDeleted_Params {
  constructor() {
    /** @type { !boolean } */
    this.wasNonempty;
    /** @type { !string } */
    this.source;
  }
}



mojo.internal.Struct(
    StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
    'StorageAreaObserver_ShouldSendOldValueOnMutations_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAreaObserver_ShouldSendOldValueOnMutations_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    StorageArea_AddObserver_ParamsSpec.$,
    'StorageArea_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(StorageAreaObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_AddObserver_Params {
  constructor() {
    /** @type { !StorageAreaObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    StorageArea_Put_ParamsSpec.$,
    'StorageArea_Put_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientOldValue', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class StorageArea_Put_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
    /** @type { !Array<!number> } */
    this.value;
    /** @type { (Array<!number>|undefined) } */
    this.clientOldValue;
    /** @type { !string } */
    this.source;
  }
}



mojo.internal.Struct(
    StorageArea_Put_ResponseParamsSpec.$,
    'StorageArea_Put_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_Put_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    StorageArea_Delete_ParamsSpec.$,
    'StorageArea_Delete_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientOldValue', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class StorageArea_Delete_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
    /** @type { (Array<!number>|undefined) } */
    this.clientOldValue;
    /** @type { !string } */
    this.source;
  }
}



mojo.internal.Struct(
    StorageArea_Delete_ResponseParamsSpec.$,
    'StorageArea_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_Delete_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    StorageArea_DeleteAll_ParamsSpec.$,
    'StorageArea_DeleteAll_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newObserver', 8,
        0,
        mojo.internal.InterfaceProxy(StorageAreaObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StorageArea_DeleteAll_Params {
  constructor() {
    /** @type { !string } */
    this.source;
    /** @type { (StorageAreaObserverRemote|undefined) } */
    this.newObserver;
  }
}



mojo.internal.Struct(
    StorageArea_DeleteAll_ResponseParamsSpec.$,
    'StorageArea_DeleteAll_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_DeleteAll_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    StorageArea_Get_ParamsSpec.$,
    'StorageArea_Get_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_Get_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.key;
  }
}



mojo.internal.Struct(
    StorageArea_Get_ResponseParamsSpec.$,
    'StorageArea_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StorageArea_Get_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !Array<!number> } */
    this.value;
  }
}



mojo.internal.Struct(
    StorageArea_GetAll_ParamsSpec.$,
    'StorageArea_GetAll_Params',
    [
      mojo.internal.StructField(
        'newObserver', 0,
        0,
        mojo.internal.InterfaceProxy(StorageAreaObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_GetAll_Params {
  constructor() {
    /** @type { (StorageAreaObserverRemote|undefined) } */
    this.newObserver;
  }
}



mojo.internal.Struct(
    StorageArea_GetAll_ResponseParamsSpec.$,
    'StorageArea_GetAll_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(KeyValueSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageArea_GetAll_ResponseParams {
  constructor() {
    /** @type { !Array<!KeyValue> } */
    this.data;
  }
}

