// third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', '../../../../../services/network/public/mojom/schemeful_site.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.js');
  }
  var permissions_policy_feature$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }


  var ReportingDestination = {};
  ReportingDestination.kBuyer = 0;
  ReportingDestination.kSeller = 1;
  ReportingDestination.kComponentSeller = 2;
  ReportingDestination.kSharedStorageSelectUrl = 3;
  ReportingDestination.kDirectSeller = 4;
  ReportingDestination.MIN_VALUE = 0;
  ReportingDestination.MAX_VALUE = 4;

  ReportingDestination.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ReportingDestination.toKnownEnumValue = function(value) {
    return value;
  };

  ReportingDestination.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DeprecatedFencedFrameMode = {};
  DeprecatedFencedFrameMode.kDefault = 0;
  DeprecatedFencedFrameMode.kOpaqueAds = 1;
  DeprecatedFencedFrameMode.MIN_VALUE = 0;
  DeprecatedFencedFrameMode.MAX_VALUE = 1;

  DeprecatedFencedFrameMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  DeprecatedFencedFrameMode.toKnownEnumValue = function(value) {
    return value;
  };

  DeprecatedFencedFrameMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Opaque = {};
  Opaque.kOpaque = 0;
  Opaque.MIN_VALUE = 0;
  Opaque.MAX_VALUE = 0;

  Opaque.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  Opaque.toKnownEnumValue = function(value) {
    return value;
  };

  Opaque.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AutomaticBeaconType = {};
  AutomaticBeaconType.kDeprecatedTopNavigation = 0;
  AutomaticBeaconType.kTopNavigationStart = 1;
  AutomaticBeaconType.kTopNavigationCommit = 2;
  AutomaticBeaconType.MIN_VALUE = 0;
  AutomaticBeaconType.MAX_VALUE = 2;

  AutomaticBeaconType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AutomaticBeaconType.toKnownEnumValue = function(value) {
    return value;
  };

  AutomaticBeaconType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AdAuctionData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdAuctionData.prototype.initDefaults_ = function() {
    this.interestGroupOwner = null;
    this.interestGroupName = null;
  };
  AdAuctionData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdAuctionData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionData.interestGroupOwner
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionData.interestGroupName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdAuctionData.encodedSize = codec.kStructHeaderSize + 16;

  AdAuctionData.decode = function(decoder) {
    var packed;
    var val = new AdAuctionData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.interestGroupOwner =
        decoder.decodeStructPointer(origin$.Origin);
    val.interestGroupName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AdAuctionData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdAuctionData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.interestGroupOwner);
    encoder.encodeStruct(codec.String, val.interestGroupName);
  };
  function URNConfigPair(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URNConfigPair.prototype.initDefaults_ = function() {
    this.urn = null;
    this.config = null;
  };
  URNConfigPair.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URNConfigPair.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URNConfigPair.urn
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URNConfigPair.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, FencedFrameConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URNConfigPair.encodedSize = codec.kStructHeaderSize + 16;

  URNConfigPair.decode = function(decoder) {
    var packed;
    var val = new URNConfigPair();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urn =
        decoder.decodeStructPointer(url$.Url);
    val.config =
        decoder.decodeStructPointer(FencedFrameConfig);
    return val;
  };

  URNConfigPair.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URNConfigPair.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.urn);
    encoder.encodeStructPointer(FencedFrameConfig, val.config);
  };
  function SharedStorageBudgetMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageBudgetMetadata.prototype.initDefaults_ = function() {
    this.site = null;
    this.budgetToCharge = 0;
    this.topNavigated = false;
  };
  SharedStorageBudgetMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageBudgetMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageBudgetMetadata.site
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SharedStorageBudgetMetadata.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageBudgetMetadata.decode = function(decoder) {
    var packed;
    var val = new SharedStorageBudgetMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.site =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    val.budgetToCharge =
        decoder.decodeStruct(codec.Double);
    packed = decoder.readUint8();
    val.topNavigated = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedStorageBudgetMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageBudgetMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.site);
    encoder.encodeStruct(codec.Double, val.budgetToCharge);
    packed = 0;
    packed |= (val.topNavigated & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ParentPermissionsInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ParentPermissionsInfo.prototype.initDefaults_ = function() {
    this.parsedPermissionsPolicy = null;
    this.origin = null;
  };
  ParentPermissionsInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ParentPermissionsInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ParentPermissionsInfo.parsedPermissionsPolicy
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ParentPermissionsInfo.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ParentPermissionsInfo.encodedSize = codec.kStructHeaderSize + 16;

  ParentPermissionsInfo.decode = function(decoder) {
    var packed;
    var val = new ParentPermissionsInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.parsedPermissionsPolicy =
        decoder.decodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration));
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  ParentPermissionsInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ParentPermissionsInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), val.parsedPermissionsPolicy);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
  };
  function FencedFrameConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FencedFrameConfig.prototype.initDefaults_ = function() {
    this.mappedUrl = null;
    this.containerSize = null;
    this.contentSize = null;
    this.deprecatedShouldFreezeInitialSize = null;
    this.adAuctionData = null;
    this.nestedConfigs = null;
    this.sharedStorageBudgetMetadata = null;
    this.urnUuid = null;
    this.mode = 0;
    this.effectiveEnabledPermissions = null;
    this.parentPermissionsInfo = null;
  };
  FencedFrameConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FencedFrameConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 152}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.mappedUrl
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, PotentiallyOpaqueURL, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.containerSize
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, PotentiallyOpaqueSize, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.contentSize
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 32, PotentiallyOpaqueSize, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.deprecatedShouldFreezeInitialSize
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 48, PotentiallyOpaqueBool, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.adAuctionData
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 64, PotentiallyOpaqueAdAuctionData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.nestedConfigs
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 80, PotentiallyOpaqueConfigVector, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.sharedStorageBudgetMetadata
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 96, PotentiallyOpaqueSharedStorageBudgetMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.urnUuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 120, DeprecatedFencedFrameMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.effectiveEnabledPermissions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 128, 4, new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameConfig.parentPermissionsInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, ParentPermissionsInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FencedFrameConfig.encodedSize = codec.kStructHeaderSize + 144;

  FencedFrameConfig.decode = function(decoder) {
    var packed;
    var val = new FencedFrameConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mappedUrl =
        decoder.decodeStruct(PotentiallyOpaqueURL);
    val.containerSize =
        decoder.decodeStruct(PotentiallyOpaqueSize);
    val.contentSize =
        decoder.decodeStruct(PotentiallyOpaqueSize);
    val.deprecatedShouldFreezeInitialSize =
        decoder.decodeStruct(PotentiallyOpaqueBool);
    val.adAuctionData =
        decoder.decodeStruct(PotentiallyOpaqueAdAuctionData);
    val.nestedConfigs =
        decoder.decodeStruct(PotentiallyOpaqueConfigVector);
    val.sharedStorageBudgetMetadata =
        decoder.decodeStruct(PotentiallyOpaqueSharedStorageBudgetMetadata);
    val.urnUuid =
        decoder.decodeStructPointer(url$.Url);
    val.mode =
        decoder.decodeStruct(new codec.Enum(DeprecatedFencedFrameMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.effectiveEnabledPermissions =
        decoder.decodeArrayPointer(new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature));
    val.parentPermissionsInfo =
        decoder.decodeStructPointer(ParentPermissionsInfo);
    return val;
  };

  FencedFrameConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FencedFrameConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(PotentiallyOpaqueURL, val.mappedUrl);
    encoder.encodeStruct(PotentiallyOpaqueSize, val.containerSize);
    encoder.encodeStruct(PotentiallyOpaqueSize, val.contentSize);
    encoder.encodeStruct(PotentiallyOpaqueBool, val.deprecatedShouldFreezeInitialSize);
    encoder.encodeStruct(PotentiallyOpaqueAdAuctionData, val.adAuctionData);
    encoder.encodeStruct(PotentiallyOpaqueConfigVector, val.nestedConfigs);
    encoder.encodeStruct(PotentiallyOpaqueSharedStorageBudgetMetadata, val.sharedStorageBudgetMetadata);
    encoder.encodeStructPointer(url$.Url, val.urnUuid);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature), val.effectiveEnabledPermissions);
    encoder.encodeStructPointer(ParentPermissionsInfo, val.parentPermissionsInfo);
  };
  function FencedFrameProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FencedFrameProperties.prototype.initDefaults_ = function() {
    this.mappedUrl = null;
    this.containerSize = null;
    this.contentSize = null;
    this.deprecatedShouldFreezeInitialSize = null;
    this.adAuctionData = null;
    this.nestedUrnConfigPairs = null;
    this.sharedStorageBudgetMetadata = null;
    this.mode = 0;
    this.canDisableUntrustedNetwork = false;
    this.isCrossOriginContent = false;
    this.allowCrossOriginEventReporting = false;
    this.effectiveEnabledPermissions = null;
    this.parentPermissionsInfo = null;
  };
  FencedFrameProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FencedFrameProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.mappedUrl
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, PotentiallyOpaqueURL, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.containerSize
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, PotentiallyOpaqueSize, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.contentSize
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 32, PotentiallyOpaqueSize, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.deprecatedShouldFreezeInitialSize
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 48, PotentiallyOpaqueBool, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.adAuctionData
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 64, PotentiallyOpaqueAdAuctionData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.nestedUrnConfigPairs
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 80, PotentiallyOpaqueURNConfigVector, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.sharedStorageBudgetMetadata
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 96, PotentiallyOpaqueSharedStorageBudgetMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 112, DeprecatedFencedFrameMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.effectiveEnabledPermissions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 120, 4, new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameProperties.parentPermissionsInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, ParentPermissionsInfo, true);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  FencedFrameProperties.encodedSize = codec.kStructHeaderSize + 136;

  FencedFrameProperties.decode = function(decoder) {
    var packed;
    var val = new FencedFrameProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mappedUrl =
        decoder.decodeStruct(PotentiallyOpaqueURL);
    val.containerSize =
        decoder.decodeStruct(PotentiallyOpaqueSize);
    val.contentSize =
        decoder.decodeStruct(PotentiallyOpaqueSize);
    val.deprecatedShouldFreezeInitialSize =
        decoder.decodeStruct(PotentiallyOpaqueBool);
    val.adAuctionData =
        decoder.decodeStruct(PotentiallyOpaqueAdAuctionData);
    val.nestedUrnConfigPairs =
        decoder.decodeStruct(PotentiallyOpaqueURNConfigVector);
    val.sharedStorageBudgetMetadata =
        decoder.decodeStruct(PotentiallyOpaqueSharedStorageBudgetMetadata);
    val.mode =
        decoder.decodeStruct(new codec.Enum(DeprecatedFencedFrameMode));
    packed = decoder.readUint8();
    val.canDisableUntrustedNetwork = (packed >> 0) & 1 ? true : false;
    val.isCrossOriginContent = (packed >> 1) & 1 ? true : false;
    val.allowCrossOriginEventReporting = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.effectiveEnabledPermissions =
        decoder.decodeArrayPointer(new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature));
    val.parentPermissionsInfo =
        decoder.decodeStructPointer(ParentPermissionsInfo);
    return val;
  };

  FencedFrameProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FencedFrameProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(PotentiallyOpaqueURL, val.mappedUrl);
    encoder.encodeStruct(PotentiallyOpaqueSize, val.containerSize);
    encoder.encodeStruct(PotentiallyOpaqueSize, val.contentSize);
    encoder.encodeStruct(PotentiallyOpaqueBool, val.deprecatedShouldFreezeInitialSize);
    encoder.encodeStruct(PotentiallyOpaqueAdAuctionData, val.adAuctionData);
    encoder.encodeStruct(PotentiallyOpaqueURNConfigVector, val.nestedUrnConfigPairs);
    encoder.encodeStruct(PotentiallyOpaqueSharedStorageBudgetMetadata, val.sharedStorageBudgetMetadata);
    encoder.encodeStruct(codec.Int32, val.mode);
    packed = 0;
    packed |= (val.canDisableUntrustedNetwork & 1) << 0
    packed |= (val.isCrossOriginContent & 1) << 1
    packed |= (val.allowCrossOriginEventReporting & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature), val.effectiveEnabledPermissions);
    encoder.encodeStructPointer(ParentPermissionsInfo, val.parentPermissionsInfo);
  };

  function PotentiallyOpaqueURL(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueURL.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueURL.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueURL.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueURL member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueURL.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueURL.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueURL.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueURL.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueURL.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueURL.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueURL.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueURL.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueURL.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueURL.Tags.transparent:
          encoder.encodeStructPointer(url$.Url, val.transparent);
          break;
        case PotentiallyOpaqueURL.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueURL.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueURL();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueURL.Tags.transparent:
          result.transparent = decoder.decodeStructPointer(url$.Url);
          break;
        case PotentiallyOpaqueURL.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueURL.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueURL.Tags.transparent:
          

    // validate PotentiallyOpaqueURL.transparent
    err = messageValidator.validateStructPointer(data_offset, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PotentiallyOpaqueURL.Tags.opaque:
          

    // validate PotentiallyOpaqueURL.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueURL.encodedSize = 16;

  function PotentiallyOpaqueSize(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueSize.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueSize.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueSize.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueSize member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueSize.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueSize.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueSize.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueSize.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueSize.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueSize.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueSize.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueSize.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueSize.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueSize.Tags.transparent:
          encoder.encodeStructPointer(geometry$.Size, val.transparent);
          break;
        case PotentiallyOpaqueSize.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueSize.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueSize();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueSize.Tags.transparent:
          result.transparent = decoder.decodeStructPointer(geometry$.Size);
          break;
        case PotentiallyOpaqueSize.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueSize.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueSize.Tags.transparent:
          

    // validate PotentiallyOpaqueSize.transparent
    err = messageValidator.validateStructPointer(data_offset, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PotentiallyOpaqueSize.Tags.opaque:
          

    // validate PotentiallyOpaqueSize.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueSize.encodedSize = 16;

  function PotentiallyOpaqueBool(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueBool.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueBool.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueBool.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueBool member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueBool.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueBool.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueBool.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueBool.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueBool.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueBool.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueBool.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueBool.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueBool.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueBool.Tags.transparent:
          encoder.writeUint8(val.transparent ? 1 : 0);
          break;
        case PotentiallyOpaqueBool.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueBool.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueBool();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueBool.Tags.transparent:
          result.transparent = decoder.readUint8() ? true : false;
          break;
        case PotentiallyOpaqueBool.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueBool.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueBool.Tags.transparent:
          

          break;
        case PotentiallyOpaqueBool.Tags.opaque:
          

    // validate PotentiallyOpaqueBool.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueBool.encodedSize = 16;

  function PotentiallyOpaqueAdAuctionData(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueAdAuctionData.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueAdAuctionData.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueAdAuctionData.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueAdAuctionData member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueAdAuctionData.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueAdAuctionData.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueAdAuctionData.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueAdAuctionData.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueAdAuctionData.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueAdAuctionData.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueAdAuctionData.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueAdAuctionData.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueAdAuctionData.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueAdAuctionData.Tags.transparent:
          encoder.encodeStructPointer(AdAuctionData, val.transparent);
          break;
        case PotentiallyOpaqueAdAuctionData.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueAdAuctionData.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueAdAuctionData();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueAdAuctionData.Tags.transparent:
          result.transparent = decoder.decodeStructPointer(AdAuctionData);
          break;
        case PotentiallyOpaqueAdAuctionData.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueAdAuctionData.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueAdAuctionData.Tags.transparent:
          

    // validate PotentiallyOpaqueAdAuctionData.transparent
    err = messageValidator.validateStructPointer(data_offset, AdAuctionData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PotentiallyOpaqueAdAuctionData.Tags.opaque:
          

    // validate PotentiallyOpaqueAdAuctionData.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueAdAuctionData.encodedSize = 16;

  function PotentiallyOpaqueConfigVector(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueConfigVector.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueConfigVector.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueConfigVector.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueConfigVector member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueConfigVector.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueConfigVector.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueConfigVector.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueConfigVector.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueConfigVector.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueConfigVector.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueConfigVector.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueConfigVector.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueConfigVector.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueConfigVector.Tags.transparent:
          encoder.encodeArrayPointer(new codec.PointerTo(FencedFrameConfig), val.transparent);
          break;
        case PotentiallyOpaqueConfigVector.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueConfigVector.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueConfigVector();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueConfigVector.Tags.transparent:
          result.transparent = decoder.decodeArrayPointer(new codec.PointerTo(FencedFrameConfig));
          break;
        case PotentiallyOpaqueConfigVector.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueConfigVector.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueConfigVector.Tags.transparent:
          

    // validate PotentiallyOpaqueConfigVector.transparent
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(FencedFrameConfig), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PotentiallyOpaqueConfigVector.Tags.opaque:
          

    // validate PotentiallyOpaqueConfigVector.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueConfigVector.encodedSize = 16;

  function PotentiallyOpaqueURNConfigVector(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueURNConfigVector.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueURNConfigVector.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueURNConfigVector.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueURNConfigVector member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueURNConfigVector.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueURNConfigVector.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueURNConfigVector.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueURNConfigVector.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueURNConfigVector.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueURNConfigVector.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueURNConfigVector.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueURNConfigVector.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueURNConfigVector.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueURNConfigVector.Tags.transparent:
          encoder.encodeArrayPointer(new codec.PointerTo(URNConfigPair), val.transparent);
          break;
        case PotentiallyOpaqueURNConfigVector.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueURNConfigVector.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueURNConfigVector();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueURNConfigVector.Tags.transparent:
          result.transparent = decoder.decodeArrayPointer(new codec.PointerTo(URNConfigPair));
          break;
        case PotentiallyOpaqueURNConfigVector.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueURNConfigVector.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueURNConfigVector.Tags.transparent:
          

    // validate PotentiallyOpaqueURNConfigVector.transparent
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(URNConfigPair), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PotentiallyOpaqueURNConfigVector.Tags.opaque:
          

    // validate PotentiallyOpaqueURNConfigVector.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueURNConfigVector.encodedSize = 16;

  function PotentiallyOpaqueSharedStorageBudgetMetadata(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PotentiallyOpaqueSharedStorageBudgetMetadata.Tags = {
    transparent: 0,
    opaque: 1,
  };

  PotentiallyOpaqueSharedStorageBudgetMetadata.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PotentiallyOpaqueSharedStorageBudgetMetadata.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transparent",
        "opaque",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PotentiallyOpaqueSharedStorageBudgetMetadata member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PotentiallyOpaqueSharedStorageBudgetMetadata.prototype, "transparent", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.transparent) {
        throw new ReferenceError(
            "PotentiallyOpaqueSharedStorageBudgetMetadata.transparent is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.transparent;
      this.$data = value;
    }
  });
  Object.defineProperty(PotentiallyOpaqueSharedStorageBudgetMetadata.prototype, "opaque", {
    get: function() {
      if (this.$tag != PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.opaque) {
        throw new ReferenceError(
            "PotentiallyOpaqueSharedStorageBudgetMetadata.opaque is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.opaque;
      this.$data = value;
    }
  });


    PotentiallyOpaqueSharedStorageBudgetMetadata.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.transparent:
          encoder.encodeStructPointer(SharedStorageBudgetMetadata, val.transparent);
          break;
        case PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.opaque:
          encoder.encodeStruct(codec.Int32, val.opaque);
          break;
      }
      encoder.align();
    };


    PotentiallyOpaqueSharedStorageBudgetMetadata.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PotentiallyOpaqueSharedStorageBudgetMetadata();
      var tag = decoder.readUint32();
      switch (tag) {
        case PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.transparent:
          result.transparent = decoder.decodeStructPointer(SharedStorageBudgetMetadata);
          break;
        case PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.opaque:
          result.opaque = decoder.decodeStruct(new codec.Enum(Opaque));
          break;
      }
      decoder.align();

      return result;
    };


    PotentiallyOpaqueSharedStorageBudgetMetadata.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.transparent:
          

    // validate PotentiallyOpaqueSharedStorageBudgetMetadata.transparent
    err = messageValidator.validateStructPointer(data_offset, SharedStorageBudgetMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PotentiallyOpaqueSharedStorageBudgetMetadata.Tags.opaque:
          

    // validate PotentiallyOpaqueSharedStorageBudgetMetadata.opaque
    err = messageValidator.validateEnum(data_offset, Opaque);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PotentiallyOpaqueSharedStorageBudgetMetadata.encodedSize = 16;
  exports.ReportingDestination = ReportingDestination;
  exports.DeprecatedFencedFrameMode = DeprecatedFencedFrameMode;
  exports.Opaque = Opaque;
  exports.AutomaticBeaconType = AutomaticBeaconType;
  exports.AdAuctionData = AdAuctionData;
  exports.URNConfigPair = URNConfigPair;
  exports.SharedStorageBudgetMetadata = SharedStorageBudgetMetadata;
  exports.ParentPermissionsInfo = ParentPermissionsInfo;
  exports.FencedFrameConfig = FencedFrameConfig;
  exports.FencedFrameProperties = FencedFrameProperties;
  exports.PotentiallyOpaqueURL = PotentiallyOpaqueURL;
  exports.PotentiallyOpaqueSize = PotentiallyOpaqueSize;
  exports.PotentiallyOpaqueBool = PotentiallyOpaqueBool;
  exports.PotentiallyOpaqueAdAuctionData = PotentiallyOpaqueAdAuctionData;
  exports.PotentiallyOpaqueConfigVector = PotentiallyOpaqueConfigVector;
  exports.PotentiallyOpaqueURNConfigVector = PotentiallyOpaqueURNConfigVector;
  exports.PotentiallyOpaqueSharedStorageBudgetMetadata = PotentiallyOpaqueSharedStorageBudgetMetadata;
})();