// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RequestContextTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RequestContextType = {
  
  UNSPECIFIED: 0,
  ATTRIBUTION_SRC: 1,
  AUDIO: 2,
  BEACON: 3,
  CSP_REPORT: 4,
  DOWNLOAD: 5,
  EMBED: 6,
  EVENT_SOURCE: 7,
  FAVICON: 8,
  FETCH: 9,
  FONT: 10,
  FORM: 11,
  FRAME: 12,
  HYPERLINK: 13,
  IFRAME: 14,
  IMAGE: 15,
  IMAGE_SET: 16,
  INTERNAL: 17,
  JSON: 18,
  LOCATION: 19,
  MANIFEST: 20,
  OBJECT: 21,
  PING: 22,
  PLUGIN: 23,
  PREFETCH: 24,
  SCRIPT: 25,
  SERVICE_WORKER: 26,
  SHARED_WORKER: 27,
  SPECULATION_RULES: 28,
  SUBRESOURCE: 29,
  SUBRESOURCE_WEBBUNDLE: 30,
  STYLE: 31,
  TRACK: 32,
  VIDEO: 33,
  WORKER: 34,
  XML_HTTP_REQUEST: 35,
  XSLT: 36,
  MIN_VALUE: 0,
  MAX_VALUE: 36,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FetchCacheModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FetchCacheMode = {
  
  kDefault: 0,
  kNoStore: 1,
  kBypassCache: 2,
  kValidateCache: 3,
  kForceCache: 4,
  kOnlyIfCached: 5,
  kUnspecifiedOnlyIfCachedStrict: 6,
  kUnspecifiedForceCacheMiss: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FetchPriorityHintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FetchPriorityHint = {
  
  kLow: 0,
  kAuto: 1,
  kHigh: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};




/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchAPIRequestHeadersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchAPIRequestBodySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchAPIRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FetchAPIRequestHeadersSpec.$,
    'FetchAPIRequestHeaders',
    [
      mojo.internal.StructField(
        'headers', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FetchAPIRequestHeaders = class {
  constructor() {
    /** @export { !Object<!string, !string> } */
    this.headers;
  }
};



mojo.internal.Struct(
    blink.mojom.FetchAPIRequestBodySpec.$,
    'FetchAPIRequestBody',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(network.mojom.DataElementSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'identifier', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'containsSensitiveInfo', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FetchAPIRequestBody = class {
  constructor() {
    /** @export { !Array<!network.mojom.DataElement> } */
    this.elements;
    /** @export { !bigint } */
    this.identifier;
    /** @export { !boolean } */
    this.containsSensitiveInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.FetchAPIRequestSpec.$,
    'FetchAPIRequest',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        network.mojom.RequestModeSpec.$,
        network.mojom.RequestMode.kNoCors,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isMainResourceLoad', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destination', 8,
        0,
        network.mojom.RequestDestinationSpec.$,
        network.mojom.RequestDestination.kEmpty,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameType', 12,
        0,
        blink.mojom.RequestContextFrameTypeSpec.$,
        blink.mojom.RequestContextFrameType.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 32,
        0,
        blink.mojom.FetchAPIRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blob', 40,
        0,
        blink.mojom.SerializedBlobSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'body', 48,
        0,
        blink.mojom.FetchAPIRequestBodySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestInitiator', 56,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationRedirectChain', 64,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 72,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentialsMode', 80,
        0,
        network.mojom.CredentialsModeSpec.$,
        network.mojom.CredentialsMode.kOmit,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheMode', 84,
        0,
        blink.mojom.FetchCacheModeSpec.$,
        blink.mojom.FetchCacheMode.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectMode', 88,
        0,
        network.mojom.RedirectModeSpec.$,
        network.mojom.RedirectMode.kFollow,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'integrity', 96,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 92,
        0,
        network.mojom.RequestPrioritySpec.$,
        network.mojom.RequestPriority.kIdle,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchWindowId', 104,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keepalive', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isReload', 4,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isHistoryNavigation', 4,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsStackId', 112,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 120,
        0,
        network.mojom.TrustTokenParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetAddressSpace', 128,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        network.mojom.IPAddressSpace.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributionReportingEligibility', 132,
        0,
        network.mojom.AttributionReportingEligibilitySpec.$,
        network.mojom.AttributionReportingEligibility.kUnset,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributionReportingSupport', 136,
        0,
        network.mojom.AttributionSupportSpec.$,
        network.mojom.AttributionSupport.kUnset,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerRaceNetworkRequestToken', 144,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 160],]);





/** @record */
blink.mojom.FetchAPIRequest = class {
  constructor() {
    /** @export { !network.mojom.RequestMode } */
    this.mode;
    /** @export { !boolean } */
    this.isMainResourceLoad;
    /** @export { !network.mojom.RequestDestination } */
    this.destination;
    /** @export { !blink.mojom.RequestContextFrameType } */
    this.frameType;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.method;
    /** @export { !blink.mojom.FetchAPIRequestHeaders } */
    this.headers;
    /** @export { (blink.mojom.SerializedBlob|undefined) } */
    this.blob;
    /** @export { (blink.mojom.FetchAPIRequestBody|undefined) } */
    this.body;
    /** @export { (url.mojom.Origin|undefined) } */
    this.requestInitiator;
    /** @export { !Array<!url.mojom.Url> } */
    this.navigationRedirectChain;
    /** @export { (blink.mojom.Referrer|undefined) } */
    this.referrer;
    /** @export { !network.mojom.CredentialsMode } */
    this.credentialsMode;
    /** @export { !blink.mojom.FetchCacheMode } */
    this.cacheMode;
    /** @export { !network.mojom.RedirectMode } */
    this.redirectMode;
    /** @export { (string|undefined) } */
    this.integrity;
    /** @export { !network.mojom.RequestPriority } */
    this.priority;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.fetchWindowId;
    /** @export { !boolean } */
    this.keepalive;
    /** @export { !boolean } */
    this.isReload;
    /** @export { !boolean } */
    this.isHistoryNavigation;
    /** @export { (string|undefined) } */
    this.devtoolsStackId;
    /** @export { (network.mojom.TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @export { !network.mojom.IPAddressSpace } */
    this.targetAddressSpace;
    /** @export { !network.mojom.AttributionReportingEligibility } */
    this.attributionReportingEligibility;
    /** @export { !network.mojom.AttributionSupport } */
    this.attributionReportingSupport;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.serviceWorkerRaceNetworkRequestToken;
  }
};

