// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_system_access_cloud_identifier$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom', 'file_system_access_cloud_identifier.mojom.js');
  }
  var file_system_access_error$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom', 'file_system_access_error.mojom.js');
  }
  var file_system_access_file_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom', 'file_system_access_file_handle.mojom.js');
  }
  var file_system_access_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom', 'file_system_access_transfer_token.mojom.js');
  }
  var file_system_access_permission_mode$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom', 'file_system_access_permission_mode.mojom.js');
  }
  var permission_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions/permission_status.mojom', '../permissions/permission_status.mojom.js');
  }



  function FileSystemAccessEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessEntry.prototype.initDefaults_ = function() {
    this.entryHandle = null;
    this.name = null;
  };
  FileSystemAccessEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessEntry.entryHandle
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, FileSystemAccessHandle, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessEntry.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessEntry.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessEntry.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entryHandle =
        decoder.decodeStruct(FileSystemAccessHandle);
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(FileSystemAccessHandle, val.entryHandle);
    encoder.encodeStruct(codec.String, val.name);
  };
  function FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.prototype.initDefaults_ = function() {
    this.result = null;
    this.entries = null;
    this.hasMoreEntries = false;
  };
  FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.entries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(FileSystemAccessEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.entries =
        decoder.decodeArrayPointer(new codec.PointerTo(FileSystemAccessEntry));
    packed = decoder.readUint8();
    val.hasMoreEntries = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeArrayPointer(new codec.PointerTo(FileSystemAccessEntry), val.entries);
    packed = 0;
    packed |= (val.hasMoreEntries & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_GetPermissionStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_system_access_permission_mode$.FileSystemAccessPermissionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetPermissionStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(file_system_access_permission_mode$.FileSystemAccessPermissionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_RequestPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_RequestPermission_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  FileSystemAccessDirectoryHandle_RequestPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_RequestPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_RequestPermission_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_system_access_permission_mode$.FileSystemAccessPermissionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_RequestPermission_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_RequestPermission_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_RequestPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(file_system_access_permission_mode$.FileSystemAccessPermissionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_RequestPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_RequestPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.status = 0;
  };
  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_GetFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetFile_Params.prototype.initDefaults_ = function() {
    this.basename = null;
    this.create = false;
  };
  FileSystemAccessDirectoryHandle_GetFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetFile_Params.basename
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetFile_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_GetFile_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.basename =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.create = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_GetFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.basename);
    packed = 0;
    packed |= (val.create & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_GetFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetFile_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.file = new file_system_access_file_handle$.FileSystemAccessFileHandlePtr();
  };
  FileSystemAccessDirectoryHandle_GetFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetFile_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetFile_ResponseParams.file
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_GetFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.file =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_file_handle$.FileSystemAccessFileHandlePtr));
    return val;
  };

  FileSystemAccessDirectoryHandle_GetFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_file_handle$.FileSystemAccessFileHandlePtr), val.file);
  };
  function FileSystemAccessDirectoryHandle_GetDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetDirectory_Params.prototype.initDefaults_ = function() {
    this.basename = null;
    this.create = false;
  };
  FileSystemAccessDirectoryHandle_GetDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetDirectory_Params.basename
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetDirectory_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_GetDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.basename =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.create = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_GetDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetDirectory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.basename);
    packed = 0;
    packed |= (val.create & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.directory = new FileSystemAccessDirectoryHandlePtr();
  };
  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.directory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.directory =
        decoder.decodeStruct(new codec.NullableInterface(FileSystemAccessDirectoryHandlePtr));
    return val;
  };

  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(FileSystemAccessDirectoryHandlePtr), val.directory);
  };
  function FileSystemAccessDirectoryHandle_GetEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetEntries_Params.prototype.initDefaults_ = function() {
    this.listener = new FileSystemAccessDirectoryEntriesListenerPtr();
  };
  FileSystemAccessDirectoryHandle_GetEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetEntries_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetEntries_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_GetEntries_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(new codec.Interface(FileSystemAccessDirectoryEntriesListenerPtr));
    return val;
  };

  FileSystemAccessDirectoryHandle_GetEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetEntries_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(FileSystemAccessDirectoryEntriesListenerPtr), val.listener);
  };
  function FileSystemAccessDirectoryHandle_Rename_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Rename_Params.prototype.initDefaults_ = function() {
    this.newEntryName = null;
  };
  FileSystemAccessDirectoryHandle_Rename_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Rename_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Rename_Params.newEntryName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Rename_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Rename_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Rename_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newEntryName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessDirectoryHandle_Rename_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Rename_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.newEntryName);
  };
  function FileSystemAccessDirectoryHandle_Rename_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Rename_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessDirectoryHandle_Rename_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Rename_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Rename_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Rename_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Rename_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Rename_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessDirectoryHandle_Rename_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Rename_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessDirectoryHandle_Move_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Move_Params.prototype.initDefaults_ = function() {
    this.destinationDirectory = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
    this.newEntryName = null;
  };
  FileSystemAccessDirectoryHandle_Move_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Move_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Move_Params.destinationDirectory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Move_Params.newEntryName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Move_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_Move_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Move_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.destinationDirectory =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    val.newEntryName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessDirectoryHandle_Move_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Move_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.destinationDirectory);
    encoder.encodeStruct(codec.String, val.newEntryName);
  };
  function FileSystemAccessDirectoryHandle_Move_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Move_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessDirectoryHandle_Move_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Move_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Move_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Move_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Move_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Move_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessDirectoryHandle_Move_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Move_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessDirectoryHandle_Remove_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Remove_Params.prototype.initDefaults_ = function() {
    this.recurse = false;
  };
  FileSystemAccessDirectoryHandle_Remove_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Remove_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Remove_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Remove_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Remove_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.recurse = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_Remove_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Remove_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.recurse & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_Remove_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Remove_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessDirectoryHandle_Remove_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Remove_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Remove_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Remove_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Remove_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Remove_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessDirectoryHandle_Remove_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Remove_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessDirectoryHandle_RemoveEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_RemoveEntry_Params.prototype.initDefaults_ = function() {
    this.basename = null;
    this.recurse = false;
  };
  FileSystemAccessDirectoryHandle_RemoveEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_RemoveEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_RemoveEntry_Params.basename
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_RemoveEntry_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_RemoveEntry_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_RemoveEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.basename =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.recurse = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_RemoveEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_RemoveEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.basename);
    packed = 0;
    packed |= (val.recurse & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessDirectoryHandle_Resolve_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Resolve_Params.prototype.initDefaults_ = function() {
    this.possibleChild = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
  };
  FileSystemAccessDirectoryHandle_Resolve_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Resolve_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Resolve_Params.possibleChild
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Resolve_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Resolve_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Resolve_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.possibleChild =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    return val;
  };

  FileSystemAccessDirectoryHandle_Resolve_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Resolve_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.possibleChild);
  };
  function FileSystemAccessDirectoryHandle_Resolve_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Resolve_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.path = null;
  };
  FileSystemAccessDirectoryHandle_Resolve_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Resolve_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Resolve_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Resolve_ResponseParams.path
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Resolve_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_Resolve_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Resolve_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.path =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  FileSystemAccessDirectoryHandle_Resolve_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Resolve_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeArrayPointer(codec.String, val.path);
  };
  function FileSystemAccessDirectoryHandle_Transfer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_Transfer_Params.prototype.initDefaults_ = function() {
    this.token = new bindings.InterfaceRequest();
  };
  FileSystemAccessDirectoryHandle_Transfer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_Transfer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_Transfer_Params.token
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_Transfer_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDirectoryHandle_Transfer_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_Transfer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDirectoryHandle_Transfer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_Transfer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessDirectoryHandle_GetUniqueId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetUniqueId_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessDirectoryHandle_GetUniqueId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetUniqueId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetUniqueId_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessDirectoryHandle_GetUniqueId_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetUniqueId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessDirectoryHandle_GetUniqueId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetUniqueId_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.id = null;
  };
  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(codec.String, val.id);
  };
  function FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.cloudIdentifiers = null;
  };
  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.cloudIdentifiers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(file_system_access_cloud_identifier$.FileSystemAccessCloudIdentifier), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.cloudIdentifiers =
        decoder.decodeArrayPointer(new codec.PointerTo(file_system_access_cloud_identifier$.FileSystemAccessCloudIdentifier));
    return val;
  };

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeArrayPointer(new codec.PointerTo(file_system_access_cloud_identifier$.FileSystemAccessCloudIdentifier), val.cloudIdentifiers);
  };

  function FileSystemAccessHandle(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  FileSystemAccessHandle.Tags = {
    file: 0,
    directory: 1,
  };

  FileSystemAccessHandle.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  FileSystemAccessHandle.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "file",
        "directory",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a FileSystemAccessHandle member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(FileSystemAccessHandle.prototype, "file", {
    get: function() {
      if (this.$tag != FileSystemAccessHandle.Tags.file) {
        throw new ReferenceError(
            "FileSystemAccessHandle.file is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessHandle.Tags.file;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessHandle.prototype, "directory", {
    get: function() {
      if (this.$tag != FileSystemAccessHandle.Tags.directory) {
        throw new ReferenceError(
            "FileSystemAccessHandle.directory is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessHandle.Tags.directory;
      this.$data = value;
    }
  });


    FileSystemAccessHandle.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case FileSystemAccessHandle.Tags.file:
          encoder.encodeStruct(new codec.Interface(file_system_access_file_handle$.FileSystemAccessFileHandlePtr), val.file);
          break;
        case FileSystemAccessHandle.Tags.directory:
          encoder.encodeStruct(new codec.Interface(FileSystemAccessDirectoryHandlePtr), val.directory);
          break;
      }
      encoder.align();
    };


    FileSystemAccessHandle.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new FileSystemAccessHandle();
      var tag = decoder.readUint32();
      switch (tag) {
        case FileSystemAccessHandle.Tags.file:
          result.file = decoder.decodeStruct(new codec.Interface(file_system_access_file_handle$.FileSystemAccessFileHandlePtr));
          break;
        case FileSystemAccessHandle.Tags.directory:
          result.directory = decoder.decodeStruct(new codec.Interface(FileSystemAccessDirectoryHandlePtr));
          break;
      }
      decoder.align();

      return result;
    };


    FileSystemAccessHandle.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case FileSystemAccessHandle.Tags.file:
          

    // validate FileSystemAccessHandle.file
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessHandle.Tags.directory:
          

    // validate FileSystemAccessHandle.directory
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  FileSystemAccessHandle.encodedSize = 16;
  var kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name = 0;

  function FileSystemAccessDirectoryEntriesListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessDirectoryEntriesListener,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessDirectoryEntriesListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessDirectoryEntriesListener, associatedInterfacePtrInfo);
  }

  FileSystemAccessDirectoryEntriesListenerAssociatedPtr.prototype =
      Object.create(FileSystemAccessDirectoryEntriesListenerPtr.prototype);
  FileSystemAccessDirectoryEntriesListenerAssociatedPtr.prototype.constructor =
      FileSystemAccessDirectoryEntriesListenerAssociatedPtr;

  function FileSystemAccessDirectoryEntriesListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessDirectoryEntriesListenerPtr.prototype.didReadDirectory = function() {
    return FileSystemAccessDirectoryEntriesListenerProxy.prototype.didReadDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryEntriesListenerProxy.prototype.didReadDirectory = function(result, entries, hasMoreEntries) {
    var params_ = new FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params();
    params_.result = result;
    params_.entries = entries;
    params_.hasMoreEntries = hasMoreEntries;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name,
        codec.align(FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FileSystemAccessDirectoryEntriesListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessDirectoryEntriesListenerStub.prototype.didReadDirectory = function(result, entries, hasMoreEntries) {
    return this.delegate_ && this.delegate_.didReadDirectory && this.delegate_.didReadDirectory(result, entries, hasMoreEntries);
  }

  FileSystemAccessDirectoryEntriesListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params);
      this.didReadDirectory(params.result, params.entries, params.hasMoreEntries);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessDirectoryEntriesListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFileSystemAccessDirectoryEntriesListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessDirectoryEntriesListener_DidReadDirectory_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessDirectoryEntriesListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FileSystemAccessDirectoryEntriesListener = {
    name: 'blink.mojom.FileSystemAccessDirectoryEntriesListener',
    kVersion: 0,
    ptrClass: FileSystemAccessDirectoryEntriesListenerPtr,
    proxyClass: FileSystemAccessDirectoryEntriesListenerProxy,
    stubClass: FileSystemAccessDirectoryEntriesListenerStub,
    validateRequest: validateFileSystemAccessDirectoryEntriesListenerRequest,
    validateResponse: null,
  };
  FileSystemAccessDirectoryEntriesListenerStub.prototype.validator = validateFileSystemAccessDirectoryEntriesListenerRequest;
  FileSystemAccessDirectoryEntriesListenerProxy.prototype.validator = null;
  var kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name = 0;
  var kFileSystemAccessDirectoryHandle_RequestPermission_Name = 1;
  var kFileSystemAccessDirectoryHandle_GetFile_Name = 2;
  var kFileSystemAccessDirectoryHandle_GetDirectory_Name = 3;
  var kFileSystemAccessDirectoryHandle_GetEntries_Name = 4;
  var kFileSystemAccessDirectoryHandle_Rename_Name = 5;
  var kFileSystemAccessDirectoryHandle_Move_Name = 6;
  var kFileSystemAccessDirectoryHandle_Remove_Name = 7;
  var kFileSystemAccessDirectoryHandle_RemoveEntry_Name = 8;
  var kFileSystemAccessDirectoryHandle_Resolve_Name = 9;
  var kFileSystemAccessDirectoryHandle_Transfer_Name = 10;
  var kFileSystemAccessDirectoryHandle_GetUniqueId_Name = 11;
  var kFileSystemAccessDirectoryHandle_GetCloudIdentifiers_Name = 12;

  function FileSystemAccessDirectoryHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessDirectoryHandle,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessDirectoryHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessDirectoryHandle, associatedInterfacePtrInfo);
  }

  FileSystemAccessDirectoryHandleAssociatedPtr.prototype =
      Object.create(FileSystemAccessDirectoryHandlePtr.prototype);
  FileSystemAccessDirectoryHandleAssociatedPtr.prototype.constructor =
      FileSystemAccessDirectoryHandleAssociatedPtr;

  function FileSystemAccessDirectoryHandleProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessDirectoryHandlePtr.prototype.getPermissionStatus = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.getPermissionStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.getPermissionStatus = function(mode) {
    var params_ = new FileSystemAccessDirectoryHandle_GetPermissionStatus_Params();
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name,
          codec.align(FileSystemAccessDirectoryHandle_GetPermissionStatus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_GetPermissionStatus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.requestPermission = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.requestPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.requestPermission = function(mode) {
    var params_ = new FileSystemAccessDirectoryHandle_RequestPermission_Params();
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_RequestPermission_Name,
          codec.align(FileSystemAccessDirectoryHandle_RequestPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_RequestPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.getFile = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.getFile
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.getFile = function(basename, create) {
    var params_ = new FileSystemAccessDirectoryHandle_GetFile_Params();
    params_.basename = basename;
    params_.create = create;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_GetFile_Name,
          codec.align(FileSystemAccessDirectoryHandle_GetFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_GetFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_GetFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.getDirectory = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.getDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.getDirectory = function(basename, create) {
    var params_ = new FileSystemAccessDirectoryHandle_GetDirectory_Params();
    params_.basename = basename;
    params_.create = create;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_GetDirectory_Name,
          codec.align(FileSystemAccessDirectoryHandle_GetDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_GetDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.getEntries = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.getEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.getEntries = function(listener) {
    var params_ = new FileSystemAccessDirectoryHandle_GetEntries_Params();
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessDirectoryHandle_GetEntries_Name,
        codec.align(FileSystemAccessDirectoryHandle_GetEntries_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessDirectoryHandle_GetEntries_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FileSystemAccessDirectoryHandlePtr.prototype.rename = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.rename
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.rename = function(newEntryName) {
    var params_ = new FileSystemAccessDirectoryHandle_Rename_Params();
    params_.newEntryName = newEntryName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_Rename_Name,
          codec.align(FileSystemAccessDirectoryHandle_Rename_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_Rename_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_Rename_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.move = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.move
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.move = function(destinationDirectory, newEntryName) {
    var params_ = new FileSystemAccessDirectoryHandle_Move_Params();
    params_.destinationDirectory = destinationDirectory;
    params_.newEntryName = newEntryName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_Move_Name,
          codec.align(FileSystemAccessDirectoryHandle_Move_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_Move_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_Move_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.remove = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.remove
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.remove = function(recurse) {
    var params_ = new FileSystemAccessDirectoryHandle_Remove_Params();
    params_.recurse = recurse;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_Remove_Name,
          codec.align(FileSystemAccessDirectoryHandle_Remove_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_Remove_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_Remove_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.removeEntry = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.removeEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.removeEntry = function(basename, recurse) {
    var params_ = new FileSystemAccessDirectoryHandle_RemoveEntry_Params();
    params_.basename = basename;
    params_.recurse = recurse;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_RemoveEntry_Name,
          codec.align(FileSystemAccessDirectoryHandle_RemoveEntry_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_RemoveEntry_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.resolve = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.resolve
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.resolve = function(possibleChild) {
    var params_ = new FileSystemAccessDirectoryHandle_Resolve_Params();
    params_.possibleChild = possibleChild;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_Resolve_Name,
          codec.align(FileSystemAccessDirectoryHandle_Resolve_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_Resolve_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_Resolve_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.transfer = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.transfer
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.transfer = function(token) {
    var params_ = new FileSystemAccessDirectoryHandle_Transfer_Params();
    params_.token = token;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessDirectoryHandle_Transfer_Name,
        codec.align(FileSystemAccessDirectoryHandle_Transfer_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessDirectoryHandle_Transfer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FileSystemAccessDirectoryHandlePtr.prototype.getUniqueId = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.getUniqueId
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.getUniqueId = function() {
    var params_ = new FileSystemAccessDirectoryHandle_GetUniqueId_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_GetUniqueId_Name,
          codec.align(FileSystemAccessDirectoryHandle_GetUniqueId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_GetUniqueId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDirectoryHandlePtr.prototype.getCloudIdentifiers = function() {
    return FileSystemAccessDirectoryHandleProxy.prototype.getCloudIdentifiers
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDirectoryHandleProxy.prototype.getCloudIdentifiers = function() {
    var params_ = new FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDirectoryHandle_GetCloudIdentifiers_Name,
          codec.align(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileSystemAccessDirectoryHandleStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessDirectoryHandleStub.prototype.getPermissionStatus = function(mode) {
    return this.delegate_ && this.delegate_.getPermissionStatus && this.delegate_.getPermissionStatus(mode);
  }
  FileSystemAccessDirectoryHandleStub.prototype.requestPermission = function(mode) {
    return this.delegate_ && this.delegate_.requestPermission && this.delegate_.requestPermission(mode);
  }
  FileSystemAccessDirectoryHandleStub.prototype.getFile = function(basename, create) {
    return this.delegate_ && this.delegate_.getFile && this.delegate_.getFile(basename, create);
  }
  FileSystemAccessDirectoryHandleStub.prototype.getDirectory = function(basename, create) {
    return this.delegate_ && this.delegate_.getDirectory && this.delegate_.getDirectory(basename, create);
  }
  FileSystemAccessDirectoryHandleStub.prototype.getEntries = function(listener) {
    return this.delegate_ && this.delegate_.getEntries && this.delegate_.getEntries(listener);
  }
  FileSystemAccessDirectoryHandleStub.prototype.rename = function(newEntryName) {
    return this.delegate_ && this.delegate_.rename && this.delegate_.rename(newEntryName);
  }
  FileSystemAccessDirectoryHandleStub.prototype.move = function(destinationDirectory, newEntryName) {
    return this.delegate_ && this.delegate_.move && this.delegate_.move(destinationDirectory, newEntryName);
  }
  FileSystemAccessDirectoryHandleStub.prototype.remove = function(recurse) {
    return this.delegate_ && this.delegate_.remove && this.delegate_.remove(recurse);
  }
  FileSystemAccessDirectoryHandleStub.prototype.removeEntry = function(basename, recurse) {
    return this.delegate_ && this.delegate_.removeEntry && this.delegate_.removeEntry(basename, recurse);
  }
  FileSystemAccessDirectoryHandleStub.prototype.resolve = function(possibleChild) {
    return this.delegate_ && this.delegate_.resolve && this.delegate_.resolve(possibleChild);
  }
  FileSystemAccessDirectoryHandleStub.prototype.transfer = function(token) {
    return this.delegate_ && this.delegate_.transfer && this.delegate_.transfer(token);
  }
  FileSystemAccessDirectoryHandleStub.prototype.getUniqueId = function() {
    return this.delegate_ && this.delegate_.getUniqueId && this.delegate_.getUniqueId();
  }
  FileSystemAccessDirectoryHandleStub.prototype.getCloudIdentifiers = function() {
    return this.delegate_ && this.delegate_.getCloudIdentifiers && this.delegate_.getCloudIdentifiers();
  }

  FileSystemAccessDirectoryHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessDirectoryHandle_GetEntries_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_GetEntries_Params);
      this.getEntries(params.listener);
      return true;
    case kFileSystemAccessDirectoryHandle_Transfer_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_Transfer_Params);
      this.transfer(params.token);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessDirectoryHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_GetPermissionStatus_Params);
      this.getPermissionStatus(params.mode).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name,
            codec.align(FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_RequestPermission_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_RequestPermission_Params);
      this.requestPermission(params.mode).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams();
        responseParams.result = response.result;
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_RequestPermission_Name,
            codec.align(FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_GetFile_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_GetFile_Params);
      this.getFile(params.basename, params.create).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_GetFile_ResponseParams();
        responseParams.result = response.result;
        responseParams.file = response.file;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_GetFile_Name,
            codec.align(FileSystemAccessDirectoryHandle_GetFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_GetFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_GetDirectory_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_GetDirectory_Params);
      this.getDirectory(params.basename, params.create).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams();
        responseParams.result = response.result;
        responseParams.directory = response.directory;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_GetDirectory_Name,
            codec.align(FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_Rename_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_Rename_Params);
      this.rename(params.newEntryName).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_Rename_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_Rename_Name,
            codec.align(FileSystemAccessDirectoryHandle_Rename_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_Rename_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_Move_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_Move_Params);
      this.move(params.destinationDirectory, params.newEntryName).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_Move_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_Move_Name,
            codec.align(FileSystemAccessDirectoryHandle_Move_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_Move_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_Remove_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_Remove_Params);
      this.remove(params.recurse).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_Remove_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_Remove_Name,
            codec.align(FileSystemAccessDirectoryHandle_Remove_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_Remove_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_RemoveEntry_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_RemoveEntry_Params);
      this.removeEntry(params.basename, params.recurse).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_RemoveEntry_Name,
            codec.align(FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_Resolve_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_Resolve_Params);
      this.resolve(params.possibleChild).then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_Resolve_ResponseParams();
        responseParams.result = response.result;
        responseParams.path = response.path;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_Resolve_Name,
            codec.align(FileSystemAccessDirectoryHandle_Resolve_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_Resolve_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_GetUniqueId_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_GetUniqueId_Params);
      this.getUniqueId().then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams();
        responseParams.result = response.result;
        responseParams.id = response.id;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_GetUniqueId_Name,
            codec.align(FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessDirectoryHandle_GetCloudIdentifiers_Name:
      var params = reader.decodeStruct(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params);
      this.getCloudIdentifiers().then(function(response) {
        var responseParams =
            new FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams();
        responseParams.result = response.result;
        responseParams.cloudIdentifiers = response.cloudIdentifiers;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDirectoryHandle_GetCloudIdentifiers_Name,
            codec.align(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessDirectoryHandleRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetPermissionStatus_Params;
      break;
      case kFileSystemAccessDirectoryHandle_RequestPermission_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_RequestPermission_Params;
      break;
      case kFileSystemAccessDirectoryHandle_GetFile_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetFile_Params;
      break;
      case kFileSystemAccessDirectoryHandle_GetDirectory_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetDirectory_Params;
      break;
      case kFileSystemAccessDirectoryHandle_GetEntries_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetEntries_Params;
      break;
      case kFileSystemAccessDirectoryHandle_Rename_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Rename_Params;
      break;
      case kFileSystemAccessDirectoryHandle_Move_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Move_Params;
      break;
      case kFileSystemAccessDirectoryHandle_Remove_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Remove_Params;
      break;
      case kFileSystemAccessDirectoryHandle_RemoveEntry_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_RemoveEntry_Params;
      break;
      case kFileSystemAccessDirectoryHandle_Resolve_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Resolve_Params;
      break;
      case kFileSystemAccessDirectoryHandle_Transfer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Transfer_Params;
      break;
      case kFileSystemAccessDirectoryHandle_GetUniqueId_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetUniqueId_Params;
      break;
      case kFileSystemAccessDirectoryHandle_GetCloudIdentifiers_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessDirectoryHandleResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessDirectoryHandle_GetPermissionStatus_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_RequestPermission_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_GetFile_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetFile_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_GetDirectory_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_Rename_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Rename_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_Move_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Move_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_Remove_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Remove_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_RemoveEntry_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_Resolve_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_Resolve_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_GetUniqueId_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams;
        break;
      case kFileSystemAccessDirectoryHandle_GetCloudIdentifiers_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessDirectoryHandle = {
    name: 'blink.mojom.FileSystemAccessDirectoryHandle',
    kVersion: 0,
    ptrClass: FileSystemAccessDirectoryHandlePtr,
    proxyClass: FileSystemAccessDirectoryHandleProxy,
    stubClass: FileSystemAccessDirectoryHandleStub,
    validateRequest: validateFileSystemAccessDirectoryHandleRequest,
    validateResponse: validateFileSystemAccessDirectoryHandleResponse,
  };
  FileSystemAccessDirectoryHandleStub.prototype.validator = validateFileSystemAccessDirectoryHandleRequest;
  FileSystemAccessDirectoryHandleProxy.prototype.validator = validateFileSystemAccessDirectoryHandleResponse;
  exports.FileSystemAccessEntry = FileSystemAccessEntry;
  exports.FileSystemAccessHandle = FileSystemAccessHandle;
  exports.FileSystemAccessDirectoryEntriesListener = FileSystemAccessDirectoryEntriesListener;
  exports.FileSystemAccessDirectoryEntriesListenerPtr = FileSystemAccessDirectoryEntriesListenerPtr;
  exports.FileSystemAccessDirectoryEntriesListenerAssociatedPtr = FileSystemAccessDirectoryEntriesListenerAssociatedPtr;
  exports.FileSystemAccessDirectoryHandle = FileSystemAccessDirectoryHandle;
  exports.FileSystemAccessDirectoryHandlePtr = FileSystemAccessDirectoryHandlePtr;
  exports.FileSystemAccessDirectoryHandleAssociatedPtr = FileSystemAccessDirectoryHandleAssociatedPtr;
})();