// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FileSystemAccessPermissionMode');
goog.require('blink.mojom.PermissionStatus');
goog.require('blink.mojom.FileSystemAccessAccessHandleHost');
goog.require('blink.mojom.FileSystemAccessFileDelegateHost');
goog.require('blink.mojom.FileSystemAccessFileModificationHost');
goog.require('blink.mojom.FileSystemAccessFileWriter');
goog.require('blink.mojom.FileSystemAccessTransferToken');
goog.require('mojoBase.mojom.File');
goog.require('mojoBase.mojom.FileInfo');
goog.require('blink.mojom.FileSystemAccessCloudIdentifier');
goog.require('blink.mojom.FileSystemAccessError');
goog.require('blink.mojom.SerializedBlob');




goog.provide('blink.mojom.FileSystemAccessAccessHandleLockMode');
goog.provide('blink.mojom.FileSystemAccessAccessHandleLockModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileSystemAccessAccessHandleLockModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FileSystemAccessAccessHandleLockMode = {
  
  kReadwrite: 0,
  kReadOnly: 1,
  kReadwriteUnsafe: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.FileSystemAccessWritableFileStreamLockMode');
goog.provide('blink.mojom.FileSystemAccessWritableFileStreamLockModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileSystemAccessWritableFileStreamLockModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FileSystemAccessWritableFileStreamLockMode = {
  
  kExclusive: 0,
  kSiloed: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.FileSystemAccessFileHandle');
goog.provide('blink.mojom.FileSystemAccessFileHandleReceiver');
goog.provide('blink.mojom.FileSystemAccessFileHandleCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessFileHandleInterface');
goog.provide('blink.mojom.FileSystemAccessFileHandleRemote');
goog.provide('blink.mojom.FileSystemAccessFileHandlePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessFileHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessFileHandle.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessFileHandleInterface = class {
  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  getPermissionStatus(mode) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  requestPermission(mode) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        info: !mojoBase.mojom.FileInfo,
        blob: ?blink.mojom.SerializedBlob,
   *  }>}
   */

  asBlob() {}
  
  /**
   * @param { !boolean } keepExistingData
   * @param { !boolean } autoClose
   * @param { !blink.mojom.FileSystemAccessWritableFileStreamLockMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        writer: ?blink.mojom.FileSystemAccessFileWriterRemote,
   *  }>}
   */

  createFileWriter(keepExistingData, autoClose, mode) {}
  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  rename(newEntryName) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  move(destinationDirectory, newEntryName) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  remove() {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessAccessHandleLockMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        file: ?blink.mojom.FileSystemAccessAccessHandleFile,
        accessHandleHost: ?blink.mojom.FileSystemAccessAccessHandleHostRemote,
   *  }>}
   */

  openAccessHandle(mode) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } other
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        isSame: !boolean,
   *  }>}
   */

  isSameEntry(other) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(token) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        cloudIdentifiers: !Array<!blink.mojom.FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessFileHandleInterface }
 */
blink.mojom.FileSystemAccessFileHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessFileHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessFileHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessFileHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  getPermissionStatus(
      mode) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  requestPermission(
      mode) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        info: !mojoBase.mojom.FileInfo,
        blob: ?blink.mojom.SerializedBlob,
   *  }>}
   */

  asBlob() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } keepExistingData
   * @param { !boolean } autoClose
   * @param { !blink.mojom.FileSystemAccessWritableFileStreamLockMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        writer: ?blink.mojom.FileSystemAccessFileWriterRemote,
   *  }>}
   */

  createFileWriter(
      keepExistingData,
      autoClose,
      mode) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
        [
          keepExistingData,
          autoClose,
          mode
        ],
        false);
  }

  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  rename(
      newEntryName) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.FileSystemAccessFileHandle_Rename_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
        [
          newEntryName
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  move(
      destinationDirectory,
      newEntryName) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.FileSystemAccessFileHandle_Move_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
        [
          destinationDirectory,
          newEntryName
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  remove() {
    return this.proxy.sendMessage(
        6,
        blink.mojom.FileSystemAccessFileHandle_Remove_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessAccessHandleLockMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        file: ?blink.mojom.FileSystemAccessAccessHandleFile,
        accessHandleHost: ?blink.mojom.FileSystemAccessAccessHandleHostRemote,
   *  }>}
   */

  openAccessHandle(
      mode) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } other
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        isSame: !boolean,
   *  }>}
   */

  isSameEntry(
      other) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
        [
          other
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(
      token) {
    this.proxy.sendMessage(
        9,
        blink.mojom.FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {
    return this.proxy.sendMessage(
        10,
        blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        cloudIdentifiers: !Array<!blink.mojom.FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {
    return this.proxy.sendMessage(
        11,
        blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessFileHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileHandleReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessFileHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessFileHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessFileHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
        impl.getPermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
        impl.requestPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
        impl.asBlob.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
        impl.createFileWriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FileSystemAccessFileHandle_Rename_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
        impl.rename.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FileSystemAccessFileHandle_Move_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
        impl.move.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FileSystemAccessFileHandle_Remove_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
        impl.openAccessHandle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
        impl.isSameEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
        null,
        impl.transfer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
        impl.getUniqueId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        impl.getCloudIdentifiers.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessFileHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessFileHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessFileHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessFileHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessFileHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
        this.getPermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
        this.requestPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.asBlob =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
        this.asBlob.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFileWriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
        this.createFileWriter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rename =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FileSystemAccessFileHandle_Rename_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
        this.rename.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.move =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FileSystemAccessFileHandle_Move_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
        this.move.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FileSystemAccessFileHandle_Remove_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openAccessHandle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
        this.openAccessHandle.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isSameEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
        this.isSameEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transfer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
        null,
        this.transfer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUniqueId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
        this.getUniqueId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCloudIdentifiers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        this.getCloudIdentifiers.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessRegularFileSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessRegularFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_RequestPermission_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_RequestPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_AsBlob_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_AsBlob_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Rename_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Rename_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Move_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Move_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Move_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Move_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Remove_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_Transfer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_Transfer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessAccessHandleFileSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileSystemAccessAccessHandleFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessRegularFileSpec.$,
    'FileSystemAccessRegularFile',
    [
      mojo.internal.StructField(
        'osFile', 0,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileSize', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileModificationHost', 16,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessFileModificationHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessRegularFile');

/** @record */
blink.mojom.FileSystemAccessRegularFile = class {
  constructor() {
    /** @export { !mojoBase.mojom.File } */
    this.osFile;
    /** @export { !bigint } */
    this.fileSize;
    /** @export { !blink.mojom.FileSystemAccessFileModificationHostRemote } */
    this.fileModificationHost;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
    'FileSystemAccessFileHandle_GetPermissionStatus_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.FileSystemAccessPermissionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessPermissionMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
    'FileSystemAccessFileHandle_RequestPermission_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.FileSystemAccessPermissionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_RequestPermission_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_RequestPermission_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessPermissionMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_RequestPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_RequestPermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
    'FileSystemAccessFileHandle_AsBlob_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_AsBlob_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_AsBlob_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_AsBlob_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'info', 8,
        0,
        mojoBase.mojom.FileInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blob', 16,
        0,
        blink.mojom.SerializedBlobSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_AsBlob_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !mojoBase.mojom.FileInfo } */
    this.info;
    /** @export { (blink.mojom.SerializedBlob|undefined) } */
    this.blob;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
    'FileSystemAccessFileHandle_CreateFileWriter_Params',
    [
      mojo.internal.StructField(
        'keepExistingData', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'autoClose', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 4,
        0,
        blink.mojom.FileSystemAccessWritableFileStreamLockModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.keepExistingData;
    /** @export { !boolean } */
    this.autoClose;
    /** @export { !blink.mojom.FileSystemAccessWritableFileStreamLockMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_CreateFileWriter_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'writer', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessFileWriterRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_CreateFileWriter_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessFileWriterRemote|undefined) } */
    this.writer;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Rename_ParamsSpec.$,
    'FileSystemAccessFileHandle_Rename_Params',
    [
      mojo.internal.StructField(
        'newEntryName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Rename_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Rename_Params = class {
  constructor() {
    /** @export { !string } */
    this.newEntryName;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_Rename_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Rename_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Move_ParamsSpec.$,
    'FileSystemAccessFileHandle_Move_Params',
    [
      mojo.internal.StructField(
        'destinationDirectory', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newEntryName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Move_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Move_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.destinationDirectory;
    /** @export { !string } */
    this.newEntryName;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_Move_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Move_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Move_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Remove_ParamsSpec.$,
    'FileSystemAccessFileHandle_Remove_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Remove_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Remove_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Remove_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
    'FileSystemAccessFileHandle_OpenAccessHandle_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.FileSystemAccessAccessHandleLockModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessAccessHandleLockMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'file', 8,
        0,
        blink.mojom.FileSystemAccessAccessHandleFileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessHandleHost', 24,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessAccessHandleHostRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessAccessHandleFile|undefined) } */
    this.file;
    /** @export { (blink.mojom.FileSystemAccessAccessHandleHostRemote|undefined) } */
    this.accessHandleHost;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
    'FileSystemAccessFileHandle_IsSameEntry_Params',
    [
      mojo.internal.StructField(
        'other', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_IsSameEntry_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_IsSameEntry_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.other;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_IsSameEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSame', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_IsSameEntry_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !boolean } */
    this.isSame;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
    'FileSystemAccessFileHandle_Transfer_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessTransferTokenPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_Transfer_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_Transfer_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
    'FileSystemAccessFileHandle_GetUniqueId_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_GetUniqueId_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_GetUniqueId_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_GetUniqueId_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_GetUniqueId_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
    'FileSystemAccessFileHandle_GetCloudIdentifiers_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_Params');

/** @record */
blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cloudIdentifiers', 8,
        0,
        mojo.internal.Array(blink.mojom.FileSystemAccessCloudIdentifierSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !Array<!blink.mojom.FileSystemAccessCloudIdentifier> } */
    this.cloudIdentifiers;
  }
};

goog.provide('blink.mojom.FileSystemAccessAccessHandleFile');


mojo.internal.Union(
    blink.mojom.FileSystemAccessAccessHandleFileSpec.$, 'FileSystemAccessAccessHandleFile',
    {
      'regularFile': {
        'ordinal': 0,
        'type': blink.mojom.FileSystemAccessRegularFileSpec.$,
      },
      'incognitoFileDelegate': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessFileDelegateHostRemote),
      },
    });

/**
 * @typedef { {
 *   regularFile: (!blink.mojom.FileSystemAccessRegularFile|undefined),
 *   incognitoFileDelegate: (!blink.mojom.FileSystemAccessFileDelegateHostRemote|undefined),
 * } }
 */
blink.mojom.FileSystemAccessAccessHandleFile;
