// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.Blob');
goog.require('blink.mojom.FileSystemAccessTransferToken');
goog.require('mojoBase.mojom.String16');
goog.require('mojoBase.mojom.Time');



goog.provide('blink.mojom.IDB_MAX_MESSAGE_SIZE');
/**
 * @const { !number }
 * @export
 */
blink.mojom.IDB_MAX_MESSAGE_SIZE = 134217728;
goog.provide('blink.mojom.IDB_MAX_MESSAGE_OVERHEAD');
/**
 * @const { !number }
 * @export
 */
blink.mojom.IDB_MAX_MESSAGE_OVERHEAD = 1048576;
goog.provide('blink.mojom.IDB_WRAP_THRESHOLD');
/**
 * @const { !number }
 * @export
 */
blink.mojom.IDB_WRAP_THRESHOLD = 65536;
goog.provide('blink.mojom.IDB_GET_ALL_CHUNK_SIZE');
/**
 * @const { !number }
 * @export
 */
blink.mojom.IDB_GET_ALL_CHUNK_SIZE = 1000;

goog.provide('blink.mojom.IDBCursorDirection');
goog.provide('blink.mojom.IDBCursorDirectionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBCursorDirectionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBCursorDirection = {
  
  Next: 0,
  NextNoDuplicate: 1,
  Prev: 2,
  PrevNoDuplicate: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.IDBDataLoss');
goog.provide('blink.mojom.IDBDataLossSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBDataLossSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBDataLoss = {
  
  None: 0,
  Total: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.IDBKeyType');
goog.provide('blink.mojom.IDBKeyTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBKeyTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBKeyType = {
  
  Invalid: 0,
  Array: 1,
  Binary: 2,
  String: 3,
  Date: 4,
  Number: 5,
  None: 6,
  Min: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('blink.mojom.IDBTransactionDurability');
goog.provide('blink.mojom.IDBTransactionDurabilitySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBTransactionDurabilitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBTransactionDurability = {
  
  Default: 0,
  Strict: 1,
  Relaxed: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.IDBGetAllResultType');
goog.provide('blink.mojom.IDBGetAllResultTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBGetAllResultTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBGetAllResultType = {
  
  Keys: 0,
  Values: 1,
  Records: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.IDBKeyPathType');
goog.provide('blink.mojom.IDBKeyPathTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBKeyPathTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBKeyPathType = {
  
  Null: 0,
  String: 1,
  Array: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.IDBOperationType');
goog.provide('blink.mojom.IDBOperationTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBOperationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBOperationType = {
  
  Add: 0,
  Put: 1,
  Delete: 2,
  Clear: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.IDBPutMode');
goog.provide('blink.mojom.IDBPutModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBPutModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBPutMode = {
  
  AddOrUpdate: 0,
  AddOnly: 1,
  CursorUpdate: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.IDBTaskType');
goog.provide('blink.mojom.IDBTaskTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBTaskTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBTaskType = {
  
  Normal: 0,
  Preemptive: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.IDBTransactionMode');
goog.provide('blink.mojom.IDBTransactionModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBTransactionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBTransactionMode = {
  
  ReadOnly: 0,
  ReadWrite: 1,
  VersionChange: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.IDBException');
goog.provide('blink.mojom.IDBExceptionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBExceptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IDBException = {
  
  kNoError: 0,
  kUnknownError: 28,
  kConstraintError: 29,
  kDataError: 30,
  kVersionError: 33,
  kAbortError: 20,
  kIgnorableAbortError: 11,
  kQuotaError: 22,
  kTimeoutError: 23,
  MIN_VALUE: 0,
  MAX_VALUE: 33,
};



goog.provide('blink.mojom.IDBFactoryClient');
goog.provide('blink.mojom.IDBFactoryClientReceiver');
goog.provide('blink.mojom.IDBFactoryClientCallbackRouter');
goog.provide('blink.mojom.IDBFactoryClientInterface');
goog.provide('blink.mojom.IDBFactoryClientRemote');
goog.provide('blink.mojom.IDBFactoryClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBFactoryClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBFactoryClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBFactoryClientInterface = class {
  
  /**
   * @param { !blink.mojom.IDBException } code
   * @param { !mojoBase.mojom.String16 } message
   */

  error(code, message) {}
  
  /**
   * @param { !bigint } existingVersion
   */

  blocked(existingVersion) {}
  
  /**
   * @param { !Object } pendingDatabase
   * @param { !bigint } oldVersion
   * @param { !blink.mojom.IDBDataLoss } dataLoss
   * @param { !string } dataLossMessage
   * @param { !blink.mojom.IDBDatabaseMetadata } dbMetadata
   */

  upgradeNeeded(pendingDatabase, oldVersion, dataLoss, dataLossMessage, dbMetadata) {}
  
  /**
   * @param { ?Object } pendingDatabase
   * @param { !blink.mojom.IDBDatabaseMetadata } metadata
   */

  openSuccess(pendingDatabase, metadata) {}
  
  /**
   * @param { !bigint } oldVersion
   */

  deleteSuccess(oldVersion) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBFactoryClientInterface }
 */
blink.mojom.IDBFactoryClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBFactoryClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBFactoryClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBFactoryClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.IDBException } code
   * @param { !mojoBase.mojom.String16 } message
   */

  error(
      code,
      message) {
    this.proxy.sendMessage(
        0,
        blink.mojom.IDBFactoryClient_Error_ParamsSpec.$,
        null,
        [
          code,
          message
        ],
        false);
  }

  
  /**
   * @param { !bigint } existingVersion
   */

  blocked(
      existingVersion) {
    this.proxy.sendMessage(
        1,
        blink.mojom.IDBFactoryClient_Blocked_ParamsSpec.$,
        null,
        [
          existingVersion
        ],
        false);
  }

  
  /**
   * @param { !Object } pendingDatabase
   * @param { !bigint } oldVersion
   * @param { !blink.mojom.IDBDataLoss } dataLoss
   * @param { !string } dataLossMessage
   * @param { !blink.mojom.IDBDatabaseMetadata } dbMetadata
   */

  upgradeNeeded(
      pendingDatabase,
      oldVersion,
      dataLoss,
      dataLossMessage,
      dbMetadata) {
    this.proxy.sendMessage(
        2,
        blink.mojom.IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
        null,
        [
          pendingDatabase,
          oldVersion,
          dataLoss,
          dataLossMessage,
          dbMetadata
        ],
        false);
  }

  
  /**
   * @param { ?Object } pendingDatabase
   * @param { !blink.mojom.IDBDatabaseMetadata } metadata
   */

  openSuccess(
      pendingDatabase,
      metadata) {
    this.proxy.sendMessage(
        3,
        blink.mojom.IDBFactoryClient_OpenSuccess_ParamsSpec.$,
        null,
        [
          pendingDatabase,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !bigint } oldVersion
   */

  deleteSuccess(
      oldVersion) {
    this.proxy.sendMessage(
        4,
        blink.mojom.IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
        null,
        [
          oldVersion
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBFactoryClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBFactoryClientReceiver = class {
  /**
   * @param {!blink.mojom.IDBFactoryClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBFactoryClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBFactoryClient_Error_ParamsSpec.$,
        null,
        impl.error.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBFactoryClient_Blocked_ParamsSpec.$,
        null,
        impl.blocked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
        null,
        impl.upgradeNeeded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBFactoryClient_OpenSuccess_ParamsSpec.$,
        null,
        impl.openSuccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
        null,
        impl.deleteSuccess.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBFactoryClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBFactoryClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBFactoryClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBFactoryClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBFactoryClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBFactoryClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.error =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBFactoryClient_Error_ParamsSpec.$,
        null,
        this.error.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blocked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBFactoryClient_Blocked_ParamsSpec.$,
        null,
        this.blocked.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.upgradeNeeded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
        null,
        this.upgradeNeeded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBFactoryClient_OpenSuccess_ParamsSpec.$,
        null,
        this.openSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
        null,
        this.deleteSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBDatabaseCallbacks');
goog.provide('blink.mojom.IDBDatabaseCallbacksReceiver');
goog.provide('blink.mojom.IDBDatabaseCallbacksCallbackRouter');
goog.provide('blink.mojom.IDBDatabaseCallbacksInterface');
goog.provide('blink.mojom.IDBDatabaseCallbacksRemote');
goog.provide('blink.mojom.IDBDatabaseCallbacksPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBDatabaseCallbacksPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBDatabaseCallbacks.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBDatabaseCallbacksInterface = class {
  
  /**
   */

  forcedClose() {}
  
  /**
   * @param { !bigint } oldVersion
   * @param { !bigint } newVersion
   */

  versionChange(oldVersion, newVersion) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !blink.mojom.IDBException } code
   * @param { !mojoBase.mojom.String16 } message
   */

  abort(transactionId, code, message) {}
  
  /**
   * @param { !bigint } transactionId
   */

  complete(transactionId) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBDatabaseCallbacksInterface }
 */
blink.mojom.IDBDatabaseCallbacksRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBDatabaseCallbacksPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBDatabaseCallbacksPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBDatabaseCallbacksPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  forcedClose() {
    this.proxy.sendMessage(
        0,
        blink.mojom.IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } oldVersion
   * @param { !bigint } newVersion
   */

  versionChange(
      oldVersion,
      newVersion) {
    this.proxy.sendMessage(
        1,
        blink.mojom.IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
        null,
        [
          oldVersion,
          newVersion
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !blink.mojom.IDBException } code
   * @param { !mojoBase.mojom.String16 } message
   */

  abort(
      transactionId,
      code,
      message) {
    this.proxy.sendMessage(
        2,
        blink.mojom.IDBDatabaseCallbacks_Abort_ParamsSpec.$,
        null,
        [
          transactionId,
          code,
          message
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   */

  complete(
      transactionId) {
    this.proxy.sendMessage(
        3,
        blink.mojom.IDBDatabaseCallbacks_Complete_ParamsSpec.$,
        null,
        [
          transactionId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBDatabaseCallbacks
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBDatabaseCallbacksReceiver = class {
  /**
   * @param {!blink.mojom.IDBDatabaseCallbacksInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBDatabaseCallbacksRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBDatabaseCallbacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBDatabaseCallbacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
        null,
        impl.forcedClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
        null,
        impl.versionChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBDatabaseCallbacks_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBDatabaseCallbacks_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBDatabaseCallbacks = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBDatabaseCallbacks";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBDatabaseCallbacksRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBDatabaseCallbacksRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBDatabaseCallbacks
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBDatabaseCallbacksCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBDatabaseCallbacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBDatabaseCallbacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forcedClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
        null,
        this.forcedClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.versionChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
        null,
        this.versionChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBDatabaseCallbacks_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBDatabaseCallbacks_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBCursor');
goog.provide('blink.mojom.IDBCursorReceiver');
goog.provide('blink.mojom.IDBCursorCallbackRouter');
goog.provide('blink.mojom.IDBCursorInterface');
goog.provide('blink.mojom.IDBCursorRemote');
goog.provide('blink.mojom.IDBCursorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBCursorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBCursor.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBCursorInterface = class {
  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !blink.mojom.IDBCursorResult,
   *  }>}
   */

  advance(count) {}
  
  /**
   * @param { !blink.mojom.IDBKey } key
   * @param { !blink.mojom.IDBKey } primaryKey
   * @return {!Promise<{
        result: !blink.mojom.IDBCursorResult,
   *  }>}
   */

  continue(key, primaryKey) {}
  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !blink.mojom.IDBCursorResult,
   *  }>}
   */

  prefetch(count) {}
  
  /**
   * @param { !number } usedPrefetches
   */

  prefetchReset(usedPrefetches) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBCursorInterface }
 */
blink.mojom.IDBCursorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBCursorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBCursorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBCursorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !blink.mojom.IDBCursorResult,
   *  }>}
   */

  advance(
      count) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.IDBCursor_Advance_ParamsSpec.$,
        blink.mojom.IDBCursor_Advance_ResponseParamsSpec.$,
        [
          count
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IDBKey } key
   * @param { !blink.mojom.IDBKey } primaryKey
   * @return {!Promise<{
        result: !blink.mojom.IDBCursorResult,
   *  }>}
   */

  continue(
      key,
      primaryKey) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.IDBCursor_Continue_ParamsSpec.$,
        blink.mojom.IDBCursor_Continue_ResponseParamsSpec.$,
        [
          key,
          primaryKey
        ],
        false);
  }

  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !blink.mojom.IDBCursorResult,
   *  }>}
   */

  prefetch(
      count) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.IDBCursor_Prefetch_ParamsSpec.$,
        blink.mojom.IDBCursor_Prefetch_ResponseParamsSpec.$,
        [
          count
        ],
        false);
  }

  
  /**
   * @param { !number } usedPrefetches
   */

  prefetchReset(
      usedPrefetches) {
    this.proxy.sendMessage(
        3,
        blink.mojom.IDBCursor_PrefetchReset_ParamsSpec.$,
        null,
        [
          usedPrefetches
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBCursor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBCursorReceiver = class {
  /**
   * @param {!blink.mojom.IDBCursorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBCursorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBCursorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBCursorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBCursor_Advance_ParamsSpec.$,
        blink.mojom.IDBCursor_Advance_ResponseParamsSpec.$,
        impl.advance.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBCursor_Continue_ParamsSpec.$,
        blink.mojom.IDBCursor_Continue_ResponseParamsSpec.$,
        impl.continue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBCursor_Prefetch_ParamsSpec.$,
        blink.mojom.IDBCursor_Prefetch_ResponseParamsSpec.$,
        impl.prefetch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBCursor_PrefetchReset_ParamsSpec.$,
        null,
        impl.prefetchReset.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBCursor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBCursor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBCursorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBCursorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBCursor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBCursorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBCursorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBCursorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.advance =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBCursor_Advance_ParamsSpec.$,
        blink.mojom.IDBCursor_Advance_ResponseParamsSpec.$,
        this.advance.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.continue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBCursor_Continue_ParamsSpec.$,
        blink.mojom.IDBCursor_Continue_ResponseParamsSpec.$,
        this.continue.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prefetch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBCursor_Prefetch_ParamsSpec.$,
        blink.mojom.IDBCursor_Prefetch_ResponseParamsSpec.$,
        this.prefetch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prefetchReset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBCursor_PrefetchReset_ParamsSpec.$,
        null,
        this.prefetchReset.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBTransaction');
goog.provide('blink.mojom.IDBTransactionReceiver');
goog.provide('blink.mojom.IDBTransactionCallbackRouter');
goog.provide('blink.mojom.IDBTransactionInterface');
goog.provide('blink.mojom.IDBTransactionRemote');
goog.provide('blink.mojom.IDBTransactionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBTransactionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBTransaction.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBTransactionInterface = class {
  
  /**
   * @param { !bigint } objectStoreId
   * @param { !mojoBase.mojom.String16 } name
   * @param { !blink.mojom.IDBKeyPath } keyPath
   * @param { !boolean } autoIncrement
   */

  createObjectStore(objectStoreId, name, keyPath, autoIncrement) {}
  
  /**
   * @param { !bigint } objectStoreId
   */

  deleteObjectStore(objectStoreId) {}
  
  /**
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBValue } value
   * @param { !blink.mojom.IDBKey } key
   * @param { !blink.mojom.IDBPutMode } mode
   * @param { !Array<!blink.mojom.IDBIndexKeys> } indexKeys
   * @return {!Promise<{
        result: !blink.mojom.IDBTransactionPutResult,
   *  }>}
   */

  put(objectStoreId, value, key, mode, indexKeys) {}
  
  /**
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBKey } primaryKey
   * @param { !blink.mojom.IDBIndexKeys } indexKeys
   */

  setIndexKeys(objectStoreId, primaryKey, indexKeys) {}
  
  /**
   */

  setIndexKeysDone() {}
  
  /**
   * @param { !bigint } numErrorsHandled
   */

  commit(numErrorsHandled) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBTransactionInterface }
 */
blink.mojom.IDBTransactionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBTransactionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBTransactionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBTransactionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } objectStoreId
   * @param { !mojoBase.mojom.String16 } name
   * @param { !blink.mojom.IDBKeyPath } keyPath
   * @param { !boolean } autoIncrement
   */

  createObjectStore(
      objectStoreId,
      name,
      keyPath,
      autoIncrement) {
    this.proxy.sendMessage(
        0,
        blink.mojom.IDBTransaction_CreateObjectStore_ParamsSpec.$,
        null,
        [
          objectStoreId,
          name,
          keyPath,
          autoIncrement
        ],
        false);
  }

  
  /**
   * @param { !bigint } objectStoreId
   */

  deleteObjectStore(
      objectStoreId) {
    this.proxy.sendMessage(
        1,
        blink.mojom.IDBTransaction_DeleteObjectStore_ParamsSpec.$,
        null,
        [
          objectStoreId
        ],
        false);
  }

  
  /**
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBValue } value
   * @param { !blink.mojom.IDBKey } key
   * @param { !blink.mojom.IDBPutMode } mode
   * @param { !Array<!blink.mojom.IDBIndexKeys> } indexKeys
   * @return {!Promise<{
        result: !blink.mojom.IDBTransactionPutResult,
   *  }>}
   */

  put(
      objectStoreId,
      value,
      key,
      mode,
      indexKeys) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.IDBTransaction_Put_ParamsSpec.$,
        blink.mojom.IDBTransaction_Put_ResponseParamsSpec.$,
        [
          objectStoreId,
          value,
          key,
          mode,
          indexKeys
        ],
        false);
  }

  
  /**
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBKey } primaryKey
   * @param { !blink.mojom.IDBIndexKeys } indexKeys
   */

  setIndexKeys(
      objectStoreId,
      primaryKey,
      indexKeys) {
    this.proxy.sendMessage(
        3,
        blink.mojom.IDBTransaction_SetIndexKeys_ParamsSpec.$,
        null,
        [
          objectStoreId,
          primaryKey,
          indexKeys
        ],
        false);
  }

  
  /**
   */

  setIndexKeysDone() {
    this.proxy.sendMessage(
        4,
        blink.mojom.IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } numErrorsHandled
   */

  commit(
      numErrorsHandled) {
    this.proxy.sendMessage(
        5,
        blink.mojom.IDBTransaction_Commit_ParamsSpec.$,
        null,
        [
          numErrorsHandled
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBTransaction
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBTransactionReceiver = class {
  /**
   * @param {!blink.mojom.IDBTransactionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBTransactionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBTransaction_CreateObjectStore_ParamsSpec.$,
        null,
        impl.createObjectStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBTransaction_DeleteObjectStore_ParamsSpec.$,
        null,
        impl.deleteObjectStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBTransaction_Put_ParamsSpec.$,
        blink.mojom.IDBTransaction_Put_ResponseParamsSpec.$,
        impl.put.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBTransaction_SetIndexKeys_ParamsSpec.$,
        null,
        impl.setIndexKeys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
        null,
        impl.setIndexKeysDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.IDBTransaction_Commit_ParamsSpec.$,
        null,
        impl.commit.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBTransaction = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBTransaction";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBTransactionRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBTransactionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBTransaction
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBTransactionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createObjectStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBTransaction_CreateObjectStore_ParamsSpec.$,
        null,
        this.createObjectStore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteObjectStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBTransaction_DeleteObjectStore_ParamsSpec.$,
        null,
        this.deleteObjectStore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.put =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBTransaction_Put_ParamsSpec.$,
        blink.mojom.IDBTransaction_Put_ResponseParamsSpec.$,
        this.put.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIndexKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBTransaction_SetIndexKeys_ParamsSpec.$,
        null,
        this.setIndexKeys.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIndexKeysDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
        null,
        this.setIndexKeysDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.IDBTransaction_Commit_ParamsSpec.$,
        null,
        this.commit.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBDatabaseGetAllResultSink');
goog.provide('blink.mojom.IDBDatabaseGetAllResultSinkReceiver');
goog.provide('blink.mojom.IDBDatabaseGetAllResultSinkCallbackRouter');
goog.provide('blink.mojom.IDBDatabaseGetAllResultSinkInterface');
goog.provide('blink.mojom.IDBDatabaseGetAllResultSinkRemote');
goog.provide('blink.mojom.IDBDatabaseGetAllResultSinkPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBDatabaseGetAllResultSinkPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBDatabaseGetAllResultSink.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBDatabaseGetAllResultSinkInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.IDBRecord> } records
   * @param { !boolean } done
   */

  receiveResults(records, done) {}
  
  /**
   * @param { !blink.mojom.IDBError } error
   */

  onError(error) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBDatabaseGetAllResultSinkInterface }
 */
blink.mojom.IDBDatabaseGetAllResultSinkRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBDatabaseGetAllResultSinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBDatabaseGetAllResultSinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBDatabaseGetAllResultSinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.IDBRecord> } records
   * @param { !boolean } done
   */

  receiveResults(
      records,
      done) {
    this.proxy.sendMessage(
        0,
        blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
        null,
        [
          records,
          done
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IDBError } error
   */

  onError(
      error) {
    this.proxy.sendMessage(
        1,
        blink.mojom.IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBDatabaseGetAllResultSink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBDatabaseGetAllResultSinkReceiver = class {
  /**
   * @param {!blink.mojom.IDBDatabaseGetAllResultSinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBDatabaseGetAllResultSinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBDatabaseGetAllResultSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBDatabaseGetAllResultSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
        null,
        impl.receiveResults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBDatabaseGetAllResultSink = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBDatabaseGetAllResultSink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBDatabaseGetAllResultSinkRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBDatabaseGetAllResultSinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBDatabaseGetAllResultSink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBDatabaseGetAllResultSinkCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBDatabaseGetAllResultSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBDatabaseGetAllResultSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
        null,
        this.receiveResults.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBDatabase');
goog.provide('blink.mojom.IDBDatabaseReceiver');
goog.provide('blink.mojom.IDBDatabaseCallbackRouter');
goog.provide('blink.mojom.IDBDatabaseInterface');
goog.provide('blink.mojom.IDBDatabaseRemote');
goog.provide('blink.mojom.IDBDatabasePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBDatabasePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBDatabase.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBDatabaseInterface = class {
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !mojoBase.mojom.String16 } newName
   */

  renameObjectStore(transactionId, objectStoreId, newName) {}
  
  /**
   * @param { !Object } transactionReceiver
   * @param { !bigint } transactionId
   * @param { !Array<!bigint> } objectStoreIds
   * @param { !blink.mojom.IDBTransactionMode } mode
   * @param { !blink.mojom.IDBTransactionDurability } durability
   */

  createTransaction(transactionReceiver, transactionId, objectStoreIds, mode, durability) {}
  
  /**
   */

  versionChangeIgnored() {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @param { !boolean } keyOnly
   * @return {!Promise<{
        result: !blink.mojom.IDBDatabaseGetResult,
   *  }>}
   */

  get(transactionId, objectStoreId, indexId, keyRange, keyOnly) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @param { !blink.mojom.IDBGetAllResultType } resultType
   * @param { !bigint } maxCount
   * @param { !blink.mojom.IDBCursorDirection } direction
   * @return {!Promise<{
        receiver: !Object,
   *  }>}
   */

  getAll(transactionId, objectStoreId, indexId, keyRange, resultType, maxCount, direction) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @param { !blink.mojom.IDBCursorDirection } direction
   * @param { !boolean } keyOnly
   * @param { !blink.mojom.IDBTaskType } taskType
   * @return {!Promise<{
        result: !blink.mojom.IDBDatabaseOpenCursorResult,
   *  }>}
   */

  openCursor(transactionId, objectStoreId, indexId, keyRange, direction, keyOnly, taskType) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
        count: !number,
   *  }>}
   */

  count(transactionId, objectStoreId, indexId, keyRange) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteRange(transactionId, objectStoreId, keyRange) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        result: !bigint,
        error: ?blink.mojom.IDBError,
   *  }>}
   */

  getKeyGeneratorCurrentNumber(transactionId, objectStoreId) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clear(transactionId, objectStoreId) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBIndexMetadata } index
   */

  createIndex(transactionId, objectStoreId, index) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   */

  deleteIndex(transactionId, objectStoreId, indexId) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !mojoBase.mojom.String16 } newName
   */

  renameIndex(transactionId, objectStoreId, indexId, newName) {}
  
  /**
   * @param { !bigint } transactionId
   */

  abort(transactionId) {}
  
  /**
   */

  didBecomeInactive() {}
  
  /**
   * @param { !number } newPriority
   */

  updatePriority(newPriority) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBDatabaseInterface }
 */
blink.mojom.IDBDatabaseRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBDatabasePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBDatabasePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBDatabasePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !mojoBase.mojom.String16 } newName
   */

  renameObjectStore(
      transactionId,
      objectStoreId,
      newName) {
    this.proxy.sendMessage(
        0,
        blink.mojom.IDBDatabase_RenameObjectStore_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          newName
        ],
        false);
  }

  
  /**
   * @param { !Object } transactionReceiver
   * @param { !bigint } transactionId
   * @param { !Array<!bigint> } objectStoreIds
   * @param { !blink.mojom.IDBTransactionMode } mode
   * @param { !blink.mojom.IDBTransactionDurability } durability
   */

  createTransaction(
      transactionReceiver,
      transactionId,
      objectStoreIds,
      mode,
      durability) {
    this.proxy.sendMessage(
        1,
        blink.mojom.IDBDatabase_CreateTransaction_ParamsSpec.$,
        null,
        [
          transactionReceiver,
          transactionId,
          objectStoreIds,
          mode,
          durability
        ],
        false);
  }

  
  /**
   */

  versionChangeIgnored() {
    this.proxy.sendMessage(
        2,
        blink.mojom.IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @param { !boolean } keyOnly
   * @return {!Promise<{
        result: !blink.mojom.IDBDatabaseGetResult,
   *  }>}
   */

  get(
      transactionId,
      objectStoreId,
      indexId,
      keyRange,
      keyOnly) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.IDBDatabase_Get_ParamsSpec.$,
        blink.mojom.IDBDatabase_Get_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange,
          keyOnly
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @param { !blink.mojom.IDBGetAllResultType } resultType
   * @param { !bigint } maxCount
   * @param { !blink.mojom.IDBCursorDirection } direction
   * @return {!Promise<{
        receiver: !Object,
   *  }>}
   */

  getAll(
      transactionId,
      objectStoreId,
      indexId,
      keyRange,
      resultType,
      maxCount,
      direction) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.IDBDatabase_GetAll_ParamsSpec.$,
        blink.mojom.IDBDatabase_GetAll_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange,
          resultType,
          maxCount,
          direction
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @param { !blink.mojom.IDBCursorDirection } direction
   * @param { !boolean } keyOnly
   * @param { !blink.mojom.IDBTaskType } taskType
   * @return {!Promise<{
        result: !blink.mojom.IDBDatabaseOpenCursorResult,
   *  }>}
   */

  openCursor(
      transactionId,
      objectStoreId,
      indexId,
      keyRange,
      direction,
      keyOnly,
      taskType) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.IDBDatabase_OpenCursor_ParamsSpec.$,
        blink.mojom.IDBDatabase_OpenCursor_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange,
          direction,
          keyOnly,
          taskType
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
        count: !number,
   *  }>}
   */

  count(
      transactionId,
      objectStoreId,
      indexId,
      keyRange) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.IDBDatabase_Count_ParamsSpec.$,
        blink.mojom.IDBDatabase_Count_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteRange(
      transactionId,
      objectStoreId,
      keyRange) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.IDBDatabase_DeleteRange_ParamsSpec.$,
        blink.mojom.IDBDatabase_DeleteRange_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          keyRange
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        result: !bigint,
        error: ?blink.mojom.IDBError,
   *  }>}
   */

  getKeyGeneratorCurrentNumber(
      transactionId,
      objectStoreId) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
        blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clear(
      transactionId,
      objectStoreId) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.IDBDatabase_Clear_ParamsSpec.$,
        blink.mojom.IDBDatabase_Clear_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !blink.mojom.IDBIndexMetadata } index
   */

  createIndex(
      transactionId,
      objectStoreId,
      index) {
    this.proxy.sendMessage(
        10,
        blink.mojom.IDBDatabase_CreateIndex_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          index
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   */

  deleteIndex(
      transactionId,
      objectStoreId,
      indexId) {
    this.proxy.sendMessage(
        11,
        blink.mojom.IDBDatabase_DeleteIndex_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          indexId
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !mojoBase.mojom.String16 } newName
   */

  renameIndex(
      transactionId,
      objectStoreId,
      indexId,
      newName) {
    this.proxy.sendMessage(
        12,
        blink.mojom.IDBDatabase_RenameIndex_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          indexId,
          newName
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   */

  abort(
      transactionId) {
    this.proxy.sendMessage(
        13,
        blink.mojom.IDBDatabase_Abort_ParamsSpec.$,
        null,
        [
          transactionId
        ],
        false);
  }

  
  /**
   */

  didBecomeInactive() {
    this.proxy.sendMessage(
        14,
        blink.mojom.IDBDatabase_DidBecomeInactive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } newPriority
   */

  updatePriority(
      newPriority) {
    this.proxy.sendMessage(
        15,
        blink.mojom.IDBDatabase_UpdatePriority_ParamsSpec.$,
        null,
        [
          newPriority
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBDatabase
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBDatabaseReceiver = class {
  /**
   * @param {!blink.mojom.IDBDatabaseInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBDatabaseRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBDatabaseRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBDatabaseRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBDatabase_RenameObjectStore_ParamsSpec.$,
        null,
        impl.renameObjectStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBDatabase_CreateTransaction_ParamsSpec.$,
        null,
        impl.createTransaction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
        null,
        impl.versionChangeIgnored.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBDatabase_Get_ParamsSpec.$,
        blink.mojom.IDBDatabase_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.IDBDatabase_GetAll_ParamsSpec.$,
        blink.mojom.IDBDatabase_GetAll_ResponseParamsSpec.$,
        impl.getAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.IDBDatabase_OpenCursor_ParamsSpec.$,
        blink.mojom.IDBDatabase_OpenCursor_ResponseParamsSpec.$,
        impl.openCursor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.IDBDatabase_Count_ParamsSpec.$,
        blink.mojom.IDBDatabase_Count_ResponseParamsSpec.$,
        impl.count.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.IDBDatabase_DeleteRange_ParamsSpec.$,
        blink.mojom.IDBDatabase_DeleteRange_ResponseParamsSpec.$,
        impl.deleteRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
        blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
        impl.getKeyGeneratorCurrentNumber.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.IDBDatabase_Clear_ParamsSpec.$,
        blink.mojom.IDBDatabase_Clear_ResponseParamsSpec.$,
        impl.clear.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.IDBDatabase_CreateIndex_ParamsSpec.$,
        null,
        impl.createIndex.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.IDBDatabase_DeleteIndex_ParamsSpec.$,
        null,
        impl.deleteIndex.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.IDBDatabase_RenameIndex_ParamsSpec.$,
        null,
        impl.renameIndex.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.IDBDatabase_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.IDBDatabase_DidBecomeInactive_ParamsSpec.$,
        null,
        impl.didBecomeInactive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.IDBDatabase_UpdatePriority_ParamsSpec.$,
        null,
        impl.updatePriority.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBDatabase = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBDatabase";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBDatabaseRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBDatabaseRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBDatabase
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBDatabaseCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBDatabaseRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBDatabaseRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameObjectStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBDatabase_RenameObjectStore_ParamsSpec.$,
        null,
        this.renameObjectStore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTransaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBDatabase_CreateTransaction_ParamsSpec.$,
        null,
        this.createTransaction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.versionChangeIgnored =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
        null,
        this.versionChangeIgnored.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.IDBDatabase_Get_ParamsSpec.$,
        blink.mojom.IDBDatabase_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.IDBDatabase_GetAll_ParamsSpec.$,
        blink.mojom.IDBDatabase_GetAll_ResponseParamsSpec.$,
        this.getAll.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openCursor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.IDBDatabase_OpenCursor_ParamsSpec.$,
        blink.mojom.IDBDatabase_OpenCursor_ResponseParamsSpec.$,
        this.openCursor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.count =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.IDBDatabase_Count_ParamsSpec.$,
        blink.mojom.IDBDatabase_Count_ResponseParamsSpec.$,
        this.count.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.IDBDatabase_DeleteRange_ParamsSpec.$,
        blink.mojom.IDBDatabase_DeleteRange_ResponseParamsSpec.$,
        this.deleteRange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getKeyGeneratorCurrentNumber =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
        blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
        this.getKeyGeneratorCurrentNumber.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clear =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.IDBDatabase_Clear_ParamsSpec.$,
        blink.mojom.IDBDatabase_Clear_ResponseParamsSpec.$,
        this.clear.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createIndex =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.IDBDatabase_CreateIndex_ParamsSpec.$,
        null,
        this.createIndex.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteIndex =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.IDBDatabase_DeleteIndex_ParamsSpec.$,
        null,
        this.deleteIndex.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameIndex =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.IDBDatabase_RenameIndex_ParamsSpec.$,
        null,
        this.renameIndex.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.IDBDatabase_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didBecomeInactive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.IDBDatabase_DidBecomeInactive_ParamsSpec.$,
        null,
        this.didBecomeInactive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.IDBDatabase_UpdatePriority_ParamsSpec.$,
        null,
        this.updatePriority.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBFactory');
goog.provide('blink.mojom.IDBFactoryReceiver');
goog.provide('blink.mojom.IDBFactoryCallbackRouter');
goog.provide('blink.mojom.IDBFactoryInterface');
goog.provide('blink.mojom.IDBFactoryRemote');
goog.provide('blink.mojom.IDBFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.IDBFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.IDBFactory.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.IDBFactoryInterface = class {
  
  /**
   * @return {!Promise<{
        namesAndVersions: !Array<!blink.mojom.IDBNameAndVersion>,
        error: !blink.mojom.IDBError,
   *  }>}
   */

  getDatabaseInfo() {}
  
  /**
   * @param { !Object } client
   * @param { !Object } databaseCallbacks
   * @param { !mojoBase.mojom.String16 } name
   * @param { !bigint } version
   * @param { !Object } versionChangeTransactionReceiver
   * @param { !bigint } transactionId
   * @param { !number } priority
   */

  open(client, databaseCallbacks, name, version, versionChangeTransactionReceiver, transactionId, priority) {}
  
  /**
   * @param { !Object } client
   * @param { !mojoBase.mojom.String16 } name
   * @param { !boolean } forceClose
   */

  deleteDatabase(client, name, forceClose) {}
};

/**
 * @export
 * @implements { blink.mojom.IDBFactoryInterface }
 */
blink.mojom.IDBFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.IDBFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.IDBFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.IDBFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        namesAndVersions: !Array<!blink.mojom.IDBNameAndVersion>,
        error: !blink.mojom.IDBError,
   *  }>}
   */

  getDatabaseInfo() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.IDBFactory_GetDatabaseInfo_ParamsSpec.$,
        blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !Object } databaseCallbacks
   * @param { !mojoBase.mojom.String16 } name
   * @param { !bigint } version
   * @param { !Object } versionChangeTransactionReceiver
   * @param { !bigint } transactionId
   * @param { !number } priority
   */

  open(
      client,
      databaseCallbacks,
      name,
      version,
      versionChangeTransactionReceiver,
      transactionId,
      priority) {
    this.proxy.sendMessage(
        1,
        blink.mojom.IDBFactory_Open_ParamsSpec.$,
        null,
        [
          client,
          databaseCallbacks,
          name,
          version,
          versionChangeTransactionReceiver,
          transactionId,
          priority
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !mojoBase.mojom.String16 } name
   * @param { !boolean } forceClose
   */

  deleteDatabase(
      client,
      name,
      forceClose) {
    this.proxy.sendMessage(
        2,
        blink.mojom.IDBFactory_DeleteDatabase_ParamsSpec.$,
        null,
        [
          client,
          name,
          forceClose
        ],
        false);
  }
};

/**
 * An object which receives request messages for the IDBFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.IDBFactoryReceiver = class {
  /**
   * @param {!blink.mojom.IDBFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.IDBFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.IDBFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBFactory_GetDatabaseInfo_ParamsSpec.$,
        blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
        impl.getDatabaseInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBFactory_Open_ParamsSpec.$,
        null,
        impl.open.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBFactory_DeleteDatabase_ParamsSpec.$,
        null,
        impl.deleteDatabase.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.IDBFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.IDBFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.IDBFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the IDBFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.IDBFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.IDBFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.IDBFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDatabaseInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.IDBFactory_GetDatabaseInfo_ParamsSpec.$,
        blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
        this.getDatabaseInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.IDBFactory_Open_ParamsSpec.$,
        null,
        this.open.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteDatabase =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.IDBFactory_DeleteDatabase_ParamsSpec.$,
        null,
        this.deleteDatabase.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.IDBKeyPathSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBKeyPathSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBKeyRangeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBKeyRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBIndexMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBIndexMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBObjectStoreMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBObjectStoreMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBNameAndVersionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBNameAndVersionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBIndexKeysSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBIndexKeysSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFileInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBBlobInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBBlobInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBValueSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBReturnValueSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBReturnValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBRecordSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBErrorSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursorValueSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursorValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseOpenCursorValueSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseOpenCursorValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactoryClient_Error_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactoryClient_Error_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactoryClient_Blocked_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactoryClient_Blocked_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactoryClient_UpgradeNeeded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactoryClient_UpgradeNeeded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactoryClient_OpenSuccess_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactoryClient_OpenSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactoryClient_DeleteSuccess_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactoryClient_DeleteSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseCallbacks_ForcedClose_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseCallbacks_ForcedClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseCallbacks_VersionChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseCallbacks_VersionChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseCallbacks_Abort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseCallbacks_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseCallbacks_Complete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseCallbacks_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_Advance_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_Advance_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_Advance_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_Advance_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_Continue_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_Continue_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_Continue_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_Continue_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_Prefetch_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_Prefetch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_Prefetch_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_Prefetch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursor_PrefetchReset_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBCursor_PrefetchReset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_CreateObjectStore_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_CreateObjectStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_DeleteObjectStore_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_DeleteObjectStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_Put_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_Put_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_Put_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_Put_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_SetIndexKeys_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_SetIndexKeys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_SetIndexKeysDone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_SetIndexKeysDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransaction_Commit_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBTransaction_Commit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseGetAllResultSink_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabaseGetAllResultSink_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_RenameObjectStore_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_RenameObjectStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_CreateTransaction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_CreateTransaction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_VersionChangeIgnored_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_VersionChangeIgnored_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Get_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Get_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_GetAll_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_GetAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_GetAll_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_GetAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_OpenCursor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_OpenCursor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_OpenCursor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_OpenCursor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Count_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Count_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Count_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Count_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_DeleteRange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_DeleteRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_DeleteRange_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_DeleteRange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Clear_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Clear_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Clear_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Clear_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_CreateIndex_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_CreateIndex_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_DeleteIndex_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_DeleteIndex_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_RenameIndex_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_RenameIndex_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_Abort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_DidBecomeInactive_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_DidBecomeInactive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabase_UpdatePriority_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBDatabase_UpdatePriority_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactory_GetDatabaseInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactory_GetDatabaseInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactory_Open_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactory_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBFactory_DeleteDatabase_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IDBFactory_DeleteDatabase_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBKeySpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBKeyPathDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBKeyPathDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBExternalObjectSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBExternalObjectSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBCursorResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBCursorResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBTransactionPutResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBTransactionPutResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseGetResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBDatabaseGetResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.IDBDatabaseOpenCursorResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IDBDatabaseOpenCursorResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.IDBKeyPathSpec.$,
    'IDBKeyPath',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        blink.mojom.IDBKeyPathDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBKeyPath');

/** @record */
blink.mojom.IDBKeyPath = class {
  constructor() {
    /** @export { (blink.mojom.IDBKeyPathData|undefined) } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBKeyRangeSpec.$,
    'IDBKeyRange',
    [
      mojo.internal.StructField(
        'lower', 0,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'upper', 16,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lowerOpen', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'upperOpen', 32,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.IDBKeyRange');

/** @record */
blink.mojom.IDBKeyRange = class {
  constructor() {
    /** @export { !blink.mojom.IDBKey } */
    this.lower;
    /** @export { !blink.mojom.IDBKey } */
    this.upper;
    /** @export { !boolean } */
    this.lowerOpen;
    /** @export { !boolean } */
    this.upperOpen;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBIndexMetadataSpec.$,
    'IDBIndexMetadata',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyPath', 16,
        0,
        blink.mojom.IDBKeyPathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unique', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multiEntry', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBIndexMetadata');

/** @record */
blink.mojom.IDBIndexMetadata = class {
  constructor() {
    /** @export { !bigint } */
    this.id;
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !blink.mojom.IDBKeyPath } */
    this.keyPath;
    /** @export { !boolean } */
    this.unique;
    /** @export { !boolean } */
    this.multiEntry;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBObjectStoreMetadataSpec.$,
    'IDBObjectStoreMetadata',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyPath', 16,
        0,
        blink.mojom.IDBKeyPathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'autoIncrement', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxIndexId', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexes', 40,
        0,
        mojo.internal.Map(mojo.internal.Int64, blink.mojom.IDBIndexMetadataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.IDBObjectStoreMetadata');

/** @record */
blink.mojom.IDBObjectStoreMetadata = class {
  constructor() {
    /** @export { !bigint } */
    this.id;
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !blink.mojom.IDBKeyPath } */
    this.keyPath;
    /** @export { !boolean } */
    this.autoIncrement;
    /** @export { !bigint } */
    this.maxIndexId;
    /** @export { !Map<!bigint, !blink.mojom.IDBIndexMetadata> } */
    this.indexes;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseMetadataSpec.$,
    'IDBDatabaseMetadata',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxObjectStoreId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStores', 24,
        0,
        mojo.internal.Map(mojo.internal.Int64, blink.mojom.IDBObjectStoreMetadataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasColdOpen', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.IDBDatabaseMetadata');

/** @record */
blink.mojom.IDBDatabaseMetadata = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !bigint } */
    this.version;
    /** @export { !bigint } */
    this.maxObjectStoreId;
    /** @export { !Map<!bigint, !blink.mojom.IDBObjectStoreMetadata> } */
    this.objectStores;
    /** @export { !boolean } */
    this.wasColdOpen;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBNameAndVersionSpec.$,
    'IDBNameAndVersion',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBNameAndVersion');

/** @record */
blink.mojom.IDBNameAndVersion = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !bigint } */
    this.version;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBIndexKeysSpec.$,
    'IDBIndexKeys',
    [
      mojo.internal.StructField(
        'indexId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexKeys', 8,
        0,
        mojo.internal.Array(blink.mojom.IDBKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBIndexKeys');

/** @record */
blink.mojom.IDBIndexKeys = class {
  constructor() {
    /** @export { !bigint } */
    this.indexId;
    /** @export { !Array<!blink.mojom.IDBKey> } */
    this.indexKeys;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFileInfoSpec.$,
    'IDBFileInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastModified', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBFileInfo');

/** @record */
blink.mojom.IDBFileInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !mojoBase.mojom.Time } */
    this.lastModified;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBBlobInfoSpec.$,
    'IDBBlobInfo',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'file', 24,
        0,
        blink.mojom.IDBFileInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBBlobInfo');

/** @record */
blink.mojom.IDBBlobInfo = class {
  constructor() {
    /** @export { !blink.mojom.BlobRemote } */
    this.blob;
    /** @export { !mojoBase.mojom.String16 } */
    this.mimeType;
    /** @export { !bigint } */
    this.size;
    /** @export { (blink.mojom.IDBFileInfo|undefined) } */
    this.file;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBValueSpec.$,
    'IDBValue',
    [
      mojo.internal.StructField(
        'bits', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'externalObjects', 8,
        0,
        mojo.internal.Array(blink.mojom.IDBExternalObjectSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBValue');

/** @record */
blink.mojom.IDBValue = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.bits;
    /** @export { !Array<!blink.mojom.IDBExternalObject> } */
    this.externalObjects;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBReturnValueSpec.$,
    'IDBReturnValue',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        blink.mojom.IDBValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryKey', 8,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyPath', 24,
        0,
        blink.mojom.IDBKeyPathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBReturnValue');

/** @record */
blink.mojom.IDBReturnValue = class {
  constructor() {
    /** @export { !blink.mojom.IDBValue } */
    this.value;
    /** @export { !blink.mojom.IDBKey } */
    this.primaryKey;
    /** @export { !blink.mojom.IDBKeyPath } */
    this.keyPath;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBRecordSpec.$,
    'IDBRecord',
    [
      mojo.internal.StructField(
        'primaryKey', 0,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'returnValue', 16,
        0,
        blink.mojom.IDBReturnValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexKey', 24,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.IDBRecord');

/** @record */
blink.mojom.IDBRecord = class {
  constructor() {
    /** @export { (blink.mojom.IDBKey|undefined) } */
    this.primaryKey;
    /** @export { (blink.mojom.IDBReturnValue|undefined) } */
    this.returnValue;
    /** @export { (blink.mojom.IDBKey|undefined) } */
    this.indexKey;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBErrorSpec.$,
    'IDBError',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        blink.mojom.IDBExceptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBError');

/** @record */
blink.mojom.IDBError = class {
  constructor() {
    /** @export { !blink.mojom.IDBException } */
    this.errorCode;
    /** @export { !mojoBase.mojom.String16 } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursorValueSpec.$,
    'IDBCursorValue',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(blink.mojom.IDBKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryKeys', 8,
        0,
        mojo.internal.Array(blink.mojom.IDBKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'values', 16,
        0,
        mojo.internal.Array(blink.mojom.IDBValueSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBCursorValue');

/** @record */
blink.mojom.IDBCursorValue = class {
  constructor() {
    /** @export { !Array<!blink.mojom.IDBKey> } */
    this.keys;
    /** @export { !Array<!blink.mojom.IDBKey> } */
    this.primaryKeys;
    /** @export { !Array<!blink.mojom.IDBValue> } */
    this.values;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseOpenCursorValueSpec.$,
    'IDBDatabaseOpenCursorValue',
    [
      mojo.internal.StructField(
        'cursor', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.IDBCursorRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'key', 8,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryKey', 24,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 40,
        0,
        blink.mojom.IDBValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.IDBDatabaseOpenCursorValue');

/** @record */
blink.mojom.IDBDatabaseOpenCursorValue = class {
  constructor() {
    /** @export { !Object } */
    this.cursor;
    /** @export { !blink.mojom.IDBKey } */
    this.key;
    /** @export { !blink.mojom.IDBKey } */
    this.primaryKey;
    /** @export { (blink.mojom.IDBValue|undefined) } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactoryClient_Error_ParamsSpec.$,
    'IDBFactoryClient_Error_Params',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        blink.mojom.IDBExceptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBFactoryClient_Error_Params');

/** @record */
blink.mojom.IDBFactoryClient_Error_Params = class {
  constructor() {
    /** @export { !blink.mojom.IDBException } */
    this.code;
    /** @export { !mojoBase.mojom.String16 } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactoryClient_Blocked_ParamsSpec.$,
    'IDBFactoryClient_Blocked_Params',
    [
      mojo.internal.StructField(
        'existingVersion', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBFactoryClient_Blocked_Params');

/** @record */
blink.mojom.IDBFactoryClient_Blocked_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.existingVersion;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
    'IDBFactoryClient_UpgradeNeeded_Params',
    [
      mojo.internal.StructField(
        'pendingDatabase', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.IDBDatabaseRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'oldVersion', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataLoss', 16,
        0,
        blink.mojom.IDBDataLossSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataLossMessage', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dbMetadata', 32,
        0,
        blink.mojom.IDBDatabaseMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.IDBFactoryClient_UpgradeNeeded_Params');

/** @record */
blink.mojom.IDBFactoryClient_UpgradeNeeded_Params = class {
  constructor() {
    /** @export { !Object } */
    this.pendingDatabase;
    /** @export { !bigint } */
    this.oldVersion;
    /** @export { !blink.mojom.IDBDataLoss } */
    this.dataLoss;
    /** @export { !string } */
    this.dataLossMessage;
    /** @export { !blink.mojom.IDBDatabaseMetadata } */
    this.dbMetadata;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactoryClient_OpenSuccess_ParamsSpec.$,
    'IDBFactoryClient_OpenSuccess_Params',
    [
      mojo.internal.StructField(
        'pendingDatabase', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.IDBDatabaseRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        blink.mojom.IDBDatabaseMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBFactoryClient_OpenSuccess_Params');

/** @record */
blink.mojom.IDBFactoryClient_OpenSuccess_Params = class {
  constructor() {
    /** @export { (Object|undefined) } */
    this.pendingDatabase;
    /** @export { !blink.mojom.IDBDatabaseMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
    'IDBFactoryClient_DeleteSuccess_Params',
    [
      mojo.internal.StructField(
        'oldVersion', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBFactoryClient_DeleteSuccess_Params');

/** @record */
blink.mojom.IDBFactoryClient_DeleteSuccess_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.oldVersion;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
    'IDBDatabaseCallbacks_ForcedClose_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.IDBDatabaseCallbacks_ForcedClose_Params');

/** @record */
blink.mojom.IDBDatabaseCallbacks_ForcedClose_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
    'IDBDatabaseCallbacks_VersionChange_Params',
    [
      mojo.internal.StructField(
        'oldVersion', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newVersion', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabaseCallbacks_VersionChange_Params');

/** @record */
blink.mojom.IDBDatabaseCallbacks_VersionChange_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.oldVersion;
    /** @export { !bigint } */
    this.newVersion;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseCallbacks_Abort_ParamsSpec.$,
    'IDBDatabaseCallbacks_Abort_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'code', 8,
        0,
        blink.mojom.IDBExceptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBDatabaseCallbacks_Abort_Params');

/** @record */
blink.mojom.IDBDatabaseCallbacks_Abort_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !blink.mojom.IDBException } */
    this.code;
    /** @export { !mojoBase.mojom.String16 } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseCallbacks_Complete_ParamsSpec.$,
    'IDBDatabaseCallbacks_Complete_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabaseCallbacks_Complete_Params');

/** @record */
blink.mojom.IDBDatabaseCallbacks_Complete_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_Advance_ParamsSpec.$,
    'IDBCursor_Advance_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBCursor_Advance_Params');

/** @record */
blink.mojom.IDBCursor_Advance_Params = class {
  constructor() {
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_Advance_ResponseParamsSpec.$,
    'IDBCursor_Advance_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.IDBCursorResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBCursor_Advance_ResponseParams');

/** @record */
blink.mojom.IDBCursor_Advance_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IDBCursorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_Continue_ParamsSpec.$,
    'IDBCursor_Continue_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryKey', 16,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBCursor_Continue_Params');

/** @record */
blink.mojom.IDBCursor_Continue_Params = class {
  constructor() {
    /** @export { !blink.mojom.IDBKey } */
    this.key;
    /** @export { !blink.mojom.IDBKey } */
    this.primaryKey;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_Continue_ResponseParamsSpec.$,
    'IDBCursor_Continue_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.IDBCursorResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBCursor_Continue_ResponseParams');

/** @record */
blink.mojom.IDBCursor_Continue_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IDBCursorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_Prefetch_ParamsSpec.$,
    'IDBCursor_Prefetch_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBCursor_Prefetch_Params');

/** @record */
blink.mojom.IDBCursor_Prefetch_Params = class {
  constructor() {
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_Prefetch_ResponseParamsSpec.$,
    'IDBCursor_Prefetch_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.IDBCursorResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBCursor_Prefetch_ResponseParams');

/** @record */
blink.mojom.IDBCursor_Prefetch_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IDBCursorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBCursor_PrefetchReset_ParamsSpec.$,
    'IDBCursor_PrefetchReset_Params',
    [
      mojo.internal.StructField(
        'usedPrefetches', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBCursor_PrefetchReset_Params');

/** @record */
blink.mojom.IDBCursor_PrefetchReset_Params = class {
  constructor() {
    /** @export { !number } */
    this.usedPrefetches;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_CreateObjectStore_ParamsSpec.$,
    'IDBTransaction_CreateObjectStore_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyPath', 16,
        0,
        blink.mojom.IDBKeyPathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'autoIncrement', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBTransaction_CreateObjectStore_Params');

/** @record */
blink.mojom.IDBTransaction_CreateObjectStore_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !blink.mojom.IDBKeyPath } */
    this.keyPath;
    /** @export { !boolean } */
    this.autoIncrement;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_DeleteObjectStore_ParamsSpec.$,
    'IDBTransaction_DeleteObjectStore_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBTransaction_DeleteObjectStore_Params');

/** @record */
blink.mojom.IDBTransaction_DeleteObjectStore_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.objectStoreId;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_Put_ParamsSpec.$,
    'IDBTransaction_Put_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        blink.mojom.IDBValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'key', 16,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 32,
        0,
        blink.mojom.IDBPutModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexKeys', 40,
        0,
        mojo.internal.Array(blink.mojom.IDBIndexKeysSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.IDBTransaction_Put_Params');

/** @record */
blink.mojom.IDBTransaction_Put_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !blink.mojom.IDBValue } */
    this.value;
    /** @export { !blink.mojom.IDBKey } */
    this.key;
    /** @export { !blink.mojom.IDBPutMode } */
    this.mode;
    /** @export { !Array<!blink.mojom.IDBIndexKeys> } */
    this.indexKeys;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_Put_ResponseParamsSpec.$,
    'IDBTransaction_Put_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.IDBTransactionPutResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBTransaction_Put_ResponseParams');

/** @record */
blink.mojom.IDBTransaction_Put_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IDBTransactionPutResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_SetIndexKeys_ParamsSpec.$,
    'IDBTransaction_SetIndexKeys_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryKey', 8,
        0,
        blink.mojom.IDBKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexKeys', 24,
        0,
        blink.mojom.IDBIndexKeysSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBTransaction_SetIndexKeys_Params');

/** @record */
blink.mojom.IDBTransaction_SetIndexKeys_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !blink.mojom.IDBKey } */
    this.primaryKey;
    /** @export { !blink.mojom.IDBIndexKeys } */
    this.indexKeys;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
    'IDBTransaction_SetIndexKeysDone_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.IDBTransaction_SetIndexKeysDone_Params');

/** @record */
blink.mojom.IDBTransaction_SetIndexKeysDone_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.IDBTransaction_Commit_ParamsSpec.$,
    'IDBTransaction_Commit_Params',
    [
      mojo.internal.StructField(
        'numErrorsHandled', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBTransaction_Commit_Params');

/** @record */
blink.mojom.IDBTransaction_Commit_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.numErrorsHandled;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
    'IDBDatabaseGetAllResultSink_ReceiveResults_Params',
    [
      mojo.internal.StructField(
        'records', 0,
        0,
        mojo.internal.Array(blink.mojom.IDBRecordSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'done', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_Params');

/** @record */
blink.mojom.IDBDatabaseGetAllResultSink_ReceiveResults_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.IDBRecord> } */
    this.records;
    /** @export { !boolean } */
    this.done;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
    'IDBDatabaseGetAllResultSink_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.IDBErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabaseGetAllResultSink_OnError_Params');

/** @record */
blink.mojom.IDBDatabaseGetAllResultSink_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.IDBError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_RenameObjectStore_ParamsSpec.$,
    'IDBDatabase_RenameObjectStore_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newName', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBDatabase_RenameObjectStore_Params');

/** @record */
blink.mojom.IDBDatabase_RenameObjectStore_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !mojoBase.mojom.String16 } */
    this.newName;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_CreateTransaction_ParamsSpec.$,
    'IDBDatabase_CreateTransaction_Params',
    [
      mojo.internal.StructField(
        'transactionReceiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.IDBTransactionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transactionId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreIds', 16,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 4,
        0,
        blink.mojom.IDBTransactionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'durability', 24,
        0,
        blink.mojom.IDBTransactionDurabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBDatabase_CreateTransaction_Params');

/** @record */
blink.mojom.IDBDatabase_CreateTransaction_Params = class {
  constructor() {
    /** @export { !Object } */
    this.transactionReceiver;
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !Array<!bigint> } */
    this.objectStoreIds;
    /** @export { !blink.mojom.IDBTransactionMode } */
    this.mode;
    /** @export { !blink.mojom.IDBTransactionDurability } */
    this.durability;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
    'IDBDatabase_VersionChangeIgnored_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.IDBDatabase_VersionChangeIgnored_Params');

/** @record */
blink.mojom.IDBDatabase_VersionChangeIgnored_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Get_ParamsSpec.$,
    'IDBDatabase_Get_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        blink.mojom.IDBKeyRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyOnly', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.IDBDatabase_Get_Params');

/** @record */
blink.mojom.IDBDatabase_Get_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !bigint } */
    this.indexId;
    /** @export { !blink.mojom.IDBKeyRange } */
    this.keyRange;
    /** @export { !boolean } */
    this.keyOnly;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Get_ResponseParamsSpec.$,
    'IDBDatabase_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.IDBDatabaseGetResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabase_Get_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_Get_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IDBDatabaseGetResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_GetAll_ParamsSpec.$,
    'IDBDatabase_GetAll_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        blink.mojom.IDBKeyRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultType', 32,
        0,
        blink.mojom.IDBGetAllResultTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxCount', 40,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'direction', 36,
        0,
        blink.mojom.IDBCursorDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.IDBDatabase_GetAll_Params');

/** @record */
blink.mojom.IDBDatabase_GetAll_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !bigint } */
    this.indexId;
    /** @export { !blink.mojom.IDBKeyRange } */
    this.keyRange;
    /** @export { !blink.mojom.IDBGetAllResultType } */
    this.resultType;
    /** @export { !bigint } */
    this.maxCount;
    /** @export { !blink.mojom.IDBCursorDirection } */
    this.direction;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_GetAll_ResponseParamsSpec.$,
    'IDBDatabase_GetAll_ResponseParams',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.IDBDatabaseGetAllResultSinkPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabase_GetAll_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_GetAll_ResponseParams = class {
  constructor() {
    /** @export { !Object } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_OpenCursor_ParamsSpec.$,
    'IDBDatabase_OpenCursor_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        blink.mojom.IDBKeyRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'direction', 32,
        0,
        blink.mojom.IDBCursorDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyOnly', 36,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'taskType', 40,
        0,
        blink.mojom.IDBTaskTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.IDBDatabase_OpenCursor_Params');

/** @record */
blink.mojom.IDBDatabase_OpenCursor_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !bigint } */
    this.indexId;
    /** @export { !blink.mojom.IDBKeyRange } */
    this.keyRange;
    /** @export { !blink.mojom.IDBCursorDirection } */
    this.direction;
    /** @export { !boolean } */
    this.keyOnly;
    /** @export { !blink.mojom.IDBTaskType } */
    this.taskType;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_OpenCursor_ResponseParamsSpec.$,
    'IDBDatabase_OpenCursor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.IDBDatabaseOpenCursorResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabase_OpenCursor_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_OpenCursor_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.IDBDatabaseOpenCursorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Count_ParamsSpec.$,
    'IDBDatabase_Count_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        blink.mojom.IDBKeyRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBDatabase_Count_Params');

/** @record */
blink.mojom.IDBDatabase_Count_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !bigint } */
    this.indexId;
    /** @export { !blink.mojom.IDBKeyRange } */
    this.keyRange;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Count_ResponseParamsSpec.$,
    'IDBDatabase_Count_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'count', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabase_Count_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_Count_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_DeleteRange_ParamsSpec.$,
    'IDBDatabase_DeleteRange_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyRange', 16,
        0,
        blink.mojom.IDBKeyRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBDatabase_DeleteRange_Params');

/** @record */
blink.mojom.IDBDatabase_DeleteRange_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !blink.mojom.IDBKeyRange } */
    this.keyRange;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_DeleteRange_ResponseParamsSpec.$,
    'IDBDatabase_DeleteRange_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabase_DeleteRange_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_DeleteRange_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
    'IDBDatabase_GetKeyGeneratorCurrentNumber_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_Params');

/** @record */
blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
    'IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.IDBErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams = class {
  constructor() {
    /** @export { !bigint } */
    this.result;
    /** @export { (blink.mojom.IDBError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Clear_ParamsSpec.$,
    'IDBDatabase_Clear_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBDatabase_Clear_Params');

/** @record */
blink.mojom.IDBDatabase_Clear_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Clear_ResponseParamsSpec.$,
    'IDBDatabase_Clear_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabase_Clear_ResponseParams');

/** @record */
blink.mojom.IDBDatabase_Clear_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_CreateIndex_ParamsSpec.$,
    'IDBDatabase_CreateIndex_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'index', 16,
        0,
        blink.mojom.IDBIndexMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBDatabase_CreateIndex_Params');

/** @record */
blink.mojom.IDBDatabase_CreateIndex_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !blink.mojom.IDBIndexMetadata } */
    this.index;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_DeleteIndex_ParamsSpec.$,
    'IDBDatabase_DeleteIndex_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBDatabase_DeleteIndex_Params');

/** @record */
blink.mojom.IDBDatabase_DeleteIndex_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !bigint } */
    this.indexId;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_RenameIndex_ParamsSpec.$,
    'IDBDatabase_RenameIndex_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newName', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.IDBDatabase_RenameIndex_Params');

/** @record */
blink.mojom.IDBDatabase_RenameIndex_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !bigint } */
    this.objectStoreId;
    /** @export { !bigint } */
    this.indexId;
    /** @export { !mojoBase.mojom.String16 } */
    this.newName;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_Abort_ParamsSpec.$,
    'IDBDatabase_Abort_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabase_Abort_Params');

/** @record */
blink.mojom.IDBDatabase_Abort_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.transactionId;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_DidBecomeInactive_ParamsSpec.$,
    'IDBDatabase_DidBecomeInactive_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.IDBDatabase_DidBecomeInactive_Params');

/** @record */
blink.mojom.IDBDatabase_DidBecomeInactive_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.IDBDatabase_UpdatePriority_ParamsSpec.$,
    'IDBDatabase_UpdatePriority_Params',
    [
      mojo.internal.StructField(
        'newPriority', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.IDBDatabase_UpdatePriority_Params');

/** @record */
blink.mojom.IDBDatabase_UpdatePriority_Params = class {
  constructor() {
    /** @export { !number } */
    this.newPriority;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactory_GetDatabaseInfo_ParamsSpec.$,
    'IDBFactory_GetDatabaseInfo_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.IDBFactory_GetDatabaseInfo_Params');

/** @record */
blink.mojom.IDBFactory_GetDatabaseInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
    'IDBFactory_GetDatabaseInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'namesAndVersions', 0,
        0,
        mojo.internal.Array(blink.mojom.IDBNameAndVersionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.IDBErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParams');

/** @record */
blink.mojom.IDBFactory_GetDatabaseInfo_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.IDBNameAndVersion> } */
    this.namesAndVersions;
    /** @export { !blink.mojom.IDBError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactory_Open_ParamsSpec.$,
    'IDBFactory_Open_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.IDBFactoryClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'databaseCallbacks', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.IDBDatabaseCallbacksRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'version', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionChangeTransactionReceiver', 32,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.IDBTransactionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transactionId', 40,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.IDBFactory_Open_Params');

/** @record */
blink.mojom.IDBFactory_Open_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !Object } */
    this.databaseCallbacks;
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !bigint } */
    this.version;
    /** @export { !Object } */
    this.versionChangeTransactionReceiver;
    /** @export { !bigint } */
    this.transactionId;
    /** @export { !number } */
    this.priority;
  }
};



mojo.internal.Struct(
    blink.mojom.IDBFactory_DeleteDatabase_ParamsSpec.$,
    'IDBFactory_DeleteDatabase_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.IDBFactoryClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceClose', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.IDBFactory_DeleteDatabase_Params');

/** @record */
blink.mojom.IDBFactory_DeleteDatabase_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !boolean } */
    this.forceClose;
  }
};

goog.provide('blink.mojom.IDBKey');


mojo.internal.Union(
    blink.mojom.IDBKeySpec.$, 'IDBKey',
    {
      'keyArray': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink.mojom.IDBKeySpec.$, false),
      },
      'binary': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
      'string': {
        'ordinal': 2,
        'type': mojoBase.mojom.String16Spec.$,
      },
      'date': {
        'ordinal': 3,
        'type': mojo.internal.Double,
      },
      'number': {
        'ordinal': 4,
        'type': mojo.internal.Double,
      },
      'otherNone': {
        'ordinal': 5,
        'type': mojo.internal.Bool,
      },
    });

/**
 * @typedef { {
 *   keyArray: (!Array<!blink.mojom.IDBKey>|undefined),
 *   binary: (!Array<!number>|undefined),
 *   string: (!mojoBase.mojom.String16|undefined),
 *   date: (!number|undefined),
 *   number: (!number|undefined),
 *   otherNone: (!boolean|undefined),
 * } }
 */
blink.mojom.IDBKey;
goog.provide('blink.mojom.IDBKeyPathData');


mojo.internal.Union(
    blink.mojom.IDBKeyPathDataSpec.$, 'IDBKeyPathData',
    {
      'string': {
        'ordinal': 0,
        'type': mojoBase.mojom.String16Spec.$,
      },
      'stringArray': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojoBase.mojom.String16Spec.$, false),
      },
    });

/**
 * @typedef { {
 *   string: (!mojoBase.mojom.String16|undefined),
 *   stringArray: (!Array<!mojoBase.mojom.String16>|undefined),
 * } }
 */
blink.mojom.IDBKeyPathData;
goog.provide('blink.mojom.IDBExternalObject');


mojo.internal.Union(
    blink.mojom.IDBExternalObjectSpec.$, 'IDBExternalObject',
    {
      'blobOrFile': {
        'ordinal': 0,
        'type': blink.mojom.IDBBlobInfoSpec.$,
      },
      'fileSystemAccessToken': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
      },
    });

/**
 * @typedef { {
 *   blobOrFile: (!blink.mojom.IDBBlobInfo|undefined),
 *   fileSystemAccessToken: (!blink.mojom.FileSystemAccessTransferTokenRemote|undefined),
 * } }
 */
blink.mojom.IDBExternalObject;
goog.provide('blink.mojom.IDBCursorResult');


mojo.internal.Union(
    blink.mojom.IDBCursorResultSpec.$, 'IDBCursorResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': blink.mojom.IDBErrorSpec.$,
      },
      'empty': {
        'ordinal': 1,
        'type': mojo.internal.Bool,
      },
      'values': {
        'ordinal': 2,
        'type': blink.mojom.IDBCursorValueSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!blink.mojom.IDBError|undefined),
 *   empty: (!boolean|undefined),
 *   values: (!blink.mojom.IDBCursorValue|undefined),
 * } }
 */
blink.mojom.IDBCursorResult;
goog.provide('blink.mojom.IDBTransactionPutResult');


mojo.internal.Union(
    blink.mojom.IDBTransactionPutResultSpec.$, 'IDBTransactionPutResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': blink.mojom.IDBErrorSpec.$,
      },
      'key': {
        'ordinal': 1,
        'type': blink.mojom.IDBKeySpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!blink.mojom.IDBError|undefined),
 *   key: (!blink.mojom.IDBKey|undefined),
 * } }
 */
blink.mojom.IDBTransactionPutResult;
goog.provide('blink.mojom.IDBDatabaseGetResult');


mojo.internal.Union(
    blink.mojom.IDBDatabaseGetResultSpec.$, 'IDBDatabaseGetResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': blink.mojom.IDBErrorSpec.$,
      },
      'empty': {
        'ordinal': 1,
        'type': mojo.internal.Bool,
      },
      'key': {
        'ordinal': 2,
        'type': blink.mojom.IDBKeySpec.$,
      },
      'value': {
        'ordinal': 3,
        'type': blink.mojom.IDBReturnValueSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!blink.mojom.IDBError|undefined),
 *   empty: (!boolean|undefined),
 *   key: (!blink.mojom.IDBKey|undefined),
 *   value: (!blink.mojom.IDBReturnValue|undefined),
 * } }
 */
blink.mojom.IDBDatabaseGetResult;
goog.provide('blink.mojom.IDBDatabaseOpenCursorResult');


mojo.internal.Union(
    blink.mojom.IDBDatabaseOpenCursorResultSpec.$, 'IDBDatabaseOpenCursorResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': blink.mojom.IDBErrorSpec.$,
      },
      'empty': {
        'ordinal': 1,
        'type': mojo.internal.Bool,
      },
      'value': {
        'ordinal': 2,
        'type': blink.mojom.IDBDatabaseOpenCursorValueSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!blink.mojom.IDBError|undefined),
 *   empty: (!boolean|undefined),
 *   value: (!blink.mojom.IDBDatabaseOpenCursorValue|undefined),
 * } }
 */
blink.mojom.IDBDatabaseOpenCursorResult;
