// third_party/blink/public/mojom/input/input_handler.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BrowserControlsOffsetTagModifications as cc_mojom_BrowserControlsOffsetTagModifications,
  BrowserControlsOffsetTagModificationsSpec as cc_mojom_BrowserControlsOffsetTagModificationsSpec
} from '../../../../../cc/mojom/browser_controls_offset_tag_modifications.mojom.m.js';

import {
  BrowserControlsState as cc_mojom_BrowserControlsState,
  BrowserControlsStateSpec as cc_mojom_BrowserControlsStateSpec
} from '../../../../../cc/mojom/browser_controls_state.mojom.m.js';

import {
  OverscrollBehavior as cc_mojom_OverscrollBehavior,
  OverscrollBehaviorSpec as cc_mojom_OverscrollBehaviorSpec
} from '../../../../../cc/mojom/overscroll_behavior.mojom.m.js';

import {
  TouchAction as cc_mojom_TouchAction,
  TouchActionSpec as cc_mojom_TouchActionSpec
} from '../../../../../cc/mojom/touch_action.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  ImeTextSpanType as ui_mojom_ImeTextSpanType,
  ImeTextSpanTypeSpec as ui_mojom_ImeTextSpanTypeSpec,
  ImeTextSpan as ui_mojom_ImeTextSpan,
  ImeTextSpanSpec as ui_mojom_ImeTextSpanSpec
} from '../../../../../ui/base/ime/mojom/ime_types.mojom.m.js';

import {
  EventPointerType as ui_mojom_EventPointerType,
  EventPointerTypeSpec as ui_mojom_EventPointerTypeSpec
} from '../../../../../ui/events/mojom/event_constants.mojom.m.js';

import {
  EventLatencyMetadata as ui_mojom_EventLatencyMetadata,
  EventLatencyMetadataSpec as ui_mojom_EventLatencyMetadataSpec
} from '../../../../../ui/events/mojom/event_latency_metadata.mojom.m.js';

import {
  ScrollGranularity as ui_mojom_ScrollGranularity,
  ScrollGranularitySpec as ui_mojom_ScrollGranularitySpec
} from '../../../../../ui/events/mojom/scroll_granularity.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec,
  PointF as gfx_mojom_PointF,
  PointFSpec as gfx_mojom_PointFSpec,
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec,
  Vector2dF as gfx_mojom_Vector2dF,
  Vector2dFSpec as gfx_mojom_Vector2dFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Range as gfx_mojom_Range,
  RangeSpec as gfx_mojom_RangeSpec
} from '../../../../../ui/gfx/range/mojom/range.mojom.m.js';

import {
  LatencyInfo as ui_mojom_LatencyInfo,
  LatencyInfoSpec as ui_mojom_LatencyInfoSpec
} from '../../../../../ui/latency/mojom/latency_info.mojom.m.js';

import {
  SelectionMenuBehavior as blink_mojom_SelectionMenuBehavior,
  SelectionMenuBehaviorSpec as blink_mojom_SelectionMenuBehaviorSpec
} from '../selection_menu/selection_menu_behavior.mojom.m.js';

import {
  GestureDevice as blink_mojom_GestureDevice,
  GestureDeviceSpec as blink_mojom_GestureDeviceSpec,
  InertialPhaseState as blink_mojom_InertialPhaseState,
  InertialPhaseStateSpec as blink_mojom_InertialPhaseStateSpec
} from './gesture_event.mojom.m.js';

import {
  HandwritingGestureResult as blink_mojom_HandwritingGestureResult,
  HandwritingGestureResultSpec as blink_mojom_HandwritingGestureResultSpec
} from './handwriting_gesture_result.mojom.m.js';

import {
  Button as blink_mojom_Button,
  ButtonSpec as blink_mojom_ButtonSpec,
  DispatchType as blink_mojom_DispatchType,
  DispatchTypeSpec as blink_mojom_DispatchTypeSpec,
  EventType as blink_mojom_EventType,
  EventTypeSpec as blink_mojom_EventTypeSpec
} from './input_event.mojom.m.js';

import {
  InputEventResultSource as blink_mojom_InputEventResultSource,
  InputEventResultSourceSpec as blink_mojom_InputEventResultSourceSpec,
  InputEventResultState as blink_mojom_InputEventResultState,
  InputEventResultStateSpec as blink_mojom_InputEventResultStateSpec
} from './input_event_result.mojom.m.js';

import {
  PointerLockContextRemote as blink_mojom_PointerLockContextRemote,
  PointerLockContextPendingReceiver as blink_mojom_PointerLockContextPendingReceiver
} from './pointer_lock_context.mojom.m.js';

import {
  PointerLockResult as blink_mojom_PointerLockResult,
  PointerLockResultSpec as blink_mojom_PointerLockResultSpec
} from './pointer_lock_result.mojom.m.js';

import {
  StylusWritingGestureData as blink_mojom_StylusWritingGestureData,
  StylusWritingGestureDataSpec as blink_mojom_StylusWritingGestureDataSpec
} from './stylus_writing_gesture.mojom.m.js';

import {
  TouchState as blink_mojom_TouchState,
  TouchStateSpec as blink_mojom_TouchStateSpec
} from './touch_event.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SelectionGranularitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SelectionGranularity = {
  
  kWord: 0,
  kSentence: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PanActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PanAction = {
  
  kNone: 0,
  kScroll: 1,
  kMoveCursorOrScroll: 2,
  kStylusWritable: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FocusStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FocusState = {
  
  kFocused: 0,
  kNotFocusedAndActive: 1,
  kNotFocusedAndNotActive: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WidgetInputHandlerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WidgetInputHandlerHost', scope);
  }
}

/** @interface */
export class WidgetInputHandlerHostInterface {
  
  /**
   * @param { !cc_mojom_TouchAction } touchAction
   */

  setTouchActionFromMain(touchAction) {}
  
  /**
   * @param { !PanAction } panAction
   */

  setPanAction(panAction) {}
  
  /**
   * @param { !DidOverscrollParams } params
   */

  didOverscroll(params) {}
  
  /**
   */

  didStartScrollingViewport() {}
  
  /**
   */

  imeCancelComposition() {}
  
  /**
   * @param { !gfx_mojom_Range } range
   * @param { ?Array<!gfx_mojom_Rect> } characterBounds
   */

  imeCompositionRangeChanged(range, characterBounds) {}
  
  /**
   * @param { !boolean } capture
   */

  setMouseCapture(capture) {}
  
  /**
   * @param { !boolean } autoscrollSelection
   */

  setAutoscrollSelectionActiveInMainFrame(autoscrollSelection) {}
  
  /**
   * @param { !boolean } fromUserGesture
   * @param { !boolean } unadjustedMovement
   * @return {!Promise<{
        result: !blink_mojom_PointerLockResult,
        context: ?blink_mojom_PointerLockContextRemote,
   *  }>}
   */

  requestMouseLock(fromUserGesture, unadjustedMovement) {}
}

/**
 * @implements { WidgetInputHandlerHostInterface }
 */
export class WidgetInputHandlerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WidgetInputHandlerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WidgetInputHandlerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WidgetInputHandlerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !cc_mojom_TouchAction } touchAction
   */

  setTouchActionFromMain(
      touchAction) {
    this.proxy.sendMessage(
        0,
        WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
        null,
        [
          touchAction
        ],
        false);
  }

  
  /**
   * @param { !PanAction } panAction
   */

  setPanAction(
      panAction) {
    this.proxy.sendMessage(
        1,
        WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
        null,
        [
          panAction
        ],
        false);
  }

  
  /**
   * @param { !DidOverscrollParams } params
   */

  didOverscroll(
      params) {
    this.proxy.sendMessage(
        2,
        WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   */

  didStartScrollingViewport() {
    this.proxy.sendMessage(
        3,
        WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  imeCancelComposition() {
    this.proxy.sendMessage(
        4,
        WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Range } range
   * @param { ?Array<!gfx_mojom_Rect> } characterBounds
   */

  imeCompositionRangeChanged(
      range,
      characterBounds) {
    this.proxy.sendMessage(
        5,
        WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
        null,
        [
          range,
          characterBounds
        ],
        false);
  }

  
  /**
   * @param { !boolean } capture
   */

  setMouseCapture(
      capture) {
    this.proxy.sendMessage(
        6,
        WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
        null,
        [
          capture
        ],
        false);
  }

  
  /**
   * @param { !boolean } autoscrollSelection
   */

  setAutoscrollSelectionActiveInMainFrame(
      autoscrollSelection) {
    this.proxy.sendMessage(
        7,
        WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
        null,
        [
          autoscrollSelection
        ],
        false);
  }

  
  /**
   * @param { !boolean } fromUserGesture
   * @param { !boolean } unadjustedMovement
   * @return {!Promise<{
        result: !blink_mojom_PointerLockResult,
        context: ?blink_mojom_PointerLockContextRemote,
   *  }>}
   */

  requestMouseLock(
      fromUserGesture,
      unadjustedMovement) {
    return this.proxy.sendMessage(
        8,
        WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
        WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
        [
          fromUserGesture,
          unadjustedMovement
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WidgetInputHandlerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WidgetInputHandlerHostReceiver {
  /**
   * @param {!WidgetInputHandlerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WidgetInputHandlerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WidgetInputHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetInputHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
        null,
        impl.setTouchActionFromMain.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
        null,
        impl.setPanAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
        null,
        impl.didOverscroll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
        null,
        impl.didStartScrollingViewport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
        null,
        impl.imeCancelComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
        null,
        impl.imeCompositionRangeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
        null,
        impl.setMouseCapture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
        null,
        impl.setAutoscrollSelectionActiveInMainFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
        WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
        impl.requestMouseLock.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WidgetInputHandlerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetInputHandlerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WidgetInputHandlerHostRemote}
   */
  static getRemote() {
    let remote = new WidgetInputHandlerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WidgetInputHandlerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WidgetInputHandlerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WidgetInputHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetInputHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTouchActionFromMain =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
        null,
        this.setTouchActionFromMain.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPanAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
        null,
        this.setPanAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didOverscroll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
        null,
        this.didOverscroll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartScrollingViewport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
        null,
        this.didStartScrollingViewport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeCancelComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
        null,
        this.imeCancelComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeCompositionRangeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
        null,
        this.imeCompositionRangeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMouseCapture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
        null,
        this.setMouseCapture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAutoscrollSelectionActiveInMainFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
        null,
        this.setAutoscrollSelectionActiveInMainFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMouseLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
        WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
        this.requestMouseLock.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FrameWidgetInputHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FrameWidgetInputHandler', scope);
  }
}

/** @interface */
export class FrameWidgetInputHandlerInterface {
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   */

  addImeTextSpansToExistingText(start, end, imeTextSpans) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !ui_mojom_ImeTextSpanType } type
   */

  clearImeTextSpansByType(start, end, type) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   */

  setCompositionFromExistingText(start, end, imeTextSpans) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  extendSelectionAndDelete(before, after) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   * @param { !mojoBase_mojom_String16 } replacementText
   */

  extendSelectionAndReplace(before, after, replacementText) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingText(before, after) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingTextInCodePoints(before, after) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   */

  setEditableSelectionOffsets(start, end) {}
  
  /**
   * @param { !blink_mojom_StylusWritingGestureData } gestureData
   * @return {!Promise<{
        result: !blink_mojom_HandwritingGestureResult,
   *  }>}
   */

  handleStylusWritingGestureAction(gestureData) {}
  
  /**
   * @param { !string } command
   * @param { ?mojoBase_mojom_String16 } value
   */

  executeEditCommand(command, value) {}
  
  /**
   */

  undo() {}
  
  /**
   */

  redo() {}
  
  /**
   */

  cut() {}
  
  /**
   */

  copy() {}
  
  /**
   */

  copyToFindPboard() {}
  
  /**
   */

  centerSelection() {}
  
  /**
   */

  paste() {}
  
  /**
   */

  pasteAndMatchStyle() {}
  
  /**
   */

  delete() {}
  
  /**
   */

  selectAll() {}
  
  /**
   */

  collapseSelection() {}
  
  /**
   * @param { !mojoBase_mojom_String16 } word
   */

  replace(word) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } word
   */

  replaceMisspelling(word) {}
  
  /**
   * @param { !gfx_mojom_Point } base
   * @param { !gfx_mojom_Point } extent
   */

  selectRange(base, extent) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !blink_mojom_SelectionMenuBehavior } behavior
   */

  adjustSelectionByCharacterOffset(start, end, behavior) {}
  
  /**
   * @param { !SelectionGranularity } granularity
   * @param { !boolean } shouldShowHandle
   * @param { !boolean } shouldShowContextMenu
   * @return {!Promise<{
        result: ?SelectAroundCaretResult,
   *  }>}
   */

  selectAroundCaret(granularity, shouldShowHandle, shouldShowContextMenu) {}
  
  /**
   * @param { !gfx_mojom_Point } extent
   */

  moveRangeSelectionExtent(extent) {}
  
  /**
   */

  scrollFocusedEditableNodeIntoView() {}
  
  /**
   * @return {!Promise}
   */

  waitForPageScaleAnimationForTesting() {}
  
  /**
   * @param { !gfx_mojom_Point } point
   */

  moveCaret(point) {}
}

/**
 * @implements { FrameWidgetInputHandlerInterface }
 */
export class FrameWidgetInputHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FrameWidgetInputHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrameWidgetInputHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FrameWidgetInputHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   */

  addImeTextSpansToExistingText(
      start,
      end,
      imeTextSpans) {
    this.proxy.sendMessage(
        0,
        FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
        null,
        [
          start,
          end,
          imeTextSpans
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !ui_mojom_ImeTextSpanType } type
   */

  clearImeTextSpansByType(
      start,
      end,
      type) {
    this.proxy.sendMessage(
        1,
        FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
        null,
        [
          start,
          end,
          type
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   */

  setCompositionFromExistingText(
      start,
      end,
      imeTextSpans) {
    this.proxy.sendMessage(
        2,
        FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
        null,
        [
          start,
          end,
          imeTextSpans
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  extendSelectionAndDelete(
      before,
      after) {
    this.proxy.sendMessage(
        3,
        FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
        null,
        [
          before,
          after
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   * @param { !mojoBase_mojom_String16 } replacementText
   */

  extendSelectionAndReplace(
      before,
      after,
      replacementText) {
    this.proxy.sendMessage(
        4,
        FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
        null,
        [
          before,
          after,
          replacementText
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingText(
      before,
      after) {
    this.proxy.sendMessage(
        5,
        FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
        null,
        [
          before,
          after
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingTextInCodePoints(
      before,
      after) {
    this.proxy.sendMessage(
        6,
        FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
        null,
        [
          before,
          after
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   */

  setEditableSelectionOffsets(
      start,
      end) {
    this.proxy.sendMessage(
        7,
        FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
        null,
        [
          start,
          end
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_StylusWritingGestureData } gestureData
   * @return {!Promise<{
        result: !blink_mojom_HandwritingGestureResult,
   *  }>}
   */

  handleStylusWritingGestureAction(
      gestureData) {
    return this.proxy.sendMessage(
        8,
        FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
        FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
        [
          gestureData
        ],
        false);
  }

  
  /**
   * @param { !string } command
   * @param { ?mojoBase_mojom_String16 } value
   */

  executeEditCommand(
      command,
      value) {
    this.proxy.sendMessage(
        9,
        FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        [
          command,
          value
        ],
        false);
  }

  
  /**
   */

  undo() {
    this.proxy.sendMessage(
        10,
        FrameWidgetInputHandler_Undo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  redo() {
    this.proxy.sendMessage(
        11,
        FrameWidgetInputHandler_Redo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cut() {
    this.proxy.sendMessage(
        12,
        FrameWidgetInputHandler_Cut_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  copy() {
    this.proxy.sendMessage(
        13,
        FrameWidgetInputHandler_Copy_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  copyToFindPboard() {
    this.proxy.sendMessage(
        14,
        FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  centerSelection() {
    this.proxy.sendMessage(
        15,
        FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  paste() {
    this.proxy.sendMessage(
        16,
        FrameWidgetInputHandler_Paste_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  pasteAndMatchStyle() {
    this.proxy.sendMessage(
        17,
        FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  delete() {
    this.proxy.sendMessage(
        18,
        FrameWidgetInputHandler_Delete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  selectAll() {
    this.proxy.sendMessage(
        19,
        FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  collapseSelection() {
    this.proxy.sendMessage(
        20,
        FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } word
   */

  replace(
      word) {
    this.proxy.sendMessage(
        21,
        FrameWidgetInputHandler_Replace_ParamsSpec.$,
        null,
        [
          word
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } word
   */

  replaceMisspelling(
      word) {
    this.proxy.sendMessage(
        22,
        FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
        null,
        [
          word
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Point } base
   * @param { !gfx_mojom_Point } extent
   */

  selectRange(
      base,
      extent) {
    this.proxy.sendMessage(
        23,
        FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
        null,
        [
          base,
          extent
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !blink_mojom_SelectionMenuBehavior } behavior
   */

  adjustSelectionByCharacterOffset(
      start,
      end,
      behavior) {
    this.proxy.sendMessage(
        24,
        FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
        null,
        [
          start,
          end,
          behavior
        ],
        false);
  }

  
  /**
   * @param { !SelectionGranularity } granularity
   * @param { !boolean } shouldShowHandle
   * @param { !boolean } shouldShowContextMenu
   * @return {!Promise<{
        result: ?SelectAroundCaretResult,
   *  }>}
   */

  selectAroundCaret(
      granularity,
      shouldShowHandle,
      shouldShowContextMenu) {
    return this.proxy.sendMessage(
        25,
        FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
        FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
        [
          granularity,
          shouldShowHandle,
          shouldShowContextMenu
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Point } extent
   */

  moveRangeSelectionExtent(
      extent) {
    this.proxy.sendMessage(
        26,
        FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
        null,
        [
          extent
        ],
        false);
  }

  
  /**
   */

  scrollFocusedEditableNodeIntoView() {
    this.proxy.sendMessage(
        27,
        FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  waitForPageScaleAnimationForTesting() {
    return this.proxy.sendMessage(
        28,
        FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
        FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Point } point
   */

  moveCaret(
      point) {
    this.proxy.sendMessage(
        29,
        FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
        null,
        [
          point
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FrameWidgetInputHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrameWidgetInputHandlerReceiver {
  /**
   * @param {!FrameWidgetInputHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FrameWidgetInputHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrameWidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameWidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
        null,
        impl.addImeTextSpansToExistingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
        null,
        impl.clearImeTextSpansByType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
        null,
        impl.setCompositionFromExistingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
        null,
        impl.extendSelectionAndDelete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
        null,
        impl.extendSelectionAndReplace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
        null,
        impl.deleteSurroundingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
        null,
        impl.deleteSurroundingTextInCodePoints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
        null,
        impl.setEditableSelectionOffsets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
        FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
        impl.handleStylusWritingGestureAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        impl.executeEditCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        FrameWidgetInputHandler_Undo_ParamsSpec.$,
        null,
        impl.undo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        FrameWidgetInputHandler_Redo_ParamsSpec.$,
        null,
        impl.redo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        FrameWidgetInputHandler_Cut_ParamsSpec.$,
        null,
        impl.cut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        FrameWidgetInputHandler_Copy_ParamsSpec.$,
        null,
        impl.copy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
        null,
        impl.copyToFindPboard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
        null,
        impl.centerSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        FrameWidgetInputHandler_Paste_ParamsSpec.$,
        null,
        impl.paste.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
        null,
        impl.pasteAndMatchStyle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        FrameWidgetInputHandler_Delete_ParamsSpec.$,
        null,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
        null,
        impl.selectAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
        null,
        impl.collapseSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        FrameWidgetInputHandler_Replace_ParamsSpec.$,
        null,
        impl.replace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
        null,
        impl.replaceMisspelling.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
        null,
        impl.selectRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
        null,
        impl.adjustSelectionByCharacterOffset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
        FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
        impl.selectAroundCaret.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
        null,
        impl.moveRangeSelectionExtent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
        null,
        impl.scrollFocusedEditableNodeIntoView.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
        FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
        impl.waitForPageScaleAnimationForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
        null,
        impl.moveCaret.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrameWidgetInputHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FrameWidgetInputHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FrameWidgetInputHandlerRemote}
   */
  static getRemote() {
    let remote = new FrameWidgetInputHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FrameWidgetInputHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrameWidgetInputHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrameWidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameWidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addImeTextSpansToExistingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
        null,
        this.addImeTextSpansToExistingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearImeTextSpansByType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
        null,
        this.clearImeTextSpansByType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCompositionFromExistingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
        null,
        this.setCompositionFromExistingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extendSelectionAndDelete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
        null,
        this.extendSelectionAndDelete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extendSelectionAndReplace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
        null,
        this.extendSelectionAndReplace.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSurroundingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
        null,
        this.deleteSurroundingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSurroundingTextInCodePoints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
        null,
        this.deleteSurroundingTextInCodePoints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEditableSelectionOffsets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
        null,
        this.setEditableSelectionOffsets.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleStylusWritingGestureAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
        FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
        this.handleStylusWritingGestureAction.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeEditCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        this.executeEditCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.undo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        FrameWidgetInputHandler_Undo_ParamsSpec.$,
        null,
        this.undo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.redo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        FrameWidgetInputHandler_Redo_ParamsSpec.$,
        null,
        this.redo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        FrameWidgetInputHandler_Cut_ParamsSpec.$,
        null,
        this.cut.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        FrameWidgetInputHandler_Copy_ParamsSpec.$,
        null,
        this.copy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copyToFindPboard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
        null,
        this.copyToFindPboard.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.centerSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
        null,
        this.centerSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.paste =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        FrameWidgetInputHandler_Paste_ParamsSpec.$,
        null,
        this.paste.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pasteAndMatchStyle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
        null,
        this.pasteAndMatchStyle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        FrameWidgetInputHandler_Delete_ParamsSpec.$,
        null,
        this.delete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
        null,
        this.selectAll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.collapseSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
        null,
        this.collapseSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        FrameWidgetInputHandler_Replace_ParamsSpec.$,
        null,
        this.replace.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replaceMisspelling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
        null,
        this.replaceMisspelling.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
        null,
        this.selectRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.adjustSelectionByCharacterOffset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
        null,
        this.adjustSelectionByCharacterOffset.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectAroundCaret =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
        FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
        this.selectAroundCaret.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.moveRangeSelectionExtent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
        null,
        this.moveRangeSelectionExtent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollFocusedEditableNodeIntoView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
        null,
        this.scrollFocusedEditableNodeIntoView.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.waitForPageScaleAnimationForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
        FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
        this.waitForPageScaleAnimationForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.moveCaret =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
        null,
        this.moveCaret.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WidgetInputHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WidgetInputHandler', scope);
  }
}

/** @interface */
export class WidgetInputHandlerInterface {
  
  /**
   * @param { !FocusState } state
   */

  setFocus(state) {}
  
  /**
   */

  mouseCaptureLost() {}
  
  /**
   * @param { !Array<!EditCommand> } commands
   */

  setEditCommandsForNextKeyEvent(commands) {}
  
  /**
   * @param { !boolean } visible
   */

  cursorVisibilityChanged(visible) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   * @param { !gfx_mojom_Range } range
   * @param { !number } start
   * @param { !number } end
   * @return {!Promise}
   */

  imeSetComposition(text, imeTextSpans, range, start, end) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   * @param { !gfx_mojom_Range } range
   * @param { !number } relativeCursorPosition
   * @return {!Promise}
   */

  imeCommitText(text, imeTextSpans, range, relativeCursorPosition) {}
  
  /**
   * @param { !boolean } keepSelection
   */

  imeFinishComposingText(keepSelection) {}
  
  /**
   */

  requestTextInputStateUpdate() {}
  
  /**
   * @param { !boolean } immediateRequest
   * @param { !boolean } monitorRequest
   */

  requestCompositionUpdates(immediateRequest, monitorRequest) {}
  
  /**
   * @param { !Event } event
   * @param { ?Event } originalEventForGesture
   * @return {!Promise<{
        source: !blink_mojom_InputEventResultSource,
        updatedLatency: !ui_mojom_LatencyInfo,
        state: !blink_mojom_InputEventResultState,
        overscroll: ?DidOverscrollParams,
        touchAction: ?TouchActionOptional,
   *  }>}
   */

  dispatchEvent(event, originalEventForGesture) {}
  
  /**
   * @param { !Event } event
   */

  dispatchNonBlockingEvent(event) {}
  
  /**
   * @return {!Promise}
   */

  waitForInputProcessed() {}
  
  /**
   * @param { !Object } interfaceRequest
   */

  getFrameWidgetInputHandler(interfaceRequest) {}
  
  /**
   * @param { !cc_mojom_BrowserControlsState } constraints
   * @param { !cc_mojom_BrowserControlsState } current
   * @param { !boolean } animate
   * @param { ?cc_mojom_BrowserControlsOffsetTagModifications } offsetTagModifications
   */

  updateBrowserControlsState(constraints, current, animate, offsetTagModifications) {}
}

/**
 * @implements { WidgetInputHandlerInterface }
 */
export class WidgetInputHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WidgetInputHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WidgetInputHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WidgetInputHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !FocusState } state
   */

  setFocus(
      state) {
    this.proxy.sendMessage(
        0,
        WidgetInputHandler_SetFocus_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   */

  mouseCaptureLost() {
    this.proxy.sendMessage(
        1,
        WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!EditCommand> } commands
   */

  setEditCommandsForNextKeyEvent(
      commands) {
    this.proxy.sendMessage(
        2,
        WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
        null,
        [
          commands
        ],
        false);
  }

  
  /**
   * @param { !boolean } visible
   */

  cursorVisibilityChanged(
      visible) {
    this.proxy.sendMessage(
        3,
        WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   * @param { !gfx_mojom_Range } range
   * @param { !number } start
   * @param { !number } end
   * @return {!Promise}
   */

  imeSetComposition(
      text,
      imeTextSpans,
      range,
      start,
      end) {
    return this.proxy.sendMessage(
        4,
        WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
        WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
        [
          text,
          imeTextSpans,
          range,
          start,
          end
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!ui_mojom_ImeTextSpan> } imeTextSpans
   * @param { !gfx_mojom_Range } range
   * @param { !number } relativeCursorPosition
   * @return {!Promise}
   */

  imeCommitText(
      text,
      imeTextSpans,
      range,
      relativeCursorPosition) {
    return this.proxy.sendMessage(
        5,
        WidgetInputHandler_ImeCommitText_ParamsSpec.$,
        WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
        [
          text,
          imeTextSpans,
          range,
          relativeCursorPosition
        ],
        false);
  }

  
  /**
   * @param { !boolean } keepSelection
   */

  imeFinishComposingText(
      keepSelection) {
    this.proxy.sendMessage(
        6,
        WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
        null,
        [
          keepSelection
        ],
        false);
  }

  
  /**
   */

  requestTextInputStateUpdate() {
    this.proxy.sendMessage(
        7,
        WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } immediateRequest
   * @param { !boolean } monitorRequest
   */

  requestCompositionUpdates(
      immediateRequest,
      monitorRequest) {
    this.proxy.sendMessage(
        8,
        WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
        null,
        [
          immediateRequest,
          monitorRequest
        ],
        false);
  }

  
  /**
   * @param { !Event } event
   * @param { ?Event } originalEventForGesture
   * @return {!Promise<{
        source: !blink_mojom_InputEventResultSource,
        updatedLatency: !ui_mojom_LatencyInfo,
        state: !blink_mojom_InputEventResultState,
        overscroll: ?DidOverscrollParams,
        touchAction: ?TouchActionOptional,
   *  }>}
   */

  dispatchEvent(
      event,
      originalEventForGesture) {
    return this.proxy.sendMessage(
        9,
        WidgetInputHandler_DispatchEvent_ParamsSpec.$,
        WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
        [
          event,
          originalEventForGesture
        ],
        false);
  }

  
  /**
   * @param { !Event } event
   */

  dispatchNonBlockingEvent(
      event) {
    this.proxy.sendMessage(
        10,
        WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  waitForInputProcessed() {
    return this.proxy.sendMessage(
        11,
        WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
        WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } interfaceRequest
   */

  getFrameWidgetInputHandler(
      interfaceRequest) {
    this.proxy.sendMessage(
        12,
        WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
        null,
        [
          interfaceRequest
        ],
        false);
  }

  
  /**
   * @param { !cc_mojom_BrowserControlsState } constraints
   * @param { !cc_mojom_BrowserControlsState } current
   * @param { !boolean } animate
   * @param { ?cc_mojom_BrowserControlsOffsetTagModifications } offsetTagModifications
   */

  updateBrowserControlsState(
      constraints,
      current,
      animate,
      offsetTagModifications) {
    this.proxy.sendMessage(
        13,
        WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        [
          constraints,
          current,
          animate,
          offsetTagModifications
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WidgetInputHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WidgetInputHandlerReceiver {
  /**
   * @param {!WidgetInputHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WidgetInputHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WidgetInputHandler_SetFocus_ParamsSpec.$,
        null,
        impl.setFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
        null,
        impl.mouseCaptureLost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
        null,
        impl.setEditCommandsForNextKeyEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
        null,
        impl.cursorVisibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
        WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
        impl.imeSetComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WidgetInputHandler_ImeCommitText_ParamsSpec.$,
        WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
        impl.imeCommitText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
        null,
        impl.imeFinishComposingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
        null,
        impl.requestTextInputStateUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
        null,
        impl.requestCompositionUpdates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WidgetInputHandler_DispatchEvent_ParamsSpec.$,
        WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
        impl.dispatchEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
        null,
        impl.dispatchNonBlockingEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
        WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
        impl.waitForInputProcessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
        null,
        impl.getFrameWidgetInputHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        impl.updateBrowserControlsState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WidgetInputHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetInputHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WidgetInputHandlerRemote}
   */
  static getRemote() {
    let remote = new WidgetInputHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WidgetInputHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WidgetInputHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WidgetInputHandler_SetFocus_ParamsSpec.$,
        null,
        this.setFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mouseCaptureLost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
        null,
        this.mouseCaptureLost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEditCommandsForNextKeyEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
        null,
        this.setEditCommandsForNextKeyEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cursorVisibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
        null,
        this.cursorVisibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeSetComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
        WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
        this.imeSetComposition.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeCommitText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WidgetInputHandler_ImeCommitText_ParamsSpec.$,
        WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
        this.imeCommitText.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeFinishComposingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
        null,
        this.imeFinishComposingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestTextInputStateUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
        null,
        this.requestTextInputStateUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCompositionUpdates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
        null,
        this.requestCompositionUpdates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WidgetInputHandler_DispatchEvent_ParamsSpec.$,
        WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
        this.dispatchEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNonBlockingEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
        null,
        this.dispatchNonBlockingEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.waitForInputProcessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
        WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
        this.waitForInputProcessed.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFrameWidgetInputHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
        null,
        this.getFrameWidgetInputHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateBrowserControlsState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        this.updateBrowserControlsState.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PointerDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WheelDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MouseDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScrollDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PinchBeginDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PinchUpdateDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PinchEndDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FlingDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TapDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TapDownDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GestureDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TouchPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TouchDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DidOverscrollParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TouchActionOptionalSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditCommandSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SelectAroundCaretResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_SetPanAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_DidOverscroll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_SetMouseCapture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_RequestMouseLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Undo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Redo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Cut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Copy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_CenterSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Paste_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_SelectAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_CollapseSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_Replace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_SelectRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameWidgetInputHandler_MoveCaret_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_SetFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_MouseCaptureLost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_CursorVisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_ImeSetComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_ImeSetComposition_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_ImeCommitText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_ImeCommitText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_ImeFinishComposingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_RequestCompositionUpdates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_DispatchEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_DispatchEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_WaitForInputProcessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    KeyDataSpec.$,
    'KeyData',
    [
      mojo.internal.StructField(
        'domKey', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domCode', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'windowsKeyCode', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nativeKeyCode', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSystemKey', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isBrowserShortcut', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unmodifiedText', 32,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class KeyData {
  constructor() {
    /** @type { !number } */
    this.domKey;
    /** @type { !number } */
    this.domCode;
    /** @type { !number } */
    this.windowsKeyCode;
    /** @type { !number } */
    this.nativeKeyCode;
    /** @type { !boolean } */
    this.isSystemKey;
    /** @type { !boolean } */
    this.isBrowserShortcut;
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
    /** @type { !mojoBase_mojom_String16 } */
    this.unmodifiedText;
  }
}



mojo.internal.Struct(
    PointerDataSpec.$,
    'PointerData',
    [
      mojo.internal.StructField(
        'pointerId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'force', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tiltX', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tiltY', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tangentialPressure', 24,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'twist', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'button', 32,
        0,
        blink_mojom_ButtonSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerType', 36,
        0,
        ui_mojom_EventPointerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'movementX', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'movementY', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isRawMovementEvent', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'widgetPosition', 56,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'screenPosition', 64,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseData', 72,
        0,
        MouseDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class PointerData {
  constructor() {
    /** @type { !number } */
    this.pointerId;
    /** @type { !number } */
    this.force;
    /** @type { !number } */
    this.tiltX;
    /** @type { !number } */
    this.tiltY;
    /** @type { !number } */
    this.tangentialPressure;
    /** @type { !number } */
    this.twist;
    /** @type { !blink_mojom_Button } */
    this.button;
    /** @type { !ui_mojom_EventPointerType } */
    this.pointerType;
    /** @type { !number } */
    this.movementX;
    /** @type { !number } */
    this.movementY;
    /** @type { !boolean } */
    this.isRawMovementEvent;
    /** @type { !gfx_mojom_PointF } */
    this.widgetPosition;
    /** @type { !gfx_mojom_PointF } */
    this.screenPosition;
    /** @type { (MouseData|undefined) } */
    this.mouseData;
    /** @type { !number } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    WheelDataSpec.$,
    'WheelData',
    [
      mojo.internal.StructField(
        'deltaX', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deltaY', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wheelTicksX', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wheelTicksY', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accelerationRatioX', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accelerationRatioY', 20,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'phase', 24,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'momentumPhase', 25,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cancelable', 28,
        0,
        blink_mojom_DispatchTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventAction', 26,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deltaUnits', 27,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WheelData {
  constructor() {
    /** @type { !number } */
    this.deltaX;
    /** @type { !number } */
    this.deltaY;
    /** @type { !number } */
    this.wheelTicksX;
    /** @type { !number } */
    this.wheelTicksY;
    /** @type { !number } */
    this.accelerationRatioX;
    /** @type { !number } */
    this.accelerationRatioY;
    /** @type { !number } */
    this.phase;
    /** @type { !number } */
    this.momentumPhase;
    /** @type { !blink_mojom_DispatchType } */
    this.cancelable;
    /** @type { !number } */
    this.eventAction;
    /** @type { !number } */
    this.deltaUnits;
  }
}



mojo.internal.Struct(
    MouseDataSpec.$,
    'MouseData',
    [
      mojo.internal.StructField(
        'clickCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wheelData', 8,
        0,
        WheelDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MouseData {
  constructor() {
    /** @type { !number } */
    this.clickCount;
    /** @type { (WheelData|undefined) } */
    this.wheelData;
  }
}



mojo.internal.Struct(
    ScrollDataSpec.$,
    'ScrollData',
    [
      mojo.internal.StructField(
        'deltaX', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deltaY', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deltaUnits', 8,
        0,
        ui_mojom_ScrollGranularitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetViewport', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inertialPhase', 16,
        0,
        blink_mojom_InertialPhaseStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'synthetic', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerCount', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cursorControl', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ScrollData {
  constructor() {
    /** @type { !number } */
    this.deltaX;
    /** @type { !number } */
    this.deltaY;
    /** @type { !ui_mojom_ScrollGranularity } */
    this.deltaUnits;
    /** @type { !boolean } */
    this.targetViewport;
    /** @type { !blink_mojom_InertialPhaseState } */
    this.inertialPhase;
    /** @type { !boolean } */
    this.synthetic;
    /** @type { !number } */
    this.pointerCount;
    /** @type { !boolean } */
    this.cursorControl;
  }
}



mojo.internal.Struct(
    PinchBeginDataSpec.$,
    'PinchBeginData',
    [
      mojo.internal.StructField(
        'needsWheelEvent', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PinchBeginData {
  constructor() {
    /** @type { !boolean } */
    this.needsWheelEvent;
  }
}



mojo.internal.Struct(
    PinchUpdateDataSpec.$,
    'PinchUpdateData',
    [
      mojo.internal.StructField(
        'scale', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'zoomDisabled', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsWheelEvent', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PinchUpdateData {
  constructor() {
    /** @type { !number } */
    this.scale;
    /** @type { !boolean } */
    this.zoomDisabled;
    /** @type { !boolean } */
    this.needsWheelEvent;
  }
}



mojo.internal.Struct(
    PinchEndDataSpec.$,
    'PinchEndData',
    [
      mojo.internal.StructField(
        'needsWheelEvent', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PinchEndData {
  constructor() {
    /** @type { !boolean } */
    this.needsWheelEvent;
  }
}



mojo.internal.Struct(
    FlingDataSpec.$,
    'FlingData',
    [
      mojo.internal.StructField(
        'velocityX', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'velocityY', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetViewport', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preventBoosting', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FlingData {
  constructor() {
    /** @type { !number } */
    this.velocityX;
    /** @type { !number } */
    this.velocityY;
    /** @type { !boolean } */
    this.targetViewport;
    /** @type { !boolean } */
    this.preventBoosting;
  }
}



mojo.internal.Struct(
    TapDataSpec.$,
    'TapData',
    [
      mojo.internal.StructField(
        'tapCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsWheelEvent', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TapData {
  constructor() {
    /** @type { !number } */
    this.tapCount;
    /** @type { !boolean } */
    this.needsWheelEvent;
  }
}



mojo.internal.Struct(
    TapDownDataSpec.$,
    'TapDownData',
    [
      mojo.internal.StructField(
        'tapDownCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TapDownData {
  constructor() {
    /** @type { !number } */
    this.tapDownCount;
  }
}



mojo.internal.Struct(
    GestureDataSpec.$,
    'GestureData',
    [
      mojo.internal.StructField(
        'screenPosition', 0,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'widgetPosition', 8,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceDevice', 16,
        0,
        blink_mojom_GestureDeviceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSourceTouchEventSetBlocking', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryPointerType', 24,
        0,
        ui_mojom_EventPointerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryUniqueTouchEventId', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uniqueTouchEventId', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contactSize', 40,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollData', 48,
        0,
        ScrollDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pinchBeginData', 56,
        0,
        PinchBeginDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pinchUpdateData', 64,
        0,
        PinchUpdateDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pinchEndData', 72,
        0,
        PinchEndDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tapData', 80,
        0,
        TapDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tapDownData', 88,
        0,
        TapDownDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flingData', 96,
        0,
        FlingDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 112],]);



/**
 * @record
 */
export class GestureData {
  constructor() {
    /** @type { !gfx_mojom_PointF } */
    this.screenPosition;
    /** @type { !gfx_mojom_PointF } */
    this.widgetPosition;
    /** @type { !blink_mojom_GestureDevice } */
    this.sourceDevice;
    /** @type { !boolean } */
    this.isSourceTouchEventSetBlocking;
    /** @type { !ui_mojom_EventPointerType } */
    this.primaryPointerType;
    /** @type { !number } */
    this.primaryUniqueTouchEventId;
    /** @type { !number } */
    this.uniqueTouchEventId;
    /** @type { (gfx_mojom_Size|undefined) } */
    this.contactSize;
    /** @type { (ScrollData|undefined) } */
    this.scrollData;
    /** @type { (PinchBeginData|undefined) } */
    this.pinchBeginData;
    /** @type { (PinchUpdateData|undefined) } */
    this.pinchUpdateData;
    /** @type { (PinchEndData|undefined) } */
    this.pinchEndData;
    /** @type { (TapData|undefined) } */
    this.tapData;
    /** @type { (TapDownData|undefined) } */
    this.tapDownData;
    /** @type { (FlingData|undefined) } */
    this.flingData;
  }
}



mojo.internal.Struct(
    TouchPointSpec.$,
    'TouchPoint',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink_mojom_TouchStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'radiusX', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'radiusY', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rotationAngle', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerData', 16,
        0,
        PointerDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TouchPoint {
  constructor() {
    /** @type { !blink_mojom_TouchState } */
    this.state;
    /** @type { !number } */
    this.radiusX;
    /** @type { !number } */
    this.radiusY;
    /** @type { !number } */
    this.rotationAngle;
    /** @type { !PointerData } */
    this.pointerData;
  }
}



mojo.internal.Struct(
    TouchDataSpec.$,
    'TouchData',
    [
      mojo.internal.StructField(
        'cancelable', 0,
        0,
        blink_mojom_DispatchTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'movedBeyondSlopRegion', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'touchStartOrFirstMove', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hovering', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uniqueTouchEventId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'touches', 16,
        0,
        mojo.internal.Array(TouchPointSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TouchData {
  constructor() {
    /** @type { !blink_mojom_DispatchType } */
    this.cancelable;
    /** @type { !boolean } */
    this.movedBeyondSlopRegion;
    /** @type { !boolean } */
    this.touchStartOrFirstMove;
    /** @type { !boolean } */
    this.hovering;
    /** @type { !number } */
    this.uniqueTouchEventId;
    /** @type { !Array<!TouchPoint> } */
    this.touches;
  }
}



mojo.internal.Struct(
    EventSpec.$,
    'Event',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink_mojom_EventTypeSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiers', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'latency', 16,
        0,
        ui_mojom_LatencyInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventLatencyMetadata', 24,
        0,
        ui_mojom_EventLatencyMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyData', 32,
        0,
        KeyDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointerData', 40,
        0,
        PointerDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gestureData', 48,
        0,
        GestureDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'touchData', 56,
        0,
        TouchDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class Event {
  constructor() {
    /** @type { !blink_mojom_EventType } */
    this.type;
    /** @type { !number } */
    this.modifiers;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timestamp;
    /** @type { !ui_mojom_LatencyInfo } */
    this.latency;
    /** @type { !ui_mojom_EventLatencyMetadata } */
    this.eventLatencyMetadata;
    /** @type { (KeyData|undefined) } */
    this.keyData;
    /** @type { (PointerData|undefined) } */
    this.pointerData;
    /** @type { (GestureData|undefined) } */
    this.gestureData;
    /** @type { (TouchData|undefined) } */
    this.touchData;
  }
}



mojo.internal.Struct(
    DidOverscrollParamsSpec.$,
    'DidOverscrollParams',
    [
      mojo.internal.StructField(
        'accumulatedOverscroll', 0,
        0,
        gfx_mojom_Vector2dFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'latestOverscrollDelta', 8,
        0,
        gfx_mojom_Vector2dFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentFlingVelocity', 16,
        0,
        gfx_mojom_Vector2dFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'causalEventViewportPoint', 24,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'overscrollBehavior', 32,
        0,
        cc_mojom_OverscrollBehaviorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceDevice', 40,
        0,
        blink_mojom_GestureDeviceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DidOverscrollParams {
  constructor() {
    /** @type { !gfx_mojom_Vector2dF } */
    this.accumulatedOverscroll;
    /** @type { !gfx_mojom_Vector2dF } */
    this.latestOverscrollDelta;
    /** @type { !gfx_mojom_Vector2dF } */
    this.currentFlingVelocity;
    /** @type { !gfx_mojom_PointF } */
    this.causalEventViewportPoint;
    /** @type { !cc_mojom_OverscrollBehavior } */
    this.overscrollBehavior;
    /** @type { !blink_mojom_GestureDevice } */
    this.sourceDevice;
  }
}



mojo.internal.Struct(
    TouchActionOptionalSpec.$,
    'TouchActionOptional',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc_mojom_TouchActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TouchActionOptional {
  constructor() {
    /** @type { !cc_mojom_TouchAction } */
    this.touchAction;
  }
}



mojo.internal.Struct(
    EditCommandSpec.$,
    'EditCommand',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditCommand {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    SelectAroundCaretResultSpec.$,
    'SelectAroundCaretResult',
    [
      mojo.internal.StructField(
        'extendedStartAdjust', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extendedEndAdjust', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wordStartAdjust', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wordEndAdjust', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SelectAroundCaretResult {
  constructor() {
    /** @type { !number } */
    this.extendedStartAdjust;
    /** @type { !number } */
    this.extendedEndAdjust;
    /** @type { !number } */
    this.wordStartAdjust;
    /** @type { !number } */
    this.wordEndAdjust;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
    'WidgetInputHandlerHost_SetTouchActionFromMain_Params',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc_mojom_TouchActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_SetTouchActionFromMain_Params {
  constructor() {
    /** @type { !cc_mojom_TouchAction } */
    this.touchAction;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
    'WidgetInputHandlerHost_SetPanAction_Params',
    [
      mojo.internal.StructField(
        'panAction', 0,
        0,
        PanActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_SetPanAction_Params {
  constructor() {
    /** @type { !PanAction } */
    this.panAction;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
    'WidgetInputHandlerHost_DidOverscroll_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        DidOverscrollParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_DidOverscroll_Params {
  constructor() {
    /** @type { !DidOverscrollParams } */
    this.params;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
    'WidgetInputHandlerHost_DidStartScrollingViewport_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_DidStartScrollingViewport_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
    'WidgetInputHandlerHost_ImeCancelComposition_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_ImeCancelComposition_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
    'WidgetInputHandlerHost_ImeCompositionRangeChanged_Params',
    [
      mojo.internal.StructField(
        'range', 0,
        0,
        gfx_mojom_RangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'characterBounds', 8,
        0,
        mojo.internal.Array(gfx_mojom_RectSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_ImeCompositionRangeChanged_Params {
  constructor() {
    /** @type { !gfx_mojom_Range } */
    this.range;
    /** @type { (Array<!gfx_mojom_Rect>|undefined) } */
    this.characterBounds;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
    'WidgetInputHandlerHost_SetMouseCapture_Params',
    [
      mojo.internal.StructField(
        'capture', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_SetMouseCapture_Params {
  constructor() {
    /** @type { !boolean } */
    this.capture;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
    'WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params',
    [
      mojo.internal.StructField(
        'autoscrollSelection', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params {
  constructor() {
    /** @type { !boolean } */
    this.autoscrollSelection;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
    'WidgetInputHandlerHost_RequestMouseLock_Params',
    [
      mojo.internal.StructField(
        'fromUserGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unadjustedMovement', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_RequestMouseLock_Params {
  constructor() {
    /** @type { !boolean } */
    this.fromUserGesture;
    /** @type { !boolean } */
    this.unadjustedMovement;
  }
}



mojo.internal.Struct(
    WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
    'WidgetInputHandlerHost_RequestMouseLock_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_PointerLockResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 4,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_PointerLockContextRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WidgetInputHandlerHost_RequestMouseLock_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PointerLockResult } */
    this.result;
    /** @type { (blink_mojom_PointerLockContextRemote|undefined) } */
    this.context;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
    'FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui_mojom_ImeTextSpanSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
    /** @type { !Array<!ui_mojom_ImeTextSpan> } */
    this.imeTextSpans;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
    'FrameWidgetInputHandler_ClearImeTextSpansByType_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        ui_mojom_ImeTextSpanTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_ClearImeTextSpansByType_Params {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
    /** @type { !ui_mojom_ImeTextSpanType } */
    this.type;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
    'FrameWidgetInputHandler_SetCompositionFromExistingText_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui_mojom_ImeTextSpanSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_SetCompositionFromExistingText_Params {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
    /** @type { !Array<!ui_mojom_ImeTextSpan> } */
    this.imeTextSpans;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
    'FrameWidgetInputHandler_ExtendSelectionAndDelete_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_ExtendSelectionAndDelete_Params {
  constructor() {
    /** @type { !number } */
    this.before;
    /** @type { !number } */
    this.after;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
    'FrameWidgetInputHandler_ExtendSelectionAndReplace_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replacementText', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_ExtendSelectionAndReplace_Params {
  constructor() {
    /** @type { !number } */
    this.before;
    /** @type { !number } */
    this.after;
    /** @type { !mojoBase_mojom_String16 } */
    this.replacementText;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
    'FrameWidgetInputHandler_DeleteSurroundingText_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_DeleteSurroundingText_Params {
  constructor() {
    /** @type { !number } */
    this.before;
    /** @type { !number } */
    this.after;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
    'FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params {
  constructor() {
    /** @type { !number } */
    this.before;
    /** @type { !number } */
    this.after;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
    'FrameWidgetInputHandler_SetEditableSelectionOffsets_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_SetEditableSelectionOffsets_Params {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
    'FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params',
    [
      mojo.internal.StructField(
        'gestureData', 0,
        0,
        blink_mojom_StylusWritingGestureDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params {
  constructor() {
    /** @type { !blink_mojom_StylusWritingGestureData } */
    this.gestureData;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_HandwritingGestureResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_HandwritingGestureResult } */
    this.result;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
    'FrameWidgetInputHandler_ExecuteEditCommand_Params',
    [
      mojo.internal.StructField(
        'command', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_ExecuteEditCommand_Params {
  constructor() {
    /** @type { !string } */
    this.command;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.value;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Undo_ParamsSpec.$,
    'FrameWidgetInputHandler_Undo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Undo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Redo_ParamsSpec.$,
    'FrameWidgetInputHandler_Redo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Redo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Cut_ParamsSpec.$,
    'FrameWidgetInputHandler_Cut_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Cut_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Copy_ParamsSpec.$,
    'FrameWidgetInputHandler_Copy_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Copy_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
    'FrameWidgetInputHandler_CopyToFindPboard_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_CopyToFindPboard_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
    'FrameWidgetInputHandler_CenterSelection_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_CenterSelection_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Paste_ParamsSpec.$,
    'FrameWidgetInputHandler_Paste_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Paste_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
    'FrameWidgetInputHandler_PasteAndMatchStyle_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_PasteAndMatchStyle_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Delete_ParamsSpec.$,
    'FrameWidgetInputHandler_Delete_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Delete_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
    'FrameWidgetInputHandler_SelectAll_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_SelectAll_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
    'FrameWidgetInputHandler_CollapseSelection_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_CollapseSelection_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_Replace_ParamsSpec.$,
    'FrameWidgetInputHandler_Replace_Params',
    [
      mojo.internal.StructField(
        'word', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_Replace_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.word;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
    'FrameWidgetInputHandler_ReplaceMisspelling_Params',
    [
      mojo.internal.StructField(
        'word', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_ReplaceMisspelling_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.word;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
    'FrameWidgetInputHandler_SelectRange_Params',
    [
      mojo.internal.StructField(
        'base', 0,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extent', 8,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_SelectRange_Params {
  constructor() {
    /** @type { !gfx_mojom_Point } */
    this.base;
    /** @type { !gfx_mojom_Point } */
    this.extent;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
    'FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'behavior', 8,
        0,
        blink_mojom_SelectionMenuBehaviorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
    /** @type { !blink_mojom_SelectionMenuBehavior } */
    this.behavior;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
    'FrameWidgetInputHandler_SelectAroundCaret_Params',
    [
      mojo.internal.StructField(
        'granularity', 0,
        0,
        SelectionGranularitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldShowHandle', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldShowContextMenu', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_SelectAroundCaret_Params {
  constructor() {
    /** @type { !SelectionGranularity } */
    this.granularity;
    /** @type { !boolean } */
    this.shouldShowHandle;
    /** @type { !boolean } */
    this.shouldShowContextMenu;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_SelectAroundCaret_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SelectAroundCaretResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_SelectAroundCaret_ResponseParams {
  constructor() {
    /** @type { (SelectAroundCaretResult|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
    'FrameWidgetInputHandler_MoveRangeSelectionExtent_Params',
    [
      mojo.internal.StructField(
        'extent', 0,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_MoveRangeSelectionExtent_Params {
  constructor() {
    /** @type { !gfx_mojom_Point } */
    this.extent;
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
    'FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
    'FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
    'FrameWidgetInputHandler_MoveCaret_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameWidgetInputHandler_MoveCaret_Params {
  constructor() {
    /** @type { !gfx_mojom_Point } */
    this.point;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_SetFocus_ParamsSpec.$,
    'WidgetInputHandler_SetFocus_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        FocusStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_SetFocus_Params {
  constructor() {
    /** @type { !FocusState } */
    this.state;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
    'WidgetInputHandler_MouseCaptureLost_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandler_MouseCaptureLost_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
    'WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params',
    [
      mojo.internal.StructField(
        'commands', 0,
        0,
        mojo.internal.Array(EditCommandSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params {
  constructor() {
    /** @type { !Array<!EditCommand> } */
    this.commands;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
    'WidgetInputHandler_CursorVisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_CursorVisibilityChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.visible;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
    'WidgetInputHandler_ImeSetComposition_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui_mojom_ImeTextSpanSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'range', 16,
        0,
        gfx_mojom_RangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'start', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WidgetInputHandler_ImeSetComposition_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
    /** @type { !Array<!ui_mojom_ImeTextSpan> } */
    this.imeTextSpans;
    /** @type { !gfx_mojom_Range } */
    this.range;
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
    'WidgetInputHandler_ImeSetComposition_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandler_ImeSetComposition_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandler_ImeCommitText_ParamsSpec.$,
    'WidgetInputHandler_ImeCommitText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui_mojom_ImeTextSpanSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'range', 16,
        0,
        gfx_mojom_RangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'relativeCursorPosition', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WidgetInputHandler_ImeCommitText_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
    /** @type { !Array<!ui_mojom_ImeTextSpan> } */
    this.imeTextSpans;
    /** @type { !gfx_mojom_Range } */
    this.range;
    /** @type { !number } */
    this.relativeCursorPosition;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
    'WidgetInputHandler_ImeCommitText_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandler_ImeCommitText_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
    'WidgetInputHandler_ImeFinishComposingText_Params',
    [
      mojo.internal.StructField(
        'keepSelection', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_ImeFinishComposingText_Params {
  constructor() {
    /** @type { !boolean } */
    this.keepSelection;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
    'WidgetInputHandler_RequestTextInputStateUpdate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandler_RequestTextInputStateUpdate_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
    'WidgetInputHandler_RequestCompositionUpdates_Params',
    [
      mojo.internal.StructField(
        'immediateRequest', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'monitorRequest', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_RequestCompositionUpdates_Params {
  constructor() {
    /** @type { !boolean } */
    this.immediateRequest;
    /** @type { !boolean } */
    this.monitorRequest;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_DispatchEvent_ParamsSpec.$,
    'WidgetInputHandler_DispatchEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        EventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalEventForGesture', 8,
        0,
        EventSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WidgetInputHandler_DispatchEvent_Params {
  constructor() {
    /** @type { !Event } */
    this.event;
    /** @type { (Event|undefined) } */
    this.originalEventForGesture;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
    'WidgetInputHandler_DispatchEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        blink_mojom_InputEventResultSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updatedLatency', 8,
        0,
        ui_mojom_LatencyInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 4,
        0,
        blink_mojom_InputEventResultStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'overscroll', 16,
        0,
        DidOverscrollParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'touchAction', 24,
        0,
        TouchActionOptionalSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WidgetInputHandler_DispatchEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_InputEventResultSource } */
    this.source;
    /** @type { !ui_mojom_LatencyInfo } */
    this.updatedLatency;
    /** @type { !blink_mojom_InputEventResultState } */
    this.state;
    /** @type { (DidOverscrollParams|undefined) } */
    this.overscroll;
    /** @type { (TouchActionOptional|undefined) } */
    this.touchAction;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
    'WidgetInputHandler_DispatchNonBlockingEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        EventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_DispatchNonBlockingEvent_Params {
  constructor() {
    /** @type { !Event } */
    this.event;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
    'WidgetInputHandler_WaitForInputProcessed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandler_WaitForInputProcessed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
    'WidgetInputHandler_WaitForInputProcessed_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetInputHandler_WaitForInputProcessed_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
    'WidgetInputHandler_GetFrameWidgetInputHandler_Params',
    [
      mojo.internal.StructField(
        'interfaceRequest', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(FrameWidgetInputHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetInputHandler_GetFrameWidgetInputHandler_Params {
  constructor() {
    /** @type { !Object } */
    this.interfaceRequest;
  }
}



mojo.internal.Struct(
    WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
    'WidgetInputHandler_UpdateBrowserControlsState_Params',
    [
      mojo.internal.StructField(
        'constraints', 0,
        0,
        cc_mojom_BrowserControlsStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'current', 4,
        0,
        cc_mojom_BrowserControlsStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'animate', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offsetTagModifications', 16,
        0,
        cc_mojom_BrowserControlsOffsetTagModificationsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WidgetInputHandler_UpdateBrowserControlsState_Params {
  constructor() {
    /** @type { !cc_mojom_BrowserControlsState } */
    this.constraints;
    /** @type { !cc_mojom_BrowserControlsState } */
    this.current;
    /** @type { !boolean } */
    this.animate;
    /** @type { (cc_mojom_BrowserControlsOffsetTagModifications|undefined) } */
    this.offsetTagModifications;
  }
}

