// third_party/blink/public/mojom/input/input_host.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('blink.mojom.TextSuggestionHost');
goog.provide('blink.mojom.TextSuggestionHostReceiver');
goog.provide('blink.mojom.TextSuggestionHostCallbackRouter');
goog.provide('blink.mojom.TextSuggestionHostInterface');
goog.provide('blink.mojom.TextSuggestionHostRemote');
goog.provide('blink.mojom.TextSuggestionHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TextSuggestionHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.TextSuggestionHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.TextSuggestionHostInterface = class {
  
  /**
   */

  startSuggestionMenuTimer() {}
  
  /**
   * @param { !number } caretX
   * @param { !number } caretY
   * @param { !string } markedText
   * @param { !Array<!blink.mojom.SpellCheckSuggestion> } suggestions
   */

  showSpellCheckSuggestionMenu(caretX, caretY, markedText, suggestions) {}
  
  /**
   * @param { !number } caretX
   * @param { !number } caretY
   * @param { !string } markedText
   * @param { !Array<!blink.mojom.TextSuggestion> } suggestions
   */

  showTextSuggestionMenu(caretX, caretY, markedText, suggestions) {}
};

/**
 * @export
 * @implements { blink.mojom.TextSuggestionHostInterface }
 */
blink.mojom.TextSuggestionHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TextSuggestionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TextSuggestionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TextSuggestionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  startSuggestionMenuTimer() {
    this.proxy.sendMessage(
        0,
        blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } caretX
   * @param { !number } caretY
   * @param { !string } markedText
   * @param { !Array<!blink.mojom.SpellCheckSuggestion> } suggestions
   */

  showSpellCheckSuggestionMenu(
      caretX,
      caretY,
      markedText,
      suggestions) {
    this.proxy.sendMessage(
        1,
        blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsSpec.$,
        null,
        [
          caretX,
          caretY,
          markedText,
          suggestions
        ],
        false);
  }

  
  /**
   * @param { !number } caretX
   * @param { !number } caretY
   * @param { !string } markedText
   * @param { !Array<!blink.mojom.TextSuggestion> } suggestions
   */

  showTextSuggestionMenu(
      caretX,
      caretY,
      markedText,
      suggestions) {
    this.proxy.sendMessage(
        2,
        blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_ParamsSpec.$,
        null,
        [
          caretX,
          caretY,
          markedText,
          suggestions
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSuggestionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TextSuggestionHostReceiver = class {
  /**
   * @param {!blink.mojom.TextSuggestionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TextSuggestionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TextSuggestionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextSuggestionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_ParamsSpec.$,
        null,
        impl.startSuggestionMenuTimer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsSpec.$,
        null,
        impl.showSpellCheckSuggestionMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_ParamsSpec.$,
        null,
        impl.showTextSuggestionMenu.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.TextSuggestionHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextSuggestionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TextSuggestionHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TextSuggestionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextSuggestionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TextSuggestionHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TextSuggestionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextSuggestionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startSuggestionMenuTimer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_ParamsSpec.$,
        null,
        this.startSuggestionMenuTimer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showSpellCheckSuggestionMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsSpec.$,
        null,
        this.showSpellCheckSuggestionMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showTextSuggestionMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_ParamsSpec.$,
        null,
        this.showTextSuggestionMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SpellCheckSuggestionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpellCheckSuggestionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextSuggestionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SpellCheckSuggestionSpec.$,
    'SpellCheckSuggestion',
    [
      mojo.internal.StructField(
        'suggestion', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SpellCheckSuggestion');

/** @record */
blink.mojom.SpellCheckSuggestion = class {
  constructor() {
    /** @export { !string } */
    this.suggestion;
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionSpec.$,
    'TextSuggestion',
    [
      mojo.internal.StructField(
        'markerTag', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestionIndex', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prefix', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestion', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suffix', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.TextSuggestion');

/** @record */
blink.mojom.TextSuggestion = class {
  constructor() {
    /** @export { !number } */
    this.markerTag;
    /** @export { !number } */
    this.suggestionIndex;
    /** @export { !string } */
    this.prefix;
    /** @export { !string } */
    this.suggestion;
    /** @export { !string } */
    this.suffix;
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_ParamsSpec.$,
    'TextSuggestionHost_StartSuggestionMenuTimer_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_Params');

/** @record */
blink.mojom.TextSuggestionHost_StartSuggestionMenuTimer_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsSpec.$,
    'TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params',
    [
      mojo.internal.StructField(
        'caretX', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'caretY', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'markedText', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestions', 24,
        0,
        mojo.internal.Array(blink.mojom.SpellCheckSuggestionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params');

/** @record */
blink.mojom.TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params = class {
  constructor() {
    /** @export { !number } */
    this.caretX;
    /** @export { !number } */
    this.caretY;
    /** @export { !string } */
    this.markedText;
    /** @export { !Array<!blink.mojom.SpellCheckSuggestion> } */
    this.suggestions;
  }
};



mojo.internal.Struct(
    blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_ParamsSpec.$,
    'TextSuggestionHost_ShowTextSuggestionMenu_Params',
    [
      mojo.internal.StructField(
        'caretX', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'caretY', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'markedText', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestions', 24,
        0,
        mojo.internal.Array(blink.mojom.TextSuggestionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_Params');

/** @record */
blink.mojom.TextSuggestionHost_ShowTextSuggestionMenu_Params = class {
  constructor() {
    /** @export { !number } */
    this.caretX;
    /** @export { !number } */
    this.caretY;
    /** @export { !string } */
    this.markedText;
    /** @export { !Array<!blink.mojom.TextSuggestion> } */
    this.suggestions;
  }
};

