// third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.InstalledAppProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.InstalledAppProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.InstalledAppProviderInterface }
 */
blink.mojom.InstalledAppProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.InstalledAppProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.InstalledAppProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.InstalledAppProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.RelatedApplication> } relatedApps
   * @param { !url.mojom.Url } manifestUrl
   * @param { !boolean } addSavedRelatedApplications
   * @return {!Promise<{
        installedApps: !Array<!blink.mojom.RelatedApplication>,
   *  }>}
   */

  filterInstalledApps(
      relatedApps,
      manifestUrl,
      addSavedRelatedApplications) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
        blink.mojom.InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
        [
          relatedApps,
          manifestUrl,
          addSavedRelatedApplications
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InstalledAppProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.InstalledAppProviderReceiver = class {
  /**
   * @param {!blink.mojom.InstalledAppProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.InstalledAppProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.InstalledAppProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.InstalledAppProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
        blink.mojom.InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
        impl.filterInstalledApps.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.InstalledAppProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.InstalledAppProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.InstalledAppProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.InstalledAppProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InstalledAppProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.InstalledAppProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.InstalledAppProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.InstalledAppProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.filterInstalledApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
        blink.mojom.InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
        this.filterInstalledApps.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InstalledAppProvider_FilterInstalledApps_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
    'InstalledAppProvider_FilterInstalledApps_Params',
    [
      mojo.internal.StructField(
        'relatedApps', 0,
        0,
        mojo.internal.Array(blink.mojom.RelatedApplicationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manifestUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addSavedRelatedApplications', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.InstalledAppProvider_FilterInstalledApps_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.RelatedApplication> } */
    this.relatedApps;
    /** @export { !url.mojom.Url } */
    this.manifestUrl;
    /** @export { !boolean } */
    this.addSavedRelatedApplications;
  }
};



mojo.internal.Struct(
    blink.mojom.InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
    'InstalledAppProvider_FilterInstalledApps_ResponseParams',
    [
      mojo.internal.StructField(
        'installedApps', 0,
        0,
        mojo.internal.Array(blink.mojom.RelatedApplicationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.InstalledAppProvider_FilterInstalledApps_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.RelatedApplication> } */
    this.installedApps;
  }
};

