// third_party/blink/public/mojom/installedapp/installed_app_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  RelatedApplication as blink_mojom_RelatedApplication,
  RelatedApplicationSpec as blink_mojom_RelatedApplicationSpec
} from './related_application.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InstalledAppProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.InstalledAppProvider', scope);
  }
}

/** @interface */
export class InstalledAppProviderInterface {
  
  /**
   * @param { !Array<!blink_mojom_RelatedApplication> } relatedApps
   * @param { !url_mojom_Url } manifestUrl
   * @param { !boolean } addSavedRelatedApplications
   * @return {!Promise<{
        installedApps: !Array<!blink_mojom_RelatedApplication>,
   *  }>}
   */

  filterInstalledApps(relatedApps, manifestUrl, addSavedRelatedApplications) {}
}

/**
 * @implements { InstalledAppProviderInterface }
 */
export class InstalledAppProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InstalledAppProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InstalledAppProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InstalledAppProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink_mojom_RelatedApplication> } relatedApps
   * @param { !url_mojom_Url } manifestUrl
   * @param { !boolean } addSavedRelatedApplications
   * @return {!Promise<{
        installedApps: !Array<!blink_mojom_RelatedApplication>,
   *  }>}
   */

  filterInstalledApps(
      relatedApps,
      manifestUrl,
      addSavedRelatedApplications) {
    return this.proxy.sendMessage(
        0,
        InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
        InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
        [
          relatedApps,
          manifestUrl,
          addSavedRelatedApplications
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InstalledAppProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InstalledAppProviderReceiver {
  /**
   * @param {!InstalledAppProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InstalledAppProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InstalledAppProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InstalledAppProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
        InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
        impl.filterInstalledApps.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InstalledAppProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.InstalledAppProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InstalledAppProviderRemote}
   */
  static getRemote() {
    let remote = new InstalledAppProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InstalledAppProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InstalledAppProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InstalledAppProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InstalledAppProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.filterInstalledApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
        InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
        this.filterInstalledApps.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InstalledAppProvider_FilterInstalledApps_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InstalledAppProvider_FilterInstalledApps_ParamsSpec.$,
    'InstalledAppProvider_FilterInstalledApps_Params',
    [
      mojo.internal.StructField(
        'relatedApps', 0,
        0,
        mojo.internal.Array(blink_mojom_RelatedApplicationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manifestUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addSavedRelatedApplications', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InstalledAppProvider_FilterInstalledApps_Params {
  constructor() {
    /** @type { !Array<!blink_mojom_RelatedApplication> } */
    this.relatedApps;
    /** @type { !url_mojom_Url } */
    this.manifestUrl;
    /** @type { !boolean } */
    this.addSavedRelatedApplications;
  }
}



mojo.internal.Struct(
    InstalledAppProvider_FilterInstalledApps_ResponseParamsSpec.$,
    'InstalledAppProvider_FilterInstalledApps_ResponseParams',
    [
      mojo.internal.StructField(
        'installedApps', 0,
        0,
        mojo.internal.Array(blink_mojom_RelatedApplicationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InstalledAppProvider_FilterInstalledApps_ResponseParams {
  constructor() {
    /** @type { !Array<!blink_mojom_RelatedApplication> } */
    this.installedApps;
  }
}

