// third_party/blink/public/mojom/loader/fetch_later.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/fetch_later.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var mutable_network_traffic_annotation_tag$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom', '../../../../../services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.js');
  }
  var url_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_request.mojom', '../../../../../services/network/public/mojom/url_request.mojom.js');
  }



  function FetchLaterLoaderFactory_CreateLoader_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchLaterLoaderFactory_CreateLoader_Params.prototype.initDefaults_ = function() {
    this.loader = new associatedBindings.AssociatedInterfaceRequest();
    this.requestId = 0;
    this.options = 0;
    this.request = null;
    this.trafficAnnotation = null;
  };
  FetchLaterLoaderFactory_CreateLoader_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchLaterLoaderFactory_CreateLoader_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchLaterLoaderFactory_CreateLoader_Params.loader
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate FetchLaterLoaderFactory_CreateLoader_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url_request$.URLRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchLaterLoaderFactory_CreateLoader_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchLaterLoaderFactory_CreateLoader_Params.encodedSize = codec.kStructHeaderSize + 32;

  FetchLaterLoaderFactory_CreateLoader_Params.decode = function(decoder) {
    var packed;
    var val = new FetchLaterLoaderFactory_CreateLoader_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.loader =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.options =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.request =
        decoder.decodeStructPointer(url_request$.URLRequest);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    return val;
  };

  FetchLaterLoaderFactory_CreateLoader_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchLaterLoaderFactory_CreateLoader_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.loader);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Uint32, val.options);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url_request$.URLRequest, val.request);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
  };
  function FetchLaterLoaderFactory_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchLaterLoaderFactory_Clone_Params.prototype.initDefaults_ = function() {
    this.factory = new associatedBindings.AssociatedInterfaceRequest();
  };
  FetchLaterLoaderFactory_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchLaterLoaderFactory_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchLaterLoaderFactory_Clone_Params.factory
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchLaterLoaderFactory_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  FetchLaterLoaderFactory_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new FetchLaterLoaderFactory_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.factory =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FetchLaterLoaderFactory_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchLaterLoaderFactory_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.factory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FetchLaterLoader_SendNow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchLaterLoader_SendNow_Params.prototype.initDefaults_ = function() {
  };
  FetchLaterLoader_SendNow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchLaterLoader_SendNow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchLaterLoader_SendNow_Params.encodedSize = codec.kStructHeaderSize + 0;

  FetchLaterLoader_SendNow_Params.decode = function(decoder) {
    var packed;
    var val = new FetchLaterLoader_SendNow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FetchLaterLoader_SendNow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchLaterLoader_SendNow_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FetchLaterLoader_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchLaterLoader_Cancel_Params.prototype.initDefaults_ = function() {
  };
  FetchLaterLoader_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchLaterLoader_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchLaterLoader_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  FetchLaterLoader_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new FetchLaterLoader_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FetchLaterLoader_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchLaterLoader_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kFetchLaterLoaderFactory_CreateLoader_Name = 0;
  var kFetchLaterLoaderFactory_Clone_Name = 1;

  function FetchLaterLoaderFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FetchLaterLoaderFactory,
                                                   handleOrPtrInfo);
  }

  function FetchLaterLoaderFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FetchLaterLoaderFactory, associatedInterfacePtrInfo);
  }

  FetchLaterLoaderFactoryAssociatedPtr.prototype =
      Object.create(FetchLaterLoaderFactoryPtr.prototype);
  FetchLaterLoaderFactoryAssociatedPtr.prototype.constructor =
      FetchLaterLoaderFactoryAssociatedPtr;

  function FetchLaterLoaderFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  FetchLaterLoaderFactoryPtr.prototype.createLoader = function() {
    return FetchLaterLoaderFactoryProxy.prototype.createLoader
        .apply(this.ptr.getProxy(), arguments);
  };

  FetchLaterLoaderFactoryProxy.prototype.createLoader = function(loader, requestId, options, request, trafficAnnotation) {
    var params_ = new FetchLaterLoaderFactory_CreateLoader_Params();
    params_.loader = loader;
    params_.requestId = requestId;
    params_.options = options;
    params_.request = request;
    params_.trafficAnnotation = trafficAnnotation;
    var builder = new codec.MessageV2Builder(
        kFetchLaterLoaderFactory_CreateLoader_Name,
        codec.align(FetchLaterLoaderFactory_CreateLoader_Params.encodedSize));
    builder.setPayload(FetchLaterLoaderFactory_CreateLoader_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FetchLaterLoaderFactoryPtr.prototype.clone = function() {
    return FetchLaterLoaderFactoryProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  FetchLaterLoaderFactoryProxy.prototype.clone = function(factory) {
    var params_ = new FetchLaterLoaderFactory_Clone_Params();
    params_.factory = factory;
    var builder = new codec.MessageV2Builder(
        kFetchLaterLoaderFactory_Clone_Name,
        codec.align(FetchLaterLoaderFactory_Clone_Params.encodedSize));
    builder.setPayload(FetchLaterLoaderFactory_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FetchLaterLoaderFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  FetchLaterLoaderFactoryStub.prototype.createLoader = function(loader, requestId, options, request, trafficAnnotation) {
    return this.delegate_ && this.delegate_.createLoader && this.delegate_.createLoader(loader, requestId, options, request, trafficAnnotation);
  }
  FetchLaterLoaderFactoryStub.prototype.clone = function(factory) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(factory);
  }

  FetchLaterLoaderFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFetchLaterLoaderFactory_CreateLoader_Name:
      var params = reader.decodeStruct(FetchLaterLoaderFactory_CreateLoader_Params);
      this.createLoader(params.loader, params.requestId, params.options, params.request, params.trafficAnnotation);
      return true;
    case kFetchLaterLoaderFactory_Clone_Name:
      var params = reader.decodeStruct(FetchLaterLoaderFactory_Clone_Params);
      this.clone(params.factory);
      return true;
    default:
      return false;
    }
  };

  FetchLaterLoaderFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFetchLaterLoaderFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFetchLaterLoaderFactory_CreateLoader_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FetchLaterLoaderFactory_CreateLoader_Params;
      break;
      case kFetchLaterLoaderFactory_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FetchLaterLoaderFactory_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFetchLaterLoaderFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FetchLaterLoaderFactory = {
    name: 'blink.mojom.FetchLaterLoaderFactory',
    kVersion: 0,
    ptrClass: FetchLaterLoaderFactoryPtr,
    proxyClass: FetchLaterLoaderFactoryProxy,
    stubClass: FetchLaterLoaderFactoryStub,
    validateRequest: validateFetchLaterLoaderFactoryRequest,
    validateResponse: null,
  };
  FetchLaterLoaderFactoryStub.prototype.validator = validateFetchLaterLoaderFactoryRequest;
  FetchLaterLoaderFactoryProxy.prototype.validator = null;
  var kFetchLaterLoader_SendNow_Name = 0;
  var kFetchLaterLoader_Cancel_Name = 1;

  function FetchLaterLoaderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FetchLaterLoader,
                                                   handleOrPtrInfo);
  }

  function FetchLaterLoaderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FetchLaterLoader, associatedInterfacePtrInfo);
  }

  FetchLaterLoaderAssociatedPtr.prototype =
      Object.create(FetchLaterLoaderPtr.prototype);
  FetchLaterLoaderAssociatedPtr.prototype.constructor =
      FetchLaterLoaderAssociatedPtr;

  function FetchLaterLoaderProxy(receiver) {
    this.receiver_ = receiver;
  }
  FetchLaterLoaderPtr.prototype.sendNow = function() {
    return FetchLaterLoaderProxy.prototype.sendNow
        .apply(this.ptr.getProxy(), arguments);
  };

  FetchLaterLoaderProxy.prototype.sendNow = function() {
    var params_ = new FetchLaterLoader_SendNow_Params();
    var builder = new codec.MessageV0Builder(
        kFetchLaterLoader_SendNow_Name,
        codec.align(FetchLaterLoader_SendNow_Params.encodedSize));
    builder.encodeStruct(FetchLaterLoader_SendNow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FetchLaterLoaderPtr.prototype.cancel = function() {
    return FetchLaterLoaderProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  FetchLaterLoaderProxy.prototype.cancel = function() {
    var params_ = new FetchLaterLoader_Cancel_Params();
    var builder = new codec.MessageV0Builder(
        kFetchLaterLoader_Cancel_Name,
        codec.align(FetchLaterLoader_Cancel_Params.encodedSize));
    builder.encodeStruct(FetchLaterLoader_Cancel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FetchLaterLoaderStub(delegate) {
    this.delegate_ = delegate;
  }
  FetchLaterLoaderStub.prototype.sendNow = function() {
    return this.delegate_ && this.delegate_.sendNow && this.delegate_.sendNow();
  }
  FetchLaterLoaderStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }

  FetchLaterLoaderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFetchLaterLoader_SendNow_Name:
      var params = reader.decodeStruct(FetchLaterLoader_SendNow_Params);
      this.sendNow();
      return true;
    case kFetchLaterLoader_Cancel_Name:
      var params = reader.decodeStruct(FetchLaterLoader_Cancel_Params);
      this.cancel();
      return true;
    default:
      return false;
    }
  };

  FetchLaterLoaderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFetchLaterLoaderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFetchLaterLoader_SendNow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FetchLaterLoader_SendNow_Params;
      break;
      case kFetchLaterLoader_Cancel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FetchLaterLoader_Cancel_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFetchLaterLoaderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FetchLaterLoader = {
    name: 'blink.mojom.FetchLaterLoader',
    kVersion: 0,
    ptrClass: FetchLaterLoaderPtr,
    proxyClass: FetchLaterLoaderProxy,
    stubClass: FetchLaterLoaderStub,
    validateRequest: validateFetchLaterLoaderRequest,
    validateResponse: null,
  };
  FetchLaterLoaderStub.prototype.validator = validateFetchLaterLoaderRequest;
  FetchLaterLoaderProxy.prototype.validator = null;
  exports.FetchLaterLoaderFactory = FetchLaterLoaderFactory;
  exports.FetchLaterLoaderFactoryPtr = FetchLaterLoaderFactoryPtr;
  exports.FetchLaterLoaderFactoryAssociatedPtr = FetchLaterLoaderFactoryAssociatedPtr;
  exports.FetchLaterLoader = FetchLaterLoader;
  exports.FetchLaterLoaderPtr = FetchLaterLoaderPtr;
  exports.FetchLaterLoaderAssociatedPtr = FetchLaterLoaderAssociatedPtr;
})();