// third_party/blink/public/mojom/loader/resource_load_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/resource_load_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var byte_count$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_count.mojom', '../../../../../mojo/public/mojom/base/byte_count.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var ip_address$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address.mojom', '../../../../../services/network/public/mojom/ip_address.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', '../../../../../services/network/public/mojom/ip_endpoint.mojom.js');
  }
  var load_timing_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/load_timing_info.mojom', '../../../../../services/network/public/mojom/load_timing_info.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', '../../../../../services/network/public/mojom/network_param.mojom.js');
  }
  var request_priority$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/request_priority.mojom', '../../../../../services/network/public/mojom/request_priority.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var ResourceType = {};
  ResourceType.kMainFrame = 0;
  ResourceType.kSubFrame = 1;
  ResourceType.kStylesheet = 2;
  ResourceType.kScript = 3;
  ResourceType.kImage = 4;
  ResourceType.kFontResource = 5;
  ResourceType.kSubResource = 6;
  ResourceType.kObject = 7;
  ResourceType.kMedia = 8;
  ResourceType.kWorker = 9;
  ResourceType.kSharedWorker = 10;
  ResourceType.kPrefetch = 11;
  ResourceType.kFavicon = 12;
  ResourceType.kXhr = 13;
  ResourceType.kPing = 14;
  ResourceType.kServiceWorker = 15;
  ResourceType.kCspReport = 16;
  ResourceType.kPluginResource = 17;
  ResourceType.kNavigationPreloadMainFrame = 19;
  ResourceType.kNavigationPreloadSubFrame = 20;
  ResourceType.kJson = 21;
  ResourceType.MIN_VALUE = 0;
  ResourceType.MAX_VALUE = 21;

  ResourceType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
      return true;
    }
    return false;
  };

  ResourceType.toKnownEnumValue = function(value) {
    return value;
  };

  ResourceType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CommonNetworkInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CommonNetworkInfo.prototype.initDefaults_ = function() {
    this.networkAccessed = false;
    this.alwaysAccessNetwork = false;
    this.remoteEndpoint = null;
  };
  CommonNetworkInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CommonNetworkInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CommonNetworkInfo.remoteEndpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CommonNetworkInfo.encodedSize = codec.kStructHeaderSize + 16;

  CommonNetworkInfo.decode = function(decoder) {
    var packed;
    var val = new CommonNetworkInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.networkAccessed = (packed >> 0) & 1 ? true : false;
    val.alwaysAccessNetwork = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.remoteEndpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  CommonNetworkInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CommonNetworkInfo.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.networkAccessed & 1) << 0
    packed |= (val.alwaysAccessNetwork & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.remoteEndpoint);
  };
  function RedirectInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RedirectInfo.prototype.initDefaults_ = function() {
    this.originOfNewUrl = null;
    this.networkInfo = null;
  };
  RedirectInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RedirectInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RedirectInfo.originOfNewUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RedirectInfo.networkInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CommonNetworkInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RedirectInfo.encodedSize = codec.kStructHeaderSize + 16;

  RedirectInfo.decode = function(decoder) {
    var packed;
    var val = new RedirectInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.originOfNewUrl =
        decoder.decodeStructPointer(origin$.Origin);
    val.networkInfo =
        decoder.decodeStructPointer(CommonNetworkInfo);
    return val;
  };

  RedirectInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RedirectInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.originOfNewUrl);
    encoder.encodeStructPointer(CommonNetworkInfo, val.networkInfo);
  };
  function ResourceLoadInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResourceLoadInfo.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.finalUrl = null;
    this.referrer = null;
    this.originalUrl = null;
    this.method = null;
    this.requestDestination = 0;
    this.requestPriority = 0;
    this.mimeType = null;
    this.wasCached = false;
    this.netError = 0;
    this.networkInfo = null;
    this.proxyChain = null;
    this.loadTimingInfo = null;
    this.rawBodyBytes = null;
    this.totalReceivedBytes = null;
    this.redirectInfoChain = null;
    this.httpStatusCode = 0;
  };
  ResourceLoadInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResourceLoadInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 128}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ResourceLoadInfo.finalUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.referrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.originalUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.requestDestination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.requestPriority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 44, request_priority$.RequestPriority);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.mimeType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate ResourceLoadInfo.networkInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, CommonNetworkInfo, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ResourceLoadInfo.proxyChain
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, network_param$.ProxyChain, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.loadTimingInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, load_timing_info$.LoadTimingInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.rawBodyBytes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, byte_count$.ByteCount, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.totalReceivedBytes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, byte_count$.ByteCount, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceLoadInfo.redirectInfoChain
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 104, 8, new codec.PointerTo(RedirectInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResourceLoadInfo.encodedSize = codec.kStructHeaderSize + 120;

  ResourceLoadInfo.decode = function(decoder) {
    var packed;
    var val = new ResourceLoadInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int64);
    val.finalUrl =
        decoder.decodeStructPointer(url$.Url);
    val.referrer =
        decoder.decodeStructPointer(url$.Url);
    val.originalUrl =
        decoder.decodeStructPointer(url$.Url);
    val.method =
        decoder.decodeStruct(codec.String);
    val.requestDestination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    val.requestPriority =
        decoder.decodeStruct(new codec.Enum(request_priority$.RequestPriority));
    val.mimeType =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.wasCached = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.netError =
        decoder.decodeStruct(codec.Int32);
    val.networkInfo =
        decoder.decodeStructPointer(CommonNetworkInfo);
    val.proxyChain =
        decoder.decodeStructPointer(network_param$.ProxyChain);
    val.loadTimingInfo =
        decoder.decodeStructPointer(load_timing_info$.LoadTimingInfo);
    val.rawBodyBytes =
        decoder.decodeStructPointer(byte_count$.ByteCount);
    val.totalReceivedBytes =
        decoder.decodeStructPointer(byte_count$.ByteCount);
    val.redirectInfoChain =
        decoder.decodeArrayPointer(new codec.PointerTo(RedirectInfo));
    val.httpStatusCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResourceLoadInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResourceLoadInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.requestId);
    encoder.encodeStructPointer(url$.Url, val.finalUrl);
    encoder.encodeStructPointer(url$.Url, val.referrer);
    encoder.encodeStructPointer(url$.Url, val.originalUrl);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStruct(codec.Int32, val.requestDestination);
    encoder.encodeStruct(codec.Int32, val.requestPriority);
    encoder.encodeStruct(codec.String, val.mimeType);
    packed = 0;
    packed |= (val.wasCached & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.encodeStructPointer(CommonNetworkInfo, val.networkInfo);
    encoder.encodeStructPointer(network_param$.ProxyChain, val.proxyChain);
    encoder.encodeStructPointer(load_timing_info$.LoadTimingInfo, val.loadTimingInfo);
    encoder.encodeStructPointer(byte_count$.ByteCount, val.rawBodyBytes);
    encoder.encodeStructPointer(byte_count$.ByteCount, val.totalReceivedBytes);
    encoder.encodeArrayPointer(new codec.PointerTo(RedirectInfo), val.redirectInfoChain);
    encoder.encodeStruct(codec.Int32, val.httpStatusCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.ResourceType = ResourceType;
  exports.CommonNetworkInfo = CommonNetworkInfo;
  exports.RedirectInfo = RedirectInfo;
  exports.ResourceLoadInfo = ResourceLoadInfo;
})();