// third_party/blink/public/mojom/mediastream/aec_dump.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/mediastream/aec_dump.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../../mojo/public/mojom/base/file.mojom.js');
  }



  function AecDumpAgent_Start_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AecDumpAgent_Start_Params.prototype.initDefaults_ = function() {
    this.file = null;
  };
  AecDumpAgent_Start_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AecDumpAgent_Start_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AecDumpAgent_Start_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AecDumpAgent_Start_Params.encodedSize = codec.kStructHeaderSize + 8;

  AecDumpAgent_Start_Params.decode = function(decoder) {
    var packed;
    var val = new AecDumpAgent_Start_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.file =
        decoder.decodeStructPointer(file$.File);
    return val;
  };

  AecDumpAgent_Start_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AecDumpAgent_Start_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.file);
  };
  function AecDumpAgent_Stop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AecDumpAgent_Stop_Params.prototype.initDefaults_ = function() {
  };
  AecDumpAgent_Stop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AecDumpAgent_Stop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AecDumpAgent_Stop_Params.encodedSize = codec.kStructHeaderSize + 0;

  AecDumpAgent_Stop_Params.decode = function(decoder) {
    var packed;
    var val = new AecDumpAgent_Stop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AecDumpAgent_Stop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AecDumpAgent_Stop_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AecDumpManager_Add_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AecDumpManager_Add_Params.prototype.initDefaults_ = function() {
    this.agent = new AecDumpAgentPtr();
  };
  AecDumpManager_Add_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AecDumpManager_Add_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AecDumpManager_Add_Params.agent
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AecDumpManager_Add_Params.encodedSize = codec.kStructHeaderSize + 8;

  AecDumpManager_Add_Params.decode = function(decoder) {
    var packed;
    var val = new AecDumpManager_Add_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.agent =
        decoder.decodeStruct(new codec.Interface(AecDumpAgentPtr));
    return val;
  };

  AecDumpManager_Add_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AecDumpManager_Add_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AecDumpAgentPtr), val.agent);
  };
  var kAecDumpAgent_Start_Name = 0;
  var kAecDumpAgent_Stop_Name = 1;

  function AecDumpAgentPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AecDumpAgent,
                                                   handleOrPtrInfo);
  }

  function AecDumpAgentAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AecDumpAgent, associatedInterfacePtrInfo);
  }

  AecDumpAgentAssociatedPtr.prototype =
      Object.create(AecDumpAgentPtr.prototype);
  AecDumpAgentAssociatedPtr.prototype.constructor =
      AecDumpAgentAssociatedPtr;

  function AecDumpAgentProxy(receiver) {
    this.receiver_ = receiver;
  }
  AecDumpAgentPtr.prototype.start = function() {
    return AecDumpAgentProxy.prototype.start
        .apply(this.ptr.getProxy(), arguments);
  };

  AecDumpAgentProxy.prototype.start = function(file) {
    var params_ = new AecDumpAgent_Start_Params();
    params_.file = file;
    var builder = new codec.MessageV0Builder(
        kAecDumpAgent_Start_Name,
        codec.align(AecDumpAgent_Start_Params.encodedSize));
    builder.encodeStruct(AecDumpAgent_Start_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AecDumpAgentPtr.prototype.stop = function() {
    return AecDumpAgentProxy.prototype.stop
        .apply(this.ptr.getProxy(), arguments);
  };

  AecDumpAgentProxy.prototype.stop = function() {
    var params_ = new AecDumpAgent_Stop_Params();
    var builder = new codec.MessageV0Builder(
        kAecDumpAgent_Stop_Name,
        codec.align(AecDumpAgent_Stop_Params.encodedSize));
    builder.encodeStruct(AecDumpAgent_Stop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AecDumpAgentStub(delegate) {
    this.delegate_ = delegate;
  }
  AecDumpAgentStub.prototype.start = function(file) {
    return this.delegate_ && this.delegate_.start && this.delegate_.start(file);
  }
  AecDumpAgentStub.prototype.stop = function() {
    return this.delegate_ && this.delegate_.stop && this.delegate_.stop();
  }

  AecDumpAgentStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAecDumpAgent_Start_Name:
      var params = reader.decodeStruct(AecDumpAgent_Start_Params);
      this.start(params.file);
      return true;
    case kAecDumpAgent_Stop_Name:
      var params = reader.decodeStruct(AecDumpAgent_Stop_Params);
      this.stop();
      return true;
    default:
      return false;
    }
  };

  AecDumpAgentStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAecDumpAgentRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAecDumpAgent_Start_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AecDumpAgent_Start_Params;
      break;
      case kAecDumpAgent_Stop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AecDumpAgent_Stop_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAecDumpAgentResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AecDumpAgent = {
    name: 'blink.mojom.AecDumpAgent',
    kVersion: 0,
    ptrClass: AecDumpAgentPtr,
    proxyClass: AecDumpAgentProxy,
    stubClass: AecDumpAgentStub,
    validateRequest: validateAecDumpAgentRequest,
    validateResponse: null,
  };
  AecDumpAgentStub.prototype.validator = validateAecDumpAgentRequest;
  AecDumpAgentProxy.prototype.validator = null;
  var kAecDumpManager_Add_Name = 0;

  function AecDumpManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AecDumpManager,
                                                   handleOrPtrInfo);
  }

  function AecDumpManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AecDumpManager, associatedInterfacePtrInfo);
  }

  AecDumpManagerAssociatedPtr.prototype =
      Object.create(AecDumpManagerPtr.prototype);
  AecDumpManagerAssociatedPtr.prototype.constructor =
      AecDumpManagerAssociatedPtr;

  function AecDumpManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  AecDumpManagerPtr.prototype.add = function() {
    return AecDumpManagerProxy.prototype.add
        .apply(this.ptr.getProxy(), arguments);
  };

  AecDumpManagerProxy.prototype.add = function(agent) {
    var params_ = new AecDumpManager_Add_Params();
    params_.agent = agent;
    var builder = new codec.MessageV0Builder(
        kAecDumpManager_Add_Name,
        codec.align(AecDumpManager_Add_Params.encodedSize));
    builder.encodeStruct(AecDumpManager_Add_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AecDumpManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  AecDumpManagerStub.prototype.add = function(agent) {
    return this.delegate_ && this.delegate_.add && this.delegate_.add(agent);
  }

  AecDumpManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAecDumpManager_Add_Name:
      var params = reader.decodeStruct(AecDumpManager_Add_Params);
      this.add(params.agent);
      return true;
    default:
      return false;
    }
  };

  AecDumpManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAecDumpManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAecDumpManager_Add_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AecDumpManager_Add_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAecDumpManagerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AecDumpManager = {
    name: 'blink.mojom.AecDumpManager',
    kVersion: 0,
    ptrClass: AecDumpManagerPtr,
    proxyClass: AecDumpManagerProxy,
    stubClass: AecDumpManagerStub,
    validateRequest: validateAecDumpManagerRequest,
    validateResponse: null,
  };
  AecDumpManagerStub.prototype.validator = validateAecDumpManagerRequest;
  AecDumpManagerProxy.prototype.validator = null;
  exports.AecDumpAgent = AecDumpAgent;
  exports.AecDumpAgentPtr = AecDumpAgentPtr;
  exports.AecDumpAgentAssociatedPtr = AecDumpAgentAssociatedPtr;
  exports.AecDumpManager = AecDumpManager;
  exports.AecDumpManagerPtr = AecDumpManagerPtr;
  exports.AecDumpManagerAssociatedPtr = AecDumpManagerAssociatedPtr;
})();