// third_party/blink/public/mojom/mediastream/media_devices.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/mediastream/media_devices.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var video_capture_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/capture/mojom/video_capture_types.mojom', '../../../../../media/capture/mojom/video_capture_types.mojom.js');
  }
  var audio_parameters$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_parameters.mojom', '../../../../../media/mojo/mojom/audio_parameters.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', '../../../../../media/mojo/mojom/media_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var capture_handle_config$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/media/capture_handle_config.mojom', '../media/capture_handle_config.mojom.js');
  }


  var MediaDeviceType = {};
  MediaDeviceType.kMediaAudioInput = 0;
  MediaDeviceType.kMediaVideoInput = 1;
  MediaDeviceType.kMediaAudioOutput = 2;
  MediaDeviceType.kNumMediaDeviceTypes = 3;
  MediaDeviceType.MIN_VALUE = 0;
  MediaDeviceType.MAX_VALUE = 3;

  MediaDeviceType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  MediaDeviceType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaDeviceType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FacingMode = {};
  FacingMode.kNone = 0;
  FacingMode.kUser = 1;
  FacingMode.kEnvironment = 2;
  FacingMode.kLeft = 3;
  FacingMode.kRight = 4;
  FacingMode.MIN_VALUE = 0;
  FacingMode.MAX_VALUE = 4;

  FacingMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  FacingMode.toKnownEnumValue = function(value) {
    return value;
  };

  FacingMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AudioOutputStatus = {};
  AudioOutputStatus.kSuccess = 0;
  AudioOutputStatus.kNoPermission = 1;
  AudioOutputStatus.kNoDevices = 2;
  AudioOutputStatus.kUnknown = 3;
  AudioOutputStatus.kDeviceNotFound = 4;
  AudioOutputStatus.kErrorOtherRequestInProgress = 5;
  AudioOutputStatus.kNotSupported = 6;
  AudioOutputStatus.kNoUserActivation = 7;
  AudioOutputStatus.MIN_VALUE = 0;
  AudioOutputStatus.MAX_VALUE = 7;

  AudioOutputStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  AudioOutputStatus.toKnownEnumValue = function(value) {
    return value;
  };

  AudioOutputStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MediaDeviceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDeviceInfo.prototype.initDefaults_ = function() {
    this.deviceId = null;
    this.label = null;
    this.groupId = null;
    this.controlSupport = null;
    this.facingMode = 0;
    this.availability_$flag = false;
    this.availability_$value = 0;
  };
  MediaDeviceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDeviceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDeviceInfo.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDeviceInfo.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDeviceInfo.groupId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDeviceInfo.controlSupport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, video_capture_types$.VideoCaptureControlSupport, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDeviceInfo.facingMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, FacingMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaDeviceInfo.availability_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, video_capture_types$.CameraAvailability);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDeviceInfo.encodedSize = codec.kStructHeaderSize + 48;

  MediaDeviceInfo.decode = function(decoder) {
    var packed;
    var val = new MediaDeviceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.label =
        decoder.decodeStruct(codec.String);
    val.groupId =
        decoder.decodeStruct(codec.String);
    val.controlSupport =
        decoder.decodeStructPointer(video_capture_types$.VideoCaptureControlSupport);
    val.facingMode =
        decoder.decodeStruct(new codec.Enum(FacingMode));
    packed = decoder.readUint8();
    val.availability_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.availability_$value =
        decoder.decodeStruct(new codec.Enum(video_capture_types$.CameraAvailability));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaDeviceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDeviceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStruct(codec.String, val.groupId);
    encoder.encodeStructPointer(video_capture_types$.VideoCaptureControlSupport, val.controlSupport);
    encoder.encodeStruct(codec.Int32, val.facingMode);
    packed = 0;
    packed |= (val.availability_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.availability_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoInputDeviceCapabilities(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoInputDeviceCapabilities.prototype.initDefaults_ = function() {
    this.deviceId = null;
    this.groupId = null;
    this.controlSupport = null;
    this.formats = null;
    this.facingMode = 0;
    this.availability_$flag = false;
    this.availability_$value = 0;
  };
  VideoInputDeviceCapabilities.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoInputDeviceCapabilities.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoInputDeviceCapabilities.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoInputDeviceCapabilities.groupId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoInputDeviceCapabilities.controlSupport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, video_capture_types$.VideoCaptureControlSupport, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoInputDeviceCapabilities.formats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(video_capture_types$.VideoCaptureFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoInputDeviceCapabilities.facingMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, FacingMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoInputDeviceCapabilities.availability_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, video_capture_types$.CameraAvailability);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoInputDeviceCapabilities.encodedSize = codec.kStructHeaderSize + 48;

  VideoInputDeviceCapabilities.decode = function(decoder) {
    var packed;
    var val = new VideoInputDeviceCapabilities();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.groupId =
        decoder.decodeStruct(codec.String);
    val.controlSupport =
        decoder.decodeStructPointer(video_capture_types$.VideoCaptureControlSupport);
    val.formats =
        decoder.decodeArrayPointer(new codec.PointerTo(video_capture_types$.VideoCaptureFormat));
    val.facingMode =
        decoder.decodeStruct(new codec.Enum(FacingMode));
    packed = decoder.readUint8();
    val.availability_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.availability_$value =
        decoder.decodeStruct(new codec.Enum(video_capture_types$.CameraAvailability));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoInputDeviceCapabilities.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoInputDeviceCapabilities.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStruct(codec.String, val.groupId);
    encoder.encodeStructPointer(video_capture_types$.VideoCaptureControlSupport, val.controlSupport);
    encoder.encodeArrayPointer(new codec.PointerTo(video_capture_types$.VideoCaptureFormat), val.formats);
    encoder.encodeStruct(codec.Int32, val.facingMode);
    packed = 0;
    packed |= (val.availability_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.availability_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SelectAudioOutputResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SelectAudioOutputResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.deviceInfo = null;
  };
  SelectAudioOutputResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SelectAudioOutputResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SelectAudioOutputResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AudioOutputStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SelectAudioOutputResult.deviceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MediaDeviceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SelectAudioOutputResult.encodedSize = codec.kStructHeaderSize + 16;

  SelectAudioOutputResult.decode = function(decoder) {
    var packed;
    var val = new SelectAudioOutputResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(AudioOutputStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deviceInfo =
        decoder.decodeStructPointer(MediaDeviceInfo);
    return val;
  };

  SelectAudioOutputResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SelectAudioOutputResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(MediaDeviceInfo, val.deviceInfo);
  };
  function AudioInputDeviceCapabilities(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioInputDeviceCapabilities.prototype.initDefaults_ = function() {
    this.deviceId = null;
    this.groupId = null;
    this.parameters = null;
    this.isValid = false;
    this.channels = 0;
    this.sampleRate = 0;
    this.latency = null;
  };
  AudioInputDeviceCapabilities.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioInputDeviceCapabilities.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioInputDeviceCapabilities.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioInputDeviceCapabilities.groupId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioInputDeviceCapabilities.parameters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate AudioInputDeviceCapabilities.latency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioInputDeviceCapabilities.encodedSize = codec.kStructHeaderSize + 48;

  AudioInputDeviceCapabilities.decode = function(decoder) {
    var packed;
    var val = new AudioInputDeviceCapabilities();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.groupId =
        decoder.decodeStruct(codec.String);
    val.parameters =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    packed = decoder.readUint8();
    val.isValid = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.channels =
        decoder.decodeStruct(codec.Int32);
    val.sampleRate =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.latency =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AudioInputDeviceCapabilities.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioInputDeviceCapabilities.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStruct(codec.String, val.groupId);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.parameters);
    packed = 0;
    packed |= (val.isValid & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.channels);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.latency);
  };
  function MediaDevicesDispatcherHost_EnumerateDevices_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_EnumerateDevices_Params.prototype.initDefaults_ = function() {
    this.requestAudioInput = false;
    this.requestVideoInput = false;
    this.requestAudioOutput = false;
    this.requestVideoInputCapabilities = false;
    this.requestAudioInputCapabilities = false;
  };
  MediaDevicesDispatcherHost_EnumerateDevices_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_EnumerateDevices_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_EnumerateDevices_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_EnumerateDevices_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_EnumerateDevices_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.requestAudioInput = (packed >> 0) & 1 ? true : false;
    val.requestVideoInput = (packed >> 1) & 1 ? true : false;
    val.requestAudioOutput = (packed >> 2) & 1 ? true : false;
    val.requestVideoInputCapabilities = (packed >> 3) & 1 ? true : false;
    val.requestAudioInputCapabilities = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaDevicesDispatcherHost_EnumerateDevices_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_EnumerateDevices_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.requestAudioInput & 1) << 0
    packed |= (val.requestVideoInput & 1) << 1
    packed |= (val.requestAudioOutput & 1) << 2
    packed |= (val.requestVideoInputCapabilities & 1) << 3
    packed |= (val.requestAudioInputCapabilities & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.prototype.initDefaults_ = function() {
    this.enumeration = null;
    this.videoInputDeviceCapabilities = null;
    this.audioInputDeviceCapabilities = null;
  };
  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.enumeration
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.ArrayOf(new codec.PointerTo(MediaDeviceInfo)), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.videoInputDeviceCapabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(VideoInputDeviceCapabilities), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.audioInputDeviceCapabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(AudioInputDeviceCapabilities), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.enumeration =
        decoder.decodeArrayPointer(new codec.ArrayOf(new codec.PointerTo(MediaDeviceInfo)));
    val.videoInputDeviceCapabilities =
        decoder.decodeArrayPointer(new codec.PointerTo(VideoInputDeviceCapabilities));
    val.audioInputDeviceCapabilities =
        decoder.decodeArrayPointer(new codec.PointerTo(AudioInputDeviceCapabilities));
    return val;
  };

  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.ArrayOf(new codec.PointerTo(MediaDeviceInfo)), val.enumeration);
    encoder.encodeArrayPointer(new codec.PointerTo(VideoInputDeviceCapabilities), val.videoInputDeviceCapabilities);
    encoder.encodeArrayPointer(new codec.PointerTo(AudioInputDeviceCapabilities), val.audioInputDeviceCapabilities);
  };
  function MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.prototype.initDefaults_ = function() {
  };
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.prototype.initDefaults_ = function() {
    this.videoInputDeviceCapabilities = null;
  };
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.videoInputDeviceCapabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(VideoInputDeviceCapabilities), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.videoInputDeviceCapabilities =
        decoder.decodeArrayPointer(new codec.PointerTo(VideoInputDeviceCapabilities));
    return val;
  };

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(VideoInputDeviceCapabilities), val.videoInputDeviceCapabilities);
  };
  function MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.prototype.initDefaults_ = function() {
    this.deviceId = null;
  };
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
  };
  function MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.prototype.initDefaults_ = function() {
    this.formats = null;
  };
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.formats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(video_capture_types$.VideoCaptureFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.formats =
        decoder.decodeArrayPointer(new codec.PointerTo(video_capture_types$.VideoCaptureFormat));
    return val;
  };

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(video_capture_types$.VideoCaptureFormat), val.formats);
  };
  function MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.prototype.initDefaults_ = function() {
    this.deviceId = null;
  };
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
  };
  function MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.prototype.initDefaults_ = function() {
    this.formats = null;
  };
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.formats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(video_capture_types$.VideoCaptureFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.formats =
        decoder.decodeArrayPointer(new codec.PointerTo(video_capture_types$.VideoCaptureFormat));
    return val;
  };

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(video_capture_types$.VideoCaptureFormat), val.formats);
  };
  function MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.prototype.initDefaults_ = function() {
  };
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.prototype.initDefaults_ = function() {
    this.audioInputDeviceCapabilities = null;
  };
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.audioInputDeviceCapabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AudioInputDeviceCapabilities), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioInputDeviceCapabilities =
        decoder.decodeArrayPointer(new codec.PointerTo(AudioInputDeviceCapabilities));
    return val;
  };

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AudioInputDeviceCapabilities), val.audioInputDeviceCapabilities);
  };
  function MediaDevicesDispatcherHost_AddMediaDevicesListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.prototype.initDefaults_ = function() {
    this.subscribeAudioInput = false;
    this.subscribeVideoInput = false;
    this.subscribeAudioOutput = false;
    this.listener = new MediaDevicesListenerPtr();
  };
  MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_AddMediaDevicesListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.subscribeAudioInput = (packed >> 0) & 1 ? true : false;
    val.subscribeVideoInput = (packed >> 1) & 1 ? true : false;
    val.subscribeAudioOutput = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.listener =
        decoder.decodeStruct(new codec.Interface(MediaDevicesListenerPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.subscribeAudioInput & 1) << 0
    packed |= (val.subscribeVideoInput & 1) << 1
    packed |= (val.subscribeAudioOutput & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(new codec.Interface(MediaDevicesListenerPtr), val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.prototype.initDefaults_ = function() {
    this.config = null;
  };
  MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, capture_handle_config$.CaptureHandleConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(capture_handle_config$.CaptureHandleConfig);
    return val;
  };

  MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(capture_handle_config$.CaptureHandleConfig, val.config);
  };
  function MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.prototype.initDefaults_ = function() {
    this.label = null;
  };
  MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
  };
  function MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, video_capture_types$.SubCaptureTargetType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(video_capture_types$.SubCaptureTargetType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.prototype.initDefaults_ = function() {
    this.id = null;
  };
  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
  };
  function MediaDevicesDispatcherHost_SetPreferredSinkId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_SetPreferredSinkId_Params.prototype.initDefaults_ = function() {
    this.sinkId = null;
  };
  MediaDevicesDispatcherHost_SetPreferredSinkId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_SetPreferredSinkId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_SetPreferredSinkId_Params.sinkId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_SetPreferredSinkId_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_SetPreferredSinkId_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_SetPreferredSinkId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaDevicesDispatcherHost_SetPreferredSinkId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_SetPreferredSinkId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sinkId);
  };
  function MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.OutputDeviceStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(media_types$.OutputDeviceStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaDevicesDispatcherHost_SelectAudioOutput_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_SelectAudioOutput_Params.prototype.initDefaults_ = function() {
    this.deviceId = null;
  };
  MediaDevicesDispatcherHost_SelectAudioOutput_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_SelectAudioOutput_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_SelectAudioOutput_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_SelectAudioOutput_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_SelectAudioOutput_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_SelectAudioOutput_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaDevicesDispatcherHost_SelectAudioOutput_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_SelectAudioOutput_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceId);
  };
  function MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SelectAudioOutputResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(SelectAudioOutputResult);
    return val;
  };

  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SelectAudioOutputResult, val.result);
  };
  function MediaDevicesListener_OnDevicesChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaDevicesListener_OnDevicesChanged_Params.prototype.initDefaults_ = function() {
    this.type = 0;
    this.deviceInfos = null;
  };
  MediaDevicesListener_OnDevicesChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaDevicesListener_OnDevicesChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesListener_OnDevicesChanged_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaDeviceType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaDevicesListener_OnDevicesChanged_Params.deviceInfos
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(MediaDeviceInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaDevicesListener_OnDevicesChanged_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaDevicesListener_OnDevicesChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaDevicesListener_OnDevicesChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(MediaDeviceType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deviceInfos =
        decoder.decodeArrayPointer(new codec.PointerTo(MediaDeviceInfo));
    return val;
  };

  MediaDevicesListener_OnDevicesChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaDevicesListener_OnDevicesChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(MediaDeviceInfo), val.deviceInfos);
  };
  var kMediaDevicesDispatcherHost_EnumerateDevices_Name = 0;
  var kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name = 1;
  var kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name = 2;
  var kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name = 3;
  var kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name = 4;
  var kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name = 5;
  var kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name = 6;
  var kMediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Name = 7;
  var kMediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Name = 8;
  var kMediaDevicesDispatcherHost_SetPreferredSinkId_Name = 9;
  var kMediaDevicesDispatcherHost_SelectAudioOutput_Name = 10;

  function MediaDevicesDispatcherHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaDevicesDispatcherHost,
                                                   handleOrPtrInfo);
  }

  function MediaDevicesDispatcherHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaDevicesDispatcherHost, associatedInterfacePtrInfo);
  }

  MediaDevicesDispatcherHostAssociatedPtr.prototype =
      Object.create(MediaDevicesDispatcherHostPtr.prototype);
  MediaDevicesDispatcherHostAssociatedPtr.prototype.constructor =
      MediaDevicesDispatcherHostAssociatedPtr;

  function MediaDevicesDispatcherHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaDevicesDispatcherHostPtr.prototype.enumerateDevices = function() {
    return MediaDevicesDispatcherHostProxy.prototype.enumerateDevices
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.enumerateDevices = function(requestAudioInput, requestVideoInput, requestAudioOutput, requestVideoInputCapabilities, requestAudioInputCapabilities) {
    var params_ = new MediaDevicesDispatcherHost_EnumerateDevices_Params();
    params_.requestAudioInput = requestAudioInput;
    params_.requestVideoInput = requestVideoInput;
    params_.requestAudioOutput = requestAudioOutput;
    params_.requestVideoInputCapabilities = requestVideoInputCapabilities;
    params_.requestAudioInputCapabilities = requestAudioInputCapabilities;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_EnumerateDevices_Name,
          codec.align(MediaDevicesDispatcherHost_EnumerateDevices_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_EnumerateDevices_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.getVideoInputCapabilities = function() {
    return MediaDevicesDispatcherHostProxy.prototype.getVideoInputCapabilities
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.getVideoInputCapabilities = function() {
    var params_ = new MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name,
          codec.align(MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.getAllVideoInputDeviceFormats = function() {
    return MediaDevicesDispatcherHostProxy.prototype.getAllVideoInputDeviceFormats
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.getAllVideoInputDeviceFormats = function(deviceId) {
    var params_ = new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params();
    params_.deviceId = deviceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name,
          codec.align(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.getAvailableVideoInputDeviceFormats = function() {
    return MediaDevicesDispatcherHostProxy.prototype.getAvailableVideoInputDeviceFormats
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.getAvailableVideoInputDeviceFormats = function(deviceId) {
    var params_ = new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params();
    params_.deviceId = deviceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name,
          codec.align(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.getAudioInputCapabilities = function() {
    return MediaDevicesDispatcherHostProxy.prototype.getAudioInputCapabilities
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.getAudioInputCapabilities = function() {
    var params_ = new MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name,
          codec.align(MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.addMediaDevicesListener = function() {
    return MediaDevicesDispatcherHostProxy.prototype.addMediaDevicesListener
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.addMediaDevicesListener = function(subscribeAudioInput, subscribeVideoInput, subscribeAudioOutput, listener) {
    var params_ = new MediaDevicesDispatcherHost_AddMediaDevicesListener_Params();
    params_.subscribeAudioInput = subscribeAudioInput;
    params_.subscribeVideoInput = subscribeVideoInput;
    params_.subscribeAudioOutput = subscribeAudioOutput;
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name,
        codec.align(MediaDevicesDispatcherHost_AddMediaDevicesListener_Params.encodedSize));
    builder.encodeStruct(MediaDevicesDispatcherHost_AddMediaDevicesListener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaDevicesDispatcherHostPtr.prototype.setCaptureHandleConfig = function() {
    return MediaDevicesDispatcherHostProxy.prototype.setCaptureHandleConfig
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.setCaptureHandleConfig = function(config) {
    var params_ = new MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params();
    params_.config = config;
    var builder = new codec.MessageV0Builder(
        kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name,
        codec.align(MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params.encodedSize));
    builder.encodeStruct(MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaDevicesDispatcherHostPtr.prototype.closeFocusWindowOfOpportunity = function() {
    return MediaDevicesDispatcherHostProxy.prototype.closeFocusWindowOfOpportunity
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.closeFocusWindowOfOpportunity = function(label) {
    var params_ = new MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params();
    params_.label = label;
    var builder = new codec.MessageV0Builder(
        kMediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Name,
        codec.align(MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params.encodedSize));
    builder.encodeStruct(MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaDevicesDispatcherHostPtr.prototype.produceSubCaptureTargetId = function() {
    return MediaDevicesDispatcherHostProxy.prototype.produceSubCaptureTargetId
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.produceSubCaptureTargetId = function(type) {
    var params_ = new MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Name,
          codec.align(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.setPreferredSinkId = function() {
    return MediaDevicesDispatcherHostProxy.prototype.setPreferredSinkId
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.setPreferredSinkId = function(sinkId) {
    var params_ = new MediaDevicesDispatcherHost_SetPreferredSinkId_Params();
    params_.sinkId = sinkId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_SetPreferredSinkId_Name,
          codec.align(MediaDevicesDispatcherHost_SetPreferredSinkId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_SetPreferredSinkId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaDevicesDispatcherHostPtr.prototype.selectAudioOutput = function() {
    return MediaDevicesDispatcherHostProxy.prototype.selectAudioOutput
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesDispatcherHostProxy.prototype.selectAudioOutput = function(deviceId) {
    var params_ = new MediaDevicesDispatcherHost_SelectAudioOutput_Params();
    params_.deviceId = deviceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaDevicesDispatcherHost_SelectAudioOutput_Name,
          codec.align(MediaDevicesDispatcherHost_SelectAudioOutput_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaDevicesDispatcherHost_SelectAudioOutput_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MediaDevicesDispatcherHostStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaDevicesDispatcherHostStub.prototype.enumerateDevices = function(requestAudioInput, requestVideoInput, requestAudioOutput, requestVideoInputCapabilities, requestAudioInputCapabilities) {
    return this.delegate_ && this.delegate_.enumerateDevices && this.delegate_.enumerateDevices(requestAudioInput, requestVideoInput, requestAudioOutput, requestVideoInputCapabilities, requestAudioInputCapabilities);
  }
  MediaDevicesDispatcherHostStub.prototype.getVideoInputCapabilities = function() {
    return this.delegate_ && this.delegate_.getVideoInputCapabilities && this.delegate_.getVideoInputCapabilities();
  }
  MediaDevicesDispatcherHostStub.prototype.getAllVideoInputDeviceFormats = function(deviceId) {
    return this.delegate_ && this.delegate_.getAllVideoInputDeviceFormats && this.delegate_.getAllVideoInputDeviceFormats(deviceId);
  }
  MediaDevicesDispatcherHostStub.prototype.getAvailableVideoInputDeviceFormats = function(deviceId) {
    return this.delegate_ && this.delegate_.getAvailableVideoInputDeviceFormats && this.delegate_.getAvailableVideoInputDeviceFormats(deviceId);
  }
  MediaDevicesDispatcherHostStub.prototype.getAudioInputCapabilities = function() {
    return this.delegate_ && this.delegate_.getAudioInputCapabilities && this.delegate_.getAudioInputCapabilities();
  }
  MediaDevicesDispatcherHostStub.prototype.addMediaDevicesListener = function(subscribeAudioInput, subscribeVideoInput, subscribeAudioOutput, listener) {
    return this.delegate_ && this.delegate_.addMediaDevicesListener && this.delegate_.addMediaDevicesListener(subscribeAudioInput, subscribeVideoInput, subscribeAudioOutput, listener);
  }
  MediaDevicesDispatcherHostStub.prototype.setCaptureHandleConfig = function(config) {
    return this.delegate_ && this.delegate_.setCaptureHandleConfig && this.delegate_.setCaptureHandleConfig(config);
  }
  MediaDevicesDispatcherHostStub.prototype.closeFocusWindowOfOpportunity = function(label) {
    return this.delegate_ && this.delegate_.closeFocusWindowOfOpportunity && this.delegate_.closeFocusWindowOfOpportunity(label);
  }
  MediaDevicesDispatcherHostStub.prototype.produceSubCaptureTargetId = function(type) {
    return this.delegate_ && this.delegate_.produceSubCaptureTargetId && this.delegate_.produceSubCaptureTargetId(type);
  }
  MediaDevicesDispatcherHostStub.prototype.setPreferredSinkId = function(sinkId) {
    return this.delegate_ && this.delegate_.setPreferredSinkId && this.delegate_.setPreferredSinkId(sinkId);
  }
  MediaDevicesDispatcherHostStub.prototype.selectAudioOutput = function(deviceId) {
    return this.delegate_ && this.delegate_.selectAudioOutput && this.delegate_.selectAudioOutput(deviceId);
  }

  MediaDevicesDispatcherHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_AddMediaDevicesListener_Params);
      this.addMediaDevicesListener(params.subscribeAudioInput, params.subscribeVideoInput, params.subscribeAudioOutput, params.listener);
      return true;
    case kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params);
      this.setCaptureHandleConfig(params.config);
      return true;
    case kMediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params);
      this.closeFocusWindowOfOpportunity(params.label);
      return true;
    default:
      return false;
    }
  };

  MediaDevicesDispatcherHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaDevicesDispatcherHost_EnumerateDevices_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_EnumerateDevices_Params);
      this.enumerateDevices(params.requestAudioInput, params.requestVideoInput, params.requestAudioOutput, params.requestVideoInputCapabilities, params.requestAudioInputCapabilities).then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams();
        responseParams.enumeration = response.enumeration;
        responseParams.videoInputDeviceCapabilities = response.videoInputDeviceCapabilities;
        responseParams.audioInputDeviceCapabilities = response.audioInputDeviceCapabilities;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_EnumerateDevices_Name,
            codec.align(MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params);
      this.getVideoInputCapabilities().then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams();
        responseParams.videoInputDeviceCapabilities = response.videoInputDeviceCapabilities;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name,
            codec.align(MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params);
      this.getAllVideoInputDeviceFormats(params.deviceId).then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams();
        responseParams.formats = response.formats;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name,
            codec.align(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params);
      this.getAvailableVideoInputDeviceFormats(params.deviceId).then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams();
        responseParams.formats = response.formats;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name,
            codec.align(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params);
      this.getAudioInputCapabilities().then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams();
        responseParams.audioInputDeviceCapabilities = response.audioInputDeviceCapabilities;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name,
            codec.align(MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params);
      this.produceSubCaptureTargetId(params.type).then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams();
        responseParams.id = response.id;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Name,
            codec.align(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_SetPreferredSinkId_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_SetPreferredSinkId_Params);
      this.setPreferredSinkId(params.sinkId).then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_SetPreferredSinkId_Name,
            codec.align(MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaDevicesDispatcherHost_SelectAudioOutput_Name:
      var params = reader.decodeStruct(MediaDevicesDispatcherHost_SelectAudioOutput_Params);
      this.selectAudioOutput(params.deviceId).then(function(response) {
        var responseParams =
            new MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMediaDevicesDispatcherHost_SelectAudioOutput_Name,
            codec.align(MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMediaDevicesDispatcherHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaDevicesDispatcherHost_EnumerateDevices_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_EnumerateDevices_Params;
      break;
      case kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params;
      break;
      case kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params;
      break;
      case kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params;
      break;
      case kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params;
      break;
      case kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_AddMediaDevicesListener_Params;
      break;
      case kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params;
      break;
      case kMediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params;
      break;
      case kMediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params;
      break;
      case kMediaDevicesDispatcherHost_SetPreferredSinkId_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_SetPreferredSinkId_Params;
      break;
      case kMediaDevicesDispatcherHost_SelectAudioOutput_Name:
        if (message.expectsResponse())
          paramsClass = MediaDevicesDispatcherHost_SelectAudioOutput_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaDevicesDispatcherHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMediaDevicesDispatcherHost_EnumerateDevices_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_SetPreferredSinkId_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams;
        break;
      case kMediaDevicesDispatcherHost_SelectAudioOutput_Name:
        if (message.isResponse())
          paramsClass = MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MediaDevicesDispatcherHost = {
    name: 'blink.mojom.MediaDevicesDispatcherHost',
    kVersion: 0,
    ptrClass: MediaDevicesDispatcherHostPtr,
    proxyClass: MediaDevicesDispatcherHostProxy,
    stubClass: MediaDevicesDispatcherHostStub,
    validateRequest: validateMediaDevicesDispatcherHostRequest,
    validateResponse: validateMediaDevicesDispatcherHostResponse,
  };
  MediaDevicesDispatcherHostStub.prototype.validator = validateMediaDevicesDispatcherHostRequest;
  MediaDevicesDispatcherHostProxy.prototype.validator = validateMediaDevicesDispatcherHostResponse;
  var kMediaDevicesListener_OnDevicesChanged_Name = 0;

  function MediaDevicesListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaDevicesListener,
                                                   handleOrPtrInfo);
  }

  function MediaDevicesListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaDevicesListener, associatedInterfacePtrInfo);
  }

  MediaDevicesListenerAssociatedPtr.prototype =
      Object.create(MediaDevicesListenerPtr.prototype);
  MediaDevicesListenerAssociatedPtr.prototype.constructor =
      MediaDevicesListenerAssociatedPtr;

  function MediaDevicesListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaDevicesListenerPtr.prototype.onDevicesChanged = function() {
    return MediaDevicesListenerProxy.prototype.onDevicesChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaDevicesListenerProxy.prototype.onDevicesChanged = function(type, deviceInfos) {
    var params_ = new MediaDevicesListener_OnDevicesChanged_Params();
    params_.type = type;
    params_.deviceInfos = deviceInfos;
    var builder = new codec.MessageV0Builder(
        kMediaDevicesListener_OnDevicesChanged_Name,
        codec.align(MediaDevicesListener_OnDevicesChanged_Params.encodedSize));
    builder.encodeStruct(MediaDevicesListener_OnDevicesChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaDevicesListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaDevicesListenerStub.prototype.onDevicesChanged = function(type, deviceInfos) {
    return this.delegate_ && this.delegate_.onDevicesChanged && this.delegate_.onDevicesChanged(type, deviceInfos);
  }

  MediaDevicesListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaDevicesListener_OnDevicesChanged_Name:
      var params = reader.decodeStruct(MediaDevicesListener_OnDevicesChanged_Params);
      this.onDevicesChanged(params.type, params.deviceInfos);
      return true;
    default:
      return false;
    }
  };

  MediaDevicesListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaDevicesListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaDevicesListener_OnDevicesChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaDevicesListener_OnDevicesChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaDevicesListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaDevicesListener = {
    name: 'blink.mojom.MediaDevicesListener',
    kVersion: 0,
    ptrClass: MediaDevicesListenerPtr,
    proxyClass: MediaDevicesListenerProxy,
    stubClass: MediaDevicesListenerStub,
    validateRequest: validateMediaDevicesListenerRequest,
    validateResponse: null,
  };
  MediaDevicesListenerStub.prototype.validator = validateMediaDevicesListenerRequest;
  MediaDevicesListenerProxy.prototype.validator = null;
  exports.MediaDeviceType = MediaDeviceType;
  exports.FacingMode = FacingMode;
  exports.AudioOutputStatus = AudioOutputStatus;
  exports.MediaDeviceInfo = MediaDeviceInfo;
  exports.VideoInputDeviceCapabilities = VideoInputDeviceCapabilities;
  exports.SelectAudioOutputResult = SelectAudioOutputResult;
  exports.AudioInputDeviceCapabilities = AudioInputDeviceCapabilities;
  exports.MediaDevicesDispatcherHost = MediaDevicesDispatcherHost;
  exports.MediaDevicesDispatcherHostPtr = MediaDevicesDispatcherHostPtr;
  exports.MediaDevicesDispatcherHostAssociatedPtr = MediaDevicesDispatcherHostAssociatedPtr;
  exports.MediaDevicesListener = MediaDevicesListener;
  exports.MediaDevicesListenerPtr = MediaDevicesListenerPtr;
  exports.MediaDevicesListenerAssociatedPtr = MediaDevicesListenerAssociatedPtr;
})();