// third_party/blink/public/mojom/messaging/cloneable_message.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/messaging/cloneable_message.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var serialized_blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/serialized_blob.mojom', '../blob/serialized_blob.mojom.js');
  }
  var file_system_access_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom', '../file_system_access/file_system_access_transfer_token.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function CloneableMessage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CloneableMessage.prototype.initDefaults_ = function() {
    this.encodedMessage = null;
    this.blobs = null;
    this.senderOrigin = null;
    this.stackTraceId = 0;
    this.stackTraceDebuggerIdFirst = 0;
    this.stackTraceDebuggerIdSecond = 0;
    this.stackTraceShouldPause = false;
    this.lockedToSenderAgentCluster = false;
    this.senderAgentClusterId = null;
    this.fileSystemAccessTokens = null;
  };
  CloneableMessage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CloneableMessage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CloneableMessage.encodedMessage
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CloneableMessage.blobs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(serialized_blob$.SerializedBlob), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CloneableMessage.senderOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;






    // validate CloneableMessage.senderAgentClusterId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CloneableMessage.fileSystemAccessTokens
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 72, 8, new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CloneableMessage.encodedSize = codec.kStructHeaderSize + 80;

  CloneableMessage.decode = function(decoder) {
    var packed;
    var val = new CloneableMessage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encodedMessage =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    val.blobs =
        decoder.decodeArrayPointer(new codec.PointerTo(serialized_blob$.SerializedBlob));
    val.senderOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.stackTraceId =
        decoder.decodeStruct(codec.Uint64);
    val.stackTraceDebuggerIdFirst =
        decoder.decodeStruct(codec.Int64);
    val.stackTraceDebuggerIdSecond =
        decoder.decodeStruct(codec.Int64);
    packed = decoder.readUint8();
    val.stackTraceShouldPause = (packed >> 0) & 1 ? true : false;
    val.lockedToSenderAgentCluster = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.senderAgentClusterId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.fileSystemAccessTokens =
        decoder.decodeArrayPointer(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    return val;
  };

  CloneableMessage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CloneableMessage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.encodedMessage);
    encoder.encodeArrayPointer(new codec.PointerTo(serialized_blob$.SerializedBlob), val.blobs);
    encoder.encodeStructPointer(origin$.Origin, val.senderOrigin);
    encoder.encodeStruct(codec.Uint64, val.stackTraceId);
    encoder.encodeStruct(codec.Int64, val.stackTraceDebuggerIdFirst);
    encoder.encodeStruct(codec.Int64, val.stackTraceDebuggerIdSecond);
    packed = 0;
    packed |= (val.stackTraceShouldPause & 1) << 0
    packed |= (val.lockedToSenderAgentCluster & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.senderAgentClusterId);
    encoder.encodeArrayPointer(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.fileSystemAccessTokens);
  };
  exports.CloneableMessage = CloneableMessage;
})();