// third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function UserActivationSnapshot(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UserActivationSnapshot.prototype.initDefaults_ = function() {
    this.hasBeenActive = false;
    this.wasActive = false;
  };
  UserActivationSnapshot.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UserActivationSnapshot.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  UserActivationSnapshot.encodedSize = codec.kStructHeaderSize + 8;

  UserActivationSnapshot.decode = function(decoder) {
    var packed;
    var val = new UserActivationSnapshot();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasBeenActive = (packed >> 0) & 1 ? true : false;
    val.wasActive = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UserActivationSnapshot.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UserActivationSnapshot.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasBeenActive & 1) << 0
    packed |= (val.wasActive & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.UserActivationSnapshot = UserActivationSnapshot;
})();