// third_party/blink/public/mojom/navigation/navigation_params.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  CSPDisposition as network_mojom_CSPDisposition,
  CSPDispositionSpec as network_mojom_CSPDispositionSpec
} from '../../../../../services/network/public/mojom/content_security_policy.mojom.m.js';

import {
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  SourceLocation as network_mojom_SourceLocation,
  SourceLocationSpec as network_mojom_SourceLocationSpec
} from '../../../../../services/network/public/mojom/source_location.mojom.m.js';

import {
  StorageAccessApiStatus as network_mojom_StorageAccessApiStatus,
  StorageAccessApiStatusSpec as network_mojom_StorageAccessApiStatusSpec
} from '../../../../../services/network/public/mojom/storage_access_api.mojom.m.js';

import {
  TrustTokenParams as network_mojom_TrustTokenParams,
  TrustTokenParamsSpec as network_mojom_TrustTokenParamsSpec
} from '../../../../../services/network/public/mojom/trust_tokens.mojom.m.js';

import {
  URLRequestRedirectInfo as network_mojom_URLRequestRedirectInfo,
  URLRequestRedirectInfoSpec as network_mojom_URLRequestRedirectInfoSpec
} from '../../../../../services/network/public/mojom/url_loader.mojom.m.js';

import {
  URLRequestBody as network_mojom_URLRequestBody,
  URLRequestBodySpec as network_mojom_URLRequestBodySpec
} from '../../../../../services/network/public/mojom/url_request.mojom.m.js';

import {
  NavigationDeliveryType as network_mojom_NavigationDeliveryType,
  NavigationDeliveryTypeSpec as network_mojom_NavigationDeliveryTypeSpec,
  URLResponseHead as network_mojom_URLResponseHead,
  URLResponseHeadSpec as network_mojom_URLResponseHeadSpec
} from '../../../../../services/network/public/mojom/url_response_head.mojom.m.js';

import {
  WebClientHintsType as network_mojom_WebClientHintsType,
  WebClientHintsTypeSpec as network_mojom_WebClientHintsTypeSpec
} from '../../../../../services/network/public/mojom/web_client_hints_types.mojom.m.js';

import {
  LocalSurfaceId as viz_mojom_LocalSurfaceId,
  LocalSurfaceIdSpec as viz_mojom_LocalSurfaceIdSpec
} from '../../../../../services/viz/public/mojom/compositing/local_surface_id.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BackForwardCacheNotRestoredReasons as blink_mojom_BackForwardCacheNotRestoredReasons,
  BackForwardCacheNotRestoredReasonsSpec as blink_mojom_BackForwardCacheNotRestoredReasonsSpec
} from '../back_forward_cache_not_restored_reasons.mojom.m.js';

import {
  Impression as blink_mojom_Impression,
  ImpressionSpec as blink_mojom_ImpressionSpec
} from '../conversions/conversions.mojom.m.js';

import {
  FencedFrameProperties as blink_mojom_FencedFrameProperties,
  FencedFramePropertiesSpec as blink_mojom_FencedFramePropertiesSpec
} from '../fenced_frame/fenced_frame_config.mojom.m.js';

import {
  RequestContextType as blink_mojom_RequestContextType,
  RequestContextTypeSpec as blink_mojom_RequestContextTypeSpec
} from '../fetch/fetch_api_request.mojom.m.js';

import {
  FramePolicy as blink_mojom_FramePolicy,
  FramePolicySpec as blink_mojom_FramePolicySpec
} from '../frame/frame_policy.mojom.m.js';

import {
  ViewTransitionState as blink_mojom_ViewTransitionState,
  ViewTransitionStateSpec as blink_mojom_ViewTransitionStateSpec
} from '../frame/view_transition_state.mojom.m.js';

import {
  LCPCriticalPathPredictorNavigationTimeHint as blink_mojom_LCPCriticalPathPredictorNavigationTimeHint,
  LCPCriticalPathPredictorNavigationTimeHintSpec as blink_mojom_LCPCriticalPathPredictorNavigationTimeHintSpec
} from '../lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.m.js';

import {
  MixedContentContextType as blink_mojom_MixedContentContextType,
  MixedContentContextTypeSpec as blink_mojom_MixedContentContextTypeSpec
} from '../loader/mixed_content.mojom.m.js';

import {
  Referrer as blink_mojom_Referrer,
  ReferrerSpec as blink_mojom_ReferrerSpec
} from '../loader/referrer.mojom.m.js';

import {
  TaskAttributionId as blink_mojom_TaskAttributionId,
  TaskAttributionIdSpec as blink_mojom_TaskAttributionIdSpec
} from '../messaging/task_attribution_id.mojom.m.js';

import {
  PageLifecycleState as blink_mojom_PageLifecycleState,
  PageLifecycleStateSpec as blink_mojom_PageLifecycleStateSpec
} from '../page/page.mojom.m.js';

import {
  PermissionName as blink_mojom_PermissionName,
  PermissionNameSpec as blink_mojom_PermissionNameSpec
} from '../permissions/permission.mojom.m.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from '../permissions/permission_status.mojom.m.js';

import {
  RuntimeFeature as blink_mojom_RuntimeFeature,
  RuntimeFeatureSpec as blink_mojom_RuntimeFeatureSpec
} from '../runtime_feature_state/runtime_feature.mojom.m.js';

import {
  StorageKey as blink_mojom_StorageKey,
  StorageKeySpec as blink_mojom_StorageKeySpec
} from '../storage_key/storage_key.mojom.m.js';

import {
  LocalFrameToken as blink_mojom_LocalFrameToken,
  LocalFrameTokenSpec as blink_mojom_LocalFrameTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  NavigationApiHistoryEntryArrays as blink_mojom_NavigationApiHistoryEntryArrays,
  NavigationApiHistoryEntryArraysSpec as blink_mojom_NavigationApiHistoryEntryArraysSpec
} from './navigation_api_history_entry_arrays.mojom.m.js';

import {
  NavigationInitiatorActivationAndAdStatus as blink_mojom_NavigationInitiatorActivationAndAdStatus,
  NavigationInitiatorActivationAndAdStatusSpec as blink_mojom_NavigationInitiatorActivationAndAdStatusSpec
} from './navigation_initiator_activation_and_ad_status.mojom.m.js';

import {
  NavigationDownloadPolicy as blink_mojom_NavigationDownloadPolicy,
  NavigationDownloadPolicySpec as blink_mojom_NavigationDownloadPolicySpec
} from './navigation_policy.mojom.m.js';

import {
  PrefetchedSignedExchangeInfo as blink_mojom_PrefetchedSignedExchangeInfo,
  PrefetchedSignedExchangeInfoSpec as blink_mojom_PrefetchedSignedExchangeInfoSpec
} from './prefetched_signed_exchange_info.mojom.m.js';

import {
  RendererContentSettings as blink_mojom_RendererContentSettings,
  RendererContentSettingsSpec as blink_mojom_RendererContentSettingsSpec
} from './renderer_content_settings.mojom.m.js';

import {
  SystemEntropy as blink_mojom_SystemEntropy,
  SystemEntropySpec as blink_mojom_SystemEntropySpec
} from './system_entropy.mojom.m.js';

import {
  WasActivatedOption as blink_mojom_WasActivatedOption,
  WasActivatedOptionSpec as blink_mojom_WasActivatedOptionSpec
} from './was_activated_option.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NavigationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NavigationType = {
  
  RELOAD: 0,
  RELOAD_BYPASSING_CACHE: 1,
  RESTORE: 2,
  RESTORE_WITH_POST: 3,
  HISTORY_SAME_DOCUMENT: 4,
  HISTORY_DIFFERENT_DOCUMENT: 5,
  SAME_DOCUMENT: 6,
  DIFFERENT_DOCUMENT: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NavigationTypeForNavigationApiSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NavigationTypeForNavigationApi = {
  
  kPush: 0,
  kTraverse: 1,
  kReplace: 2,
  kReload: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ForceHistoryPushSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ForceHistoryPush = {
  
  kYes: 0,
  kNo: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ParentResourceTimingAccessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ParentResourceTimingAccess = {
  
  kDoNotReport: 0,
  kReportWithoutResponseDetails: 1,
  kReportWithResponseDetails: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BeginNavigationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CommonNavigationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NavigationTimingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OldPageInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CommitNavigationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageSwapEventParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BeginNavigationParamsSpec.$,
    'BeginNavigationParams',
    [
      mojo.internal.StructField(
        'initiatorFrameToken', 0,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadFlags', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'skipServiceWorker', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestContextType', 24,
        0,
        blink_mojom_RequestContextTypeSpec.$,
        blink_mojom_RequestContextType.UNSPECIFIED,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mixedContentContextType', 28,
        0,
        blink_mojom_MixedContentContextTypeSpec.$,
        blink_mojom_MixedContentContextType.kNotMixedContent,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFormSubmission', 20,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasInitiatedByLinkClick', 20,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceHistoryPush', 32,
        0,
        ForceHistoryPushSpec.$,
        ForceHistoryPush.kNo,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'searchableFormUrl', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'searchableFormEncoding', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSideRedirectUrl', 56,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsInitiator', 64,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 72,
        0,
        network_mojom_TrustTokenParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'impression', 80,
        0,
        blink_mojom_ImpressionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'beforeUnloadStart', 88,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'beforeUnloadEnd', 96,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorActivationAndAdStatus', 36,
        0,
        blink_mojom_NavigationInitiatorActivationAndAdStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isContainerInitiated', 20,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 104,
        0,
        network_mojom_StorageAccessApiStatusSpec.$,
        network_mojom_StorageAccessApiStatus.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRelOpener', 20,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 120],]);



/**
 * @record
 */
export class BeginNavigationParams {
  constructor() {
    /** @type { (blink_mojom_LocalFrameToken|undefined) } */
    this.initiatorFrameToken;
    /** @type { !string } */
    this.headers;
    /** @type { !number } */
    this.loadFlags;
    /** @type { !boolean } */
    this.skipServiceWorker;
    /** @type { !blink_mojom_RequestContextType } */
    this.requestContextType;
    /** @type { !blink_mojom_MixedContentContextType } */
    this.mixedContentContextType;
    /** @type { !boolean } */
    this.isFormSubmission;
    /** @type { !boolean } */
    this.wasInitiatedByLinkClick;
    /** @type { !ForceHistoryPush } */
    this.forceHistoryPush;
    /** @type { !url_mojom_Url } */
    this.searchableFormUrl;
    /** @type { !string } */
    this.searchableFormEncoding;
    /** @type { !url_mojom_Url } */
    this.clientSideRedirectUrl;
    /** @type { (mojoBase_mojom_DictionaryValue|undefined) } */
    this.devtoolsInitiator;
    /** @type { (network_mojom_TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @type { (blink_mojom_Impression|undefined) } */
    this.impression;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.beforeUnloadStart;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.beforeUnloadEnd;
    /** @type { !blink_mojom_NavigationInitiatorActivationAndAdStatus } */
    this.initiatorActivationAndAdStatus;
    /** @type { !boolean } */
    this.isContainerInitiated;
    /** @type { !network_mojom_StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @type { !boolean } */
    this.hasRelOpener;
  }
}



mojo.internal.Struct(
    CommonNavigationParamsSpec.$,
    'CommonNavigationParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorBaseUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 24,
        0,
        blink_mojom_ReferrerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transition', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationType', 36,
        0,
        NavigationTypeSpec.$,
        NavigationType.DIFFERENT_DOCUMENT,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloadPolicy', 40,
        0,
        blink_mojom_NavigationDownloadPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldReplaceCurrentEntry', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'baseUrlForDataUrl', 56,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'actualNavigationStart', 64,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStart', 72,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 80,
        0,
        mojo.internal.String,
        "GET",
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'postData', 88,
        0,
        network_mojom_URLRequestBodySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceLocation', 96,
        0,
        network_mojom_SourceLocationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startedFromContextMenu', 48,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 48,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textFragmentToken', 48,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldCheckMainWorldCsp', 52,
        0,
        network_mojom_CSPDispositionSpec.$,
        network_mojom_CSPDisposition.CHECK,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorOriginTrialFeatures', 104,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hrefTranslate', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isHistoryNavigationInNewChildFrame', 48,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputStart', 120,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestDestination', 128,
        0,
        network_mojom_RequestDestinationSpec.$,
        network_mojom_RequestDestination.kEmpty,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 144],]);



/**
 * @record
 */
export class CommonNavigationParams {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { (url_mojom_Origin|undefined) } */
    this.initiatorOrigin;
    /** @type { (url_mojom_Url|undefined) } */
    this.initiatorBaseUrl;
    /** @type { !blink_mojom_Referrer } */
    this.referrer;
    /** @type { !number } */
    this.transition;
    /** @type { !NavigationType } */
    this.navigationType;
    /** @type { !blink_mojom_NavigationDownloadPolicy } */
    this.downloadPolicy;
    /** @type { !boolean } */
    this.shouldReplaceCurrentEntry;
    /** @type { !url_mojom_Url } */
    this.baseUrlForDataUrl;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.actualNavigationStart;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.navigationStart;
    /** @type { !string } */
    this.method;
    /** @type { (network_mojom_URLRequestBody|undefined) } */
    this.postData;
    /** @type { !network_mojom_SourceLocation } */
    this.sourceLocation;
    /** @type { !boolean } */
    this.startedFromContextMenu;
    /** @type { !boolean } */
    this.hasUserGesture;
    /** @type { !boolean } */
    this.textFragmentToken;
    /** @type { !network_mojom_CSPDisposition } */
    this.shouldCheckMainWorldCsp;
    /** @type { !Array<!number> } */
    this.initiatorOriginTrialFeatures;
    /** @type { !string } */
    this.hrefTranslate;
    /** @type { !boolean } */
    this.isHistoryNavigationInNewChildFrame;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.inputStart;
    /** @type { !network_mojom_RequestDestination } */
    this.requestDestination;
  }
}



mojo.internal.Struct(
    NavigationTimingSpec.$,
    'NavigationTiming',
    [
      mojo.internal.StructField(
        'redirectStart', 0,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectEnd', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchStart', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'systemEntropyAtNavigationStart', 24,
        0,
        blink_mojom_SystemEntropySpec.$,
        blink_mojom_SystemEntropy.kEmpty,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parentResourceTimingAccess', 28,
        0,
        ParentResourceTimingAccessSpec.$,
        ParentResourceTimingAccess.kDoNotReport,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NavigationTiming {
  constructor() {
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.redirectStart;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.redirectEnd;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.fetchStart;
    /** @type { !blink_mojom_SystemEntropy } */
    this.systemEntropyAtNavigationStart;
    /** @type { !ParentResourceTimingAccess } */
    this.parentResourceTimingAccess;
  }
}



mojo.internal.Struct(
    OldPageInfoSpec.$,
    'OldPageInfo',
    [
      mojo.internal.StructField(
        'frameTokenForOldMainFrame', 0,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newLifecycleStateForOldPage', 8,
        0,
        blink_mojom_PageLifecycleStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OldPageInfo {
  constructor() {
    /** @type { !blink_mojom_LocalFrameToken } */
    this.frameTokenForOldMainFrame;
    /** @type { !blink_mojom_PageLifecycleState } */
    this.newLifecycleStateForOldPage;
  }
}



mojo.internal.Struct(
    CommitNavigationParamsSpec.$,
    'CommitNavigationParams',
    [
      mojo.internal.StructField(
        'originToCommit', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageKey', 8,
        0,
        blink_mojom_StorageKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isOverridingUserAgent', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirects', 24,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectResponse', 32,
        0,
        mojo.internal.Array(network_mojom_URLResponseHeadSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectInfos', 40,
        0,
        mojo.internal.Array(network_mojom_URLRequestRedirectInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'postContentType', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalUrl', 56,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalMethod', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canLoadLocalResources', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageState', 72,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navEntryId', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subframeUniqueNames', 80,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Bool, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'intendedAsNewEntry', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingHistoryListIndex', 88,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentHistoryListIndex', 92,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentHistoryListLength', 96,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasDiscarded', 16,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isViewSource', 16,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldClearHistoryList', 16,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationTiming', 104,
        0,
        NavigationTimingSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasActivated', 100,
        0,
        blink_mojom_WasActivatedOptionSpec.$,
        blink_mojom_WasActivatedOption.kUnknown,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationToken', 112,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prefetchedSignedExchanges', 120,
        0,
        mojo.internal.Array(blink_mojom_PrefetchedSignedExchangeInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isBrowserInitiated', 16,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasUaVisualTransition', 16,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentUkmSourceId', 128,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framePolicy', 136,
        0,
        blink_mojom_FramePolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceEnabledOriginTrials', 144,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originAgentCluster', 17,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originAgentClusterLeftAsDefault', 17,
        1,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enabledClientHints', 152,
        0,
        mojo.internal.Array(network_mojom_WebClientHintsTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isCrossSiteCrossBrowsingContextGroup', 17,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldHaveStickyUserActivation', 17,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'oldPageInfo', 160,
        0,
        OldPageInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpResponseCode', 168,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationApiHistoryEntryArrays', 176,
        0,
        blink_mojom_NavigationApiHistoryEntryArraysSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'earlyHintsPreloadedResources', 184,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'commitSent', 192,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcdocValue', 200,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isLoadDataWithBaseUrl', 17,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ancestorOrSelfHasCspee', 17,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reducedAcceptLanguage', 208,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationDeliveryType', 172,
        0,
        network_mojom_NavigationDeliveryTypeSpec.$,
        network_mojom_NavigationDeliveryType.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewTransitionState', 216,
        0,
        blink_mojom_ViewTransitionStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'softNavigationHeuristicsTaskId', 224,
        0,
        blink_mojom_TaskAttributionIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiedRuntimeFeatures', 232,
        0,
        mojo.internal.Map(blink_mojom_RuntimeFeatureSpec.$, mojo.internal.Bool, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fencedFrameProperties', 240,
        0,
        blink_mojom_FencedFramePropertiesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notRestoredReasons', 248,
        0,
        blink_mojom_BackForwardCacheNotRestoredReasonsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadWithStorageAccess', 256,
        0,
        network_mojom_StorageAccessApiStatusSpec.$,
        network_mojom_StorageAccessApiStatus.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browsingContextGroupToken', 264,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lcppHint', 272,
        0,
        blink_mojom_LCPCriticalPathPredictorNavigationTimeHintSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentSettings', 280,
        0,
        blink_mojom_RendererContentSettingsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieDeprecationLabel', 288,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visited_link_salt_$flag', 17,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "visited_link_salt_$value",
          originalFieldName: "visitedLinkSalt",
        }
      ),
      mojo.internal.StructField(
        'visited_link_salt_$value', 296,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "visitedLinkSalt",
        }
      ),
      mojo.internal.StructField(
        'localSurfaceId', 304,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialPermissionStatuses', 312,
        0,
        mojo.internal.Map(blink_mojom_PermissionNameSpec.$, blink_mojom_PermissionStatusSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldSkipScreenshot', 17,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceNewDocumentSequenceNumber', 18,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationMetricsToken', 320,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 336],]);



/**
 * @record
 */
export class CommitNavigationParams {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.originToCommit;
    /** @type { !blink_mojom_StorageKey } */
    this.storageKey;
    /** @type { !boolean } */
    this.isOverridingUserAgent;
    /** @type { !Array<!url_mojom_Url> } */
    this.redirects;
    /** @type { !Array<!network_mojom_URLResponseHead> } */
    this.redirectResponse;
    /** @type { !Array<!network_mojom_URLRequestRedirectInfo> } */
    this.redirectInfos;
    /** @type { !string } */
    this.postContentType;
    /** @type { !url_mojom_Url } */
    this.originalUrl;
    /** @type { !string } */
    this.originalMethod;
    /** @type { !boolean } */
    this.canLoadLocalResources;
    /** @type { !mojoBase_mojom_ByteString } */
    this.pageState;
    /** @type { !number } */
    this.navEntryId;
    /** @type { !Object<!string, !boolean> } */
    this.subframeUniqueNames;
    /** @type { !boolean } */
    this.intendedAsNewEntry;
    /** @type { !number } */
    this.pendingHistoryListIndex;
    /** @type { !number } */
    this.currentHistoryListIndex;
    /** @type { !number } */
    this.currentHistoryListLength;
    /** @type { !boolean } */
    this.wasDiscarded;
    /** @type { !boolean } */
    this.isViewSource;
    /** @type { !boolean } */
    this.shouldClearHistoryList;
    /** @type { !NavigationTiming } */
    this.navigationTiming;
    /** @type { !blink_mojom_WasActivatedOption } */
    this.wasActivated;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.navigationToken;
    /** @type { !Array<!blink_mojom_PrefetchedSignedExchangeInfo> } */
    this.prefetchedSignedExchanges;
    /** @type { !boolean } */
    this.isBrowserInitiated;
    /** @type { !boolean } */
    this.hasUaVisualTransition;
    /** @type { !bigint } */
    this.documentUkmSourceId;
    /** @type { !blink_mojom_FramePolicy } */
    this.framePolicy;
    /** @type { !Array<!string> } */
    this.forceEnabledOriginTrials;
    /** @type { !boolean } */
    this.originAgentCluster;
    /** @type { !boolean } */
    this.originAgentClusterLeftAsDefault;
    /** @type { !Array<!network_mojom_WebClientHintsType> } */
    this.enabledClientHints;
    /** @type { !boolean } */
    this.isCrossSiteCrossBrowsingContextGroup;
    /** @type { !boolean } */
    this.shouldHaveStickyUserActivation;
    /** @type { (OldPageInfo|undefined) } */
    this.oldPageInfo;
    /** @type { !number } */
    this.httpResponseCode;
    /** @type { !blink_mojom_NavigationApiHistoryEntryArrays } */
    this.navigationApiHistoryEntryArrays;
    /** @type { !Array<!url_mojom_Url> } */
    this.earlyHintsPreloadedResources;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.commitSent;
    /** @type { !string } */
    this.srcdocValue;
    /** @type { !boolean } */
    this.isLoadDataWithBaseUrl;
    /** @type { !boolean } */
    this.ancestorOrSelfHasCspee;
    /** @type { !string } */
    this.reducedAcceptLanguage;
    /** @type { !network_mojom_NavigationDeliveryType } */
    this.navigationDeliveryType;
    /** @type { (blink_mojom_ViewTransitionState|undefined) } */
    this.viewTransitionState;
    /** @type { (blink_mojom_TaskAttributionId|undefined) } */
    this.softNavigationHeuristicsTaskId;
    /** @type { !Object<!blink_mojom_RuntimeFeature, !boolean> } */
    this.modifiedRuntimeFeatures;
    /** @type { (blink_mojom_FencedFrameProperties|undefined) } */
    this.fencedFrameProperties;
    /** @type { (blink_mojom_BackForwardCacheNotRestoredReasons|undefined) } */
    this.notRestoredReasons;
    /** @type { !network_mojom_StorageAccessApiStatus } */
    this.loadWithStorageAccess;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.browsingContextGroupToken;
    /** @type { (blink_mojom_LCPCriticalPathPredictorNavigationTimeHint|undefined) } */
    this.lcppHint;
    /** @type { !blink_mojom_RendererContentSettings } */
    this.contentSettings;
    /** @type { (string|undefined) } */
    this.cookieDeprecationLabel;
    /** @type { (bigint|undefined) } */
    this.visitedLinkSalt;
    /** @type { (viz_mojom_LocalSurfaceId|undefined) } */
    this.localSurfaceId;
    /** @type { (Object<!blink_mojom_PermissionName, !blink_mojom_PermissionStatus>|undefined) } */
    this.initialPermissionStatuses;
    /** @type { !boolean } */
    this.shouldSkipScreenshot;
    /** @type { !boolean } */
    this.forceNewDocumentSequenceNumber;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.navigationMetricsToken;
  }
}



mojo.internal.Struct(
    PageSwapEventParamsSpec.$,
    'PageSwapEventParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageState', 8,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationType', 16,
        0,
        NavigationTypeForNavigationApiSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PageSwapEventParams {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_ByteString } */
    this.pageState;
    /** @type { !NavigationTypeForNavigationApi } */
    this.navigationType;
  }
}

