// third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OomInterventionHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.OomInterventionHost', scope);
  }
}

/** @interface */
export class OomInterventionHostInterface {
  
  /**
   */

  onHighMemoryUsage() {}
}

/**
 * @implements { OomInterventionHostInterface }
 */
export class OomInterventionHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OomInterventionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OomInterventionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OomInterventionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onHighMemoryUsage() {
    this.proxy.sendMessage(
        0,
        OomInterventionHost_OnHighMemoryUsage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OomInterventionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OomInterventionHostReceiver {
  /**
   * @param {!OomInterventionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OomInterventionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OomInterventionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OomInterventionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OomInterventionHost_OnHighMemoryUsage_ParamsSpec.$,
        null,
        impl.onHighMemoryUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OomInterventionHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.OomInterventionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OomInterventionHostRemote}
   */
  static getRemote() {
    let remote = new OomInterventionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OomInterventionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OomInterventionHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OomInterventionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OomInterventionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHighMemoryUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OomInterventionHost_OnHighMemoryUsage_ParamsSpec.$,
        null,
        this.onHighMemoryUsage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OomInterventionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.OomIntervention', scope);
  }
}

/** @interface */
export class OomInterventionInterface {
  
  /**
   * @param { !OomInterventionHostRemote } host
   * @param { !DetectionArgs } detectionArgs
   * @param { !boolean } rendererPauseEnabled
   * @param { !boolean } navigateAdsEnabled
   * @param { !boolean } purgeV8MemoryEnabled
   */

  startDetection(host, detectionArgs, rendererPauseEnabled, navigateAdsEnabled, purgeV8MemoryEnabled) {}
}

/**
 * @implements { OomInterventionInterface }
 */
export class OomInterventionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OomInterventionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OomInterventionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OomInterventionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !OomInterventionHostRemote } host
   * @param { !DetectionArgs } detectionArgs
   * @param { !boolean } rendererPauseEnabled
   * @param { !boolean } navigateAdsEnabled
   * @param { !boolean } purgeV8MemoryEnabled
   */

  startDetection(
      host,
      detectionArgs,
      rendererPauseEnabled,
      navigateAdsEnabled,
      purgeV8MemoryEnabled) {
    this.proxy.sendMessage(
        0,
        OomIntervention_StartDetection_ParamsSpec.$,
        null,
        [
          host,
          detectionArgs,
          rendererPauseEnabled,
          navigateAdsEnabled,
          purgeV8MemoryEnabled
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OomIntervention
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OomInterventionReceiver {
  /**
   * @param {!OomInterventionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OomInterventionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OomInterventionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OomInterventionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OomIntervention_StartDetection_ParamsSpec.$,
        null,
        impl.startDetection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OomIntervention {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.OomIntervention";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OomInterventionRemote}
   */
  static getRemote() {
    let remote = new OomInterventionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OomIntervention
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OomInterventionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OomInterventionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OomInterventionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDetection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OomIntervention_StartDetection_ParamsSpec.$,
        null,
        this.startDetection.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DetectionArgsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OomInterventionHost_OnHighMemoryUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OomIntervention_StartDetection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DetectionArgsSpec.$,
    'DetectionArgs',
    [
      mojo.internal.StructField(
        'privateFootprintThreshold', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DetectionArgs {
  constructor() {
    /** @type { !bigint } */
    this.privateFootprintThreshold;
  }
}



mojo.internal.Struct(
    OomInterventionHost_OnHighMemoryUsage_ParamsSpec.$,
    'OomInterventionHost_OnHighMemoryUsage_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class OomInterventionHost_OnHighMemoryUsage_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    OomIntervention_StartDetection_ParamsSpec.$,
    'OomIntervention_StartDetection_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.InterfaceProxy(OomInterventionHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'detectionArgs', 8,
        0,
        DetectionArgsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rendererPauseEnabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigateAdsEnabled', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'purgeV8MemoryEnabled', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class OomIntervention_StartDetection_Params {
  constructor() {
    /** @type { !OomInterventionHostRemote } */
    this.host;
    /** @type { !DetectionArgs } */
    this.detectionArgs;
    /** @type { !boolean } */
    this.rendererPauseEnabled;
    /** @type { !boolean } */
    this.navigateAdsEnabled;
    /** @type { !boolean } */
    this.purgeV8MemoryEnabled;
  }
}

