// third_party/blink/public/mojom/page/page.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  AttributionSupport as network_mojom_AttributionSupport,
  AttributionSupportSpec as network_mojom_AttributionSupportSpec
} from '../../../../../services/network/public/mojom/attribution.mojom.m.js';

import {
  SkColor as skia_mojom_SkColor,
  SkColorSpec as skia_mojom_SkColorSpec
} from '../../../../../skia/public/mojom/skcolor.mojom.m.js';

import {
  RendererColorId as color_mojom_RendererColorId,
  RendererColorIdSpec as color_mojom_RendererColorIdSpec
} from '../../../../../ui/color/color_id.mojom.m.js';

import {
  NoiseToken as blink_mojom_NoiseToken,
  NoiseTokenSpec as blink_mojom_NoiseTokenSpec
} from '../fingerprinting_protection/noise_token.mojom.m.js';

import {
  FrameReplicationState as blink_mojom_FrameReplicationState,
  FrameReplicationStateSpec as blink_mojom_FrameReplicationStateSpec
} from '../frame/frame_replication_state.mojom.m.js';

import {
  RemoteFrameInterfacesFromBrowser as blink_mojom_RemoteFrameInterfacesFromBrowser,
  RemoteFrameInterfacesFromBrowserSpec as blink_mojom_RemoteFrameInterfacesFromBrowserSpec,
  RemoteMainFrameInterfaces as blink_mojom_RemoteMainFrameInterfaces,
  RemoteMainFrameInterfacesSpec as blink_mojom_RemoteMainFrameInterfacesSpec
} from '../frame/remote_frame.mojom.m.js';

import {
  ViewTransitionState as blink_mojom_ViewTransitionState,
  ViewTransitionStateSpec as blink_mojom_ViewTransitionStateSpec
} from '../frame/view_transition_state.mojom.m.js';

import {
  WasActivatedOption as blink_mojom_WasActivatedOption,
  WasActivatedOptionSpec as blink_mojom_WasActivatedOptionSpec
} from '../navigation/was_activated_option.mojom.m.js';

import {
  RendererPreferences as blink_mojom_RendererPreferences,
  RendererPreferencesSpec as blink_mojom_RendererPreferencesSpec
} from '../renderer_preferences.mojom.m.js';

import {
  RemoteFrameToken as blink_mojom_RemoteFrameToken,
  RemoteFrameTokenSpec as blink_mojom_RemoteFrameTokenSpec,
  FrameToken as blink_mojom_FrameToken,
  FrameTokenSpec as blink_mojom_FrameTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  WebPreferences as blink_mojom_WebPreferences,
  WebPreferencesSpec as blink_mojom_WebPreferencesSpec
} from '../webpreferences/web_preferences.mojom.m.js';

import {
  PageVisibilityState as blink_mojom_PageVisibilityState,
  PageVisibilityStateSpec as blink_mojom_PageVisibilityStateSpec
} from './page_visibility_state.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PagehideDispatchSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PagehideDispatch = {
  
  kNotDispatched: 0,
  kDispatchedNotPersisted: 1,
  kDispatchedPersisted: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PageBroadcastPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PageBroadcast', scope);
  }
}

/** @interface */
export class PageBroadcastInterface {
  
  /**
   * @param { !PageLifecycleState } state
   * @param { ?PageRestoreParams } pageRestoreParams
   * @return {!Promise}
   */

  setPageLifecycleState(state, pageRestoreParams) {}
  
  /**
   * @param { !boolean } isAudioPlaying
   */

  audioStateChanged(isAudioPlaying) {}
  
  /**
   * @param { !PrerenderPageActivationParams } prerenderPageActivationParams
   * @return {!Promise}
   */

  activatePrerenderedPage(prerenderPageActivationParams) {}
  
  /**
   * @param { !blink_mojom_WebPreferences } preferences
   */

  updateWebPreferences(preferences) {}
  
  /**
   * @param { !blink_mojom_RendererPreferences } preferences
   */

  updateRendererPreferences(preferences) {}
  
  /**
   * @param { !number } index
   * @param { !number } length
   */

  setHistoryIndexAndLength(index, length) {}
  
  /**
   * @param { ?skia_mojom_SkColor } color
   */

  setPageBaseBackgroundColor(color) {}
  
  /**
   * @param { !blink_mojom_RemoteFrameToken } token
   * @param { ?blink_mojom_FrameToken } openerFrameToken
   * @param { !blink_mojom_FrameReplicationState } replicationState
   * @param { !boolean } isLoading
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsFrameToken
   * @param { ?mojoBase_mojom_UnguessableToken } navigationMetricsToken
   * @param { !blink_mojom_RemoteFrameInterfacesFromBrowser } remoteFrameInterfaces
   * @param { !blink_mojom_RemoteMainFrameInterfaces } remoteMainFrameInterfaces
   */

  createRemoteMainFrame(token, openerFrameToken, replicationState, isLoading, devtoolsFrameToken, navigationMetricsToken, remoteFrameInterfaces, remoteMainFrameInterfaces) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } browsingContextGroupToken
   */

  updatePageBrowsingContextGroup(browsingContextGroupToken) {}
  
  /**
   * @param { !network_mojom_AttributionSupport } support
   */

  setPageAttributionSupport(support) {}
  
  /**
   * @param { !ColorProviderColorMaps } colorProviderColors
   */

  updateColorProviders(colorProviderColors) {}
  
  /**
   * @param { ?blink_mojom_NoiseToken } canvasNoiseToken
   */

  updateCanvasNoiseToken(canvasNoiseToken) {}
  
  /**
   * @param { !boolean } supportsDraggableRegions
   */

  setSupportsDraggableRegions(supportsDraggableRegions) {}
}

/**
 * @implements { PageBroadcastInterface }
 */
export class PageBroadcastRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PageBroadcastPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageBroadcastPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PageBroadcastPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PageLifecycleState } state
   * @param { ?PageRestoreParams } pageRestoreParams
   * @return {!Promise}
   */

  setPageLifecycleState(
      state,
      pageRestoreParams) {
    return this.proxy.sendMessage(
        0,
        PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
        PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
        [
          state,
          pageRestoreParams
        ],
        false);
  }

  
  /**
   * @param { !boolean } isAudioPlaying
   */

  audioStateChanged(
      isAudioPlaying) {
    this.proxy.sendMessage(
        1,
        PageBroadcast_AudioStateChanged_ParamsSpec.$,
        null,
        [
          isAudioPlaying
        ],
        false);
  }

  
  /**
   * @param { !PrerenderPageActivationParams } prerenderPageActivationParams
   * @return {!Promise}
   */

  activatePrerenderedPage(
      prerenderPageActivationParams) {
    return this.proxy.sendMessage(
        2,
        PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
        PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
        [
          prerenderPageActivationParams
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_WebPreferences } preferences
   */

  updateWebPreferences(
      preferences) {
    this.proxy.sendMessage(
        3,
        PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
        null,
        [
          preferences
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_RendererPreferences } preferences
   */

  updateRendererPreferences(
      preferences) {
    this.proxy.sendMessage(
        4,
        PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
        null,
        [
          preferences
        ],
        false);
  }

  
  /**
   * @param { !number } index
   * @param { !number } length
   */

  setHistoryIndexAndLength(
      index,
      length) {
    this.proxy.sendMessage(
        5,
        PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
        null,
        [
          index,
          length
        ],
        false);
  }

  
  /**
   * @param { ?skia_mojom_SkColor } color
   */

  setPageBaseBackgroundColor(
      color) {
    this.proxy.sendMessage(
        6,
        PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
        null,
        [
          color
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_RemoteFrameToken } token
   * @param { ?blink_mojom_FrameToken } openerFrameToken
   * @param { !blink_mojom_FrameReplicationState } replicationState
   * @param { !boolean } isLoading
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsFrameToken
   * @param { ?mojoBase_mojom_UnguessableToken } navigationMetricsToken
   * @param { !blink_mojom_RemoteFrameInterfacesFromBrowser } remoteFrameInterfaces
   * @param { !blink_mojom_RemoteMainFrameInterfaces } remoteMainFrameInterfaces
   */

  createRemoteMainFrame(
      token,
      openerFrameToken,
      replicationState,
      isLoading,
      devtoolsFrameToken,
      navigationMetricsToken,
      remoteFrameInterfaces,
      remoteMainFrameInterfaces) {
    this.proxy.sendMessage(
        7,
        PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
        null,
        [
          token,
          openerFrameToken,
          replicationState,
          isLoading,
          devtoolsFrameToken,
          navigationMetricsToken,
          remoteFrameInterfaces,
          remoteMainFrameInterfaces
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } browsingContextGroupToken
   */

  updatePageBrowsingContextGroup(
      browsingContextGroupToken) {
    this.proxy.sendMessage(
        8,
        PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
        null,
        [
          browsingContextGroupToken
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_AttributionSupport } support
   */

  setPageAttributionSupport(
      support) {
    this.proxy.sendMessage(
        9,
        PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
        null,
        [
          support
        ],
        false);
  }

  
  /**
   * @param { !ColorProviderColorMaps } colorProviderColors
   */

  updateColorProviders(
      colorProviderColors) {
    this.proxy.sendMessage(
        10,
        PageBroadcast_UpdateColorProviders_ParamsSpec.$,
        null,
        [
          colorProviderColors
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_NoiseToken } canvasNoiseToken
   */

  updateCanvasNoiseToken(
      canvasNoiseToken) {
    this.proxy.sendMessage(
        11,
        PageBroadcast_UpdateCanvasNoiseToken_ParamsSpec.$,
        null,
        [
          canvasNoiseToken
        ],
        false);
  }

  
  /**
   * @param { !boolean } supportsDraggableRegions
   */

  setSupportsDraggableRegions(
      supportsDraggableRegions) {
    this.proxy.sendMessage(
        12,
        PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        [
          supportsDraggableRegions
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PageBroadcast
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageBroadcastReceiver {
  /**
   * @param {!PageBroadcastInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PageBroadcastRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageBroadcastRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PageBroadcastRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
        PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
        impl.setPageLifecycleState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageBroadcast_AudioStateChanged_ParamsSpec.$,
        null,
        impl.audioStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
        PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
        impl.activatePrerenderedPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
        null,
        impl.updateWebPreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
        null,
        impl.updateRendererPreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
        null,
        impl.setHistoryIndexAndLength.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
        null,
        impl.setPageBaseBackgroundColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
        null,
        impl.createRemoteMainFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
        null,
        impl.updatePageBrowsingContextGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
        null,
        impl.setPageAttributionSupport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageBroadcast_UpdateColorProviders_ParamsSpec.$,
        null,
        impl.updateColorProviders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageBroadcast_UpdateCanvasNoiseToken_ParamsSpec.$,
        null,
        impl.updateCanvasNoiseToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        impl.setSupportsDraggableRegions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageBroadcast {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PageBroadcast";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PageBroadcastRemote}
   */
  static getRemote() {
    let remote = new PageBroadcastRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PageBroadcast
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageBroadcastCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageBroadcastRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PageBroadcastRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageLifecycleState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
        PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
        this.setPageLifecycleState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageBroadcast_AudioStateChanged_ParamsSpec.$,
        null,
        this.audioStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activatePrerenderedPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
        PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
        this.activatePrerenderedPage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateWebPreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
        null,
        this.updateWebPreferences.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRendererPreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
        null,
        this.updateRendererPreferences.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHistoryIndexAndLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
        null,
        this.setHistoryIndexAndLength.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageBaseBackgroundColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
        null,
        this.setPageBaseBackgroundColor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRemoteMainFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
        null,
        this.createRemoteMainFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePageBrowsingContextGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
        null,
        this.updatePageBrowsingContextGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageAttributionSupport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
        null,
        this.setPageAttributionSupport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateColorProviders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageBroadcast_UpdateColorProviders_ParamsSpec.$,
        null,
        this.updateColorProviders.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCanvasNoiseToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageBroadcast_UpdateCanvasNoiseToken_ParamsSpec.$,
        null,
        this.updateCanvasNoiseToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSupportsDraggableRegions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        this.setSupportsDraggableRegions.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageLifecycleStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageRestoreParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ColorProviderColorMapsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrerenderPageActivationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_SetPageLifecycleState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_SetPageLifecycleState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_AudioStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_ActivatePrerenderedPage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_UpdateWebPreferences_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_UpdateRendererPreferences_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_SetHistoryIndexAndLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_CreateRemoteMainFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_SetPageAttributionSupport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_UpdateColorProviders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_UpdateCanvasNoiseToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageBroadcast_SetSupportsDraggableRegions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PageLifecycleStateSpec.$,
    'PageLifecycleState',
    [
      mojo.internal.StructField(
        'isFrozen', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibility', 4,
        0,
        blink_mojom_PageVisibilityStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isInBackForwardCache', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pagehideDispatch', 8,
        0,
        PagehideDispatchSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'evictionEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PageLifecycleState {
  constructor() {
    /** @type { !boolean } */
    this.isFrozen;
    /** @type { !blink_mojom_PageVisibilityState } */
    this.visibility;
    /** @type { !boolean } */
    this.isInBackForwardCache;
    /** @type { !PagehideDispatch } */
    this.pagehideDispatch;
    /** @type { !boolean } */
    this.evictionEnabled;
  }
}



mojo.internal.Struct(
    PageRestoreParamsSpec.$,
    'PageRestoreParams',
    [
      mojo.internal.StructField(
        'navigationStart', 0,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingHistoryListIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentHistoryListLength', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewTransitionState', 16,
        0,
        blink_mojom_ViewTransitionStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PageRestoreParams {
  constructor() {
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.navigationStart;
    /** @type { !number } */
    this.pendingHistoryListIndex;
    /** @type { !number } */
    this.currentHistoryListLength;
    /** @type { (blink_mojom_ViewTransitionState|undefined) } */
    this.viewTransitionState;
  }
}



mojo.internal.Struct(
    ColorProviderColorMapsSpec.$,
    'ColorProviderColorMaps',
    [
      mojo.internal.StructField(
        'lightColorsMap', 0,
        0,
        mojo.internal.Map(color_mojom_RendererColorIdSpec.$, skia_mojom_SkColorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'darkColorsMap', 8,
        0,
        mojo.internal.Map(color_mojom_RendererColorIdSpec.$, skia_mojom_SkColorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forcedColorsMap', 16,
        0,
        mojo.internal.Map(color_mojom_RendererColorIdSpec.$, skia_mojom_SkColorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ColorProviderColorMaps {
  constructor() {
    /** @type { !Object<!color_mojom_RendererColorId, !skia_mojom_SkColor> } */
    this.lightColorsMap;
    /** @type { !Object<!color_mojom_RendererColorId, !skia_mojom_SkColor> } */
    this.darkColorsMap;
    /** @type { !Object<!color_mojom_RendererColorId, !skia_mojom_SkColor> } */
    this.forcedColorsMap;
  }
}



mojo.internal.Struct(
    PrerenderPageActivationParamsSpec.$,
    'PrerenderPageActivationParams',
    [
      mojo.internal.StructField(
        'wasUserActivated', 0,
        0,
        blink_mojom_WasActivatedOptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activationStart', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewTransitionState', 16,
        0,
        blink_mojom_ViewTransitionStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PrerenderPageActivationParams {
  constructor() {
    /** @type { !blink_mojom_WasActivatedOption } */
    this.wasUserActivated;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.activationStart;
    /** @type { (blink_mojom_ViewTransitionState|undefined) } */
    this.viewTransitionState;
  }
}



mojo.internal.Struct(
    PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
    'PageBroadcast_SetPageLifecycleState_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        PageLifecycleStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageRestoreParams', 8,
        0,
        PageRestoreParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PageBroadcast_SetPageLifecycleState_Params {
  constructor() {
    /** @type { !PageLifecycleState } */
    this.state;
    /** @type { (PageRestoreParams|undefined) } */
    this.pageRestoreParams;
  }
}



mojo.internal.Struct(
    PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
    'PageBroadcast_SetPageLifecycleState_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageBroadcast_SetPageLifecycleState_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PageBroadcast_AudioStateChanged_ParamsSpec.$,
    'PageBroadcast_AudioStateChanged_Params',
    [
      mojo.internal.StructField(
        'isAudioPlaying', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_AudioStateChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.isAudioPlaying;
  }
}



mojo.internal.Struct(
    PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
    'PageBroadcast_ActivatePrerenderedPage_Params',
    [
      mojo.internal.StructField(
        'prerenderPageActivationParams', 0,
        0,
        PrerenderPageActivationParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_ActivatePrerenderedPage_Params {
  constructor() {
    /** @type { !PrerenderPageActivationParams } */
    this.prerenderPageActivationParams;
  }
}



mojo.internal.Struct(
    PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
    'PageBroadcast_ActivatePrerenderedPage_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageBroadcast_ActivatePrerenderedPage_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
    'PageBroadcast_UpdateWebPreferences_Params',
    [
      mojo.internal.StructField(
        'preferences', 0,
        0,
        blink_mojom_WebPreferencesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_UpdateWebPreferences_Params {
  constructor() {
    /** @type { !blink_mojom_WebPreferences } */
    this.preferences;
  }
}



mojo.internal.Struct(
    PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
    'PageBroadcast_UpdateRendererPreferences_Params',
    [
      mojo.internal.StructField(
        'preferences', 0,
        0,
        blink_mojom_RendererPreferencesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_UpdateRendererPreferences_Params {
  constructor() {
    /** @type { !blink_mojom_RendererPreferences } */
    this.preferences;
  }
}



mojo.internal.Struct(
    PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
    'PageBroadcast_SetHistoryIndexAndLength_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_SetHistoryIndexAndLength_Params {
  constructor() {
    /** @type { !number } */
    this.index;
    /** @type { !number } */
    this.length;
  }
}



mojo.internal.Struct(
    PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
    'PageBroadcast_SetPageBaseBackgroundColor_Params',
    [
      mojo.internal.StructField(
        'color', 0,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_SetPageBaseBackgroundColor_Params {
  constructor() {
    /** @type { (skia_mojom_SkColor|undefined) } */
    this.color;
  }
}



mojo.internal.Struct(
    PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
    'PageBroadcast_CreateRemoteMainFrame_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_RemoteFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openerFrameToken', 8,
        0,
        blink_mojom_FrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replicationState', 24,
        0,
        blink_mojom_FrameReplicationStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isLoading', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 40,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationMetricsToken', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteFrameInterfaces', 56,
        0,
        blink_mojom_RemoteFrameInterfacesFromBrowserSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteMainFrameInterfaces', 64,
        0,
        blink_mojom_RemoteMainFrameInterfacesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class PageBroadcast_CreateRemoteMainFrame_Params {
  constructor() {
    /** @type { !blink_mojom_RemoteFrameToken } */
    this.token;
    /** @type { (blink_mojom_FrameToken|undefined) } */
    this.openerFrameToken;
    /** @type { !blink_mojom_FrameReplicationState } */
    this.replicationState;
    /** @type { !boolean } */
    this.isLoading;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsFrameToken;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.navigationMetricsToken;
    /** @type { !blink_mojom_RemoteFrameInterfacesFromBrowser } */
    this.remoteFrameInterfaces;
    /** @type { !blink_mojom_RemoteMainFrameInterfaces } */
    this.remoteMainFrameInterfaces;
  }
}



mojo.internal.Struct(
    PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
    'PageBroadcast_UpdatePageBrowsingContextGroup_Params',
    [
      mojo.internal.StructField(
        'browsingContextGroupToken', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_UpdatePageBrowsingContextGroup_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.browsingContextGroupToken;
  }
}



mojo.internal.Struct(
    PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
    'PageBroadcast_SetPageAttributionSupport_Params',
    [
      mojo.internal.StructField(
        'support', 0,
        0,
        network_mojom_AttributionSupportSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_SetPageAttributionSupport_Params {
  constructor() {
    /** @type { !network_mojom_AttributionSupport } */
    this.support;
  }
}



mojo.internal.Struct(
    PageBroadcast_UpdateColorProviders_ParamsSpec.$,
    'PageBroadcast_UpdateColorProviders_Params',
    [
      mojo.internal.StructField(
        'colorProviderColors', 0,
        0,
        ColorProviderColorMapsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_UpdateColorProviders_Params {
  constructor() {
    /** @type { !ColorProviderColorMaps } */
    this.colorProviderColors;
  }
}



mojo.internal.Struct(
    PageBroadcast_UpdateCanvasNoiseToken_ParamsSpec.$,
    'PageBroadcast_UpdateCanvasNoiseToken_Params',
    [
      mojo.internal.StructField(
        'canvasNoiseToken', 0,
        0,
        blink_mojom_NoiseTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_UpdateCanvasNoiseToken_Params {
  constructor() {
    /** @type { (blink_mojom_NoiseToken|undefined) } */
    this.canvasNoiseToken;
  }
}



mojo.internal.Struct(
    PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
    'PageBroadcast_SetSupportsDraggableRegions_Params',
    [
      mojo.internal.StructField(
        'supportsDraggableRegions', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageBroadcast_SetSupportsDraggableRegions_Params {
  constructor() {
    /** @type { !boolean } */
    this.supportsDraggableRegions;
  }
}

