// third_party/blink/public/mojom/permissions/permission.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from './permission_status.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PermissionNameSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PermissionName = {
  
  GEOLOCATION: 0,
  NOTIFICATIONS: 1,
  MIDI: 2,
  PROTECTED_MEDIA_IDENTIFIER: 3,
  DURABLE_STORAGE: 4,
  AUDIO_CAPTURE: 5,
  VIDEO_CAPTURE: 6,
  BACKGROUND_SYNC: 7,
  SENSORS: 8,
  CLIPBOARD_READ: 9,
  CLIPBOARD_WRITE: 10,
  PAYMENT_HANDLER: 11,
  BACKGROUND_FETCH: 12,
  IDLE_DETECTION: 13,
  PERIODIC_BACKGROUND_SYNC: 14,
  SCREEN_WAKE_LOCK: 15,
  SYSTEM_WAKE_LOCK: 16,
  NFC: 17,
  STORAGE_ACCESS: 18,
  WINDOW_MANAGEMENT: 19,
  LOCAL_FONTS: 20,
  DISPLAY_CAPTURE: 21,
  TOP_LEVEL_STORAGE_ACCESS: 22,
  CAPTURED_SURFACE_CONTROL: 23,
  SPEAKER_SELECTION: 24,
  KEYBOARD_LOCK: 25,
  POINTER_LOCK: 26,
  FULLSCREEN: 27,
  WEB_APP_INSTALLATION: 28,
  LOCAL_NETWORK_ACCESS: 29,
  VR: 30,
  AR: 31,
  HAND_TRACKING: 32,
  WEB_PRINTING: 33,
  SMART_CARD: 34,
  MIN_VALUE: 0,
  MAX_VALUE: 34,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EmbeddedPermissionControlResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EmbeddedPermissionControlResult = {
  
  kDismissed: 0,
  kGranted: 1,
  kDenied: 2,
  kNotSupported: 3,
  kResolvedNoUserGesture: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PermissionObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PermissionObserver', scope);
  }
}

/** @interface */
export class PermissionObserverInterface {
  
  /**
   * @param { !blink_mojom_PermissionStatus } status
   */

  onPermissionStatusChange(status) {}
}

/**
 * @implements { PermissionObserverInterface }
 */
export class PermissionObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PermissionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PermissionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PermissionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_PermissionStatus } status
   */

  onPermissionStatusChange(
      status) {
    this.proxy.sendMessage(
        0,
        PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PermissionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PermissionObserverReceiver {
  /**
   * @param {!PermissionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PermissionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PermissionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PermissionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
        null,
        impl.onPermissionStatusChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PermissionObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PermissionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PermissionObserverRemote}
   */
  static getRemote() {
    let remote = new PermissionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PermissionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PermissionObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PermissionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PermissionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPermissionStatusChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
        null,
        this.onPermissionStatusChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EmbeddedPermissionControlClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.EmbeddedPermissionControlClient', scope);
  }
}

/** @interface */
export class EmbeddedPermissionControlClientInterface {
  
  /**
   * @param { !boolean } allow
   * @param { ?Array<!blink_mojom_PermissionStatus> } statuses
   */

  onEmbeddedPermissionControlRegistered(allow, statuses) {}
}

/**
 * @implements { EmbeddedPermissionControlClientInterface }
 */
export class EmbeddedPermissionControlClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EmbeddedPermissionControlClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EmbeddedPermissionControlClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EmbeddedPermissionControlClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } allow
   * @param { ?Array<!blink_mojom_PermissionStatus> } statuses
   */

  onEmbeddedPermissionControlRegistered(
      allow,
      statuses) {
    this.proxy.sendMessage(
        0,
        EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
        null,
        [
          allow,
          statuses
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EmbeddedPermissionControlClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EmbeddedPermissionControlClientReceiver {
  /**
   * @param {!EmbeddedPermissionControlClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EmbeddedPermissionControlClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EmbeddedPermissionControlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EmbeddedPermissionControlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
        null,
        impl.onEmbeddedPermissionControlRegistered.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EmbeddedPermissionControlClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.EmbeddedPermissionControlClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EmbeddedPermissionControlClientRemote}
   */
  static getRemote() {
    let remote = new EmbeddedPermissionControlClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EmbeddedPermissionControlClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EmbeddedPermissionControlClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EmbeddedPermissionControlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EmbeddedPermissionControlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEmbeddedPermissionControlRegistered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
        null,
        this.onEmbeddedPermissionControlRegistered.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PermissionServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PermissionService', scope);
  }
}

/** @interface */
export class PermissionServiceInterface {
  
  /**
   * @param { !PermissionDescriptor } permission
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  hasPermission(permission) {}
  
  /**
   * @param { !Array<!PermissionDescriptor> } permissions
   * @param { !EmbeddedPermissionRequestDescriptor } descriptor
   * @param { !EmbeddedPermissionControlClientRemote } client
   */

  registerPageEmbeddedPermissionControl(permissions, descriptor, client) {}
  
  /**
   * @param { !Array<!PermissionDescriptor> } permissions
   * @param { !EmbeddedPermissionRequestDescriptor } descriptor
   * @return {!Promise<{
        status: !EmbeddedPermissionControlResult,
   *  }>}
   */

  requestPageEmbeddedPermission(permissions, descriptor) {}
  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  requestPermission(permission, userGesture) {}
  
  /**
   * @param { !Array<!PermissionDescriptor> } permission
   * @param { !boolean } userGesture
   * @return {!Promise<{
        statuses: !Array<!blink_mojom_PermissionStatus>,
   *  }>}
   */

  requestPermissions(permission, userGesture) {}
  
  /**
   * @param { !PermissionDescriptor } permission
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  revokePermission(permission) {}
  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !blink_mojom_PermissionStatus } lastKnownStatus
   * @param { !PermissionObserverRemote } observer
   */

  addPermissionObserver(permission, lastKnownStatus, observer) {}
  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !blink_mojom_PermissionStatus } lastKnownStatus
   * @param { !PermissionObserverRemote } observer
   */

  addPageEmbeddedPermissionObserver(permission, lastKnownStatus, observer) {}
  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !string } eventType
   * @param { !boolean } isAdded
   */

  notifyEventListener(permission, eventType, isAdded) {}
}

/**
 * @implements { PermissionServiceInterface }
 */
export class PermissionServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PermissionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PermissionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PermissionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PermissionDescriptor } permission
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  hasPermission(
      permission) {
    return this.proxy.sendMessage(
        0,
        PermissionService_HasPermission_ParamsSpec.$,
        PermissionService_HasPermission_ResponseParamsSpec.$,
        [
          permission
        ],
        false);
  }

  
  /**
   * @param { !Array<!PermissionDescriptor> } permissions
   * @param { !EmbeddedPermissionRequestDescriptor } descriptor
   * @param { !EmbeddedPermissionControlClientRemote } client
   */

  registerPageEmbeddedPermissionControl(
      permissions,
      descriptor,
      client) {
    this.proxy.sendMessage(
        1,
        PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
        null,
        [
          permissions,
          descriptor,
          client
        ],
        false);
  }

  
  /**
   * @param { !Array<!PermissionDescriptor> } permissions
   * @param { !EmbeddedPermissionRequestDescriptor } descriptor
   * @return {!Promise<{
        status: !EmbeddedPermissionControlResult,
   *  }>}
   */

  requestPageEmbeddedPermission(
      permissions,
      descriptor) {
    return this.proxy.sendMessage(
        2,
        PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
        PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
        [
          permissions,
          descriptor
        ],
        false);
  }

  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  requestPermission(
      permission,
      userGesture) {
    return this.proxy.sendMessage(
        3,
        PermissionService_RequestPermission_ParamsSpec.$,
        PermissionService_RequestPermission_ResponseParamsSpec.$,
        [
          permission,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !Array<!PermissionDescriptor> } permission
   * @param { !boolean } userGesture
   * @return {!Promise<{
        statuses: !Array<!blink_mojom_PermissionStatus>,
   *  }>}
   */

  requestPermissions(
      permission,
      userGesture) {
    return this.proxy.sendMessage(
        4,
        PermissionService_RequestPermissions_ParamsSpec.$,
        PermissionService_RequestPermissions_ResponseParamsSpec.$,
        [
          permission,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !PermissionDescriptor } permission
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  revokePermission(
      permission) {
    return this.proxy.sendMessage(
        5,
        PermissionService_RevokePermission_ParamsSpec.$,
        PermissionService_RevokePermission_ResponseParamsSpec.$,
        [
          permission
        ],
        false);
  }

  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !blink_mojom_PermissionStatus } lastKnownStatus
   * @param { !PermissionObserverRemote } observer
   */

  addPermissionObserver(
      permission,
      lastKnownStatus,
      observer) {
    this.proxy.sendMessage(
        6,
        PermissionService_AddPermissionObserver_ParamsSpec.$,
        null,
        [
          permission,
          lastKnownStatus,
          observer
        ],
        false);
  }

  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !blink_mojom_PermissionStatus } lastKnownStatus
   * @param { !PermissionObserverRemote } observer
   */

  addPageEmbeddedPermissionObserver(
      permission,
      lastKnownStatus,
      observer) {
    this.proxy.sendMessage(
        7,
        PermissionService_AddPageEmbeddedPermissionObserver_ParamsSpec.$,
        null,
        [
          permission,
          lastKnownStatus,
          observer
        ],
        false);
  }

  
  /**
   * @param { !PermissionDescriptor } permission
   * @param { !string } eventType
   * @param { !boolean } isAdded
   */

  notifyEventListener(
      permission,
      eventType,
      isAdded) {
    this.proxy.sendMessage(
        8,
        PermissionService_NotifyEventListener_ParamsSpec.$,
        null,
        [
          permission,
          eventType,
          isAdded
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PermissionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PermissionServiceReceiver {
  /**
   * @param {!PermissionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PermissionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PermissionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PermissionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PermissionService_HasPermission_ParamsSpec.$,
        PermissionService_HasPermission_ResponseParamsSpec.$,
        impl.hasPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
        null,
        impl.registerPageEmbeddedPermissionControl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
        PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
        impl.requestPageEmbeddedPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PermissionService_RequestPermission_ParamsSpec.$,
        PermissionService_RequestPermission_ResponseParamsSpec.$,
        impl.requestPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PermissionService_RequestPermissions_ParamsSpec.$,
        PermissionService_RequestPermissions_ResponseParamsSpec.$,
        impl.requestPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PermissionService_RevokePermission_ParamsSpec.$,
        PermissionService_RevokePermission_ResponseParamsSpec.$,
        impl.revokePermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PermissionService_AddPermissionObserver_ParamsSpec.$,
        null,
        impl.addPermissionObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PermissionService_AddPageEmbeddedPermissionObserver_ParamsSpec.$,
        null,
        impl.addPageEmbeddedPermissionObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PermissionService_NotifyEventListener_ParamsSpec.$,
        null,
        impl.notifyEventListener.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PermissionService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PermissionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PermissionServiceRemote}
   */
  static getRemote() {
    let remote = new PermissionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PermissionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PermissionServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PermissionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PermissionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PermissionService_HasPermission_ParamsSpec.$,
        PermissionService_HasPermission_ResponseParamsSpec.$,
        this.hasPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerPageEmbeddedPermissionControl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
        null,
        this.registerPageEmbeddedPermissionControl.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPageEmbeddedPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
        PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
        this.requestPageEmbeddedPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PermissionService_RequestPermission_ParamsSpec.$,
        PermissionService_RequestPermission_ResponseParamsSpec.$,
        this.requestPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PermissionService_RequestPermissions_ParamsSpec.$,
        PermissionService_RequestPermissions_ResponseParamsSpec.$,
        this.requestPermissions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.revokePermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PermissionService_RevokePermission_ParamsSpec.$,
        PermissionService_RevokePermission_ResponseParamsSpec.$,
        this.revokePermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPermissionObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PermissionService_AddPermissionObserver_ParamsSpec.$,
        null,
        this.addPermissionObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPageEmbeddedPermissionObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PermissionService_AddPageEmbeddedPermissionObserver_ParamsSpec.$,
        null,
        this.addPageEmbeddedPermissionObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyEventListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PermissionService_NotifyEventListener_ParamsSpec.$,
        null,
        this.notifyEventListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MidiPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CameraDevicePermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TopLevelStorageAccessPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FullscreenPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationEmbeddedPermissionRequestDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedPermissionRequestDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionObserver_OnPermissionStatusChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_HasPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_HasPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RequestPageEmbeddedPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RequestPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RequestPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RequestPermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RequestPermissions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RevokePermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_RevokePermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_AddPermissionObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_AddPageEmbeddedPermissionObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PermissionService_NotifyEventListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const PermissionDescriptorExtensionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MidiPermissionDescriptorSpec.$,
    'MidiPermissionDescriptor',
    [
      mojo.internal.StructField(
        'sysex', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MidiPermissionDescriptor {
  constructor() {
    /** @type { !boolean } */
    this.sysex;
  }
}



mojo.internal.Struct(
    ClipboardPermissionDescriptorSpec.$,
    'ClipboardPermissionDescriptor',
    [
      mojo.internal.StructField(
        'hasUserGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'willBeSanitized', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardPermissionDescriptor {
  constructor() {
    /** @type { !boolean } */
    this.hasUserGesture;
    /** @type { !boolean } */
    this.willBeSanitized;
  }
}



mojo.internal.Struct(
    CameraDevicePermissionDescriptorSpec.$,
    'CameraDevicePermissionDescriptor',
    [
      mojo.internal.StructField(
        'panTiltZoom', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CameraDevicePermissionDescriptor {
  constructor() {
    /** @type { !boolean } */
    this.panTiltZoom;
  }
}



mojo.internal.Struct(
    TopLevelStorageAccessPermissionDescriptorSpec.$,
    'TopLevelStorageAccessPermissionDescriptor',
    [
      mojo.internal.StructField(
        'requestedOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TopLevelStorageAccessPermissionDescriptor {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.requestedOrigin;
  }
}



mojo.internal.Struct(
    FullscreenPermissionDescriptorSpec.$,
    'FullscreenPermissionDescriptor',
    [
      mojo.internal.StructField(
        'allowWithoutUserGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FullscreenPermissionDescriptor {
  constructor() {
    /** @type { !boolean } */
    this.allowWithoutUserGesture;
  }
}



mojo.internal.Struct(
    PermissionDescriptorSpec.$,
    'PermissionDescriptor',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        PermissionNameSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extension', 8,
        0,
        PermissionDescriptorExtensionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PermissionDescriptor {
  constructor() {
    /** @type { !PermissionName } */
    this.name;
    /** @type { (PermissionDescriptorExtension|undefined) } */
    this.extension;
  }
}



mojo.internal.Struct(
    GeolocationEmbeddedPermissionRequestDescriptorSpec.$,
    'GeolocationEmbeddedPermissionRequestDescriptor',
    [
      mojo.internal.StructField(
        'autolocate', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GeolocationEmbeddedPermissionRequestDescriptor {
  constructor() {
    /** @type { !boolean } */
    this.autolocate;
  }
}



mojo.internal.Struct(
    EmbeddedPermissionRequestDescriptorSpec.$,
    'EmbeddedPermissionRequestDescriptor',
    [
      mojo.internal.StructField(
        'elementPosition', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'geolocation', 8,
        0,
        GeolocationEmbeddedPermissionRequestDescriptorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EmbeddedPermissionRequestDescriptor {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.elementPosition;
    /** @type { (GeolocationEmbeddedPermissionRequestDescriptor|undefined) } */
    this.geolocation;
  }
}



mojo.internal.Struct(
    PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
    'PermissionObserver_OnPermissionStatusChange_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionObserver_OnPermissionStatusChange_Params {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
    'EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params',
    [
      mojo.internal.StructField(
        'allow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'statuses', 8,
        0,
        mojo.internal.Array(blink_mojom_PermissionStatusSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params {
  constructor() {
    /** @type { !boolean } */
    this.allow;
    /** @type { (Array<!blink_mojom_PermissionStatus>|undefined) } */
    this.statuses;
  }
}



mojo.internal.Struct(
    PermissionService_HasPermission_ParamsSpec.$,
    'PermissionService_HasPermission_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        PermissionDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_HasPermission_Params {
  constructor() {
    /** @type { !PermissionDescriptor } */
    this.permission;
  }
}



mojo.internal.Struct(
    PermissionService_HasPermission_ResponseParamsSpec.$,
    'PermissionService_HasPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_HasPermission_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
    'PermissionService_RegisterPageEmbeddedPermissionControl_Params',
    [
      mojo.internal.StructField(
        'permissions', 0,
        0,
        mojo.internal.Array(PermissionDescriptorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'descriptor', 8,
        0,
        EmbeddedPermissionRequestDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.InterfaceProxy(EmbeddedPermissionControlClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PermissionService_RegisterPageEmbeddedPermissionControl_Params {
  constructor() {
    /** @type { !Array<!PermissionDescriptor> } */
    this.permissions;
    /** @type { !EmbeddedPermissionRequestDescriptor } */
    this.descriptor;
    /** @type { !EmbeddedPermissionControlClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
    'PermissionService_RequestPageEmbeddedPermission_Params',
    [
      mojo.internal.StructField(
        'permissions', 0,
        0,
        mojo.internal.Array(PermissionDescriptorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'descriptor', 8,
        0,
        EmbeddedPermissionRequestDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PermissionService_RequestPageEmbeddedPermission_Params {
  constructor() {
    /** @type { !Array<!PermissionDescriptor> } */
    this.permissions;
    /** @type { !EmbeddedPermissionRequestDescriptor } */
    this.descriptor;
  }
}



mojo.internal.Struct(
    PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
    'PermissionService_RequestPageEmbeddedPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        EmbeddedPermissionControlResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_RequestPageEmbeddedPermission_ResponseParams {
  constructor() {
    /** @type { !EmbeddedPermissionControlResult } */
    this.status;
  }
}



mojo.internal.Struct(
    PermissionService_RequestPermission_ParamsSpec.$,
    'PermissionService_RequestPermission_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        PermissionDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PermissionService_RequestPermission_Params {
  constructor() {
    /** @type { !PermissionDescriptor } */
    this.permission;
    /** @type { !boolean } */
    this.userGesture;
  }
}



mojo.internal.Struct(
    PermissionService_RequestPermission_ResponseParamsSpec.$,
    'PermissionService_RequestPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_RequestPermission_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PermissionService_RequestPermissions_ParamsSpec.$,
    'PermissionService_RequestPermissions_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        mojo.internal.Array(PermissionDescriptorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PermissionService_RequestPermissions_Params {
  constructor() {
    /** @type { !Array<!PermissionDescriptor> } */
    this.permission;
    /** @type { !boolean } */
    this.userGesture;
  }
}



mojo.internal.Struct(
    PermissionService_RequestPermissions_ResponseParamsSpec.$,
    'PermissionService_RequestPermissions_ResponseParams',
    [
      mojo.internal.StructField(
        'statuses', 0,
        0,
        mojo.internal.Array(blink_mojom_PermissionStatusSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_RequestPermissions_ResponseParams {
  constructor() {
    /** @type { !Array<!blink_mojom_PermissionStatus> } */
    this.statuses;
  }
}



mojo.internal.Struct(
    PermissionService_RevokePermission_ParamsSpec.$,
    'PermissionService_RevokePermission_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        PermissionDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_RevokePermission_Params {
  constructor() {
    /** @type { !PermissionDescriptor } */
    this.permission;
  }
}



mojo.internal.Struct(
    PermissionService_RevokePermission_ResponseParamsSpec.$,
    'PermissionService_RevokePermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PermissionService_RevokePermission_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PermissionService_AddPermissionObserver_ParamsSpec.$,
    'PermissionService_AddPermissionObserver_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        PermissionDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastKnownStatus', 8,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(PermissionObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PermissionService_AddPermissionObserver_Params {
  constructor() {
    /** @type { !PermissionDescriptor } */
    this.permission;
    /** @type { !blink_mojom_PermissionStatus } */
    this.lastKnownStatus;
    /** @type { !PermissionObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    PermissionService_AddPageEmbeddedPermissionObserver_ParamsSpec.$,
    'PermissionService_AddPageEmbeddedPermissionObserver_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        PermissionDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastKnownStatus', 8,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(PermissionObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PermissionService_AddPageEmbeddedPermissionObserver_Params {
  constructor() {
    /** @type { !PermissionDescriptor } */
    this.permission;
    /** @type { !blink_mojom_PermissionStatus } */
    this.lastKnownStatus;
    /** @type { !PermissionObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    PermissionService_NotifyEventListener_ParamsSpec.$,
    'PermissionService_NotifyEventListener_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        PermissionDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventType', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAdded', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PermissionService_NotifyEventListener_Params {
  constructor() {
    /** @type { !PermissionDescriptor } */
    this.permission;
    /** @type { !string } */
    this.eventType;
    /** @type { !boolean } */
    this.isAdded;
  }
}

mojo.internal.Union(
    PermissionDescriptorExtensionSpec.$, 'PermissionDescriptorExtension',
    {
      'midi': {
        'ordinal': 0,
        'type': MidiPermissionDescriptorSpec.$,
      },
      'clipboard': {
        'ordinal': 1,
        'type': ClipboardPermissionDescriptorSpec.$,
      },
      'cameraDevice': {
        'ordinal': 2,
        'type': CameraDevicePermissionDescriptorSpec.$,
      },
      'topLevelStorageAccess': {
        'ordinal': 3,
        'type': TopLevelStorageAccessPermissionDescriptorSpec.$,
      },
      'fullscreen': {
        'ordinal': 4,
        'type': FullscreenPermissionDescriptorSpec.$,
      },
    });

/**
 * @typedef { {
 *   midi: (!MidiPermissionDescriptor|undefined),
 *   clipboard: (!ClipboardPermissionDescriptor|undefined),
 *   cameraDevice: (!CameraDevicePermissionDescriptor|undefined),
 *   topLevelStorageAccess: (!TopLevelStorageAccessPermissionDescriptor|undefined),
 *   fullscreen: (!FullscreenPermissionDescriptor|undefined),
 * } }
 */
export const PermissionDescriptorExtension = {};
