// third_party/blink/public/mojom/permissions_policy/policy_value.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/permissions_policy/policy_value.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var PolicyValueType = {};
  PolicyValueType.kNull = 0;
  PolicyValueType.kBool = 1;
  PolicyValueType.kDecDouble = 2;
  PolicyValueType.kEnum = 3;
  PolicyValueType.MIN_VALUE = 0;
  PolicyValueType.MAX_VALUE = 3;

  PolicyValueType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  PolicyValueType.toKnownEnumValue = function(value) {
    return value;
  };

  PolicyValueType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };


  function PolicyValue(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PolicyValue.Tags = {
    nullValue: 0,
    boolValue: 1,
    decDoubleValue: 2,
    enumValue: 3,
  };

  PolicyValue.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PolicyValue.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "nullValue",
        "boolValue",
        "decDoubleValue",
        "enumValue",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PolicyValue member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PolicyValue.prototype, "nullValue", {
    get: function() {
      if (this.$tag != PolicyValue.Tags.nullValue) {
        throw new ReferenceError(
            "PolicyValue.nullValue is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PolicyValue.Tags.nullValue;
      this.$data = value;
    }
  });
  Object.defineProperty(PolicyValue.prototype, "boolValue", {
    get: function() {
      if (this.$tag != PolicyValue.Tags.boolValue) {
        throw new ReferenceError(
            "PolicyValue.boolValue is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PolicyValue.Tags.boolValue;
      this.$data = value;
    }
  });
  Object.defineProperty(PolicyValue.prototype, "decDoubleValue", {
    get: function() {
      if (this.$tag != PolicyValue.Tags.decDoubleValue) {
        throw new ReferenceError(
            "PolicyValue.decDoubleValue is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PolicyValue.Tags.decDoubleValue;
      this.$data = value;
    }
  });
  Object.defineProperty(PolicyValue.prototype, "enumValue", {
    get: function() {
      if (this.$tag != PolicyValue.Tags.enumValue) {
        throw new ReferenceError(
            "PolicyValue.enumValue is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PolicyValue.Tags.enumValue;
      this.$data = value;
    }
  });


    PolicyValue.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PolicyValue.Tags.nullValue:
          encoder.writeUint8(val.nullValue ? 1 : 0);
          break;
        case PolicyValue.Tags.boolValue:
          encoder.writeUint8(val.boolValue ? 1 : 0);
          break;
        case PolicyValue.Tags.decDoubleValue:
          encoder.encodeStruct(codec.Double, val.decDoubleValue);
          break;
        case PolicyValue.Tags.enumValue:
          encoder.encodeStruct(codec.Int32, val.enumValue);
          break;
      }
      encoder.align();
    };


    PolicyValue.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PolicyValue();
      var tag = decoder.readUint32();
      switch (tag) {
        case PolicyValue.Tags.nullValue:
          result.nullValue = decoder.readUint8() ? true : false;
          break;
        case PolicyValue.Tags.boolValue:
          result.boolValue = decoder.readUint8() ? true : false;
          break;
        case PolicyValue.Tags.decDoubleValue:
          result.decDoubleValue = decoder.decodeStruct(codec.Double);
          break;
        case PolicyValue.Tags.enumValue:
          result.enumValue = decoder.decodeStruct(codec.Int32);
          break;
      }
      decoder.align();

      return result;
    };


    PolicyValue.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PolicyValue.Tags.nullValue:
          

          break;
        case PolicyValue.Tags.boolValue:
          

          break;
        case PolicyValue.Tags.decDoubleValue:
          

          break;
        case PolicyValue.Tags.enumValue:
          

          break;
      }

      return validator.validationError.NONE;
    };

  PolicyValue.encodedSize = 16;
  exports.PolicyValueType = PolicyValueType;
  exports.PolicyValue = PolicyValue;
})();