// third_party/blink/public/mojom/prerender/prerender.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/prerender/prerender.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var referrer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/referrer.mojom', '../loader/referrer.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var PrerenderTriggerType = {};
  PrerenderTriggerType.kLinkRelPrerender = 0;
  PrerenderTriggerType.kLinkRelNext = 1;
  PrerenderTriggerType.MIN_VALUE = 0;
  PrerenderTriggerType.MAX_VALUE = 1;

  PrerenderTriggerType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  PrerenderTriggerType.toKnownEnumValue = function(value) {
    return value;
  };

  PrerenderTriggerType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PrerenderAttributes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrerenderAttributes.prototype.initDefaults_ = function() {
    this.url = null;
    this.triggerType = 0;
    this.referrer = null;
    this.viewSize = null;
  };
  PrerenderAttributes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrerenderAttributes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderAttributes.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderAttributes.triggerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, PrerenderTriggerType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderAttributes.referrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, referrer$.Referrer, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderAttributes.viewSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PrerenderAttributes.encodedSize = codec.kStructHeaderSize + 32;

  PrerenderAttributes.decode = function(decoder) {
    var packed;
    var val = new PrerenderAttributes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.triggerType =
        decoder.decodeStruct(new codec.Enum(PrerenderTriggerType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.referrer =
        decoder.decodeStructPointer(referrer$.Referrer);
    val.viewSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  PrerenderAttributes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrerenderAttributes.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.triggerType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(referrer$.Referrer, val.referrer);
    encoder.encodeStructPointer(geometry$.Size, val.viewSize);
  };
  function NoStatePrefetchProcessor_Start_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NoStatePrefetchProcessor_Start_Params.prototype.initDefaults_ = function() {
    this.prerenderAttribute = null;
  };
  NoStatePrefetchProcessor_Start_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NoStatePrefetchProcessor_Start_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NoStatePrefetchProcessor_Start_Params.prerenderAttribute
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PrerenderAttributes, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NoStatePrefetchProcessor_Start_Params.encodedSize = codec.kStructHeaderSize + 8;

  NoStatePrefetchProcessor_Start_Params.decode = function(decoder) {
    var packed;
    var val = new NoStatePrefetchProcessor_Start_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.prerenderAttribute =
        decoder.decodeStructPointer(PrerenderAttributes);
    return val;
  };

  NoStatePrefetchProcessor_Start_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NoStatePrefetchProcessor_Start_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PrerenderAttributes, val.prerenderAttribute);
  };
  function NoStatePrefetchProcessor_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NoStatePrefetchProcessor_Cancel_Params.prototype.initDefaults_ = function() {
  };
  NoStatePrefetchProcessor_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NoStatePrefetchProcessor_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NoStatePrefetchProcessor_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  NoStatePrefetchProcessor_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new NoStatePrefetchProcessor_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NoStatePrefetchProcessor_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NoStatePrefetchProcessor_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kNoStatePrefetchProcessor_Start_Name = 0;
  var kNoStatePrefetchProcessor_Cancel_Name = 1;

  function NoStatePrefetchProcessorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NoStatePrefetchProcessor,
                                                   handleOrPtrInfo);
  }

  function NoStatePrefetchProcessorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NoStatePrefetchProcessor, associatedInterfacePtrInfo);
  }

  NoStatePrefetchProcessorAssociatedPtr.prototype =
      Object.create(NoStatePrefetchProcessorPtr.prototype);
  NoStatePrefetchProcessorAssociatedPtr.prototype.constructor =
      NoStatePrefetchProcessorAssociatedPtr;

  function NoStatePrefetchProcessorProxy(receiver) {
    this.receiver_ = receiver;
  }
  NoStatePrefetchProcessorPtr.prototype.start = function() {
    return NoStatePrefetchProcessorProxy.prototype.start
        .apply(this.ptr.getProxy(), arguments);
  };

  NoStatePrefetchProcessorProxy.prototype.start = function(prerenderAttribute) {
    var params_ = new NoStatePrefetchProcessor_Start_Params();
    params_.prerenderAttribute = prerenderAttribute;
    var builder = new codec.MessageV0Builder(
        kNoStatePrefetchProcessor_Start_Name,
        codec.align(NoStatePrefetchProcessor_Start_Params.encodedSize));
    builder.encodeStruct(NoStatePrefetchProcessor_Start_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NoStatePrefetchProcessorPtr.prototype.cancel = function() {
    return NoStatePrefetchProcessorProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  NoStatePrefetchProcessorProxy.prototype.cancel = function() {
    var params_ = new NoStatePrefetchProcessor_Cancel_Params();
    var builder = new codec.MessageV0Builder(
        kNoStatePrefetchProcessor_Cancel_Name,
        codec.align(NoStatePrefetchProcessor_Cancel_Params.encodedSize));
    builder.encodeStruct(NoStatePrefetchProcessor_Cancel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NoStatePrefetchProcessorStub(delegate) {
    this.delegate_ = delegate;
  }
  NoStatePrefetchProcessorStub.prototype.start = function(prerenderAttribute) {
    return this.delegate_ && this.delegate_.start && this.delegate_.start(prerenderAttribute);
  }
  NoStatePrefetchProcessorStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }

  NoStatePrefetchProcessorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNoStatePrefetchProcessor_Start_Name:
      var params = reader.decodeStruct(NoStatePrefetchProcessor_Start_Params);
      this.start(params.prerenderAttribute);
      return true;
    case kNoStatePrefetchProcessor_Cancel_Name:
      var params = reader.decodeStruct(NoStatePrefetchProcessor_Cancel_Params);
      this.cancel();
      return true;
    default:
      return false;
    }
  };

  NoStatePrefetchProcessorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateNoStatePrefetchProcessorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNoStatePrefetchProcessor_Start_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NoStatePrefetchProcessor_Start_Params;
      break;
      case kNoStatePrefetchProcessor_Cancel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NoStatePrefetchProcessor_Cancel_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNoStatePrefetchProcessorResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NoStatePrefetchProcessor = {
    name: 'blink.mojom.NoStatePrefetchProcessor',
    kVersion: 0,
    ptrClass: NoStatePrefetchProcessorPtr,
    proxyClass: NoStatePrefetchProcessorProxy,
    stubClass: NoStatePrefetchProcessorStub,
    validateRequest: validateNoStatePrefetchProcessorRequest,
    validateResponse: null,
  };
  NoStatePrefetchProcessorStub.prototype.validator = validateNoStatePrefetchProcessorRequest;
  NoStatePrefetchProcessorProxy.prototype.validator = null;
  exports.PrerenderTriggerType = PrerenderTriggerType;
  exports.PrerenderAttributes = PrerenderAttributes;
  exports.NoStatePrefetchProcessor = NoStatePrefetchProcessor;
  exports.NoStatePrefetchProcessorPtr = NoStatePrefetchProcessorPtr;
  exports.NoStatePrefetchProcessorAssociatedPtr = NoStatePrefetchProcessorAssociatedPtr;
})();