// third_party/blink/public/mojom/service_worker/service_worker.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.AncestorFrameType');
goog.require('blink.mojom.ConsoleMessageLevel');
goog.require('blink.mojom.ServiceWorkerErrorType');
goog.require('blink.mojom.ServiceWorkerEventStatus');
goog.require('blink.mojom.AssociatedInterfaceProvider');
goog.require('payments.mojom.PaymentHandlerResponseCallback');
goog.require('blink.mojom.ServiceWorkerFetchResponseCallback');
goog.require('blink.mojom.BackgroundFetchRegistration');
goog.require('mojoBase.mojom.BigString16');
goog.require('payments.mojom.CanMakePaymentEventData');
goog.require('network.mojom.CookieChangeInfo');
goog.require('blink.mojom.DispatchFetchEventParams');
goog.require('blink.mojom.NotificationData');
goog.require('url.mojom.Origin');
goog.require('payments.mojom.PaymentRequestEventData');
goog.require('blink.mojom.PushSubscription');
goog.require('mojoBase.mojom.ReadOnlyBuffer');
goog.require('blink.mojom.ServiceWorkerClientInfo');
goog.require('blink.mojom.ServiceWorkerClientQueryOptions');
goog.require('blink.mojom.ServiceWorkerObjectInfo');
goog.require('blink.mojom.ServiceWorkerRegistrationObjectInfo');
goog.require('blink.mojom.ServiceWorkerRouterRules');
goog.require('blink.mojom.StorageKey');
goog.require('mojoBase.mojom.String16');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('blink.mojom.TransferableMessage');
goog.require('url.mojom.Url');
goog.require('mojoBase.mojom.Value');



goog.provide('blink.mojom.PUSH_EVENT_TIMEOUT_SECONDS');
/**
 * @const { !number }
 * @export
 */
blink.mojom.PUSH_EVENT_TIMEOUT_SECONDS = 90;
goog.provide('blink.mojom.SERVICE_WORKER_DEFAULT_IDLE_DELAY_IN_SECONDS');
/**
 * @const { !number }
 * @export
 */
blink.mojom.SERVICE_WORKER_DEFAULT_IDLE_DELAY_IN_SECONDS = 30;

goog.provide('blink.mojom.FocusError');
goog.provide('blink.mojom.FocusErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FocusErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FocusError = {
  
  CLIENT_NOT_FOUND: 0,
  CLIENT_INACTIVE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.FetchHandlerExistence');
goog.provide('blink.mojom.FetchHandlerExistenceSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FetchHandlerExistenceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FetchHandlerExistence = {
  
  UNKNOWN: 0,
  EXISTS: 1,
  DOES_NOT_EXIST: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.ServiceWorkerHost');
goog.provide('blink.mojom.ServiceWorkerHostReceiver');
goog.provide('blink.mojom.ServiceWorkerHostCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerHostInterface');
goog.provide('blink.mojom.ServiceWorkerHostRemote');
goog.provide('blink.mojom.ServiceWorkerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerHostInterface = class {
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   */

  setCachedMetadata(url, data) {}
  
  /**
   * @param { !url.mojom.Url } url
   */

  clearCachedMetadata(url) {}
  
  /**
   * @param { !blink.mojom.ServiceWorkerClientQueryOptions } options
   * @return {!Promise<{
        clients: !Array<!blink.mojom.ServiceWorkerClientInfo>,
   *  }>}
   */

  getClients(options) {}
  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        client: ?blink.mojom.ServiceWorkerClientInfo,
   *  }>}
   */

  getClient(clientUuid) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink.mojom.ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openNewTab(url) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink.mojom.ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openPaymentHandlerWindow(url) {}
  
  /**
   * @param { !string } clientUuid
   * @param { !blink.mojom.TransferableMessage } message
   */

  postMessageToClient(clientUuid, message) {}
  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        result: !blink.mojom.FocusResult,
   *  }>}
   */

  focusClient(clientUuid) {}
  
  /**
   * @param { !string } clientUuid
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink.mojom.ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  navigateClient(clientUuid, url) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  skipWaiting() {}
  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  claimClients() {}
  
  /**
   * @param { !blink.mojom.ServiceWorkerRouterRules } rules
   * @return {!Promise<{
        isParseError: !boolean,
   *  }>}
   */

  addRoutes(rules) {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerHostInterface }
 */
blink.mojom.ServiceWorkerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   */

  setCachedMetadata(
      url,
      data) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
        null,
        [
          url,
          data
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   */

  clearCachedMetadata(
      url) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerClientQueryOptions } options
   * @return {!Promise<{
        clients: !Array<!blink.mojom.ServiceWorkerClientInfo>,
   *  }>}
   */

  getClients(
      options) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorkerHost_GetClients_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        client: ?blink.mojom.ServiceWorkerClientInfo,
   *  }>}
   */

  getClient(
      clientUuid) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.ServiceWorkerHost_GetClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
        [
          clientUuid
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink.mojom.ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openNewTab(
      url) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink.mojom.ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openPaymentHandlerWindow(
      url) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @param { !blink.mojom.TransferableMessage } message
   */

  postMessageToClient(
      clientUuid,
      message) {
    this.proxy.sendMessage(
        6,
        blink.mojom.ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
        null,
        [
          clientUuid,
          message
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        result: !blink.mojom.FocusResult,
   *  }>}
   */

  focusClient(
      clientUuid) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.ServiceWorkerHost_FocusClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
        [
          clientUuid
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink.mojom.ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  navigateClient(
      clientUuid,
      url) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.ServiceWorkerHost_NavigateClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
        [
          clientUuid,
          url
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  skipWaiting() {
    return this.proxy.sendMessage(
        9,
        blink.mojom.ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  claimClients() {
    return this.proxy.sendMessage(
        10,
        blink.mojom.ServiceWorkerHost_ClaimClients_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerRouterRules } rules
   * @return {!Promise<{
        isParseError: !boolean,
   *  }>}
   */

  addRoutes(
      rules) {
    return this.proxy.sendMessage(
        11,
        blink.mojom.ServiceWorkerHost_AddRoutes_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
        [
          rules
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerHostReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
        null,
        impl.setCachedMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
        null,
        impl.clearCachedMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerHost_GetClients_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
        impl.getClients.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorkerHost_GetClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
        impl.getClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
        impl.openNewTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
        impl.openPaymentHandlerWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
        null,
        impl.postMessageToClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ServiceWorkerHost_FocusClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
        impl.focusClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ServiceWorkerHost_NavigateClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
        impl.navigateClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
        impl.skipWaiting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.ServiceWorkerHost_ClaimClients_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
        impl.claimClients.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.ServiceWorkerHost_AddRoutes_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
        impl.addRoutes.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCachedMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
        null,
        this.setCachedMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearCachedMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
        null,
        this.clearCachedMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getClients =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerHost_GetClients_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
        this.getClients.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorkerHost_GetClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
        this.getClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openNewTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
        this.openNewTab.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openPaymentHandlerWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
        this.openPaymentHandlerWindow.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageToClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
        null,
        this.postMessageToClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ServiceWorkerHost_FocusClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
        this.focusClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.navigateClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ServiceWorkerHost_NavigateClient_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
        this.navigateClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.skipWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
        this.skipWaiting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.claimClients =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.ServiceWorkerHost_ClaimClients_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
        this.claimClients.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addRoutes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.ServiceWorkerHost_AddRoutes_ParamsSpec.$,
        blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
        this.addRoutes.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorker');
goog.provide('blink.mojom.ServiceWorkerReceiver');
goog.provide('blink.mojom.ServiceWorkerCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerInterface');
goog.provide('blink.mojom.ServiceWorkerRemote');
goog.provide('blink.mojom.ServiceWorkerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorker.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerInterface = class {
  
  /**
   * @param { !Object } serviceWorkerHost
   * @param { !Object } associatedInterfacesToBrowser
   * @param { !Object } associatedInterfacesFromBrowser
   * @param { !blink.mojom.ServiceWorkerRegistrationObjectInfo } registrationInfo
   * @param { !blink.mojom.ServiceWorkerObjectInfo } serviceWorkerInfo
   * @param { !blink.mojom.FetchHandlerExistence } fetchHandlerExistence
   * @param { !blink.mojom.AncestorFrameType } ancestorFrameType
   * @param { !blink.mojom.StorageKey } storageKey
   */

  initializeGlobalScope(serviceWorkerHost, associatedInterfacesToBrowser, associatedInterfacesFromBrowser, registrationInfo, serviceWorkerInfo, fetchHandlerExistence, ancestorFrameType, storageKey) {}
  
  /**
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
        fetchCount: !number,
   *  }>}
   */

  dispatchInstallEvent() {}
  
  /**
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchActivateEvent() {}
  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchAbortEvent(registration) {}
  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchClickEvent(registration) {}
  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchFailEvent(registration) {}
  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchSuccessEvent(registration) {}
  
  /**
   * @param { !network.mojom.CookieChangeInfo } change
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCookieChangeEvent(change) {}
  
  /**
   * @param { !blink.mojom.DispatchFetchEventParams } params
   * @param { !blink.mojom.ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForMainResource(params, responseCallback) {}
  
  /**
   * @param { !string } notificationId
   * @param { !blink.mojom.NotificationData } notificationData
   * @param { !number } actionIndex
   * @param { ?mojoBase.mojom.String16 } reply
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationClickEvent(notificationId, notificationData, actionIndex, reply) {}
  
  /**
   * @param { !string } notificationId
   * @param { !blink.mojom.NotificationData } notificationData
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationCloseEvent(notificationId, notificationData) {}
  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushEvent(payload) {}
  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
        requestedUrls: ?Array<!url.mojom.Url>,
   *  }>}
   */

  dispatchPushEventRecordingNetworkRequests(payload) {}
  
  /**
   * @param { ?blink.mojom.PushSubscription } oldSubscription
   * @param { ?blink.mojom.PushSubscription } newSubscription
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushSubscriptionChangeEvent(oldSubscription, newSubscription) {}
  
  /**
   * @param { !string } tag
   * @param { !boolean } lastChance
   * @param { !mojoBase.mojom.TimeDelta } timeout
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchSyncEvent(tag, lastChance, timeout) {}
  
  /**
   * @param { !string } tag
   * @param { !mojoBase.mojom.TimeDelta } timeout
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPeriodicSyncEvent(tag, timeout) {}
  
  /**
   * @param { !payments.mojom.PaymentHandlerResponseCallbackRemote } resultOfAbortPayment
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchAbortPaymentEvent(resultOfAbortPayment) {}
  
  /**
   * @param { !payments.mojom.CanMakePaymentEventData } eventData
   * @param { !payments.mojom.PaymentHandlerResponseCallbackRemote } resultOfCanMakePayment
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCanMakePaymentEvent(eventData, resultOfCanMakePayment) {}
  
  /**
   * @param { !payments.mojom.PaymentRequestEventData } requestData
   * @param { !payments.mojom.PaymentHandlerResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPaymentRequestEvent(requestData, responseCallback) {}
  
  /**
   * @param { !blink.mojom.ExtendableMessageEvent } event
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchExtendableMessageEvent(event) {}
  
  /**
   * @param { !string } id
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchContentDeleteEvent(id) {}
  
  /**
   * @return {!Promise}
   */

  ping() {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } delay
   */

  setIdleDelay(delay) {}
  
  /**
   */

  addKeepAlive() {}
  
  /**
   */

  clearKeepAlive() {}
  
  /**
   * @param { !blink.mojom.ConsoleMessageLevel } level
   * @param { !string } message
   */

  addMessageToConsole(level, message) {}
  
  /**
   * @param { !mojoBase.mojom.BigString16 } javascript
   * @param { !boolean } wantsResult
   * @return {!Promise<{
        result: !mojoBase.mojom.Value,
        error: ?string,
   *  }>}
   */

  executeScriptForTest(javascript, wantsResult) {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerInterface }
 */
blink.mojom.ServiceWorkerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } serviceWorkerHost
   * @param { !Object } associatedInterfacesToBrowser
   * @param { !Object } associatedInterfacesFromBrowser
   * @param { !blink.mojom.ServiceWorkerRegistrationObjectInfo } registrationInfo
   * @param { !blink.mojom.ServiceWorkerObjectInfo } serviceWorkerInfo
   * @param { !blink.mojom.FetchHandlerExistence } fetchHandlerExistence
   * @param { !blink.mojom.AncestorFrameType } ancestorFrameType
   * @param { !blink.mojom.StorageKey } storageKey
   */

  initializeGlobalScope(
      serviceWorkerHost,
      associatedInterfacesToBrowser,
      associatedInterfacesFromBrowser,
      registrationInfo,
      serviceWorkerInfo,
      fetchHandlerExistence,
      ancestorFrameType,
      storageKey) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
        null,
        [
          serviceWorkerHost,
          associatedInterfacesToBrowser,
          associatedInterfacesFromBrowser,
          registrationInfo,
          serviceWorkerInfo,
          fetchHandlerExistence,
          ancestorFrameType,
          storageKey
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
        fetchCount: !number,
   *  }>}
   */

  dispatchInstallEvent() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchActivateEvent() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchAbortEvent(
      registration) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchClickEvent(
      registration) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchFailEvent(
      registration) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchSuccessEvent(
      registration) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CookieChangeInfo } change
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCookieChangeEvent(
      change) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
        [
          change
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DispatchFetchEventParams } params
   * @param { !blink.mojom.ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForMainResource(
      params,
      responseCallback) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
        [
          params,
          responseCallback
        ],
        false);
  }

  
  /**
   * @param { !string } notificationId
   * @param { !blink.mojom.NotificationData } notificationData
   * @param { !number } actionIndex
   * @param { ?mojoBase.mojom.String16 } reply
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationClickEvent(
      notificationId,
      notificationData,
      actionIndex,
      reply) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
        [
          notificationId,
          notificationData,
          actionIndex,
          reply
        ],
        false);
  }

  
  /**
   * @param { !string } notificationId
   * @param { !blink.mojom.NotificationData } notificationData
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationCloseEvent(
      notificationId,
      notificationData) {
    return this.proxy.sendMessage(
        10,
        blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
        [
          notificationId,
          notificationData
        ],
        false);
  }

  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushEvent(
      payload) {
    return this.proxy.sendMessage(
        11,
        blink.mojom.ServiceWorker_DispatchPushEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
        [
          payload
        ],
        false);
  }

  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
        requestedUrls: ?Array<!url.mojom.Url>,
   *  }>}
   */

  dispatchPushEventRecordingNetworkRequests(
      payload) {
    return this.proxy.sendMessage(
        12,
        blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
        [
          payload
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.PushSubscription } oldSubscription
   * @param { ?blink.mojom.PushSubscription } newSubscription
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushSubscriptionChangeEvent(
      oldSubscription,
      newSubscription) {
    return this.proxy.sendMessage(
        13,
        blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
        [
          oldSubscription,
          newSubscription
        ],
        false);
  }

  
  /**
   * @param { !string } tag
   * @param { !boolean } lastChance
   * @param { !mojoBase.mojom.TimeDelta } timeout
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchSyncEvent(
      tag,
      lastChance,
      timeout) {
    return this.proxy.sendMessage(
        14,
        blink.mojom.ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
        [
          tag,
          lastChance,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !string } tag
   * @param { !mojoBase.mojom.TimeDelta } timeout
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPeriodicSyncEvent(
      tag,
      timeout) {
    return this.proxy.sendMessage(
        15,
        blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
        [
          tag,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentHandlerResponseCallbackRemote } resultOfAbortPayment
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchAbortPaymentEvent(
      resultOfAbortPayment) {
    return this.proxy.sendMessage(
        16,
        blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
        [
          resultOfAbortPayment
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.CanMakePaymentEventData } eventData
   * @param { !payments.mojom.PaymentHandlerResponseCallbackRemote } resultOfCanMakePayment
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCanMakePaymentEvent(
      eventData,
      resultOfCanMakePayment) {
    return this.proxy.sendMessage(
        17,
        blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
        [
          eventData,
          resultOfCanMakePayment
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentRequestEventData } requestData
   * @param { !payments.mojom.PaymentHandlerResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPaymentRequestEvent(
      requestData,
      responseCallback) {
    return this.proxy.sendMessage(
        18,
        blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
        [
          requestData,
          responseCallback
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ExtendableMessageEvent } event
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchExtendableMessageEvent(
      event) {
    return this.proxy.sendMessage(
        19,
        blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
        [
          event
        ],
        false);
  }

  
  /**
   * @param { !string } id
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchContentDeleteEvent(
      id) {
    return this.proxy.sendMessage(
        20,
        blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  ping() {
    return this.proxy.sendMessage(
        21,
        blink.mojom.ServiceWorker_Ping_ParamsSpec.$,
        blink.mojom.ServiceWorker_Ping_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } delay
   */

  setIdleDelay(
      delay) {
    this.proxy.sendMessage(
        22,
        blink.mojom.ServiceWorker_SetIdleDelay_ParamsSpec.$,
        null,
        [
          delay
        ],
        false);
  }

  
  /**
   */

  addKeepAlive() {
    this.proxy.sendMessage(
        23,
        blink.mojom.ServiceWorker_AddKeepAlive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  clearKeepAlive() {
    this.proxy.sendMessage(
        24,
        blink.mojom.ServiceWorker_ClearKeepAlive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ConsoleMessageLevel } level
   * @param { !string } message
   */

  addMessageToConsole(
      level,
      message) {
    this.proxy.sendMessage(
        25,
        blink.mojom.ServiceWorker_AddMessageToConsole_ParamsSpec.$,
        null,
        [
          level,
          message
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } javascript
   * @param { !boolean } wantsResult
   * @return {!Promise<{
        result: !mojoBase.mojom.Value,
        error: ?string,
   *  }>}
   */

  executeScriptForTest(
      javascript,
      wantsResult) {
    return this.proxy.sendMessage(
        26,
        blink.mojom.ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
        blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
        [
          javascript,
          wantsResult
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
        null,
        impl.initializeGlobalScope.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
        impl.dispatchInstallEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
        impl.dispatchActivateEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchAbortEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchClickEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchFailEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchSuccessEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
        impl.dispatchCookieChangeEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
        impl.dispatchFetchEventForMainResource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
        impl.dispatchNotificationClickEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
        impl.dispatchNotificationCloseEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.ServiceWorker_DispatchPushEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
        impl.dispatchPushEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
        impl.dispatchPushEventRecordingNetworkRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
        impl.dispatchPushSubscriptionChangeEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
        impl.dispatchSyncEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
        impl.dispatchPeriodicSyncEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
        impl.dispatchAbortPaymentEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
        impl.dispatchCanMakePaymentEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
        impl.dispatchPaymentRequestEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
        impl.dispatchExtendableMessageEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
        impl.dispatchContentDeleteEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        blink.mojom.ServiceWorker_Ping_ParamsSpec.$,
        blink.mojom.ServiceWorker_Ping_ResponseParamsSpec.$,
        impl.ping.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        blink.mojom.ServiceWorker_SetIdleDelay_ParamsSpec.$,
        null,
        impl.setIdleDelay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        blink.mojom.ServiceWorker_AddKeepAlive_ParamsSpec.$,
        null,
        impl.addKeepAlive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        blink.mojom.ServiceWorker_ClearKeepAlive_ParamsSpec.$,
        null,
        impl.clearKeepAlive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        blink.mojom.ServiceWorker_AddMessageToConsole_ParamsSpec.$,
        null,
        impl.addMessageToConsole.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        blink.mojom.ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
        blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
        impl.executeScriptForTest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeGlobalScope =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
        null,
        this.initializeGlobalScope.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchInstallEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
        this.dispatchInstallEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchActivateEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
        this.dispatchActivateEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchAbortEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchAbortEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchClickEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchClickEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchFailEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchFailEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchSuccessEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchSuccessEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchCookieChangeEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
        this.dispatchCookieChangeEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchFetchEventForMainResource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
        this.dispatchFetchEventForMainResource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNotificationClickEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
        this.dispatchNotificationClickEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNotificationCloseEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
        this.dispatchNotificationCloseEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPushEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.ServiceWorker_DispatchPushEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
        this.dispatchPushEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPushEventRecordingNetworkRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
        this.dispatchPushEventRecordingNetworkRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPushSubscriptionChangeEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
        this.dispatchPushSubscriptionChangeEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchSyncEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
        this.dispatchSyncEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPeriodicSyncEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
        this.dispatchPeriodicSyncEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAbortPaymentEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
        this.dispatchAbortPaymentEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchCanMakePaymentEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
        this.dispatchCanMakePaymentEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPaymentRequestEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
        this.dispatchPaymentRequestEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchExtendableMessageEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
        this.dispatchExtendableMessageEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchContentDeleteEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
        blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
        this.dispatchContentDeleteEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ping =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        blink.mojom.ServiceWorker_Ping_ParamsSpec.$,
        blink.mojom.ServiceWorker_Ping_ResponseParamsSpec.$,
        this.ping.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIdleDelay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        blink.mojom.ServiceWorker_SetIdleDelay_ParamsSpec.$,
        null,
        this.setIdleDelay.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addKeepAlive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        blink.mojom.ServiceWorker_AddKeepAlive_ParamsSpec.$,
        null,
        this.addKeepAlive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearKeepAlive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        blink.mojom.ServiceWorker_ClearKeepAlive_ParamsSpec.$,
        null,
        this.clearKeepAlive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMessageToConsole =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        blink.mojom.ServiceWorker_AddMessageToConsole_ParamsSpec.$,
        null,
        this.addMessageToConsole.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeScriptForTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        blink.mojom.ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
        blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
        this.executeScriptForTest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ExtendableMessageEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ExtendableMessageEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_SetCachedMetadata_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_SetCachedMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_ClearCachedMetadata_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_ClearCachedMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_GetClients_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_GetClients_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_GetClients_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_GetClients_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_GetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_GetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_GetClient_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_GetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_OpenNewTab_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_OpenNewTab_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_PostMessageToClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_PostMessageToClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_FocusClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_FocusClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_FocusClient_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_FocusClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_NavigateClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_NavigateClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_SkipWaiting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_SkipWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_ClaimClients_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_ClaimClients_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_AddRoutes_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_AddRoutes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_InitializeGlobalScope_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_InitializeGlobalScope_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchInstallEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchInstallEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchActivateEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchActivateEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPushEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPushEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchSyncEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchSyncEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_Ping_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_Ping_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_Ping_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_Ping_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_SetIdleDelay_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_SetIdleDelay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_AddKeepAlive_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_AddKeepAlive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_ClearKeepAlive_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_ClearKeepAlive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_AddMessageToConsole_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_AddMessageToConsole_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_ExecuteScriptForTest_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_ExecuteScriptForTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FocusResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FocusResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ExtendableMessageEventSpec.$,
    'ExtendableMessageEvent',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink.mojom.TransferableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceInfoForClient', 16,
        0,
        blink.mojom.ServiceWorkerClientInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceInfoForServiceWorker', 24,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.ExtendableMessageEvent');

/** @record */
blink.mojom.ExtendableMessageEvent = class {
  constructor() {
    /** @export { !blink.mojom.TransferableMessage } */
    this.message;
    /** @export { !url.mojom.Origin } */
    this.sourceOrigin;
    /** @export { (blink.mojom.ServiceWorkerClientInfo|undefined) } */
    this.sourceInfoForClient;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.sourceInfoForServiceWorker;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
    'ServiceWorkerHost_SetCachedMetadata_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerHost_SetCachedMetadata_Params');

/** @record */
blink.mojom.ServiceWorkerHost_SetCachedMetadata_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
    'ServiceWorkerHost_ClearCachedMetadata_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_ClearCachedMetadata_Params');

/** @record */
blink.mojom.ServiceWorkerHost_ClearCachedMetadata_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_GetClients_ParamsSpec.$,
    'ServiceWorkerHost_GetClients_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.ServiceWorkerClientQueryOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_GetClients_Params');

/** @record */
blink.mojom.ServiceWorkerHost_GetClients_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerClientQueryOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
    'ServiceWorkerHost_GetClients_ResponseParams',
    [
      mojo.internal.StructField(
        'clients', 0,
        0,
        mojo.internal.Array(blink.mojom.ServiceWorkerClientInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_GetClients_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_GetClients_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.ServiceWorkerClientInfo> } */
    this.clients;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_GetClient_ParamsSpec.$,
    'ServiceWorkerHost_GetClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_GetClient_Params');

/** @record */
blink.mojom.ServiceWorkerHost_GetClient_Params = class {
  constructor() {
    /** @export { !string } */
    this.clientUuid;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
    'ServiceWorkerHost_GetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        blink.mojom.ServiceWorkerClientInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_GetClient_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_GetClient_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.ServiceWorkerClientInfo|undefined) } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
    'ServiceWorkerHost_OpenNewTab_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_OpenNewTab_Params');

/** @record */
blink.mojom.ServiceWorkerHost_OpenNewTab_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
    'ServiceWorkerHost_OpenNewTab_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        blink.mojom.ServiceWorkerClientInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_OpenNewTab_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { (blink.mojom.ServiceWorkerClientInfo|undefined) } */
    this.client;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
    'ServiceWorkerHost_OpenPaymentHandlerWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_Params');

/** @record */
blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
    'ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        blink.mojom.ServiceWorkerClientInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { (blink.mojom.ServiceWorkerClientInfo|undefined) } */
    this.client;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
    'ServiceWorkerHost_PostMessageToClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        blink.mojom.TransferableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerHost_PostMessageToClient_Params');

/** @record */
blink.mojom.ServiceWorkerHost_PostMessageToClient_Params = class {
  constructor() {
    /** @export { !string } */
    this.clientUuid;
    /** @export { !blink.mojom.TransferableMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_FocusClient_ParamsSpec.$,
    'ServiceWorkerHost_FocusClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_FocusClient_Params');

/** @record */
blink.mojom.ServiceWorkerHost_FocusClient_Params = class {
  constructor() {
    /** @export { !string } */
    this.clientUuid;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
    'ServiceWorkerHost_FocusClient_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FocusResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerHost_FocusClient_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_FocusClient_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FocusResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_NavigateClient_ParamsSpec.$,
    'ServiceWorkerHost_NavigateClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerHost_NavigateClient_Params');

/** @record */
blink.mojom.ServiceWorkerHost_NavigateClient_Params = class {
  constructor() {
    /** @export { !string } */
    this.clientUuid;
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
    'ServiceWorkerHost_NavigateClient_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        blink.mojom.ServiceWorkerClientInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_NavigateClient_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { (blink.mojom.ServiceWorkerClientInfo|undefined) } */
    this.client;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
    'ServiceWorkerHost_SkipWaiting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerHost_SkipWaiting_Params');

/** @record */
blink.mojom.ServiceWorkerHost_SkipWaiting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
    'ServiceWorkerHost_SkipWaiting_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_SkipWaiting_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_ClaimClients_ParamsSpec.$,
    'ServiceWorkerHost_ClaimClients_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerHost_ClaimClients_Params');

/** @record */
blink.mojom.ServiceWorkerHost_ClaimClients_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
    'ServiceWorkerHost_ClaimClients_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_ClaimClients_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_AddRoutes_ParamsSpec.$,
    'ServiceWorkerHost_AddRoutes_Params',
    [
      mojo.internal.StructField(
        'rules', 0,
        0,
        blink.mojom.ServiceWorkerRouterRulesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_AddRoutes_Params');

/** @record */
blink.mojom.ServiceWorkerHost_AddRoutes_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerRouterRules } */
    this.rules;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
    'ServiceWorkerHost_AddRoutes_ResponseParams',
    [
      mojo.internal.StructField(
        'isParseError', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerHost_AddRoutes_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.isParseError;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
    'ServiceWorker_InitializeGlobalScope_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerHost', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.ServiceWorkerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'associatedInterfacesToBrowser', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.AssociatedInterfaceProviderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'associatedInterfacesFromBrowser', 16,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.AssociatedInterfaceProviderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registrationInfo', 24,
        0,
        blink.mojom.ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerInfo', 32,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchHandlerExistence', 20,
        0,
        blink.mojom.FetchHandlerExistenceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ancestorFrameType', 40,
        0,
        blink.mojom.AncestorFrameTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageKey', 48,
        0,
        blink.mojom.StorageKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('blink.mojom.ServiceWorker_InitializeGlobalScope_Params');

/** @record */
blink.mojom.ServiceWorker_InitializeGlobalScope_Params = class {
  constructor() {
    /** @export { !Object } */
    this.serviceWorkerHost;
    /** @export { !Object } */
    this.associatedInterfacesToBrowser;
    /** @export { !Object } */
    this.associatedInterfacesFromBrowser;
    /** @export { !blink.mojom.ServiceWorkerRegistrationObjectInfo } */
    this.registrationInfo;
    /** @export { !blink.mojom.ServiceWorkerObjectInfo } */
    this.serviceWorkerInfo;
    /** @export { !blink.mojom.FetchHandlerExistence } */
    this.fetchHandlerExistence;
    /** @export { !blink.mojom.AncestorFrameType } */
    this.ancestorFrameType;
    /** @export { !blink.mojom.StorageKey } */
    this.storageKey;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
    'ServiceWorker_DispatchInstallEvent_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorker_DispatchInstallEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchInstallEvent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchInstallEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchCount', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchInstallEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
    /** @export { !number } */
    this.fetchCount;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
    'ServiceWorker_DispatchActivateEvent_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorker_DispatchActivateEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchActivateEvent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchActivateEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchActivateEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchAbortEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink.mojom.BackgroundFetchRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchRegistration } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchClickEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink.mojom.BackgroundFetchRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchRegistration } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchFailEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink.mojom.BackgroundFetchRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchRegistration } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink.mojom.BackgroundFetchRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchRegistration } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
    'ServiceWorker_DispatchCookieChangeEvent_Params',
    [
      mojo.internal.StructField(
        'change', 0,
        0,
        network.mojom.CookieChangeInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchCookieChangeEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchCookieChangeEvent_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieChangeInfo } */
    this.change;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchCookieChangeEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchCookieChangeEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
    'ServiceWorker_DispatchFetchEventForMainResource_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.DispatchFetchEventParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseCallback', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ServiceWorkerFetchResponseCallbackRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_Params = class {
  constructor() {
    /** @export { !blink.mojom.DispatchFetchEventParams } */
    this.params;
    /** @export { !blink.mojom.ServiceWorkerFetchResponseCallbackRemote } */
    this.responseCallback;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
    'ServiceWorker_DispatchFetchEventForMainResource_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchFetchEventForMainResource_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
    'ServiceWorker_DispatchNotificationClickEvent_Params',
    [
      mojo.internal.StructField(
        'notificationId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink.mojom.NotificationDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actionIndex', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reply', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.ServiceWorker_DispatchNotificationClickEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchNotificationClickEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.notificationId;
    /** @export { !blink.mojom.NotificationData } */
    this.notificationData;
    /** @export { !number } */
    this.actionIndex;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.reply;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchNotificationClickEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchNotificationClickEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
    'ServiceWorker_DispatchNotificationCloseEvent_Params',
    [
      mojo.internal.StructField(
        'notificationId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink.mojom.NotificationDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.notificationId;
    /** @export { !blink.mojom.NotificationData } */
    this.notificationData;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchNotificationCloseEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchNotificationCloseEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPushEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPushEvent_Params',
    [
      mojo.internal.StructField(
        'payload', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPushEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchPushEvent_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.payload;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPushEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchPushEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
    'ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params',
    [
      mojo.internal.StructField(
        'payload', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.payload;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestedUrls', 8,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
    /** @export { (Array<!url.mojom.Url>|undefined) } */
    this.requestedUrls;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPushSubscriptionChangeEvent_Params',
    [
      mojo.internal.StructField(
        'oldSubscription', 0,
        0,
        blink.mojom.PushSubscriptionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newSubscription', 8,
        0,
        blink.mojom.PushSubscriptionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_Params = class {
  constructor() {
    /** @export { (blink.mojom.PushSubscription|undefined) } */
    this.oldSubscription;
    /** @export { (blink.mojom.PushSubscription|undefined) } */
    this.newSubscription;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
    'ServiceWorker_DispatchSyncEvent_Params',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastChance', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorker_DispatchSyncEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchSyncEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.tag;
    /** @export { !boolean } */
    this.lastChance;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timeout;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchSyncEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchSyncEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPeriodicSyncEvent_Params',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.tag;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timeout;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
    'ServiceWorker_DispatchAbortPaymentEvent_Params',
    [
      mojo.internal.StructField(
        'resultOfAbortPayment', 0,
        0,
        mojo.internal.InterfaceProxy(payments.mojom.PaymentHandlerResponseCallbackRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerResponseCallbackRemote } */
    this.resultOfAbortPayment;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchAbortPaymentEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchAbortPaymentEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
    'ServiceWorker_DispatchCanMakePaymentEvent_Params',
    [
      mojo.internal.StructField(
        'eventData', 0,
        0,
        payments.mojom.CanMakePaymentEventDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultOfCanMakePayment', 8,
        0,
        mojo.internal.InterfaceProxy(payments.mojom.PaymentHandlerResponseCallbackRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_Params = class {
  constructor() {
    /** @export { !payments.mojom.CanMakePaymentEventData } */
    this.eventData;
    /** @export { !payments.mojom.PaymentHandlerResponseCallbackRemote } */
    this.resultOfCanMakePayment;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPaymentRequestEvent_Params',
    [
      mojo.internal.StructField(
        'requestData', 0,
        0,
        payments.mojom.PaymentRequestEventDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseCallback', 8,
        0,
        mojo.internal.InterfaceProxy(payments.mojom.PaymentHandlerResponseCallbackRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentRequestEventData } */
    this.requestData;
    /** @export { !payments.mojom.PaymentHandlerResponseCallbackRemote } */
    this.responseCallback;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPaymentRequestEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchPaymentRequestEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
    'ServiceWorker_DispatchExtendableMessageEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        blink.mojom.ExtendableMessageEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.ExtendableMessageEvent } */
    this.event;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchExtendableMessageEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchExtendableMessageEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
    'ServiceWorker_DispatchContentDeleteEvent_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchContentDeleteEvent_Params');

/** @record */
blink.mojom.ServiceWorker_DispatchContentDeleteEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchContentDeleteEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_DispatchContentDeleteEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_Ping_ParamsSpec.$,
    'ServiceWorker_Ping_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorker_Ping_Params');

/** @record */
blink.mojom.ServiceWorker_Ping_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_Ping_ResponseParamsSpec.$,
    'ServiceWorker_Ping_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorker_Ping_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_Ping_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_SetIdleDelay_ParamsSpec.$,
    'ServiceWorker_SetIdleDelay_Params',
    [
      mojo.internal.StructField(
        'delay', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorker_SetIdleDelay_Params');

/** @record */
blink.mojom.ServiceWorker_SetIdleDelay_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.delay;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_AddKeepAlive_ParamsSpec.$,
    'ServiceWorker_AddKeepAlive_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorker_AddKeepAlive_Params');

/** @record */
blink.mojom.ServiceWorker_AddKeepAlive_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_ClearKeepAlive_ParamsSpec.$,
    'ServiceWorker_ClearKeepAlive_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorker_ClearKeepAlive_Params');

/** @record */
blink.mojom.ServiceWorker_ClearKeepAlive_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_AddMessageToConsole_ParamsSpec.$,
    'ServiceWorker_AddMessageToConsole_Params',
    [
      mojo.internal.StructField(
        'level', 0,
        0,
        blink.mojom.ConsoleMessageLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_AddMessageToConsole_Params');

/** @record */
blink.mojom.ServiceWorker_AddMessageToConsole_Params = class {
  constructor() {
    /** @export { !blink.mojom.ConsoleMessageLevel } */
    this.level;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
    'ServiceWorker_ExecuteScriptForTest_Params',
    [
      mojo.internal.StructField(
        'javascript', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wantsResult', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorker_ExecuteScriptForTest_Params');

/** @record */
blink.mojom.ServiceWorker_ExecuteScriptForTest_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.javascript;
    /** @export { !boolean } */
    this.wantsResult;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
    'ServiceWorker_ExecuteScriptForTest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParams');

/** @record */
blink.mojom.ServiceWorker_ExecuteScriptForTest_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Value } */
    this.result;
    /** @export { (string|undefined) } */
    this.error;
  }
};

goog.provide('blink.mojom.FocusResult');


mojo.internal.Union(
    blink.mojom.FocusResultSpec.$, 'FocusResult',
    {
      'client': {
        'ordinal': 0,
        'type': blink.mojom.ServiceWorkerClientInfoSpec.$,
      },
      'errorCode': {
        'ordinal': 1,
        'type': blink.mojom.FocusErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   client: (!blink.mojom.ServiceWorkerClientInfo|undefined),
 *   errorCode: (!blink.mojom.FocusError|undefined),
 * } }
 */
blink.mojom.FocusResult;
