// third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var script_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/script/script_type.mojom', '../script/script_type.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var ServiceWorkerUpdateViaCache = {};
  ServiceWorkerUpdateViaCache.kImports = 0;
  ServiceWorkerUpdateViaCache.kAll = 1;
  ServiceWorkerUpdateViaCache.kNone = 2;
  ServiceWorkerUpdateViaCache.MIN_VALUE = 0;
  ServiceWorkerUpdateViaCache.MAX_VALUE = 2;

  ServiceWorkerUpdateViaCache.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ServiceWorkerUpdateViaCache.toKnownEnumValue = function(value) {
    return value;
  };

  ServiceWorkerUpdateViaCache.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ServiceWorkerRegistrationOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationOptions.prototype.initDefaults_ = function() {
    this.scope = null;
    this.type = script_type$.ScriptType.kClassic;
    this.updateViaCache = ServiceWorkerUpdateViaCache.kImports;
  };
  ServiceWorkerRegistrationOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationOptions.scope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationOptions.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, script_type$.ScriptType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationOptions.updateViaCache
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ServiceWorkerUpdateViaCache);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationOptions.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerRegistrationOptions.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scope =
        decoder.decodeStructPointer(url$.Url);
    val.type =
        decoder.decodeStruct(new codec.Enum(script_type$.ScriptType));
    val.updateViaCache =
        decoder.decodeStruct(new codec.Enum(ServiceWorkerUpdateViaCache));
    return val;
  };

  ServiceWorkerRegistrationOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.scope);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.updateViaCache);
  };
  exports.ServiceWorkerUpdateViaCache = ServiceWorkerUpdateViaCache;
  exports.ServiceWorkerRegistrationOptions = ServiceWorkerRegistrationOptions;
})();