// third_party/blink/public/mojom/shared_storage/shared_storage.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/shared_storage/shared_storage.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var shared_storage$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_storage.mojom', '../../../../../services/network/public/mojom/shared_storage.mojom.js');
  }
  var fenced_frame_config$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom', '../fenced_frame/fenced_frame_config.mojom.js');
  }
  var cloneable_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/cloneable_message.mojom', '../messaging/cloneable_message.mojom.js');
  }
  var origin_trial_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom', '../origin_trials/origin_trial_feature.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var SharedStorageGetStatus = {};
  SharedStorageGetStatus.kSuccess = 0;
  SharedStorageGetStatus.kNotFound = 1;
  SharedStorageGetStatus.kError = 2;
  SharedStorageGetStatus.MIN_VALUE = 0;
  SharedStorageGetStatus.MAX_VALUE = 2;

  SharedStorageGetStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SharedStorageGetStatus.toKnownEnumValue = function(value) {
    return value;
  };

  SharedStorageGetStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SharedStorageWorkletCreationMethod = {};
  SharedStorageWorkletCreationMethod.kAddModule = 0;
  SharedStorageWorkletCreationMethod.kCreateWorklet = 1;
  SharedStorageWorkletCreationMethod.MIN_VALUE = 0;
  SharedStorageWorkletCreationMethod.MAX_VALUE = 1;

  SharedStorageWorkletCreationMethod.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SharedStorageWorkletCreationMethod.toKnownEnumValue = function(value) {
    return value;
  };

  SharedStorageWorkletCreationMethod.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SharedStorageDataOriginType = {};
  SharedStorageDataOriginType.kContextOrigin = 0;
  SharedStorageDataOriginType.kScriptOrigin = 1;
  SharedStorageDataOriginType.kCustomOrigin = 2;
  SharedStorageDataOriginType.MIN_VALUE = 0;
  SharedStorageDataOriginType.MAX_VALUE = 2;

  SharedStorageDataOriginType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SharedStorageDataOriginType.toKnownEnumValue = function(value) {
    return value;
  };

  SharedStorageDataOriginType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SharedStorageUrlWithMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageUrlWithMetadata.prototype.initDefaults_ = function() {
    this.url = null;
    this.reportingMetadata = null;
  };
  SharedStorageUrlWithMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageUrlWithMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageUrlWithMetadata.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageUrlWithMetadata.reportingMetadata
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, new codec.PointerTo(url$.Url), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageUrlWithMetadata.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageUrlWithMetadata.decode = function(decoder) {
    var packed;
    var val = new SharedStorageUrlWithMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.reportingMetadata =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(url$.Url));
    return val;
  };

  SharedStorageUrlWithMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageUrlWithMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(url$.Url), val.reportingMetadata);
  };
  function PrivateAggregationConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrivateAggregationConfig.prototype.initDefaults_ = function() {
    this.aggregationCoordinatorOrigin = null;
    this.contextId = null;
    this.filteringIdMaxBytes = 0;
    this.max_contributions_$flag = false;
    this.max_contributions_$value = 0;
  };
  PrivateAggregationConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrivateAggregationConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationConfig.aggregationCoordinatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationConfig.contextId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  PrivateAggregationConfig.encodedSize = codec.kStructHeaderSize + 24;

  PrivateAggregationConfig.decode = function(decoder) {
    var packed;
    var val = new PrivateAggregationConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.aggregationCoordinatorOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.contextId =
        decoder.decodeStruct(codec.String);
    val.filteringIdMaxBytes =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.max_contributions_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.max_contributions_$value =
        decoder.decodeStruct(codec.Uint16);
    return val;
  };

  PrivateAggregationConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrivateAggregationConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.aggregationCoordinatorOrigin);
    encoder.encodeStruct(codec.String, val.contextId);
    encoder.encodeStruct(codec.Uint32, val.filteringIdMaxBytes);
    packed = 0;
    packed |= (val.max_contributions_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.max_contributions_$value);
  };
  function SharedStorageWorkletHost_SelectURL_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletHost_SelectURL_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.urlsWithMetadata = null;
    this.serializedData = null;
    this.keepAliveAfterOperation = false;
    this.resolveToConfig = false;
    this.privateAggregationConfig = null;
    this.savedQueryName = null;
    this.startTime = null;
  };
  SharedStorageWorkletHost_SelectURL_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletHost_SelectURL_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_SelectURL_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_SelectURL_Params.urlsWithMetadata
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SharedStorageUrlWithMetadata), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_SelectURL_Params.serializedData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, cloneable_message$.CloneableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletHost_SelectURL_Params.privateAggregationConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, PrivateAggregationConfig, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletHost_SelectURL_Params.savedQueryName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_SelectURL_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletHost_SelectURL_Params.encodedSize = codec.kStructHeaderSize + 56;

  SharedStorageWorkletHost_SelectURL_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletHost_SelectURL_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.urlsWithMetadata =
        decoder.decodeArrayPointer(new codec.PointerTo(SharedStorageUrlWithMetadata));
    val.serializedData =
        decoder.decodeStructPointer(cloneable_message$.CloneableMessage);
    packed = decoder.readUint8();
    val.keepAliveAfterOperation = (packed >> 0) & 1 ? true : false;
    val.resolveToConfig = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.privateAggregationConfig =
        decoder.decodeStructPointer(PrivateAggregationConfig);
    val.savedQueryName =
        decoder.decodeStructPointer(string16$.String16);
    val.startTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  SharedStorageWorkletHost_SelectURL_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletHost_SelectURL_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeArrayPointer(new codec.PointerTo(SharedStorageUrlWithMetadata), val.urlsWithMetadata);
    encoder.encodeStructPointer(cloneable_message$.CloneableMessage, val.serializedData);
    packed = 0;
    packed |= (val.keepAliveAfterOperation & 1) << 0
    packed |= (val.resolveToConfig & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(PrivateAggregationConfig, val.privateAggregationConfig);
    encoder.encodeStructPointer(string16$.String16, val.savedQueryName);
    encoder.encodeStructPointer(time$.TimeTicks, val.startTime);
  };
  function SharedStorageWorkletHost_SelectURL_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletHost_SelectURL_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.errorMessage = null;
    this.config = null;
  };
  SharedStorageWorkletHost_SelectURL_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletHost_SelectURL_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletHost_SelectURL_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_SelectURL_ResponseParams.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, fenced_frame_config$.FencedFrameConfig, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletHost_SelectURL_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageWorkletHost_SelectURL_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletHost_SelectURL_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.config =
        decoder.decodeStructPointer(fenced_frame_config$.FencedFrameConfig);
    return val;
  };

  SharedStorageWorkletHost_SelectURL_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletHost_SelectURL_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeStructPointer(fenced_frame_config$.FencedFrameConfig, val.config);
  };
  function SharedStorageWorkletHost_Run_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletHost_Run_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.serializedData = null;
    this.keepAliveAfterOperation = false;
    this.privateAggregationConfig = null;
    this.startTime = null;
  };
  SharedStorageWorkletHost_Run_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletHost_Run_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_Run_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_Run_Params.serializedData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, cloneable_message$.CloneableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletHost_Run_Params.privateAggregationConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, PrivateAggregationConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletHost_Run_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletHost_Run_Params.encodedSize = codec.kStructHeaderSize + 40;

  SharedStorageWorkletHost_Run_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletHost_Run_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.serializedData =
        decoder.decodeStructPointer(cloneable_message$.CloneableMessage);
    packed = decoder.readUint8();
    val.keepAliveAfterOperation = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.privateAggregationConfig =
        decoder.decodeStructPointer(PrivateAggregationConfig);
    val.startTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  SharedStorageWorkletHost_Run_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletHost_Run_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(cloneable_message$.CloneableMessage, val.serializedData);
    packed = 0;
    packed |= (val.keepAliveAfterOperation & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(PrivateAggregationConfig, val.privateAggregationConfig);
    encoder.encodeStructPointer(time$.TimeTicks, val.startTime);
  };
  function SharedStorageWorkletHost_Run_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletHost_Run_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.errorMessage = null;
  };
  SharedStorageWorkletHost_Run_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletHost_Run_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletHost_Run_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletHost_Run_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletHost_Run_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletHost_Run_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletHost_Run_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletHost_Run_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageDocumentService_CreateWorklet_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_CreateWorklet_Params.prototype.initDefaults_ = function() {
    this.scriptSourceUrl = null;
    this.dataOrigin = null;
    this.dataOriginType = 0;
    this.credentialsMode = 0;
    this.creationMethod = 0;
    this.workletHost = new associatedBindings.AssociatedInterfaceRequest();
    this.originTrialFeatures = null;
  };
  SharedStorageDocumentService_CreateWorklet_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_CreateWorklet_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.scriptSourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.dataOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.dataOriginType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, SharedStorageDataOriginType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.credentialsMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, fetch_api$.CredentialsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.creationMethod
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, SharedStorageWorkletCreationMethod);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.originTrialFeatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 4, new codec.Enum(origin_trial_feature$.OriginTrialFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_CreateWorklet_Params.workletHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 28, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_CreateWorklet_Params.encodedSize = codec.kStructHeaderSize + 40;

  SharedStorageDocumentService_CreateWorklet_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_CreateWorklet_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scriptSourceUrl =
        decoder.decodeStructPointer(url$.Url);
    val.dataOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.dataOriginType =
        decoder.decodeStruct(new codec.Enum(SharedStorageDataOriginType));
    val.credentialsMode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.CredentialsMode));
    val.creationMethod =
        decoder.decodeStruct(new codec.Enum(SharedStorageWorkletCreationMethod));
    val.workletHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.originTrialFeatures =
        decoder.decodeArrayPointer(new codec.Enum(origin_trial_feature$.OriginTrialFeature));
    return val;
  };

  SharedStorageDocumentService_CreateWorklet_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_CreateWorklet_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.scriptSourceUrl);
    encoder.encodeStructPointer(origin$.Origin, val.dataOrigin);
    encoder.encodeStruct(codec.Int32, val.dataOriginType);
    encoder.encodeStruct(codec.Int32, val.credentialsMode);
    encoder.encodeStruct(codec.Int32, val.creationMethod);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.workletHost);
    encoder.encodeArrayPointer(new codec.Enum(origin_trial_feature$.OriginTrialFeature), val.originTrialFeatures);
  };
  function SharedStorageDocumentService_CreateWorklet_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_CreateWorklet_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.errorMessage = null;
  };
  SharedStorageDocumentService_CreateWorklet_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_CreateWorklet_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageDocumentService_CreateWorklet_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_CreateWorklet_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageDocumentService_CreateWorklet_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_CreateWorklet_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageDocumentService_CreateWorklet_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_CreateWorklet_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageDocumentService_SharedStorageGet_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_SharedStorageGet_Params.prototype.initDefaults_ = function() {
    this.key = null;
  };
  SharedStorageDocumentService_SharedStorageGet_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_SharedStorageGet_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageGet_Params.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_storage$.SharedStorageKeyArgument, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_SharedStorageGet_Params.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageDocumentService_SharedStorageGet_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_SharedStorageGet_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(shared_storage$.SharedStorageKeyArgument);
    return val;
  };

  SharedStorageDocumentService_SharedStorageGet_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_SharedStorageGet_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_storage$.SharedStorageKeyArgument, val.key);
  };
  function SharedStorageDocumentService_SharedStorageGet_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_SharedStorageGet_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.errorMessage = null;
    this.value = null;
  };
  SharedStorageDocumentService_SharedStorageGet_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_SharedStorageGet_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageGet_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SharedStorageGetStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageGet_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageGet_ResponseParams.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_SharedStorageGet_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageDocumentService_SharedStorageGet_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_SharedStorageGet_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(SharedStorageGetStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  SharedStorageDocumentService_SharedStorageGet_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_SharedStorageGet_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeStructPointer(string16$.String16, val.value);
  };
  function SharedStorageDocumentService_SharedStorageUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_SharedStorageUpdate_Params.prototype.initDefaults_ = function() {
    this.methodWithOptions = null;
  };
  SharedStorageDocumentService_SharedStorageUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_SharedStorageUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageUpdate_Params.methodWithOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_storage$.SharedStorageModifierMethodWithOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_SharedStorageUpdate_Params.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageDocumentService_SharedStorageUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_SharedStorageUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.methodWithOptions =
        decoder.decodeStructPointer(shared_storage$.SharedStorageModifierMethodWithOptions);
    return val;
  };

  SharedStorageDocumentService_SharedStorageUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_SharedStorageUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_storage$.SharedStorageModifierMethodWithOptions, val.methodWithOptions);
  };
  function SharedStorageDocumentService_SharedStorageUpdate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.prototype.initDefaults_ = function() {
    this.errorMessage = null;
  };
  SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_SharedStorageUpdate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageDocumentService_SharedStorageBatchUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_SharedStorageBatchUpdate_Params.prototype.initDefaults_ = function() {
    this.methodsWithOptions = null;
    this.withLock = null;
  };
  SharedStorageDocumentService_SharedStorageBatchUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_SharedStorageBatchUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageBatchUpdate_Params.methodsWithOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_storage$.SharedStorageBatchUpdateMethodsArgument, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageBatchUpdate_Params.withLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_storage$.LockName, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_SharedStorageBatchUpdate_Params.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageDocumentService_SharedStorageBatchUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_SharedStorageBatchUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.methodsWithOptions =
        decoder.decodeStructPointer(shared_storage$.SharedStorageBatchUpdateMethodsArgument);
    val.withLock =
        decoder.decodeStructPointer(shared_storage$.LockName);
    return val;
  };

  SharedStorageDocumentService_SharedStorageBatchUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_SharedStorageBatchUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_storage$.SharedStorageBatchUpdateMethodsArgument, val.methodsWithOptions);
    encoder.encodeStructPointer(shared_storage$.LockName, val.withLock);
  };
  function SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.prototype.initDefaults_ = function() {
    this.errorMessage = null;
  };
  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  var kSharedStorageWorkletHost_SelectURL_Name = 0;
  var kSharedStorageWorkletHost_Run_Name = 1;

  function SharedStorageWorkletHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedStorageWorkletHost,
                                                   handleOrPtrInfo);
  }

  function SharedStorageWorkletHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedStorageWorkletHost, associatedInterfacePtrInfo);
  }

  SharedStorageWorkletHostAssociatedPtr.prototype =
      Object.create(SharedStorageWorkletHostPtr.prototype);
  SharedStorageWorkletHostAssociatedPtr.prototype.constructor =
      SharedStorageWorkletHostAssociatedPtr;

  function SharedStorageWorkletHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedStorageWorkletHostPtr.prototype.selectURL = function() {
    return SharedStorageWorkletHostProxy.prototype.selectURL
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletHostProxy.prototype.selectURL = function(name, urlsWithMetadata, serializedData, keepAliveAfterOperation, privateAggregationConfig, resolveToConfig, savedQueryName, startTime) {
    var params_ = new SharedStorageWorkletHost_SelectURL_Params();
    params_.name = name;
    params_.urlsWithMetadata = urlsWithMetadata;
    params_.serializedData = serializedData;
    params_.keepAliveAfterOperation = keepAliveAfterOperation;
    params_.privateAggregationConfig = privateAggregationConfig;
    params_.resolveToConfig = resolveToConfig;
    params_.savedQueryName = savedQueryName;
    params_.startTime = startTime;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletHost_SelectURL_Name,
          codec.align(SharedStorageWorkletHost_SelectURL_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletHost_SelectURL_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletHost_SelectURL_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletHostPtr.prototype.run = function() {
    return SharedStorageWorkletHostProxy.prototype.run
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletHostProxy.prototype.run = function(name, serializedData, keepAliveAfterOperation, privateAggregationConfig, startTime) {
    var params_ = new SharedStorageWorkletHost_Run_Params();
    params_.name = name;
    params_.serializedData = serializedData;
    params_.keepAliveAfterOperation = keepAliveAfterOperation;
    params_.privateAggregationConfig = privateAggregationConfig;
    params_.startTime = startTime;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletHost_Run_Name,
          codec.align(SharedStorageWorkletHost_Run_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletHost_Run_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletHost_Run_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SharedStorageWorkletHostStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedStorageWorkletHostStub.prototype.selectURL = function(name, urlsWithMetadata, serializedData, keepAliveAfterOperation, privateAggregationConfig, resolveToConfig, savedQueryName, startTime) {
    return this.delegate_ && this.delegate_.selectURL && this.delegate_.selectURL(name, urlsWithMetadata, serializedData, keepAliveAfterOperation, privateAggregationConfig, resolveToConfig, savedQueryName, startTime);
  }
  SharedStorageWorkletHostStub.prototype.run = function(name, serializedData, keepAliveAfterOperation, privateAggregationConfig, startTime) {
    return this.delegate_ && this.delegate_.run && this.delegate_.run(name, serializedData, keepAliveAfterOperation, privateAggregationConfig, startTime);
  }

  SharedStorageWorkletHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SharedStorageWorkletHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageWorkletHost_SelectURL_Name:
      var params = reader.decodeStruct(SharedStorageWorkletHost_SelectURL_Params);
      this.selectURL(params.name, params.urlsWithMetadata, params.serializedData, params.keepAliveAfterOperation, params.privateAggregationConfig, params.resolveToConfig, params.savedQueryName, params.startTime).then(function(response) {
        var responseParams =
            new SharedStorageWorkletHost_SelectURL_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        responseParams.config = response.config;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletHost_SelectURL_Name,
            codec.align(SharedStorageWorkletHost_SelectURL_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletHost_SelectURL_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletHost_Run_Name:
      var params = reader.decodeStruct(SharedStorageWorkletHost_Run_Params);
      this.run(params.name, params.serializedData, params.keepAliveAfterOperation, params.privateAggregationConfig, params.startTime).then(function(response) {
        var responseParams =
            new SharedStorageWorkletHost_Run_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletHost_Run_Name,
            codec.align(SharedStorageWorkletHost_Run_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletHost_Run_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSharedStorageWorkletHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedStorageWorkletHost_SelectURL_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletHost_SelectURL_Params;
      break;
      case kSharedStorageWorkletHost_Run_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletHost_Run_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedStorageWorkletHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSharedStorageWorkletHost_SelectURL_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletHost_SelectURL_ResponseParams;
        break;
      case kSharedStorageWorkletHost_Run_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletHost_Run_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SharedStorageWorkletHost = {
    name: 'blink.mojom.SharedStorageWorkletHost',
    kVersion: 0,
    ptrClass: SharedStorageWorkletHostPtr,
    proxyClass: SharedStorageWorkletHostProxy,
    stubClass: SharedStorageWorkletHostStub,
    validateRequest: validateSharedStorageWorkletHostRequest,
    validateResponse: validateSharedStorageWorkletHostResponse,
  };
  SharedStorageWorkletHostStub.prototype.validator = validateSharedStorageWorkletHostRequest;
  SharedStorageWorkletHostProxy.prototype.validator = validateSharedStorageWorkletHostResponse;
  var kSharedStorageDocumentService_CreateWorklet_Name = 0;
  var kSharedStorageDocumentService_SharedStorageGet_Name = 1;
  var kSharedStorageDocumentService_SharedStorageUpdate_Name = 2;
  var kSharedStorageDocumentService_SharedStorageBatchUpdate_Name = 3;

  function SharedStorageDocumentServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedStorageDocumentService,
                                                   handleOrPtrInfo);
  }

  function SharedStorageDocumentServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedStorageDocumentService, associatedInterfacePtrInfo);
  }

  SharedStorageDocumentServiceAssociatedPtr.prototype =
      Object.create(SharedStorageDocumentServicePtr.prototype);
  SharedStorageDocumentServiceAssociatedPtr.prototype.constructor =
      SharedStorageDocumentServiceAssociatedPtr;

  function SharedStorageDocumentServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedStorageDocumentServicePtr.prototype.createWorklet = function() {
    return SharedStorageDocumentServiceProxy.prototype.createWorklet
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageDocumentServiceProxy.prototype.createWorklet = function(scriptSourceUrl, dataOrigin, dataOriginType, credentialsMode, creationMethod, originTrialFeatures, workletHost) {
    var params_ = new SharedStorageDocumentService_CreateWorklet_Params();
    params_.scriptSourceUrl = scriptSourceUrl;
    params_.dataOrigin = dataOrigin;
    params_.dataOriginType = dataOriginType;
    params_.credentialsMode = credentialsMode;
    params_.creationMethod = creationMethod;
    params_.originTrialFeatures = originTrialFeatures;
    params_.workletHost = workletHost;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kSharedStorageDocumentService_CreateWorklet_Name,
          codec.align(SharedStorageDocumentService_CreateWorklet_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(SharedStorageDocumentService_CreateWorklet_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageDocumentService_CreateWorklet_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageDocumentServicePtr.prototype.sharedStorageGet = function() {
    return SharedStorageDocumentServiceProxy.prototype.sharedStorageGet
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageDocumentServiceProxy.prototype.sharedStorageGet = function(key) {
    var params_ = new SharedStorageDocumentService_SharedStorageGet_Params();
    params_.key = key;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageDocumentService_SharedStorageGet_Name,
          codec.align(SharedStorageDocumentService_SharedStorageGet_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageDocumentService_SharedStorageGet_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageDocumentService_SharedStorageGet_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageDocumentServicePtr.prototype.sharedStorageUpdate = function() {
    return SharedStorageDocumentServiceProxy.prototype.sharedStorageUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageDocumentServiceProxy.prototype.sharedStorageUpdate = function(methodWithOptions) {
    var params_ = new SharedStorageDocumentService_SharedStorageUpdate_Params();
    params_.methodWithOptions = methodWithOptions;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageDocumentService_SharedStorageUpdate_Name,
          codec.align(SharedStorageDocumentService_SharedStorageUpdate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageDocumentService_SharedStorageUpdate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageDocumentService_SharedStorageUpdate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageDocumentServicePtr.prototype.sharedStorageBatchUpdate = function() {
    return SharedStorageDocumentServiceProxy.prototype.sharedStorageBatchUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageDocumentServiceProxy.prototype.sharedStorageBatchUpdate = function(methodsWithOptions, withLock) {
    var params_ = new SharedStorageDocumentService_SharedStorageBatchUpdate_Params();
    params_.methodsWithOptions = methodsWithOptions;
    params_.withLock = withLock;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageDocumentService_SharedStorageBatchUpdate_Name,
          codec.align(SharedStorageDocumentService_SharedStorageBatchUpdate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageDocumentService_SharedStorageBatchUpdate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SharedStorageDocumentServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedStorageDocumentServiceStub.prototype.createWorklet = function(scriptSourceUrl, dataOrigin, dataOriginType, credentialsMode, creationMethod, originTrialFeatures, workletHost) {
    return this.delegate_ && this.delegate_.createWorklet && this.delegate_.createWorklet(scriptSourceUrl, dataOrigin, dataOriginType, credentialsMode, creationMethod, originTrialFeatures, workletHost);
  }
  SharedStorageDocumentServiceStub.prototype.sharedStorageGet = function(key) {
    return this.delegate_ && this.delegate_.sharedStorageGet && this.delegate_.sharedStorageGet(key);
  }
  SharedStorageDocumentServiceStub.prototype.sharedStorageUpdate = function(methodWithOptions) {
    return this.delegate_ && this.delegate_.sharedStorageUpdate && this.delegate_.sharedStorageUpdate(methodWithOptions);
  }
  SharedStorageDocumentServiceStub.prototype.sharedStorageBatchUpdate = function(methodsWithOptions, withLock) {
    return this.delegate_ && this.delegate_.sharedStorageBatchUpdate && this.delegate_.sharedStorageBatchUpdate(methodsWithOptions, withLock);
  }

  SharedStorageDocumentServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SharedStorageDocumentServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageDocumentService_CreateWorklet_Name:
      var params = reader.decodeStruct(SharedStorageDocumentService_CreateWorklet_Params);
      this.createWorklet(params.scriptSourceUrl, params.dataOrigin, params.dataOriginType, params.credentialsMode, params.creationMethod, params.originTrialFeatures, params.workletHost).then(function(response) {
        var responseParams =
            new SharedStorageDocumentService_CreateWorklet_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV2Builder(
            kSharedStorageDocumentService_CreateWorklet_Name,
            codec.align(SharedStorageDocumentService_CreateWorklet_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(SharedStorageDocumentService_CreateWorklet_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageDocumentService_SharedStorageGet_Name:
      var params = reader.decodeStruct(SharedStorageDocumentService_SharedStorageGet_Params);
      this.sharedStorageGet(params.key).then(function(response) {
        var responseParams =
            new SharedStorageDocumentService_SharedStorageGet_ResponseParams();
        responseParams.status = response.status;
        responseParams.errorMessage = response.errorMessage;
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kSharedStorageDocumentService_SharedStorageGet_Name,
            codec.align(SharedStorageDocumentService_SharedStorageGet_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageDocumentService_SharedStorageGet_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageDocumentService_SharedStorageUpdate_Name:
      var params = reader.decodeStruct(SharedStorageDocumentService_SharedStorageUpdate_Params);
      this.sharedStorageUpdate(params.methodWithOptions).then(function(response) {
        var responseParams =
            new SharedStorageDocumentService_SharedStorageUpdate_ResponseParams();
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageDocumentService_SharedStorageUpdate_Name,
            codec.align(SharedStorageDocumentService_SharedStorageUpdate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageDocumentService_SharedStorageUpdate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageDocumentService_SharedStorageBatchUpdate_Name:
      var params = reader.decodeStruct(SharedStorageDocumentService_SharedStorageBatchUpdate_Params);
      this.sharedStorageBatchUpdate(params.methodsWithOptions, params.withLock).then(function(response) {
        var responseParams =
            new SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams();
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageDocumentService_SharedStorageBatchUpdate_Name,
            codec.align(SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSharedStorageDocumentServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedStorageDocumentService_CreateWorklet_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageDocumentService_CreateWorklet_Params;
      break;
      case kSharedStorageDocumentService_SharedStorageGet_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageDocumentService_SharedStorageGet_Params;
      break;
      case kSharedStorageDocumentService_SharedStorageUpdate_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageDocumentService_SharedStorageUpdate_Params;
      break;
      case kSharedStorageDocumentService_SharedStorageBatchUpdate_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageDocumentService_SharedStorageBatchUpdate_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedStorageDocumentServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSharedStorageDocumentService_CreateWorklet_Name:
        if (message.isResponse())
          paramsClass = SharedStorageDocumentService_CreateWorklet_ResponseParams;
        break;
      case kSharedStorageDocumentService_SharedStorageGet_Name:
        if (message.isResponse())
          paramsClass = SharedStorageDocumentService_SharedStorageGet_ResponseParams;
        break;
      case kSharedStorageDocumentService_SharedStorageUpdate_Name:
        if (message.isResponse())
          paramsClass = SharedStorageDocumentService_SharedStorageUpdate_ResponseParams;
        break;
      case kSharedStorageDocumentService_SharedStorageBatchUpdate_Name:
        if (message.isResponse())
          paramsClass = SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SharedStorageDocumentService = {
    name: 'blink.mojom.SharedStorageDocumentService',
    kVersion: 0,
    ptrClass: SharedStorageDocumentServicePtr,
    proxyClass: SharedStorageDocumentServiceProxy,
    stubClass: SharedStorageDocumentServiceStub,
    validateRequest: validateSharedStorageDocumentServiceRequest,
    validateResponse: validateSharedStorageDocumentServiceResponse,
  };
  SharedStorageDocumentServiceStub.prototype.validator = validateSharedStorageDocumentServiceRequest;
  SharedStorageDocumentServiceProxy.prototype.validator = validateSharedStorageDocumentServiceResponse;
  exports.SharedStorageGetStatus = SharedStorageGetStatus;
  exports.SharedStorageWorkletCreationMethod = SharedStorageWorkletCreationMethod;
  exports.SharedStorageDataOriginType = SharedStorageDataOriginType;
  exports.SharedStorageUrlWithMetadata = SharedStorageUrlWithMetadata;
  exports.PrivateAggregationConfig = PrivateAggregationConfig;
  exports.SharedStorageWorkletHost = SharedStorageWorkletHost;
  exports.SharedStorageWorkletHostPtr = SharedStorageWorkletHostPtr;
  exports.SharedStorageWorkletHostAssociatedPtr = SharedStorageWorkletHostAssociatedPtr;
  exports.SharedStorageDocumentService = SharedStorageDocumentService;
  exports.SharedStorageDocumentServicePtr = SharedStorageDocumentServicePtr;
  exports.SharedStorageDocumentServiceAssociatedPtr = SharedStorageDocumentServiceAssociatedPtr;
})();