// third_party/blink/public/mojom/shared_storage/shared_storage.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  CredentialsMode as network_mojom_CredentialsMode,
  CredentialsModeSpec as network_mojom_CredentialsModeSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  LockName as network_mojom_LockName,
  LockNameSpec as network_mojom_LockNameSpec,
  SharedStorageBatchUpdateMethodsArgument as network_mojom_SharedStorageBatchUpdateMethodsArgument,
  SharedStorageBatchUpdateMethodsArgumentSpec as network_mojom_SharedStorageBatchUpdateMethodsArgumentSpec,
  SharedStorageKeyArgument as network_mojom_SharedStorageKeyArgument,
  SharedStorageKeyArgumentSpec as network_mojom_SharedStorageKeyArgumentSpec,
  SharedStorageModifierMethodWithOptions as network_mojom_SharedStorageModifierMethodWithOptions,
  SharedStorageModifierMethodWithOptionsSpec as network_mojom_SharedStorageModifierMethodWithOptionsSpec
} from '../../../../../services/network/public/mojom/shared_storage.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FencedFrameConfig as blink_mojom_FencedFrameConfig,
  FencedFrameConfigSpec as blink_mojom_FencedFrameConfigSpec
} from '../fenced_frame/fenced_frame_config.mojom.m.js';

import {
  CloneableMessage as blink_mojom_CloneableMessage,
  CloneableMessageSpec as blink_mojom_CloneableMessageSpec
} from '../messaging/cloneable_message.mojom.m.js';

import {
  OriginTrialFeature as blink_mojom_OriginTrialFeature,
  OriginTrialFeatureSpec as blink_mojom_OriginTrialFeatureSpec
} from '../origin_trials/origin_trial_feature.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SharedStorageGetStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SharedStorageGetStatus = {
  
  kSuccess: 0,
  kNotFound: 1,
  kError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SharedStorageWorkletCreationMethodSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SharedStorageWorkletCreationMethod = {
  
  kAddModule: 0,
  kCreateWorklet: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SharedStorageDataOriginTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SharedStorageDataOriginType = {
  
  kContextOrigin: 0,
  kScriptOrigin: 1,
  kCustomOrigin: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedStorageWorkletHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedStorageWorkletHost', scope);
  }
}

/** @interface */
export class SharedStorageWorkletHostInterface {
  
  /**
   * @param { !string } name
   * @param { !Array<!SharedStorageUrlWithMetadata> } urlsWithMetadata
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { !boolean } keepAliveAfterOperation
   * @param { !PrivateAggregationConfig } privateAggregationConfig
   * @param { !boolean } resolveToConfig
   * @param { !mojoBase_mojom_String16 } savedQueryName
   * @param { !mojoBase_mojom_TimeTicks } startTime
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        config: ?blink_mojom_FencedFrameConfig,
   *  }>}
   */

  selectURL(name, urlsWithMetadata, serializedData, keepAliveAfterOperation, privateAggregationConfig, resolveToConfig, savedQueryName, startTime) {}
  
  /**
   * @param { !string } name
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { !boolean } keepAliveAfterOperation
   * @param { !PrivateAggregationConfig } privateAggregationConfig
   * @param { !mojoBase_mojom_TimeTicks } startTime
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  run(name, serializedData, keepAliveAfterOperation, privateAggregationConfig, startTime) {}
}

/**
 * @implements { SharedStorageWorkletHostInterface }
 */
export class SharedStorageWorkletHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedStorageWorkletHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedStorageWorkletHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedStorageWorkletHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !Array<!SharedStorageUrlWithMetadata> } urlsWithMetadata
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { !boolean } keepAliveAfterOperation
   * @param { !PrivateAggregationConfig } privateAggregationConfig
   * @param { !boolean } resolveToConfig
   * @param { !mojoBase_mojom_String16 } savedQueryName
   * @param { !mojoBase_mojom_TimeTicks } startTime
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        config: ?blink_mojom_FencedFrameConfig,
   *  }>}
   */

  selectURL(
      name,
      urlsWithMetadata,
      serializedData,
      keepAliveAfterOperation,
      privateAggregationConfig,
      resolveToConfig,
      savedQueryName,
      startTime) {
    return this.proxy.sendMessage(
        0,
        SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
        SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
        [
          name,
          urlsWithMetadata,
          serializedData,
          keepAliveAfterOperation,
          privateAggregationConfig,
          resolveToConfig,
          savedQueryName,
          startTime
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { !boolean } keepAliveAfterOperation
   * @param { !PrivateAggregationConfig } privateAggregationConfig
   * @param { !mojoBase_mojom_TimeTicks } startTime
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  run(
      name,
      serializedData,
      keepAliveAfterOperation,
      privateAggregationConfig,
      startTime) {
    return this.proxy.sendMessage(
        1,
        SharedStorageWorkletHost_Run_ParamsSpec.$,
        SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
        [
          name,
          serializedData,
          keepAliveAfterOperation,
          privateAggregationConfig,
          startTime
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedStorageWorkletHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedStorageWorkletHostReceiver {
  /**
   * @param {!SharedStorageWorkletHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedStorageWorkletHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedStorageWorkletHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageWorkletHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
        SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
        impl.selectURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedStorageWorkletHost_Run_ParamsSpec.$,
        SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
        impl.run.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedStorageWorkletHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageWorkletHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedStorageWorkletHostRemote}
   */
  static getRemote() {
    let remote = new SharedStorageWorkletHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedStorageWorkletHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedStorageWorkletHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedStorageWorkletHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageWorkletHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
        SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
        this.selectURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.run =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedStorageWorkletHost_Run_ParamsSpec.$,
        SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
        this.run.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedStorageDocumentServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedStorageDocumentService', scope);
  }
}

/** @interface */
export class SharedStorageDocumentServiceInterface {
  
  /**
   * @param { !url_mojom_Url } scriptSourceUrl
   * @param { !url_mojom_Origin } dataOrigin
   * @param { !SharedStorageDataOriginType } dataOriginType
   * @param { !network_mojom_CredentialsMode } credentialsMode
   * @param { !SharedStorageWorkletCreationMethod } creationMethod
   * @param { !Array<!blink_mojom_OriginTrialFeature> } originTrialFeatures
   * @param { !Object } workletHost
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  createWorklet(scriptSourceUrl, dataOrigin, dataOriginType, credentialsMode, creationMethod, originTrialFeatures, workletHost) {}
  
  /**
   * @param { !network_mojom_SharedStorageKeyArgument } key
   * @return {!Promise<{
        status: !SharedStorageGetStatus,
        errorMessage: !string,
        value: !mojoBase_mojom_String16,
   *  }>}
   */

  sharedStorageGet(key) {}
  
  /**
   * @param { !network_mojom_SharedStorageModifierMethodWithOptions } methodWithOptions
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageUpdate(methodWithOptions) {}
  
  /**
   * @param { !network_mojom_SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network_mojom_LockName } withLock
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageBatchUpdate(methodsWithOptions, withLock) {}
}

/**
 * @implements { SharedStorageDocumentServiceInterface }
 */
export class SharedStorageDocumentServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedStorageDocumentServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedStorageDocumentServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedStorageDocumentServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } scriptSourceUrl
   * @param { !url_mojom_Origin } dataOrigin
   * @param { !SharedStorageDataOriginType } dataOriginType
   * @param { !network_mojom_CredentialsMode } credentialsMode
   * @param { !SharedStorageWorkletCreationMethod } creationMethod
   * @param { !Array<!blink_mojom_OriginTrialFeature> } originTrialFeatures
   * @param { !Object } workletHost
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  createWorklet(
      scriptSourceUrl,
      dataOrigin,
      dataOriginType,
      credentialsMode,
      creationMethod,
      originTrialFeatures,
      workletHost) {
    return this.proxy.sendMessage(
        0,
        SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
        SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
        [
          scriptSourceUrl,
          dataOrigin,
          dataOriginType,
          credentialsMode,
          creationMethod,
          originTrialFeatures,
          workletHost
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedStorageKeyArgument } key
   * @return {!Promise<{
        status: !SharedStorageGetStatus,
        errorMessage: !string,
        value: !mojoBase_mojom_String16,
   *  }>}
   */

  sharedStorageGet(
      key) {
    return this.proxy.sendMessage(
        1,
        SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedStorageModifierMethodWithOptions } methodWithOptions
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageUpdate(
      methodWithOptions) {
    return this.proxy.sendMessage(
        2,
        SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
        [
          methodWithOptions
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network_mojom_LockName } withLock
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageBatchUpdate(
      methodsWithOptions,
      withLock) {
    return this.proxy.sendMessage(
        3,
        SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        [
          methodsWithOptions,
          withLock
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedStorageDocumentService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedStorageDocumentServiceReceiver {
  /**
   * @param {!SharedStorageDocumentServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedStorageDocumentServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedStorageDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
        SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
        impl.createWorklet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
        impl.sharedStorageGet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
        impl.sharedStorageUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        impl.sharedStorageBatchUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedStorageDocumentService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageDocumentService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedStorageDocumentServiceRemote}
   */
  static getRemote() {
    let remote = new SharedStorageDocumentServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedStorageDocumentService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedStorageDocumentServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedStorageDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWorklet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
        SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
        this.createWorklet.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageGet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
        this.sharedStorageGet.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
        this.sharedStorageUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageBatchUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
        SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        this.sharedStorageBatchUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageUrlWithMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrivateAggregationConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletHost_SelectURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletHost_SelectURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletHost_Run_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletHost_Run_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_CreateWorklet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_SharedStorageGet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedStorageUrlWithMetadataSpec.$,
    'SharedStorageUrlWithMetadata',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingMetadata', 8,
        0,
        mojo.internal.Map(mojo.internal.String, url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageUrlWithMetadata {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Object<!string, !url_mojom_Url> } */
    this.reportingMetadata;
  }
}



mojo.internal.Struct(
    PrivateAggregationConfigSpec.$,
    'PrivateAggregationConfig',
    [
      mojo.internal.StructField(
        'aggregationCoordinatorOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contextId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filteringIdMaxBytes', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'max_contributions_$flag', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "max_contributions_$value",
          originalFieldName: "maxContributions",
        }
      ),
      mojo.internal.StructField(
        'max_contributions_$value', 22,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "maxContributions",
        }
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PrivateAggregationConfig {
  constructor() {
    /** @type { (url_mojom_Origin|undefined) } */
    this.aggregationCoordinatorOrigin;
    /** @type { (string|undefined) } */
    this.contextId;
    /** @type { !number } */
    this.filteringIdMaxBytes;
    /** @type { (number|undefined) } */
    this.maxContributions;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
    'SharedStorageWorkletHost_SelectURL_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlsWithMetadata', 8,
        0,
        mojo.internal.Array(SharedStorageUrlWithMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializedData', 16,
        0,
        blink_mojom_CloneableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keepAliveAfterOperation', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'privateAggregationConfig', 32,
        0,
        PrivateAggregationConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resolveToConfig', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'savedQueryName', 40,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startTime', 48,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class SharedStorageWorkletHost_SelectURL_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !Array<!SharedStorageUrlWithMetadata> } */
    this.urlsWithMetadata;
    /** @type { !blink_mojom_CloneableMessage } */
    this.serializedData;
    /** @type { !boolean } */
    this.keepAliveAfterOperation;
    /** @type { !PrivateAggregationConfig } */
    this.privateAggregationConfig;
    /** @type { !boolean } */
    this.resolveToConfig;
    /** @type { !mojoBase_mojom_String16 } */
    this.savedQueryName;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.startTime;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
    'SharedStorageWorkletHost_SelectURL_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'config', 16,
        0,
        blink_mojom_FencedFrameConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageWorkletHost_SelectURL_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
    /** @type { (blink_mojom_FencedFrameConfig|undefined) } */
    this.config;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletHost_Run_ParamsSpec.$,
    'SharedStorageWorkletHost_Run_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializedData', 8,
        0,
        blink_mojom_CloneableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keepAliveAfterOperation', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'privateAggregationConfig', 24,
        0,
        PrivateAggregationConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startTime', 32,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SharedStorageWorkletHost_Run_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !blink_mojom_CloneableMessage } */
    this.serializedData;
    /** @type { !boolean } */
    this.keepAliveAfterOperation;
    /** @type { !PrivateAggregationConfig } */
    this.privateAggregationConfig;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.startTime;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
    'SharedStorageWorkletHost_Run_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletHost_Run_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
    'SharedStorageDocumentService_CreateWorklet_Params',
    [
      mojo.internal.StructField(
        'scriptSourceUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataOriginType', 16,
        0,
        SharedStorageDataOriginTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credentialsMode', 20,
        0,
        network_mojom_CredentialsModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'creationMethod', 24,
        0,
        SharedStorageWorkletCreationMethodSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originTrialFeatures', 32,
        0,
        mojo.internal.Array(blink_mojom_OriginTrialFeatureSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workletHost', 28,
        0,
        mojo.internal.AssociatedInterfaceRequest(SharedStorageWorkletHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SharedStorageDocumentService_CreateWorklet_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.scriptSourceUrl;
    /** @type { !url_mojom_Origin } */
    this.dataOrigin;
    /** @type { !SharedStorageDataOriginType } */
    this.dataOriginType;
    /** @type { !network_mojom_CredentialsMode } */
    this.credentialsMode;
    /** @type { !SharedStorageWorkletCreationMethod } */
    this.creationMethod;
    /** @type { !Array<!blink_mojom_OriginTrialFeature> } */
    this.originTrialFeatures;
    /** @type { !Object } */
    this.workletHost;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
    'SharedStorageDocumentService_CreateWorklet_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageDocumentService_CreateWorklet_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageGet_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        network_mojom_SharedStorageKeyArgumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageDocumentService_SharedStorageGet_Params {
  constructor() {
    /** @type { !network_mojom_SharedStorageKeyArgument } */
    this.key;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageGet_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        SharedStorageGetStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageDocumentService_SharedStorageGet_ResponseParams {
  constructor() {
    /** @type { !SharedStorageGetStatus } */
    this.status;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !mojoBase_mojom_String16 } */
    this.value;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageUpdate_Params',
    [
      mojo.internal.StructField(
        'methodWithOptions', 0,
        0,
        network_mojom_SharedStorageModifierMethodWithOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageDocumentService_SharedStorageUpdate_Params {
  constructor() {
    /** @type { !network_mojom_SharedStorageModifierMethodWithOptions } */
    this.methodWithOptions;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageDocumentService_SharedStorageUpdate_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageBatchUpdate_Params',
    [
      mojo.internal.StructField(
        'methodsWithOptions', 0,
        0,
        network_mojom_SharedStorageBatchUpdateMethodsArgumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'withLock', 8,
        0,
        network_mojom_LockNameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageDocumentService_SharedStorageBatchUpdate_Params {
  constructor() {
    /** @type { !network_mojom_SharedStorageBatchUpdateMethodsArgument } */
    this.methodsWithOptions;
    /** @type { (network_mojom_LockName|undefined) } */
    this.withLock;
  }
}



mojo.internal.Struct(
    SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.errorMessage;
  }
}

