// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedStorageEntriesListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedStorageEntriesListener.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedStorageEntriesListenerInterface }
 */
blink.mojom.SharedStorageEntriesListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedStorageEntriesListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedStorageEntriesListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedStorageEntriesListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } success
   * @param { !string } errorMessage
   * @param { !Array<!blink.mojom.SharedStorageKeyAndOrValue> } entries
   * @param { !boolean } hasMoreEntries
   * @param { !number } totalQueuedToSend
   */

  didReadEntries(
      success,
      errorMessage,
      entries,
      hasMoreEntries,
      totalQueuedToSend) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
        null,
        [
          success,
          errorMessage,
          entries,
          hasMoreEntries,
          totalQueuedToSend
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedStorageEntriesListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedStorageEntriesListenerReceiver = class {
  /**
   * @param {!blink.mojom.SharedStorageEntriesListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedStorageEntriesListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedStorageEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
        null,
        impl.didReadEntries.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedStorageEntriesListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageEntriesListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedStorageEntriesListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedStorageEntriesListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedStorageEntriesListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedStorageEntriesListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedStorageEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReadEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
        null,
        this.didReadEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedStorageWorkletServiceClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedStorageWorkletServiceClientInterface }
 */
blink.mojom.SharedStorageWorkletServiceClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedStorageWorkletServiceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedStorageWorkletServiceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedStorageWorkletServiceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.SharedStorageModifierMethodWithOptions } methodWithOptions
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageUpdate(
      methodWithOptions) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
        [
          methodWithOptions
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network.mojom.LockName } withLock
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageBatchUpdate(
      methodsWithOptions,
      withLock) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        [
          methodsWithOptions,
          withLock
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedStorageKeyArgument } key
   * @return {!Promise<{
        status: !blink.mojom.SharedStorageGetStatus,
        errorMessage: !string,
        value: !mojoBase.mojom.String16,
   *  }>}
   */

  sharedStorageGet(
      key) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SharedStorageEntriesListenerRemote } listener
   */

  sharedStorageKeys(
      listener) {
    this.proxy.sendMessage(
        3,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SharedStorageEntriesListenerRemote } listener
   * @param { !boolean } valuesOnly
   */

  sharedStorageEntries(
      listener,
      valuesOnly) {
    this.proxy.sendMessage(
        4,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
        null,
        [
          listener,
          valuesOnly
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        length: !number,
   *  }>}
   */

  sharedStorageLength() {
    return this.proxy.sendMessage(
        5,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        bits: !number,
   *  }>}
   */

  sharedStorageRemainingBudget() {
    return this.proxy.sendMessage(
        6,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.GetInterestGroupsResult,
   *  }>}
   */

  getInterestGroups() {
    return this.proxy.sendMessage(
        7,
        blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ConsoleMessageLevel } logLevel
   * @param { !string } message
   */

  didAddMessageToConsole(
      logLevel,
      message) {
    this.proxy.sendMessage(
        8,
        blink.mojom.SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
        null,
        [
          logLevel,
          message
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.WebFeature> } features
   */

  recordUseCounters(
      features) {
    this.proxy.sendMessage(
        9,
        blink.mojom.SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
        null,
        [
          features
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedStorageWorkletServiceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClientReceiver = class {
  /**
   * @param {!blink.mojom.SharedStorageWorkletServiceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedStorageWorkletServiceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedStorageWorkletServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageWorkletServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
        impl.sharedStorageUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        impl.sharedStorageBatchUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
        impl.sharedStorageGet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
        null,
        impl.sharedStorageKeys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
        null,
        impl.sharedStorageEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
        impl.sharedStorageLength.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
        impl.sharedStorageRemainingBudget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
        impl.getInterestGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
        null,
        impl.didAddMessageToConsole.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
        null,
        impl.recordUseCounters.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedStorageWorkletServiceClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageWorkletServiceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedStorageWorkletServiceClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedStorageWorkletServiceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedStorageWorkletServiceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedStorageWorkletServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageWorkletServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
        this.sharedStorageUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageBatchUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        this.sharedStorageBatchUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageGet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
        this.sharedStorageGet.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
        null,
        this.sharedStorageKeys.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
        null,
        this.sharedStorageEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
        this.sharedStorageLength.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageRemainingBudget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
        this.sharedStorageRemainingBudget.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterestGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
        this.getInterestGroups.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didAddMessageToConsole =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
        null,
        this.didAddMessageToConsole.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordUseCounters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
        null,
        this.recordUseCounters.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedStorageWorkletServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedStorageWorkletService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedStorageWorkletServiceInterface }
 */
blink.mojom.SharedStorageWorkletServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedStorageWorkletServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedStorageWorkletServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedStorageWorkletServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @param { !blink.mojom.SharedStorageWorkletPermissionsPolicyState } permissionsPolicyState
   * @param { ?mojoBase.mojom.String16 } embedderContext
   */

  initialize(
      client,
      permissionsPolicyState,
      embedderContext) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedStorageWorkletService_Initialize_ParamsSpec.$,
        null,
        [
          client,
          permissionsPolicyState,
          embedderContext
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLLoaderFactoryRemote } urlLoaderFactory
   * @param { !url.mojom.Url } scriptSourceUrl
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  addModule(
      urlLoaderFactory,
      scriptSourceUrl) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.SharedStorageWorkletService_AddModule_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
        [
          urlLoaderFactory,
          scriptSourceUrl
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !Array<!url.mojom.Url> } urls
   * @param { !blink.mojom.CloneableMessage } serializedData
   * @param { ?blink.mojom.PrivateAggregationOperationDetails } paOperationDetails
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        index: !number,
   *  }>}
   */

  runURLSelectionOperation(
      name,
      urls,
      serializedData,
      paOperationDetails) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
        [
          name,
          urls,
          serializedData,
          paOperationDetails
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink.mojom.CloneableMessage } serializedData
   * @param { ?blink.mojom.PrivateAggregationOperationDetails } paOperationDetails
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  runOperation(
      name,
      serializedData,
      paOperationDetails) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.SharedStorageWorkletService_RunOperation_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
        [
          name,
          serializedData,
          paOperationDetails
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedStorageWorkletService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedStorageWorkletServiceReceiver = class {
  /**
   * @param {!blink.mojom.SharedStorageWorkletServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedStorageWorkletServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedStorageWorkletServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageWorkletServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageWorkletService_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageWorkletService_AddModule_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
        impl.addModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
        impl.runURLSelectionOperation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedStorageWorkletService_RunOperation_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
        impl.runOperation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedStorageWorkletService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageWorkletService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedStorageWorkletServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedStorageWorkletServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedStorageWorkletService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedStorageWorkletServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedStorageWorkletServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageWorkletServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageWorkletService_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageWorkletService_AddModule_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
        this.addModule.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runURLSelectionOperation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
        this.runURLSelectionOperation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runOperation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedStorageWorkletService_RunOperation_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
        this.runOperation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletPermissionsPolicyStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageKeyAndOrValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrivateAggregationOperationDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageEntriesListener_DidReadEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_AddModule_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_AddModule_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_RunOperation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletService_RunOperation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.GetInterestGroupsResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletPermissionsPolicyStateSpec.$,
    'SharedStorageWorkletPermissionsPolicyState',
    [
      mojo.internal.StructField(
        'privateAggregationAllowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'joinAdInterestGroupAllowed', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'runAdAuctionAllowed', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletPermissionsPolicyState = class {
  constructor() {
    /** @export { !boolean } */
    this.privateAggregationAllowed;
    /** @export { !boolean } */
    this.joinAdInterestGroupAllowed;
    /** @export { !boolean } */
    this.runAdAuctionAllowed;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageKeyAndOrValueSpec.$,
    'SharedStorageKeyAndOrValue',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageKeyAndOrValue = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.key;
    /** @export { !mojoBase.mojom.String16 } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.PrivateAggregationOperationDetailsSpec.$,
    'PrivateAggregationOperationDetails',
    [
      mojo.internal.StructField(
        'paHost', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PrivateAggregationHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filteringIdMaxBytes', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PrivateAggregationOperationDetails = class {
  constructor() {
    /** @export { !blink.mojom.PrivateAggregationHostRemote } */
    this.paHost;
    /** @export { !number } */
    this.filteringIdMaxBytes;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
    'SharedStorageEntriesListener_DidReadEntries_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entries', 16,
        0,
        mojo.internal.Array(blink.mojom.SharedStorageKeyAndOrValueSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasMoreEntries', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'totalQueuedToSend', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageEntriesListener_DidReadEntries_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
    /** @export { !Array<!blink.mojom.SharedStorageKeyAndOrValue> } */
    this.entries;
    /** @export { !boolean } */
    this.hasMoreEntries;
    /** @export { !number } */
    this.totalQueuedToSend;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageUpdate_Params',
    [
      mojo.internal.StructField(
        'methodWithOptions', 0,
        0,
        network.mojom.SharedStorageModifierMethodWithOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedStorageModifierMethodWithOptions } */
    this.methodWithOptions;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params',
    [
      mojo.internal.StructField(
        'methodsWithOptions', 0,
        0,
        network.mojom.SharedStorageBatchUpdateMethodsArgumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'withLock', 8,
        0,
        network.mojom.LockNameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedStorageBatchUpdateMethodsArgument } */
    this.methodsWithOptions;
    /** @export { (network.mojom.LockName|undefined) } */
    this.withLock;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageGet_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        network.mojom.SharedStorageKeyArgumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedStorageKeyArgument } */
    this.key;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.SharedStorageGetStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.SharedStorageGetStatus } */
    this.status;
    /** @export { !string } */
    this.errorMessage;
    /** @export { !mojoBase.mojom.String16 } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageKeys_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SharedStorageEntriesListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageKeys_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedStorageEntriesListenerRemote } */
    this.listener;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageEntries_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SharedStorageEntriesListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'valuesOnly', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageEntries_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedStorageEntriesListenerRemote } */
    this.listener;
    /** @export { !boolean } */
    this.valuesOnly;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageLength_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
    /** @export { !number } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bits', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
    /** @export { !number } */
    this.bits;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_GetInterestGroups_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.GetInterestGroupsResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.GetInterestGroupsResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params',
    [
      mojo.internal.StructField(
        'logLevel', 0,
        0,
        blink.mojom.ConsoleMessageLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params = class {
  constructor() {
    /** @export { !blink.mojom.ConsoleMessageLevel } */
    this.logLevel;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_RecordUseCounters_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        mojo.internal.Array(blink.mojom.WebFeatureSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageWorkletServiceClient_RecordUseCounters_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.WebFeature> } */
    this.features;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_Initialize_ParamsSpec.$,
    'SharedStorageWorkletService_Initialize_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.SharedStorageWorkletServiceClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'permissionsPolicyState', 8,
        0,
        blink.mojom.SharedStorageWorkletPermissionsPolicyStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'embedderContext', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageWorkletService_Initialize_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !blink.mojom.SharedStorageWorkletPermissionsPolicyState } */
    this.permissionsPolicyState;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.embedderContext;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_AddModule_ParamsSpec.$,
    'SharedStorageWorkletService_AddModule_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptSourceUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletService_AddModule_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderFactoryRemote } */
    this.urlLoaderFactory;
    /** @export { !url.mojom.Url } */
    this.scriptSourceUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
    'SharedStorageWorkletService_AddModule_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletService_AddModule_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
    'SharedStorageWorkletService_RunURLSelectionOperation_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urls', 8,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serializedData', 16,
        0,
        blink.mojom.CloneableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paOperationDetails', 24,
        0,
        blink.mojom.PrivateAggregationOperationDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !Array<!url.mojom.Url> } */
    this.urls;
    /** @export { !blink.mojom.CloneableMessage } */
    this.serializedData;
    /** @export { (blink.mojom.PrivateAggregationOperationDetails|undefined) } */
    this.paOperationDetails;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
    'SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'index', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
    /** @export { !number } */
    this.index;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_RunOperation_ParamsSpec.$,
    'SharedStorageWorkletService_RunOperation_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serializedData', 8,
        0,
        blink.mojom.CloneableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paOperationDetails', 16,
        0,
        blink.mojom.PrivateAggregationOperationDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageWorkletService_RunOperation_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !blink.mojom.CloneableMessage } */
    this.serializedData;
    /** @export { (blink.mojom.PrivateAggregationOperationDetails|undefined) } */
    this.paOperationDetails;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
    'SharedStorageWorkletService_RunOperation_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletService_RunOperation_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Union(
    blink.mojom.GetInterestGroupsResultSpec.$, 'GetInterestGroupsResult',
    {
      'errorMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'groups': {
        'ordinal': 1,
        'type': mojo.internal.Array(blink.mojom.StorageInterestGroupSpec.$, false),
      },
    });

/**
 * @typedef { {
 *   errorMessage: (!string|undefined),
 *   groups: (!Array<!blink.mojom.StorageInterestGroup>|undefined),
 * } }
 */
blink.mojom.GetInterestGroupsResult;
