// third_party/blink/public/mojom/storage_access/storage_access_handle.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/storage_access/storage_access_handle.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var byte_count$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_count.mojom', '../../../../../mojo/public/mojom/base/byte_count.mojom.js');
  }
  var blob_url_store$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob_url_store.mojom', '../blob/blob_url_store.mojom.js');
  }
  var broadcast_channel$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom', '../broadcastchannel/broadcast_channel.mojom.js');
  }
  var cache_storage$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/cache_storage/cache_storage.mojom', '../cache_storage/cache_storage.mojom.js');
  }
  var file_system_access_directory_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom', '../file_system_access/file_system_access_directory_handle.mojom.js');
  }
  var file_system_access_error$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom', '../file_system_access/file_system_access_error.mojom.js');
  }
  var indexeddb$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/indexeddb/indexeddb.mojom', '../indexeddb/indexeddb.mojom.js');
  }
  var lock_manager$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/locks/lock_manager.mojom', '../locks/lock_manager.mojom.js');
  }
  var shared_worker_connector$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/shared_worker_connector.mojom', '../worker/shared_worker_connector.mojom.js');
  }



  function StorageAccessHandle_BindIndexedDB_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_BindIndexedDB_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  StorageAccessHandle_BindIndexedDB_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_BindIndexedDB_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_BindIndexedDB_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_BindIndexedDB_Params.encodedSize = codec.kStructHeaderSize + 8;

  StorageAccessHandle_BindIndexedDB_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_BindIndexedDB_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_BindIndexedDB_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_BindIndexedDB_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StorageAccessHandle_BindLocks_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_BindLocks_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  StorageAccessHandle_BindLocks_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_BindLocks_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_BindLocks_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_BindLocks_Params.encodedSize = codec.kStructHeaderSize + 8;

  StorageAccessHandle_BindLocks_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_BindLocks_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_BindLocks_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_BindLocks_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StorageAccessHandle_BindCaches_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_BindCaches_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  StorageAccessHandle_BindCaches_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_BindCaches_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_BindCaches_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_BindCaches_Params.encodedSize = codec.kStructHeaderSize + 8;

  StorageAccessHandle_BindCaches_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_BindCaches_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_BindCaches_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_BindCaches_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StorageAccessHandle_GetDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_GetDirectory_Params.prototype.initDefaults_ = function() {
  };
  StorageAccessHandle_GetDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_GetDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_GetDirectory_Params.encodedSize = codec.kStructHeaderSize + 0;

  StorageAccessHandle_GetDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_GetDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  StorageAccessHandle_GetDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_GetDirectory_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function StorageAccessHandle_GetDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_GetDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.directory = new file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr();
  };
  StorageAccessHandle_GetDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_GetDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_GetDirectory_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_GetDirectory_ResponseParams.directory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_GetDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  StorageAccessHandle_GetDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_GetDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.directory =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr));
    return val;
  };

  StorageAccessHandle_GetDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_GetDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr), val.directory);
  };
  function StorageAccessHandle_Estimate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_Estimate_Params.prototype.initDefaults_ = function() {
  };
  StorageAccessHandle_Estimate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_Estimate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_Estimate_Params.encodedSize = codec.kStructHeaderSize + 0;

  StorageAccessHandle_Estimate_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_Estimate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  StorageAccessHandle_Estimate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_Estimate_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function StorageAccessHandle_Estimate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_Estimate_ResponseParams.prototype.initDefaults_ = function() {
    this.currentUsage = null;
    this.currentQuota = null;
    this.success = false;
  };
  StorageAccessHandle_Estimate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_Estimate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_Estimate_ResponseParams.currentUsage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_count$.ByteCount, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_Estimate_ResponseParams.currentQuota
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, byte_count$.ByteCount, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  StorageAccessHandle_Estimate_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  StorageAccessHandle_Estimate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_Estimate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currentUsage =
        decoder.decodeStructPointer(byte_count$.ByteCount);
    val.currentQuota =
        decoder.decodeStructPointer(byte_count$.ByteCount);
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_Estimate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_Estimate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_count$.ByteCount, val.currentUsage);
    encoder.encodeStructPointer(byte_count$.ByteCount, val.currentQuota);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StorageAccessHandle_BindBlobStorage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_BindBlobStorage_Params.prototype.initDefaults_ = function() {
    this.receiver = new associatedBindings.AssociatedInterfaceRequest();
  };
  StorageAccessHandle_BindBlobStorage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_BindBlobStorage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_BindBlobStorage_Params.receiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_BindBlobStorage_Params.encodedSize = codec.kStructHeaderSize + 8;

  StorageAccessHandle_BindBlobStorage_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_BindBlobStorage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_BindBlobStorage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_BindBlobStorage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StorageAccessHandle_BindBroadcastChannel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_BindBroadcastChannel_Params.prototype.initDefaults_ = function() {
    this.receiver = new associatedBindings.AssociatedInterfaceRequest();
  };
  StorageAccessHandle_BindBroadcastChannel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_BindBroadcastChannel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_BindBroadcastChannel_Params.receiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_BindBroadcastChannel_Params.encodedSize = codec.kStructHeaderSize + 8;

  StorageAccessHandle_BindBroadcastChannel_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_BindBroadcastChannel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_BindBroadcastChannel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_BindBroadcastChannel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StorageAccessHandle_BindSharedWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageAccessHandle_BindSharedWorker_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  StorageAccessHandle_BindSharedWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageAccessHandle_BindSharedWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageAccessHandle_BindSharedWorker_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageAccessHandle_BindSharedWorker_Params.encodedSize = codec.kStructHeaderSize + 8;

  StorageAccessHandle_BindSharedWorker_Params.decode = function(decoder) {
    var packed;
    var val = new StorageAccessHandle_BindSharedWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StorageAccessHandle_BindSharedWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageAccessHandle_BindSharedWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kStorageAccessHandle_BindIndexedDB_Name = 0;
  var kStorageAccessHandle_BindLocks_Name = 1;
  var kStorageAccessHandle_BindCaches_Name = 2;
  var kStorageAccessHandle_GetDirectory_Name = 3;
  var kStorageAccessHandle_Estimate_Name = 4;
  var kStorageAccessHandle_BindBlobStorage_Name = 5;
  var kStorageAccessHandle_BindBroadcastChannel_Name = 6;
  var kStorageAccessHandle_BindSharedWorker_Name = 7;

  function StorageAccessHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(StorageAccessHandle,
                                                   handleOrPtrInfo);
  }

  function StorageAccessHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        StorageAccessHandle, associatedInterfacePtrInfo);
  }

  StorageAccessHandleAssociatedPtr.prototype =
      Object.create(StorageAccessHandlePtr.prototype);
  StorageAccessHandleAssociatedPtr.prototype.constructor =
      StorageAccessHandleAssociatedPtr;

  function StorageAccessHandleProxy(receiver) {
    this.receiver_ = receiver;
  }
  StorageAccessHandlePtr.prototype.bindIndexedDB = function() {
    return StorageAccessHandleProxy.prototype.bindIndexedDB
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.bindIndexedDB = function(receiver) {
    var params_ = new StorageAccessHandle_BindIndexedDB_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kStorageAccessHandle_BindIndexedDB_Name,
        codec.align(StorageAccessHandle_BindIndexedDB_Params.encodedSize));
    builder.encodeStruct(StorageAccessHandle_BindIndexedDB_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  StorageAccessHandlePtr.prototype.bindLocks = function() {
    return StorageAccessHandleProxy.prototype.bindLocks
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.bindLocks = function(receiver) {
    var params_ = new StorageAccessHandle_BindLocks_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kStorageAccessHandle_BindLocks_Name,
        codec.align(StorageAccessHandle_BindLocks_Params.encodedSize));
    builder.encodeStruct(StorageAccessHandle_BindLocks_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  StorageAccessHandlePtr.prototype.bindCaches = function() {
    return StorageAccessHandleProxy.prototype.bindCaches
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.bindCaches = function(receiver) {
    var params_ = new StorageAccessHandle_BindCaches_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kStorageAccessHandle_BindCaches_Name,
        codec.align(StorageAccessHandle_BindCaches_Params.encodedSize));
    builder.encodeStruct(StorageAccessHandle_BindCaches_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  StorageAccessHandlePtr.prototype.getDirectory = function() {
    return StorageAccessHandleProxy.prototype.getDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.getDirectory = function() {
    var params_ = new StorageAccessHandle_GetDirectory_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kStorageAccessHandle_GetDirectory_Name,
          codec.align(StorageAccessHandle_GetDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(StorageAccessHandle_GetDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(StorageAccessHandle_GetDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  StorageAccessHandlePtr.prototype.estimate = function() {
    return StorageAccessHandleProxy.prototype.estimate
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.estimate = function() {
    var params_ = new StorageAccessHandle_Estimate_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kStorageAccessHandle_Estimate_Name,
          codec.align(StorageAccessHandle_Estimate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(StorageAccessHandle_Estimate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(StorageAccessHandle_Estimate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  StorageAccessHandlePtr.prototype.bindBlobStorage = function() {
    return StorageAccessHandleProxy.prototype.bindBlobStorage
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.bindBlobStorage = function(receiver) {
    var params_ = new StorageAccessHandle_BindBlobStorage_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV2Builder(
        kStorageAccessHandle_BindBlobStorage_Name,
        codec.align(StorageAccessHandle_BindBlobStorage_Params.encodedSize));
    builder.setPayload(StorageAccessHandle_BindBlobStorage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  StorageAccessHandlePtr.prototype.bindBroadcastChannel = function() {
    return StorageAccessHandleProxy.prototype.bindBroadcastChannel
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.bindBroadcastChannel = function(receiver) {
    var params_ = new StorageAccessHandle_BindBroadcastChannel_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV2Builder(
        kStorageAccessHandle_BindBroadcastChannel_Name,
        codec.align(StorageAccessHandle_BindBroadcastChannel_Params.encodedSize));
    builder.setPayload(StorageAccessHandle_BindBroadcastChannel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  StorageAccessHandlePtr.prototype.bindSharedWorker = function() {
    return StorageAccessHandleProxy.prototype.bindSharedWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  StorageAccessHandleProxy.prototype.bindSharedWorker = function(receiver) {
    var params_ = new StorageAccessHandle_BindSharedWorker_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kStorageAccessHandle_BindSharedWorker_Name,
        codec.align(StorageAccessHandle_BindSharedWorker_Params.encodedSize));
    builder.encodeStruct(StorageAccessHandle_BindSharedWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function StorageAccessHandleStub(delegate) {
    this.delegate_ = delegate;
  }
  StorageAccessHandleStub.prototype.bindIndexedDB = function(receiver) {
    return this.delegate_ && this.delegate_.bindIndexedDB && this.delegate_.bindIndexedDB(receiver);
  }
  StorageAccessHandleStub.prototype.bindLocks = function(receiver) {
    return this.delegate_ && this.delegate_.bindLocks && this.delegate_.bindLocks(receiver);
  }
  StorageAccessHandleStub.prototype.bindCaches = function(receiver) {
    return this.delegate_ && this.delegate_.bindCaches && this.delegate_.bindCaches(receiver);
  }
  StorageAccessHandleStub.prototype.getDirectory = function() {
    return this.delegate_ && this.delegate_.getDirectory && this.delegate_.getDirectory();
  }
  StorageAccessHandleStub.prototype.estimate = function() {
    return this.delegate_ && this.delegate_.estimate && this.delegate_.estimate();
  }
  StorageAccessHandleStub.prototype.bindBlobStorage = function(receiver) {
    return this.delegate_ && this.delegate_.bindBlobStorage && this.delegate_.bindBlobStorage(receiver);
  }
  StorageAccessHandleStub.prototype.bindBroadcastChannel = function(receiver) {
    return this.delegate_ && this.delegate_.bindBroadcastChannel && this.delegate_.bindBroadcastChannel(receiver);
  }
  StorageAccessHandleStub.prototype.bindSharedWorker = function(receiver) {
    return this.delegate_ && this.delegate_.bindSharedWorker && this.delegate_.bindSharedWorker(receiver);
  }

  StorageAccessHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kStorageAccessHandle_BindIndexedDB_Name:
      var params = reader.decodeStruct(StorageAccessHandle_BindIndexedDB_Params);
      this.bindIndexedDB(params.receiver);
      return true;
    case kStorageAccessHandle_BindLocks_Name:
      var params = reader.decodeStruct(StorageAccessHandle_BindLocks_Params);
      this.bindLocks(params.receiver);
      return true;
    case kStorageAccessHandle_BindCaches_Name:
      var params = reader.decodeStruct(StorageAccessHandle_BindCaches_Params);
      this.bindCaches(params.receiver);
      return true;
    case kStorageAccessHandle_BindBlobStorage_Name:
      var params = reader.decodeStruct(StorageAccessHandle_BindBlobStorage_Params);
      this.bindBlobStorage(params.receiver);
      return true;
    case kStorageAccessHandle_BindBroadcastChannel_Name:
      var params = reader.decodeStruct(StorageAccessHandle_BindBroadcastChannel_Params);
      this.bindBroadcastChannel(params.receiver);
      return true;
    case kStorageAccessHandle_BindSharedWorker_Name:
      var params = reader.decodeStruct(StorageAccessHandle_BindSharedWorker_Params);
      this.bindSharedWorker(params.receiver);
      return true;
    default:
      return false;
    }
  };

  StorageAccessHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kStorageAccessHandle_GetDirectory_Name:
      var params = reader.decodeStruct(StorageAccessHandle_GetDirectory_Params);
      this.getDirectory().then(function(response) {
        var responseParams =
            new StorageAccessHandle_GetDirectory_ResponseParams();
        responseParams.result = response.result;
        responseParams.directory = response.directory;
        var builder = new codec.MessageV1Builder(
            kStorageAccessHandle_GetDirectory_Name,
            codec.align(StorageAccessHandle_GetDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(StorageAccessHandle_GetDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kStorageAccessHandle_Estimate_Name:
      var params = reader.decodeStruct(StorageAccessHandle_Estimate_Params);
      this.estimate().then(function(response) {
        var responseParams =
            new StorageAccessHandle_Estimate_ResponseParams();
        responseParams.currentUsage = response.currentUsage;
        responseParams.currentQuota = response.currentQuota;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kStorageAccessHandle_Estimate_Name,
            codec.align(StorageAccessHandle_Estimate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(StorageAccessHandle_Estimate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateStorageAccessHandleRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kStorageAccessHandle_BindIndexedDB_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StorageAccessHandle_BindIndexedDB_Params;
      break;
      case kStorageAccessHandle_BindLocks_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StorageAccessHandle_BindLocks_Params;
      break;
      case kStorageAccessHandle_BindCaches_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StorageAccessHandle_BindCaches_Params;
      break;
      case kStorageAccessHandle_GetDirectory_Name:
        if (message.expectsResponse())
          paramsClass = StorageAccessHandle_GetDirectory_Params;
      break;
      case kStorageAccessHandle_Estimate_Name:
        if (message.expectsResponse())
          paramsClass = StorageAccessHandle_Estimate_Params;
      break;
      case kStorageAccessHandle_BindBlobStorage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StorageAccessHandle_BindBlobStorage_Params;
      break;
      case kStorageAccessHandle_BindBroadcastChannel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StorageAccessHandle_BindBroadcastChannel_Params;
      break;
      case kStorageAccessHandle_BindSharedWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StorageAccessHandle_BindSharedWorker_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateStorageAccessHandleResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kStorageAccessHandle_GetDirectory_Name:
        if (message.isResponse())
          paramsClass = StorageAccessHandle_GetDirectory_ResponseParams;
        break;
      case kStorageAccessHandle_Estimate_Name:
        if (message.isResponse())
          paramsClass = StorageAccessHandle_Estimate_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var StorageAccessHandle = {
    name: 'blink.mojom.StorageAccessHandle',
    kVersion: 0,
    ptrClass: StorageAccessHandlePtr,
    proxyClass: StorageAccessHandleProxy,
    stubClass: StorageAccessHandleStub,
    validateRequest: validateStorageAccessHandleRequest,
    validateResponse: validateStorageAccessHandleResponse,
  };
  StorageAccessHandleStub.prototype.validator = validateStorageAccessHandleRequest;
  StorageAccessHandleProxy.prototype.validator = validateStorageAccessHandleResponse;
  exports.StorageAccessHandle = StorageAccessHandle;
  exports.StorageAccessHandlePtr = StorageAccessHandlePtr;
  exports.StorageAccessHandleAssociatedPtr = StorageAccessHandleAssociatedPtr;
})();