// third_party/blink/public/mojom/subapps/sub_apps_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('blink.mojom.SubAppsServiceResultCode');
goog.provide('blink.mojom.SubAppsServiceResultCodeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SubAppsServiceResultCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SubAppsServiceResultCode = {
  
  kSuccess: 0,
  kFailure: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.SubAppsService');
goog.provide('blink.mojom.SubAppsServiceReceiver');
goog.provide('blink.mojom.SubAppsServiceCallbackRouter');
goog.provide('blink.mojom.SubAppsServiceInterface');
goog.provide('blink.mojom.SubAppsServiceRemote');
goog.provide('blink.mojom.SubAppsServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SubAppsServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SubAppsService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SubAppsServiceInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.SubAppsServiceAddParameters> } subAppsToAdd
   * @return {!Promise<{
        result: !Array<!blink.mojom.SubAppsServiceAddResult>,
   *  }>}
   */

  add(subAppsToAdd) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.SubAppsServiceListResult,
   *  }>}
   */

  list() {}
  
  /**
   * @param { !Array<!string> } manifestIdPaths
   * @return {!Promise<{
        result: !Array<!blink.mojom.SubAppsServiceRemoveResult>,
   *  }>}
   */

  remove(manifestIdPaths) {}
};

/**
 * @export
 * @implements { blink.mojom.SubAppsServiceInterface }
 */
blink.mojom.SubAppsServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SubAppsServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SubAppsServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SubAppsServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.SubAppsServiceAddParameters> } subAppsToAdd
   * @return {!Promise<{
        result: !Array<!blink.mojom.SubAppsServiceAddResult>,
   *  }>}
   */

  add(
      subAppsToAdd) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.SubAppsService_Add_ParamsSpec.$,
        blink.mojom.SubAppsService_Add_ResponseParamsSpec.$,
        [
          subAppsToAdd
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.SubAppsServiceListResult,
   *  }>}
   */

  list() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.SubAppsService_List_ParamsSpec.$,
        blink.mojom.SubAppsService_List_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } manifestIdPaths
   * @return {!Promise<{
        result: !Array<!blink.mojom.SubAppsServiceRemoveResult>,
   *  }>}
   */

  remove(
      manifestIdPaths) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.SubAppsService_Remove_ParamsSpec.$,
        blink.mojom.SubAppsService_Remove_ResponseParamsSpec.$,
        [
          manifestIdPaths
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SubAppsService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SubAppsServiceReceiver = class {
  /**
   * @param {!blink.mojom.SubAppsServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SubAppsServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SubAppsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SubAppsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SubAppsService_Add_ParamsSpec.$,
        blink.mojom.SubAppsService_Add_ResponseParamsSpec.$,
        impl.add.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SubAppsService_List_ParamsSpec.$,
        blink.mojom.SubAppsService_List_ResponseParamsSpec.$,
        impl.list.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SubAppsService_Remove_ParamsSpec.$,
        blink.mojom.SubAppsService_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SubAppsService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SubAppsService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SubAppsServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SubAppsServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SubAppsService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SubAppsServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SubAppsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SubAppsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.add =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SubAppsService_Add_ParamsSpec.$,
        blink.mojom.SubAppsService_Add_ResponseParamsSpec.$,
        this.add.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.list =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SubAppsService_List_ParamsSpec.$,
        blink.mojom.SubAppsService_List_ResponseParamsSpec.$,
        this.list.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SubAppsService_Remove_ParamsSpec.$,
        blink.mojom.SubAppsService_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SubAppsServiceAddParametersSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsServiceAddParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsServiceAddResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsServiceAddResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsServiceListResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsServiceListResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsServiceListResultEntrySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsServiceListResultEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsServiceRemoveResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsServiceRemoveResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsService_Add_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsService_Add_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsService_Add_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsService_Add_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsService_List_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsService_List_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsService_List_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsService_List_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsService_Remove_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsService_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SubAppsService_Remove_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SubAppsService_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SubAppsServiceAddParametersSpec.$,
    'SubAppsServiceAddParameters',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'installUrlPath', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SubAppsServiceAddParameters');

/** @record */
blink.mojom.SubAppsServiceAddParameters = class {
  constructor() {
    /** @export { !string } */
    this.manifestIdPath;
    /** @export { !string } */
    this.installUrlPath;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsServiceAddResultSpec.$,
    'SubAppsServiceAddResult',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultCode', 8,
        0,
        blink.mojom.SubAppsServiceResultCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SubAppsServiceAddResult');

/** @record */
blink.mojom.SubAppsServiceAddResult = class {
  constructor() {
    /** @export { !string } */
    this.manifestIdPath;
    /** @export { !blink.mojom.SubAppsServiceResultCode } */
    this.resultCode;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsServiceListResultSpec.$,
    'SubAppsServiceListResult',
    [
      mojo.internal.StructField(
        'resultCode', 0,
        0,
        blink.mojom.SubAppsServiceResultCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subAppsList', 8,
        0,
        mojo.internal.Array(blink.mojom.SubAppsServiceListResultEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SubAppsServiceListResult');

/** @record */
blink.mojom.SubAppsServiceListResult = class {
  constructor() {
    /** @export { !blink.mojom.SubAppsServiceResultCode } */
    this.resultCode;
    /** @export { !Array<!blink.mojom.SubAppsServiceListResultEntry> } */
    this.subAppsList;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsServiceListResultEntrySpec.$,
    'SubAppsServiceListResultEntry',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'appName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SubAppsServiceListResultEntry');

/** @record */
blink.mojom.SubAppsServiceListResultEntry = class {
  constructor() {
    /** @export { !string } */
    this.manifestIdPath;
    /** @export { !string } */
    this.appName;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsServiceRemoveResultSpec.$,
    'SubAppsServiceRemoveResult',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultCode', 8,
        0,
        blink.mojom.SubAppsServiceResultCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SubAppsServiceRemoveResult');

/** @record */
blink.mojom.SubAppsServiceRemoveResult = class {
  constructor() {
    /** @export { !string } */
    this.manifestIdPath;
    /** @export { !blink.mojom.SubAppsServiceResultCode } */
    this.resultCode;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsService_Add_ParamsSpec.$,
    'SubAppsService_Add_Params',
    [
      mojo.internal.StructField(
        'subAppsToAdd', 0,
        0,
        mojo.internal.Array(blink.mojom.SubAppsServiceAddParametersSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SubAppsService_Add_Params');

/** @record */
blink.mojom.SubAppsService_Add_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SubAppsServiceAddParameters> } */
    this.subAppsToAdd;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsService_Add_ResponseParamsSpec.$,
    'SubAppsService_Add_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(blink.mojom.SubAppsServiceAddResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SubAppsService_Add_ResponseParams');

/** @record */
blink.mojom.SubAppsService_Add_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SubAppsServiceAddResult> } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsService_List_ParamsSpec.$,
    'SubAppsService_List_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SubAppsService_List_Params');

/** @record */
blink.mojom.SubAppsService_List_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsService_List_ResponseParamsSpec.$,
    'SubAppsService_List_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.SubAppsServiceListResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SubAppsService_List_ResponseParams');

/** @record */
blink.mojom.SubAppsService_List_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.SubAppsServiceListResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsService_Remove_ParamsSpec.$,
    'SubAppsService_Remove_Params',
    [
      mojo.internal.StructField(
        'manifestIdPaths', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SubAppsService_Remove_Params');

/** @record */
blink.mojom.SubAppsService_Remove_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.manifestIdPaths;
  }
};



mojo.internal.Struct(
    blink.mojom.SubAppsService_Remove_ResponseParamsSpec.$,
    'SubAppsService_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(blink.mojom.SubAppsServiceRemoveResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SubAppsService_Remove_ResponseParams');

/** @record */
blink.mojom.SubAppsService_Remove_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SubAppsServiceRemoveResult> } */
    this.result;
  }
};

