// third_party/blink/public/mojom/timing/resource_timing.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  FetchResponseSource as network_mojom_FetchResponseSource,
  FetchResponseSourceSpec as network_mojom_FetchResponseSourceSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  LoadTimingInfo as network_mojom_LoadTimingInfo,
  LoadTimingInfoSpec as network_mojom_LoadTimingInfoSpec
} from '../../../../../services/network/public/mojom/load_timing_info.mojom.m.js';

import {
  ServiceWorkerRouterInfo as network_mojom_ServiceWorkerRouterInfo,
  ServiceWorkerRouterInfoSpec as network_mojom_ServiceWorkerRouterInfoSpec
} from '../../../../../services/network/public/mojom/service_worker_router_info.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CacheStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CacheState = {
  
  kNone: 0,
  kLocal: 1,
  kValidated: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServerTimingInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceTimingInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServerTimingInfoSpec.$,
    'ServerTimingInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'duration', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServerTimingInfo {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !number } */
    this.duration;
    /** @type { !string } */
    this.description;
  }
}



mojo.internal.Struct(
    ResourceTimingInfoSpec.$,
    'ResourceTimingInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startTime', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alpnNegotiatedProtocol', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionInfo', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timing', 32,
        0,
        network_mojom_LoadTimingInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastRedirectEndTime', 40,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseEnd', 48,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheState', 56,
        0,
        CacheStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedBodySize', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decodedBodySize', 72,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'didReuseConnection', 60,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSecureTransport', 60,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowTimingDetails', 60,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowNegativeValues', 60,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serverTiming', 80,
        0,
        mojo.internal.Array(ServerTimingInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'renderBlockingStatus', 60,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseStatus', 62,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentEncoding', 96,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorUrl', 104,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerRouterInfo', 112,
        0,
        network_mojom_ServiceWorkerRouterInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerResponseSource', 120,
        0,
        network_mojom_FetchResponseSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 136],]);



/**
 * @record
 */
export class ResourceTimingInfo {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.startTime;
    /** @type { !string } */
    this.alpnNegotiatedProtocol;
    /** @type { !string } */
    this.connectionInfo;
    /** @type { (network_mojom_LoadTimingInfo|undefined) } */
    this.timing;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.lastRedirectEndTime;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.responseEnd;
    /** @type { !CacheState } */
    this.cacheState;
    /** @type { !bigint } */
    this.encodedBodySize;
    /** @type { !bigint } */
    this.decodedBodySize;
    /** @type { !boolean } */
    this.didReuseConnection;
    /** @type { !boolean } */
    this.isSecureTransport;
    /** @type { !boolean } */
    this.allowTimingDetails;
    /** @type { !boolean } */
    this.allowNegativeValues;
    /** @type { !Array<!ServerTimingInfo> } */
    this.serverTiming;
    /** @type { !boolean } */
    this.renderBlockingStatus;
    /** @type { !number } */
    this.responseStatus;
    /** @type { !string } */
    this.contentType;
    /** @type { !string } */
    this.contentEncoding;
    /** @type { !url_mojom_Url } */
    this.initiatorUrl;
    /** @type { (network_mojom_ServiceWorkerRouterInfo|undefined) } */
    this.serviceWorkerRouterInfo;
    /** @type { !network_mojom_FetchResponseSource } */
    this.serviceWorkerResponseSource;
  }
}

