// third_party/blink/public/mojom/webauthn/authenticator.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');




/**
 * @const { !number }
 * @export
 */
blink.mojom.PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_LIST_MAX_SIZE = 64;


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AuthenticatorStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AuthenticatorStatus = {
  
  SUCCESS: 0,
  PENDING_REQUEST: 1,
  NOT_ALLOWED_ERROR: 2,
  INVALID_DOMAIN: 3,
  CREDENTIAL_EXCLUDED: 4,
  NOT_IMPLEMENTED: 5,
  NOT_FOCUSED: 6,
  RESIDENT_CREDENTIALS_UNSUPPORTED: 7,
  USER_VERIFICATION_UNSUPPORTED: 8,
  ALGORITHM_UNSUPPORTED: 9,
  EMPTY_ALLOW_CREDENTIALS: 10,
  ANDROID_NOT_SUPPORTED_ERROR: 11,
  PROTECTION_POLICY_INCONSISTENT: 12,
  ABORT_ERROR: 13,
  OPAQUE_DOMAIN: 14,
  INVALID_PROTOCOL: 15,
  BAD_RELYING_PARTY_ID: 16,
  BAD_RELYING_PARTY_ID_ATTEMPTED_FETCH: 17,
  BAD_RELYING_PARTY_ID_WRONG_CONTENT_TYPE: 18,
  BAD_RELYING_PARTY_ID_JSON_PARSE_ERROR: 19,
  BAD_RELYING_PARTY_ID_NO_JSON_MATCH: 20,
  BAD_RELYING_PARTY_ID_NO_JSON_MATCH_HIT_LIMITS: 21,
  CANNOT_READ_AND_WRITE_LARGE_BLOB: 22,
  INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB: 23,
  FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION: 24,
  REMOTE_DESKTOP_CLIENT_OVERRIDE_NOT_AUTHORIZED: 25,
  DEVICE_PUBLIC_KEY_ATTESTATION_REJECTED: 26,
  CERTIFICATE_ERROR: 27,
  ERROR_WITH_DOM_EXCEPTION_DETAILS: 28,
  IMMEDIATE_NOT_FOUND: 29,
  UNKNOWN_ERROR: 30,
  MIN_VALUE: 0,
  MAX_VALUE: 30,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AuthenticatorTransportSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AuthenticatorTransport = {
  
  USB: 0,
  NFC: 1,
  BLE: 2,
  HYBRID: 3,
  INTERNAL: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.HintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.Hint = {
  
  SECURITY_KEY: 0,
  CLIENT_DEVICE: 1,
  HYBRID: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.UserVerificationRequirementSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.UserVerificationRequirement = {
  
  REQUIRED: 0,
  PREFERRED: 1,
  DISCOURAGED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.Mediation = {
  
  MODAL: 0,
  CONDITIONAL: 1,
  IMMEDIATE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ResidentKeyRequirementSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ResidentKeyRequirement = {
  
  DISCOURAGED: 0,
  PREFERRED: 1,
  REQUIRED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AuthenticatorAttachmentSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AuthenticatorAttachment = {
  
  NO_PREFERENCE: 0,
  PLATFORM: 1,
  CROSS_PLATFORM: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ProtectionPolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ProtectionPolicy = {
  
  UNSPECIFIED: 0,
  NONE: 1,
  UV_OR_CRED_ID_REQUIRED: 2,
  UV_REQUIRED: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.LargeBlobSupportSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.LargeBlobSupport = {
  
  NOT_REQUESTED: 0,
  REQUIRED: 1,
  PREFERRED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AttestationConveyancePreferenceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AttestationConveyancePreference = {
  
  NONE: 0,
  INDIRECT: 1,
  DIRECT: 2,
  ENTERPRISE: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PublicKeyCredentialTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PublicKeyCredentialType = {
  
  PUBLIC_KEY: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AuthenticatorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.Authenticator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.AuthenticatorInterface }
 */
blink.mojom.AuthenticatorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AuthenticatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AuthenticatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AuthenticatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !blink.mojom.AuthenticatorStatus,
        credential: ?blink.mojom.MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?blink.mojom.WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makeCredential(
      options) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.Authenticator_MakeCredential_ParamsSpec.$,
        blink.mojom.Authenticator_MakeCredential_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.GetCredentialOptions } options
   * @return {!Promise<{
        response: !blink.mojom.GetCredentialResponse,
   *  }>}
   */

  getCredential(
      options) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.Authenticator_GetCredential_ParamsSpec.$,
        blink.mojom.Authenticator_GetCredential_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        available: !boolean,
   *  }>}
   */

  isUserVerifyingPlatformAuthenticatorAvailable() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
        blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        available: !boolean,
   *  }>}
   */

  isConditionalMediationAvailable() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
        blink.mojom.Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PublicKeyCredentialReportOptions } options
   * @return {!Promise<{
        status: !blink.mojom.AuthenticatorStatus,
        domExceptionDetails: ?blink.mojom.WebAuthnDOMExceptionDetails,
   *  }>}
   */

  report(
      options) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.Authenticator_Report_ParamsSpec.$,
        blink.mojom.Authenticator_Report_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        capabilities: !Array<!blink.mojom.WebAuthnClientCapability>,
   *  }>}
   */

  getClientCapabilities() {
    return this.proxy.sendMessage(
        5,
        blink.mojom.Authenticator_GetClientCapabilities_ParamsSpec.$,
        blink.mojom.Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        6,
        blink.mojom.Authenticator_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Authenticator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AuthenticatorReceiver = class {
  /**
   * @param {!blink.mojom.AuthenticatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AuthenticatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AuthenticatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AuthenticatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Authenticator_MakeCredential_ParamsSpec.$,
        blink.mojom.Authenticator_MakeCredential_ResponseParamsSpec.$,
        impl.makeCredential.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Authenticator_GetCredential_ParamsSpec.$,
        blink.mojom.Authenticator_GetCredential_ResponseParamsSpec.$,
        impl.getCredential.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
        blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
        impl.isUserVerifyingPlatformAuthenticatorAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
        blink.mojom.Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
        impl.isConditionalMediationAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.Authenticator_Report_ParamsSpec.$,
        blink.mojom.Authenticator_Report_ResponseParamsSpec.$,
        impl.report.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.Authenticator_GetClientCapabilities_ParamsSpec.$,
        blink.mojom.Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
        impl.getClientCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.Authenticator_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.Authenticator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Authenticator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AuthenticatorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AuthenticatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Authenticator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AuthenticatorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AuthenticatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AuthenticatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makeCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Authenticator_MakeCredential_ParamsSpec.$,
        blink.mojom.Authenticator_MakeCredential_ResponseParamsSpec.$,
        this.makeCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Authenticator_GetCredential_ParamsSpec.$,
        blink.mojom.Authenticator_GetCredential_ResponseParamsSpec.$,
        this.getCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isUserVerifyingPlatformAuthenticatorAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
        blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
        this.isUserVerifyingPlatformAuthenticatorAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isConditionalMediationAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
        blink.mojom.Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
        this.isConditionalMediationAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.report =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.Authenticator_Report_ParamsSpec.$,
        blink.mojom.Authenticator_Report_ResponseParamsSpec.$,
        this.report.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getClientCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.Authenticator_GetClientCapabilities_ParamsSpec.$,
        blink.mojom.Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
        this.getClientCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.Authenticator_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CommonCredentialInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SupplementalPubKeysResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AuthenticationExtensionsPaymentResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MakeCredentialAuthenticatorResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GetAssertionAuthenticatorResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AuthenticationExtensionsClientOutputsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialRpEntitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialUserEntitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CableAuthenticationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PRFValuesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PaymentOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PaymentCredentialInstrumentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ShownPaymentEntityLogoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteDesktopClientOverrideSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SupplementalPubKeysRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialRequestOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AuthenticationExtensionsClientInputsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GetCredentialOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AuthenticatorSelectionCriteriaSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialCreationOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebAuthnDOMExceptionDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PublicKeyCredentialReportOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AllAcceptedCredentialsOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CurrentUserDetailsOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebAuthnClientCapabilitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GetAssertionResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_MakeCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_MakeCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_GetCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_GetCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_IsConditionalMediationAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_Report_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_Report_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_GetClientCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_GetClientCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Authenticator_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.GetCredentialResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.CommonCredentialInfoSpec.$,
    'CommonCredentialInfo',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rawId', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientDataJson', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authenticatorData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.CommonCredentialInfo = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !Array<!number> } */
    this.rawId;
    /** @export { !Array<!number> } */
    this.clientDataJson;
    /** @export { !Array<!number> } */
    this.authenticatorData;
  }
};



mojo.internal.Struct(
    blink.mojom.SupplementalPubKeysResponseSpec.$,
    'SupplementalPubKeysResponse',
    [
      mojo.internal.StructField(
        'signatures', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SupplementalPubKeysResponse = class {
  constructor() {
    /** @export { !Array<!Array<!number>> } */
    this.signatures;
  }
};



mojo.internal.Struct(
    blink.mojom.AuthenticationExtensionsPaymentResponseSpec.$,
    'AuthenticationExtensionsPaymentResponse',
    [
      mojo.internal.StructField(
        'browserBoundSignature', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AuthenticationExtensionsPaymentResponse = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.browserBoundSignature;
  }
};



mojo.internal.Struct(
    blink.mojom.MakeCredentialAuthenticatorResponseSpec.$,
    'MakeCredentialAuthenticatorResponse',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink.mojom.CommonCredentialInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authenticatorAttachment', 8,
        0,
        blink.mojom.AuthenticatorAttachmentSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attestationObject', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transports', 24,
        0,
        mojo.internal.Array(blink.mojom.AuthenticatorTransportSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoHmacCreateSecret', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hmacCreateSecret', 12,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoPrf', 12,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prf', 12,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prfResults', 32,
        0,
        blink.mojom.PRFValuesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoCredBlob', 12,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credBlob', 12,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'publicKeyDer', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'publicKeyAlgo', 48,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoCredProps', 12,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasCredPropsRk', 12,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credPropsRk', 13,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoLargeBlob', 13,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportsLargeBlob', 13,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 56,
        0,
        blink.mojom.SupplementalPubKeysResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payment', 64,
        0,
        blink.mojom.AuthenticationExtensionsPaymentResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);





/** @record */
blink.mojom.MakeCredentialAuthenticatorResponse = class {
  constructor() {
    /** @export { !blink.mojom.CommonCredentialInfo } */
    this.info;
    /** @export { !blink.mojom.AuthenticatorAttachment } */
    this.authenticatorAttachment;
    /** @export { !Array<!number> } */
    this.attestationObject;
    /** @export { !Array<!blink.mojom.AuthenticatorTransport> } */
    this.transports;
    /** @export { !boolean } */
    this.echoHmacCreateSecret;
    /** @export { !boolean } */
    this.hmacCreateSecret;
    /** @export { !boolean } */
    this.echoPrf;
    /** @export { !boolean } */
    this.prf;
    /** @export { (blink.mojom.PRFValues|undefined) } */
    this.prfResults;
    /** @export { !boolean } */
    this.echoCredBlob;
    /** @export { !boolean } */
    this.credBlob;
    /** @export { (Array<!number>|undefined) } */
    this.publicKeyDer;
    /** @export { !number } */
    this.publicKeyAlgo;
    /** @export { !boolean } */
    this.echoCredProps;
    /** @export { !boolean } */
    this.hasCredPropsRk;
    /** @export { !boolean } */
    this.credPropsRk;
    /** @export { !boolean } */
    this.echoLargeBlob;
    /** @export { !boolean } */
    this.supportsLargeBlob;
    /** @export { (blink.mojom.SupplementalPubKeysResponse|undefined) } */
    this.supplementalPubKeys;
    /** @export { (blink.mojom.AuthenticationExtensionsPaymentResponse|undefined) } */
    this.payment;
  }
};



mojo.internal.Struct(
    blink.mojom.GetAssertionAuthenticatorResponseSpec.$,
    'GetAssertionAuthenticatorResponse',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink.mojom.CommonCredentialInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authenticatorAttachment', 8,
        0,
        blink.mojom.AuthenticatorAttachmentSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'signature', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userHandle', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensions', 32,
        0,
        blink.mojom.AuthenticationExtensionsClientOutputsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.GetAssertionAuthenticatorResponse = class {
  constructor() {
    /** @export { !blink.mojom.CommonCredentialInfo } */
    this.info;
    /** @export { !blink.mojom.AuthenticatorAttachment } */
    this.authenticatorAttachment;
    /** @export { !Array<!number> } */
    this.signature;
    /** @export { (Array<!number>|undefined) } */
    this.userHandle;
    /** @export { !blink.mojom.AuthenticationExtensionsClientOutputs } */
    this.extensions;
  }
};



mojo.internal.Struct(
    blink.mojom.AuthenticationExtensionsClientOutputsSpec.$,
    'AuthenticationExtensionsClientOutputs',
    [
      mojo.internal.StructField(
        'echoAppidExtension', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'appidExtension', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoPrf', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prfResults', 8,
        0,
        blink.mojom.PRFValuesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prfNotEvaluated', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoLargeBlob', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'largeBlob', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoLargeBlobWritten', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'largeBlobWritten', 0,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'getCredBlob', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 32,
        0,
        blink.mojom.SupplementalPubKeysResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payment', 40,
        0,
        blink.mojom.AuthenticationExtensionsPaymentResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.AuthenticationExtensionsClientOutputs = class {
  constructor() {
    /** @export { !boolean } */
    this.echoAppidExtension;
    /** @export { !boolean } */
    this.appidExtension;
    /** @export { !boolean } */
    this.echoPrf;
    /** @export { (blink.mojom.PRFValues|undefined) } */
    this.prfResults;
    /** @export { !boolean } */
    this.prfNotEvaluated;
    /** @export { !boolean } */
    this.echoLargeBlob;
    /** @export { (Array<!number>|undefined) } */
    this.largeBlob;
    /** @export { !boolean } */
    this.echoLargeBlobWritten;
    /** @export { !boolean } */
    this.largeBlobWritten;
    /** @export { (Array<!number>|undefined) } */
    this.getCredBlob;
    /** @export { (blink.mojom.SupplementalPubKeysResponse|undefined) } */
    this.supplementalPubKeys;
    /** @export { (blink.mojom.AuthenticationExtensionsPaymentResponse|undefined) } */
    this.payment;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialRpEntitySpec.$,
    'PublicKeyCredentialRpEntity',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PublicKeyCredentialRpEntity = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialUserEntitySpec.$,
    'PublicKeyCredentialUserEntity',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PublicKeyCredentialUserEntity = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.id;
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.displayName;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialParametersSpec.$,
    'PublicKeyCredentialParameters',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.PublicKeyCredentialTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'algorithmIdentifier', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PublicKeyCredentialParameters = class {
  constructor() {
    /** @export { !blink.mojom.PublicKeyCredentialType } */
    this.type;
    /** @export { !number } */
    this.algorithmIdentifier;
  }
};



mojo.internal.Struct(
    blink.mojom.CableAuthenticationSpec.$,
    'CableAuthentication',
    [
      mojo.internal.StructField(
        'version', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientEid', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authenticatorEid', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionPreKey', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serverLinkData', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'experiments', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.CableAuthentication = class {
  constructor() {
    /** @export { !number } */
    this.version;
    /** @export { (Array<!number>|undefined) } */
    this.clientEid;
    /** @export { (Array<!number>|undefined) } */
    this.authenticatorEid;
    /** @export { (Array<!number>|undefined) } */
    this.sessionPreKey;
    /** @export { (Array<!number>|undefined) } */
    this.serverLinkData;
    /** @export { (Array<!number>|undefined) } */
    this.experiments;
  }
};



mojo.internal.Struct(
    blink.mojom.PRFValuesSpec.$,
    'PRFValues',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'first', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'second', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PRFValues = class {
  constructor() {
    /** @export { (Array<!number>|undefined) } */
    this.id;
    /** @export { !Array<!number> } */
    this.first;
    /** @export { (Array<!number>|undefined) } */
    this.second;
  }
};



mojo.internal.Struct(
    blink.mojom.PaymentOptionsSpec.$,
    'PaymentOptions',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments.mojom.PaymentCurrencyAmountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instrument', 8,
        0,
        blink.mojom.PaymentCredentialInstrumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payeeName', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payeeOrigin', 24,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentEntitiesLogos', 32,
        0,
        mojo.internal.Array(blink.mojom.ShownPaymentEntityLogoSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browserBoundPublicKey', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.PaymentOptions = class {
  constructor() {
    /** @export { !payments.mojom.PaymentCurrencyAmount } */
    this.total;
    /** @export { !blink.mojom.PaymentCredentialInstrument } */
    this.instrument;
    /** @export { (string|undefined) } */
    this.payeeName;
    /** @export { (url.mojom.Origin|undefined) } */
    this.payeeOrigin;
    /** @export { (Array<!blink.mojom.ShownPaymentEntityLogo>|undefined) } */
    this.paymentEntitiesLogos;
    /** @export { (Array<!number>|undefined) } */
    this.browserBoundPublicKey;
  }
};



mojo.internal.Struct(
    blink.mojom.PaymentCredentialInstrumentSpec.$,
    'PaymentCredentialInstrument',
    [
      mojo.internal.StructField(
        'displayName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'iconMustBeShown', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.PaymentCredentialInstrument = class {
  constructor() {
    /** @export { !string } */
    this.displayName;
    /** @export { !url.mojom.Url } */
    this.icon;
    /** @export { !boolean } */
    this.iconMustBeShown;
    /** @export { (string|undefined) } */
    this.details;
  }
};



mojo.internal.Struct(
    blink.mojom.ShownPaymentEntityLogoSpec.$,
    'ShownPaymentEntityLogo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.ShownPaymentEntityLogo = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.label;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteDesktopClientOverrideSpec.$,
    'RemoteDesktopClientOverride',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sameOriginWithAncestors', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteDesktopClientOverride = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !boolean } */
    this.sameOriginWithAncestors;
  }
};



mojo.internal.Struct(
    blink.mojom.SupplementalPubKeysRequestSpec.$,
    'SupplementalPubKeysRequest',
    [
      mojo.internal.StructField(
        'deviceScopeRequested', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'providerScopeRequested', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attestation', 4,
        0,
        blink.mojom.AttestationConveyancePreferenceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attestationFormats', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SupplementalPubKeysRequest = class {
  constructor() {
    /** @export { !boolean } */
    this.deviceScopeRequested;
    /** @export { !boolean } */
    this.providerScopeRequested;
    /** @export { !blink.mojom.AttestationConveyancePreference } */
    this.attestation;
    /** @export { !Array<!string> } */
    this.attestationFormats;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialRequestOptionsSpec.$,
    'PublicKeyCredentialRequestOptions',
    [
      mojo.internal.StructField(
        'challenge', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'challengeUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'relyingPartyId', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowCredentials', 32,
        0,
        mojo.internal.Array(blink.mojom.PublicKeyCredentialDescriptorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hints', 40,
        0,
        mojo.internal.Array(blink.mojom.HintSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userVerification', 48,
        0,
        blink.mojom.UserVerificationRequirementSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensions', 56,
        0,
        blink.mojom.AuthenticationExtensionsClientInputsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
blink.mojom.PublicKeyCredentialRequestOptions = class {
  constructor() {
    /** @export { (Array<!number>|undefined) } */
    this.challenge;
    /** @export { (url.mojom.Url|undefined) } */
    this.challengeUrl;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.timeout;
    /** @export { !string } */
    this.relyingPartyId;
    /** @export { !Array<!blink.mojom.PublicKeyCredentialDescriptor> } */
    this.allowCredentials;
    /** @export { !Array<!blink.mojom.Hint> } */
    this.hints;
    /** @export { !blink.mojom.UserVerificationRequirement } */
    this.userVerification;
    /** @export { !blink.mojom.AuthenticationExtensionsClientInputs } */
    this.extensions;
  }
};



mojo.internal.Struct(
    blink.mojom.AuthenticationExtensionsClientInputsSpec.$,
    'AuthenticationExtensionsClientInputs',
    [
      mojo.internal.StructField(
        'appid', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cableAuthenticationData', 8,
        0,
        mojo.internal.Array(blink.mojom.CableAuthenticationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prf', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prfInputs', 24,
        0,
        mojo.internal.Array(blink.mojom.PRFValuesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'largeBlobRead', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'largeBlobWrite', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'getCredBlob', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteDesktopClientOverride', 40,
        0,
        blink.mojom.RemoteDesktopClientOverrideSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 48,
        0,
        blink.mojom.SupplementalPubKeysRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentBrowserBoundKeyParameters', 56,
        0,
        mojo.internal.Array(blink.mojom.PublicKeyCredentialParametersSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
blink.mojom.AuthenticationExtensionsClientInputs = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.appid;
    /** @export { !Array<!blink.mojom.CableAuthentication> } */
    this.cableAuthenticationData;
    /** @export { !boolean } */
    this.prf;
    /** @export { !Array<!blink.mojom.PRFValues> } */
    this.prfInputs;
    /** @export { !boolean } */
    this.largeBlobRead;
    /** @export { (Array<!number>|undefined) } */
    this.largeBlobWrite;
    /** @export { !boolean } */
    this.getCredBlob;
    /** @export { (blink.mojom.RemoteDesktopClientOverride|undefined) } */
    this.remoteDesktopClientOverride;
    /** @export { (blink.mojom.SupplementalPubKeysRequest|undefined) } */
    this.supplementalPubKeys;
    /** @export { (Array<!blink.mojom.PublicKeyCredentialParameters>|undefined) } */
    this.paymentBrowserBoundKeyParameters;
  }
};



mojo.internal.Struct(
    blink.mojom.GetCredentialOptionsSpec.$,
    'GetCredentialOptions',
    [
      mojo.internal.StructField(
        'mediation', 0,
        0,
        blink.mojom.MediationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'publicKey', 8,
        0,
        blink.mojom.PublicKeyCredentialRequestOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'password', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.GetCredentialOptions = class {
  constructor() {
    /** @export { !blink.mojom.Mediation } */
    this.mediation;
    /** @export { (blink.mojom.PublicKeyCredentialRequestOptions|undefined) } */
    this.publicKey;
    /** @export { !boolean } */
    this.password;
  }
};



mojo.internal.Struct(
    blink.mojom.AuthenticatorSelectionCriteriaSpec.$,
    'AuthenticatorSelectionCriteria',
    [
      mojo.internal.StructField(
        'authenticatorAttachment', 0,
        0,
        blink.mojom.AuthenticatorAttachmentSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'residentKey', 4,
        0,
        blink.mojom.ResidentKeyRequirementSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userVerification', 8,
        0,
        blink.mojom.UserVerificationRequirementSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.AuthenticatorSelectionCriteria = class {
  constructor() {
    /** @export { !blink.mojom.AuthenticatorAttachment } */
    this.authenticatorAttachment;
    /** @export { !blink.mojom.ResidentKeyRequirement } */
    this.residentKey;
    /** @export { !blink.mojom.UserVerificationRequirement } */
    this.userVerification;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialCreationOptionsSpec.$,
    'PublicKeyCredentialCreationOptions',
    [
      mojo.internal.StructField(
        'relyingParty', 0,
        0,
        blink.mojom.PublicKeyCredentialRpEntitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'user', 8,
        0,
        blink.mojom.PublicKeyCredentialUserEntitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'challenge', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'publicKeyParameters', 24,
        0,
        mojo.internal.Array(blink.mojom.PublicKeyCredentialParametersSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 32,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludeCredentials', 40,
        0,
        mojo.internal.Array(blink.mojom.PublicKeyCredentialDescriptorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authenticatorSelection', 48,
        0,
        blink.mojom.AuthenticatorSelectionCriteriaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hints', 56,
        0,
        mojo.internal.Array(blink.mojom.HintSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attestation', 64,
        0,
        blink.mojom.AttestationConveyancePreferenceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hmacCreateSecret', 68,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prfEnable', 68,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prfInput', 72,
        0,
        blink.mojom.PRFValuesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protectionPolicy', 80,
        0,
        blink.mojom.ProtectionPolicySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enforceProtectionPolicy', 68,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'appidExclude', 88,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credProps', 68,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'largeBlobEnable', 84,
        0,
        blink.mojom.LargeBlobSupportSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPaymentCredentialCreation', 68,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credBlob', 96,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minPinLengthRequested', 68,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteDesktopClientOverride', 104,
        0,
        blink.mojom.RemoteDesktopClientOverrideSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 112,
        0,
        blink.mojom.SupplementalPubKeysRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentBrowserBoundKeyParameters', 120,
        0,
        mojo.internal.Array(blink.mojom.PublicKeyCredentialParametersSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attestationFormats', 128,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isConditional', 68,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 144],]);





/** @record */
blink.mojom.PublicKeyCredentialCreationOptions = class {
  constructor() {
    /** @export { !blink.mojom.PublicKeyCredentialRpEntity } */
    this.relyingParty;
    /** @export { !blink.mojom.PublicKeyCredentialUserEntity } */
    this.user;
    /** @export { !Array<!number> } */
    this.challenge;
    /** @export { !Array<!blink.mojom.PublicKeyCredentialParameters> } */
    this.publicKeyParameters;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.timeout;
    /** @export { !Array<!blink.mojom.PublicKeyCredentialDescriptor> } */
    this.excludeCredentials;
    /** @export { (blink.mojom.AuthenticatorSelectionCriteria|undefined) } */
    this.authenticatorSelection;
    /** @export { !Array<!blink.mojom.Hint> } */
    this.hints;
    /** @export { !blink.mojom.AttestationConveyancePreference } */
    this.attestation;
    /** @export { !boolean } */
    this.hmacCreateSecret;
    /** @export { !boolean } */
    this.prfEnable;
    /** @export { (blink.mojom.PRFValues|undefined) } */
    this.prfInput;
    /** @export { !blink.mojom.ProtectionPolicy } */
    this.protectionPolicy;
    /** @export { !boolean } */
    this.enforceProtectionPolicy;
    /** @export { (string|undefined) } */
    this.appidExclude;
    /** @export { !boolean } */
    this.credProps;
    /** @export { !blink.mojom.LargeBlobSupport } */
    this.largeBlobEnable;
    /** @export { !boolean } */
    this.isPaymentCredentialCreation;
    /** @export { (Array<!number>|undefined) } */
    this.credBlob;
    /** @export { !boolean } */
    this.minPinLengthRequested;
    /** @export { (blink.mojom.RemoteDesktopClientOverride|undefined) } */
    this.remoteDesktopClientOverride;
    /** @export { (blink.mojom.SupplementalPubKeysRequest|undefined) } */
    this.supplementalPubKeys;
    /** @export { (Array<!blink.mojom.PublicKeyCredentialParameters>|undefined) } */
    this.paymentBrowserBoundKeyParameters;
    /** @export { !Array<!string> } */
    this.attestationFormats;
    /** @export { !boolean } */
    this.isConditional;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialDescriptorSpec.$,
    'PublicKeyCredentialDescriptor',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.PublicKeyCredentialTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transports', 16,
        0,
        mojo.internal.Array(blink.mojom.AuthenticatorTransportSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PublicKeyCredentialDescriptor = class {
  constructor() {
    /** @export { !blink.mojom.PublicKeyCredentialType } */
    this.type;
    /** @export { !Array<!number> } */
    this.id;
    /** @export { !Array<!blink.mojom.AuthenticatorTransport> } */
    this.transports;
  }
};



mojo.internal.Struct(
    blink.mojom.WebAuthnDOMExceptionDetailsSpec.$,
    'WebAuthnDOMExceptionDetails',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebAuthnDOMExceptionDetails = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.PublicKeyCredentialReportOptionsSpec.$,
    'PublicKeyCredentialReportOptions',
    [
      mojo.internal.StructField(
        'relyingPartyId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unknownCredentialId', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allAcceptedCredentials', 16,
        0,
        blink.mojom.AllAcceptedCredentialsOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentUserDetails', 24,
        0,
        blink.mojom.CurrentUserDetailsOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.PublicKeyCredentialReportOptions = class {
  constructor() {
    /** @export { !string } */
    this.relyingPartyId;
    /** @export { (Array<!number>|undefined) } */
    this.unknownCredentialId;
    /** @export { (blink.mojom.AllAcceptedCredentialsOptions|undefined) } */
    this.allAcceptedCredentials;
    /** @export { (blink.mojom.CurrentUserDetailsOptions|undefined) } */
    this.currentUserDetails;
  }
};



mojo.internal.Struct(
    blink.mojom.AllAcceptedCredentialsOptionsSpec.$,
    'AllAcceptedCredentialsOptions',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allAcceptedCredentialsIds', 8,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.AllAcceptedCredentialsOptions = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.userId;
    /** @export { !Array<!Array<!number>> } */
    this.allAcceptedCredentialsIds;
  }
};



mojo.internal.Struct(
    blink.mojom.CurrentUserDetailsOptionsSpec.$,
    'CurrentUserDetailsOptions',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CurrentUserDetailsOptions = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.userId;
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.displayName;
  }
};



mojo.internal.Struct(
    blink.mojom.WebAuthnClientCapabilitySpec.$,
    'WebAuthnClientCapability',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supported', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebAuthnClientCapability = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !boolean } */
    this.supported;
  }
};



mojo.internal.Struct(
    blink.mojom.GetAssertionResponseSpec.$,
    'GetAssertionResponse',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.AuthenticatorStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        blink.mojom.GetAssertionAuthenticatorResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 16,
        0,
        blink.mojom.WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.GetAssertionResponse = class {
  constructor() {
    /** @export { !blink.mojom.AuthenticatorStatus } */
    this.status;
    /** @export { (blink.mojom.GetAssertionAuthenticatorResponse|undefined) } */
    this.credential;
    /** @export { (blink.mojom.WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_MakeCredential_ParamsSpec.$,
    'Authenticator_MakeCredential_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.PublicKeyCredentialCreationOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.Authenticator_MakeCredential_Params = class {
  constructor() {
    /** @export { !blink.mojom.PublicKeyCredentialCreationOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_MakeCredential_ResponseParamsSpec.$,
    'Authenticator_MakeCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.AuthenticatorStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        blink.mojom.MakeCredentialAuthenticatorResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 16,
        0,
        blink.mojom.WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.Authenticator_MakeCredential_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.AuthenticatorStatus } */
    this.status;
    /** @export { (blink.mojom.MakeCredentialAuthenticatorResponse|undefined) } */
    this.credential;
    /** @export { (blink.mojom.WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_GetCredential_ParamsSpec.$,
    'Authenticator_GetCredential_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.GetCredentialOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.Authenticator_GetCredential_Params = class {
  constructor() {
    /** @export { !blink.mojom.GetCredentialOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_GetCredential_ResponseParamsSpec.$,
    'Authenticator_GetCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink.mojom.GetCredentialResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.Authenticator_GetCredential_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.GetCredentialResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
    'Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
    'Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.available;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
    'Authenticator_IsConditionalMediationAvailable_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.Authenticator_IsConditionalMediationAvailable_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
    'Authenticator_IsConditionalMediationAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.Authenticator_IsConditionalMediationAvailable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.available;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_Report_ParamsSpec.$,
    'Authenticator_Report_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.PublicKeyCredentialReportOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.Authenticator_Report_Params = class {
  constructor() {
    /** @export { !blink.mojom.PublicKeyCredentialReportOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_Report_ResponseParamsSpec.$,
    'Authenticator_Report_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.AuthenticatorStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 8,
        0,
        blink.mojom.WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.Authenticator_Report_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.AuthenticatorStatus } */
    this.status;
    /** @export { (blink.mojom.WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_GetClientCapabilities_ParamsSpec.$,
    'Authenticator_GetClientCapabilities_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.Authenticator_GetClientCapabilities_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
    'Authenticator_GetClientCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'capabilities', 0,
        0,
        mojo.internal.Array(blink.mojom.WebAuthnClientCapabilitySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.Authenticator_GetClientCapabilities_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.WebAuthnClientCapability> } */
    this.capabilities;
  }
};



mojo.internal.Struct(
    blink.mojom.Authenticator_Cancel_ParamsSpec.$,
    'Authenticator_Cancel_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.Authenticator_Cancel_Params = class {
  constructor() {
  }
};



mojo.internal.Union(
    blink.mojom.GetCredentialResponseSpec.$, 'GetCredentialResponse',
    {
      'getAssertionResponse': {
        'ordinal': 0,
        'type': blink.mojom.GetAssertionResponseSpec.$,
      },
      'passwordResponse': {
        'ordinal': 1,
        'type': blink.mojom.CredentialInfoSpec.$,
      },
    });

/**
 * @typedef { {
 *   getAssertionResponse: (!blink.mojom.GetAssertionResponse|undefined),
 *   passwordResponse: (!blink.mojom.CredentialInfo|undefined),
 * } }
 */
blink.mojom.GetCredentialResponse;
