// third_party/blink/public/mojom/webid/federated_auth_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/webid/federated_auth_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../../mojo/public/mojom/base/values.mojom.js');
  }
  var credential_manager$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom', '../credentialmanagement/credential_manager.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var RequestTokenStatus = {};
  RequestTokenStatus.kSuccess = 0;
  RequestTokenStatus.kErrorTooManyRequests = 1;
  RequestTokenStatus.kErrorCanceled = 2;
  RequestTokenStatus.kError = 3;
  RequestTokenStatus.MIN_VALUE = 0;
  RequestTokenStatus.MAX_VALUE = 3;

  RequestTokenStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  RequestTokenStatus.toKnownEnumValue = function(value) {
    return value;
  };

  RequestTokenStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RequestUserInfoStatus = {};
  RequestUserInfoStatus.kSuccess = 0;
  RequestUserInfoStatus.kError = 1;
  RequestUserInfoStatus.MIN_VALUE = 0;
  RequestUserInfoStatus.MAX_VALUE = 1;

  RequestUserInfoStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  RequestUserInfoStatus.toKnownEnumValue = function(value) {
    return value;
  };

  RequestUserInfoStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DisconnectStatus = {};
  DisconnectStatus.kSuccess = 0;
  DisconnectStatus.kErrorTooManyRequests = 1;
  DisconnectStatus.kError = 2;
  DisconnectStatus.MIN_VALUE = 0;
  DisconnectStatus.MAX_VALUE = 2;

  DisconnectStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  DisconnectStatus.toKnownEnumValue = function(value) {
    return value;
  };

  DisconnectStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IdpSigninStatus = {};
  IdpSigninStatus.kSignedIn = 0;
  IdpSigninStatus.kSignedOut = 1;
  IdpSigninStatus.MIN_VALUE = 0;
  IdpSigninStatus.MAX_VALUE = 1;

  IdpSigninStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  IdpSigninStatus.toKnownEnumValue = function(value) {
    return value;
  };

  IdpSigninStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RpContext = {};
  RpContext.kSignIn = 0;
  RpContext.kSignUp = 1;
  RpContext.kUse = 2;
  RpContext.kContinue = 3;
  RpContext.MIN_VALUE = 0;
  RpContext.MAX_VALUE = 3;

  RpContext.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  RpContext.toKnownEnumValue = function(value) {
    return value;
  };

  RpContext.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RpMode = {};
  RpMode.kActive = 0;
  RpMode.kPassive = 1;
  RpMode.MIN_VALUE = 0;
  RpMode.MAX_VALUE = 1;

  RpMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  RpMode.toKnownEnumValue = function(value) {
    return value;
  };

  RpMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RegisterIdpStatus = {};
  RegisterIdpStatus.kSuccess = 0;
  RegisterIdpStatus.kErrorFeatureDisabled = 1;
  RegisterIdpStatus.kErrorCrossOriginConfig = 2;
  RegisterIdpStatus.kErrorNoTransientActivation = 3;
  RegisterIdpStatus.kErrorDeclined = 4;
  RegisterIdpStatus.kErrorInvalidConfig = 5;
  RegisterIdpStatus.MIN_VALUE = 0;
  RegisterIdpStatus.MAX_VALUE = 5;

  RegisterIdpStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  RegisterIdpStatus.toKnownEnumValue = function(value) {
    return value;
  };

  RegisterIdpStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Format = {};
  Format.kSdJwt = 0;
  Format.MIN_VALUE = 0;
  Format.MAX_VALUE = 0;

  Format.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  Format.toKnownEnumValue = function(value) {
    return value;
  };

  Format.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function IdentityProviderConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IdentityProviderConfig.prototype.initDefaults_ = function() {
    this.configUrl = null;
    this.fromIdpRegistrationApi = false;
    this.type = null;
    this.clientId = null;
  };
  IdentityProviderConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IdentityProviderConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderConfig.configUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IdentityProviderConfig.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderConfig.clientId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IdentityProviderConfig.encodedSize = codec.kStructHeaderSize + 32;

  IdentityProviderConfig.decode = function(decoder) {
    var packed;
    var val = new IdentityProviderConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.configUrl =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.fromIdpRegistrationApi = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.type =
        decoder.decodeStruct(codec.String);
    val.clientId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  IdentityProviderConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IdentityProviderConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.configUrl);
    packed = 0;
    packed |= (val.fromIdpRegistrationApi & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStruct(codec.String, val.clientId);
  };
  function IdentityProviderRequestOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IdentityProviderRequestOptions.prototype.initDefaults_ = function() {
    this.config = null;
    this.nonce = null;
    this.loginHint = null;
    this.domainHint = null;
    this.fields = null;
    this.paramsJson = null;
    this.format_$flag = false;
    this.format_$value = 0;
  };
  IdentityProviderRequestOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IdentityProviderRequestOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderRequestOptions.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, IdentityProviderConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderRequestOptions.nonce
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderRequestOptions.loginHint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderRequestOptions.domainHint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderRequestOptions.fields
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderRequestOptions.paramsJson
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate IdentityProviderRequestOptions.format_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 52, Format);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IdentityProviderRequestOptions.encodedSize = codec.kStructHeaderSize + 56;

  IdentityProviderRequestOptions.decode = function(decoder) {
    var packed;
    var val = new IdentityProviderRequestOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(IdentityProviderConfig);
    val.nonce =
        decoder.decodeStruct(codec.String);
    val.loginHint =
        decoder.decodeStruct(codec.String);
    val.domainHint =
        decoder.decodeStruct(codec.String);
    val.fields =
        decoder.decodeArrayPointer(codec.String);
    val.paramsJson =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.format_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.format_$value =
        decoder.decodeStruct(new codec.Enum(Format));
    return val;
  };

  IdentityProviderRequestOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IdentityProviderRequestOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(IdentityProviderConfig, val.config);
    encoder.encodeStruct(codec.String, val.nonce);
    encoder.encodeStruct(codec.String, val.loginHint);
    encoder.encodeStruct(codec.String, val.domainHint);
    encoder.encodeArrayPointer(codec.String, val.fields);
    encoder.encodeStruct(codec.String, val.paramsJson);
    packed = 0;
    packed |= (val.format_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.format_$value);
  };
  function IdentityCredentialDisconnectOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IdentityCredentialDisconnectOptions.prototype.initDefaults_ = function() {
    this.config = null;
    this.accountHint = null;
  };
  IdentityCredentialDisconnectOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IdentityCredentialDisconnectOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityCredentialDisconnectOptions.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, IdentityProviderConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityCredentialDisconnectOptions.accountHint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IdentityCredentialDisconnectOptions.encodedSize = codec.kStructHeaderSize + 16;

  IdentityCredentialDisconnectOptions.decode = function(decoder) {
    var packed;
    var val = new IdentityCredentialDisconnectOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(IdentityProviderConfig);
    val.accountHint =
        decoder.decodeStruct(codec.String);
    return val;
  };

  IdentityCredentialDisconnectOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IdentityCredentialDisconnectOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(IdentityProviderConfig, val.config);
    encoder.encodeStruct(codec.String, val.accountHint);
  };
  function IdentityUserInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IdentityUserInfo.prototype.initDefaults_ = function() {
    this.email = null;
    this.givenName = null;
    this.name = null;
    this.picture = null;
  };
  IdentityUserInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IdentityUserInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityUserInfo.email
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityUserInfo.givenName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityUserInfo.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityUserInfo.picture
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IdentityUserInfo.encodedSize = codec.kStructHeaderSize + 32;

  IdentityUserInfo.decode = function(decoder) {
    var packed;
    var val = new IdentityUserInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.email =
        decoder.decodeStruct(codec.String);
    val.givenName =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    val.picture =
        decoder.decodeStruct(codec.String);
    return val;
  };

  IdentityUserInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IdentityUserInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.email);
    encoder.encodeStruct(codec.String, val.givenName);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.picture);
  };
  function LoginStatusAccount(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoginStatusAccount.prototype.initDefaults_ = function() {
    this.id = null;
    this.email = null;
    this.name = null;
    this.givenName = null;
    this.picture = null;
  };
  LoginStatusAccount.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoginStatusAccount.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusAccount.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusAccount.email
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusAccount.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusAccount.givenName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusAccount.picture
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LoginStatusAccount.encodedSize = codec.kStructHeaderSize + 40;

  LoginStatusAccount.decode = function(decoder) {
    var packed;
    var val = new LoginStatusAccount();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    val.email =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    val.givenName =
        decoder.decodeStruct(codec.String);
    val.picture =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  LoginStatusAccount.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoginStatusAccount.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.email);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.givenName);
    encoder.encodeStructPointer(url$.Url, val.picture);
  };
  function LoginStatusOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoginStatusOptions.prototype.initDefaults_ = function() {
    this.accounts = null;
    this.expiration = null;
  };
  LoginStatusOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoginStatusOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusOptions.accounts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(LoginStatusAccount), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoginStatusOptions.expiration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LoginStatusOptions.encodedSize = codec.kStructHeaderSize + 16;

  LoginStatusOptions.decode = function(decoder) {
    var packed;
    var val = new LoginStatusOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.accounts =
        decoder.decodeArrayPointer(new codec.PointerTo(LoginStatusAccount));
    val.expiration =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  LoginStatusOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoginStatusOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(LoginStatusAccount), val.accounts);
    encoder.encodeStructPointer(time$.TimeDelta, val.expiration);
  };
  function IdentityProviderGetParameters(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IdentityProviderGetParameters.prototype.initDefaults_ = function() {
    this.providers = null;
    this.context = 0;
    this.mode = 0;
  };
  IdentityProviderGetParameters.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IdentityProviderGetParameters.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderGetParameters.providers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(IdentityProviderRequestOptions), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderGetParameters.context
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, RpContext);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IdentityProviderGetParameters.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, RpMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IdentityProviderGetParameters.encodedSize = codec.kStructHeaderSize + 16;

  IdentityProviderGetParameters.decode = function(decoder) {
    var packed;
    var val = new IdentityProviderGetParameters();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.providers =
        decoder.decodeArrayPointer(new codec.PointerTo(IdentityProviderRequestOptions));
    val.context =
        decoder.decodeStruct(new codec.Enum(RpContext));
    val.mode =
        decoder.decodeStruct(new codec.Enum(RpMode));
    return val;
  };

  IdentityProviderGetParameters.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IdentityProviderGetParameters.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(IdentityProviderRequestOptions), val.providers);
    encoder.encodeStruct(codec.Int32, val.context);
    encoder.encodeStruct(codec.Int32, val.mode);
  };
  function TokenError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TokenError.prototype.initDefaults_ = function() {
    this.code = null;
    this.url = null;
  };
  TokenError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TokenError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TokenError.code
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TokenError.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TokenError.encodedSize = codec.kStructHeaderSize + 16;

  TokenError.decode = function(decoder) {
    var packed;
    var val = new TokenError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TokenError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TokenError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.code);
    encoder.encodeStruct(codec.String, val.url);
  };
  function FederatedAuthRequest_RequestToken_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_RequestToken_Params.prototype.initDefaults_ = function() {
    this.idpGetParams = null;
    this.requirement = 0;
  };
  FederatedAuthRequest_RequestToken_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_RequestToken_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestToken_Params.idpGetParams
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(IdentityProviderGetParameters), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestToken_Params.requirement
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, credential_manager$.CredentialMediationRequirement);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_RequestToken_Params.encodedSize = codec.kStructHeaderSize + 16;

  FederatedAuthRequest_RequestToken_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_RequestToken_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.idpGetParams =
        decoder.decodeArrayPointer(new codec.PointerTo(IdentityProviderGetParameters));
    val.requirement =
        decoder.decodeStruct(new codec.Enum(credential_manager$.CredentialMediationRequirement));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthRequest_RequestToken_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_RequestToken_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(IdentityProviderGetParameters), val.idpGetParams);
    encoder.encodeStruct(codec.Int32, val.requirement);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FederatedAuthRequest_RequestToken_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_RequestToken_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.isAutoSelected = false;
    this.selectedIdentityProviderConfigUrl = null;
    this.token = null;
    this.error = null;
  };
  FederatedAuthRequest_RequestToken_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_RequestToken_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestToken_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RequestTokenStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestToken_ResponseParams.selectedIdentityProviderConfigUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestToken_ResponseParams.token
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, values$.Value, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestToken_ResponseParams.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, TokenError, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FederatedAuthRequest_RequestToken_ResponseParams.encodedSize = codec.kStructHeaderSize + 40;

  FederatedAuthRequest_RequestToken_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_RequestToken_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(RequestTokenStatus));
    packed = decoder.readUint8();
    val.isAutoSelected = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.selectedIdentityProviderConfigUrl =
        decoder.decodeStructPointer(url$.Url);
    val.token =
        decoder.decodeStruct(values$.Value);
    val.error =
        decoder.decodeStructPointer(TokenError);
    return val;
  };

  FederatedAuthRequest_RequestToken_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_RequestToken_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    packed = 0;
    packed |= (val.isAutoSelected & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.selectedIdentityProviderConfigUrl);
    encoder.encodeStruct(values$.Value, val.token);
    encoder.encodeStructPointer(TokenError, val.error);
  };
  function FederatedAuthRequest_RequestUserInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_RequestUserInfo_Params.prototype.initDefaults_ = function() {
    this.provider = null;
  };
  FederatedAuthRequest_RequestUserInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_RequestUserInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestUserInfo_Params.provider
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, IdentityProviderConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_RequestUserInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_RequestUserInfo_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_RequestUserInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.provider =
        decoder.decodeStructPointer(IdentityProviderConfig);
    return val;
  };

  FederatedAuthRequest_RequestUserInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_RequestUserInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(IdentityProviderConfig, val.provider);
  };
  function FederatedAuthRequest_RequestUserInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_RequestUserInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.userInfo = null;
  };
  FederatedAuthRequest_RequestUserInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_RequestUserInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestUserInfo_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RequestUserInfoStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RequestUserInfo_ResponseParams.userInfo
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(IdentityUserInfo), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_RequestUserInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FederatedAuthRequest_RequestUserInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_RequestUserInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(RequestUserInfoStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.userInfo =
        decoder.decodeArrayPointer(new codec.PointerTo(IdentityUserInfo));
    return val;
  };

  FederatedAuthRequest_RequestUserInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_RequestUserInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(IdentityUserInfo), val.userInfo);
  };
  function FederatedAuthRequest_CancelTokenRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_CancelTokenRequest_Params.prototype.initDefaults_ = function() {
  };
  FederatedAuthRequest_CancelTokenRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_CancelTokenRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_CancelTokenRequest_Params.encodedSize = codec.kStructHeaderSize + 0;

  FederatedAuthRequest_CancelTokenRequest_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_CancelTokenRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FederatedAuthRequest_CancelTokenRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_CancelTokenRequest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FederatedAuthRequest_ResolveTokenRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_ResolveTokenRequest_Params.prototype.initDefaults_ = function() {
    this.accountId = null;
    this.token = null;
  };
  FederatedAuthRequest_ResolveTokenRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_ResolveTokenRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_ResolveTokenRequest_Params.accountId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_ResolveTokenRequest_Params.token
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, values$.Value, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_ResolveTokenRequest_Params.encodedSize = codec.kStructHeaderSize + 24;

  FederatedAuthRequest_ResolveTokenRequest_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_ResolveTokenRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.accountId =
        decoder.decodeStruct(codec.String);
    val.token =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  FederatedAuthRequest_ResolveTokenRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_ResolveTokenRequest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.accountId);
    encoder.encodeStruct(values$.Value, val.token);
  };
  function FederatedAuthRequest_ResolveTokenRequest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_ResolveTokenRequest_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  FederatedAuthRequest_ResolveTokenRequest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_ResolveTokenRequest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FederatedAuthRequest_ResolveTokenRequest_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_ResolveTokenRequest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_ResolveTokenRequest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthRequest_ResolveTokenRequest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_ResolveTokenRequest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FederatedAuthRequest_SetIdpSigninStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_SetIdpSigninStatus_Params.prototype.initDefaults_ = function() {
    this.origin = null;
    this.status = 0;
    this.options = null;
  };
  FederatedAuthRequest_SetIdpSigninStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_SetIdpSigninStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_SetIdpSigninStatus_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_SetIdpSigninStatus_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, IdpSigninStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_SetIdpSigninStatus_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, LoginStatusOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_SetIdpSigninStatus_Params.encodedSize = codec.kStructHeaderSize + 24;

  FederatedAuthRequest_SetIdpSigninStatus_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_SetIdpSigninStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.status =
        decoder.decodeStruct(new codec.Enum(IdpSigninStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(LoginStatusOptions);
    return val;
  };

  FederatedAuthRequest_SetIdpSigninStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_SetIdpSigninStatus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(LoginStatusOptions, val.options);
  };
  function FederatedAuthRequest_SetIdpSigninStatus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.prototype.initDefaults_ = function() {
  };
  FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_SetIdpSigninStatus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function FederatedAuthRequest_RegisterIdP_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_RegisterIdP_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  FederatedAuthRequest_RegisterIdP_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_RegisterIdP_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RegisterIdP_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_RegisterIdP_Params.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_RegisterIdP_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_RegisterIdP_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  FederatedAuthRequest_RegisterIdP_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_RegisterIdP_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function FederatedAuthRequest_RegisterIdP_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_RegisterIdP_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  FederatedAuthRequest_RegisterIdP_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_RegisterIdP_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_RegisterIdP_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RegisterIdpStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_RegisterIdP_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_RegisterIdP_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_RegisterIdP_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(RegisterIdpStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthRequest_RegisterIdP_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_RegisterIdP_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FederatedAuthRequest_UnregisterIdP_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_UnregisterIdP_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  FederatedAuthRequest_UnregisterIdP_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_UnregisterIdP_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_UnregisterIdP_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_UnregisterIdP_Params.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_UnregisterIdP_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_UnregisterIdP_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  FederatedAuthRequest_UnregisterIdP_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_UnregisterIdP_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function FederatedAuthRequest_UnregisterIdP_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_UnregisterIdP_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  FederatedAuthRequest_UnregisterIdP_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_UnregisterIdP_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FederatedAuthRequest_UnregisterIdP_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_UnregisterIdP_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_UnregisterIdP_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthRequest_UnregisterIdP_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_UnregisterIdP_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FederatedAuthRequest_CloseModalDialogView_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_CloseModalDialogView_Params.prototype.initDefaults_ = function() {
  };
  FederatedAuthRequest_CloseModalDialogView_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_CloseModalDialogView_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_CloseModalDialogView_Params.encodedSize = codec.kStructHeaderSize + 0;

  FederatedAuthRequest_CloseModalDialogView_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_CloseModalDialogView_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FederatedAuthRequest_CloseModalDialogView_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_CloseModalDialogView_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FederatedAuthRequest_PreventSilentAccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_PreventSilentAccess_Params.prototype.initDefaults_ = function() {
  };
  FederatedAuthRequest_PreventSilentAccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_PreventSilentAccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_PreventSilentAccess_Params.encodedSize = codec.kStructHeaderSize + 0;

  FederatedAuthRequest_PreventSilentAccess_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_PreventSilentAccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FederatedAuthRequest_PreventSilentAccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_PreventSilentAccess_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FederatedAuthRequest_PreventSilentAccess_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_PreventSilentAccess_ResponseParams.prototype.initDefaults_ = function() {
  };
  FederatedAuthRequest_PreventSilentAccess_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_PreventSilentAccess_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_PreventSilentAccess_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FederatedAuthRequest_PreventSilentAccess_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_PreventSilentAccess_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FederatedAuthRequest_PreventSilentAccess_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_PreventSilentAccess_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function FederatedAuthRequest_Disconnect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_Disconnect_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  FederatedAuthRequest_Disconnect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_Disconnect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_Disconnect_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, IdentityCredentialDisconnectOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_Disconnect_Params.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_Disconnect_Params.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_Disconnect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(IdentityCredentialDisconnectOptions);
    return val;
  };

  FederatedAuthRequest_Disconnect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_Disconnect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(IdentityCredentialDisconnectOptions, val.options);
  };
  function FederatedAuthRequest_Disconnect_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequest_Disconnect_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  FederatedAuthRequest_Disconnect_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequest_Disconnect_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequest_Disconnect_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DisconnectStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequest_Disconnect_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequest_Disconnect_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequest_Disconnect_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(DisconnectStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthRequest_Disconnect_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequest_Disconnect_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFederatedAuthRequest_RequestToken_Name = 0;
  var kFederatedAuthRequest_RequestUserInfo_Name = 1;
  var kFederatedAuthRequest_CancelTokenRequest_Name = 2;
  var kFederatedAuthRequest_ResolveTokenRequest_Name = 3;
  var kFederatedAuthRequest_SetIdpSigninStatus_Name = 4;
  var kFederatedAuthRequest_RegisterIdP_Name = 5;
  var kFederatedAuthRequest_UnregisterIdP_Name = 6;
  var kFederatedAuthRequest_CloseModalDialogView_Name = 7;
  var kFederatedAuthRequest_PreventSilentAccess_Name = 8;
  var kFederatedAuthRequest_Disconnect_Name = 9;

  function FederatedAuthRequestPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FederatedAuthRequest,
                                                   handleOrPtrInfo);
  }

  function FederatedAuthRequestAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FederatedAuthRequest, associatedInterfacePtrInfo);
  }

  FederatedAuthRequestAssociatedPtr.prototype =
      Object.create(FederatedAuthRequestPtr.prototype);
  FederatedAuthRequestAssociatedPtr.prototype.constructor =
      FederatedAuthRequestAssociatedPtr;

  function FederatedAuthRequestProxy(receiver) {
    this.receiver_ = receiver;
  }
  FederatedAuthRequestPtr.prototype.requestToken = function() {
    return FederatedAuthRequestProxy.prototype.requestToken
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.requestToken = function(idpGetParams, requirement) {
    var params_ = new FederatedAuthRequest_RequestToken_Params();
    params_.idpGetParams = idpGetParams;
    params_.requirement = requirement;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_RequestToken_Name,
          codec.align(FederatedAuthRequest_RequestToken_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_RequestToken_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_RequestToken_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.requestUserInfo = function() {
    return FederatedAuthRequestProxy.prototype.requestUserInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.requestUserInfo = function(provider) {
    var params_ = new FederatedAuthRequest_RequestUserInfo_Params();
    params_.provider = provider;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_RequestUserInfo_Name,
          codec.align(FederatedAuthRequest_RequestUserInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_RequestUserInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_RequestUserInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.cancelTokenRequest = function() {
    return FederatedAuthRequestProxy.prototype.cancelTokenRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.cancelTokenRequest = function() {
    var params_ = new FederatedAuthRequest_CancelTokenRequest_Params();
    var builder = new codec.MessageV0Builder(
        kFederatedAuthRequest_CancelTokenRequest_Name,
        codec.align(FederatedAuthRequest_CancelTokenRequest_Params.encodedSize));
    builder.encodeStruct(FederatedAuthRequest_CancelTokenRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FederatedAuthRequestPtr.prototype.resolveTokenRequest = function() {
    return FederatedAuthRequestProxy.prototype.resolveTokenRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.resolveTokenRequest = function(accountId, token) {
    var params_ = new FederatedAuthRequest_ResolveTokenRequest_Params();
    params_.accountId = accountId;
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_ResolveTokenRequest_Name,
          codec.align(FederatedAuthRequest_ResolveTokenRequest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_ResolveTokenRequest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_ResolveTokenRequest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.setIdpSigninStatus = function() {
    return FederatedAuthRequestProxy.prototype.setIdpSigninStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.setIdpSigninStatus = function(origin, status, options) {
    var params_ = new FederatedAuthRequest_SetIdpSigninStatus_Params();
    params_.origin = origin;
    params_.status = status;
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_SetIdpSigninStatus_Name,
          codec.align(FederatedAuthRequest_SetIdpSigninStatus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_SetIdpSigninStatus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_SetIdpSigninStatus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.registerIdP = function() {
    return FederatedAuthRequestProxy.prototype.registerIdP
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.registerIdP = function(url) {
    var params_ = new FederatedAuthRequest_RegisterIdP_Params();
    params_.url = url;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_RegisterIdP_Name,
          codec.align(FederatedAuthRequest_RegisterIdP_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_RegisterIdP_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_RegisterIdP_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.unregisterIdP = function() {
    return FederatedAuthRequestProxy.prototype.unregisterIdP
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.unregisterIdP = function(url) {
    var params_ = new FederatedAuthRequest_UnregisterIdP_Params();
    params_.url = url;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_UnregisterIdP_Name,
          codec.align(FederatedAuthRequest_UnregisterIdP_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_UnregisterIdP_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_UnregisterIdP_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.closeModalDialogView = function() {
    return FederatedAuthRequestProxy.prototype.closeModalDialogView
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.closeModalDialogView = function() {
    var params_ = new FederatedAuthRequest_CloseModalDialogView_Params();
    var builder = new codec.MessageV0Builder(
        kFederatedAuthRequest_CloseModalDialogView_Name,
        codec.align(FederatedAuthRequest_CloseModalDialogView_Params.encodedSize));
    builder.encodeStruct(FederatedAuthRequest_CloseModalDialogView_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FederatedAuthRequestPtr.prototype.preventSilentAccess = function() {
    return FederatedAuthRequestProxy.prototype.preventSilentAccess
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.preventSilentAccess = function() {
    var params_ = new FederatedAuthRequest_PreventSilentAccess_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_PreventSilentAccess_Name,
          codec.align(FederatedAuthRequest_PreventSilentAccess_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_PreventSilentAccess_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_PreventSilentAccess_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FederatedAuthRequestPtr.prototype.disconnect = function() {
    return FederatedAuthRequestProxy.prototype.disconnect
        .apply(this.ptr.getProxy(), arguments);
  };

  FederatedAuthRequestProxy.prototype.disconnect = function(options) {
    var params_ = new FederatedAuthRequest_Disconnect_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFederatedAuthRequest_Disconnect_Name,
          codec.align(FederatedAuthRequest_Disconnect_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FederatedAuthRequest_Disconnect_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FederatedAuthRequest_Disconnect_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FederatedAuthRequestStub(delegate) {
    this.delegate_ = delegate;
  }
  FederatedAuthRequestStub.prototype.requestToken = function(idpGetParams, requirement) {
    return this.delegate_ && this.delegate_.requestToken && this.delegate_.requestToken(idpGetParams, requirement);
  }
  FederatedAuthRequestStub.prototype.requestUserInfo = function(provider) {
    return this.delegate_ && this.delegate_.requestUserInfo && this.delegate_.requestUserInfo(provider);
  }
  FederatedAuthRequestStub.prototype.cancelTokenRequest = function() {
    return this.delegate_ && this.delegate_.cancelTokenRequest && this.delegate_.cancelTokenRequest();
  }
  FederatedAuthRequestStub.prototype.resolveTokenRequest = function(accountId, token) {
    return this.delegate_ && this.delegate_.resolveTokenRequest && this.delegate_.resolveTokenRequest(accountId, token);
  }
  FederatedAuthRequestStub.prototype.setIdpSigninStatus = function(origin, status, options) {
    return this.delegate_ && this.delegate_.setIdpSigninStatus && this.delegate_.setIdpSigninStatus(origin, status, options);
  }
  FederatedAuthRequestStub.prototype.registerIdP = function(url) {
    return this.delegate_ && this.delegate_.registerIdP && this.delegate_.registerIdP(url);
  }
  FederatedAuthRequestStub.prototype.unregisterIdP = function(url) {
    return this.delegate_ && this.delegate_.unregisterIdP && this.delegate_.unregisterIdP(url);
  }
  FederatedAuthRequestStub.prototype.closeModalDialogView = function() {
    return this.delegate_ && this.delegate_.closeModalDialogView && this.delegate_.closeModalDialogView();
  }
  FederatedAuthRequestStub.prototype.preventSilentAccess = function() {
    return this.delegate_ && this.delegate_.preventSilentAccess && this.delegate_.preventSilentAccess();
  }
  FederatedAuthRequestStub.prototype.disconnect = function(options) {
    return this.delegate_ && this.delegate_.disconnect && this.delegate_.disconnect(options);
  }

  FederatedAuthRequestStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFederatedAuthRequest_CancelTokenRequest_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_CancelTokenRequest_Params);
      this.cancelTokenRequest();
      return true;
    case kFederatedAuthRequest_CloseModalDialogView_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_CloseModalDialogView_Params);
      this.closeModalDialogView();
      return true;
    default:
      return false;
    }
  };

  FederatedAuthRequestStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFederatedAuthRequest_RequestToken_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_RequestToken_Params);
      this.requestToken(params.idpGetParams, params.requirement).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_RequestToken_ResponseParams();
        responseParams.status = response.status;
        responseParams.selectedIdentityProviderConfigUrl = response.selectedIdentityProviderConfigUrl;
        responseParams.token = response.token;
        responseParams.error = response.error;
        responseParams.isAutoSelected = response.isAutoSelected;
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_RequestToken_Name,
            codec.align(FederatedAuthRequest_RequestToken_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_RequestToken_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_RequestUserInfo_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_RequestUserInfo_Params);
      this.requestUserInfo(params.provider).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_RequestUserInfo_ResponseParams();
        responseParams.status = response.status;
        responseParams.userInfo = response.userInfo;
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_RequestUserInfo_Name,
            codec.align(FederatedAuthRequest_RequestUserInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_RequestUserInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_ResolveTokenRequest_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_ResolveTokenRequest_Params);
      this.resolveTokenRequest(params.accountId, params.token).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_ResolveTokenRequest_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_ResolveTokenRequest_Name,
            codec.align(FederatedAuthRequest_ResolveTokenRequest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_ResolveTokenRequest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_SetIdpSigninStatus_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_SetIdpSigninStatus_Params);
      this.setIdpSigninStatus(params.origin, params.status, params.options).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_SetIdpSigninStatus_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_SetIdpSigninStatus_Name,
            codec.align(FederatedAuthRequest_SetIdpSigninStatus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_SetIdpSigninStatus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_RegisterIdP_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_RegisterIdP_Params);
      this.registerIdP(params.url).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_RegisterIdP_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_RegisterIdP_Name,
            codec.align(FederatedAuthRequest_RegisterIdP_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_RegisterIdP_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_UnregisterIdP_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_UnregisterIdP_Params);
      this.unregisterIdP(params.url).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_UnregisterIdP_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_UnregisterIdP_Name,
            codec.align(FederatedAuthRequest_UnregisterIdP_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_UnregisterIdP_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_PreventSilentAccess_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_PreventSilentAccess_Params);
      this.preventSilentAccess().then(function(response) {
        var responseParams =
            new FederatedAuthRequest_PreventSilentAccess_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_PreventSilentAccess_Name,
            codec.align(FederatedAuthRequest_PreventSilentAccess_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_PreventSilentAccess_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFederatedAuthRequest_Disconnect_Name:
      var params = reader.decodeStruct(FederatedAuthRequest_Disconnect_Params);
      this.disconnect(params.options).then(function(response) {
        var responseParams =
            new FederatedAuthRequest_Disconnect_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kFederatedAuthRequest_Disconnect_Name,
            codec.align(FederatedAuthRequest_Disconnect_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FederatedAuthRequest_Disconnect_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFederatedAuthRequestRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFederatedAuthRequest_RequestToken_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_RequestToken_Params;
      break;
      case kFederatedAuthRequest_RequestUserInfo_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_RequestUserInfo_Params;
      break;
      case kFederatedAuthRequest_CancelTokenRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FederatedAuthRequest_CancelTokenRequest_Params;
      break;
      case kFederatedAuthRequest_ResolveTokenRequest_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_ResolveTokenRequest_Params;
      break;
      case kFederatedAuthRequest_SetIdpSigninStatus_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_SetIdpSigninStatus_Params;
      break;
      case kFederatedAuthRequest_RegisterIdP_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_RegisterIdP_Params;
      break;
      case kFederatedAuthRequest_UnregisterIdP_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_UnregisterIdP_Params;
      break;
      case kFederatedAuthRequest_CloseModalDialogView_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FederatedAuthRequest_CloseModalDialogView_Params;
      break;
      case kFederatedAuthRequest_PreventSilentAccess_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_PreventSilentAccess_Params;
      break;
      case kFederatedAuthRequest_Disconnect_Name:
        if (message.expectsResponse())
          paramsClass = FederatedAuthRequest_Disconnect_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFederatedAuthRequestResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFederatedAuthRequest_RequestToken_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_RequestToken_ResponseParams;
        break;
      case kFederatedAuthRequest_RequestUserInfo_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_RequestUserInfo_ResponseParams;
        break;
      case kFederatedAuthRequest_ResolveTokenRequest_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_ResolveTokenRequest_ResponseParams;
        break;
      case kFederatedAuthRequest_SetIdpSigninStatus_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_SetIdpSigninStatus_ResponseParams;
        break;
      case kFederatedAuthRequest_RegisterIdP_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_RegisterIdP_ResponseParams;
        break;
      case kFederatedAuthRequest_UnregisterIdP_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_UnregisterIdP_ResponseParams;
        break;
      case kFederatedAuthRequest_PreventSilentAccess_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_PreventSilentAccess_ResponseParams;
        break;
      case kFederatedAuthRequest_Disconnect_Name:
        if (message.isResponse())
          paramsClass = FederatedAuthRequest_Disconnect_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FederatedAuthRequest = {
    name: 'blink.mojom.FederatedAuthRequest',
    kVersion: 0,
    ptrClass: FederatedAuthRequestPtr,
    proxyClass: FederatedAuthRequestProxy,
    stubClass: FederatedAuthRequestStub,
    validateRequest: validateFederatedAuthRequestRequest,
    validateResponse: validateFederatedAuthRequestResponse,
  };
  FederatedAuthRequestStub.prototype.validator = validateFederatedAuthRequestRequest;
  FederatedAuthRequestProxy.prototype.validator = validateFederatedAuthRequestResponse;
  exports.RequestTokenStatus = RequestTokenStatus;
  exports.RequestUserInfoStatus = RequestUserInfoStatus;
  exports.DisconnectStatus = DisconnectStatus;
  exports.IdpSigninStatus = IdpSigninStatus;
  exports.RpContext = RpContext;
  exports.RpMode = RpMode;
  exports.RegisterIdpStatus = RegisterIdpStatus;
  exports.Format = Format;
  exports.IdentityProviderConfig = IdentityProviderConfig;
  exports.IdentityProviderRequestOptions = IdentityProviderRequestOptions;
  exports.IdentityCredentialDisconnectOptions = IdentityCredentialDisconnectOptions;
  exports.IdentityUserInfo = IdentityUserInfo;
  exports.LoginStatusAccount = LoginStatusAccount;
  exports.LoginStatusOptions = LoginStatusOptions;
  exports.IdentityProviderGetParameters = IdentityProviderGetParameters;
  exports.TokenError = TokenError;
  exports.FederatedAuthRequest = FederatedAuthRequest;
  exports.FederatedAuthRequestPtr = FederatedAuthRequestPtr;
  exports.FederatedAuthRequestAssociatedPtr = FederatedAuthRequestAssociatedPtr;
})();