// third_party/blink/public/mojom/widget/platform_widget.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/widget/platform_widget.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var render_frame_metadata$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/render_frame_metadata.mojom', '../../../../../cc/mojom/render_frame_metadata.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var text_direction$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/text_direction.mojom', '../../../../../mojo/public/mojom/base/text_direction.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var compositor_frame_sink$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_frame_sink.mojom', '../../../../../services/viz/public/mojom/compositing/compositor_frame_sink.mojom.js');
  }
  var cursor$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/cursor/mojom/cursor.mojom', '../../../../../ui/base/cursor/mojom/cursor.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var input_handler$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/input_handler.mojom', '../input/input_handler.mojom.js');
  }
  var visual_properties$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/widget/visual_properties.mojom', 'visual_properties.mojom.js');
  }
  var record_content_to_visible_time_request$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/widget/record_content_to_visible_time_request.mojom', 'record_content_to_visible_time_request.mojom.js');
  }
  var text_input_state$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/ime/mojom/text_input_state.mojom', '../../../../../ui/base/ime/mojom/text_input_state.mojom.js');
  }
  var input_target_client$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/hit_test/input_target_client.mojom', '../../../../../services/viz/public/mojom/hit_test/input_target_client.mojom.js');
  }
  var menu_source_type$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/mojom/menu_source_type.mojom', '../../../../../ui/base/mojom/menu_source_type.mojom.js');
  }



  function WidgetCompositor_VisualStateRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetCompositor_VisualStateRequest_Params.prototype.initDefaults_ = function() {
  };
  WidgetCompositor_VisualStateRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetCompositor_VisualStateRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetCompositor_VisualStateRequest_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetCompositor_VisualStateRequest_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetCompositor_VisualStateRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetCompositor_VisualStateRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetCompositor_VisualStateRequest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetCompositor_VisualStateRequest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetCompositor_VisualStateRequest_ResponseParams.prototype.initDefaults_ = function() {
  };
  WidgetCompositor_VisualStateRequest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetCompositor_VisualStateRequest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetCompositor_VisualStateRequest_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  WidgetCompositor_VisualStateRequest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WidgetCompositor_VisualStateRequest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetCompositor_VisualStateRequest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetCompositor_VisualStateRequest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetHost_SetCursor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_SetCursor_Params.prototype.initDefaults_ = function() {
    this.cursor = null;
  };
  WidgetHost_SetCursor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_SetCursor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_SetCursor_Params.cursor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, cursor$.Cursor, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_SetCursor_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetHost_SetCursor_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_SetCursor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cursor =
        decoder.decodeStructPointer(cursor$.Cursor);
    return val;
  };

  WidgetHost_SetCursor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_SetCursor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(cursor$.Cursor, val.cursor);
  };
  function WidgetHost_UpdateTooltipUnderCursor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_UpdateTooltipUnderCursor_Params.prototype.initDefaults_ = function() {
    this.tooltipText = null;
    this.textDirectionHint = 0;
  };
  WidgetHost_UpdateTooltipUnderCursor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_UpdateTooltipUnderCursor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_UpdateTooltipUnderCursor_Params.tooltipText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_UpdateTooltipUnderCursor_Params.textDirectionHint
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, text_direction$.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_UpdateTooltipUnderCursor_Params.encodedSize = codec.kStructHeaderSize + 16;

  WidgetHost_UpdateTooltipUnderCursor_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_UpdateTooltipUnderCursor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tooltipText =
        decoder.decodeStructPointer(string16$.String16);
    val.textDirectionHint =
        decoder.decodeStruct(new codec.Enum(text_direction$.TextDirection));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetHost_UpdateTooltipUnderCursor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_UpdateTooltipUnderCursor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.tooltipText);
    encoder.encodeStruct(codec.Int32, val.textDirectionHint);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetHost_UpdateTooltipFromKeyboard_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_UpdateTooltipFromKeyboard_Params.prototype.initDefaults_ = function() {
    this.tooltipText = null;
    this.textDirectionHint = 0;
    this.bounds = null;
  };
  WidgetHost_UpdateTooltipFromKeyboard_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_UpdateTooltipFromKeyboard_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_UpdateTooltipFromKeyboard_Params.tooltipText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_UpdateTooltipFromKeyboard_Params.textDirectionHint
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, text_direction$.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_UpdateTooltipFromKeyboard_Params.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_UpdateTooltipFromKeyboard_Params.encodedSize = codec.kStructHeaderSize + 24;

  WidgetHost_UpdateTooltipFromKeyboard_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_UpdateTooltipFromKeyboard_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tooltipText =
        decoder.decodeStructPointer(string16$.String16);
    val.textDirectionHint =
        decoder.decodeStruct(new codec.Enum(text_direction$.TextDirection));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.bounds =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  WidgetHost_UpdateTooltipFromKeyboard_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_UpdateTooltipFromKeyboard_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.tooltipText);
    encoder.encodeStruct(codec.Int32, val.textDirectionHint);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Rect, val.bounds);
  };
  function WidgetHost_ClearKeyboardTriggeredTooltip_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_ClearKeyboardTriggeredTooltip_Params.prototype.initDefaults_ = function() {
  };
  WidgetHost_ClearKeyboardTriggeredTooltip_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_ClearKeyboardTriggeredTooltip_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_ClearKeyboardTriggeredTooltip_Params.encodedSize = codec.kStructHeaderSize + 0;

  WidgetHost_ClearKeyboardTriggeredTooltip_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_ClearKeyboardTriggeredTooltip_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WidgetHost_ClearKeyboardTriggeredTooltip_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_ClearKeyboardTriggeredTooltip_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WidgetHost_TextInputStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_TextInputStateChanged_Params.prototype.initDefaults_ = function() {
    this.state = null;
  };
  WidgetHost_TextInputStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_TextInputStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_TextInputStateChanged_Params.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, text_input_state$.TextInputState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_TextInputStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  WidgetHost_TextInputStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_TextInputStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStructPointer(text_input_state$.TextInputState);
    return val;
  };

  WidgetHost_TextInputStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_TextInputStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(text_input_state$.TextInputState, val.state);
  };
  function WidgetHost_SelectionBoundsChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_SelectionBoundsChanged_Params.prototype.initDefaults_ = function() {
    this.anchorRect = null;
    this.anchorDir = 0;
    this.focusDir = 0;
    this.focusRect = null;
    this.boundingBoxRect = null;
    this.isAnchorFirst = false;
  };
  WidgetHost_SelectionBoundsChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_SelectionBoundsChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_SelectionBoundsChanged_Params.anchorRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_SelectionBoundsChanged_Params.anchorDir
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, text_direction$.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_SelectionBoundsChanged_Params.focusRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_SelectionBoundsChanged_Params.focusDir
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, text_direction$.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_SelectionBoundsChanged_Params.boundingBoxRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WidgetHost_SelectionBoundsChanged_Params.encodedSize = codec.kStructHeaderSize + 40;

  WidgetHost_SelectionBoundsChanged_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_SelectionBoundsChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.anchorDir =
        decoder.decodeStruct(new codec.Enum(text_direction$.TextDirection));
    val.focusDir =
        decoder.decodeStruct(new codec.Enum(text_direction$.TextDirection));
    val.focusRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.boundingBoxRect =
        decoder.decodeStructPointer(geometry$.Rect);
    packed = decoder.readUint8();
    val.isAnchorFirst = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetHost_SelectionBoundsChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_SelectionBoundsChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.anchorRect);
    encoder.encodeStruct(codec.Int32, val.anchorDir);
    encoder.encodeStruct(codec.Int32, val.focusDir);
    encoder.encodeStructPointer(geometry$.Rect, val.focusRect);
    encoder.encodeStructPointer(geometry$.Rect, val.boundingBoxRect);
    packed = 0;
    packed |= (val.isAnchorFirst & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetHost_CreateFrameSink_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_CreateFrameSink_Params.prototype.initDefaults_ = function() {
    this.compositorFrameSinkReceiver = new bindings.InterfaceRequest();
    this.compositorFrameSinkClient = new compositor_frame_sink$.CompositorFrameSinkClientPtr();
    this.renderInputRouterClient = new RenderInputRouterClientPtr();
  };
  WidgetHost_CreateFrameSink_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_CreateFrameSink_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_CreateFrameSink_Params.compositorFrameSinkReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_CreateFrameSink_Params.compositorFrameSinkClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_CreateFrameSink_Params.renderInputRouterClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_CreateFrameSink_Params.encodedSize = codec.kStructHeaderSize + 24;

  WidgetHost_CreateFrameSink_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_CreateFrameSink_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.compositorFrameSinkReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.compositorFrameSinkClient =
        decoder.decodeStruct(new codec.Interface(compositor_frame_sink$.CompositorFrameSinkClientPtr));
    val.renderInputRouterClient =
        decoder.decodeStruct(new codec.Interface(RenderInputRouterClientPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetHost_CreateFrameSink_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_CreateFrameSink_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.compositorFrameSinkReceiver);
    encoder.encodeStruct(new codec.Interface(compositor_frame_sink$.CompositorFrameSinkClientPtr), val.compositorFrameSinkClient);
    encoder.encodeStruct(new codec.Interface(RenderInputRouterClientPtr), val.renderInputRouterClient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WidgetHost_RegisterRenderFrameMetadataObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WidgetHost_RegisterRenderFrameMetadataObserver_Params.prototype.initDefaults_ = function() {
    this.renderFrameMetadataObserverClientReceiver = new bindings.InterfaceRequest();
    this.renderFrameMetadataObserver = new render_frame_metadata$.RenderFrameMetadataObserverPtr();
  };
  WidgetHost_RegisterRenderFrameMetadataObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WidgetHost_RegisterRenderFrameMetadataObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_RegisterRenderFrameMetadataObserver_Params.renderFrameMetadataObserverClientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WidgetHost_RegisterRenderFrameMetadataObserver_Params.renderFrameMetadataObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WidgetHost_RegisterRenderFrameMetadataObserver_Params.encodedSize = codec.kStructHeaderSize + 16;

  WidgetHost_RegisterRenderFrameMetadataObserver_Params.decode = function(decoder) {
    var packed;
    var val = new WidgetHost_RegisterRenderFrameMetadataObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.renderFrameMetadataObserverClientReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.renderFrameMetadataObserver =
        decoder.decodeStruct(new codec.Interface(render_frame_metadata$.RenderFrameMetadataObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WidgetHost_RegisterRenderFrameMetadataObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WidgetHost_RegisterRenderFrameMetadataObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.renderFrameMetadataObserverClientReceiver);
    encoder.encodeStruct(new codec.Interface(render_frame_metadata$.RenderFrameMetadataObserverPtr), val.renderFrameMetadataObserver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Widget_ForceRedraw_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_ForceRedraw_Params.prototype.initDefaults_ = function() {
  };
  Widget_ForceRedraw_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_ForceRedraw_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_ForceRedraw_Params.encodedSize = codec.kStructHeaderSize + 0;

  Widget_ForceRedraw_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_ForceRedraw_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Widget_ForceRedraw_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_ForceRedraw_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Widget_ForceRedraw_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_ForceRedraw_ResponseParams.prototype.initDefaults_ = function() {
  };
  Widget_ForceRedraw_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_ForceRedraw_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_ForceRedraw_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Widget_ForceRedraw_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Widget_ForceRedraw_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Widget_ForceRedraw_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_ForceRedraw_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Widget_UpdateVisualProperties_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_UpdateVisualProperties_Params.prototype.initDefaults_ = function() {
    this.visualProperties = null;
  };
  Widget_UpdateVisualProperties_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_UpdateVisualProperties_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Widget_UpdateVisualProperties_Params.visualProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, visual_properties$.VisualProperties, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_UpdateVisualProperties_Params.encodedSize = codec.kStructHeaderSize + 8;

  Widget_UpdateVisualProperties_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_UpdateVisualProperties_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.visualProperties =
        decoder.decodeStructPointer(visual_properties$.VisualProperties);
    return val;
  };

  Widget_UpdateVisualProperties_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_UpdateVisualProperties_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(visual_properties$.VisualProperties, val.visualProperties);
  };
  function Widget_UpdateScreenRects_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_UpdateScreenRects_Params.prototype.initDefaults_ = function() {
    this.widgetScreenRect = null;
    this.windowScreenRect = null;
  };
  Widget_UpdateScreenRects_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_UpdateScreenRects_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Widget_UpdateScreenRects_Params.widgetScreenRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Widget_UpdateScreenRects_Params.windowScreenRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_UpdateScreenRects_Params.encodedSize = codec.kStructHeaderSize + 16;

  Widget_UpdateScreenRects_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_UpdateScreenRects_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.widgetScreenRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.windowScreenRect =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  Widget_UpdateScreenRects_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_UpdateScreenRects_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.widgetScreenRect);
    encoder.encodeStructPointer(geometry$.Rect, val.windowScreenRect);
  };
  function Widget_UpdateScreenRects_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_UpdateScreenRects_ResponseParams.prototype.initDefaults_ = function() {
  };
  Widget_UpdateScreenRects_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_UpdateScreenRects_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_UpdateScreenRects_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Widget_UpdateScreenRects_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Widget_UpdateScreenRects_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Widget_UpdateScreenRects_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_UpdateScreenRects_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Widget_WasHidden_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_WasHidden_Params.prototype.initDefaults_ = function() {
  };
  Widget_WasHidden_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_WasHidden_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_WasHidden_Params.encodedSize = codec.kStructHeaderSize + 0;

  Widget_WasHidden_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_WasHidden_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Widget_WasHidden_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_WasHidden_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Widget_WasShown_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_WasShown_Params.prototype.initDefaults_ = function() {
    this.wasEvicted = false;
    this.recordTabSwitchTimeRequest = null;
  };
  Widget_WasShown_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_WasShown_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Widget_WasShown_Params.recordTabSwitchTimeRequest
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, record_content_to_visible_time_request$.RecordContentToVisibleTimeRequest, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_WasShown_Params.encodedSize = codec.kStructHeaderSize + 16;

  Widget_WasShown_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_WasShown_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.wasEvicted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.recordTabSwitchTimeRequest =
        decoder.decodeStructPointer(record_content_to_visible_time_request$.RecordContentToVisibleTimeRequest);
    return val;
  };

  Widget_WasShown_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_WasShown_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.wasEvicted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(record_content_to_visible_time_request$.RecordContentToVisibleTimeRequest, val.recordTabSwitchTimeRequest);
  };
  function Widget_RequestSuccessfulPresentationTimeForNextFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.prototype.initDefaults_ = function() {
    this.visibleTimeRequest = null;
  };
  Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.visibleTimeRequest
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, record_content_to_visible_time_request$.RecordContentToVisibleTimeRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_RequestSuccessfulPresentationTimeForNextFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.visibleTimeRequest =
        decoder.decodeStructPointer(record_content_to_visible_time_request$.RecordContentToVisibleTimeRequest);
    return val;
  };

  Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(record_content_to_visible_time_request$.RecordContentToVisibleTimeRequest, val.visibleTimeRequest);
  };
  function Widget_CancelSuccessfulPresentationTimeRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_CancelSuccessfulPresentationTimeRequest_Params.prototype.initDefaults_ = function() {
  };
  Widget_CancelSuccessfulPresentationTimeRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_CancelSuccessfulPresentationTimeRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_CancelSuccessfulPresentationTimeRequest_Params.encodedSize = codec.kStructHeaderSize + 0;

  Widget_CancelSuccessfulPresentationTimeRequest_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_CancelSuccessfulPresentationTimeRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Widget_CancelSuccessfulPresentationTimeRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_CancelSuccessfulPresentationTimeRequest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Widget_SetupBrowserRenderInputRouterConnections_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Widget_SetupBrowserRenderInputRouterConnections_Params.prototype.initDefaults_ = function() {
    this.browserClient = new bindings.InterfaceRequest();
  };
  Widget_SetupBrowserRenderInputRouterConnections_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Widget_SetupBrowserRenderInputRouterConnections_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Widget_SetupBrowserRenderInputRouterConnections_Params.browserClient
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Widget_SetupBrowserRenderInputRouterConnections_Params.encodedSize = codec.kStructHeaderSize + 8;

  Widget_SetupBrowserRenderInputRouterConnections_Params.decode = function(decoder) {
    var packed;
    var val = new Widget_SetupBrowserRenderInputRouterConnections_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.browserClient =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Widget_SetupBrowserRenderInputRouterConnections_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Widget_SetupBrowserRenderInputRouterConnections_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.browserClient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RenderInputRouterClient_GetWidgetInputHandler_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderInputRouterClient_GetWidgetInputHandler_Params.prototype.initDefaults_ = function() {
    this.request = new bindings.InterfaceRequest();
    this.host = new input_handler$.WidgetInputHandlerHostPtr();
    this.fromViz = false;
  };
  RenderInputRouterClient_GetWidgetInputHandler_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderInputRouterClient_GetWidgetInputHandler_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderInputRouterClient_GetWidgetInputHandler_Params.request
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderInputRouterClient_GetWidgetInputHandler_Params.host
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RenderInputRouterClient_GetWidgetInputHandler_Params.encodedSize = codec.kStructHeaderSize + 16;

  RenderInputRouterClient_GetWidgetInputHandler_Params.decode = function(decoder) {
    var packed;
    var val = new RenderInputRouterClient_GetWidgetInputHandler_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.host =
        decoder.decodeStruct(new codec.Interface(input_handler$.WidgetInputHandlerHostPtr));
    packed = decoder.readUint8();
    val.fromViz = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RenderInputRouterClient_GetWidgetInputHandler_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderInputRouterClient_GetWidgetInputHandler_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.request);
    encoder.encodeStruct(new codec.Interface(input_handler$.WidgetInputHandlerHostPtr), val.host);
    packed = 0;
    packed |= (val.fromViz & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RenderInputRouterClient_ShowContextMenu_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderInputRouterClient_ShowContextMenu_Params.prototype.initDefaults_ = function() {
    this.sourceType = 0;
    this.location = null;
  };
  RenderInputRouterClient_ShowContextMenu_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderInputRouterClient_ShowContextMenu_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderInputRouterClient_ShowContextMenu_Params.sourceType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, menu_source_type$.MenuSourceType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderInputRouterClient_ShowContextMenu_Params.location
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RenderInputRouterClient_ShowContextMenu_Params.encodedSize = codec.kStructHeaderSize + 16;

  RenderInputRouterClient_ShowContextMenu_Params.decode = function(decoder) {
    var packed;
    var val = new RenderInputRouterClient_ShowContextMenu_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceType =
        decoder.decodeStruct(new codec.Enum(menu_source_type$.MenuSourceType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.location =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  RenderInputRouterClient_ShowContextMenu_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderInputRouterClient_ShowContextMenu_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.sourceType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Point, val.location);
  };
  function RenderInputRouterClient_BindInputTargetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderInputRouterClient_BindInputTargetClient_Params.prototype.initDefaults_ = function() {
    this.host = new bindings.InterfaceRequest();
  };
  RenderInputRouterClient_BindInputTargetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderInputRouterClient_BindInputTargetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderInputRouterClient_BindInputTargetClient_Params.host
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RenderInputRouterClient_BindInputTargetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  RenderInputRouterClient_BindInputTargetClient_Params.decode = function(decoder) {
    var packed;
    var val = new RenderInputRouterClient_BindInputTargetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RenderInputRouterClient_BindInputTargetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderInputRouterClient_BindInputTargetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.host);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kWidgetCompositor_VisualStateRequest_Name = 0;

  function WidgetCompositorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WidgetCompositor,
                                                   handleOrPtrInfo);
  }

  function WidgetCompositorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WidgetCompositor, associatedInterfacePtrInfo);
  }

  WidgetCompositorAssociatedPtr.prototype =
      Object.create(WidgetCompositorPtr.prototype);
  WidgetCompositorAssociatedPtr.prototype.constructor =
      WidgetCompositorAssociatedPtr;

  function WidgetCompositorProxy(receiver) {
    this.receiver_ = receiver;
  }
  WidgetCompositorPtr.prototype.visualStateRequest = function() {
    return WidgetCompositorProxy.prototype.visualStateRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetCompositorProxy.prototype.visualStateRequest = function() {
    var params_ = new WidgetCompositor_VisualStateRequest_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidgetCompositor_VisualStateRequest_Name,
          codec.align(WidgetCompositor_VisualStateRequest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WidgetCompositor_VisualStateRequest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WidgetCompositor_VisualStateRequest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WidgetCompositorStub(delegate) {
    this.delegate_ = delegate;
  }
  WidgetCompositorStub.prototype.visualStateRequest = function() {
    return this.delegate_ && this.delegate_.visualStateRequest && this.delegate_.visualStateRequest();
  }

  WidgetCompositorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WidgetCompositorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidgetCompositor_VisualStateRequest_Name:
      var params = reader.decodeStruct(WidgetCompositor_VisualStateRequest_Params);
      this.visualStateRequest().then(function(response) {
        var responseParams =
            new WidgetCompositor_VisualStateRequest_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidgetCompositor_VisualStateRequest_Name,
            codec.align(WidgetCompositor_VisualStateRequest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WidgetCompositor_VisualStateRequest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWidgetCompositorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWidgetCompositor_VisualStateRequest_Name:
        if (message.expectsResponse())
          paramsClass = WidgetCompositor_VisualStateRequest_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWidgetCompositorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWidgetCompositor_VisualStateRequest_Name:
        if (message.isResponse())
          paramsClass = WidgetCompositor_VisualStateRequest_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WidgetCompositor = {
    name: 'blink.mojom.WidgetCompositor',
    kVersion: 0,
    ptrClass: WidgetCompositorPtr,
    proxyClass: WidgetCompositorProxy,
    stubClass: WidgetCompositorStub,
    validateRequest: validateWidgetCompositorRequest,
    validateResponse: validateWidgetCompositorResponse,
  };
  WidgetCompositorStub.prototype.validator = validateWidgetCompositorRequest;
  WidgetCompositorProxy.prototype.validator = validateWidgetCompositorResponse;
  var kWidgetHost_SetCursor_Name = 0;
  var kWidgetHost_UpdateTooltipUnderCursor_Name = 1;
  var kWidgetHost_UpdateTooltipFromKeyboard_Name = 2;
  var kWidgetHost_ClearKeyboardTriggeredTooltip_Name = 3;
  var kWidgetHost_TextInputStateChanged_Name = 4;
  var kWidgetHost_SelectionBoundsChanged_Name = 5;
  var kWidgetHost_CreateFrameSink_Name = 6;
  var kWidgetHost_RegisterRenderFrameMetadataObserver_Name = 7;

  function WidgetHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WidgetHost,
                                                   handleOrPtrInfo);
  }

  function WidgetHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WidgetHost, associatedInterfacePtrInfo);
  }

  WidgetHostAssociatedPtr.prototype =
      Object.create(WidgetHostPtr.prototype);
  WidgetHostAssociatedPtr.prototype.constructor =
      WidgetHostAssociatedPtr;

  function WidgetHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  WidgetHostPtr.prototype.setCursor = function() {
    return WidgetHostProxy.prototype.setCursor
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.setCursor = function(cursor) {
    var params_ = new WidgetHost_SetCursor_Params();
    params_.cursor = cursor;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_SetCursor_Name,
        codec.align(WidgetHost_SetCursor_Params.encodedSize));
    builder.encodeStruct(WidgetHost_SetCursor_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.updateTooltipUnderCursor = function() {
    return WidgetHostProxy.prototype.updateTooltipUnderCursor
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.updateTooltipUnderCursor = function(tooltipText, textDirectionHint) {
    var params_ = new WidgetHost_UpdateTooltipUnderCursor_Params();
    params_.tooltipText = tooltipText;
    params_.textDirectionHint = textDirectionHint;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_UpdateTooltipUnderCursor_Name,
        codec.align(WidgetHost_UpdateTooltipUnderCursor_Params.encodedSize));
    builder.encodeStruct(WidgetHost_UpdateTooltipUnderCursor_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.updateTooltipFromKeyboard = function() {
    return WidgetHostProxy.prototype.updateTooltipFromKeyboard
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.updateTooltipFromKeyboard = function(tooltipText, textDirectionHint, bounds) {
    var params_ = new WidgetHost_UpdateTooltipFromKeyboard_Params();
    params_.tooltipText = tooltipText;
    params_.textDirectionHint = textDirectionHint;
    params_.bounds = bounds;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_UpdateTooltipFromKeyboard_Name,
        codec.align(WidgetHost_UpdateTooltipFromKeyboard_Params.encodedSize));
    builder.encodeStruct(WidgetHost_UpdateTooltipFromKeyboard_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.clearKeyboardTriggeredTooltip = function() {
    return WidgetHostProxy.prototype.clearKeyboardTriggeredTooltip
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.clearKeyboardTriggeredTooltip = function() {
    var params_ = new WidgetHost_ClearKeyboardTriggeredTooltip_Params();
    var builder = new codec.MessageV0Builder(
        kWidgetHost_ClearKeyboardTriggeredTooltip_Name,
        codec.align(WidgetHost_ClearKeyboardTriggeredTooltip_Params.encodedSize));
    builder.encodeStruct(WidgetHost_ClearKeyboardTriggeredTooltip_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.textInputStateChanged = function() {
    return WidgetHostProxy.prototype.textInputStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.textInputStateChanged = function(state) {
    var params_ = new WidgetHost_TextInputStateChanged_Params();
    params_.state = state;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_TextInputStateChanged_Name,
        codec.align(WidgetHost_TextInputStateChanged_Params.encodedSize));
    builder.encodeStruct(WidgetHost_TextInputStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.selectionBoundsChanged = function() {
    return WidgetHostProxy.prototype.selectionBoundsChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.selectionBoundsChanged = function(anchorRect, anchorDir, focusRect, focusDir, boundingBoxRect, isAnchorFirst) {
    var params_ = new WidgetHost_SelectionBoundsChanged_Params();
    params_.anchorRect = anchorRect;
    params_.anchorDir = anchorDir;
    params_.focusRect = focusRect;
    params_.focusDir = focusDir;
    params_.boundingBoxRect = boundingBoxRect;
    params_.isAnchorFirst = isAnchorFirst;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_SelectionBoundsChanged_Name,
        codec.align(WidgetHost_SelectionBoundsChanged_Params.encodedSize));
    builder.encodeStruct(WidgetHost_SelectionBoundsChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.createFrameSink = function() {
    return WidgetHostProxy.prototype.createFrameSink
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.createFrameSink = function(compositorFrameSinkReceiver, compositorFrameSinkClient, renderInputRouterClient) {
    var params_ = new WidgetHost_CreateFrameSink_Params();
    params_.compositorFrameSinkReceiver = compositorFrameSinkReceiver;
    params_.compositorFrameSinkClient = compositorFrameSinkClient;
    params_.renderInputRouterClient = renderInputRouterClient;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_CreateFrameSink_Name,
        codec.align(WidgetHost_CreateFrameSink_Params.encodedSize));
    builder.encodeStruct(WidgetHost_CreateFrameSink_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetHostPtr.prototype.registerRenderFrameMetadataObserver = function() {
    return WidgetHostProxy.prototype.registerRenderFrameMetadataObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetHostProxy.prototype.registerRenderFrameMetadataObserver = function(renderFrameMetadataObserverClientReceiver, renderFrameMetadataObserver) {
    var params_ = new WidgetHost_RegisterRenderFrameMetadataObserver_Params();
    params_.renderFrameMetadataObserverClientReceiver = renderFrameMetadataObserverClientReceiver;
    params_.renderFrameMetadataObserver = renderFrameMetadataObserver;
    var builder = new codec.MessageV0Builder(
        kWidgetHost_RegisterRenderFrameMetadataObserver_Name,
        codec.align(WidgetHost_RegisterRenderFrameMetadataObserver_Params.encodedSize));
    builder.encodeStruct(WidgetHost_RegisterRenderFrameMetadataObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WidgetHostStub(delegate) {
    this.delegate_ = delegate;
  }
  WidgetHostStub.prototype.setCursor = function(cursor) {
    return this.delegate_ && this.delegate_.setCursor && this.delegate_.setCursor(cursor);
  }
  WidgetHostStub.prototype.updateTooltipUnderCursor = function(tooltipText, textDirectionHint) {
    return this.delegate_ && this.delegate_.updateTooltipUnderCursor && this.delegate_.updateTooltipUnderCursor(tooltipText, textDirectionHint);
  }
  WidgetHostStub.prototype.updateTooltipFromKeyboard = function(tooltipText, textDirectionHint, bounds) {
    return this.delegate_ && this.delegate_.updateTooltipFromKeyboard && this.delegate_.updateTooltipFromKeyboard(tooltipText, textDirectionHint, bounds);
  }
  WidgetHostStub.prototype.clearKeyboardTriggeredTooltip = function() {
    return this.delegate_ && this.delegate_.clearKeyboardTriggeredTooltip && this.delegate_.clearKeyboardTriggeredTooltip();
  }
  WidgetHostStub.prototype.textInputStateChanged = function(state) {
    return this.delegate_ && this.delegate_.textInputStateChanged && this.delegate_.textInputStateChanged(state);
  }
  WidgetHostStub.prototype.selectionBoundsChanged = function(anchorRect, anchorDir, focusRect, focusDir, boundingBoxRect, isAnchorFirst) {
    return this.delegate_ && this.delegate_.selectionBoundsChanged && this.delegate_.selectionBoundsChanged(anchorRect, anchorDir, focusRect, focusDir, boundingBoxRect, isAnchorFirst);
  }
  WidgetHostStub.prototype.createFrameSink = function(compositorFrameSinkReceiver, compositorFrameSinkClient, renderInputRouterClient) {
    return this.delegate_ && this.delegate_.createFrameSink && this.delegate_.createFrameSink(compositorFrameSinkReceiver, compositorFrameSinkClient, renderInputRouterClient);
  }
  WidgetHostStub.prototype.registerRenderFrameMetadataObserver = function(renderFrameMetadataObserverClientReceiver, renderFrameMetadataObserver) {
    return this.delegate_ && this.delegate_.registerRenderFrameMetadataObserver && this.delegate_.registerRenderFrameMetadataObserver(renderFrameMetadataObserverClientReceiver, renderFrameMetadataObserver);
  }

  WidgetHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidgetHost_SetCursor_Name:
      var params = reader.decodeStruct(WidgetHost_SetCursor_Params);
      this.setCursor(params.cursor);
      return true;
    case kWidgetHost_UpdateTooltipUnderCursor_Name:
      var params = reader.decodeStruct(WidgetHost_UpdateTooltipUnderCursor_Params);
      this.updateTooltipUnderCursor(params.tooltipText, params.textDirectionHint);
      return true;
    case kWidgetHost_UpdateTooltipFromKeyboard_Name:
      var params = reader.decodeStruct(WidgetHost_UpdateTooltipFromKeyboard_Params);
      this.updateTooltipFromKeyboard(params.tooltipText, params.textDirectionHint, params.bounds);
      return true;
    case kWidgetHost_ClearKeyboardTriggeredTooltip_Name:
      var params = reader.decodeStruct(WidgetHost_ClearKeyboardTriggeredTooltip_Params);
      this.clearKeyboardTriggeredTooltip();
      return true;
    case kWidgetHost_TextInputStateChanged_Name:
      var params = reader.decodeStruct(WidgetHost_TextInputStateChanged_Params);
      this.textInputStateChanged(params.state);
      return true;
    case kWidgetHost_SelectionBoundsChanged_Name:
      var params = reader.decodeStruct(WidgetHost_SelectionBoundsChanged_Params);
      this.selectionBoundsChanged(params.anchorRect, params.anchorDir, params.focusRect, params.focusDir, params.boundingBoxRect, params.isAnchorFirst);
      return true;
    case kWidgetHost_CreateFrameSink_Name:
      var params = reader.decodeStruct(WidgetHost_CreateFrameSink_Params);
      this.createFrameSink(params.compositorFrameSinkReceiver, params.compositorFrameSinkClient, params.renderInputRouterClient);
      return true;
    case kWidgetHost_RegisterRenderFrameMetadataObserver_Name:
      var params = reader.decodeStruct(WidgetHost_RegisterRenderFrameMetadataObserver_Params);
      this.registerRenderFrameMetadataObserver(params.renderFrameMetadataObserverClientReceiver, params.renderFrameMetadataObserver);
      return true;
    default:
      return false;
    }
  };

  WidgetHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWidgetHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWidgetHost_SetCursor_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_SetCursor_Params;
      break;
      case kWidgetHost_UpdateTooltipUnderCursor_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_UpdateTooltipUnderCursor_Params;
      break;
      case kWidgetHost_UpdateTooltipFromKeyboard_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_UpdateTooltipFromKeyboard_Params;
      break;
      case kWidgetHost_ClearKeyboardTriggeredTooltip_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_ClearKeyboardTriggeredTooltip_Params;
      break;
      case kWidgetHost_TextInputStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_TextInputStateChanged_Params;
      break;
      case kWidgetHost_SelectionBoundsChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_SelectionBoundsChanged_Params;
      break;
      case kWidgetHost_CreateFrameSink_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_CreateFrameSink_Params;
      break;
      case kWidgetHost_RegisterRenderFrameMetadataObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WidgetHost_RegisterRenderFrameMetadataObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWidgetHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WidgetHost = {
    name: 'blink.mojom.WidgetHost',
    kVersion: 0,
    ptrClass: WidgetHostPtr,
    proxyClass: WidgetHostProxy,
    stubClass: WidgetHostStub,
    validateRequest: validateWidgetHostRequest,
    validateResponse: null,
  };
  WidgetHostStub.prototype.validator = validateWidgetHostRequest;
  WidgetHostProxy.prototype.validator = null;
  var kWidget_ForceRedraw_Name = 0;
  var kWidget_UpdateVisualProperties_Name = 1;
  var kWidget_UpdateScreenRects_Name = 2;
  var kWidget_WasHidden_Name = 3;
  var kWidget_WasShown_Name = 4;
  var kWidget_RequestSuccessfulPresentationTimeForNextFrame_Name = 5;
  var kWidget_CancelSuccessfulPresentationTimeRequest_Name = 6;
  var kWidget_SetupBrowserRenderInputRouterConnections_Name = 7;

  function WidgetPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Widget,
                                                   handleOrPtrInfo);
  }

  function WidgetAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Widget, associatedInterfacePtrInfo);
  }

  WidgetAssociatedPtr.prototype =
      Object.create(WidgetPtr.prototype);
  WidgetAssociatedPtr.prototype.constructor =
      WidgetAssociatedPtr;

  function WidgetProxy(receiver) {
    this.receiver_ = receiver;
  }
  WidgetPtr.prototype.forceRedraw = function() {
    return WidgetProxy.prototype.forceRedraw
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.forceRedraw = function() {
    var params_ = new Widget_ForceRedraw_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidget_ForceRedraw_Name,
          codec.align(Widget_ForceRedraw_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Widget_ForceRedraw_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Widget_ForceRedraw_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetPtr.prototype.updateVisualProperties = function() {
    return WidgetProxy.prototype.updateVisualProperties
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.updateVisualProperties = function(visualProperties) {
    var params_ = new Widget_UpdateVisualProperties_Params();
    params_.visualProperties = visualProperties;
    var builder = new codec.MessageV0Builder(
        kWidget_UpdateVisualProperties_Name,
        codec.align(Widget_UpdateVisualProperties_Params.encodedSize));
    builder.encodeStruct(Widget_UpdateVisualProperties_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetPtr.prototype.updateScreenRects = function() {
    return WidgetProxy.prototype.updateScreenRects
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.updateScreenRects = function(widgetScreenRect, windowScreenRect) {
    var params_ = new Widget_UpdateScreenRects_Params();
    params_.widgetScreenRect = widgetScreenRect;
    params_.windowScreenRect = windowScreenRect;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWidget_UpdateScreenRects_Name,
          codec.align(Widget_UpdateScreenRects_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Widget_UpdateScreenRects_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Widget_UpdateScreenRects_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WidgetPtr.prototype.wasHidden = function() {
    return WidgetProxy.prototype.wasHidden
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.wasHidden = function() {
    var params_ = new Widget_WasHidden_Params();
    var builder = new codec.MessageV0Builder(
        kWidget_WasHidden_Name,
        codec.align(Widget_WasHidden_Params.encodedSize));
    builder.encodeStruct(Widget_WasHidden_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetPtr.prototype.wasShown = function() {
    return WidgetProxy.prototype.wasShown
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.wasShown = function(wasEvicted, recordTabSwitchTimeRequest) {
    var params_ = new Widget_WasShown_Params();
    params_.wasEvicted = wasEvicted;
    params_.recordTabSwitchTimeRequest = recordTabSwitchTimeRequest;
    var builder = new codec.MessageV0Builder(
        kWidget_WasShown_Name,
        codec.align(Widget_WasShown_Params.encodedSize));
    builder.encodeStruct(Widget_WasShown_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetPtr.prototype.requestSuccessfulPresentationTimeForNextFrame = function() {
    return WidgetProxy.prototype.requestSuccessfulPresentationTimeForNextFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.requestSuccessfulPresentationTimeForNextFrame = function(visibleTimeRequest) {
    var params_ = new Widget_RequestSuccessfulPresentationTimeForNextFrame_Params();
    params_.visibleTimeRequest = visibleTimeRequest;
    var builder = new codec.MessageV0Builder(
        kWidget_RequestSuccessfulPresentationTimeForNextFrame_Name,
        codec.align(Widget_RequestSuccessfulPresentationTimeForNextFrame_Params.encodedSize));
    builder.encodeStruct(Widget_RequestSuccessfulPresentationTimeForNextFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetPtr.prototype.cancelSuccessfulPresentationTimeRequest = function() {
    return WidgetProxy.prototype.cancelSuccessfulPresentationTimeRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.cancelSuccessfulPresentationTimeRequest = function() {
    var params_ = new Widget_CancelSuccessfulPresentationTimeRequest_Params();
    var builder = new codec.MessageV0Builder(
        kWidget_CancelSuccessfulPresentationTimeRequest_Name,
        codec.align(Widget_CancelSuccessfulPresentationTimeRequest_Params.encodedSize));
    builder.encodeStruct(Widget_CancelSuccessfulPresentationTimeRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WidgetPtr.prototype.setupBrowserRenderInputRouterConnections = function() {
    return WidgetProxy.prototype.setupBrowserRenderInputRouterConnections
        .apply(this.ptr.getProxy(), arguments);
  };

  WidgetProxy.prototype.setupBrowserRenderInputRouterConnections = function(browserClient) {
    var params_ = new Widget_SetupBrowserRenderInputRouterConnections_Params();
    params_.browserClient = browserClient;
    var builder = new codec.MessageV0Builder(
        kWidget_SetupBrowserRenderInputRouterConnections_Name,
        codec.align(Widget_SetupBrowserRenderInputRouterConnections_Params.encodedSize));
    builder.encodeStruct(Widget_SetupBrowserRenderInputRouterConnections_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WidgetStub(delegate) {
    this.delegate_ = delegate;
  }
  WidgetStub.prototype.forceRedraw = function() {
    return this.delegate_ && this.delegate_.forceRedraw && this.delegate_.forceRedraw();
  }
  WidgetStub.prototype.updateVisualProperties = function(visualProperties) {
    return this.delegate_ && this.delegate_.updateVisualProperties && this.delegate_.updateVisualProperties(visualProperties);
  }
  WidgetStub.prototype.updateScreenRects = function(widgetScreenRect, windowScreenRect) {
    return this.delegate_ && this.delegate_.updateScreenRects && this.delegate_.updateScreenRects(widgetScreenRect, windowScreenRect);
  }
  WidgetStub.prototype.wasHidden = function() {
    return this.delegate_ && this.delegate_.wasHidden && this.delegate_.wasHidden();
  }
  WidgetStub.prototype.wasShown = function(wasEvicted, recordTabSwitchTimeRequest) {
    return this.delegate_ && this.delegate_.wasShown && this.delegate_.wasShown(wasEvicted, recordTabSwitchTimeRequest);
  }
  WidgetStub.prototype.requestSuccessfulPresentationTimeForNextFrame = function(visibleTimeRequest) {
    return this.delegate_ && this.delegate_.requestSuccessfulPresentationTimeForNextFrame && this.delegate_.requestSuccessfulPresentationTimeForNextFrame(visibleTimeRequest);
  }
  WidgetStub.prototype.cancelSuccessfulPresentationTimeRequest = function() {
    return this.delegate_ && this.delegate_.cancelSuccessfulPresentationTimeRequest && this.delegate_.cancelSuccessfulPresentationTimeRequest();
  }
  WidgetStub.prototype.setupBrowserRenderInputRouterConnections = function(browserClient) {
    return this.delegate_ && this.delegate_.setupBrowserRenderInputRouterConnections && this.delegate_.setupBrowserRenderInputRouterConnections(browserClient);
  }

  WidgetStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidget_UpdateVisualProperties_Name:
      var params = reader.decodeStruct(Widget_UpdateVisualProperties_Params);
      this.updateVisualProperties(params.visualProperties);
      return true;
    case kWidget_WasHidden_Name:
      var params = reader.decodeStruct(Widget_WasHidden_Params);
      this.wasHidden();
      return true;
    case kWidget_WasShown_Name:
      var params = reader.decodeStruct(Widget_WasShown_Params);
      this.wasShown(params.wasEvicted, params.recordTabSwitchTimeRequest);
      return true;
    case kWidget_RequestSuccessfulPresentationTimeForNextFrame_Name:
      var params = reader.decodeStruct(Widget_RequestSuccessfulPresentationTimeForNextFrame_Params);
      this.requestSuccessfulPresentationTimeForNextFrame(params.visibleTimeRequest);
      return true;
    case kWidget_CancelSuccessfulPresentationTimeRequest_Name:
      var params = reader.decodeStruct(Widget_CancelSuccessfulPresentationTimeRequest_Params);
      this.cancelSuccessfulPresentationTimeRequest();
      return true;
    case kWidget_SetupBrowserRenderInputRouterConnections_Name:
      var params = reader.decodeStruct(Widget_SetupBrowserRenderInputRouterConnections_Params);
      this.setupBrowserRenderInputRouterConnections(params.browserClient);
      return true;
    default:
      return false;
    }
  };

  WidgetStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWidget_ForceRedraw_Name:
      var params = reader.decodeStruct(Widget_ForceRedraw_Params);
      this.forceRedraw().then(function(response) {
        var responseParams =
            new Widget_ForceRedraw_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidget_ForceRedraw_Name,
            codec.align(Widget_ForceRedraw_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Widget_ForceRedraw_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWidget_UpdateScreenRects_Name:
      var params = reader.decodeStruct(Widget_UpdateScreenRects_Params);
      this.updateScreenRects(params.widgetScreenRect, params.windowScreenRect).then(function(response) {
        var responseParams =
            new Widget_UpdateScreenRects_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kWidget_UpdateScreenRects_Name,
            codec.align(Widget_UpdateScreenRects_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Widget_UpdateScreenRects_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWidgetRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWidget_ForceRedraw_Name:
        if (message.expectsResponse())
          paramsClass = Widget_ForceRedraw_Params;
      break;
      case kWidget_UpdateVisualProperties_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Widget_UpdateVisualProperties_Params;
      break;
      case kWidget_UpdateScreenRects_Name:
        if (message.expectsResponse())
          paramsClass = Widget_UpdateScreenRects_Params;
      break;
      case kWidget_WasHidden_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Widget_WasHidden_Params;
      break;
      case kWidget_WasShown_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Widget_WasShown_Params;
      break;
      case kWidget_RequestSuccessfulPresentationTimeForNextFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Widget_RequestSuccessfulPresentationTimeForNextFrame_Params;
      break;
      case kWidget_CancelSuccessfulPresentationTimeRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Widget_CancelSuccessfulPresentationTimeRequest_Params;
      break;
      case kWidget_SetupBrowserRenderInputRouterConnections_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Widget_SetupBrowserRenderInputRouterConnections_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWidgetResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWidget_ForceRedraw_Name:
        if (message.isResponse())
          paramsClass = Widget_ForceRedraw_ResponseParams;
        break;
      case kWidget_UpdateScreenRects_Name:
        if (message.isResponse())
          paramsClass = Widget_UpdateScreenRects_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var Widget = {
    name: 'blink.mojom.Widget',
    kVersion: 0,
    ptrClass: WidgetPtr,
    proxyClass: WidgetProxy,
    stubClass: WidgetStub,
    validateRequest: validateWidgetRequest,
    validateResponse: validateWidgetResponse,
  };
  WidgetStub.prototype.validator = validateWidgetRequest;
  WidgetProxy.prototype.validator = validateWidgetResponse;
  var kRenderInputRouterClient_GetWidgetInputHandler_Name = 0;
  var kRenderInputRouterClient_ShowContextMenu_Name = 1;
  var kRenderInputRouterClient_BindInputTargetClient_Name = 2;

  function RenderInputRouterClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RenderInputRouterClient,
                                                   handleOrPtrInfo);
  }

  function RenderInputRouterClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RenderInputRouterClient, associatedInterfacePtrInfo);
  }

  RenderInputRouterClientAssociatedPtr.prototype =
      Object.create(RenderInputRouterClientPtr.prototype);
  RenderInputRouterClientAssociatedPtr.prototype.constructor =
      RenderInputRouterClientAssociatedPtr;

  function RenderInputRouterClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  RenderInputRouterClientPtr.prototype.getWidgetInputHandler = function() {
    return RenderInputRouterClientProxy.prototype.getWidgetInputHandler
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderInputRouterClientProxy.prototype.getWidgetInputHandler = function(request, host, fromViz) {
    var params_ = new RenderInputRouterClient_GetWidgetInputHandler_Params();
    params_.request = request;
    params_.host = host;
    params_.fromViz = fromViz;
    var builder = new codec.MessageV0Builder(
        kRenderInputRouterClient_GetWidgetInputHandler_Name,
        codec.align(RenderInputRouterClient_GetWidgetInputHandler_Params.encodedSize));
    builder.encodeStruct(RenderInputRouterClient_GetWidgetInputHandler_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RenderInputRouterClientPtr.prototype.showContextMenu = function() {
    return RenderInputRouterClientProxy.prototype.showContextMenu
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderInputRouterClientProxy.prototype.showContextMenu = function(sourceType, location) {
    var params_ = new RenderInputRouterClient_ShowContextMenu_Params();
    params_.sourceType = sourceType;
    params_.location = location;
    var builder = new codec.MessageV0Builder(
        kRenderInputRouterClient_ShowContextMenu_Name,
        codec.align(RenderInputRouterClient_ShowContextMenu_Params.encodedSize));
    builder.encodeStruct(RenderInputRouterClient_ShowContextMenu_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RenderInputRouterClientPtr.prototype.bindInputTargetClient = function() {
    return RenderInputRouterClientProxy.prototype.bindInputTargetClient
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderInputRouterClientProxy.prototype.bindInputTargetClient = function(host) {
    var params_ = new RenderInputRouterClient_BindInputTargetClient_Params();
    params_.host = host;
    var builder = new codec.MessageV0Builder(
        kRenderInputRouterClient_BindInputTargetClient_Name,
        codec.align(RenderInputRouterClient_BindInputTargetClient_Params.encodedSize));
    builder.encodeStruct(RenderInputRouterClient_BindInputTargetClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RenderInputRouterClientStub(delegate) {
    this.delegate_ = delegate;
  }
  RenderInputRouterClientStub.prototype.getWidgetInputHandler = function(request, host, fromViz) {
    return this.delegate_ && this.delegate_.getWidgetInputHandler && this.delegate_.getWidgetInputHandler(request, host, fromViz);
  }
  RenderInputRouterClientStub.prototype.showContextMenu = function(sourceType, location) {
    return this.delegate_ && this.delegate_.showContextMenu && this.delegate_.showContextMenu(sourceType, location);
  }
  RenderInputRouterClientStub.prototype.bindInputTargetClient = function(host) {
    return this.delegate_ && this.delegate_.bindInputTargetClient && this.delegate_.bindInputTargetClient(host);
  }

  RenderInputRouterClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderInputRouterClient_GetWidgetInputHandler_Name:
      var params = reader.decodeStruct(RenderInputRouterClient_GetWidgetInputHandler_Params);
      this.getWidgetInputHandler(params.request, params.host, params.fromViz);
      return true;
    case kRenderInputRouterClient_ShowContextMenu_Name:
      var params = reader.decodeStruct(RenderInputRouterClient_ShowContextMenu_Params);
      this.showContextMenu(params.sourceType, params.location);
      return true;
    case kRenderInputRouterClient_BindInputTargetClient_Name:
      var params = reader.decodeStruct(RenderInputRouterClient_BindInputTargetClient_Params);
      this.bindInputTargetClient(params.host);
      return true;
    default:
      return false;
    }
  };

  RenderInputRouterClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRenderInputRouterClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRenderInputRouterClient_GetWidgetInputHandler_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderInputRouterClient_GetWidgetInputHandler_Params;
      break;
      case kRenderInputRouterClient_ShowContextMenu_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderInputRouterClient_ShowContextMenu_Params;
      break;
      case kRenderInputRouterClient_BindInputTargetClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderInputRouterClient_BindInputTargetClient_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRenderInputRouterClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RenderInputRouterClient = {
    name: 'blink.mojom.RenderInputRouterClient',
    kVersion: 0,
    ptrClass: RenderInputRouterClientPtr,
    proxyClass: RenderInputRouterClientProxy,
    stubClass: RenderInputRouterClientStub,
    validateRequest: validateRenderInputRouterClientRequest,
    validateResponse: null,
  };
  RenderInputRouterClientStub.prototype.validator = validateRenderInputRouterClientRequest;
  RenderInputRouterClientProxy.prototype.validator = null;
  exports.WidgetCompositor = WidgetCompositor;
  exports.WidgetCompositorPtr = WidgetCompositorPtr;
  exports.WidgetCompositorAssociatedPtr = WidgetCompositorAssociatedPtr;
  exports.WidgetHost = WidgetHost;
  exports.WidgetHostPtr = WidgetHostPtr;
  exports.WidgetHostAssociatedPtr = WidgetHostAssociatedPtr;
  exports.Widget = Widget;
  exports.WidgetPtr = WidgetPtr;
  exports.WidgetAssociatedPtr = WidgetAssociatedPtr;
  exports.RenderInputRouterClient = RenderInputRouterClient;
  exports.RenderInputRouterClientPtr = RenderInputRouterClientPtr;
  exports.RenderInputRouterClientAssociatedPtr = RenderInputRouterClientAssociatedPtr;
})();