var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/CompilerScriptMapping.js
var CompilerScriptMapping_exports = {};
__export(CompilerScriptMapping_exports, {
  CompilerScriptMapping: () => CompilerScriptMapping
});
import * as Common3 from "./../../core/common/common.js";
import * as Platform2 from "./../../core/platform/platform.js";
import * as SDK3 from "./../../core/sdk/sdk.js";

// gen/third_party/devtools-frontend/src/front_end/models/stack_trace/stack_trace_impl.js
import * as Common from "./../../core/common/common.js";
import * as SDK from "./../../core/sdk/sdk.js";
import * as StackTrace from "./../stack_trace/stack_trace.js";
var __defProp2 = Object.defineProperty;
var __export2 = (target, all) => {
  for (var name in all)
    __defProp2(target, name, { get: all[name], enumerable: true });
};
var StackTraceImpl_exports = {};
__export2(StackTraceImpl_exports, {
  AsyncFragmentImpl: () => AsyncFragmentImpl,
  FragmentImpl: () => FragmentImpl,
  FrameImpl: () => FrameImpl,
  StackTraceImpl: () => StackTraceImpl
});
var StackTraceImpl = class extends Common.ObjectWrapper.ObjectWrapper {
  syncFragment;
  asyncFragments;
  constructor(syncFragment, asyncFragments) {
    super();
    this.syncFragment = syncFragment;
    this.asyncFragments = asyncFragments;
    syncFragment.stackTraces.add(this);
    this.asyncFragments.forEach((asyncFragment) => asyncFragment.fragment.stackTraces.add(this));
  }
};
var FragmentImpl = class _FragmentImpl {
  node;
  stackTraces = /* @__PURE__ */ new Set();
  /**
   * Fragments are deduplicated based on the node.
   *
   * In turn, each fragment can be part of multiple stack traces.
   */
  static getOrCreate(node) {
    if (!node.fragment) {
      node.fragment = new _FragmentImpl(node);
    }
    return node.fragment;
  }
  constructor(node) {
    this.node = node;
  }
  get frames() {
    const frames = [];
    for (const node of this.node.getCallStack()) {
      frames.push(...node.frames);
    }
    return frames;
  }
};
var AsyncFragmentImpl = class {
  constructor(description, fragment) {
    this.description = description;
    this.fragment = fragment;
  }
  get frames() {
    return this.fragment.frames;
  }
};
var FrameImpl = class {
  url;
  uiSourceCode;
  name;
  line;
  column;
  missingDebugInfo;
  constructor(url, uiSourceCode, name, line, column, missingDebugInfo) {
    this.url = url;
    this.uiSourceCode = uiSourceCode;
    this.name = name;
    this.line = line;
    this.column = column;
    this.missingDebugInfo = missingDebugInfo;
  }
};
var StackTraceModel_exports = {};
__export2(StackTraceModel_exports, {
  StackTraceModel: () => StackTraceModel
});
var Trie_exports = {};
__export2(Trie_exports, {
  FrameNode: () => FrameNode,
  Trie: () => Trie,
  compareRawFrames: () => compareRawFrames,
  isBuiltinFrame: () => isBuiltinFrame
});
function isBuiltinFrame(rawFrame) {
  return rawFrame.lineNumber === -1 && rawFrame.columnNumber === -1 && !Boolean(rawFrame.scriptId) && !Boolean(rawFrame.url);
}
var FrameNode = class {
  parent;
  children = [];
  rawFrame;
  frames = [];
  fragment;
  constructor(rawFrame, parent) {
    this.rawFrame = rawFrame;
    this.parent = parent;
  }
  /**
   * Produces the ancestor chain. Including `this` but excluding the `RootFrameNode`.
   */
  *getCallStack() {
    for (let node = this; node.parent; node = node.parent) {
      yield node;
    }
  }
};
var Trie = class {
  #root = { parent: null, children: [] };
  /**
   * Most sources produce stack traces in "top-to-bottom" order, so that is what this method expects.
   *
   * @returns The {@link FrameNode} corresponding to the top-most stack frame.
   */
  insert(frames) {
    if (frames.length === 0) {
      throw new Error("Trie.insert called with an empty frames array.");
    }
    let currentNode = this.#root;
    for (let i = frames.length - 1; i >= 0; --i) {
      currentNode = this.#insert(currentNode, frames[i]);
    }
    return currentNode;
  }
  /**
   * Inserts `rawFrame` into the children of the provided node if not already there.
   *
   * @returns the child node corresponding to `rawFrame`.
   */
  #insert(node, rawFrame) {
    let i = 0;
    for (; i < node.children.length; ++i) {
      const maybeChild = node.children[i];
      const child = maybeChild instanceof WeakRef ? maybeChild.deref() : maybeChild;
      if (!child) {
        continue;
      }
      const compareResult = compareRawFrames(child.rawFrame, rawFrame);
      if (compareResult === 0) {
        return child;
      }
      if (compareResult > 0) {
        break;
      }
    }
    const newNode = new FrameNode(rawFrame, node);
    if (node.parent) {
      node.children.splice(i, 0, newNode);
    } else {
      node.children.splice(i, 0, new WeakRef(newNode));
    }
    return newNode;
  }
  /**
   * Traverses the trie in pre-order.
   *
   * @param node Start at `node` or `null` to start with the children of the root.
   * @param visit Called on each node in the trie. Return `true` if the visitor should descend into child nodes of the provided node.
   */
  walk(node, visit) {
    const stack = node ? [node] : [...this.#root.children].map((ref) => ref.deref()).filter((node2) => Boolean(node2));
    for (let node2 = stack.pop(); node2; node2 = stack.pop()) {
      const visitChildren = visit(node2);
      if (visitChildren) {
        for (let i = node2.children.length - 1; i >= 0; --i) {
          stack.push(node2.children[i]);
        }
      }
    }
  }
};
function compareRawFrames(a, b) {
  const scriptIdCompare = (a.scriptId ?? "").localeCompare(b.scriptId ?? "");
  if (scriptIdCompare !== 0) {
    return scriptIdCompare;
  }
  const urlCompare = (a.url ?? "").localeCompare(b.url ?? "");
  if (urlCompare !== 0) {
    return urlCompare;
  }
  const nameCompare = (a.functionName ?? "").localeCompare(b.functionName ?? "");
  if (nameCompare !== 0) {
    return nameCompare;
  }
  if (a.lineNumber !== b.lineNumber) {
    return a.lineNumber - b.lineNumber;
  }
  return a.columnNumber - b.columnNumber;
}
var StackTraceModel = class _StackTraceModel extends SDK.SDKModel.SDKModel {
  #trie = new Trie();
  /** @returns the {@link StackTraceModel} for the target, or the model for the primaryPageTarget when passing null/undefined */
  static #modelForTarget(target) {
    const model = (target ?? SDK.TargetManager.TargetManager.instance().primaryPageTarget())?.model(_StackTraceModel);
    if (!model) {
      throw new Error("Unable to find StackTraceModel");
    }
    return model;
  }
  async createFromProtocolRuntime(stackTrace, rawFramesToUIFrames) {
    const translatePromises = [];
    const fragment = this.#createFragment(stackTrace.callFrames);
    translatePromises.push(this.#translateFragment(fragment, rawFramesToUIFrames));
    const asyncFragments = [];
    const debuggerModel = this.target().model(SDK.DebuggerModel.DebuggerModel);
    if (debuggerModel) {
      for await (const { stackTrace: asyncStackTrace, target } of debuggerModel.iterateAsyncParents(stackTrace)) {
        const model = _StackTraceModel.#modelForTarget(target);
        const asyncFragment = model.#createFragment(asyncStackTrace.callFrames);
        translatePromises.push(model.#translateFragment(asyncFragment, rawFramesToUIFrames));
        asyncFragments.push(new AsyncFragmentImpl(asyncStackTrace.description ?? "", asyncFragment));
      }
    }
    await Promise.all(translatePromises);
    return new StackTraceImpl(fragment, asyncFragments);
  }
  /** Trigger re-translation of all fragments with the provide script in their call stack */
  async scriptInfoChanged(script, translateRawFrames) {
    const translatePromises = [];
    let stackTracesToUpdate = /* @__PURE__ */ new Set();
    for (const fragment of this.#affectedFragments(script)) {
      if (fragment.node.children.length === 0) {
        translatePromises.push(this.#translateFragment(fragment, translateRawFrames));
      }
      stackTracesToUpdate = stackTracesToUpdate.union(fragment.stackTraces);
    }
    await Promise.all(translatePromises);
    for (const stackTrace of stackTracesToUpdate) {
      stackTrace.dispatchEventToListeners(StackTrace.StackTrace.Events.UPDATED);
    }
  }
  #createFragment(frames) {
    return FragmentImpl.getOrCreate(this.#trie.insert(frames));
  }
  async #translateFragment(fragment, rawFramesToUIFrames) {
    const rawFrames = fragment.node.getCallStack().map((node) => node.rawFrame).toArray();
    const uiFrames = await rawFramesToUIFrames(rawFrames, this.target());
    console.assert(rawFrames.length === uiFrames.length, "Broken rawFramesToUIFrames implementation");
    let i = 0;
    for (const node of fragment.node.getCallStack()) {
      node.frames = uiFrames[i++].map(
        (frame) => new FrameImpl(
          frame.url,
          frame.uiSourceCode,
          frame.name,
          frame.line,
          frame.column,
          frame.missingDebugInfo
        )
      );
    }
  }
  #affectedFragments(script) {
    const affectedBranches = /* @__PURE__ */ new Set();
    this.#trie.walk(null, (node) => {
      if (node.rawFrame.scriptId === script.scriptId || !node.rawFrame.scriptId && node.rawFrame.url === script.sourceURL) {
        affectedBranches.add(node);
        return false;
      }
      return true;
    });
    const fragments = /* @__PURE__ */ new Set();
    for (const branch of affectedBranches) {
      this.#trie.walk(branch, (node) => {
        if (node.fragment) {
          fragments.add(node.fragment);
        }
        return true;
      });
    }
    return fragments;
  }
};
SDK.SDKModel.SDKModel.register(StackTraceModel, { capabilities: SDK.Target.Capability.NONE, autostart: false });

// gen/third_party/devtools-frontend/src/front_end/models/bindings/CompilerScriptMapping.js
import * as TextUtils2 from "./../text_utils/text_utils.js";
import * as Workspace3 from "./../workspace/workspace.js";

// gen/third_party/devtools-frontend/src/front_end/models/bindings/ContentProviderBasedProject.js
var ContentProviderBasedProject_exports = {};
__export(ContentProviderBasedProject_exports, {
  ContentProviderBasedProject: () => ContentProviderBasedProject
});
import * as i18n from "./../../core/i18n/i18n.js";
import * as Platform from "./../../core/platform/platform.js";
import * as TextUtils from "./../text_utils/text_utils.js";
import * as Workspace from "./../workspace/workspace.js";
var UIStrings = {
  /**
   * @description Error message that is displayed in the Sources panel when can't be loaded.
   */
  unknownErrorLoadingFile: "Unknown error loading file"
};
var str_ = i18n.i18n.registerUIStrings("models/bindings/ContentProviderBasedProject.ts", UIStrings);
var i18nString = i18n.i18n.getLocalizedString.bind(void 0, str_);
var ContentProviderBasedProject = class extends Workspace.Workspace.ProjectStore {
  #isServiceProject;
  #uiSourceCodeToData = /* @__PURE__ */ new WeakMap();
  constructor(workspace, id, type, displayName, isServiceProject) {
    super(workspace, id, type, displayName);
    this.#isServiceProject = isServiceProject;
    workspace.addProject(this);
  }
  async requestFileContent(uiSourceCode) {
    const { contentProvider } = this.#uiSourceCodeToData.get(uiSourceCode);
    try {
      return await contentProvider.requestContentData();
    } catch (err) {
      return {
        error: err ? String(err) : i18nString(UIStrings.unknownErrorLoadingFile)
      };
    }
  }
  isServiceProject() {
    return this.#isServiceProject;
  }
  async requestMetadata(uiSourceCode) {
    const { metadata } = this.#uiSourceCodeToData.get(uiSourceCode);
    return metadata;
  }
  canSetFileContent() {
    return false;
  }
  async setFileContent(_uiSourceCode, _newContent, _isBase64) {
  }
  fullDisplayName(uiSourceCode) {
    let parentPath = uiSourceCode.parentURL().replace(/^(?:https?|file)\:\/\//, "");
    try {
      parentPath = decodeURI(parentPath);
    } catch {
    }
    return parentPath + "/" + uiSourceCode.displayName(true);
  }
  mimeType(uiSourceCode) {
    const { mimeType } = this.#uiSourceCodeToData.get(uiSourceCode);
    return mimeType;
  }
  canRename() {
    return false;
  }
  rename(_uiSourceCode, _newName, callback) {
    callback(false);
  }
  excludeFolder(_path) {
  }
  canExcludeFolder(_path) {
    return false;
  }
  async createFile(_path, _name, _content, _isBase64) {
    return null;
  }
  canCreateFile() {
    return false;
  }
  deleteFile(_uiSourceCode) {
  }
  remove() {
  }
  searchInFileContent(uiSourceCode, query, caseSensitive, isRegex) {
    const { contentProvider } = this.#uiSourceCodeToData.get(uiSourceCode);
    return contentProvider.searchInContent(query, caseSensitive, isRegex);
  }
  async findFilesMatchingSearchRequest(searchConfig, filesMatchingFileQuery, progress) {
    const result = /* @__PURE__ */ new Map();
    progress.totalWork = filesMatchingFileQuery.length;
    await Promise.all(filesMatchingFileQuery.map(searchInContent.bind(this)));
    progress.done = true;
    return result;
    async function searchInContent(uiSourceCode) {
      let allMatchesFound = true;
      let matches = [];
      for (const query of searchConfig.queries().slice()) {
        const searchMatches = await this.searchInFileContent(uiSourceCode, query, !searchConfig.ignoreCase(), searchConfig.isRegex());
        if (!searchMatches.length) {
          allMatchesFound = false;
          break;
        }
        matches = Platform.ArrayUtilities.mergeOrdered(
          matches,
          searchMatches,
          TextUtils.ContentProvider.SearchMatch.comparator
        );
      }
      if (allMatchesFound) {
        result.set(uiSourceCode, matches);
      }
      ++progress.worked;
    }
  }
  indexContent(progress) {
    queueMicrotask(() => {
      progress.done = true;
    });
  }
  addUISourceCodeWithProvider(uiSourceCode, contentProvider, metadata, mimeType) {
    this.#uiSourceCodeToData.set(uiSourceCode, { mimeType, metadata, contentProvider });
    this.addUISourceCode(uiSourceCode);
  }
  addContentProvider(url, contentProvider, mimeType) {
    const uiSourceCode = this.createUISourceCode(url, contentProvider.contentType());
    this.addUISourceCodeWithProvider(uiSourceCode, contentProvider, null, mimeType);
    return uiSourceCode;
  }
  reset() {
    this.removeProject();
    this.workspace().addProject(this);
  }
  dispose() {
    this.removeProject();
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/NetworkProject.js
var NetworkProject_exports = {};
__export(NetworkProject_exports, {
  Events: () => Events,
  NetworkProject: () => NetworkProject,
  NetworkProjectManager: () => NetworkProjectManager
});
import * as Common2 from "./../../core/common/common.js";
import * as SDK2 from "./../../core/sdk/sdk.js";
var uiSourceCodeToAttributionMap = /* @__PURE__ */ new WeakMap();
var projectToTargetMap = /* @__PURE__ */ new WeakMap();
var networkProjectManagerInstance;
var NetworkProjectManager = class _NetworkProjectManager extends Common2.ObjectWrapper.ObjectWrapper {
  constructor() {
    super();
  }
  static instance({ forceNew } = { forceNew: false }) {
    if (!networkProjectManagerInstance || forceNew) {
      networkProjectManagerInstance = new _NetworkProjectManager();
    }
    return networkProjectManagerInstance;
  }
};
var Events = /* @__PURE__ */ ((Events2) => {
  Events2["FRAME_ATTRIBUTION_ADDED"] = "FrameAttributionAdded";
  Events2["FRAME_ATTRIBUTION_REMOVED"] = "FrameAttributionRemoved";
  return Events2;
})(Events || {});
var NetworkProject = class _NetworkProject {
  static resolveFrame(uiSourceCode, frameId) {
    const target = _NetworkProject.targetForUISourceCode(uiSourceCode);
    const resourceTreeModel = target?.model(SDK2.ResourceTreeModel.ResourceTreeModel);
    return resourceTreeModel ? resourceTreeModel.frameForId(frameId) : null;
  }
  static setInitialFrameAttribution(uiSourceCode, frameId) {
    if (!frameId) {
      return;
    }
    const frame = _NetworkProject.resolveFrame(uiSourceCode, frameId);
    if (!frame) {
      return;
    }
    const attribution = /* @__PURE__ */ new Map();
    attribution.set(frameId, { frame, count: 1 });
    uiSourceCodeToAttributionMap.set(uiSourceCode, attribution);
  }
  static cloneInitialFrameAttribution(fromUISourceCode, toUISourceCode) {
    const fromAttribution = uiSourceCodeToAttributionMap.get(fromUISourceCode);
    if (!fromAttribution) {
      return;
    }
    const toAttribution = /* @__PURE__ */ new Map();
    for (const frameId of fromAttribution.keys()) {
      const value = fromAttribution.get(frameId);
      if (typeof value !== "undefined") {
        toAttribution.set(frameId, { frame: value.frame, count: value.count });
      }
    }
    uiSourceCodeToAttributionMap.set(toUISourceCode, toAttribution);
  }
  static addFrameAttribution(uiSourceCode, frameId) {
    const frame = _NetworkProject.resolveFrame(uiSourceCode, frameId);
    if (!frame) {
      return;
    }
    const frameAttribution = uiSourceCodeToAttributionMap.get(uiSourceCode);
    if (!frameAttribution) {
      return;
    }
    const attributionInfo = frameAttribution.get(frameId) || { frame, count: 0 };
    attributionInfo.count += 1;
    frameAttribution.set(frameId, attributionInfo);
    if (attributionInfo.count !== 1) {
      return;
    }
    const data = { uiSourceCode, frame };
    NetworkProjectManager.instance().dispatchEventToListeners("FrameAttributionAdded", data);
  }
  static removeFrameAttribution(uiSourceCode, frameId) {
    const frameAttribution = uiSourceCodeToAttributionMap.get(uiSourceCode);
    if (!frameAttribution) {
      return;
    }
    const attributionInfo = frameAttribution.get(frameId);
    console.assert(Boolean(attributionInfo), "Failed to remove frame attribution for url: " + uiSourceCode.url());
    if (!attributionInfo) {
      return;
    }
    attributionInfo.count -= 1;
    if (attributionInfo.count > 0) {
      return;
    }
    frameAttribution.delete(frameId);
    const data = { uiSourceCode, frame: attributionInfo.frame };
    NetworkProjectManager.instance().dispatchEventToListeners("FrameAttributionRemoved", data);
  }
  static targetForUISourceCode(uiSourceCode) {
    return projectToTargetMap.get(uiSourceCode.project()) || null;
  }
  static setTargetForProject(project, target) {
    projectToTargetMap.set(project, target);
  }
  static getTargetForProject(project) {
    return projectToTargetMap.get(project) || null;
  }
  static framesForUISourceCode(uiSourceCode) {
    const target = _NetworkProject.targetForUISourceCode(uiSourceCode);
    const resourceTreeModel = target?.model(SDK2.ResourceTreeModel.ResourceTreeModel);
    const attribution = uiSourceCodeToAttributionMap.get(uiSourceCode);
    if (!resourceTreeModel || !attribution) {
      return [];
    }
    const frames = Array.from(attribution.keys()).map((frameId) => resourceTreeModel.frameForId(frameId));
    return frames.filter((frame) => !!frame);
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/CompilerScriptMapping.js
var CompilerScriptMapping = class {
  #sourceMapManager;
  #debuggerWorkspaceBinding;
  #stubUISourceCodes = /* @__PURE__ */ new Map();
  #stubProject;
  #eventListeners;
  #projects = /* @__PURE__ */ new Map();
  #sourceMapToProject = /* @__PURE__ */ new Map();
  #uiSourceCodeToSourceMaps = new Platform2.MapUtilities.Multimap();
  #debuggerModel;
  constructor(debuggerModel, workspace, debuggerWorkspaceBinding) {
    this.#sourceMapManager = debuggerModel.sourceMapManager();
    this.#debuggerWorkspaceBinding = debuggerWorkspaceBinding;
    this.#debuggerModel = debuggerModel;
    this.#stubProject = new ContentProviderBasedProject(
      workspace,
      "jsSourceMaps:stub:" + debuggerModel.target().id(),
      Workspace3.Workspace.projectTypes.Service,
      "",
      true
      /* isServiceProject */
    );
    this.#eventListeners = [
      this.#sourceMapManager.addEventListener(
        SDK3.SourceMapManager.Events.SourceMapWillAttach,
        this.sourceMapWillAttach,
        this
      ),
      this.#sourceMapManager.addEventListener(
        SDK3.SourceMapManager.Events.SourceMapFailedToAttach,
        this.sourceMapFailedToAttach,
        this
      ),
      this.#sourceMapManager.addEventListener(
        SDK3.SourceMapManager.Events.SourceMapAttached,
        this.sourceMapAttached,
        this
      ),
      this.#sourceMapManager.addEventListener(
        SDK3.SourceMapManager.Events.SourceMapDetached,
        this.sourceMapDetached,
        this
      )
    ];
  }
  setFunctionRanges(uiSourceCode, ranges) {
    for (const sourceMap of this.#uiSourceCodeToSourceMaps.get(uiSourceCode)) {
      sourceMap.augmentWithScopes(uiSourceCode.url(), ranges);
    }
  }
  addStubUISourceCode(script) {
    const stubUISourceCode = this.#stubProject.addContentProvider(
      Common3.ParsedURL.ParsedURL.concatenate(script.sourceURL, ":sourcemap"),
      TextUtils2.StaticContentProvider.StaticContentProvider.fromString(
        script.sourceURL,
        Common3.ResourceType.resourceTypes.Script,
        "\n\n\n\n\n// Please wait a bit.\n// Compiled script is not shown while source map is being loaded!"
      ),
      "text/javascript"
    );
    this.#stubUISourceCodes.set(script, stubUISourceCode);
  }
  removeStubUISourceCode(script) {
    const uiSourceCode = this.#stubUISourceCodes.get(script);
    this.#stubUISourceCodes.delete(script);
    if (uiSourceCode) {
      this.#stubProject.removeUISourceCode(uiSourceCode.url());
    }
  }
  getLocationRangesForSameSourceLocation(rawLocation) {
    const debuggerModel = rawLocation.debuggerModel;
    const script = rawLocation.script();
    if (!script) {
      return [];
    }
    const sourceMap = this.#sourceMapManager.sourceMapForClient(script);
    if (!sourceMap) {
      return [];
    }
    const { lineNumber, columnNumber } = script.rawLocationToRelativeLocation(rawLocation);
    const entry = sourceMap.findEntry(lineNumber, columnNumber);
    if (!entry?.sourceURL) {
      return [];
    }
    const project = this.#sourceMapToProject.get(sourceMap);
    if (!project) {
      return [];
    }
    const uiSourceCode = project.uiSourceCodeForURL(entry.sourceURL);
    if (!uiSourceCode) {
      return [];
    }
    if (!this.#uiSourceCodeToSourceMaps.hasValue(uiSourceCode, sourceMap)) {
      return [];
    }
    const ranges = sourceMap.findReverseRanges(entry.sourceURL, entry.sourceLineNumber, entry.sourceColumnNumber);
    return ranges.map(({ startLine, startColumn, endLine, endColumn }) => {
      const start = script.relativeLocationToRawLocation({ lineNumber: startLine, columnNumber: startColumn });
      const end = script.relativeLocationToRawLocation({ lineNumber: endLine, columnNumber: endColumn });
      return {
        start: debuggerModel.createRawLocation(script, start.lineNumber, start.columnNumber),
        end: debuggerModel.createRawLocation(script, end.lineNumber, end.columnNumber)
      };
    });
  }
  uiSourceCodeForURL(url, isContentScript) {
    const projectType = isContentScript ? Workspace3.Workspace.projectTypes.ContentScripts : Workspace3.Workspace.projectTypes.Network;
    for (const project of this.#projects.values()) {
      if (project.type() !== projectType) {
        continue;
      }
      const uiSourceCode = project.uiSourceCodeForURL(url);
      if (uiSourceCode) {
        return uiSourceCode;
      }
    }
    return null;
  }
  /**
   * Resolves the source-mapped entity mapped from the given `rawLocation` if any. If the `rawLocation`
   * does not point into a script with a source map, `null` is returned from here, while if the source
   * map for the script is currently being loaded, a stub `UISourceCode` is returned meanwhile. Otherwise,
   * if the script has a source map entry for the position identified by the `rawLocation`, this method
   * will compute the location in the source-mapped file by a reverse lookup on the source map.
   *
   * If `rawLocation` points to a script with a source map managed by this `CompilerScriptMapping`, which
   * is stale (because it was overridden by a more recent mapping), `null` will be returned.
   *
   * @param rawLocation script location.
   * @returns the {@link Workspace.UISourceCode.UILocation} for the `rawLocation` if any.
   */
  rawLocationToUILocation(rawLocation) {
    const script = rawLocation.script();
    if (!script) {
      return null;
    }
    const { lineNumber, columnNumber } = script.rawLocationToRelativeLocation(rawLocation);
    const stubUISourceCode = this.#stubUISourceCodes.get(script);
    if (stubUISourceCode) {
      return new Workspace3.UISourceCode.UILocation(stubUISourceCode, lineNumber, columnNumber);
    }
    const sourceMap = this.#sourceMapManager.sourceMapForClient(script);
    if (!sourceMap) {
      return null;
    }
    const project = this.#sourceMapToProject.get(sourceMap);
    if (!project) {
      return null;
    }
    const entry = sourceMap.findEntry(lineNumber, columnNumber, rawLocation.inlineFrameIndex);
    if (!entry?.sourceURL) {
      return null;
    }
    const uiSourceCode = project.uiSourceCodeForURL(entry.sourceURL);
    if (!uiSourceCode) {
      return null;
    }
    if (!this.#uiSourceCodeToSourceMaps.hasValue(uiSourceCode, sourceMap)) {
      return null;
    }
    return uiSourceCode.uiLocation(entry.sourceLineNumber, entry.sourceColumnNumber);
  }
  /**
   * Resolves a location within a source mapped entity managed by the `CompilerScriptMapping`
   * to its script locations. If the `uiSourceCode` does not belong to this mapping or if its
   * mapping is stale, an empty list will be returned.
   *
   * A single UI location can map to multiple different {@link SDK.DebuggerModel.RawLocation}s,
   * and these raw locations don't even need to belong to the same script (e.g. multiple bundles
   * can reference the same shared source file in case of code splitting, and locations within
   * this shared source file will then resolve to locations in all the bundles).
   *
   * @param uiSourceCode the source mapped entity.
   * @param lineNumber the line number in terms of the {@link uiSourceCode}.
   * @param columnNumber the column number in terms of the {@link uiSourceCode}.
   * @returns a list of raw locations that correspond to the UI location.
   */
  uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber) {
    const locations = [];
    for (const sourceMap of this.#uiSourceCodeToSourceMaps.get(uiSourceCode)) {
      const entry = sourceMap.sourceLineMapping(uiSourceCode.url(), lineNumber, columnNumber);
      if (!entry) {
        continue;
      }
      const script = this.#sourceMapManager.clientForSourceMap(sourceMap);
      if (!script) {
        continue;
      }
      const location = script.relativeLocationToRawLocation(entry);
      locations.push(script.debuggerModel.createRawLocation(script, location.lineNumber, location.columnNumber));
    }
    return locations;
  }
  uiLocationRangeToRawLocationRanges(uiSourceCode, textRange) {
    if (!this.#uiSourceCodeToSourceMaps.has(uiSourceCode)) {
      return null;
    }
    const ranges = [];
    for (const sourceMap of this.#uiSourceCodeToSourceMaps.get(uiSourceCode)) {
      const script = this.#sourceMapManager.clientForSourceMap(sourceMap);
      if (!script) {
        continue;
      }
      for (const scriptTextRange of sourceMap.reverseMapTextRanges(uiSourceCode.url(), textRange)) {
        const startLocation = script.relativeLocationToRawLocation(scriptTextRange.start);
        const endLocation = script.relativeLocationToRawLocation(scriptTextRange.end);
        const start = script.debuggerModel.createRawLocation(script, startLocation.lineNumber, startLocation.columnNumber);
        const end = script.debuggerModel.createRawLocation(script, endLocation.lineNumber, endLocation.columnNumber);
        ranges.push({ start, end });
      }
    }
    return ranges;
  }
  translateRawFramesStep(rawFrames, translatedFrames) {
    const frame = rawFrames[0];
    if (Trie_exports.isBuiltinFrame(frame)) {
      return false;
    }
    const sourceMapWithScopeInfoForFrame = (rawFrame) => {
      const script2 = this.#debuggerModel.scriptForId(rawFrame.scriptId ?? "");
      if (!script2 || this.#stubUISourceCodes.has(script2)) {
        return null;
      }
      const sourceMap2 = script2.sourceMap();
      return sourceMap2?.hasScopeInfo() ? { sourceMap: sourceMap2, script: script2 } : null;
    };
    const sourceMapAndScript = sourceMapWithScopeInfoForFrame(frame);
    if (!sourceMapAndScript) {
      return false;
    }
    const { sourceMap, script } = sourceMapAndScript;
    const { lineNumber, columnNumber } = script.relativeLocationToRawLocation(frame);
    if (!sourceMap.isOutlinedFrame(lineNumber, columnNumber)) {
      const frames = sourceMap.translateCallSite(lineNumber, columnNumber);
      if (!frames.length) {
        return false;
      }
      rawFrames.shift();
      const result = [];
      translatedFrames.push(result);
      const project = this.#sourceMapToProject.get(sourceMap);
      for (const frame2 of frames) {
        const uiSourceCode = frame2.url ? project?.uiSourceCodeForURL(frame2.url) : void 0;
        result.push({
          ...frame2,
          url: uiSourceCode ? void 0 : frame2.url,
          uiSourceCode: uiSourceCode ?? void 0
        });
      }
      return true;
    }
    return false;
  }
  /**
   * Computes the set of line numbers which are source-mapped to a script within the
   * given {@link uiSourceCode}.
   *
   * @param uiSourceCode the source mapped entity.
   * @returns a set of source-mapped line numbers or `null` if the {@link uiSourceCode}
   *         is not provided by this {@link CompilerScriptMapping} instance.
   */
  getMappedLines(uiSourceCode) {
    if (!this.#uiSourceCodeToSourceMaps.has(uiSourceCode)) {
      return null;
    }
    const mappedLines = /* @__PURE__ */ new Set();
    for (const sourceMap of this.#uiSourceCodeToSourceMaps.get(uiSourceCode)) {
      for (const entry of sourceMap.mappings()) {
        if (entry.sourceURL !== uiSourceCode.url()) {
          continue;
        }
        mappedLines.add(entry.sourceLineNumber);
      }
    }
    return mappedLines;
  }
  /**
   * Invoked by the {@link SDK.SourceMapManager.SourceMapManager} whenever it starts loading the
   * source map for a given {@link SDK.Script.Script}. The `CompilerScriptMapping` will set up a
   * {@link Workspace.UISourceCode.UISourceCode} stub for the time that the source map is being
   * loaded to avoid showing the generated code when the DevTools front-end is stopped early (for
   * example on a breakpoint).
   *
   * @param event holds the {@link SDK.Script.Script} whose source map is being loaded.
   */
  sourceMapWillAttach(event) {
    const { client: script } = event.data;
    this.addStubUISourceCode(script);
    void this.#debuggerWorkspaceBinding.updateLocations(script);
    if (Workspace3.IgnoreListManager.IgnoreListManager.instance().isUserIgnoreListedURL(
      script.sourceURL,
      { isContentScript: script.isContentScript() }
    )) {
      this.#sourceMapManager.cancelAttachSourceMap(script);
    }
  }
  /**
   * Invoked by the {@link SDK.SourceMapManager.SourceMapManager} after an attempt to load the
   * source map for a given {@link SDK.Script.Script} failed. The `CompilerScriptMapping` will
   * remove the {@link Workspace.UISourceCode.UISourceCode} stub, and from this time on won't
   * report any mappings for the `client` script.
   *
   * @param event holds the {@link SDK.Script.Script} whose source map failed to load.
   */
  sourceMapFailedToAttach(event) {
    const { client: script } = event.data;
    this.removeStubUISourceCode(script);
    void this.#debuggerWorkspaceBinding.updateLocations(script);
  }
  /**
   * Invoked by the {@link SDK.SourceMapManager.SourceMapManager} after an attempt to load the
   * source map for a given {@link SDK.Script.Script} succeeded. The `CompilerScriptMapping` will
   * now create {@link Workspace.UISourceCode.UISourceCode}s for all the sources mentioned in the
   * `sourceMap`.
   *
   * In case of a conflict this method creates a new {@link Workspace.UISourceCode.UISourceCode}
   * and copies over all the mappings from the other source maps that were registered for the
   * same URL and which are compatible (agree on the content and ignore-list hint for the given
   * URL). If they are considered incompatible, the original `UISourceCode` will simply be
   * removed and a new mapping will be established.
   *
   * @param event holds the {@link SDK.Script.Script} and its {@link SDK.SourceMap.SourceMap}.
   */
  sourceMapAttached(event) {
    const { client: script, sourceMap } = event.data;
    const scripts = /* @__PURE__ */ new Set([script]);
    this.removeStubUISourceCode(script);
    const target = script.target();
    const projectId = `jsSourceMaps:${script.isContentScript() ? "extensions" : ""}:${target.id()}`;
    let project = this.#projects.get(projectId);
    if (!project) {
      const projectType = script.isContentScript() ? Workspace3.Workspace.projectTypes.ContentScripts : Workspace3.Workspace.projectTypes.Network;
      project = new ContentProviderBasedProject(
        this.#stubProject.workspace(),
        projectId,
        projectType,
        /* displayName */
        "",
        /* isServiceProject */
        false
      );
      NetworkProject.setTargetForProject(project, target);
      this.#projects.set(projectId, project);
    }
    this.#sourceMapToProject.set(sourceMap, project);
    for (const url of sourceMap.sourceURLs()) {
      const contentType = Common3.ResourceType.resourceTypes.SourceMapScript;
      const uiSourceCode = project.createUISourceCode(url, contentType);
      if (sourceMap.hasIgnoreListHint(url)) {
        uiSourceCode.markKnownThirdParty();
      }
      const content = sourceMap.embeddedContentByURL(url);
      const contentProvider = content !== null ? TextUtils2.StaticContentProvider.StaticContentProvider.fromString(url, contentType, content) : new SDK3.CompilerSourceMappingContentProvider.CompilerSourceMappingContentProvider(
        url,
        contentType,
        script.createPageResourceLoadInitiator()
      );
      let metadata = null;
      if (content !== null) {
        const encoder = new TextEncoder();
        metadata = new Workspace3.UISourceCode.UISourceCodeMetadata(null, encoder.encode(content).length);
      }
      const mimeType = Common3.ResourceType.ResourceType.mimeFromURL(url) ?? contentType.canonicalMimeType();
      this.#uiSourceCodeToSourceMaps.set(uiSourceCode, sourceMap);
      NetworkProject.setInitialFrameAttribution(uiSourceCode, script.frameId);
      const otherUISourceCode = project.uiSourceCodeForURL(url);
      if (otherUISourceCode !== null) {
        for (const otherSourceMap of this.#uiSourceCodeToSourceMaps.get(otherUISourceCode)) {
          this.#uiSourceCodeToSourceMaps.delete(otherUISourceCode, otherSourceMap);
          const otherScript = this.#sourceMapManager.clientForSourceMap(otherSourceMap);
          if (!otherScript) {
            continue;
          }
          NetworkProject.removeFrameAttribution(otherUISourceCode, otherScript.frameId);
          if (sourceMap.compatibleForURL(url, otherSourceMap)) {
            this.#uiSourceCodeToSourceMaps.set(uiSourceCode, otherSourceMap);
            NetworkProject.addFrameAttribution(uiSourceCode, otherScript.frameId);
          }
          scripts.add(otherScript);
        }
        project.removeUISourceCode(url);
      }
      project.addUISourceCodeWithProvider(uiSourceCode, contentProvider, metadata, mimeType);
    }
    void Promise.all([...scripts].map((script2) => this.#debuggerWorkspaceBinding.updateLocations(script2))).then(() => this.sourceMapAttachedForTest(sourceMap));
  }
  /**
   * Invoked by the {@link SDK.SourceMapManager.SourceMapManager} when the source map for a given
   * {@link SDK.Script.Script} is removed, which could be either because the target is execution
   * context was destroyed, or the user manually asked to replace the source map for a given
   * script.
   *
   * @param event holds the {@link SDK.Script.Script} and {@link SDK.SourceMap.SourceMap} that
   *              should be detached.
   */
  sourceMapDetached(event) {
    const { client: script, sourceMap } = event.data;
    const project = this.#sourceMapToProject.get(sourceMap);
    if (!project) {
      return;
    }
    for (const uiSourceCode of project.uiSourceCodes()) {
      if (this.#uiSourceCodeToSourceMaps.delete(uiSourceCode, sourceMap)) {
        NetworkProject.removeFrameAttribution(uiSourceCode, script.frameId);
        if (!this.#uiSourceCodeToSourceMaps.has(uiSourceCode)) {
          project.removeUISourceCode(uiSourceCode.url());
        }
      }
    }
    this.#sourceMapToProject.delete(sourceMap);
    void this.#debuggerWorkspaceBinding.updateLocations(script);
  }
  scriptsForUISourceCode(uiSourceCode) {
    const scripts = [];
    for (const sourceMap of this.#uiSourceCodeToSourceMaps.get(uiSourceCode)) {
      const script = this.#sourceMapManager.clientForSourceMap(sourceMap);
      if (script) {
        scripts.push(script);
      }
    }
    return scripts;
  }
  sourceMapAttachedForTest(_sourceMap) {
  }
  dispose() {
    Common3.EventTarget.removeEventListeners(this.#eventListeners);
    for (const project of this.#projects.values()) {
      project.dispose();
    }
    this.#stubProject.dispose();
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/CSSWorkspaceBinding.js
var CSSWorkspaceBinding_exports = {};
__export(CSSWorkspaceBinding_exports, {
  CSSWorkspaceBinding: () => CSSWorkspaceBinding,
  LiveLocation: () => LiveLocation,
  ModelInfo: () => ModelInfo
});
import * as Common7 from "./../../core/common/common.js";
import * as Platform4 from "./../../core/platform/platform.js";
import * as SDK7 from "./../../core/sdk/sdk.js";

// gen/third_party/devtools-frontend/src/front_end/models/bindings/LiveLocation.js
var LiveLocation_exports = {};
__export(LiveLocation_exports, {
  LiveLocationPool: () => LiveLocationPool,
  LiveLocationWithPool: () => LiveLocationWithPool
});
var LiveLocationWithPool = class {
  #updateDelegate;
  #locationPool;
  #updatePromise;
  constructor(updateDelegate, locationPool) {
    this.#updateDelegate = updateDelegate;
    this.#locationPool = locationPool;
    this.#locationPool.add(this);
    this.#updatePromise = null;
  }
  async update() {
    if (!this.#updateDelegate) {
      return;
    }
    if (this.#updatePromise) {
      await this.#updatePromise.then(() => this.update());
    } else {
      this.#updatePromise = this.#updateDelegate(this);
      await this.#updatePromise;
      this.#updatePromise = null;
    }
  }
  async uiLocation() {
    throw new Error("Not implemented");
  }
  dispose() {
    this.#locationPool.delete(this);
    this.#updateDelegate = null;
  }
  isDisposed() {
    return !this.#locationPool.has(this);
  }
};
var LiveLocationPool = class {
  #locations;
  constructor() {
    this.#locations = /* @__PURE__ */ new Set();
  }
  add(location) {
    this.#locations.add(location);
  }
  delete(location) {
    this.#locations.delete(location);
  }
  has(location) {
    return this.#locations.has(location);
  }
  disposeAll() {
    for (const location of this.#locations) {
      location.dispose();
    }
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/SASSSourceMapping.js
var SASSSourceMapping_exports = {};
__export(SASSSourceMapping_exports, {
  SASSSourceMapping: () => SASSSourceMapping
});
import * as Common4 from "./../../core/common/common.js";
import * as SDK4 from "./../../core/sdk/sdk.js";
import * as TextUtils3 from "./../text_utils/text_utils.js";
import * as Workspace5 from "./../workspace/workspace.js";
var SASSSourceMapping = class {
  #sourceMapManager;
  #project;
  #eventListeners;
  #bindings;
  constructor(target, sourceMapManager, workspace) {
    this.#sourceMapManager = sourceMapManager;
    this.#project = new ContentProviderBasedProject(
      workspace,
      "cssSourceMaps:" + target.id(),
      Workspace5.Workspace.projectTypes.Network,
      "",
      false
      /* isServiceProject */
    );
    NetworkProject.setTargetForProject(this.#project, target);
    this.#bindings = /* @__PURE__ */ new Map();
    this.#eventListeners = [
      this.#sourceMapManager.addEventListener(
        SDK4.SourceMapManager.Events.SourceMapAttached,
        this.sourceMapAttached,
        this
      ),
      this.#sourceMapManager.addEventListener(
        SDK4.SourceMapManager.Events.SourceMapDetached,
        this.sourceMapDetached,
        this
      )
    ];
  }
  sourceMapAttachedForTest(_sourceMap) {
  }
  async sourceMapAttached(event) {
    const header = event.data.client;
    const sourceMap = event.data.sourceMap;
    const project = this.#project;
    const bindings = this.#bindings;
    for (const sourceURL of sourceMap.sourceURLs()) {
      let binding = bindings.get(sourceURL);
      if (!binding) {
        binding = new Binding(project, sourceURL, header.createPageResourceLoadInitiator());
        bindings.set(sourceURL, binding);
      }
      binding.addSourceMap(sourceMap, header.frameId);
    }
    await CSSWorkspaceBinding.instance().updateLocations(header);
    this.sourceMapAttachedForTest(sourceMap);
  }
  async sourceMapDetached(event) {
    const header = event.data.client;
    const sourceMap = event.data.sourceMap;
    const bindings = this.#bindings;
    for (const sourceURL of sourceMap.sourceURLs()) {
      const binding = bindings.get(sourceURL);
      if (binding) {
        binding.removeSourceMap(sourceMap, header.frameId);
        if (!binding.getUiSourceCode()) {
          bindings.delete(sourceURL);
        }
      }
    }
    await CSSWorkspaceBinding.instance().updateLocations(header);
  }
  rawLocationToUILocation(rawLocation) {
    const header = rawLocation.header();
    if (!header) {
      return null;
    }
    const sourceMap = this.#sourceMapManager.sourceMapForClient(header);
    if (!sourceMap) {
      return null;
    }
    let { lineNumber, columnNumber } = rawLocation;
    if (sourceMap.mapsOrigin() && header.isInline) {
      lineNumber -= header.startLine;
      if (lineNumber === 0) {
        columnNumber -= header.startColumn;
      }
    }
    const entry = sourceMap.findEntry(lineNumber, columnNumber);
    if (!entry?.sourceURL) {
      return null;
    }
    const uiSourceCode = this.#project.uiSourceCodeForURL(entry.sourceURL);
    if (!uiSourceCode) {
      return null;
    }
    return uiSourceCode.uiLocation(entry.sourceLineNumber, entry.sourceColumnNumber);
  }
  uiLocationToRawLocations(uiLocation) {
    const { uiSourceCode, lineNumber, columnNumber = 0 } = uiLocation;
    const binding = uiSourceCodeToBinding.get(uiSourceCode);
    if (!binding) {
      return [];
    }
    const locations = [];
    for (const sourceMap of binding.getReferringSourceMaps()) {
      const entries = sourceMap.findReverseEntries(uiSourceCode.url(), lineNumber, columnNumber);
      const header = this.#sourceMapManager.clientForSourceMap(sourceMap);
      if (header) {
        locations.push(
          ...entries.map((entry) => new SDK4.CSSModel.CSSLocation(header, entry.lineNumber, entry.columnNumber))
        );
      }
    }
    return locations;
  }
  static uiSourceOrigin(uiSourceCode) {
    const binding = uiSourceCodeToBinding.get(uiSourceCode);
    if (binding) {
      return binding.getReferringSourceMaps().map((sourceMap) => sourceMap.compiledURL());
    }
    return [];
  }
  dispose() {
    Common4.EventTarget.removeEventListeners(this.#eventListeners);
    this.#project.dispose();
  }
};
var uiSourceCodeToBinding = /* @__PURE__ */ new WeakMap();
var Binding = class {
  #project;
  #url;
  #initiator;
  referringSourceMaps;
  uiSourceCode;
  constructor(project, url, initiator) {
    this.#project = project;
    this.#url = url;
    this.#initiator = initiator;
    this.referringSourceMaps = [];
    this.uiSourceCode = null;
  }
  recreateUISourceCodeIfNeeded(frameId) {
    const sourceMap = this.referringSourceMaps[this.referringSourceMaps.length - 1];
    const contentType = Common4.ResourceType.resourceTypes.SourceMapStyleSheet;
    const embeddedContent = sourceMap.embeddedContentByURL(this.#url);
    const contentProvider = embeddedContent !== null ? TextUtils3.StaticContentProvider.StaticContentProvider.fromString(this.#url, contentType, embeddedContent) : new SDK4.CompilerSourceMappingContentProvider.CompilerSourceMappingContentProvider(
      this.#url,
      contentType,
      this.#initiator
    );
    const newUISourceCode = this.#project.createUISourceCode(this.#url, contentType);
    uiSourceCodeToBinding.set(newUISourceCode, this);
    const mimeType = Common4.ResourceType.ResourceType.mimeFromURL(this.#url) || contentType.canonicalMimeType();
    const metadata = typeof embeddedContent === "string" ? new Workspace5.UISourceCode.UISourceCodeMetadata(null, embeddedContent.length) : null;
    if (this.uiSourceCode) {
      NetworkProject.cloneInitialFrameAttribution(this.uiSourceCode, newUISourceCode);
      this.#project.removeUISourceCode(this.uiSourceCode.url());
    } else {
      NetworkProject.setInitialFrameAttribution(newUISourceCode, frameId);
    }
    this.uiSourceCode = newUISourceCode;
    this.#project.addUISourceCodeWithProvider(this.uiSourceCode, contentProvider, metadata, mimeType);
  }
  addSourceMap(sourceMap, frameId) {
    if (this.uiSourceCode) {
      NetworkProject.addFrameAttribution(this.uiSourceCode, frameId);
    }
    this.referringSourceMaps.push(sourceMap);
    this.recreateUISourceCodeIfNeeded(frameId);
  }
  removeSourceMap(sourceMap, frameId) {
    const uiSourceCode = this.uiSourceCode;
    NetworkProject.removeFrameAttribution(uiSourceCode, frameId);
    const lastIndex = this.referringSourceMaps.lastIndexOf(sourceMap);
    if (lastIndex !== -1) {
      this.referringSourceMaps.splice(lastIndex, 1);
    }
    if (!this.referringSourceMaps.length) {
      this.#project.removeUISourceCode(uiSourceCode.url());
      this.uiSourceCode = null;
    } else {
      this.recreateUISourceCodeIfNeeded(frameId);
    }
  }
  getReferringSourceMaps() {
    return this.referringSourceMaps;
  }
  getUiSourceCode() {
    return this.uiSourceCode;
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/StylesSourceMapping.js
var StylesSourceMapping_exports = {};
__export(StylesSourceMapping_exports, {
  StyleFile: () => StyleFile,
  StylesSourceMapping: () => StylesSourceMapping
});
import * as Common6 from "./../../core/common/common.js";
import * as SDK6 from "./../../core/sdk/sdk.js";
import * as TextUtils4 from "./../text_utils/text_utils.js";
import * as Workspace9 from "./../workspace/workspace.js";

// gen/third_party/devtools-frontend/src/front_end/models/bindings/ResourceUtils.js
var ResourceUtils_exports = {};
__export(ResourceUtils_exports, {
  displayNameForURL: () => displayNameForURL,
  metadataForURL: () => metadataForURL,
  resourceForURL: () => resourceForURL,
  resourceMetadata: () => resourceMetadata
});
import * as Common5 from "./../../core/common/common.js";
import * as Platform3 from "./../../core/platform/platform.js";
import * as SDK5 from "./../../core/sdk/sdk.js";
import * as Workspace7 from "./../workspace/workspace.js";
function resourceForURL(url) {
  return SDK5.ResourceTreeModel.ResourceTreeModel.resourceForURL(url);
}
function displayNameForURL(url) {
  if (!url) {
    return "";
  }
  const uiSourceCode = Workspace7.Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(url);
  if (uiSourceCode) {
    return uiSourceCode.displayName();
  }
  const resource = resourceForURL(url);
  if (resource) {
    return resource.displayName;
  }
  const inspectedURL = SDK5.TargetManager.TargetManager.instance().inspectedURL();
  if (!inspectedURL) {
    return Platform3.StringUtilities.trimURL(url, "");
  }
  const parsedURL = Common5.ParsedURL.ParsedURL.fromString(inspectedURL);
  if (!parsedURL) {
    return url;
  }
  const lastPathComponent = parsedURL.lastPathComponent;
  const index = inspectedURL.indexOf(lastPathComponent);
  if (index !== -1 && index + lastPathComponent.length === inspectedURL.length) {
    const baseURL = inspectedURL.substring(0, index);
    if (url.startsWith(baseURL) && url.length > index) {
      return url.substring(index);
    }
  }
  const displayName = Platform3.StringUtilities.trimURL(url, parsedURL.host);
  return displayName === "/" ? parsedURL.host + "/" : displayName;
}
function metadataForURL(target, frameId, url) {
  const resourceTreeModel = target.model(SDK5.ResourceTreeModel.ResourceTreeModel);
  if (!resourceTreeModel) {
    return null;
  }
  const frame = resourceTreeModel.frameForId(frameId);
  if (!frame) {
    return null;
  }
  return resourceMetadata(frame.resourceForURL(url));
}
function resourceMetadata(resource) {
  if (!resource || typeof resource.contentSize() !== "number" && !resource.lastModified()) {
    return null;
  }
  return new Workspace7.UISourceCode.UISourceCodeMetadata(resource.lastModified(), resource.contentSize());
}

// gen/third_party/devtools-frontend/src/front_end/models/bindings/StylesSourceMapping.js
var uiSourceCodeToStyleMap = /* @__PURE__ */ new WeakMap();
var StylesSourceMapping = class {
  #cssModel;
  #project;
  #styleFiles = /* @__PURE__ */ new Map();
  #eventListeners;
  constructor(cssModel, workspace) {
    this.#cssModel = cssModel;
    const target = this.#cssModel.target();
    this.#project = new ContentProviderBasedProject(
      workspace,
      "css:" + target.id(),
      Workspace9.Workspace.projectTypes.Network,
      "",
      false
      /* isServiceProject */
    );
    NetworkProject.setTargetForProject(this.#project, target);
    this.#eventListeners = [
      this.#cssModel.addEventListener(SDK6.CSSModel.Events.StyleSheetAdded, this.styleSheetAdded, this),
      this.#cssModel.addEventListener(SDK6.CSSModel.Events.StyleSheetRemoved, this.styleSheetRemoved, this),
      this.#cssModel.addEventListener(SDK6.CSSModel.Events.StyleSheetChanged, this.styleSheetChanged, this)
    ];
  }
  addSourceMap(sourceUrl, sourceMapUrl) {
    this.#styleFiles.get(sourceUrl)?.addSourceMap(sourceUrl, sourceMapUrl);
  }
  rawLocationToUILocation(rawLocation) {
    const header = rawLocation.header();
    if (!header || !this.acceptsHeader(header)) {
      return null;
    }
    const styleFile = this.#styleFiles.get(header.resourceURL());
    if (!styleFile) {
      return null;
    }
    let lineNumber = rawLocation.lineNumber;
    let columnNumber = rawLocation.columnNumber;
    if (header.isInline && header.hasSourceURL) {
      lineNumber -= header.lineNumberInSource(0);
      const headerColumnNumber = header.columnNumberInSource(lineNumber, 0);
      if (typeof headerColumnNumber === "undefined") {
        columnNumber = headerColumnNumber;
      } else {
        columnNumber -= headerColumnNumber;
      }
    }
    return styleFile.getUiSourceCode().uiLocation(lineNumber, columnNumber);
  }
  uiLocationToRawLocations(uiLocation) {
    const styleFile = uiSourceCodeToStyleMap.get(uiLocation.uiSourceCode);
    if (!styleFile) {
      return [];
    }
    const rawLocations = [];
    for (const header of styleFile.getHeaders()) {
      let lineNumber = uiLocation.lineNumber;
      let columnNumber = uiLocation.columnNumber;
      if (header.isInline && header.hasSourceURL) {
        columnNumber = header.columnNumberInSource(lineNumber, uiLocation.columnNumber || 0);
        lineNumber = header.lineNumberInSource(lineNumber);
      }
      rawLocations.push(new SDK6.CSSModel.CSSLocation(header, lineNumber, columnNumber));
    }
    return rawLocations;
  }
  acceptsHeader(header) {
    if (header.isConstructedByNew()) {
      return false;
    }
    if (header.isInline && !header.hasSourceURL && header.origin !== "inspector") {
      return false;
    }
    if (!header.resourceURL()) {
      return false;
    }
    return true;
  }
  styleSheetAdded(event) {
    const header = event.data;
    if (!this.acceptsHeader(header)) {
      return;
    }
    const url = header.resourceURL();
    let styleFile = this.#styleFiles.get(url);
    if (!styleFile) {
      styleFile = new StyleFile(this.#cssModel, this.#project, header);
      this.#styleFiles.set(url, styleFile);
    } else {
      styleFile.addHeader(header);
    }
  }
  styleSheetRemoved(event) {
    const header = event.data;
    if (!this.acceptsHeader(header)) {
      return;
    }
    const url = header.resourceURL();
    const styleFile = this.#styleFiles.get(url);
    if (styleFile) {
      if (styleFile.getHeaders().size === 1) {
        styleFile.dispose();
        this.#styleFiles.delete(url);
      } else {
        styleFile.removeHeader(header);
      }
    }
  }
  styleSheetChanged(event) {
    const header = this.#cssModel.styleSheetHeaderForId(event.data.styleSheetId);
    if (!header || !this.acceptsHeader(header)) {
      return;
    }
    const styleFile = this.#styleFiles.get(header.resourceURL());
    if (styleFile) {
      styleFile.styleSheetChanged(header);
    }
  }
  dispose() {
    for (const styleFile of this.#styleFiles.values()) {
      styleFile.dispose();
    }
    this.#styleFiles.clear();
    Common6.EventTarget.removeEventListeners(this.#eventListeners);
    this.#project.removeProject();
  }
};
var StyleFile = class {
  #cssModel;
  #project;
  headers;
  uiSourceCode;
  #eventListeners;
  #throttler = new Common6.Throttler.Throttler(200);
  #terminated = false;
  #isAddingRevision;
  #isUpdatingHeaders;
  constructor(cssModel, project, header) {
    this.#cssModel = cssModel;
    this.#project = project;
    this.headers = /* @__PURE__ */ new Set([header]);
    const target = cssModel.target();
    const url = header.resourceURL();
    const metadata = metadataForURL(target, header.frameId, url);
    this.uiSourceCode = this.#project.createUISourceCode(url, header.contentType());
    uiSourceCodeToStyleMap.set(this.uiSourceCode, this);
    NetworkProject.setInitialFrameAttribution(this.uiSourceCode, header.frameId);
    this.#project.addUISourceCodeWithProvider(this.uiSourceCode, this, metadata, "text/css");
    this.#eventListeners = [
      this.uiSourceCode.addEventListener(
        Workspace9.UISourceCode.Events.WorkingCopyChanged,
        this.workingCopyChanged,
        this
      ),
      this.uiSourceCode.addEventListener(
        Workspace9.UISourceCode.Events.WorkingCopyCommitted,
        this.workingCopyCommitted,
        this
      )
    ];
  }
  addHeader(header) {
    this.headers.add(header);
    NetworkProject.addFrameAttribution(this.uiSourceCode, header.frameId);
  }
  removeHeader(header) {
    this.headers.delete(header);
    NetworkProject.removeFrameAttribution(this.uiSourceCode, header.frameId);
  }
  styleSheetChanged(header) {
    console.assert(this.headers.has(header));
    if (this.#isUpdatingHeaders || !this.headers.has(header)) {
      return;
    }
    const mirrorContentBound = this.mirrorContent.bind(
      this,
      header,
      true
      /* majorChange */
    );
    void this.#throttler.schedule(mirrorContentBound, Common6.Throttler.Scheduling.DEFAULT);
  }
  workingCopyCommitted() {
    if (this.#isAddingRevision) {
      return;
    }
    const mirrorContentBound = this.mirrorContent.bind(
      this,
      this.uiSourceCode,
      true
      /* majorChange */
    );
    void this.#throttler.schedule(mirrorContentBound, Common6.Throttler.Scheduling.AS_SOON_AS_POSSIBLE);
  }
  workingCopyChanged() {
    if (this.#isAddingRevision) {
      return;
    }
    const mirrorContentBound = this.mirrorContent.bind(
      this,
      this.uiSourceCode,
      false
      /* majorChange */
    );
    void this.#throttler.schedule(mirrorContentBound, Common6.Throttler.Scheduling.DEFAULT);
  }
  async mirrorContent(fromProvider, majorChange) {
    if (this.#terminated) {
      this.styleFileSyncedForTest();
      return;
    }
    let newContent = null;
    if (fromProvider === this.uiSourceCode) {
      newContent = this.uiSourceCode.workingCopy();
    } else {
      newContent = TextUtils4.ContentData.ContentData.textOr(await fromProvider.requestContentData(), null);
    }
    if (newContent === null || this.#terminated) {
      this.styleFileSyncedForTest();
      return;
    }
    if (fromProvider !== this.uiSourceCode) {
      this.#isAddingRevision = true;
      this.uiSourceCode.setWorkingCopy(newContent);
      this.#isAddingRevision = false;
    }
    this.#isUpdatingHeaders = true;
    const promises = [];
    for (const header of this.headers) {
      if (header === fromProvider) {
        continue;
      }
      promises.push(this.#cssModel.setStyleSheetText(header.id, newContent, majorChange));
    }
    await Promise.all(promises);
    this.#isUpdatingHeaders = false;
    this.styleFileSyncedForTest();
  }
  styleFileSyncedForTest() {
  }
  dispose() {
    if (this.#terminated) {
      return;
    }
    this.#terminated = true;
    this.#project.removeUISourceCode(this.uiSourceCode.url());
    Common6.EventTarget.removeEventListeners(this.#eventListeners);
  }
  contentURL() {
    console.assert(this.headers.size > 0);
    return this.#firstHeader().originalContentProvider().contentURL();
  }
  contentType() {
    console.assert(this.headers.size > 0);
    return this.#firstHeader().originalContentProvider().contentType();
  }
  requestContentData() {
    console.assert(this.headers.size > 0);
    return this.#firstHeader().originalContentProvider().requestContentData();
  }
  searchInContent(query, caseSensitive, isRegex) {
    console.assert(this.headers.size > 0);
    return this.#firstHeader().originalContentProvider().searchInContent(query, caseSensitive, isRegex);
  }
  #firstHeader() {
    console.assert(this.headers.size > 0);
    return this.headers.values().next().value;
  }
  getHeaders() {
    return this.headers;
  }
  getUiSourceCode() {
    return this.uiSourceCode;
  }
  addSourceMap(sourceUrl, sourceMapUrl) {
    const sourceMapManager = this.#cssModel.sourceMapManager();
    this.headers.forEach((header) => {
      sourceMapManager.detachSourceMap(header);
      sourceMapManager.attachSourceMap(header, sourceUrl, sourceMapUrl);
    });
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/CSSWorkspaceBinding.js
var cssWorkspaceBindingInstance;
var CSSWorkspaceBinding = class _CSSWorkspaceBinding {
  #resourceMapping;
  #modelToInfo;
  #liveLocationPromises;
  constructor(resourceMapping, targetManager) {
    this.#resourceMapping = resourceMapping;
    this.#modelToInfo = /* @__PURE__ */ new Map();
    targetManager.observeModels(SDK7.CSSModel.CSSModel, this);
    this.#liveLocationPromises = /* @__PURE__ */ new Set();
  }
  static instance(opts = { forceNew: null, resourceMapping: null, targetManager: null }) {
    const { forceNew, resourceMapping, targetManager } = opts;
    if (!cssWorkspaceBindingInstance || forceNew) {
      if (!resourceMapping || !targetManager) {
        throw new Error(`Unable to create CSSWorkspaceBinding: resourceMapping and targetManager must be provided: ${new Error().stack}`);
      }
      cssWorkspaceBindingInstance = new _CSSWorkspaceBinding(resourceMapping, targetManager);
    }
    return cssWorkspaceBindingInstance;
  }
  static removeInstance() {
    cssWorkspaceBindingInstance = void 0;
  }
  get modelToInfo() {
    return this.#modelToInfo;
  }
  getCSSModelInfo(cssModel) {
    return this.#modelToInfo.get(cssModel);
  }
  modelAdded(cssModel) {
    this.#modelToInfo.set(cssModel, new ModelInfo(cssModel, this.#resourceMapping));
  }
  modelRemoved(cssModel) {
    this.getCSSModelInfo(cssModel).dispose();
    this.#modelToInfo.delete(cssModel);
  }
  /**
   * The promise returned by this function is resolved once all *currently*
   * pending LiveLocations are processed.
   */
  async pendingLiveLocationChangesPromise() {
    await Promise.all(this.#liveLocationPromises);
  }
  recordLiveLocationChange(promise) {
    void promise.then(() => {
      this.#liveLocationPromises.delete(promise);
    });
    this.#liveLocationPromises.add(promise);
  }
  async updateLocations(header) {
    const updatePromise = this.getCSSModelInfo(header.cssModel()).updateLocations(header);
    this.recordLiveLocationChange(updatePromise);
    await updatePromise;
  }
  createLiveLocation(rawLocation, updateDelegate, locationPool) {
    const locationPromise = this.getCSSModelInfo(rawLocation.cssModel()).createLiveLocation(rawLocation, updateDelegate, locationPool);
    this.recordLiveLocationChange(locationPromise);
    return locationPromise;
  }
  propertyRawLocation(cssProperty, forName) {
    const style = cssProperty.ownerStyle;
    if (!style || style.type !== SDK7.CSSStyleDeclaration.Type.Regular || !style.styleSheetId) {
      return null;
    }
    const header = style.cssModel().styleSheetHeaderForId(style.styleSheetId);
    if (!header) {
      return null;
    }
    const range = forName ? cssProperty.nameRange() : cssProperty.valueRange();
    if (!range) {
      return null;
    }
    const lineNumber = range.startLine;
    const columnNumber = range.startColumn;
    return new SDK7.CSSModel.CSSLocation(
      header,
      header.lineNumberInSource(lineNumber),
      header.columnNumberInSource(lineNumber, columnNumber)
    );
  }
  propertyUILocation(cssProperty, forName) {
    const rawLocation = this.propertyRawLocation(cssProperty, forName);
    if (!rawLocation) {
      return null;
    }
    return this.rawLocationToUILocation(rawLocation);
  }
  rawLocationToUILocation(rawLocation) {
    return this.getCSSModelInfo(rawLocation.cssModel()).rawLocationToUILocation(rawLocation);
  }
  uiLocationToRawLocations(uiLocation) {
    const rawLocations = [];
    for (const modelInfo of this.#modelToInfo.values()) {
      rawLocations.push(...modelInfo.uiLocationToRawLocations(uiLocation));
    }
    return rawLocations;
  }
};
var ModelInfo = class {
  #eventListeners;
  #resourceMapping;
  #stylesSourceMapping;
  #sassSourceMapping;
  #locations;
  #unboundLocations;
  constructor(cssModel, resourceMapping) {
    this.#eventListeners = [
      cssModel.addEventListener(
        SDK7.CSSModel.Events.StyleSheetAdded,
        (event) => {
          void this.styleSheetAdded(event);
        },
        this
      ),
      cssModel.addEventListener(
        SDK7.CSSModel.Events.StyleSheetRemoved,
        (event) => {
          void this.styleSheetRemoved(event);
        },
        this
      )
    ];
    this.#resourceMapping = resourceMapping;
    this.#stylesSourceMapping = new StylesSourceMapping(cssModel, resourceMapping.workspace);
    const sourceMapManager = cssModel.sourceMapManager();
    this.#sassSourceMapping = new SASSSourceMapping(cssModel.target(), sourceMapManager, resourceMapping.workspace);
    this.#locations = new Platform4.MapUtilities.Multimap();
    this.#unboundLocations = new Platform4.MapUtilities.Multimap();
  }
  get locations() {
    return this.#locations;
  }
  async createLiveLocation(rawLocation, updateDelegate, locationPool) {
    const location = new LiveLocation(rawLocation, this, updateDelegate, locationPool);
    const header = rawLocation.header();
    if (header) {
      location.setHeader(header);
      this.#locations.set(header, location);
      await location.update();
    } else {
      this.#unboundLocations.set(rawLocation.url, location);
    }
    return location;
  }
  disposeLocation(location) {
    const header = location.header();
    if (header) {
      this.#locations.delete(header, location);
    } else {
      this.#unboundLocations.delete(location.url, location);
    }
  }
  updateLocations(header) {
    const promises = [];
    for (const location of this.#locations.get(header)) {
      promises.push(location.update());
    }
    return Promise.all(promises);
  }
  async styleSheetAdded(event) {
    const header = event.data;
    if (!header.sourceURL) {
      return;
    }
    const promises = [];
    for (const location of this.#unboundLocations.get(header.sourceURL)) {
      location.setHeader(header);
      this.#locations.set(header, location);
      promises.push(location.update());
    }
    await Promise.all(promises);
    this.#unboundLocations.deleteAll(header.sourceURL);
  }
  async styleSheetRemoved(event) {
    const header = event.data;
    const promises = [];
    for (const location of this.#locations.get(header)) {
      location.setHeader(header);
      this.#unboundLocations.set(location.url, location);
      promises.push(location.update());
    }
    await Promise.all(promises);
    this.#locations.deleteAll(header);
  }
  addSourceMap(sourceUrl, sourceMapUrl) {
    this.#stylesSourceMapping.addSourceMap(sourceUrl, sourceMapUrl);
  }
  rawLocationToUILocation(rawLocation) {
    let uiLocation = null;
    uiLocation = uiLocation || this.#sassSourceMapping.rawLocationToUILocation(rawLocation);
    uiLocation = uiLocation || this.#stylesSourceMapping.rawLocationToUILocation(rawLocation);
    uiLocation = uiLocation || this.#resourceMapping.cssLocationToUILocation(rawLocation);
    return uiLocation;
  }
  uiLocationToRawLocations(uiLocation) {
    let rawLocations = this.#sassSourceMapping.uiLocationToRawLocations(uiLocation);
    if (rawLocations.length) {
      return rawLocations;
    }
    rawLocations = this.#stylesSourceMapping.uiLocationToRawLocations(uiLocation);
    if (rawLocations.length) {
      return rawLocations;
    }
    return this.#resourceMapping.uiLocationToCSSLocations(uiLocation);
  }
  dispose() {
    Common7.EventTarget.removeEventListeners(this.#eventListeners);
    this.#stylesSourceMapping.dispose();
    this.#sassSourceMapping.dispose();
  }
};
var LiveLocation = class extends LiveLocationWithPool {
  url;
  #lineNumber;
  #columnNumber;
  #info;
  #header;
  constructor(rawLocation, info, updateDelegate, locationPool) {
    super(updateDelegate, locationPool);
    this.url = rawLocation.url;
    this.#lineNumber = rawLocation.lineNumber;
    this.#columnNumber = rawLocation.columnNumber;
    this.#info = info;
    this.#header = null;
  }
  header() {
    return this.#header;
  }
  setHeader(header) {
    this.#header = header;
  }
  async uiLocation() {
    if (!this.#header) {
      return null;
    }
    const rawLocation = new SDK7.CSSModel.CSSLocation(this.#header, this.#lineNumber, this.#columnNumber);
    return CSSWorkspaceBinding.instance().rawLocationToUILocation(rawLocation);
  }
  dispose() {
    super.dispose();
    this.#info.disposeLocation(this);
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/DebuggerLanguagePlugins.js
var DebuggerLanguagePlugins_exports = {};
__export(DebuggerLanguagePlugins_exports, {
  DebuggerLanguagePluginManager: () => DebuggerLanguagePluginManager,
  ExtensionRemoteObject: () => ExtensionRemoteObject,
  SourceScope: () => SourceScope
});
import * as Common8 from "./../../core/common/common.js";
import * as i18n3 from "./../../core/i18n/i18n.js";
import { assertNotNullOrUndefined } from "./../../core/platform/platform.js";
import * as SDK8 from "./../../core/sdk/sdk.js";

// gen/third_party/devtools-frontend/src/front_end/generated/protocol.js
var Accessibility;
((Accessibility2) => {
  let AXValueType;
  ((AXValueType2) => {
    AXValueType2["Boolean"] = "boolean";
    AXValueType2["Tristate"] = "tristate";
    AXValueType2["BooleanOrUndefined"] = "booleanOrUndefined";
    AXValueType2["Idref"] = "idref";
    AXValueType2["IdrefList"] = "idrefList";
    AXValueType2["Integer"] = "integer";
    AXValueType2["Node"] = "node";
    AXValueType2["NodeList"] = "nodeList";
    AXValueType2["Number"] = "number";
    AXValueType2["String"] = "string";
    AXValueType2["ComputedString"] = "computedString";
    AXValueType2["Token"] = "token";
    AXValueType2["TokenList"] = "tokenList";
    AXValueType2["DomRelation"] = "domRelation";
    AXValueType2["Role"] = "role";
    AXValueType2["InternalRole"] = "internalRole";
    AXValueType2["ValueUndefined"] = "valueUndefined";
  })(AXValueType = Accessibility2.AXValueType || (Accessibility2.AXValueType = {}));
  let AXValueSourceType;
  ((AXValueSourceType2) => {
    AXValueSourceType2["Attribute"] = "attribute";
    AXValueSourceType2["Implicit"] = "implicit";
    AXValueSourceType2["Style"] = "style";
    AXValueSourceType2["Contents"] = "contents";
    AXValueSourceType2["Placeholder"] = "placeholder";
    AXValueSourceType2["RelatedElement"] = "relatedElement";
  })(AXValueSourceType = Accessibility2.AXValueSourceType || (Accessibility2.AXValueSourceType = {}));
  let AXValueNativeSourceType;
  ((AXValueNativeSourceType2) => {
    AXValueNativeSourceType2["Description"] = "description";
    AXValueNativeSourceType2["Figcaption"] = "figcaption";
    AXValueNativeSourceType2["Label"] = "label";
    AXValueNativeSourceType2["Labelfor"] = "labelfor";
    AXValueNativeSourceType2["Labelwrapped"] = "labelwrapped";
    AXValueNativeSourceType2["Legend"] = "legend";
    AXValueNativeSourceType2["Rubyannotation"] = "rubyannotation";
    AXValueNativeSourceType2["Tablecaption"] = "tablecaption";
    AXValueNativeSourceType2["Title"] = "title";
    AXValueNativeSourceType2["Other"] = "other";
  })(AXValueNativeSourceType = Accessibility2.AXValueNativeSourceType || (Accessibility2.AXValueNativeSourceType = {}));
  let AXPropertyName;
  ((AXPropertyName2) => {
    AXPropertyName2["Actions"] = "actions";
    AXPropertyName2["Busy"] = "busy";
    AXPropertyName2["Disabled"] = "disabled";
    AXPropertyName2["Editable"] = "editable";
    AXPropertyName2["Focusable"] = "focusable";
    AXPropertyName2["Focused"] = "focused";
    AXPropertyName2["Hidden"] = "hidden";
    AXPropertyName2["HiddenRoot"] = "hiddenRoot";
    AXPropertyName2["Invalid"] = "invalid";
    AXPropertyName2["Keyshortcuts"] = "keyshortcuts";
    AXPropertyName2["Settable"] = "settable";
    AXPropertyName2["Roledescription"] = "roledescription";
    AXPropertyName2["Live"] = "live";
    AXPropertyName2["Atomic"] = "atomic";
    AXPropertyName2["Relevant"] = "relevant";
    AXPropertyName2["Root"] = "root";
    AXPropertyName2["Autocomplete"] = "autocomplete";
    AXPropertyName2["HasPopup"] = "hasPopup";
    AXPropertyName2["Level"] = "level";
    AXPropertyName2["Multiselectable"] = "multiselectable";
    AXPropertyName2["Orientation"] = "orientation";
    AXPropertyName2["Multiline"] = "multiline";
    AXPropertyName2["Readonly"] = "readonly";
    AXPropertyName2["Required"] = "required";
    AXPropertyName2["Valuemin"] = "valuemin";
    AXPropertyName2["Valuemax"] = "valuemax";
    AXPropertyName2["Valuetext"] = "valuetext";
    AXPropertyName2["Checked"] = "checked";
    AXPropertyName2["Expanded"] = "expanded";
    AXPropertyName2["Modal"] = "modal";
    AXPropertyName2["Pressed"] = "pressed";
    AXPropertyName2["Selected"] = "selected";
    AXPropertyName2["Activedescendant"] = "activedescendant";
    AXPropertyName2["Controls"] = "controls";
    AXPropertyName2["Describedby"] = "describedby";
    AXPropertyName2["Details"] = "details";
    AXPropertyName2["Errormessage"] = "errormessage";
    AXPropertyName2["Flowto"] = "flowto";
    AXPropertyName2["Labelledby"] = "labelledby";
    AXPropertyName2["Owns"] = "owns";
    AXPropertyName2["Url"] = "url";
    AXPropertyName2["ActiveFullscreenElement"] = "activeFullscreenElement";
    AXPropertyName2["ActiveModalDialog"] = "activeModalDialog";
    AXPropertyName2["ActiveAriaModalDialog"] = "activeAriaModalDialog";
    AXPropertyName2["AriaHiddenElement"] = "ariaHiddenElement";
    AXPropertyName2["AriaHiddenSubtree"] = "ariaHiddenSubtree";
    AXPropertyName2["EmptyAlt"] = "emptyAlt";
    AXPropertyName2["EmptyText"] = "emptyText";
    AXPropertyName2["InertElement"] = "inertElement";
    AXPropertyName2["InertSubtree"] = "inertSubtree";
    AXPropertyName2["LabelContainer"] = "labelContainer";
    AXPropertyName2["LabelFor"] = "labelFor";
    AXPropertyName2["NotRendered"] = "notRendered";
    AXPropertyName2["NotVisible"] = "notVisible";
    AXPropertyName2["PresentationalRole"] = "presentationalRole";
    AXPropertyName2["ProbablyPresentational"] = "probablyPresentational";
    AXPropertyName2["InactiveCarouselTabContent"] = "inactiveCarouselTabContent";
    AXPropertyName2["Uninteresting"] = "uninteresting";
  })(AXPropertyName = Accessibility2.AXPropertyName || (Accessibility2.AXPropertyName = {}));
})(Accessibility || (Accessibility = {}));
var Animation;
((Animation2) => {
  let AnimationType;
  ((AnimationType2) => {
    AnimationType2["CSSTransition"] = "CSSTransition";
    AnimationType2["CSSAnimation"] = "CSSAnimation";
    AnimationType2["WebAnimation"] = "WebAnimation";
  })(AnimationType = Animation2.AnimationType || (Animation2.AnimationType = {}));
})(Animation || (Animation = {}));
var Audits;
((Audits2) => {
  let CookieExclusionReason;
  ((CookieExclusionReason2) => {
    CookieExclusionReason2["ExcludeSameSiteUnspecifiedTreatedAsLax"] = "ExcludeSameSiteUnspecifiedTreatedAsLax";
    CookieExclusionReason2["ExcludeSameSiteNoneInsecure"] = "ExcludeSameSiteNoneInsecure";
    CookieExclusionReason2["ExcludeSameSiteLax"] = "ExcludeSameSiteLax";
    CookieExclusionReason2["ExcludeSameSiteStrict"] = "ExcludeSameSiteStrict";
    CookieExclusionReason2["ExcludeInvalidSameParty"] = "ExcludeInvalidSameParty";
    CookieExclusionReason2["ExcludeSamePartyCrossPartyContext"] = "ExcludeSamePartyCrossPartyContext";
    CookieExclusionReason2["ExcludeDomainNonASCII"] = "ExcludeDomainNonASCII";
    CookieExclusionReason2["ExcludeThirdPartyCookieBlockedInFirstPartySet"] = "ExcludeThirdPartyCookieBlockedInFirstPartySet";
    CookieExclusionReason2["ExcludeThirdPartyPhaseout"] = "ExcludeThirdPartyPhaseout";
    CookieExclusionReason2["ExcludePortMismatch"] = "ExcludePortMismatch";
    CookieExclusionReason2["ExcludeSchemeMismatch"] = "ExcludeSchemeMismatch";
  })(CookieExclusionReason = Audits2.CookieExclusionReason || (Audits2.CookieExclusionReason = {}));
  let CookieWarningReason;
  ((CookieWarningReason2) => {
    CookieWarningReason2["WarnSameSiteUnspecifiedCrossSiteContext"] = "WarnSameSiteUnspecifiedCrossSiteContext";
    CookieWarningReason2["WarnSameSiteNoneInsecure"] = "WarnSameSiteNoneInsecure";
    CookieWarningReason2["WarnSameSiteUnspecifiedLaxAllowUnsafe"] = "WarnSameSiteUnspecifiedLaxAllowUnsafe";
    CookieWarningReason2["WarnSameSiteStrictLaxDowngradeStrict"] = "WarnSameSiteStrictLaxDowngradeStrict";
    CookieWarningReason2["WarnSameSiteStrictCrossDowngradeStrict"] = "WarnSameSiteStrictCrossDowngradeStrict";
    CookieWarningReason2["WarnSameSiteStrictCrossDowngradeLax"] = "WarnSameSiteStrictCrossDowngradeLax";
    CookieWarningReason2["WarnSameSiteLaxCrossDowngradeStrict"] = "WarnSameSiteLaxCrossDowngradeStrict";
    CookieWarningReason2["WarnSameSiteLaxCrossDowngradeLax"] = "WarnSameSiteLaxCrossDowngradeLax";
    CookieWarningReason2["WarnAttributeValueExceedsMaxSize"] = "WarnAttributeValueExceedsMaxSize";
    CookieWarningReason2["WarnDomainNonASCII"] = "WarnDomainNonASCII";
    CookieWarningReason2["WarnThirdPartyPhaseout"] = "WarnThirdPartyPhaseout";
    CookieWarningReason2["WarnCrossSiteRedirectDowngradeChangesInclusion"] = "WarnCrossSiteRedirectDowngradeChangesInclusion";
    CookieWarningReason2["WarnDeprecationTrialMetadata"] = "WarnDeprecationTrialMetadata";
    CookieWarningReason2["WarnThirdPartyCookieHeuristic"] = "WarnThirdPartyCookieHeuristic";
  })(CookieWarningReason = Audits2.CookieWarningReason || (Audits2.CookieWarningReason = {}));
  let CookieOperation;
  ((CookieOperation2) => {
    CookieOperation2["SetCookie"] = "SetCookie";
    CookieOperation2["ReadCookie"] = "ReadCookie";
  })(CookieOperation = Audits2.CookieOperation || (Audits2.CookieOperation = {}));
  let InsightType;
  ((InsightType2) => {
    InsightType2["GitHubResource"] = "GitHubResource";
    InsightType2["GracePeriod"] = "GracePeriod";
    InsightType2["Heuristics"] = "Heuristics";
  })(InsightType = Audits2.InsightType || (Audits2.InsightType = {}));
  let MixedContentResolutionStatus;
  ((MixedContentResolutionStatus2) => {
    MixedContentResolutionStatus2["MixedContentBlocked"] = "MixedContentBlocked";
    MixedContentResolutionStatus2["MixedContentAutomaticallyUpgraded"] = "MixedContentAutomaticallyUpgraded";
    MixedContentResolutionStatus2["MixedContentWarning"] = "MixedContentWarning";
  })(MixedContentResolutionStatus = Audits2.MixedContentResolutionStatus || (Audits2.MixedContentResolutionStatus = {}));
  let MixedContentResourceType;
  ((MixedContentResourceType2) => {
    MixedContentResourceType2["AttributionSrc"] = "AttributionSrc";
    MixedContentResourceType2["Audio"] = "Audio";
    MixedContentResourceType2["Beacon"] = "Beacon";
    MixedContentResourceType2["CSPReport"] = "CSPReport";
    MixedContentResourceType2["Download"] = "Download";
    MixedContentResourceType2["EventSource"] = "EventSource";
    MixedContentResourceType2["Favicon"] = "Favicon";
    MixedContentResourceType2["Font"] = "Font";
    MixedContentResourceType2["Form"] = "Form";
    MixedContentResourceType2["Frame"] = "Frame";
    MixedContentResourceType2["Image"] = "Image";
    MixedContentResourceType2["Import"] = "Import";
    MixedContentResourceType2["JSON"] = "JSON";
    MixedContentResourceType2["Manifest"] = "Manifest";
    MixedContentResourceType2["Ping"] = "Ping";
    MixedContentResourceType2["PluginData"] = "PluginData";
    MixedContentResourceType2["PluginResource"] = "PluginResource";
    MixedContentResourceType2["Prefetch"] = "Prefetch";
    MixedContentResourceType2["Resource"] = "Resource";
    MixedContentResourceType2["Script"] = "Script";
    MixedContentResourceType2["ServiceWorker"] = "ServiceWorker";
    MixedContentResourceType2["SharedWorker"] = "SharedWorker";
    MixedContentResourceType2["SpeculationRules"] = "SpeculationRules";
    MixedContentResourceType2["Stylesheet"] = "Stylesheet";
    MixedContentResourceType2["Track"] = "Track";
    MixedContentResourceType2["Video"] = "Video";
    MixedContentResourceType2["Worker"] = "Worker";
    MixedContentResourceType2["XMLHttpRequest"] = "XMLHttpRequest";
    MixedContentResourceType2["XSLT"] = "XSLT";
  })(MixedContentResourceType = Audits2.MixedContentResourceType || (Audits2.MixedContentResourceType = {}));
  let BlockedByResponseReason;
  ((BlockedByResponseReason2) => {
    BlockedByResponseReason2["CoepFrameResourceNeedsCoepHeader"] = "CoepFrameResourceNeedsCoepHeader";
    BlockedByResponseReason2["CoopSandboxedIFrameCannotNavigateToCoopPage"] = "CoopSandboxedIFrameCannotNavigateToCoopPage";
    BlockedByResponseReason2["CorpNotSameOrigin"] = "CorpNotSameOrigin";
    BlockedByResponseReason2["CorpNotSameOriginAfterDefaultedToSameOriginByCoep"] = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep";
    BlockedByResponseReason2["CorpNotSameOriginAfterDefaultedToSameOriginByDip"] = "CorpNotSameOriginAfterDefaultedToSameOriginByDip";
    BlockedByResponseReason2["CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip"] = "CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip";
    BlockedByResponseReason2["CorpNotSameSite"] = "CorpNotSameSite";
    BlockedByResponseReason2["SRIMessageSignatureMismatch"] = "SRIMessageSignatureMismatch";
  })(BlockedByResponseReason = Audits2.BlockedByResponseReason || (Audits2.BlockedByResponseReason = {}));
  let HeavyAdResolutionStatus;
  ((HeavyAdResolutionStatus2) => {
    HeavyAdResolutionStatus2["HeavyAdBlocked"] = "HeavyAdBlocked";
    HeavyAdResolutionStatus2["HeavyAdWarning"] = "HeavyAdWarning";
  })(HeavyAdResolutionStatus = Audits2.HeavyAdResolutionStatus || (Audits2.HeavyAdResolutionStatus = {}));
  let HeavyAdReason;
  ((HeavyAdReason2) => {
    HeavyAdReason2["NetworkTotalLimit"] = "NetworkTotalLimit";
    HeavyAdReason2["CpuTotalLimit"] = "CpuTotalLimit";
    HeavyAdReason2["CpuPeakLimit"] = "CpuPeakLimit";
  })(HeavyAdReason = Audits2.HeavyAdReason || (Audits2.HeavyAdReason = {}));
  let ContentSecurityPolicyViolationType;
  ((ContentSecurityPolicyViolationType2) => {
    ContentSecurityPolicyViolationType2["KInlineViolation"] = "kInlineViolation";
    ContentSecurityPolicyViolationType2["KEvalViolation"] = "kEvalViolation";
    ContentSecurityPolicyViolationType2["KURLViolation"] = "kURLViolation";
    ContentSecurityPolicyViolationType2["KSRIViolation"] = "kSRIViolation";
    ContentSecurityPolicyViolationType2["KTrustedTypesSinkViolation"] = "kTrustedTypesSinkViolation";
    ContentSecurityPolicyViolationType2["KTrustedTypesPolicyViolation"] = "kTrustedTypesPolicyViolation";
    ContentSecurityPolicyViolationType2["KWasmEvalViolation"] = "kWasmEvalViolation";
  })(ContentSecurityPolicyViolationType = Audits2.ContentSecurityPolicyViolationType || (Audits2.ContentSecurityPolicyViolationType = {}));
  let SharedArrayBufferIssueType;
  ((SharedArrayBufferIssueType2) => {
    SharedArrayBufferIssueType2["TransferIssue"] = "TransferIssue";
    SharedArrayBufferIssueType2["CreationIssue"] = "CreationIssue";
  })(SharedArrayBufferIssueType = Audits2.SharedArrayBufferIssueType || (Audits2.SharedArrayBufferIssueType = {}));
  let AttributionReportingIssueType;
  ((AttributionReportingIssueType2) => {
    AttributionReportingIssueType2["PermissionPolicyDisabled"] = "PermissionPolicyDisabled";
    AttributionReportingIssueType2["UntrustworthyReportingOrigin"] = "UntrustworthyReportingOrigin";
    AttributionReportingIssueType2["InsecureContext"] = "InsecureContext";
    AttributionReportingIssueType2["InvalidHeader"] = "InvalidHeader";
    AttributionReportingIssueType2["InvalidRegisterTriggerHeader"] = "InvalidRegisterTriggerHeader";
    AttributionReportingIssueType2["SourceAndTriggerHeaders"] = "SourceAndTriggerHeaders";
    AttributionReportingIssueType2["SourceIgnored"] = "SourceIgnored";
    AttributionReportingIssueType2["TriggerIgnored"] = "TriggerIgnored";
    AttributionReportingIssueType2["OsSourceIgnored"] = "OsSourceIgnored";
    AttributionReportingIssueType2["OsTriggerIgnored"] = "OsTriggerIgnored";
    AttributionReportingIssueType2["InvalidRegisterOsSourceHeader"] = "InvalidRegisterOsSourceHeader";
    AttributionReportingIssueType2["InvalidRegisterOsTriggerHeader"] = "InvalidRegisterOsTriggerHeader";
    AttributionReportingIssueType2["WebAndOsHeaders"] = "WebAndOsHeaders";
    AttributionReportingIssueType2["NoWebOrOsSupport"] = "NoWebOrOsSupport";
    AttributionReportingIssueType2["NavigationRegistrationWithoutTransientUserActivation"] = "NavigationRegistrationWithoutTransientUserActivation";
    AttributionReportingIssueType2["InvalidInfoHeader"] = "InvalidInfoHeader";
    AttributionReportingIssueType2["NoRegisterSourceHeader"] = "NoRegisterSourceHeader";
    AttributionReportingIssueType2["NoRegisterTriggerHeader"] = "NoRegisterTriggerHeader";
    AttributionReportingIssueType2["NoRegisterOsSourceHeader"] = "NoRegisterOsSourceHeader";
    AttributionReportingIssueType2["NoRegisterOsTriggerHeader"] = "NoRegisterOsTriggerHeader";
    AttributionReportingIssueType2["NavigationRegistrationUniqueScopeAlreadySet"] = "NavigationRegistrationUniqueScopeAlreadySet";
  })(AttributionReportingIssueType = Audits2.AttributionReportingIssueType || (Audits2.AttributionReportingIssueType = {}));
  let SharedDictionaryError;
  ((SharedDictionaryError2) => {
    SharedDictionaryError2["UseErrorCrossOriginNoCorsRequest"] = "UseErrorCrossOriginNoCorsRequest";
    SharedDictionaryError2["UseErrorDictionaryLoadFailure"] = "UseErrorDictionaryLoadFailure";
    SharedDictionaryError2["UseErrorMatchingDictionaryNotUsed"] = "UseErrorMatchingDictionaryNotUsed";
    SharedDictionaryError2["UseErrorUnexpectedContentDictionaryHeader"] = "UseErrorUnexpectedContentDictionaryHeader";
    SharedDictionaryError2["WriteErrorCossOriginNoCorsRequest"] = "WriteErrorCossOriginNoCorsRequest";
    SharedDictionaryError2["WriteErrorDisallowedBySettings"] = "WriteErrorDisallowedBySettings";
    SharedDictionaryError2["WriteErrorExpiredResponse"] = "WriteErrorExpiredResponse";
    SharedDictionaryError2["WriteErrorFeatureDisabled"] = "WriteErrorFeatureDisabled";
    SharedDictionaryError2["WriteErrorInsufficientResources"] = "WriteErrorInsufficientResources";
    SharedDictionaryError2["WriteErrorInvalidMatchField"] = "WriteErrorInvalidMatchField";
    SharedDictionaryError2["WriteErrorInvalidStructuredHeader"] = "WriteErrorInvalidStructuredHeader";
    SharedDictionaryError2["WriteErrorInvalidTTLField"] = "WriteErrorInvalidTTLField";
    SharedDictionaryError2["WriteErrorNavigationRequest"] = "WriteErrorNavigationRequest";
    SharedDictionaryError2["WriteErrorNoMatchField"] = "WriteErrorNoMatchField";
    SharedDictionaryError2["WriteErrorNonIntegerTTLField"] = "WriteErrorNonIntegerTTLField";
    SharedDictionaryError2["WriteErrorNonListMatchDestField"] = "WriteErrorNonListMatchDestField";
    SharedDictionaryError2["WriteErrorNonSecureContext"] = "WriteErrorNonSecureContext";
    SharedDictionaryError2["WriteErrorNonStringIdField"] = "WriteErrorNonStringIdField";
    SharedDictionaryError2["WriteErrorNonStringInMatchDestList"] = "WriteErrorNonStringInMatchDestList";
    SharedDictionaryError2["WriteErrorNonStringMatchField"] = "WriteErrorNonStringMatchField";
    SharedDictionaryError2["WriteErrorNonTokenTypeField"] = "WriteErrorNonTokenTypeField";
    SharedDictionaryError2["WriteErrorRequestAborted"] = "WriteErrorRequestAborted";
    SharedDictionaryError2["WriteErrorShuttingDown"] = "WriteErrorShuttingDown";
    SharedDictionaryError2["WriteErrorTooLongIdField"] = "WriteErrorTooLongIdField";
    SharedDictionaryError2["WriteErrorUnsupportedType"] = "WriteErrorUnsupportedType";
  })(SharedDictionaryError = Audits2.SharedDictionaryError || (Audits2.SharedDictionaryError = {}));
  let SRIMessageSignatureError;
  ((SRIMessageSignatureError2) => {
    SRIMessageSignatureError2["MissingSignatureHeader"] = "MissingSignatureHeader";
    SRIMessageSignatureError2["MissingSignatureInputHeader"] = "MissingSignatureInputHeader";
    SRIMessageSignatureError2["InvalidSignatureHeader"] = "InvalidSignatureHeader";
    SRIMessageSignatureError2["InvalidSignatureInputHeader"] = "InvalidSignatureInputHeader";
    SRIMessageSignatureError2["SignatureHeaderValueIsNotByteSequence"] = "SignatureHeaderValueIsNotByteSequence";
    SRIMessageSignatureError2["SignatureHeaderValueIsParameterized"] = "SignatureHeaderValueIsParameterized";
    SRIMessageSignatureError2["SignatureHeaderValueIsIncorrectLength"] = "SignatureHeaderValueIsIncorrectLength";
    SRIMessageSignatureError2["SignatureInputHeaderMissingLabel"] = "SignatureInputHeaderMissingLabel";
    SRIMessageSignatureError2["SignatureInputHeaderValueNotInnerList"] = "SignatureInputHeaderValueNotInnerList";
    SRIMessageSignatureError2["SignatureInputHeaderValueMissingComponents"] = "SignatureInputHeaderValueMissingComponents";
    SRIMessageSignatureError2["SignatureInputHeaderInvalidComponentType"] = "SignatureInputHeaderInvalidComponentType";
    SRIMessageSignatureError2["SignatureInputHeaderInvalidComponentName"] = "SignatureInputHeaderInvalidComponentName";
    SRIMessageSignatureError2["SignatureInputHeaderInvalidHeaderComponentParameter"] = "SignatureInputHeaderInvalidHeaderComponentParameter";
    SRIMessageSignatureError2["SignatureInputHeaderInvalidDerivedComponentParameter"] = "SignatureInputHeaderInvalidDerivedComponentParameter";
    SRIMessageSignatureError2["SignatureInputHeaderKeyIdLength"] = "SignatureInputHeaderKeyIdLength";
    SRIMessageSignatureError2["SignatureInputHeaderInvalidParameter"] = "SignatureInputHeaderInvalidParameter";
    SRIMessageSignatureError2["SignatureInputHeaderMissingRequiredParameters"] = "SignatureInputHeaderMissingRequiredParameters";
    SRIMessageSignatureError2["ValidationFailedSignatureExpired"] = "ValidationFailedSignatureExpired";
    SRIMessageSignatureError2["ValidationFailedInvalidLength"] = "ValidationFailedInvalidLength";
    SRIMessageSignatureError2["ValidationFailedSignatureMismatch"] = "ValidationFailedSignatureMismatch";
    SRIMessageSignatureError2["ValidationFailedIntegrityMismatch"] = "ValidationFailedIntegrityMismatch";
  })(SRIMessageSignatureError = Audits2.SRIMessageSignatureError || (Audits2.SRIMessageSignatureError = {}));
  let UnencodedDigestError;
  ((UnencodedDigestError2) => {
    UnencodedDigestError2["MalformedDictionary"] = "MalformedDictionary";
    UnencodedDigestError2["UnknownAlgorithm"] = "UnknownAlgorithm";
    UnencodedDigestError2["IncorrectDigestType"] = "IncorrectDigestType";
    UnencodedDigestError2["IncorrectDigestLength"] = "IncorrectDigestLength";
  })(UnencodedDigestError = Audits2.UnencodedDigestError || (Audits2.UnencodedDigestError = {}));
  let GenericIssueErrorType;
  ((GenericIssueErrorType2) => {
    GenericIssueErrorType2["FormLabelForNameError"] = "FormLabelForNameError";
    GenericIssueErrorType2["FormDuplicateIdForInputError"] = "FormDuplicateIdForInputError";
    GenericIssueErrorType2["FormInputWithNoLabelError"] = "FormInputWithNoLabelError";
    GenericIssueErrorType2["FormAutocompleteAttributeEmptyError"] = "FormAutocompleteAttributeEmptyError";
    GenericIssueErrorType2["FormEmptyIdAndNameAttributesForInputError"] = "FormEmptyIdAndNameAttributesForInputError";
    GenericIssueErrorType2["FormAriaLabelledByToNonExistingId"] = "FormAriaLabelledByToNonExistingId";
    GenericIssueErrorType2["FormInputAssignedAutocompleteValueToIdOrNameAttributeError"] = "FormInputAssignedAutocompleteValueToIdOrNameAttributeError";
    GenericIssueErrorType2["FormLabelHasNeitherForNorNestedInput"] = "FormLabelHasNeitherForNorNestedInput";
    GenericIssueErrorType2["FormLabelForMatchesNonExistingIdError"] = "FormLabelForMatchesNonExistingIdError";
    GenericIssueErrorType2["FormInputHasWrongButWellIntendedAutocompleteValueError"] = "FormInputHasWrongButWellIntendedAutocompleteValueError";
    GenericIssueErrorType2["ResponseWasBlockedByORB"] = "ResponseWasBlockedByORB";
  })(GenericIssueErrorType = Audits2.GenericIssueErrorType || (Audits2.GenericIssueErrorType = {}));
  let ClientHintIssueReason;
  ((ClientHintIssueReason2) => {
    ClientHintIssueReason2["MetaTagAllowListInvalidOrigin"] = "MetaTagAllowListInvalidOrigin";
    ClientHintIssueReason2["MetaTagModifiedHTML"] = "MetaTagModifiedHTML";
  })(ClientHintIssueReason = Audits2.ClientHintIssueReason || (Audits2.ClientHintIssueReason = {}));
  let FederatedAuthRequestIssueReason;
  ((FederatedAuthRequestIssueReason2) => {
    FederatedAuthRequestIssueReason2["ShouldEmbargo"] = "ShouldEmbargo";
    FederatedAuthRequestIssueReason2["TooManyRequests"] = "TooManyRequests";
    FederatedAuthRequestIssueReason2["WellKnownHttpNotFound"] = "WellKnownHttpNotFound";
    FederatedAuthRequestIssueReason2["WellKnownNoResponse"] = "WellKnownNoResponse";
    FederatedAuthRequestIssueReason2["WellKnownInvalidResponse"] = "WellKnownInvalidResponse";
    FederatedAuthRequestIssueReason2["WellKnownListEmpty"] = "WellKnownListEmpty";
    FederatedAuthRequestIssueReason2["WellKnownInvalidContentType"] = "WellKnownInvalidContentType";
    FederatedAuthRequestIssueReason2["ConfigNotInWellKnown"] = "ConfigNotInWellKnown";
    FederatedAuthRequestIssueReason2["WellKnownTooBig"] = "WellKnownTooBig";
    FederatedAuthRequestIssueReason2["ConfigHttpNotFound"] = "ConfigHttpNotFound";
    FederatedAuthRequestIssueReason2["ConfigNoResponse"] = "ConfigNoResponse";
    FederatedAuthRequestIssueReason2["ConfigInvalidResponse"] = "ConfigInvalidResponse";
    FederatedAuthRequestIssueReason2["ConfigInvalidContentType"] = "ConfigInvalidContentType";
    FederatedAuthRequestIssueReason2["ClientMetadataHttpNotFound"] = "ClientMetadataHttpNotFound";
    FederatedAuthRequestIssueReason2["ClientMetadataNoResponse"] = "ClientMetadataNoResponse";
    FederatedAuthRequestIssueReason2["ClientMetadataInvalidResponse"] = "ClientMetadataInvalidResponse";
    FederatedAuthRequestIssueReason2["ClientMetadataInvalidContentType"] = "ClientMetadataInvalidContentType";
    FederatedAuthRequestIssueReason2["IdpNotPotentiallyTrustworthy"] = "IdpNotPotentiallyTrustworthy";
    FederatedAuthRequestIssueReason2["DisabledInSettings"] = "DisabledInSettings";
    FederatedAuthRequestIssueReason2["DisabledInFlags"] = "DisabledInFlags";
    FederatedAuthRequestIssueReason2["ErrorFetchingSignin"] = "ErrorFetchingSignin";
    FederatedAuthRequestIssueReason2["InvalidSigninResponse"] = "InvalidSigninResponse";
    FederatedAuthRequestIssueReason2["AccountsHttpNotFound"] = "AccountsHttpNotFound";
    FederatedAuthRequestIssueReason2["AccountsNoResponse"] = "AccountsNoResponse";
    FederatedAuthRequestIssueReason2["AccountsInvalidResponse"] = "AccountsInvalidResponse";
    FederatedAuthRequestIssueReason2["AccountsListEmpty"] = "AccountsListEmpty";
    FederatedAuthRequestIssueReason2["AccountsInvalidContentType"] = "AccountsInvalidContentType";
    FederatedAuthRequestIssueReason2["IdTokenHttpNotFound"] = "IdTokenHttpNotFound";
    FederatedAuthRequestIssueReason2["IdTokenNoResponse"] = "IdTokenNoResponse";
    FederatedAuthRequestIssueReason2["IdTokenInvalidResponse"] = "IdTokenInvalidResponse";
    FederatedAuthRequestIssueReason2["IdTokenIdpErrorResponse"] = "IdTokenIdpErrorResponse";
    FederatedAuthRequestIssueReason2["IdTokenCrossSiteIdpErrorResponse"] = "IdTokenCrossSiteIdpErrorResponse";
    FederatedAuthRequestIssueReason2["IdTokenInvalidRequest"] = "IdTokenInvalidRequest";
    FederatedAuthRequestIssueReason2["IdTokenInvalidContentType"] = "IdTokenInvalidContentType";
    FederatedAuthRequestIssueReason2["ErrorIdToken"] = "ErrorIdToken";
    FederatedAuthRequestIssueReason2["Canceled"] = "Canceled";
    FederatedAuthRequestIssueReason2["RpPageNotVisible"] = "RpPageNotVisible";
    FederatedAuthRequestIssueReason2["SilentMediationFailure"] = "SilentMediationFailure";
    FederatedAuthRequestIssueReason2["ThirdPartyCookiesBlocked"] = "ThirdPartyCookiesBlocked";
    FederatedAuthRequestIssueReason2["NotSignedInWithIdp"] = "NotSignedInWithIdp";
    FederatedAuthRequestIssueReason2["MissingTransientUserActivation"] = "MissingTransientUserActivation";
    FederatedAuthRequestIssueReason2["ReplacedByActiveMode"] = "ReplacedByActiveMode";
    FederatedAuthRequestIssueReason2["InvalidFieldsSpecified"] = "InvalidFieldsSpecified";
    FederatedAuthRequestIssueReason2["RelyingPartyOriginIsOpaque"] = "RelyingPartyOriginIsOpaque";
    FederatedAuthRequestIssueReason2["TypeNotMatching"] = "TypeNotMatching";
    FederatedAuthRequestIssueReason2["UiDismissedNoEmbargo"] = "UiDismissedNoEmbargo";
    FederatedAuthRequestIssueReason2["CorsError"] = "CorsError";
    FederatedAuthRequestIssueReason2["SuppressedBySegmentationPlatform"] = "SuppressedBySegmentationPlatform";
  })(FederatedAuthRequestIssueReason = Audits2.FederatedAuthRequestIssueReason || (Audits2.FederatedAuthRequestIssueReason = {}));
  let FederatedAuthUserInfoRequestIssueReason;
  ((FederatedAuthUserInfoRequestIssueReason2) => {
    FederatedAuthUserInfoRequestIssueReason2["NotSameOrigin"] = "NotSameOrigin";
    FederatedAuthUserInfoRequestIssueReason2["NotIframe"] = "NotIframe";
    FederatedAuthUserInfoRequestIssueReason2["NotPotentiallyTrustworthy"] = "NotPotentiallyTrustworthy";
    FederatedAuthUserInfoRequestIssueReason2["NoAPIPermission"] = "NoApiPermission";
    FederatedAuthUserInfoRequestIssueReason2["NotSignedInWithIdp"] = "NotSignedInWithIdp";
    FederatedAuthUserInfoRequestIssueReason2["NoAccountSharingPermission"] = "NoAccountSharingPermission";
    FederatedAuthUserInfoRequestIssueReason2["InvalidConfigOrWellKnown"] = "InvalidConfigOrWellKnown";
    FederatedAuthUserInfoRequestIssueReason2["InvalidAccountsResponse"] = "InvalidAccountsResponse";
    FederatedAuthUserInfoRequestIssueReason2["NoReturningUserFromFetchedAccounts"] = "NoReturningUserFromFetchedAccounts";
  })(FederatedAuthUserInfoRequestIssueReason = Audits2.FederatedAuthUserInfoRequestIssueReason || (Audits2.FederatedAuthUserInfoRequestIssueReason = {}));
  let PartitioningBlobURLInfo;
  ((PartitioningBlobURLInfo2) => {
    PartitioningBlobURLInfo2["BlockedCrossPartitionFetching"] = "BlockedCrossPartitionFetching";
    PartitioningBlobURLInfo2["EnforceNoopenerForNavigation"] = "EnforceNoopenerForNavigation";
  })(PartitioningBlobURLInfo = Audits2.PartitioningBlobURLInfo || (Audits2.PartitioningBlobURLInfo = {}));
  let ElementAccessibilityIssueReason;
  ((ElementAccessibilityIssueReason2) => {
    ElementAccessibilityIssueReason2["DisallowedSelectChild"] = "DisallowedSelectChild";
    ElementAccessibilityIssueReason2["DisallowedOptGroupChild"] = "DisallowedOptGroupChild";
    ElementAccessibilityIssueReason2["NonPhrasingContentOptionChild"] = "NonPhrasingContentOptionChild";
    ElementAccessibilityIssueReason2["InteractiveContentOptionChild"] = "InteractiveContentOptionChild";
    ElementAccessibilityIssueReason2["InteractiveContentLegendChild"] = "InteractiveContentLegendChild";
    ElementAccessibilityIssueReason2["InteractiveContentSummaryDescendant"] = "InteractiveContentSummaryDescendant";
  })(ElementAccessibilityIssueReason = Audits2.ElementAccessibilityIssueReason || (Audits2.ElementAccessibilityIssueReason = {}));
  let StyleSheetLoadingIssueReason;
  ((StyleSheetLoadingIssueReason2) => {
    StyleSheetLoadingIssueReason2["LateImportRule"] = "LateImportRule";
    StyleSheetLoadingIssueReason2["RequestFailed"] = "RequestFailed";
  })(StyleSheetLoadingIssueReason = Audits2.StyleSheetLoadingIssueReason || (Audits2.StyleSheetLoadingIssueReason = {}));
  let PropertyRuleIssueReason;
  ((PropertyRuleIssueReason2) => {
    PropertyRuleIssueReason2["InvalidSyntax"] = "InvalidSyntax";
    PropertyRuleIssueReason2["InvalidInitialValue"] = "InvalidInitialValue";
    PropertyRuleIssueReason2["InvalidInherits"] = "InvalidInherits";
    PropertyRuleIssueReason2["InvalidName"] = "InvalidName";
  })(PropertyRuleIssueReason = Audits2.PropertyRuleIssueReason || (Audits2.PropertyRuleIssueReason = {}));
  let UserReidentificationIssueType;
  ((UserReidentificationIssueType2) => {
    UserReidentificationIssueType2["BlockedFrameNavigation"] = "BlockedFrameNavigation";
    UserReidentificationIssueType2["BlockedSubresource"] = "BlockedSubresource";
    UserReidentificationIssueType2["NoisedCanvasReadback"] = "NoisedCanvasReadback";
  })(UserReidentificationIssueType = Audits2.UserReidentificationIssueType || (Audits2.UserReidentificationIssueType = {}));
  let InspectorIssueCode;
  ((InspectorIssueCode2) => {
    InspectorIssueCode2["CookieIssue"] = "CookieIssue";
    InspectorIssueCode2["MixedContentIssue"] = "MixedContentIssue";
    InspectorIssueCode2["BlockedByResponseIssue"] = "BlockedByResponseIssue";
    InspectorIssueCode2["HeavyAdIssue"] = "HeavyAdIssue";
    InspectorIssueCode2["ContentSecurityPolicyIssue"] = "ContentSecurityPolicyIssue";
    InspectorIssueCode2["SharedArrayBufferIssue"] = "SharedArrayBufferIssue";
    InspectorIssueCode2["LowTextContrastIssue"] = "LowTextContrastIssue";
    InspectorIssueCode2["CorsIssue"] = "CorsIssue";
    InspectorIssueCode2["AttributionReportingIssue"] = "AttributionReportingIssue";
    InspectorIssueCode2["QuirksModeIssue"] = "QuirksModeIssue";
    InspectorIssueCode2["PartitioningBlobURLIssue"] = "PartitioningBlobURLIssue";
    InspectorIssueCode2["NavigatorUserAgentIssue"] = "NavigatorUserAgentIssue";
    InspectorIssueCode2["GenericIssue"] = "GenericIssue";
    InspectorIssueCode2["DeprecationIssue"] = "DeprecationIssue";
    InspectorIssueCode2["ClientHintIssue"] = "ClientHintIssue";
    InspectorIssueCode2["FederatedAuthRequestIssue"] = "FederatedAuthRequestIssue";
    InspectorIssueCode2["BounceTrackingIssue"] = "BounceTrackingIssue";
    InspectorIssueCode2["CookieDeprecationMetadataIssue"] = "CookieDeprecationMetadataIssue";
    InspectorIssueCode2["StylesheetLoadingIssue"] = "StylesheetLoadingIssue";
    InspectorIssueCode2["FederatedAuthUserInfoRequestIssue"] = "FederatedAuthUserInfoRequestIssue";
    InspectorIssueCode2["PropertyRuleIssue"] = "PropertyRuleIssue";
    InspectorIssueCode2["SharedDictionaryIssue"] = "SharedDictionaryIssue";
    InspectorIssueCode2["ElementAccessibilityIssue"] = "ElementAccessibilityIssue";
    InspectorIssueCode2["SRIMessageSignatureIssue"] = "SRIMessageSignatureIssue";
    InspectorIssueCode2["UnencodedDigestIssue"] = "UnencodedDigestIssue";
    InspectorIssueCode2["UserReidentificationIssue"] = "UserReidentificationIssue";
  })(InspectorIssueCode = Audits2.InspectorIssueCode || (Audits2.InspectorIssueCode = {}));
  let GetEncodedResponseRequestEncoding;
  ((GetEncodedResponseRequestEncoding2) => {
    GetEncodedResponseRequestEncoding2["Webp"] = "webp";
    GetEncodedResponseRequestEncoding2["Jpeg"] = "jpeg";
    GetEncodedResponseRequestEncoding2["Png"] = "png";
  })(GetEncodedResponseRequestEncoding = Audits2.GetEncodedResponseRequestEncoding || (Audits2.GetEncodedResponseRequestEncoding = {}));
})(Audits || (Audits = {}));
var Autofill;
((Autofill2) => {
  let FillingStrategy;
  ((FillingStrategy2) => {
    FillingStrategy2["AutocompleteAttribute"] = "autocompleteAttribute";
    FillingStrategy2["AutofillInferred"] = "autofillInferred";
  })(FillingStrategy = Autofill2.FillingStrategy || (Autofill2.FillingStrategy = {}));
})(Autofill || (Autofill = {}));
var BackgroundService;
((BackgroundService2) => {
  let ServiceName;
  ((ServiceName2) => {
    ServiceName2["BackgroundFetch"] = "backgroundFetch";
    ServiceName2["BackgroundSync"] = "backgroundSync";
    ServiceName2["PushMessaging"] = "pushMessaging";
    ServiceName2["Notifications"] = "notifications";
    ServiceName2["PaymentHandler"] = "paymentHandler";
    ServiceName2["PeriodicBackgroundSync"] = "periodicBackgroundSync";
  })(ServiceName = BackgroundService2.ServiceName || (BackgroundService2.ServiceName = {}));
})(BackgroundService || (BackgroundService = {}));
var BluetoothEmulation;
((BluetoothEmulation2) => {
  let CentralState;
  ((CentralState2) => {
    CentralState2["Absent"] = "absent";
    CentralState2["PoweredOff"] = "powered-off";
    CentralState2["PoweredOn"] = "powered-on";
  })(CentralState = BluetoothEmulation2.CentralState || (BluetoothEmulation2.CentralState = {}));
  let GATTOperationType;
  ((GATTOperationType2) => {
    GATTOperationType2["Connection"] = "connection";
    GATTOperationType2["Discovery"] = "discovery";
  })(GATTOperationType = BluetoothEmulation2.GATTOperationType || (BluetoothEmulation2.GATTOperationType = {}));
  let CharacteristicWriteType;
  ((CharacteristicWriteType2) => {
    CharacteristicWriteType2["WriteDefaultDeprecated"] = "write-default-deprecated";
    CharacteristicWriteType2["WriteWithResponse"] = "write-with-response";
    CharacteristicWriteType2["WriteWithoutResponse"] = "write-without-response";
  })(CharacteristicWriteType = BluetoothEmulation2.CharacteristicWriteType || (BluetoothEmulation2.CharacteristicWriteType = {}));
  let CharacteristicOperationType;
  ((CharacteristicOperationType2) => {
    CharacteristicOperationType2["Read"] = "read";
    CharacteristicOperationType2["Write"] = "write";
    CharacteristicOperationType2["SubscribeToNotifications"] = "subscribe-to-notifications";
    CharacteristicOperationType2["UnsubscribeFromNotifications"] = "unsubscribe-from-notifications";
  })(CharacteristicOperationType = BluetoothEmulation2.CharacteristicOperationType || (BluetoothEmulation2.CharacteristicOperationType = {}));
  let DescriptorOperationType;
  ((DescriptorOperationType2) => {
    DescriptorOperationType2["Read"] = "read";
    DescriptorOperationType2["Write"] = "write";
  })(DescriptorOperationType = BluetoothEmulation2.DescriptorOperationType || (BluetoothEmulation2.DescriptorOperationType = {}));
})(BluetoothEmulation || (BluetoothEmulation = {}));
var Browser;
((Browser2) => {
  let WindowState;
  ((WindowState2) => {
    WindowState2["Normal"] = "normal";
    WindowState2["Minimized"] = "minimized";
    WindowState2["Maximized"] = "maximized";
    WindowState2["Fullscreen"] = "fullscreen";
  })(WindowState = Browser2.WindowState || (Browser2.WindowState = {}));
  let PermissionType;
  ((PermissionType2) => {
    PermissionType2["Ar"] = "ar";
    PermissionType2["AudioCapture"] = "audioCapture";
    PermissionType2["AutomaticFullscreen"] = "automaticFullscreen";
    PermissionType2["BackgroundFetch"] = "backgroundFetch";
    PermissionType2["BackgroundSync"] = "backgroundSync";
    PermissionType2["CameraPanTiltZoom"] = "cameraPanTiltZoom";
    PermissionType2["CapturedSurfaceControl"] = "capturedSurfaceControl";
    PermissionType2["ClipboardReadWrite"] = "clipboardReadWrite";
    PermissionType2["ClipboardSanitizedWrite"] = "clipboardSanitizedWrite";
    PermissionType2["DisplayCapture"] = "displayCapture";
    PermissionType2["DurableStorage"] = "durableStorage";
    PermissionType2["Geolocation"] = "geolocation";
    PermissionType2["HandTracking"] = "handTracking";
    PermissionType2["IdleDetection"] = "idleDetection";
    PermissionType2["KeyboardLock"] = "keyboardLock";
    PermissionType2["LocalFonts"] = "localFonts";
    PermissionType2["LocalNetworkAccess"] = "localNetworkAccess";
    PermissionType2["Midi"] = "midi";
    PermissionType2["MidiSysex"] = "midiSysex";
    PermissionType2["Nfc"] = "nfc";
    PermissionType2["Notifications"] = "notifications";
    PermissionType2["PaymentHandler"] = "paymentHandler";
    PermissionType2["PeriodicBackgroundSync"] = "periodicBackgroundSync";
    PermissionType2["PointerLock"] = "pointerLock";
    PermissionType2["ProtectedMediaIdentifier"] = "protectedMediaIdentifier";
    PermissionType2["Sensors"] = "sensors";
    PermissionType2["SmartCard"] = "smartCard";
    PermissionType2["SpeakerSelection"] = "speakerSelection";
    PermissionType2["StorageAccess"] = "storageAccess";
    PermissionType2["TopLevelStorageAccess"] = "topLevelStorageAccess";
    PermissionType2["VideoCapture"] = "videoCapture";
    PermissionType2["Vr"] = "vr";
    PermissionType2["WakeLockScreen"] = "wakeLockScreen";
    PermissionType2["WakeLockSystem"] = "wakeLockSystem";
    PermissionType2["WebAppInstallation"] = "webAppInstallation";
    PermissionType2["WebPrinting"] = "webPrinting";
    PermissionType2["WindowManagement"] = "windowManagement";
  })(PermissionType = Browser2.PermissionType || (Browser2.PermissionType = {}));
  let PermissionSetting;
  ((PermissionSetting2) => {
    PermissionSetting2["Granted"] = "granted";
    PermissionSetting2["Denied"] = "denied";
    PermissionSetting2["Prompt"] = "prompt";
  })(PermissionSetting = Browser2.PermissionSetting || (Browser2.PermissionSetting = {}));
  let BrowserCommandId;
  ((BrowserCommandId2) => {
    BrowserCommandId2["OpenTabSearch"] = "openTabSearch";
    BrowserCommandId2["CloseTabSearch"] = "closeTabSearch";
    BrowserCommandId2["OpenGlic"] = "openGlic";
  })(BrowserCommandId = Browser2.BrowserCommandId || (Browser2.BrowserCommandId = {}));
  let PrivacySandboxAPI;
  ((PrivacySandboxAPI2) => {
    PrivacySandboxAPI2["BiddingAndAuctionServices"] = "BiddingAndAuctionServices";
    PrivacySandboxAPI2["TrustedKeyValue"] = "TrustedKeyValue";
  })(PrivacySandboxAPI = Browser2.PrivacySandboxAPI || (Browser2.PrivacySandboxAPI = {}));
  let SetDownloadBehaviorRequestBehavior;
  ((SetDownloadBehaviorRequestBehavior2) => {
    SetDownloadBehaviorRequestBehavior2["Deny"] = "deny";
    SetDownloadBehaviorRequestBehavior2["Allow"] = "allow";
    SetDownloadBehaviorRequestBehavior2["AllowAndName"] = "allowAndName";
    SetDownloadBehaviorRequestBehavior2["Default"] = "default";
  })(SetDownloadBehaviorRequestBehavior = Browser2.SetDownloadBehaviorRequestBehavior || (Browser2.SetDownloadBehaviorRequestBehavior = {}));
  let DownloadProgressEventState;
  ((DownloadProgressEventState2) => {
    DownloadProgressEventState2["InProgress"] = "inProgress";
    DownloadProgressEventState2["Completed"] = "completed";
    DownloadProgressEventState2["Canceled"] = "canceled";
  })(DownloadProgressEventState = Browser2.DownloadProgressEventState || (Browser2.DownloadProgressEventState = {}));
})(Browser || (Browser = {}));
var CSS;
((CSS2) => {
  let StyleSheetOrigin;
  ((StyleSheetOrigin2) => {
    StyleSheetOrigin2["Injected"] = "injected";
    StyleSheetOrigin2["UserAgent"] = "user-agent";
    StyleSheetOrigin2["Inspector"] = "inspector";
    StyleSheetOrigin2["Regular"] = "regular";
  })(StyleSheetOrigin = CSS2.StyleSheetOrigin || (CSS2.StyleSheetOrigin = {}));
  let CSSRuleType;
  ((CSSRuleType2) => {
    CSSRuleType2["MediaRule"] = "MediaRule";
    CSSRuleType2["SupportsRule"] = "SupportsRule";
    CSSRuleType2["ContainerRule"] = "ContainerRule";
    CSSRuleType2["LayerRule"] = "LayerRule";
    CSSRuleType2["ScopeRule"] = "ScopeRule";
    CSSRuleType2["StyleRule"] = "StyleRule";
    CSSRuleType2["StartingStyleRule"] = "StartingStyleRule";
  })(CSSRuleType = CSS2.CSSRuleType || (CSS2.CSSRuleType = {}));
  let CSSMediaSource;
  ((CSSMediaSource2) => {
    CSSMediaSource2["MediaRule"] = "mediaRule";
    CSSMediaSource2["ImportRule"] = "importRule";
    CSSMediaSource2["LinkedSheet"] = "linkedSheet";
    CSSMediaSource2["InlineSheet"] = "inlineSheet";
  })(CSSMediaSource = CSS2.CSSMediaSource || (CSS2.CSSMediaSource = {}));
})(CSS || (CSS = {}));
var CacheStorage;
((CacheStorage2) => {
  let CachedResponseType;
  ((CachedResponseType2) => {
    CachedResponseType2["Basic"] = "basic";
    CachedResponseType2["Cors"] = "cors";
    CachedResponseType2["Default"] = "default";
    CachedResponseType2["Error"] = "error";
    CachedResponseType2["OpaqueResponse"] = "opaqueResponse";
    CachedResponseType2["OpaqueRedirect"] = "opaqueRedirect";
  })(CachedResponseType = CacheStorage2.CachedResponseType || (CacheStorage2.CachedResponseType = {}));
})(CacheStorage || (CacheStorage = {}));
var DOM;
((DOM2) => {
  let PseudoType;
  ((PseudoType2) => {
    PseudoType2["FirstLine"] = "first-line";
    PseudoType2["FirstLetter"] = "first-letter";
    PseudoType2["Checkmark"] = "checkmark";
    PseudoType2["Before"] = "before";
    PseudoType2["After"] = "after";
    PseudoType2["PickerIcon"] = "picker-icon";
    PseudoType2["InterestHint"] = "interest-hint";
    PseudoType2["Marker"] = "marker";
    PseudoType2["Backdrop"] = "backdrop";
    PseudoType2["Column"] = "column";
    PseudoType2["Selection"] = "selection";
    PseudoType2["SearchText"] = "search-text";
    PseudoType2["TargetText"] = "target-text";
    PseudoType2["SpellingError"] = "spelling-error";
    PseudoType2["GrammarError"] = "grammar-error";
    PseudoType2["Highlight"] = "highlight";
    PseudoType2["FirstLineInherited"] = "first-line-inherited";
    PseudoType2["ScrollMarker"] = "scroll-marker";
    PseudoType2["ScrollMarkerGroup"] = "scroll-marker-group";
    PseudoType2["ScrollButton"] = "scroll-button";
    PseudoType2["Scrollbar"] = "scrollbar";
    PseudoType2["ScrollbarThumb"] = "scrollbar-thumb";
    PseudoType2["ScrollbarButton"] = "scrollbar-button";
    PseudoType2["ScrollbarTrack"] = "scrollbar-track";
    PseudoType2["ScrollbarTrackPiece"] = "scrollbar-track-piece";
    PseudoType2["ScrollbarCorner"] = "scrollbar-corner";
    PseudoType2["Resizer"] = "resizer";
    PseudoType2["InputListButton"] = "input-list-button";
    PseudoType2["ViewTransition"] = "view-transition";
    PseudoType2["ViewTransitionGroup"] = "view-transition-group";
    PseudoType2["ViewTransitionImagePair"] = "view-transition-image-pair";
    PseudoType2["ViewTransitionGroupChildren"] = "view-transition-group-children";
    PseudoType2["ViewTransitionOld"] = "view-transition-old";
    PseudoType2["ViewTransitionNew"] = "view-transition-new";
    PseudoType2["Placeholder"] = "placeholder";
    PseudoType2["FileSelectorButton"] = "file-selector-button";
    PseudoType2["DetailsContent"] = "details-content";
    PseudoType2["Picker"] = "picker";
    PseudoType2["PermissionIcon"] = "permission-icon";
  })(PseudoType = DOM2.PseudoType || (DOM2.PseudoType = {}));
  let ShadowRootType;
  ((ShadowRootType2) => {
    ShadowRootType2["UserAgent"] = "user-agent";
    ShadowRootType2["Open"] = "open";
    ShadowRootType2["Closed"] = "closed";
  })(ShadowRootType = DOM2.ShadowRootType || (DOM2.ShadowRootType = {}));
  let CompatibilityMode;
  ((CompatibilityMode2) => {
    CompatibilityMode2["QuirksMode"] = "QuirksMode";
    CompatibilityMode2["LimitedQuirksMode"] = "LimitedQuirksMode";
    CompatibilityMode2["NoQuirksMode"] = "NoQuirksMode";
  })(CompatibilityMode = DOM2.CompatibilityMode || (DOM2.CompatibilityMode = {}));
  let PhysicalAxes;
  ((PhysicalAxes2) => {
    PhysicalAxes2["Horizontal"] = "Horizontal";
    PhysicalAxes2["Vertical"] = "Vertical";
    PhysicalAxes2["Both"] = "Both";
  })(PhysicalAxes = DOM2.PhysicalAxes || (DOM2.PhysicalAxes = {}));
  let LogicalAxes;
  ((LogicalAxes2) => {
    LogicalAxes2["Inline"] = "Inline";
    LogicalAxes2["Block"] = "Block";
    LogicalAxes2["Both"] = "Both";
  })(LogicalAxes = DOM2.LogicalAxes || (DOM2.LogicalAxes = {}));
  let ScrollOrientation;
  ((ScrollOrientation2) => {
    ScrollOrientation2["Horizontal"] = "horizontal";
    ScrollOrientation2["Vertical"] = "vertical";
  })(ScrollOrientation = DOM2.ScrollOrientation || (DOM2.ScrollOrientation = {}));
  let EnableRequestIncludeWhitespace;
  ((EnableRequestIncludeWhitespace2) => {
    EnableRequestIncludeWhitespace2["None"] = "none";
    EnableRequestIncludeWhitespace2["All"] = "all";
  })(EnableRequestIncludeWhitespace = DOM2.EnableRequestIncludeWhitespace || (DOM2.EnableRequestIncludeWhitespace = {}));
  let GetElementByRelationRequestRelation;
  ((GetElementByRelationRequestRelation2) => {
    GetElementByRelationRequestRelation2["PopoverTarget"] = "PopoverTarget";
    GetElementByRelationRequestRelation2["InterestTarget"] = "InterestTarget";
    GetElementByRelationRequestRelation2["CommandFor"] = "CommandFor";
  })(GetElementByRelationRequestRelation = DOM2.GetElementByRelationRequestRelation || (DOM2.GetElementByRelationRequestRelation = {}));
})(DOM || (DOM = {}));
var DOMDebugger;
((DOMDebugger2) => {
  let DOMBreakpointType;
  ((DOMBreakpointType2) => {
    DOMBreakpointType2["SubtreeModified"] = "subtree-modified";
    DOMBreakpointType2["AttributeModified"] = "attribute-modified";
    DOMBreakpointType2["NodeRemoved"] = "node-removed";
  })(DOMBreakpointType = DOMDebugger2.DOMBreakpointType || (DOMDebugger2.DOMBreakpointType = {}));
  let CSPViolationType;
  ((CSPViolationType2) => {
    CSPViolationType2["TrustedtypeSinkViolation"] = "trustedtype-sink-violation";
    CSPViolationType2["TrustedtypePolicyViolation"] = "trustedtype-policy-violation";
  })(CSPViolationType = DOMDebugger2.CSPViolationType || (DOMDebugger2.CSPViolationType = {}));
})(DOMDebugger || (DOMDebugger = {}));
var Emulation;
((Emulation2) => {
  let ScreenOrientationType;
  ((ScreenOrientationType2) => {
    ScreenOrientationType2["PortraitPrimary"] = "portraitPrimary";
    ScreenOrientationType2["PortraitSecondary"] = "portraitSecondary";
    ScreenOrientationType2["LandscapePrimary"] = "landscapePrimary";
    ScreenOrientationType2["LandscapeSecondary"] = "landscapeSecondary";
  })(ScreenOrientationType = Emulation2.ScreenOrientationType || (Emulation2.ScreenOrientationType = {}));
  let DisplayFeatureOrientation;
  ((DisplayFeatureOrientation2) => {
    DisplayFeatureOrientation2["Vertical"] = "vertical";
    DisplayFeatureOrientation2["Horizontal"] = "horizontal";
  })(DisplayFeatureOrientation = Emulation2.DisplayFeatureOrientation || (Emulation2.DisplayFeatureOrientation = {}));
  let DevicePostureType;
  ((DevicePostureType2) => {
    DevicePostureType2["Continuous"] = "continuous";
    DevicePostureType2["Folded"] = "folded";
  })(DevicePostureType = Emulation2.DevicePostureType || (Emulation2.DevicePostureType = {}));
  let VirtualTimePolicy;
  ((VirtualTimePolicy2) => {
    VirtualTimePolicy2["Advance"] = "advance";
    VirtualTimePolicy2["Pause"] = "pause";
    VirtualTimePolicy2["PauseIfNetworkFetchesPending"] = "pauseIfNetworkFetchesPending";
  })(VirtualTimePolicy = Emulation2.VirtualTimePolicy || (Emulation2.VirtualTimePolicy = {}));
  let SensorType;
  ((SensorType2) => {
    SensorType2["AbsoluteOrientation"] = "absolute-orientation";
    SensorType2["Accelerometer"] = "accelerometer";
    SensorType2["AmbientLight"] = "ambient-light";
    SensorType2["Gravity"] = "gravity";
    SensorType2["Gyroscope"] = "gyroscope";
    SensorType2["LinearAcceleration"] = "linear-acceleration";
    SensorType2["Magnetometer"] = "magnetometer";
    SensorType2["RelativeOrientation"] = "relative-orientation";
  })(SensorType = Emulation2.SensorType || (Emulation2.SensorType = {}));
  let PressureSource;
  ((PressureSource2) => {
    PressureSource2["Cpu"] = "cpu";
  })(PressureSource = Emulation2.PressureSource || (Emulation2.PressureSource = {}));
  let PressureState;
  ((PressureState2) => {
    PressureState2["Nominal"] = "nominal";
    PressureState2["Fair"] = "fair";
    PressureState2["Serious"] = "serious";
    PressureState2["Critical"] = "critical";
  })(PressureState = Emulation2.PressureState || (Emulation2.PressureState = {}));
  let DisabledImageType;
  ((DisabledImageType2) => {
    DisabledImageType2["Avif"] = "avif";
    DisabledImageType2["Webp"] = "webp";
  })(DisabledImageType = Emulation2.DisabledImageType || (Emulation2.DisabledImageType = {}));
  let SetEmitTouchEventsForMouseRequestConfiguration;
  ((SetEmitTouchEventsForMouseRequestConfiguration2) => {
    SetEmitTouchEventsForMouseRequestConfiguration2["Mobile"] = "mobile";
    SetEmitTouchEventsForMouseRequestConfiguration2["Desktop"] = "desktop";
  })(SetEmitTouchEventsForMouseRequestConfiguration = Emulation2.SetEmitTouchEventsForMouseRequestConfiguration || (Emulation2.SetEmitTouchEventsForMouseRequestConfiguration = {}));
  let SetEmulatedVisionDeficiencyRequestType;
  ((SetEmulatedVisionDeficiencyRequestType2) => {
    SetEmulatedVisionDeficiencyRequestType2["None"] = "none";
    SetEmulatedVisionDeficiencyRequestType2["BlurredVision"] = "blurredVision";
    SetEmulatedVisionDeficiencyRequestType2["ReducedContrast"] = "reducedContrast";
    SetEmulatedVisionDeficiencyRequestType2["Achromatopsia"] = "achromatopsia";
    SetEmulatedVisionDeficiencyRequestType2["Deuteranopia"] = "deuteranopia";
    SetEmulatedVisionDeficiencyRequestType2["Protanopia"] = "protanopia";
    SetEmulatedVisionDeficiencyRequestType2["Tritanopia"] = "tritanopia";
  })(SetEmulatedVisionDeficiencyRequestType = Emulation2.SetEmulatedVisionDeficiencyRequestType || (Emulation2.SetEmulatedVisionDeficiencyRequestType = {}));
})(Emulation || (Emulation = {}));
var Extensions;
((Extensions2) => {
  let StorageArea;
  ((StorageArea2) => {
    StorageArea2["Session"] = "session";
    StorageArea2["Local"] = "local";
    StorageArea2["Sync"] = "sync";
    StorageArea2["Managed"] = "managed";
  })(StorageArea = Extensions2.StorageArea || (Extensions2.StorageArea = {}));
})(Extensions || (Extensions = {}));
var FedCm;
((FedCm2) => {
  let LoginState;
  ((LoginState2) => {
    LoginState2["SignIn"] = "SignIn";
    LoginState2["SignUp"] = "SignUp";
  })(LoginState = FedCm2.LoginState || (FedCm2.LoginState = {}));
  let DialogType;
  ((DialogType2) => {
    DialogType2["AccountChooser"] = "AccountChooser";
    DialogType2["AutoReauthn"] = "AutoReauthn";
    DialogType2["ConfirmIdpLogin"] = "ConfirmIdpLogin";
    DialogType2["Error"] = "Error";
  })(DialogType = FedCm2.DialogType || (FedCm2.DialogType = {}));
  let DialogButton;
  ((DialogButton2) => {
    DialogButton2["ConfirmIdpLoginContinue"] = "ConfirmIdpLoginContinue";
    DialogButton2["ErrorGotIt"] = "ErrorGotIt";
    DialogButton2["ErrorMoreDetails"] = "ErrorMoreDetails";
  })(DialogButton = FedCm2.DialogButton || (FedCm2.DialogButton = {}));
  let AccountUrlType;
  ((AccountUrlType2) => {
    AccountUrlType2["TermsOfService"] = "TermsOfService";
    AccountUrlType2["PrivacyPolicy"] = "PrivacyPolicy";
  })(AccountUrlType = FedCm2.AccountUrlType || (FedCm2.AccountUrlType = {}));
})(FedCm || (FedCm = {}));
var Fetch;
((Fetch2) => {
  let RequestStage;
  ((RequestStage2) => {
    RequestStage2["Request"] = "Request";
    RequestStage2["Response"] = "Response";
  })(RequestStage = Fetch2.RequestStage || (Fetch2.RequestStage = {}));
  let AuthChallengeSource;
  ((AuthChallengeSource2) => {
    AuthChallengeSource2["Server"] = "Server";
    AuthChallengeSource2["Proxy"] = "Proxy";
  })(AuthChallengeSource = Fetch2.AuthChallengeSource || (Fetch2.AuthChallengeSource = {}));
  let AuthChallengeResponseResponse;
  ((AuthChallengeResponseResponse2) => {
    AuthChallengeResponseResponse2["Default"] = "Default";
    AuthChallengeResponseResponse2["CancelAuth"] = "CancelAuth";
    AuthChallengeResponseResponse2["ProvideCredentials"] = "ProvideCredentials";
  })(AuthChallengeResponseResponse = Fetch2.AuthChallengeResponseResponse || (Fetch2.AuthChallengeResponseResponse = {}));
})(Fetch || (Fetch = {}));
var HeadlessExperimental;
((HeadlessExperimental2) => {
  let ScreenshotParamsFormat;
  ((ScreenshotParamsFormat2) => {
    ScreenshotParamsFormat2["Jpeg"] = "jpeg";
    ScreenshotParamsFormat2["Png"] = "png";
    ScreenshotParamsFormat2["Webp"] = "webp";
  })(ScreenshotParamsFormat = HeadlessExperimental2.ScreenshotParamsFormat || (HeadlessExperimental2.ScreenshotParamsFormat = {}));
})(HeadlessExperimental || (HeadlessExperimental = {}));
var IndexedDB;
((IndexedDB2) => {
  let KeyType;
  ((KeyType2) => {
    KeyType2["Number"] = "number";
    KeyType2["String"] = "string";
    KeyType2["Date"] = "date";
    KeyType2["Array"] = "array";
  })(KeyType = IndexedDB2.KeyType || (IndexedDB2.KeyType = {}));
  let KeyPathType;
  ((KeyPathType2) => {
    KeyPathType2["Null"] = "null";
    KeyPathType2["String"] = "string";
    KeyPathType2["Array"] = "array";
  })(KeyPathType = IndexedDB2.KeyPathType || (IndexedDB2.KeyPathType = {}));
})(IndexedDB || (IndexedDB = {}));
var Input;
((Input2) => {
  let GestureSourceType;
  ((GestureSourceType2) => {
    GestureSourceType2["Default"] = "default";
    GestureSourceType2["Touch"] = "touch";
    GestureSourceType2["Mouse"] = "mouse";
  })(GestureSourceType = Input2.GestureSourceType || (Input2.GestureSourceType = {}));
  let MouseButton;
  ((MouseButton2) => {
    MouseButton2["None"] = "none";
    MouseButton2["Left"] = "left";
    MouseButton2["Middle"] = "middle";
    MouseButton2["Right"] = "right";
    MouseButton2["Back"] = "back";
    MouseButton2["Forward"] = "forward";
  })(MouseButton = Input2.MouseButton || (Input2.MouseButton = {}));
  let DispatchDragEventRequestType;
  ((DispatchDragEventRequestType2) => {
    DispatchDragEventRequestType2["DragEnter"] = "dragEnter";
    DispatchDragEventRequestType2["DragOver"] = "dragOver";
    DispatchDragEventRequestType2["Drop"] = "drop";
    DispatchDragEventRequestType2["DragCancel"] = "dragCancel";
  })(DispatchDragEventRequestType = Input2.DispatchDragEventRequestType || (Input2.DispatchDragEventRequestType = {}));
  let DispatchKeyEventRequestType;
  ((DispatchKeyEventRequestType2) => {
    DispatchKeyEventRequestType2["KeyDown"] = "keyDown";
    DispatchKeyEventRequestType2["KeyUp"] = "keyUp";
    DispatchKeyEventRequestType2["RawKeyDown"] = "rawKeyDown";
    DispatchKeyEventRequestType2["Char"] = "char";
  })(DispatchKeyEventRequestType = Input2.DispatchKeyEventRequestType || (Input2.DispatchKeyEventRequestType = {}));
  let DispatchMouseEventRequestType;
  ((DispatchMouseEventRequestType2) => {
    DispatchMouseEventRequestType2["MousePressed"] = "mousePressed";
    DispatchMouseEventRequestType2["MouseReleased"] = "mouseReleased";
    DispatchMouseEventRequestType2["MouseMoved"] = "mouseMoved";
    DispatchMouseEventRequestType2["MouseWheel"] = "mouseWheel";
  })(DispatchMouseEventRequestType = Input2.DispatchMouseEventRequestType || (Input2.DispatchMouseEventRequestType = {}));
  let DispatchMouseEventRequestPointerType;
  ((DispatchMouseEventRequestPointerType2) => {
    DispatchMouseEventRequestPointerType2["Mouse"] = "mouse";
    DispatchMouseEventRequestPointerType2["Pen"] = "pen";
  })(DispatchMouseEventRequestPointerType = Input2.DispatchMouseEventRequestPointerType || (Input2.DispatchMouseEventRequestPointerType = {}));
  let DispatchTouchEventRequestType;
  ((DispatchTouchEventRequestType2) => {
    DispatchTouchEventRequestType2["TouchStart"] = "touchStart";
    DispatchTouchEventRequestType2["TouchEnd"] = "touchEnd";
    DispatchTouchEventRequestType2["TouchMove"] = "touchMove";
    DispatchTouchEventRequestType2["TouchCancel"] = "touchCancel";
  })(DispatchTouchEventRequestType = Input2.DispatchTouchEventRequestType || (Input2.DispatchTouchEventRequestType = {}));
  let EmulateTouchFromMouseEventRequestType;
  ((EmulateTouchFromMouseEventRequestType2) => {
    EmulateTouchFromMouseEventRequestType2["MousePressed"] = "mousePressed";
    EmulateTouchFromMouseEventRequestType2["MouseReleased"] = "mouseReleased";
    EmulateTouchFromMouseEventRequestType2["MouseMoved"] = "mouseMoved";
    EmulateTouchFromMouseEventRequestType2["MouseWheel"] = "mouseWheel";
  })(EmulateTouchFromMouseEventRequestType = Input2.EmulateTouchFromMouseEventRequestType || (Input2.EmulateTouchFromMouseEventRequestType = {}));
})(Input || (Input = {}));
var LayerTree;
((LayerTree2) => {
  let ScrollRectType;
  ((ScrollRectType2) => {
    ScrollRectType2["RepaintsOnScroll"] = "RepaintsOnScroll";
    ScrollRectType2["TouchEventHandler"] = "TouchEventHandler";
    ScrollRectType2["WheelEventHandler"] = "WheelEventHandler";
  })(ScrollRectType = LayerTree2.ScrollRectType || (LayerTree2.ScrollRectType = {}));
})(LayerTree || (LayerTree = {}));
var Log;
((Log2) => {
  let LogEntrySource;
  ((LogEntrySource2) => {
    LogEntrySource2["XML"] = "xml";
    LogEntrySource2["Javascript"] = "javascript";
    LogEntrySource2["Network"] = "network";
    LogEntrySource2["Storage"] = "storage";
    LogEntrySource2["Appcache"] = "appcache";
    LogEntrySource2["Rendering"] = "rendering";
    LogEntrySource2["Security"] = "security";
    LogEntrySource2["Deprecation"] = "deprecation";
    LogEntrySource2["Worker"] = "worker";
    LogEntrySource2["Violation"] = "violation";
    LogEntrySource2["Intervention"] = "intervention";
    LogEntrySource2["Recommendation"] = "recommendation";
    LogEntrySource2["Other"] = "other";
  })(LogEntrySource = Log2.LogEntrySource || (Log2.LogEntrySource = {}));
  let LogEntryLevel;
  ((LogEntryLevel2) => {
    LogEntryLevel2["Verbose"] = "verbose";
    LogEntryLevel2["Info"] = "info";
    LogEntryLevel2["Warning"] = "warning";
    LogEntryLevel2["Error"] = "error";
  })(LogEntryLevel = Log2.LogEntryLevel || (Log2.LogEntryLevel = {}));
  let LogEntryCategory;
  ((LogEntryCategory2) => {
    LogEntryCategory2["Cors"] = "cors";
  })(LogEntryCategory = Log2.LogEntryCategory || (Log2.LogEntryCategory = {}));
  let ViolationSettingName;
  ((ViolationSettingName2) => {
    ViolationSettingName2["LongTask"] = "longTask";
    ViolationSettingName2["LongLayout"] = "longLayout";
    ViolationSettingName2["BlockedEvent"] = "blockedEvent";
    ViolationSettingName2["BlockedParser"] = "blockedParser";
    ViolationSettingName2["DiscouragedAPIUse"] = "discouragedAPIUse";
    ViolationSettingName2["Handler"] = "handler";
    ViolationSettingName2["RecurringHandler"] = "recurringHandler";
  })(ViolationSettingName = Log2.ViolationSettingName || (Log2.ViolationSettingName = {}));
})(Log || (Log = {}));
var Media;
((Media2) => {
  let PlayerMessageLevel;
  ((PlayerMessageLevel2) => {
    PlayerMessageLevel2["Error"] = "error";
    PlayerMessageLevel2["Warning"] = "warning";
    PlayerMessageLevel2["Info"] = "info";
    PlayerMessageLevel2["Debug"] = "debug";
  })(PlayerMessageLevel = Media2.PlayerMessageLevel || (Media2.PlayerMessageLevel = {}));
})(Media || (Media = {}));
var Memory;
((Memory2) => {
  let PressureLevel;
  ((PressureLevel2) => {
    PressureLevel2["Moderate"] = "moderate";
    PressureLevel2["Critical"] = "critical";
  })(PressureLevel = Memory2.PressureLevel || (Memory2.PressureLevel = {}));
})(Memory || (Memory = {}));
var Network;
((Network2) => {
  let ResourceType6;
  ((ResourceType22) => {
    ResourceType22["Document"] = "Document";
    ResourceType22["Stylesheet"] = "Stylesheet";
    ResourceType22["Image"] = "Image";
    ResourceType22["Media"] = "Media";
    ResourceType22["Font"] = "Font";
    ResourceType22["Script"] = "Script";
    ResourceType22["TextTrack"] = "TextTrack";
    ResourceType22["XHR"] = "XHR";
    ResourceType22["Fetch"] = "Fetch";
    ResourceType22["Prefetch"] = "Prefetch";
    ResourceType22["EventSource"] = "EventSource";
    ResourceType22["WebSocket"] = "WebSocket";
    ResourceType22["Manifest"] = "Manifest";
    ResourceType22["SignedExchange"] = "SignedExchange";
    ResourceType22["Ping"] = "Ping";
    ResourceType22["CSPViolationReport"] = "CSPViolationReport";
    ResourceType22["Preflight"] = "Preflight";
    ResourceType22["FedCM"] = "FedCM";
    ResourceType22["Other"] = "Other";
  })(ResourceType6 = Network2.ResourceType || (Network2.ResourceType = {}));
  let ErrorReason;
  ((ErrorReason2) => {
    ErrorReason2["Failed"] = "Failed";
    ErrorReason2["Aborted"] = "Aborted";
    ErrorReason2["TimedOut"] = "TimedOut";
    ErrorReason2["AccessDenied"] = "AccessDenied";
    ErrorReason2["ConnectionClosed"] = "ConnectionClosed";
    ErrorReason2["ConnectionReset"] = "ConnectionReset";
    ErrorReason2["ConnectionRefused"] = "ConnectionRefused";
    ErrorReason2["ConnectionAborted"] = "ConnectionAborted";
    ErrorReason2["ConnectionFailed"] = "ConnectionFailed";
    ErrorReason2["NameNotResolved"] = "NameNotResolved";
    ErrorReason2["InternetDisconnected"] = "InternetDisconnected";
    ErrorReason2["AddressUnreachable"] = "AddressUnreachable";
    ErrorReason2["BlockedByClient"] = "BlockedByClient";
    ErrorReason2["BlockedByResponse"] = "BlockedByResponse";
  })(ErrorReason = Network2.ErrorReason || (Network2.ErrorReason = {}));
  let ConnectionType;
  ((ConnectionType2) => {
    ConnectionType2["None"] = "none";
    ConnectionType2["Cellular2g"] = "cellular2g";
    ConnectionType2["Cellular3g"] = "cellular3g";
    ConnectionType2["Cellular4g"] = "cellular4g";
    ConnectionType2["Bluetooth"] = "bluetooth";
    ConnectionType2["Ethernet"] = "ethernet";
    ConnectionType2["Wifi"] = "wifi";
    ConnectionType2["Wimax"] = "wimax";
    ConnectionType2["Other"] = "other";
  })(ConnectionType = Network2.ConnectionType || (Network2.ConnectionType = {}));
  let CookieSameSite;
  ((CookieSameSite2) => {
    CookieSameSite2["Strict"] = "Strict";
    CookieSameSite2["Lax"] = "Lax";
    CookieSameSite2["None"] = "None";
  })(CookieSameSite = Network2.CookieSameSite || (Network2.CookieSameSite = {}));
  let CookiePriority;
  ((CookiePriority2) => {
    CookiePriority2["Low"] = "Low";
    CookiePriority2["Medium"] = "Medium";
    CookiePriority2["High"] = "High";
  })(CookiePriority = Network2.CookiePriority || (Network2.CookiePriority = {}));
  let CookieSourceScheme;
  ((CookieSourceScheme2) => {
    CookieSourceScheme2["Unset"] = "Unset";
    CookieSourceScheme2["NonSecure"] = "NonSecure";
    CookieSourceScheme2["Secure"] = "Secure";
  })(CookieSourceScheme = Network2.CookieSourceScheme || (Network2.CookieSourceScheme = {}));
  let ResourcePriority;
  ((ResourcePriority2) => {
    ResourcePriority2["VeryLow"] = "VeryLow";
    ResourcePriority2["Low"] = "Low";
    ResourcePriority2["Medium"] = "Medium";
    ResourcePriority2["High"] = "High";
    ResourcePriority2["VeryHigh"] = "VeryHigh";
  })(ResourcePriority = Network2.ResourcePriority || (Network2.ResourcePriority = {}));
  let RequestReferrerPolicy;
  ((RequestReferrerPolicy2) => {
    RequestReferrerPolicy2["UnsafeUrl"] = "unsafe-url";
    RequestReferrerPolicy2["NoReferrerWhenDowngrade"] = "no-referrer-when-downgrade";
    RequestReferrerPolicy2["NoReferrer"] = "no-referrer";
    RequestReferrerPolicy2["Origin"] = "origin";
    RequestReferrerPolicy2["OriginWhenCrossOrigin"] = "origin-when-cross-origin";
    RequestReferrerPolicy2["SameOrigin"] = "same-origin";
    RequestReferrerPolicy2["StrictOrigin"] = "strict-origin";
    RequestReferrerPolicy2["StrictOriginWhenCrossOrigin"] = "strict-origin-when-cross-origin";
  })(RequestReferrerPolicy = Network2.RequestReferrerPolicy || (Network2.RequestReferrerPolicy = {}));
  let CertificateTransparencyCompliance;
  ((CertificateTransparencyCompliance2) => {
    CertificateTransparencyCompliance2["Unknown"] = "unknown";
    CertificateTransparencyCompliance2["NotCompliant"] = "not-compliant";
    CertificateTransparencyCompliance2["Compliant"] = "compliant";
  })(CertificateTransparencyCompliance = Network2.CertificateTransparencyCompliance || (Network2.CertificateTransparencyCompliance = {}));
  let BlockedReason;
  ((BlockedReason2) => {
    BlockedReason2["Other"] = "other";
    BlockedReason2["Csp"] = "csp";
    BlockedReason2["MixedContent"] = "mixed-content";
    BlockedReason2["Origin"] = "origin";
    BlockedReason2["Inspector"] = "inspector";
    BlockedReason2["Integrity"] = "integrity";
    BlockedReason2["SubresourceFilter"] = "subresource-filter";
    BlockedReason2["ContentType"] = "content-type";
    BlockedReason2["CoepFrameResourceNeedsCoepHeader"] = "coep-frame-resource-needs-coep-header";
    BlockedReason2["CoopSandboxedIframeCannotNavigateToCoopPage"] = "coop-sandboxed-iframe-cannot-navigate-to-coop-page";
    BlockedReason2["CorpNotSameOrigin"] = "corp-not-same-origin";
    BlockedReason2["CorpNotSameOriginAfterDefaultedToSameOriginByCoep"] = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep";
    BlockedReason2["CorpNotSameOriginAfterDefaultedToSameOriginByDip"] = "corp-not-same-origin-after-defaulted-to-same-origin-by-dip";
    BlockedReason2["CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip"] = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip";
    BlockedReason2["CorpNotSameSite"] = "corp-not-same-site";
    BlockedReason2["SriMessageSignatureMismatch"] = "sri-message-signature-mismatch";
  })(BlockedReason = Network2.BlockedReason || (Network2.BlockedReason = {}));
  let IpProxyStatus;
  ((IpProxyStatus2) => {
    IpProxyStatus2["Available"] = "Available";
    IpProxyStatus2["FeatureNotEnabled"] = "FeatureNotEnabled";
    IpProxyStatus2["MaskedDomainListNotEnabled"] = "MaskedDomainListNotEnabled";
    IpProxyStatus2["MaskedDomainListNotPopulated"] = "MaskedDomainListNotPopulated";
    IpProxyStatus2["AuthTokensUnavailable"] = "AuthTokensUnavailable";
    IpProxyStatus2["Unavailable"] = "Unavailable";
    IpProxyStatus2["BypassedByDevTools"] = "BypassedByDevTools";
  })(IpProxyStatus = Network2.IpProxyStatus || (Network2.IpProxyStatus = {}));
  let CorsError;
  ((CorsError2) => {
    CorsError2["DisallowedByMode"] = "DisallowedByMode";
    CorsError2["InvalidResponse"] = "InvalidResponse";
    CorsError2["WildcardOriginNotAllowed"] = "WildcardOriginNotAllowed";
    CorsError2["MissingAllowOriginHeader"] = "MissingAllowOriginHeader";
    CorsError2["MultipleAllowOriginValues"] = "MultipleAllowOriginValues";
    CorsError2["InvalidAllowOriginValue"] = "InvalidAllowOriginValue";
    CorsError2["AllowOriginMismatch"] = "AllowOriginMismatch";
    CorsError2["InvalidAllowCredentials"] = "InvalidAllowCredentials";
    CorsError2["CorsDisabledScheme"] = "CorsDisabledScheme";
    CorsError2["PreflightInvalidStatus"] = "PreflightInvalidStatus";
    CorsError2["PreflightDisallowedRedirect"] = "PreflightDisallowedRedirect";
    CorsError2["PreflightWildcardOriginNotAllowed"] = "PreflightWildcardOriginNotAllowed";
    CorsError2["PreflightMissingAllowOriginHeader"] = "PreflightMissingAllowOriginHeader";
    CorsError2["PreflightMultipleAllowOriginValues"] = "PreflightMultipleAllowOriginValues";
    CorsError2["PreflightInvalidAllowOriginValue"] = "PreflightInvalidAllowOriginValue";
    CorsError2["PreflightAllowOriginMismatch"] = "PreflightAllowOriginMismatch";
    CorsError2["PreflightInvalidAllowCredentials"] = "PreflightInvalidAllowCredentials";
    CorsError2["PreflightMissingAllowExternal"] = "PreflightMissingAllowExternal";
    CorsError2["PreflightInvalidAllowExternal"] = "PreflightInvalidAllowExternal";
    CorsError2["PreflightMissingAllowPrivateNetwork"] = "PreflightMissingAllowPrivateNetwork";
    CorsError2["PreflightInvalidAllowPrivateNetwork"] = "PreflightInvalidAllowPrivateNetwork";
    CorsError2["InvalidAllowMethodsPreflightResponse"] = "InvalidAllowMethodsPreflightResponse";
    CorsError2["InvalidAllowHeadersPreflightResponse"] = "InvalidAllowHeadersPreflightResponse";
    CorsError2["MethodDisallowedByPreflightResponse"] = "MethodDisallowedByPreflightResponse";
    CorsError2["HeaderDisallowedByPreflightResponse"] = "HeaderDisallowedByPreflightResponse";
    CorsError2["RedirectContainsCredentials"] = "RedirectContainsCredentials";
    CorsError2["InsecurePrivateNetwork"] = "InsecurePrivateNetwork";
    CorsError2["InvalidPrivateNetworkAccess"] = "InvalidPrivateNetworkAccess";
    CorsError2["UnexpectedPrivateNetworkAccess"] = "UnexpectedPrivateNetworkAccess";
    CorsError2["NoCorsRedirectModeNotFollow"] = "NoCorsRedirectModeNotFollow";
    CorsError2["PreflightMissingPrivateNetworkAccessId"] = "PreflightMissingPrivateNetworkAccessId";
    CorsError2["PreflightMissingPrivateNetworkAccessName"] = "PreflightMissingPrivateNetworkAccessName";
    CorsError2["PrivateNetworkAccessPermissionUnavailable"] = "PrivateNetworkAccessPermissionUnavailable";
    CorsError2["PrivateNetworkAccessPermissionDenied"] = "PrivateNetworkAccessPermissionDenied";
    CorsError2["LocalNetworkAccessPermissionDenied"] = "LocalNetworkAccessPermissionDenied";
  })(CorsError = Network2.CorsError || (Network2.CorsError = {}));
  let ServiceWorkerResponseSource;
  ((ServiceWorkerResponseSource2) => {
    ServiceWorkerResponseSource2["CacheStorage"] = "cache-storage";
    ServiceWorkerResponseSource2["HttpCache"] = "http-cache";
    ServiceWorkerResponseSource2["FallbackCode"] = "fallback-code";
    ServiceWorkerResponseSource2["Network"] = "network";
  })(ServiceWorkerResponseSource = Network2.ServiceWorkerResponseSource || (Network2.ServiceWorkerResponseSource = {}));
  let TrustTokenParamsRefreshPolicy;
  ((TrustTokenParamsRefreshPolicy2) => {
    TrustTokenParamsRefreshPolicy2["UseCached"] = "UseCached";
    TrustTokenParamsRefreshPolicy2["Refresh"] = "Refresh";
  })(TrustTokenParamsRefreshPolicy = Network2.TrustTokenParamsRefreshPolicy || (Network2.TrustTokenParamsRefreshPolicy = {}));
  let TrustTokenOperationType;
  ((TrustTokenOperationType2) => {
    TrustTokenOperationType2["Issuance"] = "Issuance";
    TrustTokenOperationType2["Redemption"] = "Redemption";
    TrustTokenOperationType2["Signing"] = "Signing";
  })(TrustTokenOperationType = Network2.TrustTokenOperationType || (Network2.TrustTokenOperationType = {}));
  let AlternateProtocolUsage;
  ((AlternateProtocolUsage2) => {
    AlternateProtocolUsage2["AlternativeJobWonWithoutRace"] = "alternativeJobWonWithoutRace";
    AlternateProtocolUsage2["AlternativeJobWonRace"] = "alternativeJobWonRace";
    AlternateProtocolUsage2["MainJobWonRace"] = "mainJobWonRace";
    AlternateProtocolUsage2["MappingMissing"] = "mappingMissing";
    AlternateProtocolUsage2["Broken"] = "broken";
    AlternateProtocolUsage2["DnsAlpnH3JobWonWithoutRace"] = "dnsAlpnH3JobWonWithoutRace";
    AlternateProtocolUsage2["DnsAlpnH3JobWonRace"] = "dnsAlpnH3JobWonRace";
    AlternateProtocolUsage2["UnspecifiedReason"] = "unspecifiedReason";
  })(AlternateProtocolUsage = Network2.AlternateProtocolUsage || (Network2.AlternateProtocolUsage = {}));
  let ServiceWorkerRouterSource;
  ((ServiceWorkerRouterSource2) => {
    ServiceWorkerRouterSource2["Network"] = "network";
    ServiceWorkerRouterSource2["Cache"] = "cache";
    ServiceWorkerRouterSource2["FetchEvent"] = "fetch-event";
    ServiceWorkerRouterSource2["RaceNetworkAndFetchHandler"] = "race-network-and-fetch-handler";
    ServiceWorkerRouterSource2["RaceNetworkAndCache"] = "race-network-and-cache";
  })(ServiceWorkerRouterSource = Network2.ServiceWorkerRouterSource || (Network2.ServiceWorkerRouterSource = {}));
  let InitiatorType;
  ((InitiatorType2) => {
    InitiatorType2["Parser"] = "parser";
    InitiatorType2["Script"] = "script";
    InitiatorType2["Preload"] = "preload";
    InitiatorType2["SignedExchange"] = "SignedExchange";
    InitiatorType2["Preflight"] = "preflight";
    InitiatorType2["FedCM"] = "FedCM";
    InitiatorType2["Other"] = "other";
  })(InitiatorType = Network2.InitiatorType || (Network2.InitiatorType = {}));
  let SetCookieBlockedReason;
  ((SetCookieBlockedReason2) => {
    SetCookieBlockedReason2["SecureOnly"] = "SecureOnly";
    SetCookieBlockedReason2["SameSiteStrict"] = "SameSiteStrict";
    SetCookieBlockedReason2["SameSiteLax"] = "SameSiteLax";
    SetCookieBlockedReason2["SameSiteUnspecifiedTreatedAsLax"] = "SameSiteUnspecifiedTreatedAsLax";
    SetCookieBlockedReason2["SameSiteNoneInsecure"] = "SameSiteNoneInsecure";
    SetCookieBlockedReason2["UserPreferences"] = "UserPreferences";
    SetCookieBlockedReason2["ThirdPartyPhaseout"] = "ThirdPartyPhaseout";
    SetCookieBlockedReason2["ThirdPartyBlockedInFirstPartySet"] = "ThirdPartyBlockedInFirstPartySet";
    SetCookieBlockedReason2["SyntaxError"] = "SyntaxError";
    SetCookieBlockedReason2["SchemeNotSupported"] = "SchemeNotSupported";
    SetCookieBlockedReason2["OverwriteSecure"] = "OverwriteSecure";
    SetCookieBlockedReason2["InvalidDomain"] = "InvalidDomain";
    SetCookieBlockedReason2["InvalidPrefix"] = "InvalidPrefix";
    SetCookieBlockedReason2["UnknownError"] = "UnknownError";
    SetCookieBlockedReason2["SchemefulSameSiteStrict"] = "SchemefulSameSiteStrict";
    SetCookieBlockedReason2["SchemefulSameSiteLax"] = "SchemefulSameSiteLax";
    SetCookieBlockedReason2["SchemefulSameSiteUnspecifiedTreatedAsLax"] = "SchemefulSameSiteUnspecifiedTreatedAsLax";
    SetCookieBlockedReason2["SamePartyFromCrossPartyContext"] = "SamePartyFromCrossPartyContext";
    SetCookieBlockedReason2["SamePartyConflictsWithOtherAttributes"] = "SamePartyConflictsWithOtherAttributes";
    SetCookieBlockedReason2["NameValuePairExceedsMaxSize"] = "NameValuePairExceedsMaxSize";
    SetCookieBlockedReason2["DisallowedCharacter"] = "DisallowedCharacter";
    SetCookieBlockedReason2["NoCookieContent"] = "NoCookieContent";
  })(SetCookieBlockedReason = Network2.SetCookieBlockedReason || (Network2.SetCookieBlockedReason = {}));
  let CookieBlockedReason;
  ((CookieBlockedReason2) => {
    CookieBlockedReason2["SecureOnly"] = "SecureOnly";
    CookieBlockedReason2["NotOnPath"] = "NotOnPath";
    CookieBlockedReason2["DomainMismatch"] = "DomainMismatch";
    CookieBlockedReason2["SameSiteStrict"] = "SameSiteStrict";
    CookieBlockedReason2["SameSiteLax"] = "SameSiteLax";
    CookieBlockedReason2["SameSiteUnspecifiedTreatedAsLax"] = "SameSiteUnspecifiedTreatedAsLax";
    CookieBlockedReason2["SameSiteNoneInsecure"] = "SameSiteNoneInsecure";
    CookieBlockedReason2["UserPreferences"] = "UserPreferences";
    CookieBlockedReason2["ThirdPartyPhaseout"] = "ThirdPartyPhaseout";
    CookieBlockedReason2["ThirdPartyBlockedInFirstPartySet"] = "ThirdPartyBlockedInFirstPartySet";
    CookieBlockedReason2["UnknownError"] = "UnknownError";
    CookieBlockedReason2["SchemefulSameSiteStrict"] = "SchemefulSameSiteStrict";
    CookieBlockedReason2["SchemefulSameSiteLax"] = "SchemefulSameSiteLax";
    CookieBlockedReason2["SchemefulSameSiteUnspecifiedTreatedAsLax"] = "SchemefulSameSiteUnspecifiedTreatedAsLax";
    CookieBlockedReason2["SamePartyFromCrossPartyContext"] = "SamePartyFromCrossPartyContext";
    CookieBlockedReason2["NameValuePairExceedsMaxSize"] = "NameValuePairExceedsMaxSize";
    CookieBlockedReason2["PortMismatch"] = "PortMismatch";
    CookieBlockedReason2["SchemeMismatch"] = "SchemeMismatch";
    CookieBlockedReason2["AnonymousContext"] = "AnonymousContext";
  })(CookieBlockedReason = Network2.CookieBlockedReason || (Network2.CookieBlockedReason = {}));
  let CookieExemptionReason;
  ((CookieExemptionReason2) => {
    CookieExemptionReason2["None"] = "None";
    CookieExemptionReason2["UserSetting"] = "UserSetting";
    CookieExemptionReason2["TPCDMetadata"] = "TPCDMetadata";
    CookieExemptionReason2["TPCDDeprecationTrial"] = "TPCDDeprecationTrial";
    CookieExemptionReason2["TopLevelTPCDDeprecationTrial"] = "TopLevelTPCDDeprecationTrial";
    CookieExemptionReason2["TPCDHeuristics"] = "TPCDHeuristics";
    CookieExemptionReason2["EnterprisePolicy"] = "EnterprisePolicy";
    CookieExemptionReason2["StorageAccess"] = "StorageAccess";
    CookieExemptionReason2["TopLevelStorageAccess"] = "TopLevelStorageAccess";
    CookieExemptionReason2["Scheme"] = "Scheme";
    CookieExemptionReason2["SameSiteNoneCookiesInSandbox"] = "SameSiteNoneCookiesInSandbox";
  })(CookieExemptionReason = Network2.CookieExemptionReason || (Network2.CookieExemptionReason = {}));
  let AuthChallengeSource;
  ((AuthChallengeSource2) => {
    AuthChallengeSource2["Server"] = "Server";
    AuthChallengeSource2["Proxy"] = "Proxy";
  })(AuthChallengeSource = Network2.AuthChallengeSource || (Network2.AuthChallengeSource = {}));
  let AuthChallengeResponseResponse;
  ((AuthChallengeResponseResponse2) => {
    AuthChallengeResponseResponse2["Default"] = "Default";
    AuthChallengeResponseResponse2["CancelAuth"] = "CancelAuth";
    AuthChallengeResponseResponse2["ProvideCredentials"] = "ProvideCredentials";
  })(AuthChallengeResponseResponse = Network2.AuthChallengeResponseResponse || (Network2.AuthChallengeResponseResponse = {}));
  let InterceptionStage;
  ((InterceptionStage2) => {
    InterceptionStage2["Request"] = "Request";
    InterceptionStage2["HeadersReceived"] = "HeadersReceived";
  })(InterceptionStage = Network2.InterceptionStage || (Network2.InterceptionStage = {}));
  let SignedExchangeErrorField;
  ((SignedExchangeErrorField2) => {
    SignedExchangeErrorField2["SignatureSig"] = "signatureSig";
    SignedExchangeErrorField2["SignatureIntegrity"] = "signatureIntegrity";
    SignedExchangeErrorField2["SignatureCertUrl"] = "signatureCertUrl";
    SignedExchangeErrorField2["SignatureCertSha256"] = "signatureCertSha256";
    SignedExchangeErrorField2["SignatureValidityUrl"] = "signatureValidityUrl";
    SignedExchangeErrorField2["SignatureTimestamps"] = "signatureTimestamps";
  })(SignedExchangeErrorField = Network2.SignedExchangeErrorField || (Network2.SignedExchangeErrorField = {}));
  let ContentEncoding;
  ((ContentEncoding2) => {
    ContentEncoding2["Deflate"] = "deflate";
    ContentEncoding2["Gzip"] = "gzip";
    ContentEncoding2["Br"] = "br";
    ContentEncoding2["Zstd"] = "zstd";
  })(ContentEncoding = Network2.ContentEncoding || (Network2.ContentEncoding = {}));
  let DirectSocketDnsQueryType;
  ((DirectSocketDnsQueryType2) => {
    DirectSocketDnsQueryType2["Ipv4"] = "ipv4";
    DirectSocketDnsQueryType2["Ipv6"] = "ipv6";
  })(DirectSocketDnsQueryType = Network2.DirectSocketDnsQueryType || (Network2.DirectSocketDnsQueryType = {}));
  let PrivateNetworkRequestPolicy;
  ((PrivateNetworkRequestPolicy2) => {
    PrivateNetworkRequestPolicy2["Allow"] = "Allow";
    PrivateNetworkRequestPolicy2["BlockFromInsecureToMorePrivate"] = "BlockFromInsecureToMorePrivate";
    PrivateNetworkRequestPolicy2["WarnFromInsecureToMorePrivate"] = "WarnFromInsecureToMorePrivate";
    PrivateNetworkRequestPolicy2["PreflightBlock"] = "PreflightBlock";
    PrivateNetworkRequestPolicy2["PreflightWarn"] = "PreflightWarn";
    PrivateNetworkRequestPolicy2["PermissionBlock"] = "PermissionBlock";
    PrivateNetworkRequestPolicy2["PermissionWarn"] = "PermissionWarn";
  })(PrivateNetworkRequestPolicy = Network2.PrivateNetworkRequestPolicy || (Network2.PrivateNetworkRequestPolicy = {}));
  let IPAddressSpace;
  ((IPAddressSpace2) => {
    IPAddressSpace2["Loopback"] = "Loopback";
    IPAddressSpace2["Local"] = "Local";
    IPAddressSpace2["Public"] = "Public";
    IPAddressSpace2["Unknown"] = "Unknown";
  })(IPAddressSpace = Network2.IPAddressSpace || (Network2.IPAddressSpace = {}));
  let CrossOriginOpenerPolicyValue;
  ((CrossOriginOpenerPolicyValue2) => {
    CrossOriginOpenerPolicyValue2["SameOrigin"] = "SameOrigin";
    CrossOriginOpenerPolicyValue2["SameOriginAllowPopups"] = "SameOriginAllowPopups";
    CrossOriginOpenerPolicyValue2["RestrictProperties"] = "RestrictProperties";
    CrossOriginOpenerPolicyValue2["UnsafeNone"] = "UnsafeNone";
    CrossOriginOpenerPolicyValue2["SameOriginPlusCoep"] = "SameOriginPlusCoep";
    CrossOriginOpenerPolicyValue2["RestrictPropertiesPlusCoep"] = "RestrictPropertiesPlusCoep";
    CrossOriginOpenerPolicyValue2["NoopenerAllowPopups"] = "NoopenerAllowPopups";
  })(CrossOriginOpenerPolicyValue = Network2.CrossOriginOpenerPolicyValue || (Network2.CrossOriginOpenerPolicyValue = {}));
  let CrossOriginEmbedderPolicyValue;
  ((CrossOriginEmbedderPolicyValue2) => {
    CrossOriginEmbedderPolicyValue2["None"] = "None";
    CrossOriginEmbedderPolicyValue2["Credentialless"] = "Credentialless";
    CrossOriginEmbedderPolicyValue2["RequireCorp"] = "RequireCorp";
  })(CrossOriginEmbedderPolicyValue = Network2.CrossOriginEmbedderPolicyValue || (Network2.CrossOriginEmbedderPolicyValue = {}));
  let ContentSecurityPolicySource;
  ((ContentSecurityPolicySource2) => {
    ContentSecurityPolicySource2["HTTP"] = "HTTP";
    ContentSecurityPolicySource2["Meta"] = "Meta";
  })(ContentSecurityPolicySource = Network2.ContentSecurityPolicySource || (Network2.ContentSecurityPolicySource = {}));
  let ReportStatus;
  ((ReportStatus2) => {
    ReportStatus2["Queued"] = "Queued";
    ReportStatus2["Pending"] = "Pending";
    ReportStatus2["MarkedForRemoval"] = "MarkedForRemoval";
    ReportStatus2["Success"] = "Success";
  })(ReportStatus = Network2.ReportStatus || (Network2.ReportStatus = {}));
  let TrustTokenOperationDoneEventStatus;
  ((TrustTokenOperationDoneEventStatus2) => {
    TrustTokenOperationDoneEventStatus2["Ok"] = "Ok";
    TrustTokenOperationDoneEventStatus2["InvalidArgument"] = "InvalidArgument";
    TrustTokenOperationDoneEventStatus2["MissingIssuerKeys"] = "MissingIssuerKeys";
    TrustTokenOperationDoneEventStatus2["FailedPrecondition"] = "FailedPrecondition";
    TrustTokenOperationDoneEventStatus2["ResourceExhausted"] = "ResourceExhausted";
    TrustTokenOperationDoneEventStatus2["AlreadyExists"] = "AlreadyExists";
    TrustTokenOperationDoneEventStatus2["ResourceLimited"] = "ResourceLimited";
    TrustTokenOperationDoneEventStatus2["Unauthorized"] = "Unauthorized";
    TrustTokenOperationDoneEventStatus2["BadResponse"] = "BadResponse";
    TrustTokenOperationDoneEventStatus2["InternalError"] = "InternalError";
    TrustTokenOperationDoneEventStatus2["UnknownError"] = "UnknownError";
    TrustTokenOperationDoneEventStatus2["FulfilledLocally"] = "FulfilledLocally";
    TrustTokenOperationDoneEventStatus2["SiteIssuerLimit"] = "SiteIssuerLimit";
  })(TrustTokenOperationDoneEventStatus = Network2.TrustTokenOperationDoneEventStatus || (Network2.TrustTokenOperationDoneEventStatus = {}));
})(Network || (Network = {}));
var Overlay;
((Overlay2) => {
  let LineStylePattern;
  ((LineStylePattern2) => {
    LineStylePattern2["Dashed"] = "dashed";
    LineStylePattern2["Dotted"] = "dotted";
  })(LineStylePattern = Overlay2.LineStylePattern || (Overlay2.LineStylePattern = {}));
  let ContrastAlgorithm;
  ((ContrastAlgorithm2) => {
    ContrastAlgorithm2["Aa"] = "aa";
    ContrastAlgorithm2["Aaa"] = "aaa";
    ContrastAlgorithm2["Apca"] = "apca";
  })(ContrastAlgorithm = Overlay2.ContrastAlgorithm || (Overlay2.ContrastAlgorithm = {}));
  let ColorFormat;
  ((ColorFormat2) => {
    ColorFormat2["Rgb"] = "rgb";
    ColorFormat2["Hsl"] = "hsl";
    ColorFormat2["Hwb"] = "hwb";
    ColorFormat2["Hex"] = "hex";
  })(ColorFormat = Overlay2.ColorFormat || (Overlay2.ColorFormat = {}));
  let InspectMode;
  ((InspectMode2) => {
    InspectMode2["SearchForNode"] = "searchForNode";
    InspectMode2["SearchForUAShadowDOM"] = "searchForUAShadowDOM";
    InspectMode2["CaptureAreaScreenshot"] = "captureAreaScreenshot";
    InspectMode2["None"] = "none";
  })(InspectMode = Overlay2.InspectMode || (Overlay2.InspectMode = {}));
})(Overlay || (Overlay = {}));
var PWA;
((PWA2) => {
  let DisplayMode;
  ((DisplayMode2) => {
    DisplayMode2["Standalone"] = "standalone";
    DisplayMode2["Browser"] = "browser";
  })(DisplayMode = PWA2.DisplayMode || (PWA2.DisplayMode = {}));
})(PWA || (PWA = {}));
var Page;
((Page2) => {
  let AdFrameType;
  ((AdFrameType2) => {
    AdFrameType2["None"] = "none";
    AdFrameType2["Child"] = "child";
    AdFrameType2["Root"] = "root";
  })(AdFrameType = Page2.AdFrameType || (Page2.AdFrameType = {}));
  let AdFrameExplanation;
  ((AdFrameExplanation2) => {
    AdFrameExplanation2["ParentIsAd"] = "ParentIsAd";
    AdFrameExplanation2["CreatedByAdScript"] = "CreatedByAdScript";
    AdFrameExplanation2["MatchedBlockingRule"] = "MatchedBlockingRule";
  })(AdFrameExplanation = Page2.AdFrameExplanation || (Page2.AdFrameExplanation = {}));
  let SecureContextType;
  ((SecureContextType2) => {
    SecureContextType2["Secure"] = "Secure";
    SecureContextType2["SecureLocalhost"] = "SecureLocalhost";
    SecureContextType2["InsecureScheme"] = "InsecureScheme";
    SecureContextType2["InsecureAncestor"] = "InsecureAncestor";
  })(SecureContextType = Page2.SecureContextType || (Page2.SecureContextType = {}));
  let CrossOriginIsolatedContextType;
  ((CrossOriginIsolatedContextType2) => {
    CrossOriginIsolatedContextType2["Isolated"] = "Isolated";
    CrossOriginIsolatedContextType2["NotIsolated"] = "NotIsolated";
    CrossOriginIsolatedContextType2["NotIsolatedFeatureDisabled"] = "NotIsolatedFeatureDisabled";
  })(CrossOriginIsolatedContextType = Page2.CrossOriginIsolatedContextType || (Page2.CrossOriginIsolatedContextType = {}));
  let GatedAPIFeatures;
  ((GatedAPIFeatures2) => {
    GatedAPIFeatures2["SharedArrayBuffers"] = "SharedArrayBuffers";
    GatedAPIFeatures2["SharedArrayBuffersTransferAllowed"] = "SharedArrayBuffersTransferAllowed";
    GatedAPIFeatures2["PerformanceMeasureMemory"] = "PerformanceMeasureMemory";
    GatedAPIFeatures2["PerformanceProfile"] = "PerformanceProfile";
  })(GatedAPIFeatures = Page2.GatedAPIFeatures || (Page2.GatedAPIFeatures = {}));
  let PermissionsPolicyFeature;
  ((PermissionsPolicyFeature2) => {
    PermissionsPolicyFeature2["Accelerometer"] = "accelerometer";
    PermissionsPolicyFeature2["AllScreensCapture"] = "all-screens-capture";
    PermissionsPolicyFeature2["AmbientLightSensor"] = "ambient-light-sensor";
    PermissionsPolicyFeature2["AriaNotify"] = "aria-notify";
    PermissionsPolicyFeature2["AttributionReporting"] = "attribution-reporting";
    PermissionsPolicyFeature2["Autoplay"] = "autoplay";
    PermissionsPolicyFeature2["Bluetooth"] = "bluetooth";
    PermissionsPolicyFeature2["BrowsingTopics"] = "browsing-topics";
    PermissionsPolicyFeature2["Camera"] = "camera";
    PermissionsPolicyFeature2["CapturedSurfaceControl"] = "captured-surface-control";
    PermissionsPolicyFeature2["ChDpr"] = "ch-dpr";
    PermissionsPolicyFeature2["ChDeviceMemory"] = "ch-device-memory";
    PermissionsPolicyFeature2["ChDownlink"] = "ch-downlink";
    PermissionsPolicyFeature2["ChEct"] = "ch-ect";
    PermissionsPolicyFeature2["ChPrefersColorScheme"] = "ch-prefers-color-scheme";
    PermissionsPolicyFeature2["ChPrefersReducedMotion"] = "ch-prefers-reduced-motion";
    PermissionsPolicyFeature2["ChPrefersReducedTransparency"] = "ch-prefers-reduced-transparency";
    PermissionsPolicyFeature2["ChRtt"] = "ch-rtt";
    PermissionsPolicyFeature2["ChSaveData"] = "ch-save-data";
    PermissionsPolicyFeature2["ChUa"] = "ch-ua";
    PermissionsPolicyFeature2["ChUaArch"] = "ch-ua-arch";
    PermissionsPolicyFeature2["ChUaBitness"] = "ch-ua-bitness";
    PermissionsPolicyFeature2["ChUaHighEntropyValues"] = "ch-ua-high-entropy-values";
    PermissionsPolicyFeature2["ChUaPlatform"] = "ch-ua-platform";
    PermissionsPolicyFeature2["ChUaModel"] = "ch-ua-model";
    PermissionsPolicyFeature2["ChUaMobile"] = "ch-ua-mobile";
    PermissionsPolicyFeature2["ChUaFormFactors"] = "ch-ua-form-factors";
    PermissionsPolicyFeature2["ChUaFullVersion"] = "ch-ua-full-version";
    PermissionsPolicyFeature2["ChUaFullVersionList"] = "ch-ua-full-version-list";
    PermissionsPolicyFeature2["ChUaPlatformVersion"] = "ch-ua-platform-version";
    PermissionsPolicyFeature2["ChUaWow64"] = "ch-ua-wow64";
    PermissionsPolicyFeature2["ChViewportHeight"] = "ch-viewport-height";
    PermissionsPolicyFeature2["ChViewportWidth"] = "ch-viewport-width";
    PermissionsPolicyFeature2["ChWidth"] = "ch-width";
    PermissionsPolicyFeature2["ClipboardRead"] = "clipboard-read";
    PermissionsPolicyFeature2["ClipboardWrite"] = "clipboard-write";
    PermissionsPolicyFeature2["ComputePressure"] = "compute-pressure";
    PermissionsPolicyFeature2["ControlledFrame"] = "controlled-frame";
    PermissionsPolicyFeature2["CrossOriginIsolated"] = "cross-origin-isolated";
    PermissionsPolicyFeature2["DeferredFetch"] = "deferred-fetch";
    PermissionsPolicyFeature2["DeferredFetchMinimal"] = "deferred-fetch-minimal";
    PermissionsPolicyFeature2["DeviceAttributes"] = "device-attributes";
    PermissionsPolicyFeature2["DigitalCredentialsCreate"] = "digital-credentials-create";
    PermissionsPolicyFeature2["DigitalCredentialsGet"] = "digital-credentials-get";
    PermissionsPolicyFeature2["DirectSockets"] = "direct-sockets";
    PermissionsPolicyFeature2["DirectSocketsMulticast"] = "direct-sockets-multicast";
    PermissionsPolicyFeature2["DirectSocketsPrivate"] = "direct-sockets-private";
    PermissionsPolicyFeature2["DisplayCapture"] = "display-capture";
    PermissionsPolicyFeature2["DocumentDomain"] = "document-domain";
    PermissionsPolicyFeature2["EncryptedMedia"] = "encrypted-media";
    PermissionsPolicyFeature2["ExecutionWhileOutOfViewport"] = "execution-while-out-of-viewport";
    PermissionsPolicyFeature2["ExecutionWhileNotRendered"] = "execution-while-not-rendered";
    PermissionsPolicyFeature2["FencedUnpartitionedStorageRead"] = "fenced-unpartitioned-storage-read";
    PermissionsPolicyFeature2["FocusWithoutUserActivation"] = "focus-without-user-activation";
    PermissionsPolicyFeature2["Fullscreen"] = "fullscreen";
    PermissionsPolicyFeature2["Frobulate"] = "frobulate";
    PermissionsPolicyFeature2["Gamepad"] = "gamepad";
    PermissionsPolicyFeature2["Geolocation"] = "geolocation";
    PermissionsPolicyFeature2["Gyroscope"] = "gyroscope";
    PermissionsPolicyFeature2["Hid"] = "hid";
    PermissionsPolicyFeature2["IdentityCredentialsGet"] = "identity-credentials-get";
    PermissionsPolicyFeature2["IdleDetection"] = "idle-detection";
    PermissionsPolicyFeature2["InterestCohort"] = "interest-cohort";
    PermissionsPolicyFeature2["JoinAdInterestGroup"] = "join-ad-interest-group";
    PermissionsPolicyFeature2["KeyboardMap"] = "keyboard-map";
    PermissionsPolicyFeature2["LanguageDetector"] = "language-detector";
    PermissionsPolicyFeature2["LanguageModel"] = "language-model";
    PermissionsPolicyFeature2["LocalFonts"] = "local-fonts";
    PermissionsPolicyFeature2["LocalNetworkAccess"] = "local-network-access";
    PermissionsPolicyFeature2["Magnetometer"] = "magnetometer";
    PermissionsPolicyFeature2["MediaPlaybackWhileNotVisible"] = "media-playback-while-not-visible";
    PermissionsPolicyFeature2["Microphone"] = "microphone";
    PermissionsPolicyFeature2["Midi"] = "midi";
    PermissionsPolicyFeature2["OnDeviceSpeechRecognition"] = "on-device-speech-recognition";
    PermissionsPolicyFeature2["OtpCredentials"] = "otp-credentials";
    PermissionsPolicyFeature2["Payment"] = "payment";
    PermissionsPolicyFeature2["PictureInPicture"] = "picture-in-picture";
    PermissionsPolicyFeature2["Popins"] = "popins";
    PermissionsPolicyFeature2["PrivateAggregation"] = "private-aggregation";
    PermissionsPolicyFeature2["PrivateStateTokenIssuance"] = "private-state-token-issuance";
    PermissionsPolicyFeature2["PrivateStateTokenRedemption"] = "private-state-token-redemption";
    PermissionsPolicyFeature2["PublickeyCredentialsCreate"] = "publickey-credentials-create";
    PermissionsPolicyFeature2["PublickeyCredentialsGet"] = "publickey-credentials-get";
    PermissionsPolicyFeature2["RecordAdAuctionEvents"] = "record-ad-auction-events";
    PermissionsPolicyFeature2["Rewriter"] = "rewriter";
    PermissionsPolicyFeature2["RunAdAuction"] = "run-ad-auction";
    PermissionsPolicyFeature2["ScreenWakeLock"] = "screen-wake-lock";
    PermissionsPolicyFeature2["Serial"] = "serial";
    PermissionsPolicyFeature2["SharedAutofill"] = "shared-autofill";
    PermissionsPolicyFeature2["SharedStorage"] = "shared-storage";
    PermissionsPolicyFeature2["SharedStorageSelectUrl"] = "shared-storage-select-url";
    PermissionsPolicyFeature2["SmartCard"] = "smart-card";
    PermissionsPolicyFeature2["SpeakerSelection"] = "speaker-selection";
    PermissionsPolicyFeature2["StorageAccess"] = "storage-access";
    PermissionsPolicyFeature2["SubApps"] = "sub-apps";
    PermissionsPolicyFeature2["Summarizer"] = "summarizer";
    PermissionsPolicyFeature2["SyncXhr"] = "sync-xhr";
    PermissionsPolicyFeature2["Translator"] = "translator";
    PermissionsPolicyFeature2["Unload"] = "unload";
    PermissionsPolicyFeature2["Usb"] = "usb";
    PermissionsPolicyFeature2["UsbUnrestricted"] = "usb-unrestricted";
    PermissionsPolicyFeature2["VerticalScroll"] = "vertical-scroll";
    PermissionsPolicyFeature2["WebAppInstallation"] = "web-app-installation";
    PermissionsPolicyFeature2["WebPrinting"] = "web-printing";
    PermissionsPolicyFeature2["WebShare"] = "web-share";
    PermissionsPolicyFeature2["WindowManagement"] = "window-management";
    PermissionsPolicyFeature2["Writer"] = "writer";
    PermissionsPolicyFeature2["XrSpatialTracking"] = "xr-spatial-tracking";
  })(PermissionsPolicyFeature = Page2.PermissionsPolicyFeature || (Page2.PermissionsPolicyFeature = {}));
  let PermissionsPolicyBlockReason;
  ((PermissionsPolicyBlockReason2) => {
    PermissionsPolicyBlockReason2["Header"] = "Header";
    PermissionsPolicyBlockReason2["IframeAttribute"] = "IframeAttribute";
    PermissionsPolicyBlockReason2["InFencedFrameTree"] = "InFencedFrameTree";
    PermissionsPolicyBlockReason2["InIsolatedApp"] = "InIsolatedApp";
  })(PermissionsPolicyBlockReason = Page2.PermissionsPolicyBlockReason || (Page2.PermissionsPolicyBlockReason = {}));
  let OriginTrialTokenStatus;
  ((OriginTrialTokenStatus2) => {
    OriginTrialTokenStatus2["Success"] = "Success";
    OriginTrialTokenStatus2["NotSupported"] = "NotSupported";
    OriginTrialTokenStatus2["Insecure"] = "Insecure";
    OriginTrialTokenStatus2["Expired"] = "Expired";
    OriginTrialTokenStatus2["WrongOrigin"] = "WrongOrigin";
    OriginTrialTokenStatus2["InvalidSignature"] = "InvalidSignature";
    OriginTrialTokenStatus2["Malformed"] = "Malformed";
    OriginTrialTokenStatus2["WrongVersion"] = "WrongVersion";
    OriginTrialTokenStatus2["FeatureDisabled"] = "FeatureDisabled";
    OriginTrialTokenStatus2["TokenDisabled"] = "TokenDisabled";
    OriginTrialTokenStatus2["FeatureDisabledForUser"] = "FeatureDisabledForUser";
    OriginTrialTokenStatus2["UnknownTrial"] = "UnknownTrial";
  })(OriginTrialTokenStatus = Page2.OriginTrialTokenStatus || (Page2.OriginTrialTokenStatus = {}));
  let OriginTrialStatus;
  ((OriginTrialStatus2) => {
    OriginTrialStatus2["Enabled"] = "Enabled";
    OriginTrialStatus2["ValidTokenNotProvided"] = "ValidTokenNotProvided";
    OriginTrialStatus2["OSNotSupported"] = "OSNotSupported";
    OriginTrialStatus2["TrialNotAllowed"] = "TrialNotAllowed";
  })(OriginTrialStatus = Page2.OriginTrialStatus || (Page2.OriginTrialStatus = {}));
  let OriginTrialUsageRestriction;
  ((OriginTrialUsageRestriction2) => {
    OriginTrialUsageRestriction2["None"] = "None";
    OriginTrialUsageRestriction2["Subset"] = "Subset";
  })(OriginTrialUsageRestriction = Page2.OriginTrialUsageRestriction || (Page2.OriginTrialUsageRestriction = {}));
  let TransitionType;
  ((TransitionType2) => {
    TransitionType2["Link"] = "link";
    TransitionType2["Typed"] = "typed";
    TransitionType2["Address_bar"] = "address_bar";
    TransitionType2["Auto_bookmark"] = "auto_bookmark";
    TransitionType2["Auto_subframe"] = "auto_subframe";
    TransitionType2["Manual_subframe"] = "manual_subframe";
    TransitionType2["Generated"] = "generated";
    TransitionType2["Auto_toplevel"] = "auto_toplevel";
    TransitionType2["Form_submit"] = "form_submit";
    TransitionType2["Reload"] = "reload";
    TransitionType2["Keyword"] = "keyword";
    TransitionType2["Keyword_generated"] = "keyword_generated";
    TransitionType2["Other"] = "other";
  })(TransitionType = Page2.TransitionType || (Page2.TransitionType = {}));
  let DialogType;
  ((DialogType2) => {
    DialogType2["Alert"] = "alert";
    DialogType2["Confirm"] = "confirm";
    DialogType2["Prompt"] = "prompt";
    DialogType2["Beforeunload"] = "beforeunload";
  })(DialogType = Page2.DialogType || (Page2.DialogType = {}));
  let ClientNavigationReason;
  ((ClientNavigationReason2) => {
    ClientNavigationReason2["AnchorClick"] = "anchorClick";
    ClientNavigationReason2["FormSubmissionGet"] = "formSubmissionGet";
    ClientNavigationReason2["FormSubmissionPost"] = "formSubmissionPost";
    ClientNavigationReason2["HttpHeaderRefresh"] = "httpHeaderRefresh";
    ClientNavigationReason2["InitialFrameNavigation"] = "initialFrameNavigation";
    ClientNavigationReason2["MetaTagRefresh"] = "metaTagRefresh";
    ClientNavigationReason2["Other"] = "other";
    ClientNavigationReason2["PageBlockInterstitial"] = "pageBlockInterstitial";
    ClientNavigationReason2["Reload"] = "reload";
    ClientNavigationReason2["ScriptInitiated"] = "scriptInitiated";
  })(ClientNavigationReason = Page2.ClientNavigationReason || (Page2.ClientNavigationReason = {}));
  let ClientNavigationDisposition;
  ((ClientNavigationDisposition2) => {
    ClientNavigationDisposition2["CurrentTab"] = "currentTab";
    ClientNavigationDisposition2["NewTab"] = "newTab";
    ClientNavigationDisposition2["NewWindow"] = "newWindow";
    ClientNavigationDisposition2["Download"] = "download";
  })(ClientNavigationDisposition = Page2.ClientNavigationDisposition || (Page2.ClientNavigationDisposition = {}));
  let ReferrerPolicy;
  ((ReferrerPolicy2) => {
    ReferrerPolicy2["NoReferrer"] = "noReferrer";
    ReferrerPolicy2["NoReferrerWhenDowngrade"] = "noReferrerWhenDowngrade";
    ReferrerPolicy2["Origin"] = "origin";
    ReferrerPolicy2["OriginWhenCrossOrigin"] = "originWhenCrossOrigin";
    ReferrerPolicy2["SameOrigin"] = "sameOrigin";
    ReferrerPolicy2["StrictOrigin"] = "strictOrigin";
    ReferrerPolicy2["StrictOriginWhenCrossOrigin"] = "strictOriginWhenCrossOrigin";
    ReferrerPolicy2["UnsafeUrl"] = "unsafeUrl";
  })(ReferrerPolicy = Page2.ReferrerPolicy || (Page2.ReferrerPolicy = {}));
  let NavigationType;
  ((NavigationType2) => {
    NavigationType2["Navigation"] = "Navigation";
    NavigationType2["BackForwardCacheRestore"] = "BackForwardCacheRestore";
  })(NavigationType = Page2.NavigationType || (Page2.NavigationType = {}));
  let BackForwardCacheNotRestoredReason;
  ((BackForwardCacheNotRestoredReason2) => {
    BackForwardCacheNotRestoredReason2["NotPrimaryMainFrame"] = "NotPrimaryMainFrame";
    BackForwardCacheNotRestoredReason2["BackForwardCacheDisabled"] = "BackForwardCacheDisabled";
    BackForwardCacheNotRestoredReason2["RelatedActiveContentsExist"] = "RelatedActiveContentsExist";
    BackForwardCacheNotRestoredReason2["HTTPStatusNotOK"] = "HTTPStatusNotOK";
    BackForwardCacheNotRestoredReason2["SchemeNotHTTPOrHTTPS"] = "SchemeNotHTTPOrHTTPS";
    BackForwardCacheNotRestoredReason2["Loading"] = "Loading";
    BackForwardCacheNotRestoredReason2["WasGrantedMediaAccess"] = "WasGrantedMediaAccess";
    BackForwardCacheNotRestoredReason2["DisableForRenderFrameHostCalled"] = "DisableForRenderFrameHostCalled";
    BackForwardCacheNotRestoredReason2["DomainNotAllowed"] = "DomainNotAllowed";
    BackForwardCacheNotRestoredReason2["HTTPMethodNotGET"] = "HTTPMethodNotGET";
    BackForwardCacheNotRestoredReason2["SubframeIsNavigating"] = "SubframeIsNavigating";
    BackForwardCacheNotRestoredReason2["Timeout"] = "Timeout";
    BackForwardCacheNotRestoredReason2["CacheLimit"] = "CacheLimit";
    BackForwardCacheNotRestoredReason2["JavaScriptExecution"] = "JavaScriptExecution";
    BackForwardCacheNotRestoredReason2["RendererProcessKilled"] = "RendererProcessKilled";
    BackForwardCacheNotRestoredReason2["RendererProcessCrashed"] = "RendererProcessCrashed";
    BackForwardCacheNotRestoredReason2["SchedulerTrackedFeatureUsed"] = "SchedulerTrackedFeatureUsed";
    BackForwardCacheNotRestoredReason2["ConflictingBrowsingInstance"] = "ConflictingBrowsingInstance";
    BackForwardCacheNotRestoredReason2["CacheFlushed"] = "CacheFlushed";
    BackForwardCacheNotRestoredReason2["ServiceWorkerVersionActivation"] = "ServiceWorkerVersionActivation";
    BackForwardCacheNotRestoredReason2["SessionRestored"] = "SessionRestored";
    BackForwardCacheNotRestoredReason2["ServiceWorkerPostMessage"] = "ServiceWorkerPostMessage";
    BackForwardCacheNotRestoredReason2["EnteredBackForwardCacheBeforeServiceWorkerHostAdded"] = "EnteredBackForwardCacheBeforeServiceWorkerHostAdded";
    BackForwardCacheNotRestoredReason2["RenderFrameHostReused_SameSite"] = "RenderFrameHostReused_SameSite";
    BackForwardCacheNotRestoredReason2["RenderFrameHostReused_CrossSite"] = "RenderFrameHostReused_CrossSite";
    BackForwardCacheNotRestoredReason2["ServiceWorkerClaim"] = "ServiceWorkerClaim";
    BackForwardCacheNotRestoredReason2["IgnoreEventAndEvict"] = "IgnoreEventAndEvict";
    BackForwardCacheNotRestoredReason2["HaveInnerContents"] = "HaveInnerContents";
    BackForwardCacheNotRestoredReason2["TimeoutPuttingInCache"] = "TimeoutPuttingInCache";
    BackForwardCacheNotRestoredReason2["BackForwardCacheDisabledByLowMemory"] = "BackForwardCacheDisabledByLowMemory";
    BackForwardCacheNotRestoredReason2["BackForwardCacheDisabledByCommandLine"] = "BackForwardCacheDisabledByCommandLine";
    BackForwardCacheNotRestoredReason2["NetworkRequestDatAPIpeDrainedAsBytesConsumer"] = "NetworkRequestDatapipeDrainedAsBytesConsumer";
    BackForwardCacheNotRestoredReason2["NetworkRequestRedirected"] = "NetworkRequestRedirected";
    BackForwardCacheNotRestoredReason2["NetworkRequestTimeout"] = "NetworkRequestTimeout";
    BackForwardCacheNotRestoredReason2["NetworkExceedsBufferLimit"] = "NetworkExceedsBufferLimit";
    BackForwardCacheNotRestoredReason2["NavigationCancelledWhileRestoring"] = "NavigationCancelledWhileRestoring";
    BackForwardCacheNotRestoredReason2["NotMostRecentNavigationEntry"] = "NotMostRecentNavigationEntry";
    BackForwardCacheNotRestoredReason2["BackForwardCacheDisabledForPrerender"] = "BackForwardCacheDisabledForPrerender";
    BackForwardCacheNotRestoredReason2["UserAgentOverrideDiffers"] = "UserAgentOverrideDiffers";
    BackForwardCacheNotRestoredReason2["ForegroundCacheLimit"] = "ForegroundCacheLimit";
    BackForwardCacheNotRestoredReason2["BrowsingInstanceNotSwapped"] = "BrowsingInstanceNotSwapped";
    BackForwardCacheNotRestoredReason2["BackForwardCacheDisabledForDelegate"] = "BackForwardCacheDisabledForDelegate";
    BackForwardCacheNotRestoredReason2["UnloadHandlerExistsInMainFrame"] = "UnloadHandlerExistsInMainFrame";
    BackForwardCacheNotRestoredReason2["UnloadHandlerExistsInSubFrame"] = "UnloadHandlerExistsInSubFrame";
    BackForwardCacheNotRestoredReason2["ServiceWorkerUnregistration"] = "ServiceWorkerUnregistration";
    BackForwardCacheNotRestoredReason2["CacheControlNoStore"] = "CacheControlNoStore";
    BackForwardCacheNotRestoredReason2["CacheControlNoStoreCookieModified"] = "CacheControlNoStoreCookieModified";
    BackForwardCacheNotRestoredReason2["CacheControlNoStoreHTTPOnlyCookieModified"] = "CacheControlNoStoreHTTPOnlyCookieModified";
    BackForwardCacheNotRestoredReason2["NoResponseHead"] = "NoResponseHead";
    BackForwardCacheNotRestoredReason2["Unknown"] = "Unknown";
    BackForwardCacheNotRestoredReason2["ActivationNavigationsDisallowedForBug1234857"] = "ActivationNavigationsDisallowedForBug1234857";
    BackForwardCacheNotRestoredReason2["ErrorDocument"] = "ErrorDocument";
    BackForwardCacheNotRestoredReason2["FencedFramesEmbedder"] = "FencedFramesEmbedder";
    BackForwardCacheNotRestoredReason2["CookieDisabled"] = "CookieDisabled";
    BackForwardCacheNotRestoredReason2["HTTPAuthRequired"] = "HTTPAuthRequired";
    BackForwardCacheNotRestoredReason2["CookieFlushed"] = "CookieFlushed";
    BackForwardCacheNotRestoredReason2["BroadcastChannelOnMessage"] = "BroadcastChannelOnMessage";
    BackForwardCacheNotRestoredReason2["WebViewSettingsChanged"] = "WebViewSettingsChanged";
    BackForwardCacheNotRestoredReason2["WebViewJavaScriptObjectChanged"] = "WebViewJavaScriptObjectChanged";
    BackForwardCacheNotRestoredReason2["WebViewMessageListenerInjected"] = "WebViewMessageListenerInjected";
    BackForwardCacheNotRestoredReason2["WebViewSafeBrowsingAllowlistChanged"] = "WebViewSafeBrowsingAllowlistChanged";
    BackForwardCacheNotRestoredReason2["WebViewDocumentStartJavascriptChanged"] = "WebViewDocumentStartJavascriptChanged";
    BackForwardCacheNotRestoredReason2["WebSocket"] = "WebSocket";
    BackForwardCacheNotRestoredReason2["WebTransport"] = "WebTransport";
    BackForwardCacheNotRestoredReason2["WebRTC"] = "WebRTC";
    BackForwardCacheNotRestoredReason2["MainResourceHasCacheControlNoStore"] = "MainResourceHasCacheControlNoStore";
    BackForwardCacheNotRestoredReason2["MainResourceHasCacheControlNoCache"] = "MainResourceHasCacheControlNoCache";
    BackForwardCacheNotRestoredReason2["SubresourceHasCacheControlNoStore"] = "SubresourceHasCacheControlNoStore";
    BackForwardCacheNotRestoredReason2["SubresourceHasCacheControlNoCache"] = "SubresourceHasCacheControlNoCache";
    BackForwardCacheNotRestoredReason2["ContainsPlugins"] = "ContainsPlugins";
    BackForwardCacheNotRestoredReason2["DocumentLoaded"] = "DocumentLoaded";
    BackForwardCacheNotRestoredReason2["OutstandingNetworkRequestOthers"] = "OutstandingNetworkRequestOthers";
    BackForwardCacheNotRestoredReason2["RequestedMIDIPermission"] = "RequestedMIDIPermission";
    BackForwardCacheNotRestoredReason2["RequestedAudioCapturePermission"] = "RequestedAudioCapturePermission";
    BackForwardCacheNotRestoredReason2["RequestedVideoCapturePermission"] = "RequestedVideoCapturePermission";
    BackForwardCacheNotRestoredReason2["RequestedBackForwardCacheBlockedSensors"] = "RequestedBackForwardCacheBlockedSensors";
    BackForwardCacheNotRestoredReason2["RequestedBackgroundWorkPermission"] = "RequestedBackgroundWorkPermission";
    BackForwardCacheNotRestoredReason2["BroadcastChannel"] = "BroadcastChannel";
    BackForwardCacheNotRestoredReason2["WebXR"] = "WebXR";
    BackForwardCacheNotRestoredReason2["SharedWorker"] = "SharedWorker";
    BackForwardCacheNotRestoredReason2["SharedWorkerMessage"] = "SharedWorkerMessage";
    BackForwardCacheNotRestoredReason2["SharedWorkerWithNoActiveClient"] = "SharedWorkerWithNoActiveClient";
    BackForwardCacheNotRestoredReason2["WebLocks"] = "WebLocks";
    BackForwardCacheNotRestoredReason2["WebHID"] = "WebHID";
    BackForwardCacheNotRestoredReason2["WebBluetooth"] = "WebBluetooth";
    BackForwardCacheNotRestoredReason2["WebShare"] = "WebShare";
    BackForwardCacheNotRestoredReason2["RequestedStorageAccessGrant"] = "RequestedStorageAccessGrant";
    BackForwardCacheNotRestoredReason2["WebNfc"] = "WebNfc";
    BackForwardCacheNotRestoredReason2["OutstandingNetworkRequestFetch"] = "OutstandingNetworkRequestFetch";
    BackForwardCacheNotRestoredReason2["OutstandingNetworkRequestXHR"] = "OutstandingNetworkRequestXHR";
    BackForwardCacheNotRestoredReason2["AppBanner"] = "AppBanner";
    BackForwardCacheNotRestoredReason2["Printing"] = "Printing";
    BackForwardCacheNotRestoredReason2["WebDatabase"] = "WebDatabase";
    BackForwardCacheNotRestoredReason2["PictureInPicture"] = "PictureInPicture";
    BackForwardCacheNotRestoredReason2["SpeechRecognizer"] = "SpeechRecognizer";
    BackForwardCacheNotRestoredReason2["IdleManager"] = "IdleManager";
    BackForwardCacheNotRestoredReason2["PaymentManager"] = "PaymentManager";
    BackForwardCacheNotRestoredReason2["SpeechSynthesis"] = "SpeechSynthesis";
    BackForwardCacheNotRestoredReason2["KeyboardLock"] = "KeyboardLock";
    BackForwardCacheNotRestoredReason2["WebOTPService"] = "WebOTPService";
    BackForwardCacheNotRestoredReason2["OutstandingNetworkRequestDirectSocket"] = "OutstandingNetworkRequestDirectSocket";
    BackForwardCacheNotRestoredReason2["InjectedJavascript"] = "InjectedJavascript";
    BackForwardCacheNotRestoredReason2["InjectedStyleSheet"] = "InjectedStyleSheet";
    BackForwardCacheNotRestoredReason2["KeepaliveRequest"] = "KeepaliveRequest";
    BackForwardCacheNotRestoredReason2["IndexedDBEvent"] = "IndexedDBEvent";
    BackForwardCacheNotRestoredReason2["Dummy"] = "Dummy";
    BackForwardCacheNotRestoredReason2["JsNetworkRequestReceivedCacheControlNoStoreResource"] = "JsNetworkRequestReceivedCacheControlNoStoreResource";
    BackForwardCacheNotRestoredReason2["WebRTCUsedWithCCNS"] = "WebRTCUsedWithCCNS";
    BackForwardCacheNotRestoredReason2["WebTransportUsedWithCCNS"] = "WebTransportUsedWithCCNS";
    BackForwardCacheNotRestoredReason2["WebSocketUsedWithCCNS"] = "WebSocketUsedWithCCNS";
    BackForwardCacheNotRestoredReason2["SmartCard"] = "SmartCard";
    BackForwardCacheNotRestoredReason2["LiveMediaStreamTrack"] = "LiveMediaStreamTrack";
    BackForwardCacheNotRestoredReason2["UnloadHandler"] = "UnloadHandler";
    BackForwardCacheNotRestoredReason2["ParserAborted"] = "ParserAborted";
    BackForwardCacheNotRestoredReason2["ContentSecurityHandler"] = "ContentSecurityHandler";
    BackForwardCacheNotRestoredReason2["ContentWebAuthenticationAPI"] = "ContentWebAuthenticationAPI";
    BackForwardCacheNotRestoredReason2["ContentFileChooser"] = "ContentFileChooser";
    BackForwardCacheNotRestoredReason2["ContentSerial"] = "ContentSerial";
    BackForwardCacheNotRestoredReason2["ContentFileSystemAccess"] = "ContentFileSystemAccess";
    BackForwardCacheNotRestoredReason2["ContentMediaDevicesDispatcherHost"] = "ContentMediaDevicesDispatcherHost";
    BackForwardCacheNotRestoredReason2["ContentWebBluetooth"] = "ContentWebBluetooth";
    BackForwardCacheNotRestoredReason2["ContentWebUSB"] = "ContentWebUSB";
    BackForwardCacheNotRestoredReason2["ContentMediaSessionService"] = "ContentMediaSessionService";
    BackForwardCacheNotRestoredReason2["ContentScreenReader"] = "ContentScreenReader";
    BackForwardCacheNotRestoredReason2["ContentDiscarded"] = "ContentDiscarded";
    BackForwardCacheNotRestoredReason2["EmbedderPopupBlockerTabHelper"] = "EmbedderPopupBlockerTabHelper";
    BackForwardCacheNotRestoredReason2["EmbedderSafeBrowsingTriggeredPopupBlocker"] = "EmbedderSafeBrowsingTriggeredPopupBlocker";
    BackForwardCacheNotRestoredReason2["EmbedderSafeBrowsingThreatDetails"] = "EmbedderSafeBrowsingThreatDetails";
    BackForwardCacheNotRestoredReason2["EmbedderAppBannerManager"] = "EmbedderAppBannerManager";
    BackForwardCacheNotRestoredReason2["EmbedderDomDistillerViewerSource"] = "EmbedderDomDistillerViewerSource";
    BackForwardCacheNotRestoredReason2["EmbedderDomDistillerSelfDeletingRequestDelegate"] = "EmbedderDomDistillerSelfDeletingRequestDelegate";
    BackForwardCacheNotRestoredReason2["EmbedderOomInterventionTabHelper"] = "EmbedderOomInterventionTabHelper";
    BackForwardCacheNotRestoredReason2["EmbedderOfflinePage"] = "EmbedderOfflinePage";
    BackForwardCacheNotRestoredReason2["EmbedderChromePasswordManagerClientBindCredentialManager"] = "EmbedderChromePasswordManagerClientBindCredentialManager";
    BackForwardCacheNotRestoredReason2["EmbedderPermissionRequestManager"] = "EmbedderPermissionRequestManager";
    BackForwardCacheNotRestoredReason2["EmbedderModalDialog"] = "EmbedderModalDialog";
    BackForwardCacheNotRestoredReason2["EmbedderExtensions"] = "EmbedderExtensions";
    BackForwardCacheNotRestoredReason2["EmbedderExtensionMessaging"] = "EmbedderExtensionMessaging";
    BackForwardCacheNotRestoredReason2["EmbedderExtensionMessagingForOpenPort"] = "EmbedderExtensionMessagingForOpenPort";
    BackForwardCacheNotRestoredReason2["EmbedderExtensionSentMessageToCachedFrame"] = "EmbedderExtensionSentMessageToCachedFrame";
    BackForwardCacheNotRestoredReason2["RequestedByWebViewClient"] = "RequestedByWebViewClient";
    BackForwardCacheNotRestoredReason2["PostMessageByWebViewClient"] = "PostMessageByWebViewClient";
    BackForwardCacheNotRestoredReason2["CacheControlNoStoreDeviceBoundSessionTerminated"] = "CacheControlNoStoreDeviceBoundSessionTerminated";
    BackForwardCacheNotRestoredReason2["CacheLimitPrunedOnModerateMemoryPressure"] = "CacheLimitPrunedOnModerateMemoryPressure";
    BackForwardCacheNotRestoredReason2["CacheLimitPrunedOnCriticalMemoryPressure"] = "CacheLimitPrunedOnCriticalMemoryPressure";
  })(BackForwardCacheNotRestoredReason = Page2.BackForwardCacheNotRestoredReason || (Page2.BackForwardCacheNotRestoredReason = {}));
  let BackForwardCacheNotRestoredReasonType;
  ((BackForwardCacheNotRestoredReasonType2) => {
    BackForwardCacheNotRestoredReasonType2["SupportPending"] = "SupportPending";
    BackForwardCacheNotRestoredReasonType2["PageSupportNeeded"] = "PageSupportNeeded";
    BackForwardCacheNotRestoredReasonType2["Circumstantial"] = "Circumstantial";
  })(BackForwardCacheNotRestoredReasonType = Page2.BackForwardCacheNotRestoredReasonType || (Page2.BackForwardCacheNotRestoredReasonType = {}));
  let CaptureScreenshotRequestFormat;
  ((CaptureScreenshotRequestFormat2) => {
    CaptureScreenshotRequestFormat2["Jpeg"] = "jpeg";
    CaptureScreenshotRequestFormat2["Png"] = "png";
    CaptureScreenshotRequestFormat2["Webp"] = "webp";
  })(CaptureScreenshotRequestFormat = Page2.CaptureScreenshotRequestFormat || (Page2.CaptureScreenshotRequestFormat = {}));
  let CaptureSnapshotRequestFormat;
  ((CaptureSnapshotRequestFormat2) => {
    CaptureSnapshotRequestFormat2["MHTML"] = "mhtml";
  })(CaptureSnapshotRequestFormat = Page2.CaptureSnapshotRequestFormat || (Page2.CaptureSnapshotRequestFormat = {}));
  let PrintToPDFRequestTransferMode;
  ((PrintToPDFRequestTransferMode2) => {
    PrintToPDFRequestTransferMode2["ReturnAsBase64"] = "ReturnAsBase64";
    PrintToPDFRequestTransferMode2["ReturnAsStream"] = "ReturnAsStream";
  })(PrintToPDFRequestTransferMode = Page2.PrintToPDFRequestTransferMode || (Page2.PrintToPDFRequestTransferMode = {}));
  let SetDownloadBehaviorRequestBehavior;
  ((SetDownloadBehaviorRequestBehavior2) => {
    SetDownloadBehaviorRequestBehavior2["Deny"] = "deny";
    SetDownloadBehaviorRequestBehavior2["Allow"] = "allow";
    SetDownloadBehaviorRequestBehavior2["Default"] = "default";
  })(SetDownloadBehaviorRequestBehavior = Page2.SetDownloadBehaviorRequestBehavior || (Page2.SetDownloadBehaviorRequestBehavior = {}));
  let SetTouchEmulationEnabledRequestConfiguration;
  ((SetTouchEmulationEnabledRequestConfiguration2) => {
    SetTouchEmulationEnabledRequestConfiguration2["Mobile"] = "mobile";
    SetTouchEmulationEnabledRequestConfiguration2["Desktop"] = "desktop";
  })(SetTouchEmulationEnabledRequestConfiguration = Page2.SetTouchEmulationEnabledRequestConfiguration || (Page2.SetTouchEmulationEnabledRequestConfiguration = {}));
  let StartScreencastRequestFormat;
  ((StartScreencastRequestFormat2) => {
    StartScreencastRequestFormat2["Jpeg"] = "jpeg";
    StartScreencastRequestFormat2["Png"] = "png";
  })(StartScreencastRequestFormat = Page2.StartScreencastRequestFormat || (Page2.StartScreencastRequestFormat = {}));
  let SetWebLifecycleStateRequestState;
  ((SetWebLifecycleStateRequestState2) => {
    SetWebLifecycleStateRequestState2["Frozen"] = "frozen";
    SetWebLifecycleStateRequestState2["Active"] = "active";
  })(SetWebLifecycleStateRequestState = Page2.SetWebLifecycleStateRequestState || (Page2.SetWebLifecycleStateRequestState = {}));
  let SetSPCTransactionModeRequestMode;
  ((SetSPCTransactionModeRequestMode2) => {
    SetSPCTransactionModeRequestMode2["None"] = "none";
    SetSPCTransactionModeRequestMode2["AutoAccept"] = "autoAccept";
    SetSPCTransactionModeRequestMode2["AutoChooseToAuthAnotherWay"] = "autoChooseToAuthAnotherWay";
    SetSPCTransactionModeRequestMode2["AutoReject"] = "autoReject";
    SetSPCTransactionModeRequestMode2["AutoOptOut"] = "autoOptOut";
  })(SetSPCTransactionModeRequestMode = Page2.SetSPCTransactionModeRequestMode || (Page2.SetSPCTransactionModeRequestMode = {}));
  let SetRPHRegistrationModeRequestMode;
  ((SetRPHRegistrationModeRequestMode2) => {
    SetRPHRegistrationModeRequestMode2["None"] = "none";
    SetRPHRegistrationModeRequestMode2["AutoAccept"] = "autoAccept";
    SetRPHRegistrationModeRequestMode2["AutoReject"] = "autoReject";
  })(SetRPHRegistrationModeRequestMode = Page2.SetRPHRegistrationModeRequestMode || (Page2.SetRPHRegistrationModeRequestMode = {}));
  let FileChooserOpenedEventMode;
  ((FileChooserOpenedEventMode2) => {
    FileChooserOpenedEventMode2["SelectSingle"] = "selectSingle";
    FileChooserOpenedEventMode2["SelectMultiple"] = "selectMultiple";
  })(FileChooserOpenedEventMode = Page2.FileChooserOpenedEventMode || (Page2.FileChooserOpenedEventMode = {}));
  let FrameDetachedEventReason;
  ((FrameDetachedEventReason2) => {
    FrameDetachedEventReason2["Remove"] = "remove";
    FrameDetachedEventReason2["Swap"] = "swap";
  })(FrameDetachedEventReason = Page2.FrameDetachedEventReason || (Page2.FrameDetachedEventReason = {}));
  let FrameStartedNavigatingEventNavigationType;
  ((FrameStartedNavigatingEventNavigationType2) => {
    FrameStartedNavigatingEventNavigationType2["Reload"] = "reload";
    FrameStartedNavigatingEventNavigationType2["ReloadBypassingCache"] = "reloadBypassingCache";
    FrameStartedNavigatingEventNavigationType2["Restore"] = "restore";
    FrameStartedNavigatingEventNavigationType2["RestoreWithPost"] = "restoreWithPost";
    FrameStartedNavigatingEventNavigationType2["HistorySameDocument"] = "historySameDocument";
    FrameStartedNavigatingEventNavigationType2["HistoryDifferentDocument"] = "historyDifferentDocument";
    FrameStartedNavigatingEventNavigationType2["SameDocument"] = "sameDocument";
    FrameStartedNavigatingEventNavigationType2["DifferentDocument"] = "differentDocument";
  })(FrameStartedNavigatingEventNavigationType = Page2.FrameStartedNavigatingEventNavigationType || (Page2.FrameStartedNavigatingEventNavigationType = {}));
  let DownloadProgressEventState;
  ((DownloadProgressEventState2) => {
    DownloadProgressEventState2["InProgress"] = "inProgress";
    DownloadProgressEventState2["Completed"] = "completed";
    DownloadProgressEventState2["Canceled"] = "canceled";
  })(DownloadProgressEventState = Page2.DownloadProgressEventState || (Page2.DownloadProgressEventState = {}));
  let NavigatedWithinDocumentEventNavigationType;
  ((NavigatedWithinDocumentEventNavigationType2) => {
    NavigatedWithinDocumentEventNavigationType2["Fragment"] = "fragment";
    NavigatedWithinDocumentEventNavigationType2["HistoryAPI"] = "historyApi";
    NavigatedWithinDocumentEventNavigationType2["Other"] = "other";
  })(NavigatedWithinDocumentEventNavigationType = Page2.NavigatedWithinDocumentEventNavigationType || (Page2.NavigatedWithinDocumentEventNavigationType = {}));
})(Page || (Page = {}));
var Performance;
((Performance2) => {
  let EnableRequestTimeDomain;
  ((EnableRequestTimeDomain2) => {
    EnableRequestTimeDomain2["TimeTicks"] = "timeTicks";
    EnableRequestTimeDomain2["ThreadTicks"] = "threadTicks";
  })(EnableRequestTimeDomain = Performance2.EnableRequestTimeDomain || (Performance2.EnableRequestTimeDomain = {}));
  let SetTimeDomainRequestTimeDomain;
  ((SetTimeDomainRequestTimeDomain2) => {
    SetTimeDomainRequestTimeDomain2["TimeTicks"] = "timeTicks";
    SetTimeDomainRequestTimeDomain2["ThreadTicks"] = "threadTicks";
  })(SetTimeDomainRequestTimeDomain = Performance2.SetTimeDomainRequestTimeDomain || (Performance2.SetTimeDomainRequestTimeDomain = {}));
})(Performance || (Performance = {}));
var Preload;
((Preload2) => {
  let RuleSetErrorType;
  ((RuleSetErrorType2) => {
    RuleSetErrorType2["SourceIsNotJsonObject"] = "SourceIsNotJsonObject";
    RuleSetErrorType2["InvalidRulesSkipped"] = "InvalidRulesSkipped";
    RuleSetErrorType2["InvalidRulesetLevelTag"] = "InvalidRulesetLevelTag";
  })(RuleSetErrorType = Preload2.RuleSetErrorType || (Preload2.RuleSetErrorType = {}));
  let SpeculationAction;
  ((SpeculationAction2) => {
    SpeculationAction2["Prefetch"] = "Prefetch";
    SpeculationAction2["Prerender"] = "Prerender";
    SpeculationAction2["PrerenderUntilScript"] = "PrerenderUntilScript";
  })(SpeculationAction = Preload2.SpeculationAction || (Preload2.SpeculationAction = {}));
  let SpeculationTargetHint;
  ((SpeculationTargetHint2) => {
    SpeculationTargetHint2["Blank"] = "Blank";
    SpeculationTargetHint2["Self"] = "Self";
  })(SpeculationTargetHint = Preload2.SpeculationTargetHint || (Preload2.SpeculationTargetHint = {}));
  let PrerenderFinalStatus;
  ((PrerenderFinalStatus2) => {
    PrerenderFinalStatus2["Activated"] = "Activated";
    PrerenderFinalStatus2["Destroyed"] = "Destroyed";
    PrerenderFinalStatus2["LowEndDevice"] = "LowEndDevice";
    PrerenderFinalStatus2["InvalidSchemeRedirect"] = "InvalidSchemeRedirect";
    PrerenderFinalStatus2["InvalidSchemeNavigation"] = "InvalidSchemeNavigation";
    PrerenderFinalStatus2["NavigationRequestBlockedByCsp"] = "NavigationRequestBlockedByCsp";
    PrerenderFinalStatus2["MojoBinderPolicy"] = "MojoBinderPolicy";
    PrerenderFinalStatus2["RendererProcessCrashed"] = "RendererProcessCrashed";
    PrerenderFinalStatus2["RendererProcessKilled"] = "RendererProcessKilled";
    PrerenderFinalStatus2["Download"] = "Download";
    PrerenderFinalStatus2["TriggerDestroyed"] = "TriggerDestroyed";
    PrerenderFinalStatus2["NavigationNotCommitted"] = "NavigationNotCommitted";
    PrerenderFinalStatus2["NavigationBadHttpStatus"] = "NavigationBadHttpStatus";
    PrerenderFinalStatus2["ClientCertRequested"] = "ClientCertRequested";
    PrerenderFinalStatus2["NavigationRequestNetworkError"] = "NavigationRequestNetworkError";
    PrerenderFinalStatus2["CancelAllHostsForTesting"] = "CancelAllHostsForTesting";
    PrerenderFinalStatus2["DidFailLoad"] = "DidFailLoad";
    PrerenderFinalStatus2["Stop"] = "Stop";
    PrerenderFinalStatus2["SslCertificateError"] = "SslCertificateError";
    PrerenderFinalStatus2["LoginAuthRequested"] = "LoginAuthRequested";
    PrerenderFinalStatus2["UaChangeRequiresReload"] = "UaChangeRequiresReload";
    PrerenderFinalStatus2["BlockedByClient"] = "BlockedByClient";
    PrerenderFinalStatus2["AudioOutputDeviceRequested"] = "AudioOutputDeviceRequested";
    PrerenderFinalStatus2["MixedContent"] = "MixedContent";
    PrerenderFinalStatus2["TriggerBackgrounded"] = "TriggerBackgrounded";
    PrerenderFinalStatus2["MemoryLimitExceeded"] = "MemoryLimitExceeded";
    PrerenderFinalStatus2["DataSaverEnabled"] = "DataSaverEnabled";
    PrerenderFinalStatus2["TriggerUrlHasEffectiveUrl"] = "TriggerUrlHasEffectiveUrl";
    PrerenderFinalStatus2["ActivatedBeforeStarted"] = "ActivatedBeforeStarted";
    PrerenderFinalStatus2["InactivePageRestriction"] = "InactivePageRestriction";
    PrerenderFinalStatus2["StartFailed"] = "StartFailed";
    PrerenderFinalStatus2["TimeoutBackgrounded"] = "TimeoutBackgrounded";
    PrerenderFinalStatus2["CrossSiteRedirectInInitialNavigation"] = "CrossSiteRedirectInInitialNavigation";
    PrerenderFinalStatus2["CrossSiteNavigationInInitialNavigation"] = "CrossSiteNavigationInInitialNavigation";
    PrerenderFinalStatus2["SameSiteCrossOriginRedirectNotOptInInInitialNavigation"] = "SameSiteCrossOriginRedirectNotOptInInInitialNavigation";
    PrerenderFinalStatus2["SameSiteCrossOriginNavigationNotOptInInInitialNavigation"] = "SameSiteCrossOriginNavigationNotOptInInInitialNavigation";
    PrerenderFinalStatus2["ActivationNavigationParameterMismatch"] = "ActivationNavigationParameterMismatch";
    PrerenderFinalStatus2["ActivatedInBackground"] = "ActivatedInBackground";
    PrerenderFinalStatus2["EmbedderHostDisallowed"] = "EmbedderHostDisallowed";
    PrerenderFinalStatus2["ActivationNavigationDestroyedBeforeSuccess"] = "ActivationNavigationDestroyedBeforeSuccess";
    PrerenderFinalStatus2["TabClosedByUserGesture"] = "TabClosedByUserGesture";
    PrerenderFinalStatus2["TabClosedWithoutUserGesture"] = "TabClosedWithoutUserGesture";
    PrerenderFinalStatus2["PrimaryMainFrameRendererProcessCrashed"] = "PrimaryMainFrameRendererProcessCrashed";
    PrerenderFinalStatus2["PrimaryMainFrameRendererProcessKilled"] = "PrimaryMainFrameRendererProcessKilled";
    PrerenderFinalStatus2["ActivationFramePolicyNotCompatible"] = "ActivationFramePolicyNotCompatible";
    PrerenderFinalStatus2["PreloadingDisabled"] = "PreloadingDisabled";
    PrerenderFinalStatus2["BatterySaverEnabled"] = "BatterySaverEnabled";
    PrerenderFinalStatus2["ActivatedDuringMainFrameNavigation"] = "ActivatedDuringMainFrameNavigation";
    PrerenderFinalStatus2["PreloadingUnsupportedByWebContents"] = "PreloadingUnsupportedByWebContents";
    PrerenderFinalStatus2["CrossSiteRedirectInMainFrameNavigation"] = "CrossSiteRedirectInMainFrameNavigation";
    PrerenderFinalStatus2["CrossSiteNavigationInMainFrameNavigation"] = "CrossSiteNavigationInMainFrameNavigation";
    PrerenderFinalStatus2["SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation"] = "SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation";
    PrerenderFinalStatus2["SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation"] = "SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation";
    PrerenderFinalStatus2["MemoryPressureOnTrigger"] = "MemoryPressureOnTrigger";
    PrerenderFinalStatus2["MemoryPressureAfterTriggered"] = "MemoryPressureAfterTriggered";
    PrerenderFinalStatus2["PrerenderingDisabledByDevTools"] = "PrerenderingDisabledByDevTools";
    PrerenderFinalStatus2["SpeculationRuleRemoved"] = "SpeculationRuleRemoved";
    PrerenderFinalStatus2["ActivatedWithAuxiliaryBrowsingContexts"] = "ActivatedWithAuxiliaryBrowsingContexts";
    PrerenderFinalStatus2["MaxNumOfRunningEagerPrerendersExceeded"] = "MaxNumOfRunningEagerPrerendersExceeded";
    PrerenderFinalStatus2["MaxNumOfRunningNonEagerPrerendersExceeded"] = "MaxNumOfRunningNonEagerPrerendersExceeded";
    PrerenderFinalStatus2["MaxNumOfRunningEmbedderPrerendersExceeded"] = "MaxNumOfRunningEmbedderPrerendersExceeded";
    PrerenderFinalStatus2["PrerenderingUrlHasEffectiveUrl"] = "PrerenderingUrlHasEffectiveUrl";
    PrerenderFinalStatus2["RedirectedPrerenderingUrlHasEffectiveUrl"] = "RedirectedPrerenderingUrlHasEffectiveUrl";
    PrerenderFinalStatus2["ActivationUrlHasEffectiveUrl"] = "ActivationUrlHasEffectiveUrl";
    PrerenderFinalStatus2["JavaScriptInterfaceAdded"] = "JavaScriptInterfaceAdded";
    PrerenderFinalStatus2["JavaScriptInterfaceRemoved"] = "JavaScriptInterfaceRemoved";
    PrerenderFinalStatus2["AllPrerenderingCanceled"] = "AllPrerenderingCanceled";
    PrerenderFinalStatus2["WindowClosed"] = "WindowClosed";
    PrerenderFinalStatus2["SlowNetwork"] = "SlowNetwork";
    PrerenderFinalStatus2["OtherPrerenderedPageActivated"] = "OtherPrerenderedPageActivated";
    PrerenderFinalStatus2["V8OptimizerDisabled"] = "V8OptimizerDisabled";
    PrerenderFinalStatus2["PrerenderFailedDuringPrefetch"] = "PrerenderFailedDuringPrefetch";
    PrerenderFinalStatus2["BrowsingDataRemoved"] = "BrowsingDataRemoved";
    PrerenderFinalStatus2["PrerenderHostReused"] = "PrerenderHostReused";
  })(PrerenderFinalStatus = Preload2.PrerenderFinalStatus || (Preload2.PrerenderFinalStatus = {}));
  let PreloadingStatus;
  ((PreloadingStatus2) => {
    PreloadingStatus2["Pending"] = "Pending";
    PreloadingStatus2["Running"] = "Running";
    PreloadingStatus2["Ready"] = "Ready";
    PreloadingStatus2["Success"] = "Success";
    PreloadingStatus2["Failure"] = "Failure";
    PreloadingStatus2["NotSupported"] = "NotSupported";
  })(PreloadingStatus = Preload2.PreloadingStatus || (Preload2.PreloadingStatus = {}));
  let PrefetchStatus;
  ((PrefetchStatus2) => {
    PrefetchStatus2["PrefetchAllowed"] = "PrefetchAllowed";
    PrefetchStatus2["PrefetchFailedIneligibleRedirect"] = "PrefetchFailedIneligibleRedirect";
    PrefetchStatus2["PrefetchFailedInvalidRedirect"] = "PrefetchFailedInvalidRedirect";
    PrefetchStatus2["PrefetchFailedMIMENotSupported"] = "PrefetchFailedMIMENotSupported";
    PrefetchStatus2["PrefetchFailedNetError"] = "PrefetchFailedNetError";
    PrefetchStatus2["PrefetchFailedNon2XX"] = "PrefetchFailedNon2XX";
    PrefetchStatus2["PrefetchEvictedAfterBrowsingDataRemoved"] = "PrefetchEvictedAfterBrowsingDataRemoved";
    PrefetchStatus2["PrefetchEvictedAfterCandidateRemoved"] = "PrefetchEvictedAfterCandidateRemoved";
    PrefetchStatus2["PrefetchEvictedForNewerPrefetch"] = "PrefetchEvictedForNewerPrefetch";
    PrefetchStatus2["PrefetchHeldback"] = "PrefetchHeldback";
    PrefetchStatus2["PrefetchIneligibleRetryAfter"] = "PrefetchIneligibleRetryAfter";
    PrefetchStatus2["PrefetchIsPrivacyDecoy"] = "PrefetchIsPrivacyDecoy";
    PrefetchStatus2["PrefetchIsStale"] = "PrefetchIsStale";
    PrefetchStatus2["PrefetchNotEligibleBrowserContextOffTheRecord"] = "PrefetchNotEligibleBrowserContextOffTheRecord";
    PrefetchStatus2["PrefetchNotEligibleDataSaverEnabled"] = "PrefetchNotEligibleDataSaverEnabled";
    PrefetchStatus2["PrefetchNotEligibleExistingProxy"] = "PrefetchNotEligibleExistingProxy";
    PrefetchStatus2["PrefetchNotEligibleHostIsNonUnique"] = "PrefetchNotEligibleHostIsNonUnique";
    PrefetchStatus2["PrefetchNotEligibleNonDefaultStoragePartition"] = "PrefetchNotEligibleNonDefaultStoragePartition";
    PrefetchStatus2["PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy"] = "PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy";
    PrefetchStatus2["PrefetchNotEligibleSchemeIsNotHttps"] = "PrefetchNotEligibleSchemeIsNotHttps";
    PrefetchStatus2["PrefetchNotEligibleUserHasCookies"] = "PrefetchNotEligibleUserHasCookies";
    PrefetchStatus2["PrefetchNotEligibleUserHasServiceWorker"] = "PrefetchNotEligibleUserHasServiceWorker";
    PrefetchStatus2["PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler"] = "PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler";
    PrefetchStatus2["PrefetchNotEligibleRedirectFromServiceWorker"] = "PrefetchNotEligibleRedirectFromServiceWorker";
    PrefetchStatus2["PrefetchNotEligibleRedirectToServiceWorker"] = "PrefetchNotEligibleRedirectToServiceWorker";
    PrefetchStatus2["PrefetchNotEligibleBatterySaverEnabled"] = "PrefetchNotEligibleBatterySaverEnabled";
    PrefetchStatus2["PrefetchNotEligiblePreloadingDisabled"] = "PrefetchNotEligiblePreloadingDisabled";
    PrefetchStatus2["PrefetchNotFinishedInTime"] = "PrefetchNotFinishedInTime";
    PrefetchStatus2["PrefetchNotStarted"] = "PrefetchNotStarted";
    PrefetchStatus2["PrefetchNotUsedCookiesChanged"] = "PrefetchNotUsedCookiesChanged";
    PrefetchStatus2["PrefetchProxyNotAvailable"] = "PrefetchProxyNotAvailable";
    PrefetchStatus2["PrefetchResponseUsed"] = "PrefetchResponseUsed";
    PrefetchStatus2["PrefetchSuccessfulButNotUsed"] = "PrefetchSuccessfulButNotUsed";
    PrefetchStatus2["PrefetchNotUsedProbeFailed"] = "PrefetchNotUsedProbeFailed";
  })(PrefetchStatus = Preload2.PrefetchStatus || (Preload2.PrefetchStatus = {}));
})(Preload || (Preload = {}));
var Security;
((Security2) => {
  let MixedContentType;
  ((MixedContentType2) => {
    MixedContentType2["Blockable"] = "blockable";
    MixedContentType2["OptionallyBlockable"] = "optionally-blockable";
    MixedContentType2["None"] = "none";
  })(MixedContentType = Security2.MixedContentType || (Security2.MixedContentType = {}));
  let SecurityState;
  ((SecurityState2) => {
    SecurityState2["Unknown"] = "unknown";
    SecurityState2["Neutral"] = "neutral";
    SecurityState2["Insecure"] = "insecure";
    SecurityState2["Secure"] = "secure";
    SecurityState2["Info"] = "info";
    SecurityState2["InsecureBroken"] = "insecure-broken";
  })(SecurityState = Security2.SecurityState || (Security2.SecurityState = {}));
  let SafetyTipStatus;
  ((SafetyTipStatus2) => {
    SafetyTipStatus2["BadReputation"] = "badReputation";
    SafetyTipStatus2["Lookalike"] = "lookalike";
  })(SafetyTipStatus = Security2.SafetyTipStatus || (Security2.SafetyTipStatus = {}));
  let CertificateErrorAction;
  ((CertificateErrorAction2) => {
    CertificateErrorAction2["Continue"] = "continue";
    CertificateErrorAction2["Cancel"] = "cancel";
  })(CertificateErrorAction = Security2.CertificateErrorAction || (Security2.CertificateErrorAction = {}));
})(Security || (Security = {}));
var ServiceWorker;
((ServiceWorker2) => {
  let ServiceWorkerVersionRunningStatus;
  ((ServiceWorkerVersionRunningStatus2) => {
    ServiceWorkerVersionRunningStatus2["Stopped"] = "stopped";
    ServiceWorkerVersionRunningStatus2["Starting"] = "starting";
    ServiceWorkerVersionRunningStatus2["Running"] = "running";
    ServiceWorkerVersionRunningStatus2["Stopping"] = "stopping";
  })(ServiceWorkerVersionRunningStatus = ServiceWorker2.ServiceWorkerVersionRunningStatus || (ServiceWorker2.ServiceWorkerVersionRunningStatus = {}));
  let ServiceWorkerVersionStatus;
  ((ServiceWorkerVersionStatus2) => {
    ServiceWorkerVersionStatus2["New"] = "new";
    ServiceWorkerVersionStatus2["Installing"] = "installing";
    ServiceWorkerVersionStatus2["Installed"] = "installed";
    ServiceWorkerVersionStatus2["Activating"] = "activating";
    ServiceWorkerVersionStatus2["Activated"] = "activated";
    ServiceWorkerVersionStatus2["Redundant"] = "redundant";
  })(ServiceWorkerVersionStatus = ServiceWorker2.ServiceWorkerVersionStatus || (ServiceWorker2.ServiceWorkerVersionStatus = {}));
})(ServiceWorker || (ServiceWorker = {}));
var Storage;
((Storage2) => {
  let StorageType;
  ((StorageType2) => {
    StorageType2["Cookies"] = "cookies";
    StorageType2["File_systems"] = "file_systems";
    StorageType2["Indexeddb"] = "indexeddb";
    StorageType2["Local_storage"] = "local_storage";
    StorageType2["Shader_cache"] = "shader_cache";
    StorageType2["Websql"] = "websql";
    StorageType2["Service_workers"] = "service_workers";
    StorageType2["Cache_storage"] = "cache_storage";
    StorageType2["Interest_groups"] = "interest_groups";
    StorageType2["Shared_storage"] = "shared_storage";
    StorageType2["Storage_buckets"] = "storage_buckets";
    StorageType2["All"] = "all";
    StorageType2["Other"] = "other";
  })(StorageType = Storage2.StorageType || (Storage2.StorageType = {}));
  let InterestGroupAccessType;
  ((InterestGroupAccessType2) => {
    InterestGroupAccessType2["Join"] = "join";
    InterestGroupAccessType2["Leave"] = "leave";
    InterestGroupAccessType2["Update"] = "update";
    InterestGroupAccessType2["Loaded"] = "loaded";
    InterestGroupAccessType2["Bid"] = "bid";
    InterestGroupAccessType2["Win"] = "win";
    InterestGroupAccessType2["AdditionalBid"] = "additionalBid";
    InterestGroupAccessType2["AdditionalBidWin"] = "additionalBidWin";
    InterestGroupAccessType2["TopLevelBid"] = "topLevelBid";
    InterestGroupAccessType2["TopLevelAdditionalBid"] = "topLevelAdditionalBid";
    InterestGroupAccessType2["Clear"] = "clear";
  })(InterestGroupAccessType = Storage2.InterestGroupAccessType || (Storage2.InterestGroupAccessType = {}));
  let InterestGroupAuctionEventType;
  ((InterestGroupAuctionEventType2) => {
    InterestGroupAuctionEventType2["Started"] = "started";
    InterestGroupAuctionEventType2["ConfigResolved"] = "configResolved";
  })(InterestGroupAuctionEventType = Storage2.InterestGroupAuctionEventType || (Storage2.InterestGroupAuctionEventType = {}));
  let InterestGroupAuctionFetchType;
  ((InterestGroupAuctionFetchType2) => {
    InterestGroupAuctionFetchType2["BidderJs"] = "bidderJs";
    InterestGroupAuctionFetchType2["BidderWasm"] = "bidderWasm";
    InterestGroupAuctionFetchType2["SellerJs"] = "sellerJs";
    InterestGroupAuctionFetchType2["BidderTrustedSignals"] = "bidderTrustedSignals";
    InterestGroupAuctionFetchType2["SellerTrustedSignals"] = "sellerTrustedSignals";
  })(InterestGroupAuctionFetchType = Storage2.InterestGroupAuctionFetchType || (Storage2.InterestGroupAuctionFetchType = {}));
  let SharedStorageAccessScope;
  ((SharedStorageAccessScope2) => {
    SharedStorageAccessScope2["Window"] = "window";
    SharedStorageAccessScope2["SharedStorageWorklet"] = "sharedStorageWorklet";
    SharedStorageAccessScope2["ProtectedAudienceWorklet"] = "protectedAudienceWorklet";
    SharedStorageAccessScope2["Header"] = "header";
  })(SharedStorageAccessScope = Storage2.SharedStorageAccessScope || (Storage2.SharedStorageAccessScope = {}));
  let SharedStorageAccessMethod;
  ((SharedStorageAccessMethod2) => {
    SharedStorageAccessMethod2["AddModule"] = "addModule";
    SharedStorageAccessMethod2["CreateWorklet"] = "createWorklet";
    SharedStorageAccessMethod2["SelectURL"] = "selectURL";
    SharedStorageAccessMethod2["Run"] = "run";
    SharedStorageAccessMethod2["BatchUpdate"] = "batchUpdate";
    SharedStorageAccessMethod2["Set"] = "set";
    SharedStorageAccessMethod2["Append"] = "append";
    SharedStorageAccessMethod2["Delete"] = "delete";
    SharedStorageAccessMethod2["Clear"] = "clear";
    SharedStorageAccessMethod2["Get"] = "get";
    SharedStorageAccessMethod2["Keys"] = "keys";
    SharedStorageAccessMethod2["Values"] = "values";
    SharedStorageAccessMethod2["Entries"] = "entries";
    SharedStorageAccessMethod2["Length"] = "length";
    SharedStorageAccessMethod2["RemainingBudget"] = "remainingBudget";
  })(SharedStorageAccessMethod = Storage2.SharedStorageAccessMethod || (Storage2.SharedStorageAccessMethod = {}));
  let StorageBucketsDurability;
  ((StorageBucketsDurability2) => {
    StorageBucketsDurability2["Relaxed"] = "relaxed";
    StorageBucketsDurability2["Strict"] = "strict";
  })(StorageBucketsDurability = Storage2.StorageBucketsDurability || (Storage2.StorageBucketsDurability = {}));
  let AttributionReportingSourceType;
  ((AttributionReportingSourceType2) => {
    AttributionReportingSourceType2["Navigation"] = "navigation";
    AttributionReportingSourceType2["Event"] = "event";
  })(AttributionReportingSourceType = Storage2.AttributionReportingSourceType || (Storage2.AttributionReportingSourceType = {}));
  let AttributionReportingTriggerDataMatching;
  ((AttributionReportingTriggerDataMatching2) => {
    AttributionReportingTriggerDataMatching2["Exact"] = "exact";
    AttributionReportingTriggerDataMatching2["Modulus"] = "modulus";
  })(AttributionReportingTriggerDataMatching = Storage2.AttributionReportingTriggerDataMatching || (Storage2.AttributionReportingTriggerDataMatching = {}));
  let AttributionReportingSourceRegistrationResult;
  ((AttributionReportingSourceRegistrationResult2) => {
    AttributionReportingSourceRegistrationResult2["Success"] = "success";
    AttributionReportingSourceRegistrationResult2["InternalError"] = "internalError";
    AttributionReportingSourceRegistrationResult2["InsufficientSourceCapacity"] = "insufficientSourceCapacity";
    AttributionReportingSourceRegistrationResult2["InsufficientUniqueDestinationCapacity"] = "insufficientUniqueDestinationCapacity";
    AttributionReportingSourceRegistrationResult2["ExcessiveReportingOrigins"] = "excessiveReportingOrigins";
    AttributionReportingSourceRegistrationResult2["ProhibitedByBrowserPolicy"] = "prohibitedByBrowserPolicy";
    AttributionReportingSourceRegistrationResult2["SuccessNoised"] = "successNoised";
    AttributionReportingSourceRegistrationResult2["DestinationReportingLimitReached"] = "destinationReportingLimitReached";
    AttributionReportingSourceRegistrationResult2["DestinationGlobalLimitReached"] = "destinationGlobalLimitReached";
    AttributionReportingSourceRegistrationResult2["DestinationBothLimitsReached"] = "destinationBothLimitsReached";
    AttributionReportingSourceRegistrationResult2["ReportingOriginsPerSiteLimitReached"] = "reportingOriginsPerSiteLimitReached";
    AttributionReportingSourceRegistrationResult2["ExceedsMaxChannelCapacity"] = "exceedsMaxChannelCapacity";
    AttributionReportingSourceRegistrationResult2["ExceedsMaxScopesChannelCapacity"] = "exceedsMaxScopesChannelCapacity";
    AttributionReportingSourceRegistrationResult2["ExceedsMaxTriggerStateCardinality"] = "exceedsMaxTriggerStateCardinality";
    AttributionReportingSourceRegistrationResult2["ExceedsMaxEventStatesLimit"] = "exceedsMaxEventStatesLimit";
    AttributionReportingSourceRegistrationResult2["DestinationPerDayReportingLimitReached"] = "destinationPerDayReportingLimitReached";
  })(AttributionReportingSourceRegistrationResult = Storage2.AttributionReportingSourceRegistrationResult || (Storage2.AttributionReportingSourceRegistrationResult = {}));
  let AttributionReportingSourceRegistrationTimeConfig;
  ((AttributionReportingSourceRegistrationTimeConfig2) => {
    AttributionReportingSourceRegistrationTimeConfig2["Include"] = "include";
    AttributionReportingSourceRegistrationTimeConfig2["Exclude"] = "exclude";
  })(AttributionReportingSourceRegistrationTimeConfig = Storage2.AttributionReportingSourceRegistrationTimeConfig || (Storage2.AttributionReportingSourceRegistrationTimeConfig = {}));
  let AttributionReportingEventLevelResult;
  ((AttributionReportingEventLevelResult2) => {
    AttributionReportingEventLevelResult2["Success"] = "success";
    AttributionReportingEventLevelResult2["SuccessDroppedLowerPriority"] = "successDroppedLowerPriority";
    AttributionReportingEventLevelResult2["InternalError"] = "internalError";
    AttributionReportingEventLevelResult2["NoCapacityForAttributionDestination"] = "noCapacityForAttributionDestination";
    AttributionReportingEventLevelResult2["NoMatchingSources"] = "noMatchingSources";
    AttributionReportingEventLevelResult2["Deduplicated"] = "deduplicated";
    AttributionReportingEventLevelResult2["ExcessiveAttributions"] = "excessiveAttributions";
    AttributionReportingEventLevelResult2["PriorityTooLow"] = "priorityTooLow";
    AttributionReportingEventLevelResult2["NeverAttributedSource"] = "neverAttributedSource";
    AttributionReportingEventLevelResult2["ExcessiveReportingOrigins"] = "excessiveReportingOrigins";
    AttributionReportingEventLevelResult2["NoMatchingSourceFilterData"] = "noMatchingSourceFilterData";
    AttributionReportingEventLevelResult2["ProhibitedByBrowserPolicy"] = "prohibitedByBrowserPolicy";
    AttributionReportingEventLevelResult2["NoMatchingConfigurations"] = "noMatchingConfigurations";
    AttributionReportingEventLevelResult2["ExcessiveReports"] = "excessiveReports";
    AttributionReportingEventLevelResult2["FalselyAttributedSource"] = "falselyAttributedSource";
    AttributionReportingEventLevelResult2["ReportWindowPassed"] = "reportWindowPassed";
    AttributionReportingEventLevelResult2["NotRegistered"] = "notRegistered";
    AttributionReportingEventLevelResult2["ReportWindowNotStarted"] = "reportWindowNotStarted";
    AttributionReportingEventLevelResult2["NoMatchingTriggerData"] = "noMatchingTriggerData";
  })(AttributionReportingEventLevelResult = Storage2.AttributionReportingEventLevelResult || (Storage2.AttributionReportingEventLevelResult = {}));
  let AttributionReportingAggregatableResult;
  ((AttributionReportingAggregatableResult2) => {
    AttributionReportingAggregatableResult2["Success"] = "success";
    AttributionReportingAggregatableResult2["InternalError"] = "internalError";
    AttributionReportingAggregatableResult2["NoCapacityForAttributionDestination"] = "noCapacityForAttributionDestination";
    AttributionReportingAggregatableResult2["NoMatchingSources"] = "noMatchingSources";
    AttributionReportingAggregatableResult2["ExcessiveAttributions"] = "excessiveAttributions";
    AttributionReportingAggregatableResult2["ExcessiveReportingOrigins"] = "excessiveReportingOrigins";
    AttributionReportingAggregatableResult2["NoHistograms"] = "noHistograms";
    AttributionReportingAggregatableResult2["InsufficientBudget"] = "insufficientBudget";
    AttributionReportingAggregatableResult2["InsufficientNamedBudget"] = "insufficientNamedBudget";
    AttributionReportingAggregatableResult2["NoMatchingSourceFilterData"] = "noMatchingSourceFilterData";
    AttributionReportingAggregatableResult2["NotRegistered"] = "notRegistered";
    AttributionReportingAggregatableResult2["ProhibitedByBrowserPolicy"] = "prohibitedByBrowserPolicy";
    AttributionReportingAggregatableResult2["Deduplicated"] = "deduplicated";
    AttributionReportingAggregatableResult2["ReportWindowPassed"] = "reportWindowPassed";
    AttributionReportingAggregatableResult2["ExcessiveReports"] = "excessiveReports";
  })(AttributionReportingAggregatableResult = Storage2.AttributionReportingAggregatableResult || (Storage2.AttributionReportingAggregatableResult = {}));
  let AttributionReportingReportResult;
  ((AttributionReportingReportResult2) => {
    AttributionReportingReportResult2["Sent"] = "sent";
    AttributionReportingReportResult2["Prohibited"] = "prohibited";
    AttributionReportingReportResult2["FailedToAssemble"] = "failedToAssemble";
    AttributionReportingReportResult2["Expired"] = "expired";
  })(AttributionReportingReportResult = Storage2.AttributionReportingReportResult || (Storage2.AttributionReportingReportResult = {}));
})(Storage || (Storage = {}));
var SystemInfo;
((SystemInfo2) => {
  let SubsamplingFormat;
  ((SubsamplingFormat2) => {
    SubsamplingFormat2["Yuv420"] = "yuv420";
    SubsamplingFormat2["Yuv422"] = "yuv422";
    SubsamplingFormat2["Yuv444"] = "yuv444";
  })(SubsamplingFormat = SystemInfo2.SubsamplingFormat || (SystemInfo2.SubsamplingFormat = {}));
  let ImageType;
  ((ImageType2) => {
    ImageType2["Jpeg"] = "jpeg";
    ImageType2["Webp"] = "webp";
    ImageType2["Unknown"] = "unknown";
  })(ImageType = SystemInfo2.ImageType || (SystemInfo2.ImageType = {}));
})(SystemInfo || (SystemInfo = {}));
var Target2;
((Target22) => {
  let WindowState;
  ((WindowState2) => {
    WindowState2["Normal"] = "normal";
    WindowState2["Minimized"] = "minimized";
    WindowState2["Maximized"] = "maximized";
    WindowState2["Fullscreen"] = "fullscreen";
  })(WindowState = Target22.WindowState || (Target22.WindowState = {}));
})(Target2 || (Target2 = {}));
var Tracing;
((Tracing2) => {
  let TraceConfigRecordMode;
  ((TraceConfigRecordMode2) => {
    TraceConfigRecordMode2["RecordUntilFull"] = "recordUntilFull";
    TraceConfigRecordMode2["RecordContinuously"] = "recordContinuously";
    TraceConfigRecordMode2["RecordAsMuchAsPossible"] = "recordAsMuchAsPossible";
    TraceConfigRecordMode2["EchoToConsole"] = "echoToConsole";
  })(TraceConfigRecordMode = Tracing2.TraceConfigRecordMode || (Tracing2.TraceConfigRecordMode = {}));
  let StreamFormat;
  ((StreamFormat2) => {
    StreamFormat2["Json"] = "json";
    StreamFormat2["Proto"] = "proto";
  })(StreamFormat = Tracing2.StreamFormat || (Tracing2.StreamFormat = {}));
  let StreamCompression;
  ((StreamCompression2) => {
    StreamCompression2["None"] = "none";
    StreamCompression2["Gzip"] = "gzip";
  })(StreamCompression = Tracing2.StreamCompression || (Tracing2.StreamCompression = {}));
  let MemoryDumpLevelOfDetail;
  ((MemoryDumpLevelOfDetail2) => {
    MemoryDumpLevelOfDetail2["Background"] = "background";
    MemoryDumpLevelOfDetail2["Light"] = "light";
    MemoryDumpLevelOfDetail2["Detailed"] = "detailed";
  })(MemoryDumpLevelOfDetail = Tracing2.MemoryDumpLevelOfDetail || (Tracing2.MemoryDumpLevelOfDetail = {}));
  let TracingBackend;
  ((TracingBackend2) => {
    TracingBackend2["Auto"] = "auto";
    TracingBackend2["Chrome"] = "chrome";
    TracingBackend2["System"] = "system";
  })(TracingBackend = Tracing2.TracingBackend || (Tracing2.TracingBackend = {}));
  let StartRequestTransferMode;
  ((StartRequestTransferMode2) => {
    StartRequestTransferMode2["ReportEvents"] = "ReportEvents";
    StartRequestTransferMode2["ReturnAsStream"] = "ReturnAsStream";
  })(StartRequestTransferMode = Tracing2.StartRequestTransferMode || (Tracing2.StartRequestTransferMode = {}));
})(Tracing || (Tracing = {}));
var WebAudio;
((WebAudio2) => {
  let ContextType;
  ((ContextType2) => {
    ContextType2["Realtime"] = "realtime";
    ContextType2["Offline"] = "offline";
  })(ContextType = WebAudio2.ContextType || (WebAudio2.ContextType = {}));
  let ContextState;
  ((ContextState2) => {
    ContextState2["Suspended"] = "suspended";
    ContextState2["Running"] = "running";
    ContextState2["Closed"] = "closed";
    ContextState2["Interrupted"] = "interrupted";
  })(ContextState = WebAudio2.ContextState || (WebAudio2.ContextState = {}));
  let ChannelCountMode;
  ((ChannelCountMode2) => {
    ChannelCountMode2["ClampedMax"] = "clamped-max";
    ChannelCountMode2["Explicit"] = "explicit";
    ChannelCountMode2["Max"] = "max";
  })(ChannelCountMode = WebAudio2.ChannelCountMode || (WebAudio2.ChannelCountMode = {}));
  let ChannelInterpretation;
  ((ChannelInterpretation2) => {
    ChannelInterpretation2["Discrete"] = "discrete";
    ChannelInterpretation2["Speakers"] = "speakers";
  })(ChannelInterpretation = WebAudio2.ChannelInterpretation || (WebAudio2.ChannelInterpretation = {}));
  let AutomationRate;
  ((AutomationRate2) => {
    AutomationRate2["ARate"] = "a-rate";
    AutomationRate2["KRate"] = "k-rate";
  })(AutomationRate = WebAudio2.AutomationRate || (WebAudio2.AutomationRate = {}));
})(WebAudio || (WebAudio = {}));
var WebAuthn;
((WebAuthn2) => {
  let AuthenticatorProtocol;
  ((AuthenticatorProtocol2) => {
    AuthenticatorProtocol2["U2f"] = "u2f";
    AuthenticatorProtocol2["Ctap2"] = "ctap2";
  })(AuthenticatorProtocol = WebAuthn2.AuthenticatorProtocol || (WebAuthn2.AuthenticatorProtocol = {}));
  let Ctap2Version;
  ((Ctap2Version2) => {
    Ctap2Version2["Ctap2_0"] = "ctap2_0";
    Ctap2Version2["Ctap2_1"] = "ctap2_1";
  })(Ctap2Version = WebAuthn2.Ctap2Version || (WebAuthn2.Ctap2Version = {}));
  let AuthenticatorTransport;
  ((AuthenticatorTransport2) => {
    AuthenticatorTransport2["Usb"] = "usb";
    AuthenticatorTransport2["Nfc"] = "nfc";
    AuthenticatorTransport2["Ble"] = "ble";
    AuthenticatorTransport2["Cable"] = "cable";
    AuthenticatorTransport2["Internal"] = "internal";
  })(AuthenticatorTransport = WebAuthn2.AuthenticatorTransport || (WebAuthn2.AuthenticatorTransport = {}));
})(WebAuthn || (WebAuthn = {}));
var Debugger;
((Debugger2) => {
  let ScopeType;
  ((ScopeType2) => {
    ScopeType2["Global"] = "global";
    ScopeType2["Local"] = "local";
    ScopeType2["With"] = "with";
    ScopeType2["Closure"] = "closure";
    ScopeType2["Catch"] = "catch";
    ScopeType2["Block"] = "block";
    ScopeType2["Script"] = "script";
    ScopeType2["Eval"] = "eval";
    ScopeType2["Module"] = "module";
    ScopeType2["WasmExpressionStack"] = "wasm-expression-stack";
  })(ScopeType = Debugger2.ScopeType || (Debugger2.ScopeType = {}));
  let BreakLocationType;
  ((BreakLocationType2) => {
    BreakLocationType2["DebuggerStatement"] = "debuggerStatement";
    BreakLocationType2["Call"] = "call";
    BreakLocationType2["Return"] = "return";
  })(BreakLocationType = Debugger2.BreakLocationType || (Debugger2.BreakLocationType = {}));
  let ScriptLanguage;
  ((ScriptLanguage2) => {
    ScriptLanguage2["JavaScript"] = "JavaScript";
    ScriptLanguage2["WebAssembly"] = "WebAssembly";
  })(ScriptLanguage = Debugger2.ScriptLanguage || (Debugger2.ScriptLanguage = {}));
  let DebugSymbolsType;
  ((DebugSymbolsType2) => {
    DebugSymbolsType2["SourceMap"] = "SourceMap";
    DebugSymbolsType2["EmbeddedDWARF"] = "EmbeddedDWARF";
    DebugSymbolsType2["ExternalDWARF"] = "ExternalDWARF";
  })(DebugSymbolsType = Debugger2.DebugSymbolsType || (Debugger2.DebugSymbolsType = {}));
  let ContinueToLocationRequestTargetCallFrames;
  ((ContinueToLocationRequestTargetCallFrames2) => {
    ContinueToLocationRequestTargetCallFrames2["Any"] = "any";
    ContinueToLocationRequestTargetCallFrames2["Current"] = "current";
  })(ContinueToLocationRequestTargetCallFrames = Debugger2.ContinueToLocationRequestTargetCallFrames || (Debugger2.ContinueToLocationRequestTargetCallFrames = {}));
  let RestartFrameRequestMode;
  ((RestartFrameRequestMode2) => {
    RestartFrameRequestMode2["StepInto"] = "StepInto";
  })(RestartFrameRequestMode = Debugger2.RestartFrameRequestMode || (Debugger2.RestartFrameRequestMode = {}));
  let SetInstrumentationBreakpointRequestInstrumentation;
  ((SetInstrumentationBreakpointRequestInstrumentation2) => {
    SetInstrumentationBreakpointRequestInstrumentation2["BeforeScriptExecution"] = "beforeScriptExecution";
    SetInstrumentationBreakpointRequestInstrumentation2["BeforeScriptWithSourceMapExecution"] = "beforeScriptWithSourceMapExecution";
  })(SetInstrumentationBreakpointRequestInstrumentation = Debugger2.SetInstrumentationBreakpointRequestInstrumentation || (Debugger2.SetInstrumentationBreakpointRequestInstrumentation = {}));
  let SetPauseOnExceptionsRequestState;
  ((SetPauseOnExceptionsRequestState2) => {
    SetPauseOnExceptionsRequestState2["None"] = "none";
    SetPauseOnExceptionsRequestState2["Caught"] = "caught";
    SetPauseOnExceptionsRequestState2["Uncaught"] = "uncaught";
    SetPauseOnExceptionsRequestState2["All"] = "all";
  })(SetPauseOnExceptionsRequestState = Debugger2.SetPauseOnExceptionsRequestState || (Debugger2.SetPauseOnExceptionsRequestState = {}));
  let SetScriptSourceResponseStatus;
  ((SetScriptSourceResponseStatus2) => {
    SetScriptSourceResponseStatus2["Ok"] = "Ok";
    SetScriptSourceResponseStatus2["CompileError"] = "CompileError";
    SetScriptSourceResponseStatus2["BlockedByActiveGenerator"] = "BlockedByActiveGenerator";
    SetScriptSourceResponseStatus2["BlockedByActiveFunction"] = "BlockedByActiveFunction";
    SetScriptSourceResponseStatus2["BlockedByTopLevelEsModuleChange"] = "BlockedByTopLevelEsModuleChange";
  })(SetScriptSourceResponseStatus = Debugger2.SetScriptSourceResponseStatus || (Debugger2.SetScriptSourceResponseStatus = {}));
  let PausedEventReason;
  ((PausedEventReason2) => {
    PausedEventReason2["Ambiguous"] = "ambiguous";
    PausedEventReason2["Assert"] = "assert";
    PausedEventReason2["CSPViolation"] = "CSPViolation";
    PausedEventReason2["DebugCommand"] = "debugCommand";
    PausedEventReason2["DOM"] = "DOM";
    PausedEventReason2["EventListener"] = "EventListener";
    PausedEventReason2["Exception"] = "exception";
    PausedEventReason2["Instrumentation"] = "instrumentation";
    PausedEventReason2["OOM"] = "OOM";
    PausedEventReason2["Other"] = "other";
    PausedEventReason2["PromiseRejection"] = "promiseRejection";
    PausedEventReason2["XHR"] = "XHR";
    PausedEventReason2["Step"] = "step";
  })(PausedEventReason = Debugger2.PausedEventReason || (Debugger2.PausedEventReason = {}));
})(Debugger || (Debugger = {}));
var Runtime;
((Runtime22) => {
  let SerializationOptionsSerialization;
  ((SerializationOptionsSerialization2) => {
    SerializationOptionsSerialization2["Deep"] = "deep";
    SerializationOptionsSerialization2["Json"] = "json";
    SerializationOptionsSerialization2["IdOnly"] = "idOnly";
  })(SerializationOptionsSerialization = Runtime22.SerializationOptionsSerialization || (Runtime22.SerializationOptionsSerialization = {}));
  let DeepSerializedValueType;
  ((DeepSerializedValueType2) => {
    DeepSerializedValueType2["Undefined"] = "undefined";
    DeepSerializedValueType2["Null"] = "null";
    DeepSerializedValueType2["String"] = "string";
    DeepSerializedValueType2["Number"] = "number";
    DeepSerializedValueType2["Boolean"] = "boolean";
    DeepSerializedValueType2["Bigint"] = "bigint";
    DeepSerializedValueType2["Regexp"] = "regexp";
    DeepSerializedValueType2["Date"] = "date";
    DeepSerializedValueType2["Symbol"] = "symbol";
    DeepSerializedValueType2["Array"] = "array";
    DeepSerializedValueType2["Object"] = "object";
    DeepSerializedValueType2["Function"] = "function";
    DeepSerializedValueType2["Map"] = "map";
    DeepSerializedValueType2["Set"] = "set";
    DeepSerializedValueType2["Weakmap"] = "weakmap";
    DeepSerializedValueType2["Weakset"] = "weakset";
    DeepSerializedValueType2["Error"] = "error";
    DeepSerializedValueType2["Proxy"] = "proxy";
    DeepSerializedValueType2["Promise"] = "promise";
    DeepSerializedValueType2["Typedarray"] = "typedarray";
    DeepSerializedValueType2["Arraybuffer"] = "arraybuffer";
    DeepSerializedValueType2["Node"] = "node";
    DeepSerializedValueType2["Window"] = "window";
    DeepSerializedValueType2["Generator"] = "generator";
  })(DeepSerializedValueType = Runtime22.DeepSerializedValueType || (Runtime22.DeepSerializedValueType = {}));
  let RemoteObjectType;
  ((RemoteObjectType2) => {
    RemoteObjectType2["Object"] = "object";
    RemoteObjectType2["Function"] = "function";
    RemoteObjectType2["Undefined"] = "undefined";
    RemoteObjectType2["String"] = "string";
    RemoteObjectType2["Number"] = "number";
    RemoteObjectType2["Boolean"] = "boolean";
    RemoteObjectType2["Symbol"] = "symbol";
    RemoteObjectType2["Bigint"] = "bigint";
  })(RemoteObjectType = Runtime22.RemoteObjectType || (Runtime22.RemoteObjectType = {}));
  let RemoteObjectSubtype;
  ((RemoteObjectSubtype2) => {
    RemoteObjectSubtype2["Array"] = "array";
    RemoteObjectSubtype2["Null"] = "null";
    RemoteObjectSubtype2["Node"] = "node";
    RemoteObjectSubtype2["Regexp"] = "regexp";
    RemoteObjectSubtype2["Date"] = "date";
    RemoteObjectSubtype2["Map"] = "map";
    RemoteObjectSubtype2["Set"] = "set";
    RemoteObjectSubtype2["Weakmap"] = "weakmap";
    RemoteObjectSubtype2["Weakset"] = "weakset";
    RemoteObjectSubtype2["Iterator"] = "iterator";
    RemoteObjectSubtype2["Generator"] = "generator";
    RemoteObjectSubtype2["Error"] = "error";
    RemoteObjectSubtype2["Proxy"] = "proxy";
    RemoteObjectSubtype2["Promise"] = "promise";
    RemoteObjectSubtype2["Typedarray"] = "typedarray";
    RemoteObjectSubtype2["Arraybuffer"] = "arraybuffer";
    RemoteObjectSubtype2["Dataview"] = "dataview";
    RemoteObjectSubtype2["Webassemblymemory"] = "webassemblymemory";
    RemoteObjectSubtype2["Wasmvalue"] = "wasmvalue";
    RemoteObjectSubtype2["Trustedtype"] = "trustedtype";
  })(RemoteObjectSubtype = Runtime22.RemoteObjectSubtype || (Runtime22.RemoteObjectSubtype = {}));
  let ObjectPreviewType;
  ((ObjectPreviewType2) => {
    ObjectPreviewType2["Object"] = "object";
    ObjectPreviewType2["Function"] = "function";
    ObjectPreviewType2["Undefined"] = "undefined";
    ObjectPreviewType2["String"] = "string";
    ObjectPreviewType2["Number"] = "number";
    ObjectPreviewType2["Boolean"] = "boolean";
    ObjectPreviewType2["Symbol"] = "symbol";
    ObjectPreviewType2["Bigint"] = "bigint";
  })(ObjectPreviewType = Runtime22.ObjectPreviewType || (Runtime22.ObjectPreviewType = {}));
  let ObjectPreviewSubtype;
  ((ObjectPreviewSubtype2) => {
    ObjectPreviewSubtype2["Array"] = "array";
    ObjectPreviewSubtype2["Null"] = "null";
    ObjectPreviewSubtype2["Node"] = "node";
    ObjectPreviewSubtype2["Regexp"] = "regexp";
    ObjectPreviewSubtype2["Date"] = "date";
    ObjectPreviewSubtype2["Map"] = "map";
    ObjectPreviewSubtype2["Set"] = "set";
    ObjectPreviewSubtype2["Weakmap"] = "weakmap";
    ObjectPreviewSubtype2["Weakset"] = "weakset";
    ObjectPreviewSubtype2["Iterator"] = "iterator";
    ObjectPreviewSubtype2["Generator"] = "generator";
    ObjectPreviewSubtype2["Error"] = "error";
    ObjectPreviewSubtype2["Proxy"] = "proxy";
    ObjectPreviewSubtype2["Promise"] = "promise";
    ObjectPreviewSubtype2["Typedarray"] = "typedarray";
    ObjectPreviewSubtype2["Arraybuffer"] = "arraybuffer";
    ObjectPreviewSubtype2["Dataview"] = "dataview";
    ObjectPreviewSubtype2["Webassemblymemory"] = "webassemblymemory";
    ObjectPreviewSubtype2["Wasmvalue"] = "wasmvalue";
    ObjectPreviewSubtype2["Trustedtype"] = "trustedtype";
  })(ObjectPreviewSubtype = Runtime22.ObjectPreviewSubtype || (Runtime22.ObjectPreviewSubtype = {}));
  let PropertyPreviewType;
  ((PropertyPreviewType2) => {
    PropertyPreviewType2["Object"] = "object";
    PropertyPreviewType2["Function"] = "function";
    PropertyPreviewType2["Undefined"] = "undefined";
    PropertyPreviewType2["String"] = "string";
    PropertyPreviewType2["Number"] = "number";
    PropertyPreviewType2["Boolean"] = "boolean";
    PropertyPreviewType2["Symbol"] = "symbol";
    PropertyPreviewType2["Accessor"] = "accessor";
    PropertyPreviewType2["Bigint"] = "bigint";
  })(PropertyPreviewType = Runtime22.PropertyPreviewType || (Runtime22.PropertyPreviewType = {}));
  let PropertyPreviewSubtype;
  ((PropertyPreviewSubtype2) => {
    PropertyPreviewSubtype2["Array"] = "array";
    PropertyPreviewSubtype2["Null"] = "null";
    PropertyPreviewSubtype2["Node"] = "node";
    PropertyPreviewSubtype2["Regexp"] = "regexp";
    PropertyPreviewSubtype2["Date"] = "date";
    PropertyPreviewSubtype2["Map"] = "map";
    PropertyPreviewSubtype2["Set"] = "set";
    PropertyPreviewSubtype2["Weakmap"] = "weakmap";
    PropertyPreviewSubtype2["Weakset"] = "weakset";
    PropertyPreviewSubtype2["Iterator"] = "iterator";
    PropertyPreviewSubtype2["Generator"] = "generator";
    PropertyPreviewSubtype2["Error"] = "error";
    PropertyPreviewSubtype2["Proxy"] = "proxy";
    PropertyPreviewSubtype2["Promise"] = "promise";
    PropertyPreviewSubtype2["Typedarray"] = "typedarray";
    PropertyPreviewSubtype2["Arraybuffer"] = "arraybuffer";
    PropertyPreviewSubtype2["Dataview"] = "dataview";
    PropertyPreviewSubtype2["Webassemblymemory"] = "webassemblymemory";
    PropertyPreviewSubtype2["Wasmvalue"] = "wasmvalue";
    PropertyPreviewSubtype2["Trustedtype"] = "trustedtype";
  })(PropertyPreviewSubtype = Runtime22.PropertyPreviewSubtype || (Runtime22.PropertyPreviewSubtype = {}));
  let ConsoleAPICalledEventType;
  ((ConsoleAPICalledEventType2) => {
    ConsoleAPICalledEventType2["Log"] = "log";
    ConsoleAPICalledEventType2["Debug"] = "debug";
    ConsoleAPICalledEventType2["Info"] = "info";
    ConsoleAPICalledEventType2["Error"] = "error";
    ConsoleAPICalledEventType2["Warning"] = "warning";
    ConsoleAPICalledEventType2["Dir"] = "dir";
    ConsoleAPICalledEventType2["DirXML"] = "dirxml";
    ConsoleAPICalledEventType2["Table"] = "table";
    ConsoleAPICalledEventType2["Trace"] = "trace";
    ConsoleAPICalledEventType2["Clear"] = "clear";
    ConsoleAPICalledEventType2["StartGroup"] = "startGroup";
    ConsoleAPICalledEventType2["StartGroupCollapsed"] = "startGroupCollapsed";
    ConsoleAPICalledEventType2["EndGroup"] = "endGroup";
    ConsoleAPICalledEventType2["Assert"] = "assert";
    ConsoleAPICalledEventType2["Profile"] = "profile";
    ConsoleAPICalledEventType2["ProfileEnd"] = "profileEnd";
    ConsoleAPICalledEventType2["Count"] = "count";
    ConsoleAPICalledEventType2["TimeEnd"] = "timeEnd";
  })(ConsoleAPICalledEventType = Runtime22.ConsoleAPICalledEventType || (Runtime22.ConsoleAPICalledEventType = {}));
})(Runtime || (Runtime = {}));

// gen/third_party/devtools-frontend/src/front_end/models/bindings/DebuggerLanguagePlugins.js
import * as StackTrace3 from "./../stack_trace/stack_trace.js";
import * as TextUtils5 from "./../text_utils/text_utils.js";
import * as Workspace11 from "./../workspace/workspace.js";
var UIStrings2 = {
  /**
   * @description Error message that is displayed in the Console when language #plugins report errors
   * @example {File not found} PH1
   */
  errorInDebuggerLanguagePlugin: "Error in debugger language plugin: {PH1}",
  /**
   * @description Status message that is shown in the Console when debugging information is being
   *loaded. The 2nd and 3rd placeholders are URLs.
   * @example {C/C++ DevTools Support (DWARF)} PH1
   * @example {http://web.dev/file.wasm} PH2
   * @example {http://web.dev/file.wasm.debug.wasm} PH3
   */
  loadingDebugSymbolsForVia: "[{PH1}] Loading debug symbols for {PH2} (via {PH3})\u2026",
  /**
   * @description Status message that is shown in the Console when debugging information is being loaded
   * @example {C/C++ DevTools Support (DWARF)} PH1
   * @example {http://web.dev/file.wasm} PH2
   */
  loadingDebugSymbolsFor: "[{PH1}] Loading debug symbols for {PH2}\u2026",
  /**
   * @description Warning message that is displayed in the Console when debugging information was loaded, but no source files were found
   * @example {C/C++ DevTools Support (DWARF)} PH1
   * @example {http://web.dev/file.wasm} PH2
   */
  loadedDebugSymbolsForButDidnt: "[{PH1}] Loaded debug symbols for {PH2}, but didn't find any source files",
  /**
   * @description Status message that is shown in the Console when debugging information is successfully loaded
   * @example {C/C++ DevTools Support (DWARF)} PH1
   * @example {http://web.dev/file.wasm} PH2
   * @example {42} PH3
   */
  loadedDebugSymbolsForFound: "[{PH1}] Loaded debug symbols for {PH2}, found {PH3} source file(s)",
  /**
   * @description Error message that is displayed in the Console when debugging information cannot be loaded
   * @example {C/C++ DevTools Support (DWARF)} PH1
   * @example {http://web.dev/file.wasm} PH2
   * @example {File not found} PH3
   */
  failedToLoadDebugSymbolsFor: "[{PH1}] Failed to load debug symbols for {PH2} ({PH3})",
  /**
   * @description Error message that is displayed in UI debugging information cannot be found for a call frame
   * @example {main} PH1
   */
  failedToLoadDebugSymbolsForFunction: 'No debug information for function "{PH1}"',
  /**
   * @description Error message that is displayed in UI when a file needed for debugging information for a call frame is missing
   * @example {mainp.debug.wasm.dwp} PH1
   */
  debugSymbolsIncomplete: "The debug information for function {PH1} is incomplete"
};
var str_2 = i18n3.i18n.registerUIStrings("models/bindings/DebuggerLanguagePlugins.ts", UIStrings2);
var i18nString2 = i18n3.i18n.getLocalizedString.bind(void 0, str_2);
function rawModuleIdForScript(script) {
  return `${script.sourceURL}@${script.hash}`;
}
function getRawLocation(callFrame) {
  const { script } = callFrame;
  return {
    rawModuleId: rawModuleIdForScript(script),
    codeOffset: callFrame.location().columnNumber - (script.codeOffset() || 0),
    inlineFrameIndex: callFrame.inlineFrameIndex
  };
}
var FormattingError = class _FormattingError extends Error {
  exception;
  exceptionDetails;
  constructor(exception, exceptionDetails) {
    const { description } = exceptionDetails.exception || {};
    super(description || exceptionDetails.text);
    this.exception = exception;
    this.exceptionDetails = exceptionDetails;
  }
  static makeLocal(callFrame, message) {
    const exception = {
      type: Runtime.RemoteObjectType.Object,
      subtype: Runtime.RemoteObjectSubtype.Error,
      description: message
    };
    const exceptionDetails = { text: "Uncaught", exceptionId: -1, columnNumber: 0, lineNumber: 0, exception };
    const errorObject = callFrame.debuggerModel.runtimeModel().createRemoteObject(exception);
    return new _FormattingError(errorObject, exceptionDetails);
  }
};
var NamespaceObject = class extends SDK8.RemoteObject.LocalJSONObject {
  get description() {
    return this.type;
  }
  get type() {
    return "namespace";
  }
};
async function getRemoteObject(callFrame, object) {
  if (!/^(local|global|operand)$/.test(object.valueClass)) {
    return { type: Runtime.RemoteObjectType.Undefined };
  }
  const index = Number(object.index);
  const expression = `${object.valueClass}s[${index}]`;
  const response = await callFrame.debuggerModel.agent.invoke_evaluateOnCallFrame({
    callFrameId: callFrame.id,
    expression,
    silent: true,
    generatePreview: true,
    throwOnSideEffect: true
  });
  if (response.getError() || response.exceptionDetails) {
    return { type: Runtime.RemoteObjectType.Undefined };
  }
  return response.result;
}
async function wrapRemoteObject(callFrame, object, plugin) {
  if (object.type === "reftype") {
    const obj = await getRemoteObject(callFrame, object);
    return callFrame.debuggerModel.runtimeModel().createRemoteObject(obj);
  }
  return new ExtensionRemoteObject(callFrame, object, plugin);
}
var SourceScopeRemoteObject = class extends SDK8.RemoteObject.RemoteObjectImpl {
  variables;
  #callFrame;
  #plugin;
  stopId;
  constructor(callFrame, stopId, plugin) {
    super(callFrame.debuggerModel.runtimeModel(), void 0, "object", void 0, null);
    this.variables = [];
    this.#callFrame = callFrame;
    this.#plugin = plugin;
    this.stopId = stopId;
  }
  async doGetProperties(_ownProperties, accessorPropertiesOnly, _generatePreview) {
    if (accessorPropertiesOnly) {
      return { properties: [], internalProperties: [] };
    }
    const properties = [];
    const namespaces = {};
    function makeProperty(name, obj) {
      return new SDK8.RemoteObject.RemoteObjectProperty(
        name,
        obj,
        /* enumerable=*/
        false,
        /* writable=*/
        false,
        /* isOwn=*/
        true,
        /* wasThrown=*/
        false
      );
    }
    for (const variable of this.variables) {
      let sourceVar;
      try {
        const evalResult = await this.#plugin.evaluate(variable.name, getRawLocation(this.#callFrame), this.stopId);
        sourceVar = evalResult ? await wrapRemoteObject(this.#callFrame, evalResult, this.#plugin) : new SDK8.RemoteObject.LocalJSONObject(void 0);
      } catch (e) {
        console.warn(e);
        sourceVar = new SDK8.RemoteObject.LocalJSONObject(void 0);
      }
      if (variable.nestedName && variable.nestedName.length > 1) {
        let parent = namespaces;
        for (let index = 0; index < variable.nestedName.length - 1; index++) {
          const nestedName = variable.nestedName[index];
          let child = parent[nestedName];
          if (!child) {
            child = new NamespaceObject({});
            parent[nestedName] = child;
          }
          parent = child.value;
        }
        const name = variable.nestedName[variable.nestedName.length - 1];
        parent[name] = sourceVar;
      } else {
        properties.push(makeProperty(variable.name, sourceVar));
      }
    }
    for (const namespace in namespaces) {
      properties.push(makeProperty(namespace, namespaces[namespace]));
    }
    return { properties, internalProperties: [] };
  }
};
var SourceScope = class {
  #callFrame;
  #type;
  #typeName;
  #icon;
  #object;
  constructor(callFrame, stopId, type, typeName, icon, plugin) {
    if (icon && new URL(icon).protocol !== "data:") {
      throw new Error("The icon must be a data:-URL");
    }
    this.#callFrame = callFrame;
    this.#type = type;
    this.#typeName = typeName;
    this.#icon = icon;
    this.#object = new SourceScopeRemoteObject(callFrame, stopId, plugin);
  }
  async getVariableValue(name) {
    for (let v = 0; v < this.#object.variables.length; ++v) {
      if (this.#object.variables[v].name !== name) {
        continue;
      }
      const properties = await this.#object.getAllProperties(false, false);
      if (!properties.properties) {
        continue;
      }
      const { value } = properties.properties[v];
      if (value) {
        return value;
      }
    }
    return null;
  }
  callFrame() {
    return this.#callFrame;
  }
  type() {
    return this.#type;
  }
  typeName() {
    return this.#typeName;
  }
  name() {
    return void 0;
  }
  range() {
    return null;
  }
  object() {
    return this.#object;
  }
  description() {
    return "";
  }
  icon() {
    return this.#icon;
  }
  extraProperties() {
    return [];
  }
};
var ExtensionRemoteObject = class extends SDK8.RemoteObject.RemoteObject {
  extensionObject;
  plugin;
  callFrame;
  constructor(callFrame, extensionObject, plugin) {
    super();
    this.extensionObject = extensionObject;
    this.plugin = plugin;
    this.callFrame = callFrame;
  }
  get linearMemoryAddress() {
    return this.extensionObject.linearMemoryAddress;
  }
  get linearMemorySize() {
    return this.extensionObject.linearMemorySize;
  }
  get objectId() {
    return this.extensionObject.objectId;
  }
  get type() {
    if (this.extensionObject.type === "array" || this.extensionObject.type === "null") {
      return "object";
    }
    return this.extensionObject.type;
  }
  get subtype() {
    if (this.extensionObject.type === "array" || this.extensionObject.type === "null") {
      return this.extensionObject.type;
    }
    return void 0;
  }
  get value() {
    return this.extensionObject.value;
  }
  unserializableValue() {
    return void 0;
  }
  get description() {
    return this.extensionObject.description;
  }
  set description(_description) {
  }
  get hasChildren() {
    return this.extensionObject.hasChildren;
  }
  get preview() {
    return void 0;
  }
  get className() {
    return this.extensionObject.className ?? null;
  }
  arrayLength() {
    return 0;
  }
  arrayBufferByteLength() {
    return 0;
  }
  getOwnProperties(_generatePreview, _nonIndexedPropertiesOnly) {
    return this.getAllProperties(false, _generatePreview, _nonIndexedPropertiesOnly);
  }
  async getAllProperties(_accessorPropertiesOnly, _generatePreview, _nonIndexedPropertiesOnly) {
    const { objectId } = this.extensionObject;
    if (objectId) {
      assertNotNullOrUndefined(this.plugin.getProperties);
      const extensionObjectProperties = await this.plugin.getProperties(objectId);
      const properties = await Promise.all(extensionObjectProperties.map(
        async (p) => new SDK8.RemoteObject.RemoteObjectProperty(
          p.name,
          await wrapRemoteObject(this.callFrame, p.value, this.plugin)
        )
      ));
      return { properties, internalProperties: null };
    }
    return { properties: null, internalProperties: null };
  }
  release() {
    const { objectId } = this.extensionObject;
    if (objectId) {
      assertNotNullOrUndefined(this.plugin.releaseObject);
      void this.plugin.releaseObject(objectId);
    }
  }
  debuggerModel() {
    return this.callFrame.debuggerModel;
  }
  runtimeModel() {
    return this.callFrame.debuggerModel.runtimeModel();
  }
  isLinearMemoryInspectable() {
    return this.extensionObject.linearMemoryAddress !== void 0;
  }
};
var DebuggerLanguagePluginManager = class {
  #workspace;
  #debuggerWorkspaceBinding;
  #plugins;
  #debuggerModelToData;
  #rawModuleHandles;
  callFrameByStopId = /* @__PURE__ */ new Map();
  stopIdByCallFrame = /* @__PURE__ */ new Map();
  nextStopId = 0n;
  constructor(targetManager, workspace, debuggerWorkspaceBinding) {
    this.#workspace = workspace;
    this.#debuggerWorkspaceBinding = debuggerWorkspaceBinding;
    this.#plugins = [];
    this.#debuggerModelToData = /* @__PURE__ */ new Map();
    targetManager.observeModels(SDK8.DebuggerModel.DebuggerModel, this);
    this.#rawModuleHandles = /* @__PURE__ */ new Map();
  }
  async evaluateOnCallFrame(callFrame, options) {
    const { script } = callFrame;
    const { expression, returnByValue, throwOnSideEffect } = options;
    const { plugin } = await this.rawModuleIdAndPluginForScript(script);
    if (!plugin) {
      return null;
    }
    const location = getRawLocation(callFrame);
    const sourceLocations = await plugin.rawLocationToSourceLocation(location);
    if (sourceLocations.length === 0) {
      return null;
    }
    if (returnByValue) {
      return { error: "Cannot return by value" };
    }
    if (throwOnSideEffect) {
      return { error: "Cannot guarantee side-effect freedom" };
    }
    try {
      const object = await plugin.evaluate(expression, location, this.stopIdForCallFrame(callFrame));
      if (object) {
        return { object: await wrapRemoteObject(callFrame, object, plugin), exceptionDetails: void 0 };
      }
      return { object: new SDK8.RemoteObject.LocalJSONObject(void 0), exceptionDetails: void 0 };
    } catch (error) {
      if (error instanceof FormattingError) {
        const { exception: object2, exceptionDetails: exceptionDetails2 } = error;
        return { object: object2, exceptionDetails: exceptionDetails2 };
      }
      const { exception: object, exceptionDetails } = FormattingError.makeLocal(callFrame, error.message);
      return { object, exceptionDetails };
    }
  }
  stopIdForCallFrame(callFrame) {
    let stopId = this.stopIdByCallFrame.get(callFrame);
    if (stopId !== void 0) {
      return stopId;
    }
    stopId = this.nextStopId++;
    this.stopIdByCallFrame.set(callFrame, stopId);
    this.callFrameByStopId.set(stopId, callFrame);
    return stopId;
  }
  callFrameForStopId(stopId) {
    return this.callFrameByStopId.get(stopId);
  }
  expandCallFrames(callFrames) {
    return Promise.all(callFrames.map(async (callFrame) => {
      const functionInfo = await this.getFunctionInfo(callFrame.script, callFrame.location());
      if (functionInfo) {
        if ("frames" in functionInfo && functionInfo.frames.length) {
          return functionInfo.frames.map(({ name }, index) => callFrame.createVirtualCallFrame(index, name));
        }
        if ("missingSymbolFiles" in functionInfo && functionInfo.missingSymbolFiles.length) {
          const resources = functionInfo.missingSymbolFiles;
          const details = i18nString2(UIStrings2.debugSymbolsIncomplete, { PH1: callFrame.functionName });
          callFrame.missingDebugInfoDetails = { details, resources };
        } else {
          callFrame.missingDebugInfoDetails = {
            details: i18nString2(UIStrings2.failedToLoadDebugSymbolsForFunction, { PH1: callFrame.functionName }),
            resources: []
          };
        }
      }
      return callFrame;
    })).then((callFrames2) => callFrames2.flat());
  }
  modelAdded(debuggerModel) {
    this.#debuggerModelToData.set(debuggerModel, new ModelData(debuggerModel, this.#workspace));
    debuggerModel.addEventListener(SDK8.DebuggerModel.Events.GlobalObjectCleared, this.globalObjectCleared, this);
    debuggerModel.addEventListener(SDK8.DebuggerModel.Events.ParsedScriptSource, this.parsedScriptSource, this);
    debuggerModel.addEventListener(SDK8.DebuggerModel.Events.DebuggerResumed, this.debuggerResumed, this);
    debuggerModel.setEvaluateOnCallFrameCallback(this.evaluateOnCallFrame.bind(this));
    debuggerModel.setExpandCallFramesCallback(this.expandCallFrames.bind(this));
  }
  modelRemoved(debuggerModel) {
    debuggerModel.removeEventListener(SDK8.DebuggerModel.Events.GlobalObjectCleared, this.globalObjectCleared, this);
    debuggerModel.removeEventListener(SDK8.DebuggerModel.Events.ParsedScriptSource, this.parsedScriptSource, this);
    debuggerModel.removeEventListener(SDK8.DebuggerModel.Events.DebuggerResumed, this.debuggerResumed, this);
    debuggerModel.setEvaluateOnCallFrameCallback(null);
    debuggerModel.setExpandCallFramesCallback(null);
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (modelData) {
      modelData.dispose();
      this.#debuggerModelToData.delete(debuggerModel);
    }
    this.#rawModuleHandles.forEach((rawModuleHandle, rawModuleId) => {
      const scripts = rawModuleHandle.scripts.filter((script) => script.debuggerModel !== debuggerModel);
      if (scripts.length === 0) {
        rawModuleHandle.plugin.removeRawModule(rawModuleId).catch((error) => {
          Common8.Console.Console.instance().error(
            i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }),
            /* show=*/
            false
          );
        });
        this.#rawModuleHandles.delete(rawModuleId);
      } else {
        rawModuleHandle.scripts = scripts;
      }
    });
  }
  globalObjectCleared(event) {
    const debuggerModel = event.data;
    this.modelRemoved(debuggerModel);
    this.modelAdded(debuggerModel);
  }
  addPlugin(plugin) {
    this.#plugins.push(plugin);
    for (const debuggerModel of this.#debuggerModelToData.keys()) {
      for (const script of debuggerModel.scripts()) {
        if (this.hasPluginForScript(script)) {
          continue;
        }
        this.parsedScriptSource({ data: script });
      }
    }
  }
  removePlugin(plugin) {
    this.#plugins = this.#plugins.filter((p) => p !== plugin);
    const scripts = /* @__PURE__ */ new Set();
    this.#rawModuleHandles.forEach((rawModuleHandle, rawModuleId) => {
      if (rawModuleHandle.plugin !== plugin) {
        return;
      }
      rawModuleHandle.scripts.forEach((script) => scripts.add(script));
      this.#rawModuleHandles.delete(rawModuleId);
    });
    for (const script of scripts) {
      const modelData = this.#debuggerModelToData.get(script.debuggerModel);
      modelData.removeScript(script);
      this.parsedScriptSource({ data: script });
    }
  }
  hasPluginForScript(script) {
    const rawModuleId = rawModuleIdForScript(script);
    const rawModuleHandle = this.#rawModuleHandles.get(rawModuleId);
    return rawModuleHandle?.scripts.includes(script) ?? false;
  }
  /**
   * Returns the responsible language #plugin and the raw module ID for a script.
   *
   * This ensures that the `addRawModule` call finishes first such that the
   * caller can immediately issue calls to the returned #plugin without the
   * risk of racing with the `addRawModule` call. The returned #plugin will be
   * set to undefined to indicate that there's no #plugin for the script.
   */
  async rawModuleIdAndPluginForScript(script) {
    const rawModuleId = rawModuleIdForScript(script);
    const rawModuleHandle = this.#rawModuleHandles.get(rawModuleId);
    if (rawModuleHandle) {
      await rawModuleHandle.addRawModulePromise;
      if (rawModuleHandle === this.#rawModuleHandles.get(rawModuleId)) {
        return { rawModuleId, plugin: rawModuleHandle.plugin };
      }
    }
    return { rawModuleId, plugin: null };
  }
  uiSourceCodeForURL(debuggerModel, url) {
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (modelData) {
      return modelData.getProject().uiSourceCodeForURL(url);
    }
    return null;
  }
  async rawLocationToUILocation(rawLocation) {
    const script = rawLocation.script();
    if (!script) {
      return null;
    }
    const { rawModuleId, plugin } = await this.rawModuleIdAndPluginForScript(script);
    if (!plugin) {
      return null;
    }
    const pluginLocation = {
      rawModuleId,
      // RawLocation.#columnNumber is the byte offset in the full raw wasm module. Plugins expect the offset in the code
      // section, so subtract the offset of the code section in the module here.
      codeOffset: rawLocation.columnNumber - (script.codeOffset() || 0),
      inlineFrameIndex: rawLocation.inlineFrameIndex
    };
    try {
      const sourceLocations = await plugin.rawLocationToSourceLocation(pluginLocation);
      for (const sourceLocation of sourceLocations) {
        const uiSourceCode = this.uiSourceCodeForURL(
          script.debuggerModel,
          sourceLocation.sourceFileURL
        );
        if (!uiSourceCode) {
          continue;
        }
        return uiSourceCode.uiLocation(
          sourceLocation.lineNumber,
          sourceLocation.columnNumber >= 0 ? sourceLocation.columnNumber : void 0
        );
      }
    } catch (error) {
      Common8.Console.Console.instance().error(
        i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }),
        /* show=*/
        false
      );
    }
    return null;
  }
  uiLocationToRawLocationRanges(uiSourceCode, lineNumber, columnNumber = -1) {
    const locationPromises = [];
    this.scriptsForUISourceCode(uiSourceCode).forEach((script) => {
      const rawModuleId = rawModuleIdForScript(script);
      const rawModuleHandle = this.#rawModuleHandles.get(rawModuleId);
      if (!rawModuleHandle) {
        return;
      }
      const { plugin } = rawModuleHandle;
      locationPromises.push(getLocations(rawModuleId, plugin, script));
    });
    if (locationPromises.length === 0) {
      return Promise.resolve(null);
    }
    return Promise.all(locationPromises).then((locations) => locations.flat()).catch((error) => {
      Common8.Console.Console.instance().error(
        i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }),
        /* show=*/
        false
      );
      return null;
    });
    async function getLocations(rawModuleId, plugin, script) {
      const pluginLocation = { rawModuleId, sourceFileURL: uiSourceCode.url(), lineNumber, columnNumber };
      const rawLocations = await plugin.sourceLocationToRawLocation(pluginLocation);
      if (!rawLocations) {
        return [];
      }
      return rawLocations.map(
        (m) => ({
          start: new SDK8.DebuggerModel.Location(
            script.debuggerModel,
            script.scriptId,
            0,
            Number(m.startOffset) + (script.codeOffset() || 0)
          ),
          end: new SDK8.DebuggerModel.Location(
            script.debuggerModel,
            script.scriptId,
            0,
            Number(m.endOffset) + (script.codeOffset() || 0)
          )
        })
      );
    }
  }
  async uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber) {
    const locationRanges = await this.uiLocationToRawLocationRanges(uiSourceCode, lineNumber, columnNumber);
    if (!locationRanges) {
      return null;
    }
    return locationRanges.map(({ start }) => start);
  }
  async uiLocationRangeToRawLocationRanges(uiSourceCode, textRange) {
    const locationRangesPromises = [];
    for (let line = textRange.startLine; line <= textRange.endLine; ++line) {
      locationRangesPromises.push(this.uiLocationToRawLocationRanges(uiSourceCode, line));
    }
    const ranges = [];
    for (const locationRanges of await Promise.all(locationRangesPromises)) {
      if (locationRanges === null) {
        return null;
      }
      for (const range of locationRanges) {
        const [startLocation, endLocation] = await Promise.all([
          this.rawLocationToUILocation(range.start),
          this.rawLocationToUILocation(range.end)
        ]);
        if (startLocation === null || endLocation === null) {
          continue;
        }
        const overlap = textRange.intersection(new TextUtils5.TextRange.TextRange(
          startLocation.lineNumber,
          startLocation.columnNumber ?? 0,
          endLocation.lineNumber,
          endLocation.columnNumber ?? Infinity
        ));
        if (!overlap.isEmpty()) {
          ranges.push(range);
        }
      }
    }
    return ranges;
  }
  async translateRawFramesStep(rawFrames, translatedFrames, target) {
    const frame = rawFrames[0];
    const script = target.model(SDK8.DebuggerModel.DebuggerModel)?.scriptForId(frame.scriptId ?? "");
    if (!script) {
      return false;
    }
    const functionInfo = await this.getFunctionInfo(script, frame);
    if (!functionInfo) {
      return false;
    }
    rawFrames.shift();
    if ("frames" in functionInfo && functionInfo.frames.length) {
      const framePromises = functionInfo.frames.map(async ({ name }, index) => {
        const rawLocation = new SDK8.DebuggerModel.Location(
          script.debuggerModel,
          script.scriptId,
          frame.lineNumber,
          frame.columnNumber,
          index
        );
        const uiLocation = await this.rawLocationToUILocation(rawLocation);
        return {
          uiSourceCode: uiLocation?.uiSourceCode,
          url: uiLocation ? void 0 : frame.url,
          name,
          line: uiLocation?.lineNumber ?? frame.lineNumber,
          column: uiLocation?.columnNumber ?? frame.columnNumber
        };
      });
      translatedFrames.push(await Promise.all(framePromises));
      return true;
    }
    const mappedFrame = {
      url: frame.url,
      name: frame.functionName,
      line: frame.lineNumber,
      column: frame.columnNumber
    };
    if ("missingSymbolFiles" in functionInfo && functionInfo.missingSymbolFiles.length) {
      translatedFrames.push([{
        ...mappedFrame,
        missingDebugInfo: {
          type: StackTrace3.StackTrace.MissingDebugInfoType.PARTIAL_INFO,
          missingDebugFiles: functionInfo.missingSymbolFiles
        }
      }]);
    } else {
      translatedFrames.push([{
        ...mappedFrame,
        missingDebugInfo: {
          type: StackTrace3.StackTrace.MissingDebugInfoType.NO_INFO
        }
      }]);
    }
    return true;
  }
  scriptsForUISourceCode(uiSourceCode) {
    for (const modelData of this.#debuggerModelToData.values()) {
      const scripts = modelData.uiSourceCodeToScripts.get(uiSourceCode);
      if (scripts) {
        return scripts;
      }
    }
    return [];
  }
  setDebugInfoURL(script, externalURL) {
    if (this.hasPluginForScript(script)) {
      return;
    }
    script.debugSymbols = { type: Debugger.DebugSymbolsType.ExternalDWARF, externalURL };
    this.parsedScriptSource({ data: script });
    void script.debuggerModel.setDebugInfoURL(script, externalURL);
  }
  parsedScriptSource(event) {
    const script = event.data;
    if (!script.sourceURL) {
      return;
    }
    for (const plugin of this.#plugins) {
      if (!plugin.handleScript(script)) {
        continue;
      }
      const rawModuleId = rawModuleIdForScript(script);
      let rawModuleHandle = this.#rawModuleHandles.get(rawModuleId);
      if (!rawModuleHandle) {
        const sourceFileURLsPromise = (async () => {
          const console2 = Common8.Console.Console.instance();
          const url = script.sourceURL;
          const symbolsUrl = script.debugSymbols?.externalURL || "";
          if (symbolsUrl) {
            console2.log(i18nString2(UIStrings2.loadingDebugSymbolsForVia, { PH1: plugin.name, PH2: url, PH3: symbolsUrl }));
          } else {
            console2.log(i18nString2(UIStrings2.loadingDebugSymbolsFor, { PH1: plugin.name, PH2: url }));
          }
          try {
            const code = !symbolsUrl && Common8.ParsedURL.schemeIs(url, "wasm:") ? await script.getWasmBytecode() : void 0;
            const addModuleResult = await plugin.addRawModule(rawModuleId, symbolsUrl, { url, code });
            if (rawModuleHandle !== this.#rawModuleHandles.get(rawModuleId)) {
              return [];
            }
            if ("missingSymbolFiles" in addModuleResult) {
              const initiator = plugin.createPageResourceLoadInitiator();
              const missingSymbolFiles = addModuleResult.missingSymbolFiles.map((resource) => {
                const resourceUrl = resource;
                return { resourceUrl, initiator };
              });
              return { missingSymbolFiles };
            }
            const sourceFileURLs = addModuleResult;
            if (sourceFileURLs.length === 0) {
              console2.warn(i18nString2(UIStrings2.loadedDebugSymbolsForButDidnt, { PH1: plugin.name, PH2: url }));
            } else {
              console2.log(i18nString2(
                UIStrings2.loadedDebugSymbolsForFound,
                { PH1: plugin.name, PH2: url, PH3: sourceFileURLs.length }
              ));
            }
            return sourceFileURLs;
          } catch (error) {
            console2.error(
              i18nString2(UIStrings2.failedToLoadDebugSymbolsFor, { PH1: plugin.name, PH2: url, PH3: error.message }),
              /* show=*/
              false
            );
            this.#rawModuleHandles.delete(rawModuleId);
            return [];
          }
        })();
        rawModuleHandle = { rawModuleId, plugin, scripts: [script], addRawModulePromise: sourceFileURLsPromise };
        this.#rawModuleHandles.set(rawModuleId, rawModuleHandle);
      } else {
        rawModuleHandle.scripts.push(script);
      }
      void rawModuleHandle.addRawModulePromise.then((sourceFileURLs) => {
        if (!("missingSymbolFiles" in sourceFileURLs)) {
          if (script.debuggerModel.scriptForId(script.scriptId) === script) {
            const modelData = this.#debuggerModelToData.get(script.debuggerModel);
            if (modelData) {
              modelData.addSourceFiles(script, sourceFileURLs);
              void this.#debuggerWorkspaceBinding.updateLocations(script);
            }
          }
        }
      });
      return;
    }
  }
  debuggerResumed(event) {
    const resumedFrames = Array.from(this.callFrameByStopId.values()).filter((callFrame) => callFrame.debuggerModel === event.data);
    for (const callFrame of resumedFrames) {
      const stopId = this.stopIdByCallFrame.get(callFrame);
      assertNotNullOrUndefined(stopId);
      this.stopIdByCallFrame.delete(callFrame);
      this.callFrameByStopId.delete(stopId);
    }
  }
  getSourcesForScript(script) {
    const rawModuleId = rawModuleIdForScript(script);
    const rawModuleHandle = this.#rawModuleHandles.get(rawModuleId);
    if (rawModuleHandle) {
      return rawModuleHandle.addRawModulePromise;
    }
    return Promise.resolve(void 0);
  }
  async resolveScopeChain(callFrame) {
    const script = callFrame.script;
    const { rawModuleId, plugin } = await this.rawModuleIdAndPluginForScript(script);
    if (!plugin) {
      return null;
    }
    const location = {
      rawModuleId,
      codeOffset: callFrame.location().columnNumber - (script.codeOffset() || 0),
      inlineFrameIndex: callFrame.inlineFrameIndex
    };
    const stopId = this.stopIdForCallFrame(callFrame);
    try {
      const sourceMapping = await plugin.rawLocationToSourceLocation(location);
      if (sourceMapping.length === 0) {
        return null;
      }
      const scopes = /* @__PURE__ */ new Map();
      const variables = await plugin.listVariablesInScope(location);
      for (const variable of variables || []) {
        let scope = scopes.get(variable.scope);
        if (!scope) {
          const { type, typeName, icon } = await plugin.getScopeInfo(variable.scope);
          scope = new SourceScope(callFrame, stopId, type, typeName, icon, plugin);
          scopes.set(variable.scope, scope);
        }
        scope.object().variables.push(variable);
      }
      return Array.from(scopes.values());
    } catch (error) {
      Common8.Console.Console.instance().error(
        i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }),
        /* show=*/
        false
      );
      return null;
    }
  }
  async getFunctionInfo(script, location) {
    const { rawModuleId, plugin } = await this.rawModuleIdAndPluginForScript(script);
    if (!plugin) {
      return null;
    }
    const rawLocation = {
      rawModuleId,
      codeOffset: location.columnNumber - (script.codeOffset() || 0),
      inlineFrameIndex: 0
    };
    try {
      const functionInfo = await plugin.getFunctionInfo(rawLocation);
      if ("missingSymbolFiles" in functionInfo) {
        const initiator = plugin.createPageResourceLoadInitiator();
        const missingSymbolFiles = functionInfo.missingSymbolFiles.map((resource) => {
          const resourceUrl = resource;
          return { resourceUrl, initiator };
        });
        return { missingSymbolFiles, ..."frames" in functionInfo && { frames: functionInfo.frames } };
      }
      return functionInfo;
    } catch (error) {
      Common8.Console.Console.instance().warn(i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }));
      return { frames: [] };
    }
  }
  async getInlinedFunctionRanges(rawLocation) {
    const script = rawLocation.script();
    if (!script) {
      return [];
    }
    const { rawModuleId, plugin } = await this.rawModuleIdAndPluginForScript(script);
    if (!plugin) {
      return [];
    }
    const pluginLocation = {
      rawModuleId,
      // RawLocation.#columnNumber is the byte offset in the full raw wasm module. Plugins expect the offset in the code
      // section, so subtract the offset of the code section in the module here.
      codeOffset: rawLocation.columnNumber - (script.codeOffset() || 0)
    };
    try {
      const locations = await plugin.getInlinedFunctionRanges(pluginLocation);
      return locations.map(
        (m) => ({
          start: new SDK8.DebuggerModel.Location(
            script.debuggerModel,
            script.scriptId,
            0,
            Number(m.startOffset) + (script.codeOffset() || 0)
          ),
          end: new SDK8.DebuggerModel.Location(
            script.debuggerModel,
            script.scriptId,
            0,
            Number(m.endOffset) + (script.codeOffset() || 0)
          )
        })
      );
    } catch (error) {
      Common8.Console.Console.instance().warn(i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }));
      return [];
    }
  }
  async getInlinedCalleesRanges(rawLocation) {
    const script = rawLocation.script();
    if (!script) {
      return [];
    }
    const { rawModuleId, plugin } = await this.rawModuleIdAndPluginForScript(script);
    if (!plugin) {
      return [];
    }
    const pluginLocation = {
      rawModuleId,
      // RawLocation.#columnNumber is the byte offset in the full raw wasm module. Plugins expect the offset in the code
      // section, so subtract the offset of the code section in the module here.
      codeOffset: rawLocation.columnNumber - (script.codeOffset() || 0)
    };
    try {
      const locations = await plugin.getInlinedCalleesRanges(pluginLocation);
      return locations.map(
        (m) => ({
          start: new SDK8.DebuggerModel.Location(
            script.debuggerModel,
            script.scriptId,
            0,
            Number(m.startOffset) + (script.codeOffset() || 0)
          ),
          end: new SDK8.DebuggerModel.Location(
            script.debuggerModel,
            script.scriptId,
            0,
            Number(m.endOffset) + (script.codeOffset() || 0)
          )
        })
      );
    } catch (error) {
      Common8.Console.Console.instance().warn(i18nString2(UIStrings2.errorInDebuggerLanguagePlugin, { PH1: error.message }));
      return [];
    }
  }
  async getMappedLines(uiSourceCode) {
    const rawModuleIds = await Promise.all(this.scriptsForUISourceCode(uiSourceCode).map((s) => this.rawModuleIdAndPluginForScript(s)));
    let mappedLines = null;
    for (const { rawModuleId, plugin } of rawModuleIds) {
      if (!plugin) {
        continue;
      }
      const lines = await plugin.getMappedLines(rawModuleId, uiSourceCode.url());
      if (lines === void 0) {
        continue;
      }
      if (mappedLines === null) {
        mappedLines = new Set(lines);
      } else {
        lines.forEach((l) => mappedLines.add(l));
      }
    }
    return mappedLines;
  }
};
var ModelData = class {
  project;
  uiSourceCodeToScripts;
  constructor(debuggerModel, workspace) {
    this.project = new ContentProviderBasedProject(
      workspace,
      "language_plugins::" + debuggerModel.target().id(),
      Workspace11.Workspace.projectTypes.Network,
      "",
      false
      /* isServiceProject */
    );
    NetworkProject.setTargetForProject(this.project, debuggerModel.target());
    this.uiSourceCodeToScripts = /* @__PURE__ */ new Map();
  }
  addSourceFiles(script, urls) {
    const initiator = script.createPageResourceLoadInitiator();
    for (const url of urls) {
      let uiSourceCode = this.project.uiSourceCodeForURL(url);
      if (!uiSourceCode) {
        uiSourceCode = this.project.createUISourceCode(url, Common8.ResourceType.resourceTypes.SourceMapScript);
        NetworkProject.setInitialFrameAttribution(uiSourceCode, script.frameId);
        this.uiSourceCodeToScripts.set(uiSourceCode, [script]);
        const contentProvider = new SDK8.CompilerSourceMappingContentProvider.CompilerSourceMappingContentProvider(
          url,
          Common8.ResourceType.resourceTypes.SourceMapScript,
          initiator
        );
        const mimeType = Common8.ResourceType.ResourceType.mimeFromURL(url) || "text/javascript";
        this.project.addUISourceCodeWithProvider(uiSourceCode, contentProvider, null, mimeType);
      } else {
        const scripts = this.uiSourceCodeToScripts.get(uiSourceCode);
        if (!scripts.includes(script)) {
          scripts.push(script);
        }
      }
    }
  }
  removeScript(script) {
    this.uiSourceCodeToScripts.forEach((scripts, uiSourceCode) => {
      scripts = scripts.filter((s) => s !== script);
      if (scripts.length === 0) {
        this.uiSourceCodeToScripts.delete(uiSourceCode);
        this.project.removeUISourceCode(uiSourceCode.url());
      } else {
        this.uiSourceCodeToScripts.set(uiSourceCode, scripts);
      }
    });
  }
  dispose() {
    this.project.dispose();
  }
  getProject() {
    return this.project;
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/DebuggerWorkspaceBinding.js
var DebuggerWorkspaceBinding_exports = {};
__export(DebuggerWorkspaceBinding_exports, {
  DebuggerWorkspaceBinding: () => DebuggerWorkspaceBinding,
  Location: () => Location
});
import * as Common11 from "./../../core/common/common.js";
import * as Platform6 from "./../../core/platform/platform.js";
import * as SDK11 from "./../../core/sdk/sdk.js";
import * as Workspace17 from "./../workspace/workspace.js";

// gen/third_party/devtools-frontend/src/front_end/models/bindings/DefaultScriptMapping.js
var DefaultScriptMapping_exports = {};
__export(DefaultScriptMapping_exports, {
  DefaultScriptMapping: () => DefaultScriptMapping
});
import * as Common9 from "./../../core/common/common.js";
import * as SDK9 from "./../../core/sdk/sdk.js";
import * as Workspace13 from "./../workspace/workspace.js";
var DefaultScriptMapping = class _DefaultScriptMapping {
  #debuggerWorkspaceBinding;
  #project;
  #eventListeners;
  #uiSourceCodeToScript;
  #scriptToUISourceCode;
  constructor(debuggerModel, workspace, debuggerWorkspaceBinding) {
    defaultScriptMappings.add(this);
    this.#debuggerWorkspaceBinding = debuggerWorkspaceBinding;
    this.#project = new ContentProviderBasedProject(
      workspace,
      "debugger:" + debuggerModel.target().id(),
      Workspace13.Workspace.projectTypes.Debugger,
      "",
      true
      /* isServiceProject */
    );
    this.#eventListeners = [
      debuggerModel.addEventListener(SDK9.DebuggerModel.Events.GlobalObjectCleared, this.globalObjectCleared, this),
      debuggerModel.addEventListener(SDK9.DebuggerModel.Events.ParsedScriptSource, this.parsedScriptSource, this),
      debuggerModel.addEventListener(
        SDK9.DebuggerModel.Events.DiscardedAnonymousScriptSource,
        this.discardedScriptSource,
        this
      )
    ];
    this.#uiSourceCodeToScript = /* @__PURE__ */ new Map();
    this.#scriptToUISourceCode = /* @__PURE__ */ new Map();
  }
  static createV8ScriptURL(script) {
    const name = Common9.ParsedURL.ParsedURL.extractName(script.sourceURL);
    const url = "debugger:///VM" + script.scriptId + (name ? " " + name : "");
    return url;
  }
  static scriptForUISourceCode(uiSourceCode) {
    for (const defaultScriptMapping of defaultScriptMappings) {
      const script = defaultScriptMapping.#uiSourceCodeToScript.get(uiSourceCode);
      if (script !== void 0) {
        return script;
      }
    }
    return null;
  }
  uiSourceCodeForScript(script) {
    return this.#scriptToUISourceCode.get(script) ?? null;
  }
  rawLocationToUILocation(rawLocation) {
    const script = rawLocation.script();
    if (!script) {
      return null;
    }
    const uiSourceCode = this.#scriptToUISourceCode.get(script);
    if (!uiSourceCode) {
      return null;
    }
    const { lineNumber, columnNumber } = script.rawLocationToRelativeLocation(rawLocation);
    return uiSourceCode.uiLocation(lineNumber, columnNumber);
  }
  uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber) {
    const script = this.#uiSourceCodeToScript.get(uiSourceCode);
    if (!script) {
      return [];
    }
    ({ lineNumber, columnNumber } = script.relativeLocationToRawLocation({ lineNumber, columnNumber }));
    return [script.debuggerModel.createRawLocation(script, lineNumber, columnNumber ?? 0)];
  }
  uiLocationRangeToRawLocationRanges(uiSourceCode, { startLine, startColumn, endLine, endColumn }) {
    const script = this.#uiSourceCodeToScript.get(uiSourceCode);
    if (!script) {
      return [];
    }
    ({ lineNumber: startLine, columnNumber: startColumn } = script.relativeLocationToRawLocation({ lineNumber: startLine, columnNumber: startColumn }));
    ({ lineNumber: endLine, columnNumber: endColumn } = script.relativeLocationToRawLocation({ lineNumber: endLine, columnNumber: endColumn }));
    const start = script.debuggerModel.createRawLocation(script, startLine, startColumn);
    const end = script.debuggerModel.createRawLocation(script, endLine, endColumn);
    return [{ start, end }];
  }
  parsedScriptSource(event) {
    const script = event.data;
    const url = _DefaultScriptMapping.createV8ScriptURL(script);
    const uiSourceCode = this.#project.createUISourceCode(url, Common9.ResourceType.resourceTypes.Script);
    if (script.isBreakpointCondition) {
      uiSourceCode.markAsUnconditionallyIgnoreListed();
    }
    this.#uiSourceCodeToScript.set(uiSourceCode, script);
    this.#scriptToUISourceCode.set(script, uiSourceCode);
    this.#project.addUISourceCodeWithProvider(uiSourceCode, script, null, "text/javascript");
    void this.#debuggerWorkspaceBinding.updateLocations(script);
  }
  discardedScriptSource(event) {
    const script = event.data;
    const uiSourceCode = this.#scriptToUISourceCode.get(script);
    if (uiSourceCode === void 0) {
      return;
    }
    this.#scriptToUISourceCode.delete(script);
    this.#uiSourceCodeToScript.delete(uiSourceCode);
    this.#project.removeUISourceCode(uiSourceCode.url());
  }
  globalObjectCleared() {
    this.#scriptToUISourceCode.clear();
    this.#uiSourceCodeToScript.clear();
    this.#project.reset();
  }
  dispose() {
    defaultScriptMappings.delete(this);
    Common9.EventTarget.removeEventListeners(this.#eventListeners);
    this.globalObjectCleared();
    this.#project.dispose();
  }
};
var defaultScriptMappings = /* @__PURE__ */ new Set();

// gen/third_party/devtools-frontend/src/front_end/models/bindings/ResourceScriptMapping.js
var ResourceScriptMapping_exports = {};
__export(ResourceScriptMapping_exports, {
  ResourceScriptFile: () => ResourceScriptFile,
  ResourceScriptMapping: () => ResourceScriptMapping
});
import * as Common10 from "./../../core/common/common.js";
import * as i18n5 from "./../../core/i18n/i18n.js";
import * as Platform5 from "./../../core/platform/platform.js";
import * as Root from "./../../core/root/root.js";
import * as SDK10 from "./../../core/sdk/sdk.js";
import * as TextUtils6 from "./../text_utils/text_utils.js";
import * as Workspace15 from "./../workspace/workspace.js";
var UIStrings3 = {
  /**
   * @description Error text displayed in the console when editing a live script fails. LiveEdit is
   *the name of the feature for editing code that is already running.
   * @example {warning} PH1
   */
  liveEditFailed: "`LiveEdit` failed: {PH1}",
  /**
   * @description Error text displayed in the console when compiling a live-edited script fails. LiveEdit is
   *the name of the feature for editing code that is already running.
   * @example {connection lost} PH1
   */
  liveEditCompileFailed: "`LiveEdit` compile failed: {PH1}"
};
var str_3 = i18n5.i18n.registerUIStrings("models/bindings/ResourceScriptMapping.ts", UIStrings3);
var i18nString3 = i18n5.i18n.getLocalizedString.bind(void 0, str_3);
var ResourceScriptMapping = class {
  debuggerModel;
  #workspace;
  debuggerWorkspaceBinding;
  #uiSourceCodeToScriptFile;
  #projects;
  #scriptToUISourceCode;
  #eventListeners;
  constructor(debuggerModel, workspace, debuggerWorkspaceBinding) {
    this.debuggerModel = debuggerModel;
    this.#workspace = workspace;
    this.debuggerWorkspaceBinding = debuggerWorkspaceBinding;
    this.#uiSourceCodeToScriptFile = /* @__PURE__ */ new Map();
    this.#projects = /* @__PURE__ */ new Map();
    this.#scriptToUISourceCode = /* @__PURE__ */ new Map();
    const runtimeModel = debuggerModel.runtimeModel();
    this.#eventListeners = [
      this.debuggerModel.addEventListener(
        SDK10.DebuggerModel.Events.ParsedScriptSource,
        (event) => this.addScript(event.data),
        this
      ),
      this.debuggerModel.addEventListener(SDK10.DebuggerModel.Events.GlobalObjectCleared, this.globalObjectCleared, this),
      runtimeModel.addEventListener(
        SDK10.RuntimeModel.Events.ExecutionContextDestroyed,
        this.executionContextDestroyed,
        this
      ),
      runtimeModel.target().targetManager().addEventListener(
        SDK10.TargetManager.Events.INSPECTED_URL_CHANGED,
        this.inspectedURLChanged,
        this
      )
    ];
  }
  project(script) {
    const prefix = script.isContentScript() ? "js:extensions:" : "js::";
    const projectId = prefix + this.debuggerModel.target().id() + ":" + script.frameId;
    let project = this.#projects.get(projectId);
    if (!project) {
      const projectType = script.isContentScript() ? Workspace15.Workspace.projectTypes.ContentScripts : Workspace15.Workspace.projectTypes.Network;
      project = new ContentProviderBasedProject(
        this.#workspace,
        projectId,
        projectType,
        "",
        false
        /* isServiceProject */
      );
      NetworkProject.setTargetForProject(project, this.debuggerModel.target());
      this.#projects.set(projectId, project);
    }
    return project;
  }
  uiSourceCodeForScript(script) {
    return this.#scriptToUISourceCode.get(script) ?? null;
  }
  rawLocationToUILocation(rawLocation) {
    const script = rawLocation.script();
    if (!script) {
      return null;
    }
    const uiSourceCode = this.#scriptToUISourceCode.get(script);
    if (!uiSourceCode) {
      return null;
    }
    const scriptFile = this.#uiSourceCodeToScriptFile.get(uiSourceCode);
    if (!scriptFile) {
      return null;
    }
    if (scriptFile.hasDivergedFromVM() && !scriptFile.isMergingToVM() || scriptFile.isDivergingFromVM()) {
      return null;
    }
    if (scriptFile.script !== script) {
      return null;
    }
    const { lineNumber, columnNumber = 0 } = rawLocation;
    return uiSourceCode.uiLocation(lineNumber, columnNumber);
  }
  uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber) {
    const scriptFile = this.#uiSourceCodeToScriptFile.get(uiSourceCode);
    if (!scriptFile) {
      return [];
    }
    const { script } = scriptFile;
    if (!script) {
      return [];
    }
    return [this.debuggerModel.createRawLocation(script, lineNumber, columnNumber)];
  }
  uiLocationRangeToRawLocationRanges(uiSourceCode, { startLine, startColumn, endLine, endColumn }) {
    const scriptFile = this.#uiSourceCodeToScriptFile.get(uiSourceCode);
    if (!scriptFile) {
      return null;
    }
    const { script } = scriptFile;
    if (!script) {
      return null;
    }
    const start = this.debuggerModel.createRawLocation(script, startLine, startColumn);
    const end = this.debuggerModel.createRawLocation(script, endLine, endColumn);
    return [{ start, end }];
  }
  inspectedURLChanged(event) {
    for (let target = this.debuggerModel.target(); target !== event.data; target = target.parentTarget()) {
      if (target === null) {
        return;
      }
    }
    for (const script of Array.from(this.#scriptToUISourceCode.keys())) {
      this.removeScripts([script]);
      this.addScript(script);
    }
  }
  addScript(script) {
    if (script.isLiveEdit() || script.isBreakpointCondition) {
      return;
    }
    let url = script.sourceURL;
    if (!url) {
      return;
    }
    if (script.hasSourceURL) {
      url = SDK10.SourceMapManager.SourceMapManager.resolveRelativeSourceURL(script.debuggerModel.target(), url);
    } else {
      if (script.isInlineScript()) {
        return;
      }
      if (script.isContentScript()) {
        const parsedURL = new Common10.ParsedURL.ParsedURL(url);
        if (!parsedURL.isValid) {
          return;
        }
      }
    }
    const project = this.project(script);
    const oldUISourceCode = project.uiSourceCodeForURL(url);
    if (oldUISourceCode) {
      const oldScriptFile = this.#uiSourceCodeToScriptFile.get(oldUISourceCode);
      if (oldScriptFile?.script) {
        this.removeScripts([oldScriptFile.script]);
      }
    }
    const originalContentProvider = script.originalContentProvider();
    const uiSourceCode = project.createUISourceCode(url, originalContentProvider.contentType());
    NetworkProject.setInitialFrameAttribution(uiSourceCode, script.frameId);
    const metadata = metadataForURL(this.debuggerModel.target(), script.frameId, url);
    const scriptFile = new ResourceScriptFile(this, uiSourceCode, script);
    this.#uiSourceCodeToScriptFile.set(uiSourceCode, scriptFile);
    this.#scriptToUISourceCode.set(script, uiSourceCode);
    const mimeType = script.isWasm() ? "application/wasm" : "text/javascript";
    project.addUISourceCodeWithProvider(uiSourceCode, originalContentProvider, metadata, mimeType);
    void this.debuggerWorkspaceBinding.updateLocations(script);
  }
  scriptFile(uiSourceCode) {
    return this.#uiSourceCodeToScriptFile.get(uiSourceCode) || null;
  }
  removeScripts(scripts) {
    const uiSourceCodesByProject = new Platform5.MapUtilities.Multimap();
    for (const script of scripts) {
      const uiSourceCode = this.#scriptToUISourceCode.get(script);
      if (!uiSourceCode) {
        continue;
      }
      const scriptFile = this.#uiSourceCodeToScriptFile.get(uiSourceCode);
      if (scriptFile) {
        scriptFile.dispose();
      }
      this.#uiSourceCodeToScriptFile.delete(uiSourceCode);
      this.#scriptToUISourceCode.delete(script);
      uiSourceCodesByProject.set(uiSourceCode.project(), uiSourceCode);
      void this.debuggerWorkspaceBinding.updateLocations(script);
    }
    for (const project of uiSourceCodesByProject.keysArray()) {
      const uiSourceCodes = uiSourceCodesByProject.get(project);
      let allInProjectRemoved = true;
      for (const projectSourceCode of project.uiSourceCodes()) {
        if (!uiSourceCodes.has(projectSourceCode)) {
          allInProjectRemoved = false;
          break;
        }
      }
      if (allInProjectRemoved) {
        this.#projects.delete(project.id());
        project.removeProject();
      } else {
        uiSourceCodes.forEach((c) => project.removeUISourceCode(c.url()));
      }
    }
  }
  executionContextDestroyed(event) {
    const executionContext = event.data;
    this.removeScripts(this.debuggerModel.scriptsForExecutionContext(executionContext));
  }
  globalObjectCleared() {
    const scripts = Array.from(this.#scriptToUISourceCode.keys());
    this.removeScripts(scripts);
  }
  resetForTest() {
    this.globalObjectCleared();
  }
  dispose() {
    Common10.EventTarget.removeEventListeners(this.#eventListeners);
    this.globalObjectCleared();
  }
};
var ResourceScriptFile = class _ResourceScriptFile extends Common10.ObjectWrapper.ObjectWrapper {
  #resourceScriptMapping;
  uiSourceCode;
  script;
  #scriptSource;
  #isDivergingFromVM;
  #hasDivergedFromVM;
  #isMergingToVM;
  #updateMutex = new Common10.Mutex.Mutex();
  constructor(resourceScriptMapping, uiSourceCode, script) {
    super();
    this.#resourceScriptMapping = resourceScriptMapping;
    this.uiSourceCode = uiSourceCode;
    this.script = this.uiSourceCode.contentType().isScript() ? script : null;
    this.uiSourceCode.addEventListener(Workspace15.UISourceCode.Events.WorkingCopyChanged, this.workingCopyChanged, this);
    this.uiSourceCode.addEventListener(
      Workspace15.UISourceCode.Events.WorkingCopyCommitted,
      this.workingCopyCommitted,
      this
    );
  }
  isDiverged() {
    if (this.uiSourceCode.isDirty()) {
      return true;
    }
    if (!this.script) {
      return false;
    }
    if (typeof this.#scriptSource === "undefined" || this.#scriptSource === null) {
      return false;
    }
    const workingCopy = this.uiSourceCode.workingCopy();
    if (!workingCopy) {
      return false;
    }
    if (!workingCopy.startsWith(this.#scriptSource.trimEnd())) {
      return true;
    }
    const suffix = this.uiSourceCode.workingCopy().substr(this.#scriptSource.length);
    return Boolean(suffix.length) && !suffix.match(SDK10.Script.sourceURLRegex);
  }
  workingCopyChanged() {
    void this.update();
  }
  workingCopyCommitted() {
    if (Root.Runtime.hostConfig.devToolsLiveEdit?.enabled === false) {
      return;
    }
    if (this.uiSourceCode.project().canSetFileContent()) {
      return;
    }
    if (!this.script) {
      return;
    }
    const source = this.uiSourceCode.workingCopy();
    void this.script.editSource(source).then(({ status, exceptionDetails }) => {
      void this.scriptSourceWasSet(source, status, exceptionDetails);
    });
  }
  async scriptSourceWasSet(source, status, exceptionDetails) {
    if (status === Debugger.SetScriptSourceResponseStatus.Ok) {
      this.#scriptSource = source;
    }
    await this.update();
    if (status === Debugger.SetScriptSourceResponseStatus.Ok) {
      return;
    }
    if (!exceptionDetails) {
      Common10.Console.Console.instance().addMessage(
        i18nString3(UIStrings3.liveEditFailed, { PH1: getErrorText(status) }),
        Common10.Console.MessageLevel.WARNING
      );
      return;
    }
    const messageText = i18nString3(UIStrings3.liveEditCompileFailed, { PH1: exceptionDetails.text });
    this.uiSourceCode.addLineMessage(
      Workspace15.UISourceCode.Message.Level.ERROR,
      messageText,
      exceptionDetails.lineNumber,
      exceptionDetails.columnNumber
    );
    function getErrorText(status2) {
      switch (status2) {
        case Debugger.SetScriptSourceResponseStatus.BlockedByActiveFunction:
          return "Functions that are on the stack (currently being executed) can not be edited";
        case Debugger.SetScriptSourceResponseStatus.BlockedByActiveGenerator:
          return "Async functions/generators that are active can not be edited";
        case Debugger.SetScriptSourceResponseStatus.BlockedByTopLevelEsModuleChange:
          return "The top-level of ES modules can not be edited";
        case Debugger.SetScriptSourceResponseStatus.CompileError:
        case Debugger.SetScriptSourceResponseStatus.Ok:
          throw new Error("Compile errors and Ok status must not be reported on the console");
      }
    }
  }
  async update() {
    const release = await this.#updateMutex.acquire();
    const diverged = this.isDiverged();
    if (diverged && !this.#hasDivergedFromVM) {
      await this.divergeFromVM();
    } else if (!diverged && this.#hasDivergedFromVM) {
      await this.mergeToVM();
    }
    release();
  }
  async divergeFromVM() {
    if (this.script) {
      this.#isDivergingFromVM = true;
      await this.#resourceScriptMapping.debuggerWorkspaceBinding.updateLocations(this.script);
      this.#isDivergingFromVM = void 0;
      this.#hasDivergedFromVM = true;
      this.dispatchEventToListeners(_ResourceScriptFile.Events.DID_DIVERGE_FROM_VM);
    }
  }
  async mergeToVM() {
    if (this.script) {
      this.#hasDivergedFromVM = void 0;
      this.#isMergingToVM = true;
      await this.#resourceScriptMapping.debuggerWorkspaceBinding.updateLocations(this.script);
      this.#isMergingToVM = void 0;
      this.dispatchEventToListeners(_ResourceScriptFile.Events.DID_MERGE_TO_VM);
    }
  }
  hasDivergedFromVM() {
    return Boolean(this.#hasDivergedFromVM);
  }
  isDivergingFromVM() {
    return Boolean(this.#isDivergingFromVM);
  }
  isMergingToVM() {
    return Boolean(this.#isMergingToVM);
  }
  checkMapping() {
    if (!this.script || typeof this.#scriptSource !== "undefined") {
      this.mappingCheckedForTest();
      return;
    }
    void this.script.requestContentData().then((content) => {
      this.#scriptSource = TextUtils6.ContentData.ContentData.textOr(content, null);
      void this.update().then(() => this.mappingCheckedForTest());
    });
  }
  mappingCheckedForTest() {
  }
  dispose() {
    this.uiSourceCode.removeEventListener(
      Workspace15.UISourceCode.Events.WorkingCopyChanged,
      this.workingCopyChanged,
      this
    );
    this.uiSourceCode.removeEventListener(
      Workspace15.UISourceCode.Events.WorkingCopyCommitted,
      this.workingCopyCommitted,
      this
    );
  }
  addSourceMapURL(sourceMapURL) {
    if (!this.script) {
      return;
    }
    this.script.debuggerModel.setSourceMapURL(this.script, sourceMapURL);
  }
  addDebugInfoURL(debugInfoURL) {
    if (!this.script) {
      return;
    }
    const { pluginManager } = DebuggerWorkspaceBinding.instance();
    pluginManager.setDebugInfoURL(this.script, debugInfoURL);
  }
  hasSourceMapURL() {
    return Boolean(this.script?.sourceMapURL);
  }
  async missingSymbolFiles() {
    if (!this.script) {
      return null;
    }
    const { pluginManager } = this.#resourceScriptMapping.debuggerWorkspaceBinding;
    const sources = await pluginManager.getSourcesForScript(this.script);
    return sources && "missingSymbolFiles" in sources ? sources.missingSymbolFiles : null;
  }
};
((ResourceScriptFile2) => {
  let Events2;
  ((Events22) => {
    Events22["DID_MERGE_TO_VM"] = "DidMergeToVM";
    Events22["DID_DIVERGE_FROM_VM"] = "DidDivergeFromVM";
  })(Events2 = ResourceScriptFile2.Events || (ResourceScriptFile2.Events = {}));
})(ResourceScriptFile || (ResourceScriptFile = {}));

// gen/third_party/devtools-frontend/src/front_end/models/bindings/DebuggerWorkspaceBinding.js
var debuggerWorkspaceBindingInstance;
var DebuggerWorkspaceBinding = class _DebuggerWorkspaceBinding {
  resourceMapping;
  #debuggerModelToData;
  #liveLocationPromises;
  pluginManager;
  constructor(resourceMapping, targetManager, ignoreListManager) {
    this.resourceMapping = resourceMapping;
    this.#debuggerModelToData = /* @__PURE__ */ new Map();
    targetManager.addModelListener(
      SDK11.DebuggerModel.DebuggerModel,
      SDK11.DebuggerModel.Events.GlobalObjectCleared,
      this.globalObjectCleared,
      this
    );
    targetManager.addModelListener(
      SDK11.DebuggerModel.DebuggerModel,
      SDK11.DebuggerModel.Events.DebuggerResumed,
      this.debuggerResumed,
      this
    );
    targetManager.observeModels(SDK11.DebuggerModel.DebuggerModel, this);
    ignoreListManager.addEventListener(
      Workspace17.IgnoreListManager.Events.IGNORED_SCRIPT_RANGES_UPDATED,
      (event) => this.updateLocations(event.data)
    );
    this.#liveLocationPromises = /* @__PURE__ */ new Set();
    this.pluginManager = new DebuggerLanguagePluginManager(targetManager, resourceMapping.workspace, this);
  }
  setFunctionRanges(uiSourceCode, ranges) {
    for (const modelData of this.#debuggerModelToData.values()) {
      modelData.compilerMapping.setFunctionRanges(uiSourceCode, ranges);
    }
  }
  static instance(opts = { forceNew: null, resourceMapping: null, targetManager: null, ignoreListManager: null }) {
    const { forceNew, resourceMapping, targetManager, ignoreListManager } = opts;
    if (!debuggerWorkspaceBindingInstance || forceNew) {
      if (!resourceMapping || !targetManager || !ignoreListManager) {
        throw new Error(
          `Unable to create DebuggerWorkspaceBinding: resourceMapping, targetManager and IgnoreLIstManager must be provided: ${new Error().stack}`
        );
      }
      debuggerWorkspaceBindingInstance = new _DebuggerWorkspaceBinding(resourceMapping, targetManager, ignoreListManager);
    }
    return debuggerWorkspaceBindingInstance;
  }
  static removeInstance() {
    debuggerWorkspaceBindingInstance = void 0;
  }
  async computeAutoStepRanges(mode, callFrame) {
    function contained(location, range) {
      const { start, end } = range;
      if (start.scriptId !== location.scriptId) {
        return false;
      }
      if (location.lineNumber < start.lineNumber || location.lineNumber > end.lineNumber) {
        return false;
      }
      if (location.lineNumber === start.lineNumber && location.columnNumber < start.columnNumber) {
        return false;
      }
      if (location.lineNumber === end.lineNumber && location.columnNumber >= end.columnNumber) {
        return false;
      }
      return true;
    }
    const rawLocation = callFrame.location();
    if (!rawLocation) {
      return [];
    }
    const pluginManager = this.pluginManager;
    let ranges = [];
    if (mode === SDK11.DebuggerModel.StepMode.STEP_OUT) {
      return await pluginManager.getInlinedFunctionRanges(rawLocation);
    }
    const uiLocation = await pluginManager.rawLocationToUILocation(rawLocation);
    if (uiLocation) {
      ranges = await pluginManager.uiLocationToRawLocationRanges(
        uiLocation.uiSourceCode,
        uiLocation.lineNumber,
        uiLocation.columnNumber
      ) || [];
      ranges = ranges.filter((range) => contained(rawLocation, range));
      if (mode === SDK11.DebuggerModel.StepMode.STEP_OVER) {
        ranges = ranges.concat(await pluginManager.getInlinedCalleesRanges(rawLocation));
      }
      return ranges;
    }
    const compilerMapping = this.#debuggerModelToData.get(rawLocation.debuggerModel)?.compilerMapping;
    if (!compilerMapping) {
      return [];
    }
    ranges = compilerMapping.getLocationRangesForSameSourceLocation(rawLocation);
    ranges = ranges.filter((range) => contained(rawLocation, range));
    return ranges;
  }
  modelAdded(debuggerModel) {
    debuggerModel.setBeforePausedCallback(this.shouldPause.bind(this));
    this.#debuggerModelToData.set(debuggerModel, new ModelData2(debuggerModel, this));
    debuggerModel.setComputeAutoStepRangesCallback(this.computeAutoStepRanges.bind(this));
  }
  modelRemoved(debuggerModel) {
    debuggerModel.setComputeAutoStepRangesCallback(null);
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (modelData) {
      modelData.dispose();
      this.#debuggerModelToData.delete(debuggerModel);
    }
  }
  /**
   * The promise returned by this function is resolved once all *currently*
   * pending LiveLocations are processed.
   */
  async pendingLiveLocationChangesPromise() {
    await Promise.all(this.#liveLocationPromises);
  }
  recordLiveLocationChange(promise) {
    void promise.then(() => {
      this.#liveLocationPromises.delete(promise);
    });
    this.#liveLocationPromises.add(promise);
  }
  async updateLocations(script) {
    const updatePromises = [script.target().model(StackTraceModel_exports.StackTraceModel)?.scriptInfoChanged(script, this.#translateRawFrames.bind(this))];
    const modelData = this.#debuggerModelToData.get(script.debuggerModel);
    if (modelData) {
      const updatePromise = modelData.updateLocations(script);
      this.recordLiveLocationChange(updatePromise);
      updatePromises.push(updatePromise);
    }
    await Promise.all(updatePromises);
  }
  async createStackTraceFromProtocolRuntime(stackTrace, target) {
    const model = target.model(StackTraceModel_exports.StackTraceModel);
    return await model.createFromProtocolRuntime(stackTrace, this.#translateRawFrames.bind(this));
  }
  async createLiveLocation(rawLocation, updateDelegate, locationPool) {
    const modelData = this.#debuggerModelToData.get(rawLocation.debuggerModel);
    if (!modelData) {
      return null;
    }
    const liveLocationPromise = modelData.createLiveLocation(rawLocation, updateDelegate, locationPool);
    this.recordLiveLocationChange(liveLocationPromise);
    return await liveLocationPromise;
  }
  async createStackTraceTopFrameLiveLocation(rawLocations, updateDelegate, locationPool) {
    console.assert(rawLocations.length > 0);
    const locationPromise = StackTraceTopFrameLocation.createStackTraceTopFrameLocation(rawLocations, this, updateDelegate, locationPool);
    this.recordLiveLocationChange(locationPromise);
    return await locationPromise;
  }
  async createCallFrameLiveLocation(location, updateDelegate, locationPool) {
    const script = location.script();
    if (!script) {
      return null;
    }
    const debuggerModel = location.debuggerModel;
    const liveLocationPromise = this.createLiveLocation(location, updateDelegate, locationPool);
    this.recordLiveLocationChange(liveLocationPromise);
    const liveLocation = await liveLocationPromise;
    if (!liveLocation) {
      return null;
    }
    this.registerCallFrameLiveLocation(debuggerModel, liveLocation);
    return liveLocation;
  }
  async rawLocationToUILocation(rawLocation) {
    const uiLocation = await this.pluginManager.rawLocationToUILocation(rawLocation);
    if (uiLocation) {
      return uiLocation;
    }
    const modelData = this.#debuggerModelToData.get(rawLocation.debuggerModel);
    return modelData ? modelData.rawLocationToUILocation(rawLocation) : null;
  }
  uiSourceCodeForSourceMapSourceURL(debuggerModel, url, isContentScript) {
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (!modelData) {
      return null;
    }
    return modelData.compilerMapping.uiSourceCodeForURL(url, isContentScript);
  }
  async uiSourceCodeForSourceMapSourceURLPromise(debuggerModel, url, isContentScript) {
    const uiSourceCode = this.uiSourceCodeForSourceMapSourceURL(debuggerModel, url, isContentScript);
    return await (uiSourceCode || this.waitForUISourceCodeAdded(url, debuggerModel.target()));
  }
  async uiSourceCodeForDebuggerLanguagePluginSourceURLPromise(debuggerModel, url) {
    const uiSourceCode = this.pluginManager.uiSourceCodeForURL(debuggerModel, url);
    return await (uiSourceCode || this.waitForUISourceCodeAdded(url, debuggerModel.target()));
  }
  uiSourceCodeForScript(script) {
    const modelData = this.#debuggerModelToData.get(script.debuggerModel);
    if (!modelData) {
      return null;
    }
    return modelData.uiSourceCodeForScript(script);
  }
  waitForUISourceCodeAdded(url, target) {
    return new Promise((resolve) => {
      const workspace = Workspace17.Workspace.WorkspaceImpl.instance();
      const descriptor = workspace.addEventListener(Workspace17.Workspace.Events.UISourceCodeAdded, (event) => {
        const uiSourceCode = event.data;
        if (uiSourceCode.url() === url && NetworkProject.targetForUISourceCode(uiSourceCode) === target) {
          workspace.removeEventListener(Workspace17.Workspace.Events.UISourceCodeAdded, descriptor.listener);
          resolve(uiSourceCode);
        }
      });
    });
  }
  async uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber) {
    const locations = await this.pluginManager.uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber);
    if (locations) {
      return locations;
    }
    for (const modelData of this.#debuggerModelToData.values()) {
      const locations2 = modelData.uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber);
      if (locations2.length) {
        return locations2;
      }
    }
    return [];
  }
  /**
   * Computes all the raw location ranges that intersect with the {@link textRange} in the given
   * {@link uiSourceCode}. The reverse mappings of the returned ranges must not be fully contained
   * with the {@link textRange} and it's the responsibility of the caller to appropriately filter or
   * clamp if desired.
   *
   * It's important to note that for a contiguous range in the {@link uiSourceCode} there can be a
   * variety of non-contiguous raw location ranges that intersect with the {@link textRange}. A
   * simple example is that of an HTML document with multiple inline `<script>`s in the same line,
   * so just asking for the raw locations in this single line will return a set of location ranges
   * in different scripts.
   *
   * This method returns an empty array if this {@link uiSourceCode} is not provided by any of the
   * mappings for this instance.
   *
   * @param uiSourceCode the {@link UISourceCode} to which the {@link textRange} belongs.
   * @param textRange the text range in terms of the UI.
   * @returns the list of raw location ranges that intersect with the text range or `[]` if
   *          the {@link uiSourceCode} does not belong to this instance.
   */
  async uiLocationRangeToRawLocationRanges(uiSourceCode, textRange) {
    const ranges = await this.pluginManager.uiLocationRangeToRawLocationRanges(uiSourceCode, textRange);
    if (ranges) {
      return ranges;
    }
    for (const modelData of this.#debuggerModelToData.values()) {
      const ranges2 = modelData.uiLocationRangeToRawLocationRanges(uiSourceCode, textRange);
      if (ranges2) {
        return ranges2;
      }
    }
    return [];
  }
  async normalizeUILocation(uiLocation) {
    const rawLocations = await this.uiLocationToRawLocations(uiLocation.uiSourceCode, uiLocation.lineNumber, uiLocation.columnNumber);
    for (const location of rawLocations) {
      const uiLocationCandidate = await this.rawLocationToUILocation(location);
      if (uiLocationCandidate) {
        return uiLocationCandidate;
      }
    }
    return uiLocation;
  }
  /**
   * Computes the set of lines in the {@link uiSourceCode} that map to scripts by either looking at
   * the debug info (if any) or checking for inline scripts within documents. If this set cannot be
   * computed or all the lines in the {@link uiSourceCode} correspond to lines in a script, `null`
   * is returned here.
   *
   * @param uiSourceCode the source entity.
   * @returns a set of known mapped lines for {@link uiSourceCode} or `null` if it's impossible to
   *          determine the set or the {@link uiSourceCode} does not map to or include any scripts.
   */
  async getMappedLines(uiSourceCode) {
    for (const modelData of this.#debuggerModelToData.values()) {
      const mappedLines = modelData.getMappedLines(uiSourceCode);
      if (mappedLines !== null) {
        return mappedLines;
      }
    }
    return await this.pluginManager.getMappedLines(uiSourceCode);
  }
  scriptFile(uiSourceCode, debuggerModel) {
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    return modelData ? modelData.getResourceScriptMapping().scriptFile(uiSourceCode) : null;
  }
  scriptsForUISourceCode(uiSourceCode) {
    const scripts = /* @__PURE__ */ new Set();
    this.pluginManager.scriptsForUISourceCode(uiSourceCode).forEach((script) => scripts.add(script));
    for (const modelData of this.#debuggerModelToData.values()) {
      const resourceScriptFile = modelData.getResourceScriptMapping().scriptFile(uiSourceCode);
      if (resourceScriptFile?.script) {
        scripts.add(resourceScriptFile.script);
      }
      modelData.compilerMapping.scriptsForUISourceCode(uiSourceCode).forEach((script) => scripts.add(script));
    }
    return [...scripts];
  }
  supportsConditionalBreakpoints(uiSourceCode) {
    const scripts = this.pluginManager.scriptsForUISourceCode(uiSourceCode);
    return scripts.every((script) => script.isJavaScript());
  }
  globalObjectCleared(event) {
    this.reset(event.data);
  }
  reset(debuggerModel) {
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (!modelData) {
      return;
    }
    for (const location of modelData.callFrameLocations.values()) {
      this.removeLiveLocation(location);
    }
    modelData.callFrameLocations.clear();
  }
  resetForTest(target) {
    const debuggerModel = target.model(SDK11.DebuggerModel.DebuggerModel);
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (modelData) {
      modelData.getResourceScriptMapping().resetForTest();
    }
  }
  registerCallFrameLiveLocation(debuggerModel, location) {
    const modelData = this.#debuggerModelToData.get(debuggerModel);
    if (modelData) {
      const locations = modelData.callFrameLocations;
      locations.add(location);
    }
  }
  removeLiveLocation(location) {
    const modelData = this.#debuggerModelToData.get(location.rawLocation.debuggerModel);
    if (modelData) {
      modelData.disposeLocation(location);
    }
  }
  debuggerResumed(event) {
    this.reset(event.data);
  }
  async shouldPause(debuggerPausedDetails, autoSteppingContext) {
    const { callFrames: [frame] } = debuggerPausedDetails;
    if (!frame) {
      return false;
    }
    const functionLocation = frame.functionLocation();
    if (!autoSteppingContext || debuggerPausedDetails.reason !== Debugger.PausedEventReason.Step || !functionLocation || !frame.script.isWasm() || !Common11.Settings.moduleSetting("wasm-auto-stepping").get() || !this.pluginManager.hasPluginForScript(frame.script)) {
      return true;
    }
    const uiLocation = await this.pluginManager.rawLocationToUILocation(frame.location());
    if (uiLocation) {
      return true;
    }
    return autoSteppingContext.script() !== functionLocation.script() || autoSteppingContext.columnNumber !== functionLocation.columnNumber || autoSteppingContext.lineNumber !== functionLocation.lineNumber;
  }
  async #translateRawFrames(frames, target) {
    const rawFrames = frames.slice(0);
    const translatedFrames = [];
    while (rawFrames.length) {
      await this.#translateRawFramesStep(rawFrames, translatedFrames, target);
    }
    return translatedFrames;
  }
  async #translateRawFramesStep(rawFrames, translatedFrames, target) {
    if (await this.pluginManager.translateRawFramesStep(rawFrames, translatedFrames, target)) {
      return;
    }
    const modelData = this.#debuggerModelToData.get(target.model(SDK11.DebuggerModel.DebuggerModel));
    if (modelData) {
      modelData.translateRawFramesStep(rawFrames, translatedFrames);
      return;
    }
    const frame = rawFrames.shift();
    const { url, lineNumber, columnNumber, functionName } = frame;
    translatedFrames.push([{ url, line: lineNumber, column: columnNumber, name: functionName }]);
  }
};
var ModelData2 = class {
  #debuggerModel;
  #debuggerWorkspaceBinding;
  callFrameLocations;
  #defaultMapping;
  #resourceMapping;
  #resourceScriptMapping;
  compilerMapping;
  #locations;
  constructor(debuggerModel, debuggerWorkspaceBinding) {
    this.#debuggerModel = debuggerModel;
    this.#debuggerWorkspaceBinding = debuggerWorkspaceBinding;
    this.callFrameLocations = /* @__PURE__ */ new Set();
    const { workspace } = debuggerWorkspaceBinding.resourceMapping;
    this.#defaultMapping = new DefaultScriptMapping(debuggerModel, workspace, debuggerWorkspaceBinding);
    this.#resourceMapping = debuggerWorkspaceBinding.resourceMapping;
    this.#resourceScriptMapping = new ResourceScriptMapping(debuggerModel, workspace, debuggerWorkspaceBinding);
    this.compilerMapping = new CompilerScriptMapping(debuggerModel, workspace, debuggerWorkspaceBinding);
    this.#locations = new Platform6.MapUtilities.Multimap();
  }
  async createLiveLocation(rawLocation, updateDelegate, locationPool) {
    console.assert(rawLocation.scriptId !== "");
    const scriptId = rawLocation.scriptId;
    const location = new Location(scriptId, rawLocation, this.#debuggerWorkspaceBinding, updateDelegate, locationPool);
    this.#locations.set(scriptId, location);
    await location.update();
    return location;
  }
  disposeLocation(location) {
    this.#locations.delete(location.scriptId, location);
  }
  async updateLocations(script) {
    const promises = [];
    for (const location of this.#locations.get(script.scriptId)) {
      promises.push(location.update());
    }
    await Promise.all(promises);
  }
  rawLocationToUILocation(rawLocation) {
    let uiLocation = this.compilerMapping.rawLocationToUILocation(rawLocation);
    uiLocation = uiLocation || this.#resourceScriptMapping.rawLocationToUILocation(rawLocation);
    uiLocation = uiLocation || this.#resourceMapping.jsLocationToUILocation(rawLocation);
    uiLocation = uiLocation || this.#defaultMapping.rawLocationToUILocation(rawLocation);
    return uiLocation;
  }
  uiSourceCodeForScript(script) {
    let uiSourceCode = null;
    uiSourceCode = uiSourceCode || this.#resourceScriptMapping.uiSourceCodeForScript(script);
    uiSourceCode = uiSourceCode || this.#resourceMapping.uiSourceCodeForScript(script);
    uiSourceCode = uiSourceCode || this.#defaultMapping.uiSourceCodeForScript(script);
    return uiSourceCode;
  }
  uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber = 0) {
    let locations = this.compilerMapping.uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber);
    locations = locations.length ? locations : this.#resourceScriptMapping.uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber);
    locations = locations.length ? locations : this.#resourceMapping.uiLocationToJSLocations(uiSourceCode, lineNumber, columnNumber);
    locations = locations.length ? locations : this.#defaultMapping.uiLocationToRawLocations(uiSourceCode, lineNumber, columnNumber);
    return locations;
  }
  uiLocationRangeToRawLocationRanges(uiSourceCode, textRange) {
    let ranges = this.compilerMapping.uiLocationRangeToRawLocationRanges(uiSourceCode, textRange);
    ranges ??= this.#resourceScriptMapping.uiLocationRangeToRawLocationRanges(uiSourceCode, textRange);
    ranges ??= this.#resourceMapping.uiLocationRangeToJSLocationRanges(uiSourceCode, textRange);
    ranges ??= this.#defaultMapping.uiLocationRangeToRawLocationRanges(uiSourceCode, textRange);
    return ranges;
  }
  translateRawFramesStep(rawFrames, translatedFrames) {
    if (!this.compilerMapping.translateRawFramesStep(rawFrames, translatedFrames)) {
      this.#defaultTranslateRawFramesStep(rawFrames, translatedFrames);
    }
  }
  /** The default implementation translates one frame at a time and only translates the location, but not the function name. */
  #defaultTranslateRawFramesStep(rawFrames, translatedFrames) {
    const frame = rawFrames.shift();
    const { scriptId, url, lineNumber, columnNumber, functionName } = frame;
    const rawLocation = scriptId ? this.#debuggerModel.createRawLocationByScriptId(scriptId, lineNumber, columnNumber) : url ? this.#debuggerModel.createRawLocationByURL(url, lineNumber, columnNumber) : null;
    if (rawLocation) {
      const uiLocation = this.rawLocationToUILocation(rawLocation);
      if (uiLocation) {
        translatedFrames.push([{
          uiSourceCode: uiLocation.uiSourceCode,
          name: functionName,
          line: uiLocation.lineNumber,
          column: uiLocation.columnNumber ?? -1
        }]);
        return;
      }
    }
    translatedFrames.push([{ url, line: lineNumber, column: columnNumber, name: functionName }]);
  }
  getMappedLines(uiSourceCode) {
    const mappedLines = this.compilerMapping.getMappedLines(uiSourceCode);
    return mappedLines;
  }
  dispose() {
    this.#debuggerModel.setBeforePausedCallback(null);
    this.compilerMapping.dispose();
    this.#resourceScriptMapping.dispose();
    this.#defaultMapping.dispose();
  }
  getResourceScriptMapping() {
    return this.#resourceScriptMapping;
  }
};
var Location = class extends LiveLocationWithPool {
  scriptId;
  rawLocation;
  #binding;
  constructor(scriptId, rawLocation, binding, updateDelegate, locationPool) {
    super(updateDelegate, locationPool);
    this.scriptId = scriptId;
    this.rawLocation = rawLocation;
    this.#binding = binding;
  }
  async uiLocation() {
    const debuggerModelLocation = this.rawLocation;
    return await this.#binding.rawLocationToUILocation(debuggerModelLocation);
  }
  dispose() {
    super.dispose();
    this.#binding.removeLiveLocation(this);
  }
};
var StackTraceTopFrameLocation = class _StackTraceTopFrameLocation extends LiveLocationWithPool {
  #updateScheduled;
  #current;
  #locations;
  constructor(updateDelegate, locationPool) {
    super(updateDelegate, locationPool);
    this.#updateScheduled = true;
    this.#current = null;
    this.#locations = null;
  }
  static async createStackTraceTopFrameLocation(rawLocations, binding, updateDelegate, locationPool) {
    const location = new _StackTraceTopFrameLocation(updateDelegate, locationPool);
    const locationsPromises = rawLocations.map(
      (rawLocation) => binding.createLiveLocation(rawLocation, location.scheduleUpdate.bind(location), locationPool)
    );
    location.#locations = (await Promise.all(locationsPromises)).filter((l) => !!l);
    await location.updateLocation();
    return location;
  }
  async uiLocation() {
    return this.#current ? await this.#current.uiLocation() : null;
  }
  dispose() {
    super.dispose();
    if (this.#locations) {
      for (const location of this.#locations) {
        location.dispose();
      }
    }
    this.#locations = null;
    this.#current = null;
  }
  async scheduleUpdate() {
    if (this.#updateScheduled) {
      return;
    }
    this.#updateScheduled = true;
    queueMicrotask(() => {
      void this.updateLocation();
    });
  }
  async updateLocation() {
    this.#updateScheduled = false;
    if (!this.#locations || this.#locations.length === 0) {
      return;
    }
    this.#current = this.#locations[0];
    for (const location of this.#locations) {
      const uiLocation = await location.uiLocation();
      if (!uiLocation?.isIgnoreListed()) {
        this.#current = location;
        break;
      }
    }
    void this.update();
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/FileUtils.js
var FileUtils_exports = {};
__export(FileUtils_exports, {
  ChunkedFileReader: () => ChunkedFileReader,
  FileOutputStream: () => FileOutputStream
});
import * as Common12 from "./../../core/common/common.js";
import * as TextUtils7 from "./../text_utils/text_utils.js";
import * as Workspace19 from "./../workspace/workspace.js";
var ChunkedFileReader = class {
  #file;
  #fileSize;
  #loadedSize;
  #streamReader;
  #chunkSize;
  #chunkTransferredCallback;
  #decoder;
  #isCanceled;
  #error;
  #transferFinished;
  #output;
  #reader;
  constructor(file, chunkSize, chunkTransferredCallback) {
    this.#file = file;
    this.#fileSize = file.size;
    this.#loadedSize = 0;
    this.#chunkSize = chunkSize ? chunkSize : Number.MAX_VALUE;
    this.#chunkTransferredCallback = chunkTransferredCallback;
    this.#decoder = new TextDecoder();
    this.#isCanceled = false;
    this.#error = null;
    this.#streamReader = null;
  }
  async read(output) {
    if (this.#chunkTransferredCallback) {
      this.#chunkTransferredCallback(this);
    }
    if (this.#file?.type.endsWith("gzip")) {
      const fileStream = this.#file.stream();
      const stream = Common12.Gzip.decompressStream(fileStream);
      this.#streamReader = stream.getReader();
    } else {
      this.#reader = new FileReader();
      this.#reader.onload = this.onChunkLoaded.bind(this);
      this.#reader.onerror = this.onError.bind(this);
    }
    this.#output = output;
    void this.loadChunk();
    return await new Promise((resolve) => {
      this.#transferFinished = resolve;
    });
  }
  cancel() {
    this.#isCanceled = true;
  }
  loadedSize() {
    return this.#loadedSize;
  }
  fileSize() {
    return this.#fileSize;
  }
  fileName() {
    if (!this.#file) {
      return "";
    }
    return this.#file.name;
  }
  error() {
    return this.#error;
  }
  onChunkLoaded(event) {
    if (this.#isCanceled) {
      return;
    }
    const eventTarget = event.target;
    if (eventTarget.readyState !== FileReader.DONE) {
      return;
    }
    if (!this.#reader) {
      return;
    }
    const buffer = this.#reader.result;
    this.#loadedSize += buffer.byteLength;
    const endOfFile = this.#loadedSize === this.#fileSize;
    void this.decodeChunkBuffer(buffer, endOfFile);
  }
  async decodeChunkBuffer(buffer, endOfFile) {
    if (!this.#output) {
      return;
    }
    const decodedString = this.#decoder.decode(buffer, { stream: !endOfFile });
    await this.#output.write(decodedString, endOfFile);
    if (this.#isCanceled) {
      return;
    }
    if (this.#chunkTransferredCallback) {
      this.#chunkTransferredCallback(this);
    }
    if (endOfFile) {
      void this.finishRead();
      return;
    }
    void this.loadChunk();
  }
  async finishRead() {
    if (!this.#output) {
      return;
    }
    this.#file = null;
    this.#reader = null;
    await this.#output.close();
    this.#transferFinished(!this.#error);
  }
  async loadChunk() {
    if (!this.#output || !this.#file) {
      return;
    }
    if (this.#streamReader) {
      const { value, done } = await this.#streamReader.read();
      if (done || !value) {
        await this.#output.write("", true);
        return await this.finishRead();
      }
      void this.decodeChunkBuffer(value.buffer, false);
    }
    if (this.#reader) {
      const chunkStart = this.#loadedSize;
      const chunkEnd = Math.min(this.#fileSize, chunkStart + this.#chunkSize);
      const nextPart = this.#file.slice(chunkStart, chunkEnd);
      this.#reader.readAsArrayBuffer(nextPart);
    }
  }
  onError(event) {
    const eventTarget = event.target;
    this.#error = eventTarget.error;
    this.#transferFinished(false);
  }
};
var FileOutputStream = class {
  #writeCallbacks;
  #fileName;
  #closed;
  constructor() {
    this.#writeCallbacks = [];
  }
  async open(fileName) {
    this.#closed = false;
    this.#writeCallbacks = [];
    this.#fileName = fileName;
    const saveResponse = await Workspace19.FileManager.FileManager.instance().save(
      this.#fileName,
      TextUtils7.ContentData.EMPTY_TEXT_CONTENT_DATA,
      /* forceSaveAs=*/
      true
    );
    if (saveResponse) {
      Workspace19.FileManager.FileManager.instance().addEventListener(
        Workspace19.FileManager.Events.APPENDED_TO_URL,
        this.onAppendDone,
        this
      );
    }
    return Boolean(saveResponse);
  }
  write(data) {
    return new Promise((resolve) => {
      this.#writeCallbacks.push(resolve);
      Workspace19.FileManager.FileManager.instance().append(this.#fileName, data);
    });
  }
  async close() {
    this.#closed = true;
    if (this.#writeCallbacks.length) {
      return;
    }
    Workspace19.FileManager.FileManager.instance().removeEventListener(
      Workspace19.FileManager.Events.APPENDED_TO_URL,
      this.onAppendDone,
      this
    );
    Workspace19.FileManager.FileManager.instance().close(this.#fileName);
  }
  onAppendDone(event) {
    if (event.data !== this.#fileName) {
      return;
    }
    const writeCallback = this.#writeCallbacks.shift();
    if (writeCallback) {
      writeCallback();
    }
    if (this.#writeCallbacks.length) {
      return;
    }
    if (!this.#closed) {
      return;
    }
    Workspace19.FileManager.FileManager.instance().removeEventListener(
      Workspace19.FileManager.Events.APPENDED_TO_URL,
      this.onAppendDone,
      this
    );
    Workspace19.FileManager.FileManager.instance().close(this.#fileName);
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/PresentationConsoleMessageHelper.js
var PresentationConsoleMessageHelper_exports = {};
__export(PresentationConsoleMessageHelper_exports, {
  PresentationConsoleMessageManager: () => PresentationConsoleMessageManager,
  PresentationSourceFrameMessage: () => PresentationSourceFrameMessage,
  PresentationSourceFrameMessageHelper: () => PresentationSourceFrameMessageHelper,
  PresentationSourceFrameMessageManager: () => PresentationSourceFrameMessageManager
});
import * as SDK12 from "./../../core/sdk/sdk.js";
import * as TextUtils8 from "./../text_utils/text_utils.js";
import * as Workspace20 from "./../workspace/workspace.js";
var PresentationSourceFrameMessageManager = class {
  #targetToMessageHelperMap = /* @__PURE__ */ new WeakMap();
  constructor() {
    SDK12.TargetManager.TargetManager.instance().observeModels(SDK12.DebuggerModel.DebuggerModel, this);
    SDK12.TargetManager.TargetManager.instance().observeModels(SDK12.CSSModel.CSSModel, this);
  }
  modelAdded(model) {
    const target = model.target();
    const helper = this.#targetToMessageHelperMap.get(target) ?? new PresentationSourceFrameMessageHelper();
    if (model instanceof SDK12.DebuggerModel.DebuggerModel) {
      helper.setDebuggerModel(model);
    } else {
      helper.setCSSModel(model);
    }
    this.#targetToMessageHelperMap.set(target, helper);
  }
  modelRemoved(model) {
    const target = model.target();
    const helper = this.#targetToMessageHelperMap.get(target);
    helper?.clear();
  }
  addMessage(message, source, target) {
    const helper = this.#targetToMessageHelperMap.get(target);
    void helper?.addMessage(message, source);
  }
  clear() {
    for (const target of SDK12.TargetManager.TargetManager.instance().targets()) {
      const helper = this.#targetToMessageHelperMap.get(target);
      helper?.clear();
    }
  }
};
var PresentationConsoleMessageManager = class {
  #sourceFrameMessageManager = new PresentationSourceFrameMessageManager();
  constructor() {
    SDK12.TargetManager.TargetManager.instance().addModelListener(
      SDK12.ConsoleModel.ConsoleModel,
      SDK12.ConsoleModel.Events.MessageAdded,
      (event) => this.consoleMessageAdded(event.data)
    );
    SDK12.ConsoleModel.ConsoleModel.allMessagesUnordered().forEach(this.consoleMessageAdded, this);
    SDK12.TargetManager.TargetManager.instance().addModelListener(
      SDK12.ConsoleModel.ConsoleModel,
      SDK12.ConsoleModel.Events.ConsoleCleared,
      () => this.#sourceFrameMessageManager.clear()
    );
  }
  consoleMessageAdded(consoleMessage) {
    const runtimeModel = consoleMessage.runtimeModel();
    if (!consoleMessage.isErrorOrWarning() || !consoleMessage.runtimeModel() || consoleMessage.source === Log.LogEntrySource.Violation || !runtimeModel) {
      return;
    }
    const level = consoleMessage.level === Log.LogEntryLevel.Error ? Workspace20.UISourceCode.Message.Level.ERROR : Workspace20.UISourceCode.Message.Level.WARNING;
    this.#sourceFrameMessageManager.addMessage(
      new Workspace20.UISourceCode.Message(level, consoleMessage.messageText),
      consoleMessage,
      runtimeModel.target()
    );
  }
};
var PresentationSourceFrameMessageHelper = class {
  #debuggerModel;
  #cssModel;
  #presentationMessages = /* @__PURE__ */ new Map();
  #locationPool;
  constructor() {
    this.#locationPool = new LiveLocationPool();
    Workspace20.Workspace.WorkspaceImpl.instance().addEventListener(
      Workspace20.Workspace.Events.UISourceCodeAdded,
      this.#uiSourceCodeAdded.bind(this)
    );
  }
  setDebuggerModel(debuggerModel) {
    if (this.#debuggerModel) {
      throw new Error("Cannot set DebuggerModel twice");
    }
    this.#debuggerModel = debuggerModel;
    debuggerModel.addEventListener(SDK12.DebuggerModel.Events.ParsedScriptSource, (event) => {
      queueMicrotask(() => {
        this.#parsedScriptSource(event);
      });
    });
    debuggerModel.addEventListener(SDK12.DebuggerModel.Events.GlobalObjectCleared, this.#debuggerReset, this);
  }
  setCSSModel(cssModel) {
    if (this.#cssModel) {
      throw new Error("Cannot set CSSModel twice");
    }
    this.#cssModel = cssModel;
    cssModel.addEventListener(
      SDK12.CSSModel.Events.StyleSheetAdded,
      (event) => queueMicrotask(() => this.#styleSheetAdded(event))
    );
  }
  async addMessage(message, source) {
    const presentation = new PresentationSourceFrameMessage(message, this.#locationPool);
    const location = this.#rawLocation(source) ?? this.#cssLocation(source) ?? this.#uiLocation(source);
    if (location) {
      await presentation.updateLocationSource(location);
    }
    if (source.url) {
      let messages = this.#presentationMessages.get(source.url);
      if (!messages) {
        messages = [];
        this.#presentationMessages.set(source.url, messages);
      }
      messages.push({ source, presentation });
    }
  }
  #uiLocation(source) {
    if (!source.url) {
      return null;
    }
    const uiSourceCode = Workspace20.Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(source.url);
    if (!uiSourceCode) {
      return null;
    }
    return new Workspace20.UISourceCode.UILocation(uiSourceCode, source.line, source.column);
  }
  #cssLocation(source) {
    if (!this.#cssModel || !source.url) {
      return null;
    }
    const locations = this.#cssModel.createRawLocationsByURL(source.url, source.line, source.column);
    return locations[0] ?? null;
  }
  #rawLocation(source) {
    if (!this.#debuggerModel) {
      return null;
    }
    if (source.scriptId) {
      return this.#debuggerModel.createRawLocationByScriptId(source.scriptId, source.line, source.column);
    }
    const callFrame = source.stackTrace?.callFrames ? source.stackTrace.callFrames[0] : null;
    if (callFrame) {
      return this.#debuggerModel.createRawLocationByScriptId(
        callFrame.scriptId,
        callFrame.lineNumber,
        callFrame.columnNumber
      );
    }
    if (source.url) {
      return this.#debuggerModel.createRawLocationByURL(source.url, source.line, source.column);
    }
    return null;
  }
  #parsedScriptSource(event) {
    const script = event.data;
    const messages = this.#presentationMessages.get(script.sourceURL);
    const promises = [];
    for (const { presentation, source } of messages ?? []) {
      const rawLocation = this.#rawLocation(source);
      if (rawLocation && script.scriptId === rawLocation.scriptId) {
        promises.push(presentation.updateLocationSource(rawLocation));
      }
    }
    void Promise.all(promises).then(this.parsedScriptSourceForTest.bind(this));
  }
  parsedScriptSourceForTest() {
  }
  #uiSourceCodeAdded(event) {
    const uiSourceCode = event.data;
    const messages = this.#presentationMessages.get(uiSourceCode.url());
    const promises = [];
    for (const { presentation, source } of messages ?? []) {
      promises.push(presentation.updateLocationSource(
        new Workspace20.UISourceCode.UILocation(uiSourceCode, source.line, source.column)
      ));
    }
    void Promise.all(promises).then(this.uiSourceCodeAddedForTest.bind(this));
  }
  uiSourceCodeAddedForTest() {
  }
  #styleSheetAdded(event) {
    const header = event.data;
    const messages = this.#presentationMessages.get(header.sourceURL);
    const promises = [];
    for (const { source, presentation } of messages ?? []) {
      if (header.containsLocation(source.line, source.column)) {
        promises.push(
          presentation.updateLocationSource(new SDK12.CSSModel.CSSLocation(header, source.line, source.column))
        );
      }
    }
    void Promise.all(promises).then(this.styleSheetAddedForTest.bind(this));
  }
  styleSheetAddedForTest() {
  }
  clear() {
    this.#debuggerReset();
  }
  #debuggerReset() {
    const presentations = Array.from(this.#presentationMessages.values()).flat();
    for (const { presentation } of presentations) {
      presentation.dispose();
    }
    this.#presentationMessages.clear();
    this.#locationPool.disposeAll();
  }
};
var FrozenLiveLocation = class extends LiveLocationWithPool {
  #uiLocation;
  constructor(uiLocation, updateDelegate, locationPool) {
    super(updateDelegate, locationPool);
    this.#uiLocation = uiLocation;
  }
  async uiLocation() {
    return this.#uiLocation;
  }
};
var PresentationSourceFrameMessage = class {
  #uiSourceCode;
  #liveLocation;
  #locationPool;
  #message;
  constructor(message, locationPool) {
    this.#message = message;
    this.#locationPool = locationPool;
  }
  async updateLocationSource(source) {
    if (source instanceof SDK12.DebuggerModel.Location) {
      await DebuggerWorkspaceBinding.instance().createLiveLocation(
        source,
        this.#updateLocation.bind(this),
        this.#locationPool
      );
    } else if (source instanceof SDK12.CSSModel.CSSLocation) {
      await CSSWorkspaceBinding.instance().createLiveLocation(
        source,
        this.#updateLocation.bind(this),
        this.#locationPool
      );
    } else if (source instanceof Workspace20.UISourceCode.UILocation) {
      if (!this.#liveLocation) {
        this.#liveLocation = new FrozenLiveLocation(source, this.#updateLocation.bind(this), this.#locationPool);
        await this.#liveLocation.update();
      }
    }
  }
  async #updateLocation(liveLocation) {
    if (this.#uiSourceCode) {
      this.#uiSourceCode.removeMessage(this.#message);
    }
    if (liveLocation !== this.#liveLocation) {
      this.#uiSourceCode?.removeMessage(this.#message);
      this.#liveLocation?.dispose();
      this.#liveLocation = liveLocation;
    }
    const uiLocation = await liveLocation.uiLocation();
    if (!uiLocation) {
      return;
    }
    this.#message.range = TextUtils8.TextRange.TextRange.createFromLocation(uiLocation.lineNumber, uiLocation.columnNumber || 0);
    this.#uiSourceCode = uiLocation.uiSourceCode;
    this.#uiSourceCode.addMessage(this.#message);
  }
  dispose() {
    this.#uiSourceCode?.removeMessage(this.#message);
    this.#liveLocation?.dispose();
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/ResourceMapping.js
var ResourceMapping_exports = {};
__export(ResourceMapping_exports, {
  ResourceMapping: () => ResourceMapping
});
import * as Common13 from "./../../core/common/common.js";
import * as SDK13 from "./../../core/sdk/sdk.js";
import * as TextUtils9 from "./../text_utils/text_utils.js";
import * as Workspace22 from "./../workspace/workspace.js";
var styleSheetRangeMap = /* @__PURE__ */ new WeakMap();
var scriptRangeMap = /* @__PURE__ */ new WeakMap();
var boundUISourceCodes = /* @__PURE__ */ new WeakSet();
function computeScriptRange(script) {
  return new TextUtils9.TextRange.TextRange(script.lineOffset, script.columnOffset, script.endLine, script.endColumn);
}
function computeStyleSheetRange(header) {
  return new TextUtils9.TextRange.TextRange(header.startLine, header.startColumn, header.endLine, header.endColumn);
}
var ResourceMapping = class {
  workspace;
  #modelToInfo = /* @__PURE__ */ new Map();
  constructor(targetManager, workspace) {
    this.workspace = workspace;
    targetManager.observeModels(SDK13.ResourceTreeModel.ResourceTreeModel, this);
  }
  modelAdded(resourceTreeModel) {
    const info = new ModelInfo2(this.workspace, resourceTreeModel);
    this.#modelToInfo.set(resourceTreeModel, info);
  }
  modelRemoved(resourceTreeModel) {
    const info = this.#modelToInfo.get(resourceTreeModel);
    if (info) {
      info.dispose();
      this.#modelToInfo.delete(resourceTreeModel);
    }
  }
  infoForTarget(target) {
    const resourceTreeModel = target.model(SDK13.ResourceTreeModel.ResourceTreeModel);
    return resourceTreeModel ? this.#modelToInfo.get(resourceTreeModel) || null : null;
  }
  uiSourceCodeForScript(script) {
    const info = this.infoForTarget(script.debuggerModel.target());
    if (!info) {
      return null;
    }
    const project = info.getProject();
    const uiSourceCode = project.uiSourceCodeForURL(script.sourceURL);
    return uiSourceCode;
  }
  cssLocationToUILocation(cssLocation) {
    const header = cssLocation.header();
    if (!header) {
      return null;
    }
    const info = this.infoForTarget(cssLocation.cssModel().target());
    if (!info) {
      return null;
    }
    const uiSourceCode = info.getProject().uiSourceCodeForURL(cssLocation.url);
    if (!uiSourceCode) {
      return null;
    }
    const offset = styleSheetRangeMap.get(header) ?? computeStyleSheetRange(header);
    const lineNumber = cssLocation.lineNumber + offset.startLine - header.startLine;
    let columnNumber = cssLocation.columnNumber;
    if (cssLocation.lineNumber === header.startLine) {
      columnNumber += offset.startColumn - header.startColumn;
    }
    return uiSourceCode.uiLocation(lineNumber, columnNumber);
  }
  jsLocationToUILocation(jsLocation) {
    const script = jsLocation.script();
    if (!script) {
      return null;
    }
    const info = this.infoForTarget(jsLocation.debuggerModel.target());
    if (!info) {
      return null;
    }
    const embedderName = script.embedderName();
    if (!embedderName) {
      return null;
    }
    const uiSourceCode = info.getProject().uiSourceCodeForURL(embedderName);
    if (!uiSourceCode) {
      return null;
    }
    const { startLine, startColumn } = scriptRangeMap.get(script) ?? computeScriptRange(script);
    let { lineNumber, columnNumber } = jsLocation;
    if (lineNumber === script.lineOffset) {
      columnNumber += startColumn - script.columnOffset;
    }
    lineNumber += startLine - script.lineOffset;
    if (script.hasSourceURL) {
      if (lineNumber === 0) {
        columnNumber += script.columnOffset;
      }
      lineNumber += script.lineOffset;
    }
    return uiSourceCode.uiLocation(lineNumber, columnNumber);
  }
  uiLocationToJSLocations(uiSourceCode, lineNumber, columnNumber) {
    if (!boundUISourceCodes.has(uiSourceCode)) {
      return [];
    }
    const target = NetworkProject.targetForUISourceCode(uiSourceCode);
    if (!target) {
      return [];
    }
    const debuggerModel = target.model(SDK13.DebuggerModel.DebuggerModel);
    if (!debuggerModel) {
      return [];
    }
    const locations = [];
    for (const script of debuggerModel.scripts()) {
      if (script.embedderName() !== uiSourceCode.url()) {
        continue;
      }
      const range = scriptRangeMap.get(script) ?? computeScriptRange(script);
      if (!range.containsLocation(lineNumber, columnNumber)) {
        continue;
      }
      let scriptLineNumber = lineNumber;
      let scriptColumnNumber = columnNumber;
      if (script.hasSourceURL) {
        scriptLineNumber -= range.startLine;
        if (scriptLineNumber === 0) {
          scriptColumnNumber -= range.startColumn;
        }
      }
      locations.push(debuggerModel.createRawLocation(script, scriptLineNumber, scriptColumnNumber));
    }
    return locations;
  }
  uiLocationRangeToJSLocationRanges(uiSourceCode, textRange) {
    if (!boundUISourceCodes.has(uiSourceCode)) {
      return null;
    }
    const target = NetworkProject.targetForUISourceCode(uiSourceCode);
    if (!target) {
      return null;
    }
    const debuggerModel = target.model(SDK13.DebuggerModel.DebuggerModel);
    if (!debuggerModel) {
      return null;
    }
    const ranges = [];
    for (const script of debuggerModel.scripts()) {
      if (script.embedderName() !== uiSourceCode.url()) {
        continue;
      }
      const scriptTextRange = scriptRangeMap.get(script) ?? computeScriptRange(script);
      const range = scriptTextRange.intersection(textRange);
      if (range.isEmpty()) {
        continue;
      }
      let { startLine, startColumn, endLine, endColumn } = range;
      if (script.hasSourceURL) {
        startLine -= range.startLine;
        if (startLine === 0) {
          startColumn -= range.startColumn;
        }
        endLine -= range.startLine;
        if (endLine === 0) {
          endColumn -= range.startColumn;
        }
      }
      const start = debuggerModel.createRawLocation(script, startLine, startColumn);
      const end = debuggerModel.createRawLocation(script, endLine, endColumn);
      ranges.push({ start, end });
    }
    return ranges;
  }
  getMappedLines(uiSourceCode) {
    if (!boundUISourceCodes.has(uiSourceCode)) {
      return null;
    }
    const target = NetworkProject.targetForUISourceCode(uiSourceCode);
    if (!target) {
      return null;
    }
    const debuggerModel = target.model(SDK13.DebuggerModel.DebuggerModel);
    if (!debuggerModel) {
      return null;
    }
    const mappedLines = /* @__PURE__ */ new Set();
    for (const script of debuggerModel.scripts()) {
      if (script.embedderName() !== uiSourceCode.url()) {
        continue;
      }
      const { startLine, endLine } = scriptRangeMap.get(script) ?? computeScriptRange(script);
      for (let line = startLine; line <= endLine; ++line) {
        mappedLines.add(line);
      }
    }
    return mappedLines;
  }
  uiLocationToCSSLocations(uiLocation) {
    if (!boundUISourceCodes.has(uiLocation.uiSourceCode)) {
      return [];
    }
    const target = NetworkProject.targetForUISourceCode(uiLocation.uiSourceCode);
    if (!target) {
      return [];
    }
    const cssModel = target.model(SDK13.CSSModel.CSSModel);
    if (!cssModel) {
      return [];
    }
    return cssModel.createRawLocationsByURL(
      uiLocation.uiSourceCode.url(),
      uiLocation.lineNumber,
      uiLocation.columnNumber
    );
  }
  resetForTest(target) {
    const resourceTreeModel = target.model(SDK13.ResourceTreeModel.ResourceTreeModel);
    const info = resourceTreeModel ? this.#modelToInfo.get(resourceTreeModel) : null;
    if (info) {
      info.resetForTest();
    }
  }
};
var ModelInfo2 = class {
  project;
  #bindings = /* @__PURE__ */ new Map();
  #cssModel;
  #eventListeners;
  constructor(workspace, resourceTreeModel) {
    const target = resourceTreeModel.target();
    this.project = new ContentProviderBasedProject(
      workspace,
      "resources:" + target.id(),
      Workspace22.Workspace.projectTypes.Network,
      "",
      false
      /* isServiceProject */
    );
    NetworkProject.setTargetForProject(this.project, target);
    const cssModel = target.model(SDK13.CSSModel.CSSModel);
    console.assert(Boolean(cssModel));
    this.#cssModel = cssModel;
    for (const frame of resourceTreeModel.frames()) {
      for (const resource of frame.getResourcesMap().values()) {
        this.addResource(resource);
      }
    }
    this.#eventListeners = [
      resourceTreeModel.addEventListener(SDK13.ResourceTreeModel.Events.ResourceAdded, this.resourceAdded, this),
      resourceTreeModel.addEventListener(SDK13.ResourceTreeModel.Events.FrameWillNavigate, this.frameWillNavigate, this),
      resourceTreeModel.addEventListener(SDK13.ResourceTreeModel.Events.FrameDetached, this.frameDetached, this),
      this.#cssModel.addEventListener(
        SDK13.CSSModel.Events.StyleSheetChanged,
        (event) => {
          void this.styleSheetChanged(event);
        },
        this
      )
    ];
  }
  async styleSheetChanged(event) {
    const header = this.#cssModel.styleSheetHeaderForId(event.data.styleSheetId);
    if (!header || !header.isInline || header.isInline && header.isMutable) {
      return;
    }
    const binding = this.#bindings.get(header.resourceURL());
    if (!binding) {
      return;
    }
    await binding.styleSheetChanged(header, event.data.edit || null);
  }
  acceptsResource(resource) {
    const resourceType = resource.resourceType();
    if (resourceType !== Common13.ResourceType.resourceTypes.Image && resourceType !== Common13.ResourceType.resourceTypes.Font && resourceType !== Common13.ResourceType.resourceTypes.Document && resourceType !== Common13.ResourceType.resourceTypes.Manifest && resourceType !== Common13.ResourceType.resourceTypes.Fetch && resourceType !== Common13.ResourceType.resourceTypes.XHR) {
      return false;
    }
    if (resourceType === Common13.ResourceType.resourceTypes.Image && resource.mimeType && !resource.mimeType.startsWith("image")) {
      return false;
    }
    if (resourceType === Common13.ResourceType.resourceTypes.Font && resource.mimeType && !resource.mimeType.includes("font")) {
      return false;
    }
    if ((resourceType === Common13.ResourceType.resourceTypes.Image || resourceType === Common13.ResourceType.resourceTypes.Font) && Common13.ParsedURL.schemeIs(resource.contentURL(), "data:")) {
      return false;
    }
    return true;
  }
  resourceAdded(event) {
    this.addResource(event.data);
  }
  addResource(resource) {
    if (!this.acceptsResource(resource)) {
      return;
    }
    let binding = this.#bindings.get(resource.url);
    if (!binding) {
      binding = new Binding2(this.project, resource);
      this.#bindings.set(resource.url, binding);
    } else {
      binding.addResource(resource);
    }
  }
  removeFrameResources(frame) {
    for (const resource of frame.resources()) {
      if (!this.acceptsResource(resource)) {
        continue;
      }
      const binding = this.#bindings.get(resource.url);
      if (!binding) {
        continue;
      }
      if (binding.resources.size === 1) {
        binding.dispose();
        this.#bindings.delete(resource.url);
      } else {
        binding.removeResource(resource);
      }
    }
  }
  frameWillNavigate(event) {
    this.removeFrameResources(event.data);
  }
  frameDetached(event) {
    this.removeFrameResources(event.data.frame);
  }
  resetForTest() {
    for (const binding of this.#bindings.values()) {
      binding.dispose();
    }
    this.#bindings.clear();
  }
  dispose() {
    Common13.EventTarget.removeEventListeners(this.#eventListeners);
    for (const binding of this.#bindings.values()) {
      binding.dispose();
    }
    this.#bindings.clear();
    this.project.removeProject();
  }
  getProject() {
    return this.project;
  }
};
var Binding2 = class {
  resources;
  #project;
  #uiSourceCode;
  #edits = [];
  constructor(project, resource) {
    this.resources = /* @__PURE__ */ new Set([resource]);
    this.#project = project;
    this.#uiSourceCode = this.#project.createUISourceCode(resource.url, resource.contentType());
    boundUISourceCodes.add(this.#uiSourceCode);
    if (resource.frameId) {
      NetworkProject.setInitialFrameAttribution(this.#uiSourceCode, resource.frameId);
    }
    this.#project.addUISourceCodeWithProvider(this.#uiSourceCode, this, resourceMetadata(resource), resource.mimeType);
    void Promise.all([
      ...this.inlineScripts().map((script) => DebuggerWorkspaceBinding.instance().updateLocations(script)),
      ...this.inlineStyles().map((style) => CSSWorkspaceBinding.instance().updateLocations(style))
    ]);
  }
  inlineStyles() {
    const target = NetworkProject.targetForUISourceCode(this.#uiSourceCode);
    const stylesheets = [];
    if (!target) {
      return stylesheets;
    }
    const cssModel = target.model(SDK13.CSSModel.CSSModel);
    if (cssModel) {
      for (const headerId of cssModel.getStyleSheetIdsForURL(this.#uiSourceCode.url())) {
        const header = cssModel.styleSheetHeaderForId(headerId);
        if (header) {
          stylesheets.push(header);
        }
      }
    }
    return stylesheets;
  }
  inlineScripts() {
    const target = NetworkProject.targetForUISourceCode(this.#uiSourceCode);
    if (!target) {
      return [];
    }
    const debuggerModel = target.model(SDK13.DebuggerModel.DebuggerModel);
    if (!debuggerModel) {
      return [];
    }
    return debuggerModel.scripts().filter((script) => script.embedderName() === this.#uiSourceCode.url());
  }
  async styleSheetChanged(stylesheet, edit) {
    this.#edits.push({ stylesheet, edit });
    if (this.#edits.length > 1) {
      return;
    }
    const content = await this.#uiSourceCode.requestContentData();
    if (!TextUtils9.ContentData.ContentData.isError(content)) {
      await this.innerStyleSheetChanged(content.text);
    }
    this.#edits = [];
  }
  async innerStyleSheetChanged(content) {
    const scripts = this.inlineScripts();
    const styles = this.inlineStyles();
    let text = new TextUtils9.Text.Text(content);
    for (const data of this.#edits) {
      const edit = data.edit;
      if (!edit) {
        continue;
      }
      const stylesheet = data.stylesheet;
      const startLocation = styleSheetRangeMap.get(stylesheet) ?? computeStyleSheetRange(stylesheet);
      const oldRange = edit.oldRange.relativeFrom(startLocation.startLine, startLocation.startColumn);
      const newRange = edit.newRange.relativeFrom(startLocation.startLine, startLocation.startColumn);
      text = new TextUtils9.Text.Text(text.replaceRange(oldRange, edit.newText));
      const updatePromises = [];
      for (const script of scripts) {
        const range = scriptRangeMap.get(script) ?? computeScriptRange(script);
        if (!range.follows(oldRange)) {
          continue;
        }
        scriptRangeMap.set(script, range.rebaseAfterTextEdit(oldRange, newRange));
        updatePromises.push(DebuggerWorkspaceBinding.instance().updateLocations(script));
      }
      for (const style of styles) {
        const range = styleSheetRangeMap.get(style) ?? computeStyleSheetRange(style);
        if (!range.follows(oldRange)) {
          continue;
        }
        styleSheetRangeMap.set(style, range.rebaseAfterTextEdit(oldRange, newRange));
        updatePromises.push(CSSWorkspaceBinding.instance().updateLocations(style));
      }
      await Promise.all(updatePromises);
    }
    this.#uiSourceCode.addRevision(text.value());
  }
  addResource(resource) {
    this.resources.add(resource);
    if (resource.frameId) {
      NetworkProject.addFrameAttribution(this.#uiSourceCode, resource.frameId);
    }
  }
  removeResource(resource) {
    this.resources.delete(resource);
    if (resource.frameId) {
      NetworkProject.removeFrameAttribution(this.#uiSourceCode, resource.frameId);
    }
  }
  dispose() {
    this.#project.removeUISourceCode(this.#uiSourceCode.url());
    void Promise.all([
      ...this.inlineScripts().map((script) => DebuggerWorkspaceBinding.instance().updateLocations(script)),
      ...this.inlineStyles().map((style) => CSSWorkspaceBinding.instance().updateLocations(style))
    ]);
  }
  firstResource() {
    console.assert(this.resources.size > 0);
    return this.resources.values().next().value;
  }
  contentURL() {
    return this.firstResource().contentURL();
  }
  contentType() {
    return this.firstResource().contentType();
  }
  requestContentData() {
    return this.firstResource().requestContentData();
  }
  searchInContent(query, caseSensitive, isRegex) {
    return this.firstResource().searchInContent(query, caseSensitive, isRegex);
  }
};

// gen/third_party/devtools-frontend/src/front_end/models/bindings/TempFile.js
var TempFile_exports = {};
__export(TempFile_exports, {
  TempFile: () => TempFile
});
import * as Common14 from "./../../core/common/common.js";
var TempFile = class {
  #lastBlob;
  constructor() {
    this.#lastBlob = null;
  }
  write(pieces) {
    if (this.#lastBlob) {
      pieces.unshift(this.#lastBlob);
    }
    this.#lastBlob = new Blob(pieces, { type: "text/plain" });
  }
  read() {
    return this.readRange();
  }
  size() {
    return this.#lastBlob ? this.#lastBlob.size : 0;
  }
  async readRange(startOffset, endOffset) {
    if (!this.#lastBlob) {
      Common14.Console.Console.instance().error("Attempt to read a temp file that was never written");
      return "";
    }
    const blob = typeof startOffset === "number" || typeof endOffset === "number" ? this.#lastBlob.slice(startOffset, endOffset) : this.#lastBlob;
    const reader = new FileReader();
    try {
      await new Promise((resolve, reject) => {
        reader.onloadend = resolve;
        reader.onerror = reject;
        reader.readAsText(blob);
      });
    } catch (error) {
      Common14.Console.Console.instance().error("Failed to read from temp file: " + error.message);
    }
    return reader.result;
  }
  async copyToOutputStream(outputStream, progress) {
    if (!this.#lastBlob) {
      void outputStream.close();
      return null;
    }
    const reader = new ChunkedFileReader(this.#lastBlob, 10 * 1e3 * 1e3, progress);
    return await reader.read(outputStream).then((success) => success ? null : reader.error());
  }
  remove() {
    this.#lastBlob = null;
  }
};
export {
  CSSWorkspaceBinding_exports as CSSWorkspaceBinding,
  CompilerScriptMapping_exports as CompilerScriptMapping,
  ContentProviderBasedProject_exports as ContentProviderBasedProject,
  DebuggerLanguagePlugins_exports as DebuggerLanguagePlugins,
  DebuggerWorkspaceBinding_exports as DebuggerWorkspaceBinding,
  DefaultScriptMapping_exports as DefaultScriptMapping,
  FileUtils_exports as FileUtils,
  LiveLocation_exports as LiveLocation,
  NetworkProject_exports as NetworkProject,
  PresentationConsoleMessageHelper_exports as PresentationConsoleMessageHelper,
  ResourceMapping_exports as ResourceMapping,
  ResourceScriptMapping_exports as ResourceScriptMapping,
  ResourceUtils_exports as ResourceUtils,
  SASSSourceMapping_exports as SASSSourceMapping,
  StylesSourceMapping_exports as StylesSourceMapping,
  TempFile_exports as TempFile
};
//# sourceMappingURL=bindings.js.map
