"use strict";
import * as MarkdownView from "../../../ui/components/markdown_view/markdown_view.js";
export class MarkdownRendererWithCodeBlock extends MarkdownView.MarkdownView.MarkdownInsightRenderer {
  templateForToken(token) {
    if (token.type === "code") {
      const lines = token.text.split("\n");
      if (lines[0]?.trim() === "css") {
        token.lang = "css";
        token.text = lines.slice(1).join("\n");
      }
    }
    return super.templateForToken(token);
  }
}
//# sourceMappingURL=MarkdownRendererWithCodeBlock.js.map
