"use strict";
import * as Common from "../../core/common/common.js";
import * as UI from "../../ui/legacy/legacy.js";
import { Events } from "./ComputedStyleModel.js";
export class ElementsSidebarPane extends UI.Widget.VBox {
  computedStyleModelInternal;
  updateThrottler;
  updateWhenVisible;
  constructor(computedStyleModel, delegatesFocus) {
    super({ useShadowDom: true, delegatesFocus });
    this.element.classList.add("flex-none");
    this.computedStyleModelInternal = computedStyleModel;
    this.computedStyleModelInternal.addEventListener(Events.CSS_MODEL_CHANGED, this.onCSSModelChanged, this);
    this.computedStyleModelInternal.addEventListener(Events.COMPUTED_STYLE_CHANGED, this.onComputedStyleChanged, this);
    this.updateThrottler = new Common.Throttler.Throttler(100);
    this.updateWhenVisible = false;
  }
  node() {
    return this.computedStyleModelInternal.node();
  }
  cssModel() {
    return this.computedStyleModelInternal.cssModel();
  }
  computedStyleModel() {
    return this.computedStyleModelInternal;
  }
  async doUpdate() {
    return;
  }
  update() {
    this.updateWhenVisible = !this.isShowing();
    if (this.updateWhenVisible) {
      return;
    }
    void this.updateThrottler.schedule(innerUpdate.bind(this));
    function innerUpdate() {
      return this.isShowing() ? this.doUpdate() : Promise.resolve();
    }
  }
  wasShown() {
    super.wasShown();
    if (this.updateWhenVisible) {
      this.update();
    }
  }
  onCSSModelChanged(_event) {
  }
  onComputedStyleChanged() {
  }
}
//# sourceMappingURL=ElementsSidebarPane.js.map
