"use strict";
import * as i18n from "../../core/i18n/i18n.js";
import * as Buttons from "../../ui/components/buttons/buttons.js";
import * as UI from "../../ui/legacy/legacy.js";
import { Directives, html, render } from "../../ui/lit/lit.js";
import * as VisualLogging from "../../ui/visual_logging/visual_logging.js";
import dialogStyles from "./dialog.css.js";
const UIStrings = {
  /**
   * @description Text in Add Source Map URLDialog of the Sources panel
   */
  sourceMapUrl: "Source map URL: ",
  /**
   * @description Text in Add Debug Info URL Dialog of the Sources panel
   */
  debugInfoUrl: "DWARF symbols URL: ",
  /**
   * @description Text to add something
   */
  add: "Add"
};
const str_ = i18n.i18n.registerUIStrings("panels/sources/AddSourceMapURLDialog.ts", UIStrings);
const i18nString = i18n.i18n.getLocalizedString.bind(void 0, str_);
const { ref } = Directives;
export const DEFAULT_VIEW = (input, output, target) => {
  render(
    html`
    <style>${dialogStyles}</style>
    <label>${input.label}</label>
    <input class="harmony-input add-source-map" spellcheck="false" type="text"
        jslog=${VisualLogging.textField("url").track({ keydown: "Enter", change: true })}
        @keydown=${input.onKeyDown} ${ref((e) => {
      output.input = e;
    })}>
    <devtools-button @click=${input.apply} .jslogContext=${"add"}
        .variant=${Buttons.Button.Variant.OUTLINED}>${i18nString(UIStrings.add)}</devtools-button>`,
    target
  );
};
export class AddDebugInfoURLDialog extends UI.Widget.HBox {
  input;
  dialog;
  callback;
  constructor(label, jslogContext, callback, view = DEFAULT_VIEW) {
    super({ useShadowDom: true });
    const viewInput = {
      label,
      onKeyDown: this.onKeyDown.bind(this),
      apply: this.apply.bind(this)
    };
    const that = this;
    const viewOutput = {
      set input(input) {
        that.input = input;
      }
    };
    view(viewInput, viewOutput, this.contentElement);
    this.dialog = new UI.Dialog.Dialog(jslogContext);
    this.dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.MEASURE_CONTENT);
    this.dialog.setDefaultFocusedElement(this.input);
    this.callback = callback;
  }
  static createAddSourceMapURLDialog(callback) {
    return new AddDebugInfoURLDialog(i18nString(UIStrings.sourceMapUrl), "add-source-map-url", callback);
  }
  static createAddDWARFSymbolsURLDialog(callback) {
    return new AddDebugInfoURLDialog(i18nString(UIStrings.debugInfoUrl), "add-debug-info-url", callback);
  }
  show() {
    super.show(this.dialog.contentElement);
    this.dialog.show();
  }
  done(value) {
    this.dialog.hide();
    this.callback(value);
  }
  apply() {
    this.done(this.input.value);
  }
  onKeyDown(event) {
    if (event.key === "Enter") {
      event.consume(true);
      this.apply();
    }
  }
}
//# sourceMappingURL=AddSourceMapURLDialog.js.map
